#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#ifndef CMARK_MODULE_H
#define CMARK_MODULE_H

#ifdef __cplusplus
extern "C" {
#endif

#define CMARKEXTENSIONS_STATIC_DEFINE

#include "cmark-gfm.h"
#include "cmark-gfm-extension_api.h"
#include "cmark-gfm-core-extensions.h"

#ifdef __cplusplus
}
#endif

#endif


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // char *()(char const *, size_t, int)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 76), // char const *
/*  2 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  3 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // char *()(cmark_node *, int, cmark_llist *)
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 79), // cmark_node *
/*  7 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 77), // cmark_llist *
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // char const *()(void)
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // cmark_llist *()(cmark_mem *, cmark_llist *, void *)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 78), // cmark_mem *
/* 14 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 15 */ _CFFI_OP(_CFFI_OP_POINTER, 86), // void *
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // cmark_llist *()(cmark_parser *)
/* 18 */ _CFFI_OP(_CFFI_OP_POINTER, 81), // cmark_parser *
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // cmark_node *()(char const *, size_t, int)
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 22 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 23 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // cmark_node *()(cmark_parser *)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 18),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // cmark_node_type()(cmark_node *)
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // cmark_parser *()(int)
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 39), // cmark_syntax_extension *()(char const *)
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // int()(cmark_parser *, cmark_syntax_extension *)
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 18),
/* 39 */ _CFFI_OP(_CFFI_OP_POINTER, 82), // cmark_syntax_extension *
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // void *()(size_t, size_t)
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // void *()(void *, size_t)
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 47 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(cmark_mem *, cmark_llist *)
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(cmark_mem *, cmark_llist *, void(*)(cmark_mem *, void *))
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 56 */ _CFFI_OP(_CFFI_OP_POINTER, 58), // void(*)(cmark_mem *, void *)
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(cmark_mem *, void *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(cmark_parser *)
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 18),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(cmark_parser *, char const *, size_t)
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 18),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 68 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(void *)
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION, 86), // void()(void)
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_POINTER, 76), // char *
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 77 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // cmark_llist
/* 78 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // cmark_mem
/* 79 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // cmark_node
/* 80 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // cmark_node_type
/* 81 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // cmark_parser
/* 82 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // cmark_syntax_extension
/* 83 */ _CFFI_OP(_CFFI_OP_POINTER, 41), // void *(*)(size_t, size_t)
/* 84 */ _CFFI_OP(_CFFI_OP_POINTER, 45), // void *(*)(void *, size_t)
/* 85 */ _CFFI_OP(_CFFI_OP_POINTER, 70), // void(*)(void *)
/* 86 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_CMARK_NODE_NONE(unsigned long long *o)
{
  int n = (CMARK_NODE_NONE) <= 0;
  *o = (unsigned long long)((CMARK_NODE_NONE) | 0);  /* check that CMARK_NODE_NONE is an integer */
  return n;
}

static cmark_syntax_extension * _cffi_d_cmark_find_syntax_extension(char const * x0)
{
  return cmark_find_syntax_extension(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_find_syntax_extension(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_syntax_extension * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_find_syntax_extension(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(39));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_find_syntax_extension _cffi_d_cmark_find_syntax_extension
#endif

static void _cffi_d_cmark_gfm_core_extensions_ensure_registered(void)
{
  cmark_gfm_core_extensions_ensure_registered();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_gfm_core_extensions_ensure_registered(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cmark_gfm_core_extensions_ensure_registered(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cmark_gfm_core_extensions_ensure_registered _cffi_d_cmark_gfm_core_extensions_ensure_registered
#endif

static cmark_llist * _cffi_d_cmark_llist_append(cmark_mem * x0, cmark_llist * x1, void * x2)
{
  return cmark_llist_append(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_llist_append(PyObject *self, PyObject *args)
{
  cmark_mem * x0;
  cmark_llist * x1;
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_llist * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_llist_append", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_mem *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (cmark_llist *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_llist_append(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_llist_append _cffi_d_cmark_llist_append
#endif

static void _cffi_d_cmark_llist_free(cmark_mem * x0, cmark_llist * x1)
{
  cmark_llist_free(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_llist_free(PyObject *self, PyObject *args)
{
  cmark_mem * x0;
  cmark_llist * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "cmark_llist_free", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_mem *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (cmark_llist *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cmark_llist_free(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cmark_llist_free _cffi_d_cmark_llist_free
#endif

static void _cffi_d_cmark_llist_free_full(cmark_mem * x0, cmark_llist * x1, void(* x2)(cmark_mem *, void *))
{
  cmark_llist_free_full(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_llist_free_full(PyObject *self, PyObject *args)
{
  cmark_mem * x0;
  cmark_llist * x1;
  void(* x2)(cmark_mem *, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_llist_free_full", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_mem *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (cmark_llist *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (void(*)(cmark_mem *, void *))_cffi_to_c_pointer(arg2, _cffi_type(56));
  if (x2 == (void(*)(cmark_mem *, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cmark_llist_free_full(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cmark_llist_free_full _cffi_d_cmark_llist_free_full
#endif

static char * _cffi_d_cmark_markdown_to_html(char const * x0, size_t x1, int x2)
{
  return cmark_markdown_to_html(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_markdown_to_html(PyObject *self, PyObject *args)
{
  char const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_markdown_to_html", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_markdown_to_html(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_markdown_to_html _cffi_d_cmark_markdown_to_html
#endif

static cmark_node_type _cffi_d_cmark_node_get_type(cmark_node * x0)
{
  return cmark_node_get_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_node_get_type(PyObject *self, PyObject *arg0)
{
  cmark_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_node_type result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_node_get_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(80));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_node_get_type _cffi_d_cmark_node_get_type
#endif

static cmark_node * _cffi_d_cmark_parse_document(char const * x0, size_t x1, int x2)
{
  return cmark_parse_document(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parse_document(PyObject *self, PyObject *args)
{
  char const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_node * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_parse_document", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_parse_document(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(6));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_parse_document _cffi_d_cmark_parse_document
#endif

static int _cffi_d_cmark_parser_attach_syntax_extension(cmark_parser * x0, cmark_syntax_extension * x1)
{
  return cmark_parser_attach_syntax_extension(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_attach_syntax_extension(PyObject *self, PyObject *args)
{
  cmark_parser * x0;
  cmark_syntax_extension * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "cmark_parser_attach_syntax_extension", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_parser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (cmark_syntax_extension *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_parser_attach_syntax_extension(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_parser_attach_syntax_extension _cffi_d_cmark_parser_attach_syntax_extension
#endif

static void _cffi_d_cmark_parser_feed(cmark_parser * x0, char const * x1, size_t x2)
{
  cmark_parser_feed(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_feed(PyObject *self, PyObject *args)
{
  cmark_parser * x0;
  char const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_parser_feed", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_parser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cmark_parser_feed(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cmark_parser_feed _cffi_d_cmark_parser_feed
#endif

static cmark_node * _cffi_d_cmark_parser_finish(cmark_parser * x0)
{
  return cmark_parser_finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_finish(PyObject *self, PyObject *arg0)
{
  cmark_parser * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_node * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_parser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_parser_finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(6));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_parser_finish _cffi_d_cmark_parser_finish
#endif

static void _cffi_d_cmark_parser_free(cmark_parser * x0)
{
  cmark_parser_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_free(PyObject *self, PyObject *arg0)
{
  cmark_parser * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_parser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cmark_parser_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cmark_parser_free _cffi_d_cmark_parser_free
#endif

static cmark_llist * _cffi_d_cmark_parser_get_syntax_extensions(cmark_parser * x0)
{
  return cmark_parser_get_syntax_extensions(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_get_syntax_extensions(PyObject *self, PyObject *arg0)
{
  cmark_parser * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cmark_llist * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(18), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_parser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(18), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_parser_get_syntax_extensions(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_parser_get_syntax_extensions _cffi_d_cmark_parser_get_syntax_extensions
#endif

static cmark_parser * _cffi_d_cmark_parser_new(int x0)
{
  return cmark_parser_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_parser_new(PyObject *self, PyObject *arg0)
{
  int x0;
  cmark_parser * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_parser_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(18));
  return pyresult;
}
#else
#  define _cffi_f_cmark_parser_new _cffi_d_cmark_parser_new
#endif

static char * _cffi_d_cmark_render_html(cmark_node * x0, int x1, cmark_llist * x2)
{
  return cmark_render_html(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_render_html(PyObject *self, PyObject *args)
{
  cmark_node * x0;
  int x1;
  cmark_llist * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cmark_render_html", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (cmark_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (cmark_llist *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_render_html(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cmark_render_html _cffi_d_cmark_render_html
#endif

static char const * _cffi_d_cmark_version_string(void)
{
  return cmark_version_string();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cmark_version_string(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cmark_version_string(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_cmark_version_string _cffi_d_cmark_version_string
#endif

static int _cffi_const_CMARK_OPT_DEFAULT(unsigned long long *o)
{
  int n = (CMARK_OPT_DEFAULT) <= 0;
  *o = (unsigned long long)((CMARK_OPT_DEFAULT) | 0);  /* check that CMARK_OPT_DEFAULT is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_CMARK_OPT_FOOTNOTES(unsigned long long *o)
{
  int n = (CMARK_OPT_FOOTNOTES) <= 0;
  *o = (unsigned long long)((CMARK_OPT_FOOTNOTES) | 0);  /* check that CMARK_OPT_FOOTNOTES is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_GITHUB_PRE_LANG(unsigned long long *o)
{
  int n = (CMARK_OPT_GITHUB_PRE_LANG) <= 0;
  *o = (unsigned long long)((CMARK_OPT_GITHUB_PRE_LANG) | 0);  /* check that CMARK_OPT_GITHUB_PRE_LANG is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_HARDBREAKS(unsigned long long *o)
{
  int n = (CMARK_OPT_HARDBREAKS) <= 0;
  *o = (unsigned long long)((CMARK_OPT_HARDBREAKS) | 0);  /* check that CMARK_OPT_HARDBREAKS is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_LIBERAL_HTML_TAG(unsigned long long *o)
{
  int n = (CMARK_OPT_LIBERAL_HTML_TAG) <= 0;
  *o = (unsigned long long)((CMARK_OPT_LIBERAL_HTML_TAG) | 0);  /* check that CMARK_OPT_LIBERAL_HTML_TAG is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_NOBREAKS(unsigned long long *o)
{
  int n = (CMARK_OPT_NOBREAKS) <= 0;
  *o = (unsigned long long)((CMARK_OPT_NOBREAKS) | 0);  /* check that CMARK_OPT_NOBREAKS is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_NORMALIZE(unsigned long long *o)
{
  int n = (CMARK_OPT_NORMALIZE) <= 0;
  *o = (unsigned long long)((CMARK_OPT_NORMALIZE) | 0);  /* check that CMARK_OPT_NORMALIZE is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_SMART(unsigned long long *o)
{
  int n = (CMARK_OPT_SMART) <= 0;
  *o = (unsigned long long)((CMARK_OPT_SMART) | 0);  /* check that CMARK_OPT_SMART is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_SOURCEPOS(unsigned long long *o)
{
  int n = (CMARK_OPT_SOURCEPOS) <= 0;
  *o = (unsigned long long)((CMARK_OPT_SOURCEPOS) | 0);  /* check that CMARK_OPT_SOURCEPOS is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE(unsigned long long *o)
{
  int n = (CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE) <= 0;
  *o = (unsigned long long)((CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE) | 0);  /* check that CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES(unsigned long long *o)
{
  int n = (CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES) <= 0;
  *o = (unsigned long long)((CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES) | 0);  /* check that CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_UNSAFE(unsigned long long *o)
{
  int n = (CMARK_OPT_UNSAFE) <= 0;
  *o = (unsigned long long)((CMARK_OPT_UNSAFE) | 0);  /* check that CMARK_OPT_UNSAFE is an integer */
  return n;
}

static int _cffi_const_CMARK_OPT_VALIDATE_UTF8(unsigned long long *o)
{
  int n = (CMARK_OPT_VALIDATE_UTF8) <= 0;
  *o = (unsigned long long)((CMARK_OPT_VALIDATE_UTF8) | 0);  /* check that CMARK_OPT_VALIDATE_UTF8 is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__cmark_llist(cmark_llist *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { cmark_llist * *tmp = &p->next; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align__cmark_llist { char x; cmark_llist y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__cmark_mem(cmark_mem *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void *(* *tmp)(size_t, size_t) = &p->calloc; (void)tmp; }
  { void *(* *tmp)(void *, size_t) = &p->realloc; (void)tmp; }
  { void(* *tmp)(void *) = &p->free; (void)tmp; }
}
struct _cffi_align__cmark_mem { char x; cmark_mem y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "CMARK_NODE_NONE", (void *)_cffi_const_CMARK_NODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CMARK_OPT_DEFAULT", (void *)_cffi_const_CMARK_OPT_DEFAULT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_FOOTNOTES", (void *)_cffi_const_CMARK_OPT_FOOTNOTES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_GITHUB_PRE_LANG", (void *)_cffi_const_CMARK_OPT_GITHUB_PRE_LANG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_HARDBREAKS", (void *)_cffi_const_CMARK_OPT_HARDBREAKS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_LIBERAL_HTML_TAG", (void *)_cffi_const_CMARK_OPT_LIBERAL_HTML_TAG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_NOBREAKS", (void *)_cffi_const_CMARK_OPT_NOBREAKS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_NORMALIZE", (void *)_cffi_const_CMARK_OPT_NORMALIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_SMART", (void *)_cffi_const_CMARK_OPT_SMART, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_SOURCEPOS", (void *)_cffi_const_CMARK_OPT_SOURCEPOS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE", (void *)_cffi_const_CMARK_OPT_STRIKETHROUGH_DOUBLE_TILDE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES", (void *)_cffi_const_CMARK_OPT_TABLE_PREFER_STYLE_ATTRIBUTES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_UNSAFE", (void *)_cffi_const_CMARK_OPT_UNSAFE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CMARK_OPT_VALIDATE_UTF8", (void *)_cffi_const_CMARK_OPT_VALIDATE_UTF8, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "cmark_find_syntax_extension", (void *)_cffi_f_cmark_find_syntax_extension, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 34), (void *)_cffi_d_cmark_find_syntax_extension },
  { "cmark_gfm_core_extensions_ensure_registered", (void *)_cffi_f_cmark_gfm_core_extensions_ensure_registered, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 73), (void *)_cffi_d_cmark_gfm_core_extensions_ensure_registered },
  { "cmark_llist_append", (void *)_cffi_f_cmark_llist_append, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_cmark_llist_append },
  { "cmark_llist_free", (void *)_cffi_f_cmark_llist_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_cmark_llist_free },
  { "cmark_llist_free_full", (void *)_cffi_f_cmark_llist_free_full, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 53), (void *)_cffi_d_cmark_llist_free_full },
  { "cmark_markdown_to_html", (void *)_cffi_f_cmark_markdown_to_html, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_cmark_markdown_to_html },
  { "cmark_node_get_type", (void *)_cffi_f_cmark_node_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_cmark_node_get_type },
  { "cmark_parse_document", (void *)_cffi_f_cmark_parse_document, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 20), (void *)_cffi_d_cmark_parse_document },
  { "cmark_parser_attach_syntax_extension", (void *)_cffi_f_cmark_parser_attach_syntax_extension, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 37), (void *)_cffi_d_cmark_parser_attach_syntax_extension },
  { "cmark_parser_feed", (void *)_cffi_f_cmark_parser_feed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_cmark_parser_feed },
  { "cmark_parser_finish", (void *)_cffi_f_cmark_parser_finish, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 25), (void *)_cffi_d_cmark_parser_finish },
  { "cmark_parser_free", (void *)_cffi_f_cmark_parser_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 62), (void *)_cffi_d_cmark_parser_free },
  { "cmark_parser_get_syntax_extensions", (void *)_cffi_f_cmark_parser_get_syntax_extensions, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 17), (void *)_cffi_d_cmark_parser_get_syntax_extensions },
  { "cmark_parser_new", (void *)_cffi_f_cmark_parser_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 31), (void *)_cffi_d_cmark_parser_new },
  { "cmark_render_html", (void *)_cffi_f_cmark_render_html, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 5), (void *)_cffi_d_cmark_render_html },
  { "cmark_version_string", (void *)_cffi_f_cmark_version_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 10), (void *)_cffi_d_cmark_version_string },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "next", offsetof(cmark_llist, next),
            sizeof(((cmark_llist *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "data", offsetof(cmark_llist, data),
            sizeof(((cmark_llist *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "calloc", offsetof(cmark_mem, calloc),
              sizeof(((cmark_mem *)0)->calloc),
              _CFFI_OP(_CFFI_OP_NOOP, 83) },
  { "realloc", offsetof(cmark_mem, realloc),
               sizeof(((cmark_mem *)0)->realloc),
               _CFFI_OP(_CFFI_OP_NOOP, 84) },
  { "free", offsetof(cmark_mem, free),
            sizeof(((cmark_mem *)0)->free),
            _CFFI_OP(_CFFI_OP_NOOP, 85) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "_cmark_llist", 77, _CFFI_F_CHECK_FIELDS,
    sizeof(cmark_llist), offsetof(struct _cffi_align__cmark_llist, y), 0, 2 },
  { "cmark_mem", 78, _CFFI_F_CHECK_FIELDS,
    sizeof(cmark_mem), offsetof(struct _cffi_align__cmark_mem, y), 2, 3 },
  { "cmark_node", 79, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "cmark_parser", 81, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "cmark_syntax_extension", 82, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$cmark_node_type", 80, _cffi_prim_int(sizeof(cmark_node_type), ((cmark_node_type)-1) <= 0),
    "CMARK_NODE_NONE" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "cmark_free_func", 56 },
  { "cmark_llist", 77 },
  { "cmark_mem", 78 },
  { "cmark_node", 79 },
  { "cmark_node_type", 80 },
  { "cmark_parser", 81 },
  { "cmark_syntax_extension", 82 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  30,  /* num_globals */
  5,  /* num_struct_unions */
  1,  /* num_enums */
  7,  /* num_typenames */
  NULL,  /* no includes */
  87,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cmark(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cmark(void) { return NULL; }
#  else
     init_cmark(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cmark(void)
{
  return _cffi_init("cmarkgfm._cmark", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cmark(void)
{
  _cffi_init("cmarkgfm._cmark", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
