#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


        #include <vips/vips.h>
        
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 401), // VipsImage * *()(GValue const *, int *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 395), // GValue const *
/*  2 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // int *
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // VipsImage *()(VipsImage *)
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 402), // VipsImage *
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // VipsImage *()(char const *)
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 420), // char const *
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // VipsImage *()(int, int, double const *, int)
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 12 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 303), // double const *
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // VipsImage *()(void const *, size_t, int, int, int, int)
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 436), // void const *
/* 18 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 19 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 22 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 403), // VipsInterpolate *()(char const *)
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // VipsOperation *()(VipsOperation *)
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 408), // VipsOperation *
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // VipsOperation *()(char const *)
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION, 155), // VipsRegion *()(VipsImage *)
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 83), // VipsSource *()(char const *)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 83), // VipsSource *()(int)
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 83), // VipsSource *()(void const *, size_t)
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION, 412), // VipsSourceCustom *()(void)
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // VipsTarget *()(char const *)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // VipsTarget *()(int)
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // VipsTarget *()(void)
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 415), // VipsTargetCustom *()(void)
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 417), // char * *()(VipsImage *)
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 417), // char * *()(void)
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 418), // char *()(char const *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(GParamSpec *)
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 389), // GParamSpec *
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(GValue *)
/* 70 */ _CFFI_OP(_CFFI_OP_POINTER, 395), // GValue *
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(GValue const *, size_t *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 74 */ _CFFI_OP(_CFFI_OP_POINTER, 18), // size_t *
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(VipsConnection *)
/* 77 */ _CFFI_OP(_CFFI_OP_POINTER, 400), // VipsConnection *
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(VipsObject *)
/* 80 */ _CFFI_OP(_CFFI_OP_POINTER, 405), // VipsObject *
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(VipsSource *)
/* 83 */ _CFFI_OP(_CFFI_OP_POINTER, 411), // VipsSource *
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(char const *)
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(uint64_t)
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(uint64_t, int)
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(void const *, size_t)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 97 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // char const *()(void)
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 421), // double *()(GValue const *, int *)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION, 303), // double()(GValue *)
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // int *()(GValue const *, int *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(GValue *)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(GValue const *)
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsImage *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsImage *, VipsImage *)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsImage *, char const *)
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsImage const *, char const *, GValue *)
/* 130 */ _CFFI_OP(_CFFI_OP_POINTER, 402), // VipsImage const *
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsObject *, char const * * *, int * *, int *)
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 136 */ _CFFI_OP(_CFFI_OP_POINTER, 419), // char const * * *
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // int * *
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsObject *, char const *)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsObject *, char const *, GParamSpec * *, VipsArgumentClass * *, VipsArgumentInstance * *)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 147 */ _CFFI_OP(_CFFI_OP_POINTER, 67), // GParamSpec * *
/* 148 */ _CFFI_OP(_CFFI_OP_POINTER, 244), // VipsArgumentClass * *
/* 149 */ _CFFI_OP(_CFFI_OP_POINTER, 245), // VipsArgumentInstance * *
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsOperation *)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsRegion *)
/* 155 */ _CFFI_OP(_CFFI_OP_POINTER, 410), // VipsRegion *
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(VipsTarget *, void *)
/* 158 */ _CFFI_OP(_CFFI_OP_POINTER, 414), // VipsTarget *
/* 159 */ _CFFI_OP(_CFFI_OP_POINTER, 436), // void *
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(char const *)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(char const *, int, void(*)(char const *, int, char const *, void *), void *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 167 */ _CFFI_OP(_CFFI_OP_POINTER, 359), // void(*)(char const *, int, char const *, void *)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(char const *, uint64_t, char const *)
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 172 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(int)
/* 176 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // int()(void)
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION, 182), // int64_t()(VipsSource *, int64_t, int, void *)
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 83),
/* 182 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 183 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 182), // int64_t()(VipsSource *, void *, int64_t, void *)
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 83),
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 189 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 182), // int64_t()(VipsTarget *, void *, int64_t, void *)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION, 427), // long()(GObject *, char const *, void(*)(void), void *, void(*)(void *, struct _GClosure *), int)
/* 199 */ _CFFI_OP(_CFFI_OP_POINTER, 388), // GObject *
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 201 */ _CFFI_OP(_CFFI_OP_POINTER, 378), // void(*)(void)
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 203 */ _CFFI_OP(_CFFI_OP_POINTER, 374), // void(*)(void *, struct _GClosure *)
/* 204 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // size_t()(void)
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(GValue *)
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(VipsImage const *, char const *)
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(char const *)
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(char const *, char const *)
/* 219 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(uint64_t)
/* 223 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // uint64_t()(void)
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 320), // unsigned int()(GValue *)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(GValue *)
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(GValue const *, size_t *)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(VipsImage *, size_t *)
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 244 */ _CFFI_OP(_CFFI_OP_POINTER, 397), // VipsArgumentClass *
/* 245 */ _CFFI_OP(_CFFI_OP_POINTER, 399), // VipsArgumentInstance *
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(VipsObject *, void *(*)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *), void *, void *)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 251 */ _CFFI_OP(_CFFI_OP_POINTER, 241), // void *(*)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *)
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(VipsRegion *, int, int, int, int, size_t *)
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 74),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(size_t)
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(uint64_t)
/* 267 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(uint64_t, void *)
/* 270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 271 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(uint64_t, void *, void *)
/* 274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 276 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 159), // void *()(uint64_t, void *, void *, void *)
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 281 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GObject *, char const *, GValue *)
/* 285 */ _CFFI_OP(_CFFI_OP_NOOP, 199),
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 287 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, char const *)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, double const *, int)
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 299 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, double)
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, int const *, int)
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 307 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // int const *
/* 308 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 309 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, int)
/* 311 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 312 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, uint64_t)
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, unsigned int)
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, void *)
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(GValue *, void *, size_t)
/* 327 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsImage *)
/* 332 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 333 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 334 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsImage *, char const *, GValue *)
/* 335 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 337 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsImage *, int)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 341 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 342 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 343 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsImage *, void *, void *)
/* 344 */ _CFFI_OP(_CFFI_OP_NOOP, 5),
/* 345 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsObject *)
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 80),
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(VipsTarget *, void *)
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 354 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 355 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(char const *, int)
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 357 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(char const *, int, char const *, void *)
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 362 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(int)
/* 366 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 367 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(size_t)
/* 369 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 370 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(void *)
/* 372 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 374 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(void *, struct _GClosure *)
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 376 */ _CFFI_OP(_CFFI_OP_POINTER, 428), // struct _GClosure *
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 436), // void()(void)
/* 379 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 380 */ _CFFI_OP(_CFFI_OP_POINTER, 381), // GData *
/* 381 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // GData
/* 382 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // GEnumClass
/* 383 */ _CFFI_OP(_CFFI_OP_POINTER, 384), // GEnumValue *
/* 384 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // GEnumValue
/* 385 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // GFlagsClass
/* 386 */ _CFFI_OP(_CFFI_OP_POINTER, 387), // GFlagsValue *
/* 387 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // GFlagsValue
/* 388 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // GObject
/* 389 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // GParamSpec
/* 390 */ _CFFI_OP(_CFFI_OP_POINTER, 391), // GTimer *
/* 391 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // GTimer
/* 392 */ _CFFI_OP(_CFFI_OP_POINTER, 393), // GTypeClass *
/* 393 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // GTypeClass
/* 394 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // GTypeInstance
/* 395 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // GValue
/* 396 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // VipsArgument
/* 397 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // VipsArgumentClass
/* 398 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // VipsArgumentFlags
/* 399 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // VipsArgumentInstance
/* 400 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // VipsConnection
/* 401 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // VipsImage * *
/* 402 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // VipsImage
/* 403 */ _CFFI_OP(_CFFI_OP_POINTER, 404), // VipsInterpolate *
/* 404 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // VipsInterpolate
/* 405 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // VipsObject
/* 406 */ _CFFI_OP(_CFFI_OP_POINTER, 407), // VipsObjectClass *
/* 407 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // VipsObjectClass
/* 408 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // VipsOperation
/* 409 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // VipsProgress
/* 410 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // VipsRegion
/* 411 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // VipsSource
/* 412 */ _CFFI_OP(_CFFI_OP_POINTER, 413), // VipsSourceCustom *
/* 413 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // VipsSourceCustom
/* 414 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // VipsTarget
/* 415 */ _CFFI_OP(_CFFI_OP_POINTER, 416), // VipsTargetCustom *
/* 416 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // VipsTargetCustom
/* 417 */ _CFFI_OP(_CFFI_OP_POINTER, 418), // char * *
/* 418 */ _CFFI_OP(_CFFI_OP_POINTER, 420), // char *
/* 419 */ _CFFI_OP(_CFFI_OP_POINTER, 8), // char const * *
/* 420 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 421 */ _CFFI_OP(_CFFI_OP_POINTER, 303), // double *
/* 422 */ _CFFI_OP(_CFFI_OP_POINTER, 157), // int(*)(VipsTarget *, void *)
/* 423 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 424 */ _CFFI_OP(_CFFI_OP_POINTER, 180), // int64_t(*)(VipsSource *, int64_t, int, void *)
/* 425 */ _CFFI_OP(_CFFI_OP_POINTER, 186), // int64_t(*)(VipsSource *, void *, int64_t, void *)
/* 426 */ _CFFI_OP(_CFFI_OP_POINTER, 192), // int64_t(*)(VipsTarget *, void *, int64_t, void *)
/* 427 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9), // long
/* 428 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct _GClosure
/* 429 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 430 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $1
/* 431 */ _CFFI_OP(_CFFI_OP_ARRAY, 430), // union $1[2]
/* 432 */ (_cffi_opcode_t)(2),
/* 433 */ _CFFI_OP(_CFFI_OP_POINTER, 273), // void *(*)(uint64_t, void *, void *)
/* 434 */ _CFFI_OP(_CFFI_OP_POINTER, 343), // void(*)(VipsImage *, void *, void *)
/* 435 */ _CFFI_OP(_CFFI_OP_POINTER, 351), // void(*)(VipsTarget *, void *)
/* 436 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_VIPS_ARGUMENT_NONE(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_NONE) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_NONE) | 0);  /* check that VIPS_ARGUMENT_NONE is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_REQUIRED(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_REQUIRED) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_REQUIRED) | 0);  /* check that VIPS_ARGUMENT_REQUIRED is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_CONSTRUCT(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_CONSTRUCT) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_CONSTRUCT) | 0);  /* check that VIPS_ARGUMENT_CONSTRUCT is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_SET_ONCE(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_SET_ONCE) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_SET_ONCE) | 0);  /* check that VIPS_ARGUMENT_SET_ONCE is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_SET_ALWAYS(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_SET_ALWAYS) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_SET_ALWAYS) | 0);  /* check that VIPS_ARGUMENT_SET_ALWAYS is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_INPUT(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_INPUT) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_INPUT) | 0);  /* check that VIPS_ARGUMENT_INPUT is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_OUTPUT(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_OUTPUT) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_OUTPUT) | 0);  /* check that VIPS_ARGUMENT_OUTPUT is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_DEPRECATED(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_DEPRECATED) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_DEPRECATED) | 0);  /* check that VIPS_ARGUMENT_DEPRECATED is an integer */
  return n;
}

static int _cffi_const_VIPS_ARGUMENT_MODIFY(unsigned long long *o)
{
  int n = (VIPS_ARGUMENT_MODIFY) <= 0;
  *o = (unsigned long long)((VIPS_ARGUMENT_MODIFY) | 0);  /* check that VIPS_ARGUMENT_MODIFY is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___log_handler_callback =
  { "_libvips._log_handler_callback", 0, 0, 0 };

static void _log_handler_callback(char const * a0, int a1, char const * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___log_handler_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy___marshal_end =
  { "_libvips._marshal_end", (int)sizeof(int), 0, 0 };

static int _marshal_end(VipsTarget * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(VipsTarget * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___marshal_end, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___marshal_finish =
  { "_libvips._marshal_finish", 0, 0, 0 };

static void _marshal_finish(VipsTarget * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(VipsTarget * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___marshal_finish, p);
}

static struct _cffi_externpy_s _cffi_externpy___marshal_image_progress =
  { "_libvips._marshal_image_progress", 0, 0, 0 };

static void _marshal_image_progress(VipsImage * a0, void * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(VipsImage * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___marshal_image_progress, p);
}

static struct _cffi_externpy_s _cffi_externpy___marshal_read =
  { "_libvips._marshal_read", (int)sizeof(int64_t), 0, 0 };

static int64_t _marshal_read(VipsSource * a0, void * a1, int64_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(VipsSource * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(int64_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___marshal_read, p);
  return *(int64_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___marshal_seek =
  { "_libvips._marshal_seek", (int)sizeof(int64_t), 0, 0 };

static int64_t _marshal_seek(VipsSource * a0, int64_t a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(VipsSource * *)(p + 0) = a0;
  *(int64_t *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___marshal_seek, p);
  return *(int64_t *)p;
}

static struct _cffi_externpy_s _cffi_externpy___marshal_write =
  { "_libvips._marshal_write", (int)sizeof(int64_t), 0, 0 };

static int64_t _marshal_write(VipsTarget * a0, void * a1, int64_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(VipsTarget * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(int64_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___marshal_write, p);
  return *(int64_t *)p;
}

static void _cffi_d_g_free(void * x0)
{
  g_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_free _cffi_d_g_free
#endif

static void _cffi_d_g_log_remove_handler(char const * x0, int x1)
{
  g_log_remove_handler(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_log_remove_handler(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_log_remove_handler", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_log_remove_handler(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_log_remove_handler _cffi_d_g_log_remove_handler
#endif

static int _cffi_d_g_log_set_handler(char const * x0, int x1, void(* x2)(char const *, int, char const *, void *), void * x3)
{
  return g_log_set_handler(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_log_set_handler(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  void(* x2)(char const *, int, char const *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "g_log_set_handler", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(char const *, int, char const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(167));
  if (x2 == (void(*)(char const *, int, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_log_set_handler(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_log_set_handler _cffi_d_g_log_set_handler
#endif

static void * _cffi_d_g_malloc(size_t x0)
{
  return g_malloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_malloc(PyObject *self, PyObject *arg0)
{
  size_t x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_malloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  return pyresult;
}
#else
#  define _cffi_f_g_malloc _cffi_d_g_malloc
#endif

static void _cffi_d_g_object_get_property(GObject * x0, char const * x1, GValue * x2)
{
  g_object_get_property(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_object_get_property(PyObject *self, PyObject *args)
{
  GObject * x0;
  char const * x1;
  GValue * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "g_object_get_property", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(199), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(199), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_object_get_property(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_object_get_property _cffi_d_g_object_get_property
#endif

static void * _cffi_d_g_object_new(uint64_t x0, void * x1)
{
  return g_object_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_object_new(PyObject *self, PyObject *args)
{
  uint64_t x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_object_new", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_object_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_object_new _cffi_d_g_object_new
#endif

static void _cffi_d_g_object_ref(void * x0)
{
  g_object_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_object_ref(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_object_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_object_ref _cffi_d_g_object_ref
#endif

static void _cffi_d_g_object_set_property(GObject * x0, char const * x1, GValue * x2)
{
  g_object_set_property(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_object_set_property(PyObject *self, PyObject *args)
{
  GObject * x0;
  char const * x1;
  GValue * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "g_object_set_property", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(199), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(199), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_object_set_property(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_object_set_property _cffi_d_g_object_set_property
#endif

static void _cffi_d_g_object_unref(void * x0)
{
  g_object_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_object_unref(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_object_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_object_unref _cffi_d_g_object_unref
#endif

static char const * _cffi_d_g_param_spec_get_blurb(GParamSpec * x0)
{
  return g_param_spec_get_blurb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_param_spec_get_blurb(PyObject *self, PyObject *arg0)
{
  GParamSpec * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GParamSpec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_param_spec_get_blurb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_param_spec_get_blurb _cffi_d_g_param_spec_get_blurb
#endif

static long _cffi_d_g_signal_connect_data(GObject * x0, char const * x1, void(* x2)(void), void * x3, void(* x4)(void *, struct _GClosure *), int x5)
{
  return g_signal_connect_data(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_signal_connect_data(PyObject *self, PyObject *args)
{
  GObject * x0;
  char const * x1;
  void(* x2)(void);
  void * x3;
  void(* x4)(void *, struct _GClosure *);
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "g_signal_connect_data", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(199), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(199), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (void(*)(void))_cffi_to_c_pointer(arg2, _cffi_type(201));
  if (x2 == (void(*)(void))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(void *, struct _GClosure *))_cffi_to_c_pointer(arg4, _cffi_type(203));
  if (x4 == (void(*)(void *, struct _GClosure *))NULL && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_signal_connect_data(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_signal_connect_data _cffi_d_g_signal_connect_data
#endif

static void * _cffi_d_g_type_class_ref(uint64_t x0)
{
  return g_type_class_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_type_class_ref(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_type_class_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  return pyresult;
}
#else
#  define _cffi_f_g_type_class_ref _cffi_d_g_type_class_ref
#endif

static uint64_t _cffi_d_g_type_from_name(char const * x0)
{
  return g_type_from_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_type_from_name(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_type_from_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_type_from_name _cffi_d_g_type_from_name
#endif

static uint64_t _cffi_d_g_type_fundamental(uint64_t x0)
{
  return g_type_fundamental(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_type_fundamental(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  uint64_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_type_fundamental(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_g_type_fundamental _cffi_d_g_type_fundamental
#endif

static char const * _cffi_d_g_type_name(uint64_t x0)
{
  return g_type_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_type_name(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_type_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_g_type_name _cffi_d_g_type_name
#endif

static int _cffi_d_g_value_get_boolean(GValue const * x0)
{
  return g_value_get_boolean(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_boolean(PyObject *self, PyObject *arg0)
{
  GValue const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_boolean(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_boolean _cffi_d_g_value_get_boolean
#endif

static double _cffi_d_g_value_get_double(GValue * x0)
{
  return g_value_get_double(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_double(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_double(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_double _cffi_d_g_value_get_double
#endif

static int _cffi_d_g_value_get_enum(GValue * x0)
{
  return g_value_get_enum(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_enum(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_enum(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_enum _cffi_d_g_value_get_enum
#endif

static unsigned int _cffi_d_g_value_get_flags(GValue * x0)
{
  return g_value_get_flags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_flags(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_flags _cffi_d_g_value_get_flags
#endif

static int _cffi_d_g_value_get_int(GValue * x0)
{
  return g_value_get_int(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_int(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_int(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_int _cffi_d_g_value_get_int
#endif

static void * _cffi_d_g_value_get_object(GValue * x0)
{
  return g_value_get_object(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_object(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_object(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_object _cffi_d_g_value_get_object
#endif

static char const * _cffi_d_g_value_get_string(GValue * x0)
{
  return g_value_get_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_string(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_string _cffi_d_g_value_get_string
#endif

static uint64_t _cffi_d_g_value_get_uint64(GValue * x0)
{
  return g_value_get_uint64(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_get_uint64(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = g_value_get_uint64(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_g_value_get_uint64 _cffi_d_g_value_get_uint64
#endif

static void _cffi_d_g_value_init(GValue * x0, uint64_t x1)
{
  g_value_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_init(PyObject *self, PyObject *args)
{
  GValue * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_init _cffi_d_g_value_init
#endif

static void _cffi_d_g_value_set_boolean(GValue * x0, int x1)
{
  g_value_set_boolean(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_boolean(PyObject *self, PyObject *args)
{
  GValue * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_boolean", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_boolean(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_boolean _cffi_d_g_value_set_boolean
#endif

static void _cffi_d_g_value_set_double(GValue * x0, double x1)
{
  g_value_set_double(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_double(PyObject *self, PyObject *args)
{
  GValue * x0;
  double x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_double", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_double(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_double _cffi_d_g_value_set_double
#endif

static void _cffi_d_g_value_set_enum(GValue * x0, int x1)
{
  g_value_set_enum(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_enum(PyObject *self, PyObject *args)
{
  GValue * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_enum", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_enum(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_enum _cffi_d_g_value_set_enum
#endif

static void _cffi_d_g_value_set_flags(GValue * x0, unsigned int x1)
{
  g_value_set_flags(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_flags(PyObject *self, PyObject *args)
{
  GValue * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_flags", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_flags _cffi_d_g_value_set_flags
#endif

static void _cffi_d_g_value_set_int(GValue * x0, int x1)
{
  g_value_set_int(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_int(PyObject *self, PyObject *args)
{
  GValue * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_int", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_int(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_int _cffi_d_g_value_set_int
#endif

static void _cffi_d_g_value_set_object(GValue * x0, void * x1)
{
  g_value_set_object(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_object(PyObject *self, PyObject *args)
{
  GValue * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_object", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_object(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_object _cffi_d_g_value_set_object
#endif

static void _cffi_d_g_value_set_string(GValue * x0, char const * x1)
{
  g_value_set_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_string(PyObject *self, PyObject *args)
{
  GValue * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_string _cffi_d_g_value_set_string
#endif

static void _cffi_d_g_value_set_uint64(GValue * x0, uint64_t x1)
{
  g_value_set_uint64(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_set_uint64(PyObject *self, PyObject *args)
{
  GValue * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "g_value_set_uint64", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_set_uint64(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_set_uint64 _cffi_d_g_value_set_uint64
#endif

static void _cffi_d_g_value_unset(GValue * x0)
{
  g_value_unset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_g_value_unset(PyObject *self, PyObject *arg0)
{
  GValue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { g_value_unset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_g_value_unset _cffi_d_g_value_unset
#endif

static void * _cffi_d_vips_argument_map(VipsObject * x0, void *(* x1)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *), void * x2, void * x3)
{
  return vips_argument_map(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_argument_map(PyObject *self, PyObject *args)
{
  VipsObject * x0;
  void *(* x1)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *);
  void * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "vips_argument_map", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void *(*)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *))_cffi_to_c_pointer(arg1, _cffi_type(251));
  if (x1 == (void *(*)(VipsObject *, GParamSpec *, VipsArgumentClass *, VipsArgumentInstance *, void *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_argument_map(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_argument_map _cffi_d_vips_argument_map
#endif

static uint64_t _cffi_d_vips_band_format_get_type(void)
{
  return vips_band_format_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_band_format_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_band_format_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_band_format_get_type _cffi_d_vips_band_format_get_type
#endif

static uint64_t _cffi_d_vips_blend_mode_get_type(void)
{
  return vips_blend_mode_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_blend_mode_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_blend_mode_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_blend_mode_get_type _cffi_d_vips_blend_mode_get_type
#endif

static void _cffi_d_vips_block_untrusted_set(int x0)
{
  vips_block_untrusted_set(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_block_untrusted_set(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_block_untrusted_set(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_block_untrusted_set _cffi_d_vips_block_untrusted_set
#endif

static int _cffi_d_vips_cache_get_max(void)
{
  return vips_cache_get_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_get_max(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_cache_get_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_vips_cache_get_max _cffi_d_vips_cache_get_max
#endif

static int _cffi_d_vips_cache_get_max_files(void)
{
  return vips_cache_get_max_files();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_get_max_files(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_cache_get_max_files(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_vips_cache_get_max_files _cffi_d_vips_cache_get_max_files
#endif

static size_t _cffi_d_vips_cache_get_max_mem(void)
{
  return vips_cache_get_max_mem();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_get_max_mem(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_cache_get_max_mem(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_cache_get_max_mem _cffi_d_vips_cache_get_max_mem
#endif

static int _cffi_d_vips_cache_get_size(void)
{
  return vips_cache_get_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_get_size(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_cache_get_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_vips_cache_get_size _cffi_d_vips_cache_get_size
#endif

static VipsOperation * _cffi_d_vips_cache_operation_build(VipsOperation * x0)
{
  return vips_cache_operation_build(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_operation_build(PyObject *self, PyObject *arg0)
{
  VipsOperation * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsOperation * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsOperation *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_cache_operation_build(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(28));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_cache_operation_build _cffi_d_vips_cache_operation_build
#endif

static void _cffi_d_vips_cache_set_max(int x0)
{
  vips_cache_set_max(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_set_max(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_cache_set_max(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_cache_set_max _cffi_d_vips_cache_set_max
#endif

static void _cffi_d_vips_cache_set_max_files(int x0)
{
  vips_cache_set_max_files(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_set_max_files(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_cache_set_max_files(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_cache_set_max_files _cffi_d_vips_cache_set_max_files
#endif

static void _cffi_d_vips_cache_set_max_mem(size_t x0)
{
  vips_cache_set_max_mem(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_set_max_mem(PyObject *self, PyObject *arg0)
{
  size_t x0;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_cache_set_max_mem(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_cache_set_max_mem _cffi_d_vips_cache_set_max_mem
#endif

static void _cffi_d_vips_cache_set_trace(int x0)
{
  vips_cache_set_trace(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_cache_set_trace(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_cache_set_trace(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_cache_set_trace _cffi_d_vips_cache_set_trace
#endif

static char const * _cffi_d_vips_connection_filename(VipsConnection * x0)
{
  return vips_connection_filename(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_connection_filename(PyObject *self, PyObject *arg0)
{
  VipsConnection * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(77), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsConnection *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(77), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_connection_filename(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_connection_filename _cffi_d_vips_connection_filename
#endif

static char const * _cffi_d_vips_connection_nick(VipsConnection * x0)
{
  return vips_connection_nick(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_connection_nick(PyObject *self, PyObject *arg0)
{
  VipsConnection * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(77), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsConnection *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(77), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_connection_nick(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_connection_nick _cffi_d_vips_connection_nick
#endif

static int _cffi_d_vips_enum_from_nick(char const * x0, uint64_t x1, char const * x2)
{
  return vips_enum_from_nick(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_enum_from_nick(PyObject *self, PyObject *args)
{
  char const * x0;
  uint64_t x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_enum_from_nick", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_enum_from_nick(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_enum_from_nick _cffi_d_vips_enum_from_nick
#endif

static char const * _cffi_d_vips_enum_nick(uint64_t x0, int x1)
{
  return vips_enum_nick(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_enum_nick(PyObject *self, PyObject *args)
{
  uint64_t x0;
  int x1;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_enum_nick", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_enum_nick(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_vips_enum_nick _cffi_d_vips_enum_nick
#endif

static char const * _cffi_d_vips_error_buffer(void)
{
  return vips_error_buffer();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_error_buffer(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_error_buffer(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_vips_error_buffer _cffi_d_vips_error_buffer
#endif

static void _cffi_d_vips_error_clear(void)
{
  vips_error_clear();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_error_clear(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_error_clear(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_error_clear _cffi_d_vips_error_clear
#endif

static void _cffi_d_vips_error_freeze(void)
{
  vips_error_freeze();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_error_freeze(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_error_freeze(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_error_freeze _cffi_d_vips_error_freeze
#endif

static void _cffi_d_vips_error_thaw(void)
{
  vips_error_thaw();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_error_thaw(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_error_thaw(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_error_thaw _cffi_d_vips_error_thaw
#endif

static char * _cffi_d_vips_filename_get_filename(char const * x0)
{
  return vips_filename_get_filename(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_filename_get_filename(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_filename_get_filename(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(418));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_filename_get_filename _cffi_d_vips_filename_get_filename
#endif

static char * _cffi_d_vips_filename_get_options(char const * x0)
{
  return vips_filename_get_options(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_filename_get_options(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_filename_get_options(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(418));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_filename_get_options _cffi_d_vips_filename_get_options
#endif

static int _cffi_d_vips_flags_from_nick(char const * x0, uint64_t x1, char const * x2)
{
  return vips_flags_from_nick(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_flags_from_nick(PyObject *self, PyObject *args)
{
  char const * x0;
  uint64_t x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_flags_from_nick", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_flags_from_nick(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_flags_from_nick _cffi_d_vips_flags_from_nick
#endif

static char const * _cffi_d_vips_foreign_find_load(char const * x0)
{
  return vips_foreign_find_load(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_load(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_load(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_load _cffi_d_vips_foreign_find_load
#endif

static char const * _cffi_d_vips_foreign_find_load_buffer(void const * x0, size_t x1)
{
  return vips_foreign_find_load_buffer(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_load_buffer(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_foreign_find_load_buffer", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_load_buffer(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_load_buffer _cffi_d_vips_foreign_find_load_buffer
#endif

static char const * _cffi_d_vips_foreign_find_load_source(VipsSource * x0)
{
  return vips_foreign_find_load_source(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_load_source(PyObject *self, PyObject *arg0)
{
  VipsSource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(83), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsSource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(83), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_load_source(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_load_source _cffi_d_vips_foreign_find_load_source
#endif

static char const * _cffi_d_vips_foreign_find_save(char const * x0)
{
  return vips_foreign_find_save(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_save(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_save(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_save _cffi_d_vips_foreign_find_save
#endif

static char const * _cffi_d_vips_foreign_find_save_buffer(char const * x0)
{
  return vips_foreign_find_save_buffer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_save_buffer(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_save_buffer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_save_buffer _cffi_d_vips_foreign_find_save_buffer
#endif

static char const * _cffi_d_vips_foreign_find_save_target(char const * x0)
{
  return vips_foreign_find_save_target(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_find_save_target(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_find_save_target(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_find_save_target _cffi_d_vips_foreign_find_save_target
#endif

static char * * _cffi_d_vips_foreign_get_suffixes(void)
{
  return vips_foreign_get_suffixes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_foreign_get_suffixes(PyObject *self, PyObject *noarg)
{
  char * * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_foreign_get_suffixes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(417));
  return pyresult;
}
#else
#  define _cffi_f_vips_foreign_get_suffixes _cffi_d_vips_foreign_get_suffixes
#endif

static VipsImage * _cffi_d_vips_image_copy_memory(VipsImage * x0)
{
  return vips_image_copy_memory(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_copy_memory(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsImage * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_copy_memory(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_copy_memory _cffi_d_vips_image_copy_memory
#endif

static int _cffi_d_vips_image_get(VipsImage const * x0, char const * x1, GValue * x2)
{
  return vips_image_get(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_get(PyObject *self, PyObject *args)
{
  VipsImage const * x0;
  char const * x1;
  GValue * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_image_get", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_get(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_get _cffi_d_vips_image_get
#endif

static char * * _cffi_d_vips_image_get_fields(VipsImage * x0)
{
  return vips_image_get_fields(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_get_fields(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_get_fields(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(417));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_get_fields _cffi_d_vips_image_get_fields
#endif

static int _cffi_d_vips_image_get_n_pages(VipsImage * x0)
{
  return vips_image_get_n_pages(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_get_n_pages(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_get_n_pages(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_get_n_pages _cffi_d_vips_image_get_n_pages
#endif

static int _cffi_d_vips_image_get_page_height(VipsImage * x0)
{
  return vips_image_get_page_height(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_get_page_height(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_get_page_height(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_get_page_height _cffi_d_vips_image_get_page_height
#endif

static uint64_t _cffi_d_vips_image_get_typeof(VipsImage const * x0, char const * x1)
{
  return vips_image_get_typeof(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_get_typeof(PyObject *self, PyObject *args)
{
  VipsImage const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_get_typeof", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_get_typeof(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_get_typeof _cffi_d_vips_image_get_typeof
#endif

static int _cffi_d_vips_image_hasalpha(VipsImage * x0)
{
  return vips_image_hasalpha(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_hasalpha(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_hasalpha(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_hasalpha _cffi_d_vips_image_hasalpha
#endif

static void _cffi_d_vips_image_invalidate_all(VipsImage * x0)
{
  vips_image_invalidate_all(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_invalidate_all(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_image_invalidate_all(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_image_invalidate_all _cffi_d_vips_image_invalidate_all
#endif

static VipsImage * _cffi_d_vips_image_new_from_memory(void const * x0, size_t x1, int x2, int x3, int x4, int x5)
{
  return vips_image_new_from_memory(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_new_from_memory(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  int x2;
  int x3;
  int x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsImage * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "vips_image_new_from_memory", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_new_from_memory(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_new_from_memory _cffi_d_vips_image_new_from_memory
#endif

static VipsImage * _cffi_d_vips_image_new_matrix_from_array(int x0, int x1, double const * x2, int x3)
{
  return vips_image_new_matrix_from_array(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_new_matrix_from_array(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  double const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsImage * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "vips_image_new_matrix_from_array", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_new_matrix_from_array(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_new_matrix_from_array _cffi_d_vips_image_new_matrix_from_array
#endif

static VipsImage * _cffi_d_vips_image_new_temp_file(char const * x0)
{
  return vips_image_new_temp_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_new_temp_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsImage * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_new_temp_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(5));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_new_temp_file _cffi_d_vips_image_new_temp_file
#endif

static int _cffi_d_vips_image_remove(VipsImage * x0, char const * x1)
{
  return vips_image_remove(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_remove(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_remove", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_remove(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_remove _cffi_d_vips_image_remove
#endif

static void _cffi_d_vips_image_set(VipsImage * x0, char const * x1, GValue * x2)
{
  vips_image_set(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_set(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  char const * x1;
  GValue * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_image_set", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_image_set(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_image_set _cffi_d_vips_image_set
#endif

static void _cffi_d_vips_image_set_kill(VipsImage * x0, int x1)
{
  vips_image_set_kill(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_set_kill(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_set_kill", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_image_set_kill(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_image_set_kill _cffi_d_vips_image_set_kill
#endif

static void _cffi_d_vips_image_set_progress(VipsImage * x0, int x1)
{
  vips_image_set_progress(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_set_progress(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_set_progress", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_image_set_progress(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_image_set_progress _cffi_d_vips_image_set_progress
#endif

static uint64_t _cffi_d_vips_image_type_get_type(void)
{
  return vips_image_type_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_type_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_type_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_type_get_type _cffi_d_vips_image_type_get_type
#endif

static int _cffi_d_vips_image_write(VipsImage * x0, VipsImage * x1)
{
  return vips_image_write(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_write(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  VipsImage * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_write", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_write(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_write _cffi_d_vips_image_write
#endif

static void * _cffi_d_vips_image_write_to_memory(VipsImage * x0, size_t * x1)
{
  return vips_image_write_to_memory(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_image_write_to_memory(PyObject *self, PyObject *args)
{
  VipsImage * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_image_write_to_memory", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_image_write_to_memory(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_image_write_to_memory _cffi_d_vips_image_write_to_memory
#endif

static int _cffi_d_vips_init(char const * x0)
{
  return vips_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_init(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_init _cffi_d_vips_init
#endif

static VipsInterpolate * _cffi_d_vips_interpolate_new(char const * x0)
{
  return vips_interpolate_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_interpolate_new(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsInterpolate * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_interpolate_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(403));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_interpolate_new _cffi_d_vips_interpolate_new
#endif

static uint64_t _cffi_d_vips_interpretation_get_type(void)
{
  return vips_interpretation_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_interpretation_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_interpretation_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_interpretation_get_type _cffi_d_vips_interpretation_get_type
#endif

static void _cffi_d_vips_leak_set(int x0)
{
  vips_leak_set(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_leak_set(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_leak_set(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_leak_set _cffi_d_vips_leak_set
#endif

static char const * _cffi_d_vips_nickname_find(uint64_t x0)
{
  return vips_nickname_find(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_nickname_find(PyObject *self, PyObject *arg0)
{
  uint64_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_nickname_find(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  return pyresult;
}
#else
#  define _cffi_f_vips_nickname_find _cffi_d_vips_nickname_find
#endif

static int _cffi_d_vips_object_get_args(VipsObject * x0, char const * * * x1, int * * x2, int * x3)
{
  return vips_object_get_args(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_get_args(PyObject *self, PyObject *args)
{
  VipsObject * x0;
  char const * * * x1;
  int * * x2;
  int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "vips_object_get_args", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(136), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(136), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_object_get_args(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_object_get_args _cffi_d_vips_object_get_args
#endif

static int _cffi_d_vips_object_get_argument(VipsObject * x0, char const * x1, GParamSpec * * x2, VipsArgumentClass * * x3, VipsArgumentInstance * * x4)
{
  return vips_object_get_argument(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_get_argument(PyObject *self, PyObject *args)
{
  VipsObject * x0;
  char const * x1;
  GParamSpec * * x2;
  VipsArgumentClass * * x3;
  VipsArgumentInstance * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "vips_object_get_argument", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (GParamSpec * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(148), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (VipsArgumentClass * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(148), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (VipsArgumentInstance * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_object_get_argument(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_object_get_argument _cffi_d_vips_object_get_argument
#endif

static char const * _cffi_d_vips_object_get_description(VipsObject * x0)
{
  return vips_object_get_description(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_get_description(PyObject *self, PyObject *arg0)
{
  VipsObject * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_object_get_description(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_object_get_description _cffi_d_vips_object_get_description
#endif

static void _cffi_d_vips_object_print_all(void)
{
  vips_object_print_all();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_print_all(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_object_print_all(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_object_print_all _cffi_d_vips_object_print_all
#endif

static int _cffi_d_vips_object_set_from_string(VipsObject * x0, char const * x1)
{
  return vips_object_set_from_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_set_from_string(PyObject *self, PyObject *args)
{
  VipsObject * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_object_set_from_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_object_set_from_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_object_set_from_string _cffi_d_vips_object_set_from_string
#endif

static void _cffi_d_vips_object_unref_outputs(VipsObject * x0)
{
  vips_object_unref_outputs(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_object_unref_outputs(PyObject *self, PyObject *arg0)
{
  VipsObject * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(80), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsObject *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(80), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_object_unref_outputs(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_object_unref_outputs _cffi_d_vips_object_unref_outputs
#endif

static void _cffi_d_vips_operation_block_set(char const * x0, int x1)
{
  vips_operation_block_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_operation_block_set(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_operation_block_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_operation_block_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_operation_block_set _cffi_d_vips_operation_block_set
#endif

static uint64_t _cffi_d_vips_operation_flags_get_type(void)
{
  return vips_operation_flags_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_operation_flags_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_operation_flags_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_operation_flags_get_type _cffi_d_vips_operation_flags_get_type
#endif

static int _cffi_d_vips_operation_get_flags(VipsOperation * x0)
{
  return vips_operation_get_flags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_operation_get_flags(PyObject *self, PyObject *arg0)
{
  VipsOperation * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsOperation *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_operation_get_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_operation_get_flags _cffi_d_vips_operation_get_flags
#endif

static VipsOperation * _cffi_d_vips_operation_new(char const * x0)
{
  return vips_operation_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_operation_new(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsOperation * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_operation_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(28));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_operation_new _cffi_d_vips_operation_new
#endif

static void * _cffi_d_vips_region_fetch(VipsRegion * x0, int x1, int x2, int x3, int x4, size_t * x5)
{
  return vips_region_fetch(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_region_fetch(PyObject *self, PyObject *args)
{
  VipsRegion * x0;
  int x1;
  int x2;
  int x3;
  int x4;
  size_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "vips_region_fetch", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsRegion *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_region_fetch(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_region_fetch _cffi_d_vips_region_fetch
#endif

static int _cffi_d_vips_region_height(VipsRegion * x0)
{
  return vips_region_height(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_region_height(PyObject *self, PyObject *arg0)
{
  VipsRegion * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsRegion *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_region_height(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_region_height _cffi_d_vips_region_height
#endif

static VipsRegion * _cffi_d_vips_region_new(VipsImage * x0)
{
  return vips_region_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_region_new(PyObject *self, PyObject *arg0)
{
  VipsImage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsRegion * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsImage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_region_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(155));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_region_new _cffi_d_vips_region_new
#endif

static int _cffi_d_vips_region_width(VipsRegion * x0)
{
  return vips_region_width(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_region_width(PyObject *self, PyObject *arg0)
{
  VipsRegion * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (VipsRegion *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_region_width(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_region_width _cffi_d_vips_region_width
#endif

static uint64_t _cffi_d_vips_saveable_get_type(void)
{
  return vips_saveable_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_saveable_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_saveable_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_saveable_get_type _cffi_d_vips_saveable_get_type
#endif

static void _cffi_d_vips_shutdown(void)
{
  vips_shutdown();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_shutdown(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_shutdown(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_shutdown _cffi_d_vips_shutdown
#endif

static VipsSourceCustom * _cffi_d_vips_source_custom_new(void)
{
  return vips_source_custom_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_source_custom_new(PyObject *self, PyObject *noarg)
{
  VipsSourceCustom * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_source_custom_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(412));
  return pyresult;
}
#else
#  define _cffi_f_vips_source_custom_new _cffi_d_vips_source_custom_new
#endif

static VipsSource * _cffi_d_vips_source_new_from_descriptor(int x0)
{
  return vips_source_new_from_descriptor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_source_new_from_descriptor(PyObject *self, PyObject *arg0)
{
  int x0;
  VipsSource * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_source_new_from_descriptor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(83));
  return pyresult;
}
#else
#  define _cffi_f_vips_source_new_from_descriptor _cffi_d_vips_source_new_from_descriptor
#endif

static VipsSource * _cffi_d_vips_source_new_from_file(char const * x0)
{
  return vips_source_new_from_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_source_new_from_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsSource * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_source_new_from_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(83));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_source_new_from_file _cffi_d_vips_source_new_from_file
#endif

static VipsSource * _cffi_d_vips_source_new_from_memory(void const * x0, size_t x1)
{
  return vips_source_new_from_memory(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_source_new_from_memory(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsSource * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_source_new_from_memory", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_source_new_from_memory(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(83));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_source_new_from_memory _cffi_d_vips_source_new_from_memory
#endif

static VipsTargetCustom * _cffi_d_vips_target_custom_new(void)
{
  return vips_target_custom_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_target_custom_new(PyObject *self, PyObject *noarg)
{
  VipsTargetCustom * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_target_custom_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(415));
  return pyresult;
}
#else
#  define _cffi_f_vips_target_custom_new _cffi_d_vips_target_custom_new
#endif

static VipsTarget * _cffi_d_vips_target_new_to_descriptor(int x0)
{
  return vips_target_new_to_descriptor(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_target_new_to_descriptor(PyObject *self, PyObject *arg0)
{
  int x0;
  VipsTarget * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_target_new_to_descriptor(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  return pyresult;
}
#else
#  define _cffi_f_vips_target_new_to_descriptor _cffi_d_vips_target_new_to_descriptor
#endif

static VipsTarget * _cffi_d_vips_target_new_to_file(char const * x0)
{
  return vips_target_new_to_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_target_new_to_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsTarget * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_target_new_to_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_target_new_to_file _cffi_d_vips_target_new_to_file
#endif

static VipsTarget * _cffi_d_vips_target_new_to_memory(void)
{
  return vips_target_new_to_memory();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_target_new_to_memory(PyObject *self, PyObject *noarg)
{
  VipsTarget * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_target_new_to_memory(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  return pyresult;
}
#else
#  define _cffi_f_vips_target_new_to_memory _cffi_d_vips_target_new_to_memory
#endif

static uint64_t _cffi_d_vips_token_get_type(void)
{
  return vips_token_get_type();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_token_get_type(PyObject *self, PyObject *noarg)
{
  uint64_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_token_get_type(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  return pyresult;
}
#else
#  define _cffi_f_vips_token_get_type _cffi_d_vips_token_get_type
#endif

static uint64_t _cffi_d_vips_type_find(char const * x0, char const * x1)
{
  return vips_type_find(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_type_find(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_type_find", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_type_find(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_type_find _cffi_d_vips_type_find
#endif

static void * _cffi_d_vips_type_map(uint64_t x0, void * x1, void * x2, void * x3)
{
  return vips_type_map(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_type_map(PyObject *self, PyObject *args)
{
  uint64_t x0;
  void * x1;
  void * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "vips_type_map", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, uint64_t);
  if (x0 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_type_map(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_type_map _cffi_d_vips_type_map
#endif

static double * _cffi_d_vips_value_get_array_double(GValue const * x0, int * x1)
{
  return vips_value_get_array_double(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_get_array_double(PyObject *self, PyObject *args)
{
  GValue const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_get_array_double", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_value_get_array_double(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(421));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_value_get_array_double _cffi_d_vips_value_get_array_double
#endif

static VipsImage * * _cffi_d_vips_value_get_array_image(GValue const * x0, int * x1)
{
  return vips_value_get_array_image(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_get_array_image(PyObject *self, PyObject *args)
{
  GValue const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  VipsImage * * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_get_array_image", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_value_get_array_image(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(401));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_value_get_array_image _cffi_d_vips_value_get_array_image
#endif

static int * _cffi_d_vips_value_get_array_int(GValue const * x0, int * x1)
{
  return vips_value_get_array_int(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_get_array_int(PyObject *self, PyObject *args)
{
  GValue const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_get_array_int", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_value_get_array_int(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_value_get_array_int _cffi_d_vips_value_get_array_int
#endif

static void * _cffi_d_vips_value_get_blob(GValue const * x0, size_t * x1)
{
  return vips_value_get_blob(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_get_blob(PyObject *self, PyObject *args)
{
  GValue const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_get_blob", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_value_get_blob(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(159));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_value_get_blob _cffi_d_vips_value_get_blob
#endif

static char const * _cffi_d_vips_value_get_ref_string(GValue const * x0, size_t * x1)
{
  return vips_value_get_ref_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_get_ref_string(PyObject *self, PyObject *args)
{
  GValue const * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_get_ref_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(74), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(74), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_value_get_ref_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_vips_value_get_ref_string _cffi_d_vips_value_get_ref_string
#endif

static void _cffi_d_vips_value_set_array_double(GValue * x0, double const * x1, int x2)
{
  vips_value_set_array_double(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_set_array_double(PyObject *self, PyObject *args)
{
  GValue * x0;
  double const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_value_set_array_double", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_value_set_array_double(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_value_set_array_double _cffi_d_vips_value_set_array_double
#endif

static void _cffi_d_vips_value_set_array_image(GValue * x0, int x1)
{
  vips_value_set_array_image(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_set_array_image(PyObject *self, PyObject *args)
{
  GValue * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_set_array_image", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_value_set_array_image(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_value_set_array_image _cffi_d_vips_value_set_array_image
#endif

static void _cffi_d_vips_value_set_array_int(GValue * x0, int const * x1, int x2)
{
  vips_value_set_array_int(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_set_array_int(PyObject *self, PyObject *args)
{
  GValue * x0;
  int const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_value_set_array_int", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(307), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(307), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_value_set_array_int(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_value_set_array_int _cffi_d_vips_value_set_array_int
#endif

static void _cffi_d_vips_value_set_blob_free(GValue * x0, void * x1, size_t x2)
{
  vips_value_set_blob_free(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_set_blob_free(PyObject *self, PyObject *args)
{
  GValue * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "vips_value_set_blob_free", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_value_set_blob_free(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_value_set_blob_free _cffi_d_vips_value_set_blob_free
#endif

static void _cffi_d_vips_value_set_ref_string(GValue * x0, char const * x1)
{
  vips_value_set_ref_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_value_set_ref_string(PyObject *self, PyObject *args)
{
  GValue * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "vips_value_set_ref_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GValue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { vips_value_set_ref_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_vips_value_set_ref_string _cffi_d_vips_value_set_ref_string
#endif

static int _cffi_d_vips_version(int x0)
{
  return vips_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_vips_version(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = vips_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_vips_version _cffi_d_vips_version
#endif

static int _cffi_const_VIPS_MAJOR_VERSION(unsigned long long *o)
{
  int n = (VIPS_MAJOR_VERSION) <= 0;
  *o = (unsigned long long)((VIPS_MAJOR_VERSION) | 0);  /* check that VIPS_MAJOR_VERSION is an integer */
  return n;
}

static int _cffi_const_VIPS_MICRO_VERSION(unsigned long long *o)
{
  int n = (VIPS_MICRO_VERSION) <= 0;
  *o = (unsigned long long)((VIPS_MICRO_VERSION) | 0);  /* check that VIPS_MICRO_VERSION is an integer */
  return n;
}

static int _cffi_const_VIPS_MINOR_VERSION(unsigned long long *o)
{
  int n = (VIPS_MINOR_VERSION) <= 0;
  *o = (unsigned long long)((VIPS_MINOR_VERSION) | 0);  /* check that VIPS_MINOR_VERSION is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__GEnumClass(GEnumClass *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GTypeClass *tmp = &p->g_type_class; (void)tmp; }
  (void)((p->minimum) | 0);  /* check that 'GEnumClass.minimum' is an integer */
  (void)((p->maximum) | 0);  /* check that 'GEnumClass.maximum' is an integer */
  (void)((p->n_values) | 0);  /* check that 'GEnumClass.n_values' is an integer */
  { GEnumValue * *tmp = &p->values; (void)tmp; }
}
struct _cffi_align__GEnumClass { char x; GEnumClass y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GEnumValue(GEnumValue *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->value) | 0);  /* check that 'GEnumValue.value' is an integer */
  { char const * *tmp = &p->value_name; (void)tmp; }
  { char const * *tmp = &p->value_nick; (void)tmp; }
}
struct _cffi_align__GEnumValue { char x; GEnumValue y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GFlagsClass(GFlagsClass *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GTypeClass *tmp = &p->g_type_class; (void)tmp; }
  (void)((p->mask) | 0);  /* check that 'GFlagsClass.mask' is an integer */
  (void)((p->n_values) | 0);  /* check that 'GFlagsClass.n_values' is an integer */
  { GFlagsValue * *tmp = &p->values; (void)tmp; }
}
struct _cffi_align__GFlagsClass { char x; GFlagsClass y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GFlagsValue(GFlagsValue *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->value) | 0);  /* check that 'GFlagsValue.value' is an integer */
  { char const * *tmp = &p->value_name; (void)tmp; }
  { char const * *tmp = &p->value_nick; (void)tmp; }
}
struct _cffi_align__GFlagsValue { char x; GFlagsValue y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GObject(GObject *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GTypeInstance *tmp = &p->g_type_instance; (void)tmp; }
  (void)((p->ref_count) | 0);  /* check that 'GObject.ref_count' is an integer */
  { GData * *tmp = &p->qdata; (void)tmp; }
}
struct _cffi_align__GObject { char x; GObject y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GParamSpec(GParamSpec *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GTypeInstance *tmp = &p->g_type_instance; (void)tmp; }
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->flags) | 0);  /* check that 'GParamSpec.flags' is an integer */
  (void)((p->value_type) | 0);  /* check that 'GParamSpec.value_type' is an integer */
  (void)((p->owner_type) | 0);  /* check that 'GParamSpec.owner_type' is an integer */
  { char * *tmp = &p->_nick; (void)tmp; }
  { char * *tmp = &p->_blurb; (void)tmp; }
  { GData * *tmp = &p->qdata; (void)tmp; }
  (void)((p->ref_count) | 0);  /* check that 'GParamSpec.ref_count' is an integer */
  (void)((p->param_id) | 0);  /* check that 'GParamSpec.param_id' is an integer */
}
struct _cffi_align__GParamSpec { char x; GParamSpec y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GTypeClass(GTypeClass *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->g_type) | 0);  /* check that 'GTypeClass.g_type' is an integer */
}
struct _cffi_align__GTypeClass { char x; GTypeClass y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GTypeInstance(GTypeInstance *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GTypeClass * *tmp = &p->g_class; (void)tmp; }
}
struct _cffi_align__GTypeInstance { char x; GTypeInstance y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__GValue(GValue *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->g_type) | 0);  /* check that 'GValue.g_type' is an integer */
  /* cannot generate 'union $1[2]' in field 'data': unknown type name */
}
struct _cffi_align__GValue { char x; GValue y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__VipsArgument(VipsArgument *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { GParamSpec * *tmp = &p->pspec; (void)tmp; }
}
struct _cffi_align__VipsArgument { char x; VipsArgument y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__VipsArgumentClass(VipsArgumentClass *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { VipsArgument *tmp = &p->parent; (void)tmp; }
  { VipsObjectClass * *tmp = &p->object_class; (void)tmp; }
  { VipsArgumentFlags *tmp = &p->flags; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'VipsArgumentClass.priority' is an integer */
  (void)((p->offset) | 0);  /* check that 'VipsArgumentClass.offset' is an integer */
}
struct _cffi_align__VipsArgumentClass { char x; VipsArgumentClass y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__VipsArgumentInstance(VipsArgumentInstance *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { VipsArgument *tmp = &p->parent; (void)tmp; }
}
struct _cffi_align__VipsArgumentInstance { char x; VipsArgumentInstance y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__VipsProgress(VipsProgress *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { VipsImage * *tmp = &p->im; (void)tmp; }
  (void)((p->run) | 0);  /* check that 'VipsProgress.run' is an integer */
  (void)((p->eta) | 0);  /* check that 'VipsProgress.eta' is an integer */
  (void)((p->tpels) | 0);  /* check that 'VipsProgress.tpels' is an integer */
  (void)((p->npels) | 0);  /* check that 'VipsProgress.npels' is an integer */
  (void)((p->percent) | 0);  /* check that 'VipsProgress.percent' is an integer */
  { GTimer * *tmp = &p->start; (void)tmp; }
}
struct _cffi_align__VipsProgress { char x; VipsProgress y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "VIPS_ARGUMENT_CONSTRUCT", (void *)_cffi_const_VIPS_ARGUMENT_CONSTRUCT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_DEPRECATED", (void *)_cffi_const_VIPS_ARGUMENT_DEPRECATED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_INPUT", (void *)_cffi_const_VIPS_ARGUMENT_INPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_MODIFY", (void *)_cffi_const_VIPS_ARGUMENT_MODIFY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_NONE", (void *)_cffi_const_VIPS_ARGUMENT_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_OUTPUT", (void *)_cffi_const_VIPS_ARGUMENT_OUTPUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_REQUIRED", (void *)_cffi_const_VIPS_ARGUMENT_REQUIRED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_SET_ALWAYS", (void *)_cffi_const_VIPS_ARGUMENT_SET_ALWAYS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_ARGUMENT_SET_ONCE", (void *)_cffi_const_VIPS_ARGUMENT_SET_ONCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VIPS_MAJOR_VERSION", (void *)_cffi_const_VIPS_MAJOR_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "VIPS_MICRO_VERSION", (void *)_cffi_const_VIPS_MICRO_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "VIPS_MINOR_VERSION", (void *)_cffi_const_VIPS_MINOR_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_log_handler_callback", (void *)&_cffi_externpy___log_handler_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 167), (void *)_log_handler_callback },
  { "_marshal_end", (void *)&_cffi_externpy___marshal_end, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 422), (void *)_marshal_end },
  { "_marshal_finish", (void *)&_cffi_externpy___marshal_finish, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 435), (void *)_marshal_finish },
  { "_marshal_image_progress", (void *)&_cffi_externpy___marshal_image_progress, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 434), (void *)_marshal_image_progress },
  { "_marshal_read", (void *)&_cffi_externpy___marshal_read, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 425), (void *)_marshal_read },
  { "_marshal_seek", (void *)&_cffi_externpy___marshal_seek, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 424), (void *)_marshal_seek },
  { "_marshal_write", (void *)&_cffi_externpy___marshal_write, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 426), (void *)_marshal_write },
  { "g_free", (void *)_cffi_f_g_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 371), (void *)_cffi_d_g_free },
  { "g_log_remove_handler", (void *)_cffi_f_g_log_remove_handler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 355), (void *)_cffi_d_g_log_remove_handler },
  { "g_log_set_handler", (void *)_cffi_f_g_log_set_handler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_g_log_set_handler },
  { "g_malloc", (void *)_cffi_f_g_malloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 263), (void *)_cffi_d_g_malloc },
  { "g_object_get_property", (void *)_cffi_f_g_object_get_property, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_g_object_get_property },
  { "g_object_new", (void *)_cffi_f_g_object_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 269), (void *)_cffi_d_g_object_new },
  { "g_object_ref", (void *)_cffi_f_g_object_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 371), (void *)_cffi_d_g_object_ref },
  { "g_object_set_property", (void *)_cffi_f_g_object_set_property, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_g_object_set_property },
  { "g_object_unref", (void *)_cffi_f_g_object_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 371), (void *)_cffi_d_g_object_unref },
  { "g_param_spec_get_blurb", (void *)_cffi_f_g_param_spec_get_blurb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 66), (void *)_cffi_d_g_param_spec_get_blurb },
  { "g_signal_connect_data", (void *)_cffi_f_g_signal_connect_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 198), (void *)_cffi_d_g_signal_connect_data },
  { "g_type_class_ref", (void *)_cffi_f_g_type_class_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 266), (void *)_cffi_d_g_type_class_ref },
  { "g_type_from_name", (void *)_cffi_f_g_type_from_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 215), (void *)_cffi_d_g_type_from_name },
  { "g_type_fundamental", (void *)_cffi_f_g_type_fundamental, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 222), (void *)_cffi_d_g_type_fundamental },
  { "g_type_name", (void *)_cffi_f_g_type_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_g_type_name },
  { "g_value_get_boolean", (void *)_cffi_f_g_value_get_boolean, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_g_value_get_boolean },
  { "g_value_get_double", (void *)_cffi_f_g_value_get_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 105), (void *)_cffi_d_g_value_get_double },
  { "g_value_get_enum", (void *)_cffi_f_g_value_get_enum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 112), (void *)_cffi_d_g_value_get_enum },
  { "g_value_get_flags", (void *)_cffi_f_g_value_get_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 227), (void *)_cffi_d_g_value_get_flags },
  { "g_value_get_int", (void *)_cffi_f_g_value_get_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 112), (void *)_cffi_d_g_value_get_int },
  { "g_value_get_object", (void *)_cffi_f_g_value_get_object, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 230), (void *)_cffi_d_g_value_get_object },
  { "g_value_get_string", (void *)_cffi_f_g_value_get_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_g_value_get_string },
  { "g_value_get_uint64", (void *)_cffi_f_g_value_get_uint64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 208), (void *)_cffi_d_g_value_get_uint64 },
  { "g_value_init", (void *)_cffi_f_g_value_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 314), (void *)_cffi_d_g_value_init },
  { "g_value_set_boolean", (void *)_cffi_f_g_value_set_boolean, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 310), (void *)_cffi_d_g_value_set_boolean },
  { "g_value_set_double", (void *)_cffi_f_g_value_set_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 301), (void *)_cffi_d_g_value_set_double },
  { "g_value_set_enum", (void *)_cffi_f_g_value_set_enum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 310), (void *)_cffi_d_g_value_set_enum },
  { "g_value_set_flags", (void *)_cffi_f_g_value_set_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 318), (void *)_cffi_d_g_value_set_flags },
  { "g_value_set_int", (void *)_cffi_f_g_value_set_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 310), (void *)_cffi_d_g_value_set_int },
  { "g_value_set_object", (void *)_cffi_f_g_value_set_object, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 322), (void *)_cffi_d_g_value_set_object },
  { "g_value_set_string", (void *)_cffi_f_g_value_set_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 292), (void *)_cffi_d_g_value_set_string },
  { "g_value_set_uint64", (void *)_cffi_f_g_value_set_uint64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 314), (void *)_cffi_d_g_value_set_uint64 },
  { "g_value_unset", (void *)_cffi_f_g_value_unset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 289), (void *)_cffi_d_g_value_unset },
  { "vips_argument_map", (void *)_cffi_f_vips_argument_map, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 249), (void *)_cffi_d_vips_argument_map },
  { "vips_band_format_get_type", (void *)_cffi_f_vips_band_format_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_band_format_get_type },
  { "vips_blend_mode_get_type", (void *)_cffi_f_vips_blend_mode_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_blend_mode_get_type },
  { "vips_block_untrusted_set", (void *)_cffi_f_vips_block_untrusted_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_vips_block_untrusted_set },
  { "vips_cache_get_max", (void *)_cffi_f_vips_cache_get_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 178), (void *)_cffi_d_vips_cache_get_max },
  { "vips_cache_get_max_files", (void *)_cffi_f_vips_cache_get_max_files, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 178), (void *)_cffi_d_vips_cache_get_max_files },
  { "vips_cache_get_max_mem", (void *)_cffi_f_vips_cache_get_max_mem, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_vips_cache_get_max_mem },
  { "vips_cache_get_size", (void *)_cffi_f_vips_cache_get_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 178), (void *)_cffi_d_vips_cache_get_size },
  { "vips_cache_operation_build", (void *)_cffi_f_vips_cache_operation_build, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 27), (void *)_cffi_d_vips_cache_operation_build },
  { "vips_cache_set_max", (void *)_cffi_f_vips_cache_set_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_vips_cache_set_max },
  { "vips_cache_set_max_files", (void *)_cffi_f_vips_cache_set_max_files, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_vips_cache_set_max_files },
  { "vips_cache_set_max_mem", (void *)_cffi_f_vips_cache_set_max_mem, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 368), (void *)_cffi_d_vips_cache_set_max_mem },
  { "vips_cache_set_trace", (void *)_cffi_f_vips_cache_set_trace, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_vips_cache_set_trace },
  { "vips_connection_filename", (void *)_cffi_f_vips_connection_filename, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 76), (void *)_cffi_d_vips_connection_filename },
  { "vips_connection_nick", (void *)_cffi_f_vips_connection_nick, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 76), (void *)_cffi_d_vips_connection_nick },
  { "vips_enum_from_nick", (void *)_cffi_f_vips_enum_from_nick, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 170), (void *)_cffi_d_vips_enum_from_nick },
  { "vips_enum_nick", (void *)_cffi_f_vips_enum_nick, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_vips_enum_nick },
  { "vips_error_buffer", (void *)_cffi_f_vips_error_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 99), (void *)_cffi_d_vips_error_buffer },
  { "vips_error_clear", (void *)_cffi_f_vips_error_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 378), (void *)_cffi_d_vips_error_clear },
  { "vips_error_freeze", (void *)_cffi_f_vips_error_freeze, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 378), (void *)_cffi_d_vips_error_freeze },
  { "vips_error_thaw", (void *)_cffi_f_vips_error_thaw, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 378), (void *)_cffi_d_vips_error_thaw },
  { "vips_filename_get_filename", (void *)_cffi_f_vips_filename_get_filename, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 63), (void *)_cffi_d_vips_filename_get_filename },
  { "vips_filename_get_options", (void *)_cffi_f_vips_filename_get_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 63), (void *)_cffi_d_vips_filename_get_options },
  { "vips_flags_from_nick", (void *)_cffi_f_vips_flags_from_nick, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 170), (void *)_cffi_d_vips_flags_from_nick },
  { "vips_foreign_find_load", (void *)_cffi_f_vips_foreign_find_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_vips_foreign_find_load },
  { "vips_foreign_find_load_buffer", (void *)_cffi_f_vips_foreign_find_load_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_vips_foreign_find_load_buffer },
  { "vips_foreign_find_load_source", (void *)_cffi_f_vips_foreign_find_load_source, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 82), (void *)_cffi_d_vips_foreign_find_load_source },
  { "vips_foreign_find_save", (void *)_cffi_f_vips_foreign_find_save, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_vips_foreign_find_save },
  { "vips_foreign_find_save_buffer", (void *)_cffi_f_vips_foreign_find_save_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_vips_foreign_find_save_buffer },
  { "vips_foreign_find_save_target", (void *)_cffi_f_vips_foreign_find_save_target, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_vips_foreign_find_save_target },
  { "vips_foreign_get_suffixes", (void *)_cffi_f_vips_foreign_get_suffixes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 61), (void *)_cffi_d_vips_foreign_get_suffixes },
  { "vips_image_copy_memory", (void *)_cffi_f_vips_image_copy_memory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 4), (void *)_cffi_d_vips_image_copy_memory },
  { "vips_image_get", (void *)_cffi_f_vips_image_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 129), (void *)_cffi_d_vips_image_get },
  { "vips_image_get_fields", (void *)_cffi_f_vips_image_get_fields, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 58), (void *)_cffi_d_vips_image_get_fields },
  { "vips_image_get_n_pages", (void *)_cffi_f_vips_image_get_n_pages, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_vips_image_get_n_pages },
  { "vips_image_get_page_height", (void *)_cffi_f_vips_image_get_page_height, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_vips_image_get_page_height },
  { "vips_image_get_typeof", (void *)_cffi_f_vips_image_get_typeof, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 211), (void *)_cffi_d_vips_image_get_typeof },
  { "vips_image_hasalpha", (void *)_cffi_f_vips_image_hasalpha, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_vips_image_hasalpha },
  { "vips_image_invalidate_all", (void *)_cffi_f_vips_image_invalidate_all, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 331), (void *)_cffi_d_vips_image_invalidate_all },
  { "vips_image_new_from_memory", (void *)_cffi_f_vips_image_new_from_memory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 16), (void *)_cffi_d_vips_image_new_from_memory },
  { "vips_image_new_matrix_from_array", (void *)_cffi_f_vips_image_new_matrix_from_array, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 10), (void *)_cffi_d_vips_image_new_matrix_from_array },
  { "vips_image_new_temp_file", (void *)_cffi_f_vips_image_new_temp_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 7), (void *)_cffi_d_vips_image_new_temp_file },
  { "vips_image_remove", (void *)_cffi_f_vips_image_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_vips_image_remove },
  { "vips_image_set", (void *)_cffi_f_vips_image_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 334), (void *)_cffi_d_vips_image_set },
  { "vips_image_set_kill", (void *)_cffi_f_vips_image_set_kill, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_vips_image_set_kill },
  { "vips_image_set_progress", (void *)_cffi_f_vips_image_set_progress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_vips_image_set_progress },
  { "vips_image_type_get_type", (void *)_cffi_f_vips_image_type_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_image_type_get_type },
  { "vips_image_write", (void *)_cffi_f_vips_image_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_vips_image_write },
  { "vips_image_write_to_memory", (void *)_cffi_f_vips_image_write_to_memory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 237), (void *)_cffi_d_vips_image_write_to_memory },
  { "vips_init", (void *)_cffi_f_vips_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 161), (void *)_cffi_d_vips_init },
  { "vips_interpolate_new", (void *)_cffi_f_vips_interpolate_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 24), (void *)_cffi_d_vips_interpolate_new },
  { "vips_interpretation_get_type", (void *)_cffi_f_vips_interpretation_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_interpretation_get_type },
  { "vips_leak_set", (void *)_cffi_f_vips_leak_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 365), (void *)_cffi_d_vips_leak_set },
  { "vips_nickname_find", (void *)_cffi_f_vips_nickname_find, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_vips_nickname_find },
  { "vips_object_get_args", (void *)_cffi_f_vips_object_get_args, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 134), (void *)_cffi_d_vips_object_get_args },
  { "vips_object_get_argument", (void *)_cffi_f_vips_object_get_argument, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_vips_object_get_argument },
  { "vips_object_get_description", (void *)_cffi_f_vips_object_get_description, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_vips_object_get_description },
  { "vips_object_print_all", (void *)_cffi_f_vips_object_print_all, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 378), (void *)_cffi_d_vips_object_print_all },
  { "vips_object_set_from_string", (void *)_cffi_f_vips_object_set_from_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 140), (void *)_cffi_d_vips_object_set_from_string },
  { "vips_object_unref_outputs", (void *)_cffi_f_vips_object_unref_outputs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 348), (void *)_cffi_d_vips_object_unref_outputs },
  { "vips_operation_block_set", (void *)_cffi_f_vips_operation_block_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 355), (void *)_cffi_d_vips_operation_block_set },
  { "vips_operation_flags_get_type", (void *)_cffi_f_vips_operation_flags_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_operation_flags_get_type },
  { "vips_operation_get_flags", (void *)_cffi_f_vips_operation_get_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 151), (void *)_cffi_d_vips_operation_get_flags },
  { "vips_operation_new", (void *)_cffi_f_vips_operation_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 30), (void *)_cffi_d_vips_operation_new },
  { "vips_region_fetch", (void *)_cffi_f_vips_region_fetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 255), (void *)_cffi_d_vips_region_fetch },
  { "vips_region_height", (void *)_cffi_f_vips_region_height, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 154), (void *)_cffi_d_vips_region_height },
  { "vips_region_new", (void *)_cffi_f_vips_region_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 33), (void *)_cffi_d_vips_region_new },
  { "vips_region_width", (void *)_cffi_f_vips_region_width, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 154), (void *)_cffi_d_vips_region_width },
  { "vips_saveable_get_type", (void *)_cffi_f_vips_saveable_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_saveable_get_type },
  { "vips_shutdown", (void *)_cffi_f_vips_shutdown, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 378), (void *)_cffi_d_vips_shutdown },
  { "vips_source_custom_new", (void *)_cffi_f_vips_source_custom_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 46), (void *)_cffi_d_vips_source_custom_new },
  { "vips_source_new_from_descriptor", (void *)_cffi_f_vips_source_new_from_descriptor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_vips_source_new_from_descriptor },
  { "vips_source_new_from_file", (void *)_cffi_f_vips_source_new_from_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 36), (void *)_cffi_d_vips_source_new_from_file },
  { "vips_source_new_from_memory", (void *)_cffi_f_vips_source_new_from_memory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 42), (void *)_cffi_d_vips_source_new_from_memory },
  { "vips_target_custom_new", (void *)_cffi_f_vips_target_custom_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 56), (void *)_cffi_d_vips_target_custom_new },
  { "vips_target_new_to_descriptor", (void *)_cffi_f_vips_target_new_to_descriptor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 51), (void *)_cffi_d_vips_target_new_to_descriptor },
  { "vips_target_new_to_file", (void *)_cffi_f_vips_target_new_to_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 48), (void *)_cffi_d_vips_target_new_to_file },
  { "vips_target_new_to_memory", (void *)_cffi_f_vips_target_new_to_memory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 54), (void *)_cffi_d_vips_target_new_to_memory },
  { "vips_token_get_type", (void *)_cffi_f_vips_token_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 225), (void *)_cffi_d_vips_token_get_type },
  { "vips_type_find", (void *)_cffi_f_vips_type_find, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 218), (void *)_cffi_d_vips_type_find },
  { "vips_type_map", (void *)_cffi_f_vips_type_map, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 278), (void *)_cffi_d_vips_type_map },
  { "vips_value_get_array_double", (void *)_cffi_f_vips_value_get_array_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 101), (void *)_cffi_d_vips_value_get_array_double },
  { "vips_value_get_array_image", (void *)_cffi_f_vips_value_get_array_image, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_vips_value_get_array_image },
  { "vips_value_get_array_int", (void *)_cffi_f_vips_value_get_array_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 108), (void *)_cffi_d_vips_value_get_array_int },
  { "vips_value_get_blob", (void *)_cffi_f_vips_value_get_blob, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 233), (void *)_cffi_d_vips_value_get_blob },
  { "vips_value_get_ref_string", (void *)_cffi_f_vips_value_get_ref_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_vips_value_get_ref_string },
  { "vips_value_set_array_double", (void *)_cffi_f_vips_value_set_array_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 296), (void *)_cffi_d_vips_value_set_array_double },
  { "vips_value_set_array_image", (void *)_cffi_f_vips_value_set_array_image, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 310), (void *)_cffi_d_vips_value_set_array_image },
  { "vips_value_set_array_int", (void *)_cffi_f_vips_value_set_array_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 305), (void *)_cffi_d_vips_value_set_array_int },
  { "vips_value_set_blob_free", (void *)_cffi_f_vips_value_set_blob_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 326), (void *)_cffi_d_vips_value_set_blob_free },
  { "vips_value_set_ref_string", (void *)_cffi_f_vips_value_set_ref_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 292), (void *)_cffi_d_vips_value_set_ref_string },
  { "vips_version", (void *)_cffi_f_vips_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 175), (void *)_cffi_d_vips_version },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "g_type_class", offsetof(GEnumClass, g_type_class),
                    sizeof(((GEnumClass *)0)->g_type_class),
                    _CFFI_OP(_CFFI_OP_NOOP, 393) },
  { "minimum", offsetof(GEnumClass, minimum),
               sizeof(((GEnumClass *)0)->minimum),
               _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "maximum", offsetof(GEnumClass, maximum),
               sizeof(((GEnumClass *)0)->maximum),
               _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "n_values", offsetof(GEnumClass, n_values),
                sizeof(((GEnumClass *)0)->n_values),
                _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "values", offsetof(GEnumClass, values),
              sizeof(((GEnumClass *)0)->values),
              _CFFI_OP(_CFFI_OP_NOOP, 383) },
  { "value", offsetof(GEnumValue, value),
             sizeof(((GEnumValue *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "value_name", offsetof(GEnumValue, value_name),
                  sizeof(((GEnumValue *)0)->value_name),
                  _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "value_nick", offsetof(GEnumValue, value_nick),
                  sizeof(((GEnumValue *)0)->value_nick),
                  _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "g_type_class", offsetof(GFlagsClass, g_type_class),
                    sizeof(((GFlagsClass *)0)->g_type_class),
                    _CFFI_OP(_CFFI_OP_NOOP, 393) },
  { "mask", offsetof(GFlagsClass, mask),
            sizeof(((GFlagsClass *)0)->mask),
            _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "n_values", offsetof(GFlagsClass, n_values),
                sizeof(((GFlagsClass *)0)->n_values),
                _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "values", offsetof(GFlagsClass, values),
              sizeof(((GFlagsClass *)0)->values),
              _CFFI_OP(_CFFI_OP_NOOP, 386) },
  { "value", offsetof(GFlagsValue, value),
             sizeof(((GFlagsValue *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "value_name", offsetof(GFlagsValue, value_name),
                  sizeof(((GFlagsValue *)0)->value_name),
                  _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "value_nick", offsetof(GFlagsValue, value_nick),
                  sizeof(((GFlagsValue *)0)->value_nick),
                  _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "g_type_instance", offsetof(GObject, g_type_instance),
                       sizeof(((GObject *)0)->g_type_instance),
                       _CFFI_OP(_CFFI_OP_NOOP, 394) },
  { "ref_count", offsetof(GObject, ref_count),
                 sizeof(((GObject *)0)->ref_count),
                 _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "qdata", offsetof(GObject, qdata),
             sizeof(((GObject *)0)->qdata),
             _CFFI_OP(_CFFI_OP_NOOP, 380) },
  { "g_type_instance", offsetof(GParamSpec, g_type_instance),
                       sizeof(((GParamSpec *)0)->g_type_instance),
                       _CFFI_OP(_CFFI_OP_NOOP, 394) },
  { "name", offsetof(GParamSpec, name),
            sizeof(((GParamSpec *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 8) },
  { "flags", offsetof(GParamSpec, flags),
             sizeof(((GParamSpec *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "value_type", offsetof(GParamSpec, value_type),
                  sizeof(((GParamSpec *)0)->value_type),
                  _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "owner_type", offsetof(GParamSpec, owner_type),
                  sizeof(((GParamSpec *)0)->owner_type),
                  _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "_nick", offsetof(GParamSpec, _nick),
             sizeof(((GParamSpec *)0)->_nick),
             _CFFI_OP(_CFFI_OP_NOOP, 418) },
  { "_blurb", offsetof(GParamSpec, _blurb),
              sizeof(((GParamSpec *)0)->_blurb),
              _CFFI_OP(_CFFI_OP_NOOP, 418) },
  { "qdata", offsetof(GParamSpec, qdata),
             sizeof(((GParamSpec *)0)->qdata),
             _CFFI_OP(_CFFI_OP_NOOP, 380) },
  { "ref_count", offsetof(GParamSpec, ref_count),
                 sizeof(((GParamSpec *)0)->ref_count),
                 _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "param_id", offsetof(GParamSpec, param_id),
                sizeof(((GParamSpec *)0)->param_id),
                _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "g_type", offsetof(GTypeClass, g_type),
              sizeof(((GTypeClass *)0)->g_type),
              _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "g_class", offsetof(GTypeInstance, g_class),
               sizeof(((GTypeInstance *)0)->g_class),
               _CFFI_OP(_CFFI_OP_NOOP, 392) },
  { "g_type", offsetof(GValue, g_type),
              sizeof(((GValue *)0)->g_type),
              _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "data", offsetof(GValue, data),
            sizeof(((GValue *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 431) },
  { "pspec", offsetof(VipsArgument, pspec),
             sizeof(((VipsArgument *)0)->pspec),
             _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "parent", offsetof(VipsArgumentClass, parent),
              sizeof(((VipsArgumentClass *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 396) },
  { "object_class", offsetof(VipsArgumentClass, object_class),
                    sizeof(((VipsArgumentClass *)0)->object_class),
                    _CFFI_OP(_CFFI_OP_NOOP, 406) },
  { "flags", offsetof(VipsArgumentClass, flags),
             sizeof(((VipsArgumentClass *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 398) },
  { "priority", offsetof(VipsArgumentClass, priority),
                sizeof(((VipsArgumentClass *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "offset", offsetof(VipsArgumentClass, offset),
              sizeof(((VipsArgumentClass *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 320) },
  { "parent", offsetof(VipsArgumentInstance, parent),
              sizeof(((VipsArgumentInstance *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 396) },
  { "im", offsetof(VipsProgress, im),
          sizeof(((VipsProgress *)0)->im),
          _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "run", offsetof(VipsProgress, run),
           sizeof(((VipsProgress *)0)->run),
           _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "eta", offsetof(VipsProgress, eta),
           sizeof(((VipsProgress *)0)->eta),
           _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "tpels", offsetof(VipsProgress, tpels),
             sizeof(((VipsProgress *)0)->tpels),
             _CFFI_OP(_CFFI_OP_NOOP, 182) },
  { "npels", offsetof(VipsProgress, npels),
             sizeof(((VipsProgress *)0)->npels),
             _CFFI_OP(_CFFI_OP_NOOP, 182) },
  { "percent", offsetof(VipsProgress, percent),
               sizeof(((VipsProgress *)0)->percent),
               _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "start", offsetof(VipsProgress, start),
             sizeof(((VipsProgress *)0)->start),
             _CFFI_OP(_CFFI_OP_NOOP, 390) },
  { "v_uint64", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 89) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 430, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 46, 1 /* unnamed */ },
  { "$GData", 381, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$GTimer", 391, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsConnection", 400, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsImage", 402, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsInterpolate", 404, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsObject", 405, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsObjectClass", 407, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsOperation", 408, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsRegion", 410, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsSource", 411, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsSourceCustom", 413, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsTarget", 414, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$VipsTargetCustom", 416, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_GClosure", 428, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_GEnumClass", 382, _CFFI_F_CHECK_FIELDS,
    sizeof(GEnumClass), offsetof(struct _cffi_align__GEnumClass, y), 0, 5 },
  { "_GEnumValue", 384, _CFFI_F_CHECK_FIELDS,
    sizeof(GEnumValue), offsetof(struct _cffi_align__GEnumValue, y), 5, 3 },
  { "_GFlagsClass", 385, _CFFI_F_CHECK_FIELDS,
    sizeof(GFlagsClass), offsetof(struct _cffi_align__GFlagsClass, y), 8, 4 },
  { "_GFlagsValue", 387, _CFFI_F_CHECK_FIELDS,
    sizeof(GFlagsValue), offsetof(struct _cffi_align__GFlagsValue, y), 12, 3 },
  { "_GObject", 388, _CFFI_F_CHECK_FIELDS,
    sizeof(GObject), offsetof(struct _cffi_align__GObject, y), 15, 3 },
  { "_GParamSpec", 389, _CFFI_F_CHECK_FIELDS,
    sizeof(GParamSpec), offsetof(struct _cffi_align__GParamSpec, y), 18, 10 },
  { "_GTypeClass", 393, _CFFI_F_CHECK_FIELDS,
    sizeof(GTypeClass), offsetof(struct _cffi_align__GTypeClass, y), 28, 1 },
  { "_GTypeInstance", 394, _CFFI_F_CHECK_FIELDS,
    sizeof(GTypeInstance), offsetof(struct _cffi_align__GTypeInstance, y), 29, 1 },
  { "_GValue", 395, _CFFI_F_CHECK_FIELDS,
    sizeof(GValue), offsetof(struct _cffi_align__GValue, y), 30, 2 },
  { "_VipsArgument", 396, _CFFI_F_CHECK_FIELDS,
    sizeof(VipsArgument), offsetof(struct _cffi_align__VipsArgument, y), 32, 1 },
  { "_VipsArgumentClass", 397, _CFFI_F_CHECK_FIELDS,
    sizeof(VipsArgumentClass), offsetof(struct _cffi_align__VipsArgumentClass, y), 33, 5 },
  { "_VipsArgumentInstance", 399, _CFFI_F_CHECK_FIELDS,
    sizeof(VipsArgumentInstance), offsetof(struct _cffi_align__VipsArgumentInstance, y), 38, 1 },
  { "_VipsProgress", 409, _CFFI_F_CHECK_FIELDS,
    sizeof(VipsProgress), offsetof(struct _cffi_align__VipsProgress, y), 39, 7 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "_VipsArgumentFlags", 398, _cffi_prim_int(sizeof(VipsArgumentFlags), ((VipsArgumentFlags)-1) <= 0),
    "VIPS_ARGUMENT_NONE,VIPS_ARGUMENT_REQUIRED,VIPS_ARGUMENT_CONSTRUCT,VIPS_ARGUMENT_SET_ONCE,VIPS_ARGUMENT_SET_ALWAYS,VIPS_ARGUMENT_INPUT,VIPS_ARGUMENT_OUTPUT,VIPS_ARGUMENT_DEPRECATED,VIPS_ARGUMENT_MODIFY" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "GCallback", 201 },
  { "GClosureNotify", 203 },
  { "GData", 381 },
  { "GEnumClass", 382 },
  { "GEnumValue", 384 },
  { "GFlagsClass", 385 },
  { "GFlagsValue", 387 },
  { "GLogFunc", 167 },
  { "GObject", 388 },
  { "GParamSpec", 389 },
  { "GTimer", 391 },
  { "GType", 89 },
  { "GTypeClass", 393 },
  { "GTypeInstance", 394 },
  { "GValue", 395 },
  { "VipsArgument", 396 },
  { "VipsArgumentClass", 397 },
  { "VipsArgumentFlags", 398 },
  { "VipsArgumentInstance", 399 },
  { "VipsArgumentMapFn", 251 },
  { "VipsConnection", 400 },
  { "VipsImage", 402 },
  { "VipsInterpolate", 404 },
  { "VipsObject", 405 },
  { "VipsObjectClass", 407 },
  { "VipsOperation", 408 },
  { "VipsProgress", 409 },
  { "VipsRegion", 410 },
  { "VipsSource", 411 },
  { "VipsSourceCustom", 413 },
  { "VipsTarget", 414 },
  { "VipsTargetCustom", 416 },
  { "VipsTypeMap2Fn", 433 },
  { "gint32", 423 },
  { "gint64", 182 },
  { "guint32", 429 },
  { "guint64", 89 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  144,  /* num_globals */
  28,  /* num_struct_unions */
  1,  /* num_enums */
  37,  /* num_typenames */
  NULL,  /* no includes */
  437,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__libvips(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__libvips(void) { return NULL; }
#  else
     init_libvips(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__libvips(void)
{
  return _cffi_init("_libvips", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_libvips(void)
{
  _cffi_init("_libvips", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
