/*
* This file is a part of the Cairo-Dock project
*
* Copyright : (C) see the 'copyright' file.
* E-mail    : see the 'copyright' file.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 3
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __GLDI_ICON_NAMES__
#define  __GLDI_ICON_NAMES__

#include "glib.h"

G_BEGIN_DECLS

/**
*@file gldi-icon-names.h This file lists the common named icons; these are generic icons that any icon-theme should provide, and they replace gtk-stock icons.
 * 
 */

#define GLDI_ICON_NAME_ABOUT "help-about"

#define GLDI_ICON_NAME_ADD "list-add"

#define GLDI_ICON_NAME_BOLD "format-text-bold"

#define GLDI_ICON_NAME_CAPS_LOCK_WARNING "dialog-warning-symbolic"

#define GLDI_ICON_NAME_CDROM "media-optical"

#define GLDI_ICON_NAME_CLEAR "edit-clear"

#define GLDI_ICON_NAME_CLOSE "window-close"

#define GLDI_ICON_NAME_CONNECT "network-wired"

#define GLDI_ICON_NAME_COPY "edit-copy"

#define GLDI_ICON_NAME_CUT "edit-cut"

#define GLDI_ICON_NAME_DELETE "edit-delete"

#define GLDI_ICON_NAME_DIALOG_AUTHENTICATION "dialog-password"

#define GLDI_ICON_NAME_DIALOG_INFO "dialog-information"

#define GLDI_ICON_NAME_DIALOG_WARNING "dialog-warning"

#define GLDI_ICON_NAME_DIALOG_ERROR "dialog-error"

#define GLDI_ICON_NAME_DIALOG_QUESTION "dialog-question"

#define GLDI_ICON_NAME_DIRECTORY "folder"

#define GLDI_ICON_NAME_DISCONNECT "network-offline"

#define GLDI_ICON_NAME_EDIT "document-open"

#define GLDI_ICON_NAME_EXECUTE "system-run"

#define GLDI_ICON_NAME_FILE "text-x-generic"

#define GLDI_ICON_NAME_FIND "edit-find"

#define GLDI_ICON_NAME_FIND_AND_REPLACE "edit-find-replace"

#define GLDI_ICON_NAME_FLOPPY "media-floppy"

#define GLDI_ICON_NAME_FULLSCREEN "view-fullscreen"

#define GLDI_ICON_NAME_GOTO_BOTTOM "go-bottom"

#define GLDI_ICON_NAME_GOTO_FIRST "go-first"

#define GLDI_ICON_NAME_GOTO_LAST "go-last"

#define GLDI_ICON_NAME_GOTO_TOP "go-top"

#define GLDI_ICON_NAME_GO_BACK "go-previous"

#define GLDI_ICON_NAME_GO_DOWN "go-down"

#define GLDI_ICON_NAME_GO_FORWARD "go-next"

#define GLDI_ICON_NAME_GO_UP "go-up"

#define GLDI_ICON_NAME_HARDDISK "drive-harddisk"

#define GLDI_ICON_NAME_HELP "help-browser"

#define GLDI_ICON_NAME_HOME "go-home"

#define GLDI_ICON_NAME_INDENT "format-indent-more"

#define GLDI_ICON_NAME_INFO "dialog-information"

#define GLDI_ICON_NAME_ITALIC "format-text-italic"

#define GLDI_ICON_NAME_JUMP_TO "go-jump"

#define GLDI_ICON_NAME_JUSTIFY_CENTER "format-justify-center"

#define GLDI_ICON_NAME_JUSTIFY_FILL "format-justify-fill"

#define GLDI_ICON_NAME_JUSTIFY_LEFT "format-justify-left"

#define GLDI_ICON_NAME_JUSTIFY_RIGHT "format-justify-right"

#define GLDI_ICON_NAME_LEAVE_FULLSCREEN "view-restore"

#define GLDI_ICON_NAME_MISSING_IMAGE "image-missing"

#define GLDI_ICON_NAME_MEDIA_EJECT "media-eject"

#define GLDI_ICON_NAME_MEDIA_FORWARD "media-seek-forward"

#define GLDI_ICON_NAME_MEDIA_NEXT "media-skip-forward"

#define GLDI_ICON_NAME_MEDIA_PAUSE "media-playback-pause"

#define GLDI_ICON_NAME_MEDIA_PLAY "media-playback-start"

#define GLDI_ICON_NAME_MEDIA_PREVIOUS "media-skip-backward"

#define GLDI_ICON_NAME_MEDIA_RECORD "media-record"

#define GLDI_ICON_NAME_MEDIA_REWIND "media-seek-backward"

#define GLDI_ICON_NAME_MEDIA_STOP "media-playback-stop"

#define GLDI_ICON_NAME_NETWORK "network-workgroup"

#define GLDI_ICON_NAME_NEW "document-new"

#define GLDI_ICON_NAME_OPEN "document-open"

#define GLDI_ICON_NAME_PAGE_SETUP "document-page-setup"

#define GLDI_ICON_NAME_PASTE "edit-paste"

#define GLDI_ICON_NAME_PREFERENCES "preferences-system"

#define GLDI_ICON_NAME_PRINT "document-print"

#define GLDI_ICON_NAME_PRINT_ERROR "printer-error"

#define GLDI_ICON_NAME_PROPERTIES "document-properties"

#define GLDI_ICON_NAME_QUIT "application-exit"

#define GLDI_ICON_NAME_REDO "edit-redo"

#define GLDI_ICON_NAME_REFRESH "view-refresh"

#define GLDI_ICON_NAME_REMOVE "list-remove"

#define GLDI_ICON_NAME_REVERT_TO_SAVED "document-revert"

#define GLDI_ICON_NAME_SAVE "document-save"

#define GLDI_ICON_NAME_SAVE_AS "document-save-as"

#define GLDI_ICON_NAME_SELECT_ALL "edit-select-all"

#define GLDI_ICON_NAME_SELECT_COLOR "preferences-desktop-theme"

#define GLDI_ICON_NAME_SELECT_FONT "preferences-desktop-font"

#define GLDI_ICON_NAME_SORT_ASCENDING "view-sort-ascending"

#define GLDI_ICON_NAME_SORT_DESCENDING "view-sort-descending"

#define GLDI_ICON_NAME_SPELL_CHECK "tools-check-spelling"

#define GLDI_ICON_NAME_STOP "process-stop"

#define GLDI_ICON_NAME_UNDERLINE "format-text-underline"

#define GLDI_ICON_NAME_UNDO "edit-undo"

#define GLDI_ICON_NAME_UNINDENT "format-indent-less"

#define GLDI_ICON_NAME_ZOOM_100 "zoom-original"

#define GLDI_ICON_NAME_ZOOM_FIT "zoom-fit-best"

#define GLDI_ICON_NAME_ZOOM_IN "zoom-in"

#define GLDI_ICON_NAME_ZOOM_OUT "zoom-out"


G_END_DECLS
#endif
