"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentIdByConfig = exports.getAgentIdAndRequest = void 0;
var _query_assist = require("../../../../common/constants/query_assist");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const AGENT_REQUEST_OPTIONS = {
  /**
   * It is time-consuming for LLM to generate final answer
   * Give it a large timeout window
   */
  requestTimeout: 5 * 60 * 1000,
  /**
   * Do not retry
   */
  maxRetries: 0
};
const getAgentIdByConfig = async (opensearchClient, configName) => {
  try {
    var _response$body$ml_con, _response$body$config, _response$body$ml_con2, _response$body$config2;
    const response = await opensearchClient.transport.request({
      method: 'GET',
      path: `${_query_assist.ML_COMMONS_API_PREFIX}/config/${configName}`
    });
    if (!response || !((_response$body$ml_con = response.body.ml_configuration) !== null && _response$body$ml_con !== void 0 && _response$body$ml_con.agent_id || (_response$body$config = response.body.configuration) !== null && _response$body$config !== void 0 && _response$body$config.agent_id)) {
      throw new Error('cannot find any agent by configuration: ' + configName);
    }
    return ((_response$body$ml_con2 = response.body.ml_configuration) === null || _response$body$ml_con2 === void 0 ? void 0 : _response$body$ml_con2.agent_id) || ((_response$body$config2 = response.body.configuration) === null || _response$body$config2 === void 0 ? void 0 : _response$body$config2.agent_id);
  } catch (error) {
    var _error$meta;
    const errorMessage = JSON.stringify((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body) || error;
    throw new Error(`Get agent '${configName}' failed, reason: ` + errorMessage);
  }
};
exports.getAgentIdByConfig = getAgentIdByConfig;
const getAgentIdAndRequest = async options => {
  const {
    client,
    configName,
    body
  } = options;
  const agentId = await getAgentIdByConfig(client, configName);
  return client.transport.request({
    method: 'POST',
    path: `${_query_assist.ML_COMMONS_API_PREFIX}/agents/${agentId}/_execute`,
    body
  }, AGENT_REQUEST_OPTIONS);
};
exports.getAgentIdAndRequest = getAgentIdAndRequest;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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