/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.LinuxKeyRingAccessor;
import com.azure.identity.implementation.PersistentTokenCacheImpl;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;

public class IntelliJCacheAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCacheAccessor.class);
    public static final String INTELLIJ_TOOLKIT_CACHE = "azure-toolkit.cache.nocae";
    private static final byte[] CRYPTO_KEY = new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99};

    public String getIntelliJCredentialsFromIdentityMsalCache() {
        if (Platform.isMac()) {
            try {
                KeyChainAccessor accessor = new KeyChainAccessor(null, "Microsoft.Developer.IdentityService", INTELLIJ_TOOLKIT_CACHE);
                String jsonCred = new String(accessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(jsonCred);
            }
            catch (Error | Exception e) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + e.getMessage());
            }
        } else if (Platform.isLinux()) {
            try {
                LinuxKeyRingAccessor accessor = new LinuxKeyRingAccessor("com.intellij.credentialStore.Credential", "service", "Microsoft.Developer.IdentityService", "account", "azure-toolkit.cache");
                String jsonCred = new String(accessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(jsonCred);
            }
            catch (Error | Exception e) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + e.getMessage());
            }
        } else if (Platform.isWindows()) {
            try {
                CacheFileAccessor cacheFileAccessor = new CacheFileAccessor(Paths.get(PersistentTokenCacheImpl.DEFAULT_CACHE_FILE_PATH.toString(), File.separator, INTELLIJ_TOOLKIT_CACHE).toString());
                String data = new String(cacheFileAccessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(data);
            }
            catch (Error | Exception e) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + e.getMessage());
            }
        } else {
            LOGGER.verbose(String.format("OS %s Platform not supported.", Platform.getOSType()));
        }
        return null;
    }

    public String parseRefreshTokenFromJson(String jsonString) {
        String string;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)jsonString);
            try {
                string = (String)jsonReader.readObject(reader -> {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("RefreshToken".equals(fieldName)) {
                            reader.nextToken();
                            reader.nextToken();
                            while (reader.nextToken() != JsonToken.END_OBJECT) {
                                String secretFieldName = reader.getFieldName();
                                reader.nextToken();
                                if ("secret".equals(secretFieldName)) {
                                    return reader.getString();
                                }
                                reader.skipChildren();
                            }
                            continue;
                        }
                        reader.skipChildren();
                    }
                    throw new CredentialUnavailableException("IntelliJCredential => Refresh Token not found.");
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.verbose("IntelliJCredential => Refresh Token not found: " + e.getMessage());
                    return null;
                }
            }
            jsonReader.close();
        }
        return string;
    }
}

