/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.httpclient;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.ssl.PrivateKeyDetails;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Node;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;

public class HttpClient
implements Closeable {
    private final KeyStore trustStore;
    private final Logger log = LogManager.getLogger(this.getClass());
    private RestHighLevelClient rclient;
    private String basicCredentials;
    private KeyStore keystore;
    private String keystoreAlias;
    private char[] keyPassword;
    private boolean verifyHostnames;
    private boolean ssl;
    private String[] supportedProtocols;
    private String[] supportedCipherSuites;

    public static HttpClientBuilder builder(String ... servers) {
        return new HttpClientBuilder(servers);
    }

    private HttpClient(KeyStore trustStore, String basicCredentials, KeyStore keystore, char[] keyPassword, String keystoreAlias, boolean verifyHostnames, boolean ssl, String[] supportedProtocols, String[] supportedCipherSuites, String ... servers) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        this.trustStore = trustStore;
        this.basicCredentials = basicCredentials;
        this.keystore = keystore;
        this.keyPassword = keyPassword;
        this.verifyHostnames = verifyHostnames;
        this.ssl = ssl;
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.keystoreAlias = keystoreAlias;
        HttpHost[] hosts = this.createHosts(servers);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        builder.setFailureListener(new RestClient.FailureListener(this){

            public void onFailure(Node node) {
            }
        });
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                try {
                    return HttpClient.this.asyncClientBuilder(httpClientBuilder);
                }
                catch (Exception e) {
                    HttpClient.this.log.error("Unable to build http client", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
        this.rclient = new RestHighLevelClient(builder);
    }

    private HttpHost[] createHosts(String[] servers) {
        return (HttpHost[])Arrays.stream(servers).map(server -> {
            try {
                server = this.addSchemeBasedOnSSL((String)server);
                URI uri = new URI((String)server);
                return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(HttpHost[]::new);
    }

    private String addSchemeBasedOnSSL(String server) {
        server = server.replaceAll("https://|http://", "");
        String protocol = this.ssl ? "https://" : "http://";
        return protocol.concat(server);
    }

    public boolean index(String content, String index, String type, boolean refresh) {
        try {
            IndexRequest ir = new IndexRequest(index);
            IndexResponse response = this.rclient.index(((IndexRequest)ir.setRefreshPolicy(refresh ? WriteRequest.RefreshPolicy.IMMEDIATE : WriteRequest.RefreshPolicy.NONE)).source(content, (MediaType)XContentType.JSON), RequestOptions.DEFAULT);
            return response.getShardInfo().getSuccessful() > 0 && response.getShardInfo().getFailed() == 0;
        }
        catch (Exception e) {
            this.log.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    private final HttpAsyncClientBuilder asyncClientBuilder(HttpAsyncClientBuilder httpClientBuilder) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (this.ssl) {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Configure HTTP client with SSL");
            }
            if (this.trustStore != null) {
                sslContextBuilder.loadTrustMaterial(this.trustStore, null);
            }
            if (this.keystore != null) {
                sslContextBuilder.loadKeyMaterial(this.keystore, this.keyPassword, new PrivateKeyStrategy(){

                    public String chooseAlias(Map<String, PrivateKeyDetails> aliases, SSLParameters sslParameters) {
                        if (aliases == null || aliases.isEmpty()) {
                            return HttpClient.this.keystoreAlias;
                        }
                        if (HttpClient.this.keystoreAlias == null || HttpClient.this.keystoreAlias.isEmpty()) {
                            return aliases.keySet().iterator().next();
                        }
                        return HttpClient.this.keystoreAlias;
                    }
                });
            }
            NoopHostnameVerifier hnv = this.verifyHostnames ? new DefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
            SSLContext sslContext = sslContextBuilder.build();
            DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext, this.supportedProtocols, this.supportedCipherSuites, SSLBufferMode.STATIC, (HostnameVerifier)hnv);
            PoolingAsyncClientConnectionManager cm = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)tlsStrategy).build();
            httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)cm);
        }
        if (this.basicCredentials != null) {
            httpClientBuilder.setDefaultHeaders((Collection)Lists.newArrayList((Object[])new BasicHeader[]{new BasicHeader("Authorization", (Object)("Basic " + this.basicCredentials))}));
        }
        int timeout = 5;
        RequestConfig config = RequestConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).build();
        httpClientBuilder.setDefaultRequestConfig(config);
        return httpClientBuilder;
    }

    @Override
    public void close() throws IOException {
        if (this.rclient != null) {
            this.rclient.close();
        }
    }

    public static class HttpClientBuilder {
        private KeyStore trustStore;
        private String basicCredentials;
        private KeyStore keystore;
        private String keystoreAlias;
        private char[] keyPassword;
        private boolean verifyHostnames;
        private String[] supportedProtocols = null;
        private String[] supportedCipherSuites = null;
        private final String[] servers;
        private boolean ssl;

        private HttpClientBuilder(String ... servers) {
            this.servers = Objects.requireNonNull(servers);
            if (this.servers.length == 0) {
                throw new IllegalArgumentException();
            }
        }

        public HttpClientBuilder enableSsl(KeyStore trustStore, boolean verifyHostnames) {
            this.ssl = true;
            this.trustStore = Objects.requireNonNull(trustStore);
            this.verifyHostnames = verifyHostnames;
            return this;
        }

        public HttpClientBuilder setBasicCredentials(String username, String password) {
            this.basicCredentials = HttpClientBuilder.encodeBasicHeader(Objects.requireNonNull(username), Objects.requireNonNull(password));
            return this;
        }

        public HttpClientBuilder setPkiCredentials(KeyStore keystore, char[] keyPassword, String keystoreAlias) {
            this.keystore = Objects.requireNonNull(keystore);
            this.keyPassword = keyPassword;
            this.keystoreAlias = keystoreAlias;
            return this;
        }

        public HttpClientBuilder setSupportedProtocols(String[] protocols) {
            this.supportedProtocols = protocols;
            return this;
        }

        public HttpClientBuilder setSupportedCipherSuites(String[] cipherSuites) {
            this.supportedCipherSuites = cipherSuites;
            return this;
        }

        public HttpClient build() throws Exception {
            return new HttpClient(this.trustStore, this.basicCredentials, this.keystore, this.keyPassword, this.keystoreAlias, this.verifyHostnames, this.ssl, this.supportedProtocols, this.supportedCipherSuites, this.servers);
        }

        private static String encodeBasicHeader(String username, String password) {
            return Base64.getEncoder().encodeToString((username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8));
        }
    }
}

