/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotationHolder;
import com.jetbrains.python.validation.PyAnnotatorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionHighlightingAnnotator
extends PyAnnotatorBase {
    protected void annotate(@NotNull PsiElement element, @NotNull PyAnnotationHolder holder) {
        if (element == null) {
            PyFunctionHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyFunctionHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/validation/PyFunctionHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVisitor
    extends PyElementVisitor {
        public static final HighlightSeverity LOW_PRIORITY_HIGHLIGHTING = new HighlightSeverity("LOW_PRIORITY_HIGHLIGHTING", HighlightSeverity.INFORMATION.myVal - 3);
        @NotNull
        private final PyAnnotationHolder myHolder;

        private MyVisitor(@NotNull PyAnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitPyParameter(@NotNull PyParameter node) {
            PyFunction function;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null) {
                TextAttributesKey attrKey;
                TextAttributesKey textAttributesKey = attrKey = node.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
                if (MyVisitor.isArgOrKwargParameter(node)) {
                    this.myHolder.addHighlightingAnnotation((PsiElement)node, attrKey);
                } else {
                    this.myHolder.addHighlightingAnnotation(node.getFirstChild(), attrKey);
                }
            }
        }

        private static boolean isArgOrKwargParameter(PyParameter parameter) {
            if (parameter instanceof PyNamedParameter) {
                PyNamedParameter namedParameter = (PyNamedParameter)parameter;
                return namedParameter.isPositionalContainer() || namedParameter.isKeywordContainer();
            }
            return false;
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            PyNamedParameter element;
            PyFunction function;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            String referencedName = node.getReferencedName();
            if (!node.isQualified() && referencedName != null && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null && (element = MyVisitor.findParameterRecursively(function, referencedName)) != null) {
                TextAttributesKey attrKey = element.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
                this.myHolder.addHighlightingAnnotation((PsiElement)node, attrKey);
            }
        }

        public void visitPyKeywordArgument(@NotNull PyKeywordArgument node) {
            ASTNode keywordNode;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((keywordNode = node.getKeywordNode()) != null) {
                this.myHolder.addHighlightingAnnotation(keywordNode, PyHighlighter.PY_KEYWORD_ARGUMENT);
            }
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (node.getParent() instanceof PyDecorator) {
                return;
            }
            PyReferenceExpression callee = PyUtil.as(node.getCallee(), PyReferenceExpression.class);
            if (callee != null) {
                if (!callee.isQualified() && PyBuiltinCache.isInBuiltins((PyExpression)callee)) {
                    return;
                }
                ASTNode functionName = callee.getNameElement();
                if (functionName != null) {
                    TextAttributesKey attrKey = callee.isQualified() ? PyHighlighter.PY_METHOD_CALL : PyHighlighter.PY_FUNCTION_CALL;
                    this.myHolder.addHighlightingAnnotation(functionName, attrKey);
                }
            }
        }

        public void visitPyAnnotation(@NotNull PyAnnotation node) {
            PyExpression value;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((value = node.getValue()) != null) {
                this.myHolder.addHighlightingAnnotation((PsiElement)value, PyHighlighter.PY_ANNOTATION, LOW_PRIORITY_HIGHLIGHTING);
            }
        }

        @Nullable
        private static PyNamedParameter findParameterRecursively(@NotNull PyFunction function, @NotNull String referencedName) {
            if (function == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (referencedName == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            PyFunction f = function;
            while (f != null) {
                PyNamedParameter element = f.getParameterList().findParameterByName(referencedName);
                if (element != null) {
                    return element;
                }
                f = (PyFunction)ObjectUtils.tryCast((Object)ScopeUtil.getScopeOwner((PsiElement)f), PyFunction.class);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/validation/PyFunctionHighlightingAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyKeywordArgument";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAnnotation";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findParameterRecursively";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

