﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class CreateRestoreTestingPlanResult {
 public:
  AWS_BACKUP_API CreateRestoreTestingPlanResult() = default;
  AWS_BACKUP_API CreateRestoreTestingPlanResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API CreateRestoreTestingPlanResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The date and time a restore testing plan was created, in Unix format and
   * Coordinated Universal Time (UTC). The value of <code>CreationTime</code> is
   * accurate to milliseconds. For example, the value 1516925490.087 represents
   * Friday, January 26, 2018 12:11:30.087AM.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  CreateRestoreTestingPlanResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An Amazon Resource Name (ARN) that uniquely identifies the created restore
   * testing plan.</p>
   */
  inline const Aws::String& GetRestoreTestingPlanArn() const { return m_restoreTestingPlanArn; }
  template <typename RestoreTestingPlanArnT = Aws::String>
  void SetRestoreTestingPlanArn(RestoreTestingPlanArnT&& value) {
    m_restoreTestingPlanArnHasBeenSet = true;
    m_restoreTestingPlanArn = std::forward<RestoreTestingPlanArnT>(value);
  }
  template <typename RestoreTestingPlanArnT = Aws::String>
  CreateRestoreTestingPlanResult& WithRestoreTestingPlanArn(RestoreTestingPlanArnT&& value) {
    SetRestoreTestingPlanArn(std::forward<RestoreTestingPlanArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This unique string is the name of the restore testing plan.</p> <p>The name
   * cannot be changed after creation. The name consists of only alphanumeric
   * characters and underscores. Maximum length is 50.</p>
   */
  inline const Aws::String& GetRestoreTestingPlanName() const { return m_restoreTestingPlanName; }
  template <typename RestoreTestingPlanNameT = Aws::String>
  void SetRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    m_restoreTestingPlanNameHasBeenSet = true;
    m_restoreTestingPlanName = std::forward<RestoreTestingPlanNameT>(value);
  }
  template <typename RestoreTestingPlanNameT = Aws::String>
  CreateRestoreTestingPlanResult& WithRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    SetRestoreTestingPlanName(std::forward<RestoreTestingPlanNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateRestoreTestingPlanResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_restoreTestingPlanArn;

  Aws::String m_restoreTestingPlanName;

  Aws::String m_requestId;
  bool m_creationTimeHasBeenSet = false;
  bool m_restoreTestingPlanArnHasBeenSet = false;
  bool m_restoreTestingPlanNameHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
