/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.script;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.script.ImportInfo;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterFactory;
import io.sf.carte.echosvg.script.SecurityHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map<String, InterpreterFactory> defaultFactories = new HashMap<String, InterpreterFactory>(7);
    protected Map<String, InterpreterFactory> factories = new HashMap<String, InterpreterFactory>(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String language) {
        return this.createInterpreter(document, language, null);
    }

    public Interpreter createInterpreter(Document document, String language, ImportInfo imports) {
        InterpreterFactory factory = this.factories.get(language);
        if (factory == null) {
            return null;
        }
        if (imports == null) {
            imports = ImportInfo.getImports();
        }
        Interpreter interpreter = null;
        SVGOMDocument svgDoc = (SVGOMDocument)document;
        URL url = null;
        try {
            url = new URL(svgDoc.getDocumentURI());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        interpreter = InterpreterPool.createInterpreter(factory, url, svgDoc.isSVG12(), imports);
        if (interpreter == null) {
            return null;
        }
        interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        return interpreter;
    }

    private static Interpreter createInterpreter(final InterpreterFactory factory, final URL documentURL, final boolean svg12, final ImportInfo imports) {
        PrivilegedExceptionAction<Interpreter> pea = new PrivilegedExceptionAction<Interpreter>(){

            @Override
            public Interpreter run() throws Exception {
                return factory.createInterpreter(documentURL, svg12, imports);
            }
        };
        try {
            return (Interpreter)SecurityHelper.getInstance().runPrivilegedExceptionAction(pea);
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            ex.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void putInterpreterFactory(String language, InterpreterFactory factory) {
        this.factories.put(language, factory);
    }

    public void removeInterpreterFactory(String language) {
        this.factories.remove(language);
    }

    static {
        ServiceLoader<InterpreterFactory> loader = ServiceLoader.load(InterpreterFactory.class);
        Iterator<InterpreterFactory> iter = loader.iterator();
        while (iter.hasNext()) {
            String[] mimeTypes;
            InterpreterFactory factory = null;
            factory = iter.next();
            for (String mimeType : mimeTypes = factory.getMimeTypes()) {
                defaultFactories.put(mimeType, factory);
            }
        }
    }
}

