/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.configuration.DefaultBuildClientMetaData;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonConnectionBackedEventConsumer;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class ExecuteBuild
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(ExecuteBuild.class);
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> actionExecuter;
    private final DaemonRunningStats runningStats;

    public ExecuteBuild(BuildActionExecutor<BuildActionParameters, BuildRequestContext> actionExecuter, DaemonRunningStats runningStats) {
        this.actionExecuter = actionExecuter;
        this.runningStats = runningStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        LOGGER.debug("The daemon has started executing the build.");
        LOGGER.debug("Executing build with daemon context: {}", (Object)execution.getDaemonContext());
        this.runningStats.buildStarted();
        DaemonConnectionBackedEventConsumer buildEventConsumer = new DaemonConnectionBackedEventConsumer(execution);
        try {
            BuildCancellationToken cancellationToken = execution.getDaemonStateControl().getCancellationToken();
            DefaultBuildClientMetaData clientMetaData = new DefaultBuildClientMetaData(build.getBuildClientMetaData());
            DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData((BuildClientMetaData)clientMetaData, build.getStartTime(), build.isInteractive());
            DefaultBuildRequestContext buildRequestContext = new DefaultBuildRequestContext((BuildRequestMetaData)buildRequestMetaData, cancellationToken, (BuildEventConsumer)buildEventConsumer);
            if (!build.getAction().getStartParameter().isContinuous()) {
                buildRequestContext.getCancellationToken().addCallback(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.info("The daemon has received a build cancellation request.");
                    }
                });
            }
            BuildActionResult result = this.actionExecuter.execute(build.getAction(), (Object)build.getParameters(), (Object)buildRequestContext);
            execution.setResult(result);
        }
        finally {
            buildEventConsumer.waitForFinish();
            this.runningStats.buildFinished();
            LOGGER.debug("The daemon has finished executing the build.");
        }
        execution.proceed();
    }
}

