/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.Locale;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Build.class, Scope.Settings.class, Scope.Project.class})
public abstract class ConfigurationTargetIdentifier {
    private ConfigurationTargetIdentifier() {
    }

    public abstract Type getTargetType();

    public abstract @Nullable String getTargetPath();

    public abstract String getBuildPath();

    public static @Nullable ConfigurationTargetIdentifier of(Object any) {
        if (any instanceof PluginAwareInternal) {
            return ((PluginAwareInternal)any).getConfigurationTargetIdentifier();
        }
        return null;
    }

    public static ConfigurationTargetIdentifier of(final ProjectIdentity projectIdentity) {
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.PROJECT;
            }

            @Override
            public String getTargetPath() {
                return projectIdentity.getProjectPath().asString();
            }

            @Override
            public String getBuildPath() {
                return projectIdentity.getBuildPath().asString();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(SettingsInternal settings) {
        final Path buildPath = settings.getGradle().getOwner().getIdentityPath();
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.SETTINGS;
            }

            @Override
            public @Nullable String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return buildPath.asString();
            }
        };
    }

    public static ConfigurationTargetIdentifier of(GradleInternal gradle) {
        final Path buildPath = gradle.getOwner().getIdentityPath();
        return new ConfigurationTargetIdentifier(){

            @Override
            public Type getTargetType() {
                return Type.GRADLE;
            }

            @Override
            public @Nullable String getTargetPath() {
                return null;
            }

            @Override
            public String getBuildPath() {
                return buildPath.asString();
            }
        };
    }

    public static enum Type {
        GRADLE,
        SETTINGS,
        PROJECT;

        public final String label = this.name().toLowerCase(Locale.ROOT);
    }
}

