/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.HKDF;
import sun.security.ssl.Record;
import sun.security.ssl.SSLKeyDerivation;

final class SSLBasicKeyDerivation
implements SSLKeyDerivation {
    private final String hashAlg;
    private final SecretKey secret;
    private final byte[] hkdfInfo;

    SSLBasicKeyDerivation(SecretKey secretKey, String string, byte[] byArray, byte[] byArray2, int n) {
        this.hashAlg = string.replace("-", "");
        this.secret = secretKey;
        this.hkdfInfo = SSLBasicKeyDerivation.createHkdfInfo(byArray, byArray2, n);
    }

    @Override
    public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
        try {
            HKDF hKDF = new HKDF(this.hashAlg);
            return hKDF.expand(this.secret, this.hkdfInfo, ((SecretSizeSpec)algorithmParameterSpec).length, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
        }
    }

    private static byte[] createHkdfInfo(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[4 + byArray.length + byArray2.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        try {
            Record.putInt16(byteBuffer, n);
            Record.putBytes8(byteBuffer, byArray);
            Record.putBytes8(byteBuffer, byArray2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray3;
    }

    static class SecretSizeSpec
    implements AlgorithmParameterSpec {
        final int length;

        SecretSizeSpec(int n) {
            this.length = n;
        }
    }
}

