/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitContributionBuildItem;
import io.quarkus.hibernate.orm.deployment.xml.QuarkusMappingFileParser;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManagedType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitDefaultsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class JpaJandexScavenger {
    public static final List<DotName> EMBEDDED_ANNOTATIONS = Arrays.asList(ClassNames.EMBEDDED_ID, ClassNames.EMBEDDED);
    private static final String XML_MAPPING_DEFAULT_ORM_XML = "META-INF/orm.xml";
    private static final String XML_MAPPING_NO_FILE = "no-file";
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private final BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles;
    private final List<JpaModelPersistenceUnitContributionBuildItem> persistenceUnitContributions;
    private final IndexView index;
    private final Set<String> ignorableNonIndexedClasses;

    JpaJandexScavenger(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, List<JpaModelPersistenceUnitContributionBuildItem> persistenceUnitContributions, IndexView index, Set<String> ignorableNonIndexedClasses) {
        this.reflectiveClass = reflectiveClass;
        this.hotDeploymentWatchedFiles = hotDeploymentWatchedFiles;
        this.persistenceUnitContributions = persistenceUnitContributions;
        this.index = index;
        this.ignorableNonIndexedClasses = ignorableNonIndexedClasses;
    }

    public JpaModelBuildItem discoverModelAndRegisterForReflection() throws BuildException {
        Collector collector = new Collector();
        for (DotName dotName : ClassNames.PACKAGE_ANNOTATIONS) {
            this.enlistJPAModelAnnotatedPackages(collector, dotName);
        }
        this.enlistJPAModelClasses(collector, ClassNames.JPA_ENTITY);
        this.enlistJPAModelClasses(collector, ClassNames.EMBEDDABLE);
        this.enlistJPAModelClasses(collector, ClassNames.MAPPED_SUPERCLASS);
        this.enlistJPAModelIdClasses(collector, ClassNames.ID_CLASS);
        this.enlistEmbeddedsAndElementCollections(collector);
        this.enlistPotentialCdiBeanClasses(collector, ClassNames.CONVERTER);
        for (DotName dotName : ClassNames.JPA_LISTENER_ANNOTATIONS) {
            this.enlistPotentialCdiBeanClasses(collector, dotName);
        }
        this.enlistPotentialClassReferences(collector, ClassNames.GENERIC_GENERATOR, "type", "strategy");
        this.enlistPotentialClassReferences(collector, ClassNames.ID_GENERATOR_TYPE, "value");
        this.enlistPotentialClassReferences(collector, ClassNames.VALUE_GENERATION_TYPE, "generatedBy");
        for (JpaModelPersistenceUnitContributionBuildItem jpaModelPersistenceUnitContributionBuildItem : this.persistenceUnitContributions) {
            this.enlistExplicitMappings(collector, jpaModelPersistenceUnitContributionBuildItem);
        }
        HashSet<String> managedClassNames = new HashSet<String>(collector.entityTypes);
        managedClassNames.addAll(collector.modelTypes);
        for (String className : managedClassNames) {
            this.reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().fields().build());
            this.reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className + "_"}).fields().build());
        }
        if (!collector.enumTypes.isEmpty()) {
            this.reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.lang.Enum"}).methods().build());
            for (String className : collector.enumTypes) {
                this.reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().build());
            }
        }
        for (String javaType : collector.javaTypes) {
            this.reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{javaType}).methods().build());
        }
        if (!collector.unindexedClasses.isEmpty()) {
            Set set = collector.unindexedClasses.stream().map(DotName::toString).collect(Collectors.toSet());
            set.removeAll(this.ignorableNonIndexedClasses);
            if (!set.isEmpty()) {
                String unindexedClassesErrorMessage = set.stream().map(d -> "\t- " + d + "\n").collect(Collectors.joining());
                throw new ConfigurationException("Unable to properly register the hierarchy of the following JPA classes as they are not in the Jandex index:\n" + unindexedClassesErrorMessage + "Consider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.");
            }
        }
        return new JpaModelBuildItem(collector.packages, collector.entityTypes, managedClassNames, collector.potentialCdiBeanTypes, collector.xmlMappingsByPU);
    }

    private void enlistExplicitMappings(Collector collector, JpaModelPersistenceUnitContributionBuildItem persistenceUnitContribution) {
        for (String className : persistenceUnitContribution.explicitlyListedClassNames) {
            this.enlistExplicitClass(collector, className);
        }
        LinkedHashSet<String> mappingFileNames = new LinkedHashSet<String>(persistenceUnitContribution.explicitlyListedMappingFiles);
        if (!mappingFileNames.remove(XML_MAPPING_NO_FILE)) {
            mappingFileNames.add(XML_MAPPING_DEFAULT_ORM_XML);
        }
        try (QuarkusMappingFileParser parser = QuarkusMappingFileParser.create();){
            for (String mappingFileName : mappingFileNames) {
                this.hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(mappingFileName));
                Optional<RecordableXmlMapping> mappingOptional = parser.parse(persistenceUnitContribution.persistenceUnitName, persistenceUnitContribution.persistenceUnitRootURL, mappingFileName);
                if (!mappingOptional.isPresent()) {
                    if (!persistenceUnitContribution.explicitlyListedMappingFiles.contains(mappingFileName)) continue;
                    throw new IllegalStateException("Cannot find ORM mapping file '" + mappingFileName + "' in the classpath");
                }
                RecordableXmlMapping mapping = mappingOptional.get();
                if (mapping.getOrmXmlRoot() != null) {
                    this.enlistOrmXmlMapping(collector, mapping.getOrmXmlRoot());
                }
                if (mapping.getHbmXmlRoot() != null) {
                    this.enlistHbmXmlMapping(collector, mapping.getHbmXmlRoot());
                }
                collector.xmlMappingsByPU.computeIfAbsent(persistenceUnitContribution.persistenceUnitName, ignored -> new ArrayList()).add(mapping);
            }
        }
    }

    private void enlistOrmXmlMapping(Collector collector, JaxbEntityMappingsImpl mapping) {
        JaxbPersistenceUnitDefaultsImpl defaults;
        String packageName = mapping.getPackage();
        Object packagePrefix = packageName == null ? "" : packageName + ".";
        JaxbPersistenceUnitMetadataImpl metadata = mapping.getPersistenceUnitMetadata();
        JaxbPersistenceUnitDefaultsImpl jaxbPersistenceUnitDefaultsImpl = defaults = metadata == null ? null : metadata.getPersistenceUnitDefaults();
        if (defaults != null) {
            this.enlistOrmXmlMappingListeners(collector, (String)packagePrefix, defaults.getEntityListenerContainer());
        }
        for (JaxbEntityImpl entity : mapping.getEntities()) {
            this.enlistOrmXmlMappingManagedClass(collector, (String)packagePrefix, (JaxbEntityOrMappedSuperclass)entity, "entity");
        }
        for (JaxbMappedSuperclassImpl mappedSuperclass : mapping.getMappedSuperclasses()) {
            this.enlistOrmXmlMappingManagedClass(collector, (String)packagePrefix, (JaxbEntityOrMappedSuperclass)mappedSuperclass, "mapped-superclass");
        }
        for (JaxbEmbeddableImpl embeddable : mapping.getEmbeddables()) {
            String name = JpaJandexScavenger.safeGetClassName((String)packagePrefix, (JaxbManagedType)embeddable, "embeddable");
            this.enlistExplicitClass(collector, name);
        }
        for (JaxbConverterImpl converter : mapping.getConverters()) {
            collector.potentialCdiBeanTypes.add(DotName.createSimple((String)JpaJandexScavenger.qualifyIfNecessary((String)packagePrefix, converter.getClazz())));
        }
    }

    private void enlistOrmXmlMappingManagedClass(Collector collector, String packagePrefix, JaxbEntityOrMappedSuperclass managed, String nodeName) {
        String name = JpaJandexScavenger.safeGetClassName(packagePrefix, (JaxbManagedType)managed, nodeName);
        this.enlistExplicitClass(collector, name);
        if (managed instanceof JaxbEntity) {
            JaxbEntity entity = (JaxbEntity)managed;
            collector.entityTypes.add(name);
            if (entity.getGenericGenerator() != null) {
                JaxbGenericIdGeneratorImpl generator = entity.getGenericGenerator();
                this.enlistPotentialClassReference(collector, generator == null ? null : generator.getClazz());
            }
        }
        this.enlistOrmXmlMappingListeners(collector, packagePrefix, managed.getEntityListenerContainer());
    }

    private void enlistOrmXmlMappingListeners(Collector collector, String packagePrefix, JaxbEntityListenerContainerImpl entityListeners) {
        if (entityListeners == null) {
            return;
        }
        for (JaxbEntityListenerImpl listener : entityListeners.getEntityListeners()) {
            collector.potentialCdiBeanTypes.add(DotName.createSimple((String)JpaJandexScavenger.qualifyIfNecessary(packagePrefix, listener.getClazz())));
        }
    }

    private static String safeGetClassName(String packagePrefix, JaxbManagedType managedType, String nodeName) {
        String name = managedType.getClazz();
        if (name == null) {
            throw new IllegalArgumentException("Missing attribute '" + nodeName + ".class'");
        }
        return JpaJandexScavenger.qualifyIfNecessary(packagePrefix, name);
    }

    private static String qualifyIfNecessary(String packagePrefix, String name) {
        if (name.indexOf(46) < 0) {
            return packagePrefix + name;
        }
        return name;
    }

    private void enlistHbmXmlMapping(Collector collector, JaxbHbmHibernateMapping mapping) {
        String packageValue = mapping.getPackage();
        Object packagePrefix = packageValue == null ? "" : packageValue + ".";
        for (JaxbHbmRootEntityType entity : mapping.getClazz()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)entity, entity.getAttributes());
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getUnionSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
            for (JaxbHbmDiscriminatorSubclassEntityType subclass : entity.getJoinedSubclass()) {
                this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
            }
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getUnionSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
        for (JaxbHbmDiscriminatorSubclassEntityType subclass : mapping.getJoinedSubclass()) {
            this.enlistHbmXmlEntity(collector, (String)packagePrefix, (JaxbHbmEntityBaseDefinition)subclass, subclass.getAttributes());
        }
    }

    private void enlistHbmXmlEntity(Collector collector, String packagePrefix, JaxbHbmEntityBaseDefinition entityDefinition, List<?> attributes) {
        String name = packagePrefix + entityDefinition.getName();
        this.enlistExplicitClass(collector, name);
        collector.entityTypes.add(name);
        this.collectHbmXmlEmbeddedTypes(collector, packagePrefix, attributes);
    }

    private void collectHbmXmlEmbeddedTypes(Collector collector, String packagePrefix, List<?> attributes) {
        for (Object attribute : attributes) {
            if (!(attribute instanceof JaxbHbmCompositeAttributeType)) continue;
            JaxbHbmCompositeAttributeType compositeAttribute = (JaxbHbmCompositeAttributeType)attribute;
            String name = packagePrefix + compositeAttribute.getClazz();
            this.enlistExplicitClass(collector, name);
            collector.entityTypes.add(name);
            this.collectHbmXmlEmbeddedTypes(collector, packagePrefix, compositeAttribute.getAttributes());
        }
    }

    private void enlistExplicitClass(Collector collector, String className) {
        DotName dotName = DotName.createSimple((String)className);
        this.addClassHierarchyToReflectiveList(collector, dotName);
    }

    private void enlistEmbeddedsAndElementCollections(Collector collector) throws BuildException {
        HashSet<DotName> embeddedTypes = new HashSet<DotName>();
        for (DotName embeddedAnnotation : EMBEDDED_ANNOTATIONS) {
            block9: for (AnnotationInstance annotation : this.index.getAnnotations(embeddedAnnotation)) {
                AnnotationTarget target = annotation.target();
                switch (target.kind()) {
                    case FIELD: {
                        FieldInfo field = target.asField();
                        this.collectEmbeddedType(embeddedTypes, field.declaringClass(), (Declaration)field, field.type(), true);
                        continue block9;
                    }
                    case METHOD: {
                        MethodInfo method = target.asMethod();
                        if (method.isBridge()) continue block9;
                        this.collectEmbeddedType(embeddedTypes, method.declaringClass(), (Declaration)method, method.returnType(), true);
                        continue block9;
                    }
                }
                throw new IllegalStateException("[internal error] " + String.valueOf(embeddedAnnotation) + " placed on a unknown element: " + String.valueOf(target));
            }
        }
        block10: for (AnnotationInstance annotation : this.index.getAnnotations(ClassNames.ELEMENT_COLLECTION)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case FIELD: {
                    FieldInfo field = target.asField();
                    this.collectElementCollectionTypes(embeddedTypes, field.declaringClass(), (Declaration)field, field.type());
                    continue block10;
                }
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    if (method.isBridge()) continue block10;
                    this.collectElementCollectionTypes(embeddedTypes, method.declaringClass(), (Declaration)method, method.returnType());
                    continue block10;
                }
            }
            throw new IllegalStateException("[internal error] " + String.valueOf(ClassNames.ELEMENT_COLLECTION) + " placed on a unknown element: " + String.valueOf(target));
        }
        for (DotName embeddedType : embeddedTypes) {
            this.addClassHierarchyToReflectiveList(collector, embeddedType);
        }
    }

    private void enlistJPAModelAnnotatedPackages(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass;
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || !(klass = annotation.target().asClass()).simpleName().equals("package-info")) continue;
            JpaJandexScavenger.collectPackage(collector, klass);
        }
    }

    private void enlistJPAModelClasses(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass = annotation.target().asClass();
            DotName targetDotName = klass.name();
            this.addClassHierarchyToReflectiveList(collector, targetDotName);
            JpaJandexScavenger.collectModelType(collector, klass);
        }
    }

    private void enlistJPAModelIdClasses(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            DotName targetDotName = annotation.value().asClass().name();
            this.addClassHierarchyToReflectiveList(collector, targetDotName);
            collector.modelTypes.add(targetDotName.toString());
        }
    }

    private void enlistPotentialCdiBeanClasses(Collector collector, DotName dotName) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            AnnotationTarget target = annotation.target();
            ClassInfo beanType = switch (target.kind()) {
                case AnnotationTarget.Kind.CLASS -> target.asClass();
                case AnnotationTarget.Kind.FIELD -> target.asField().declaringClass();
                case AnnotationTarget.Kind.METHOD -> target.asMethod().declaringClass();
                default -> throw new IllegalArgumentException("Annotation " + String.valueOf(dotName) + " was not expected on a target of kind " + String.valueOf(target.kind()));
            };
            DotName beanTypeDotName = beanType.name();
            collector.potentialCdiBeanTypes.add(beanTypeDotName);
        }
    }

    private void enlistPotentialClassReferences(Collector collector, DotName dotName, String ... referenceAttributes) {
        Collection jpaAnnotations = this.index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            for (String referenceAttribute : referenceAttributes) {
                AnnotationValue referenceValue = annotation.value(referenceAttribute);
                if (referenceValue == null) continue;
                String reference = switch (referenceValue.kind()) {
                    case AnnotationValue.Kind.CLASS -> referenceValue.asClass().name().toString();
                    case AnnotationValue.Kind.STRING -> {
                        String stringRef = referenceValue.asString();
                        if (stringRef.isEmpty() || this.index.getClassByName(stringRef) == null) {
                            yield null;
                        }
                        yield stringRef;
                    }
                    default -> null;
                };
                this.enlistPotentialClassReference(collector, reference);
            }
        }
    }

    private void enlistPotentialClassReference(Collector collector, String reference) {
        if (reference == null) {
            return;
        }
        collector.javaTypes.add(reference);
    }

    private void addClassHierarchyToReflectiveList(Collector collector, DotName className) {
        if (className == null || JpaJandexScavenger.isIgnored(className)) {
            return;
        }
        if (JpaJandexScavenger.isInJavaPackage(className)) {
            collector.javaTypes.add(className.toString());
            return;
        }
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            collector.unindexedClasses.add(className);
            return;
        }
        for (FieldInfo fieldInfo : classInfo.fields()) {
            DotName fieldClassName;
            ClassInfo fieldTypeClassInfo;
            Type fieldType = fieldInfo.type();
            if (Type.Kind.CLASS != fieldType.kind() || (fieldTypeClassInfo = this.index.getClassByName(fieldClassName = fieldInfo.type().name())) == null || !ClassNames.ENUM.equals((Object)fieldTypeClassInfo.superName())) continue;
            collector.enumTypes.add(fieldClassName.toString());
        }
        JpaJandexScavenger.collectModelType(collector, classInfo);
        this.addClassHierarchyToReflectiveList(collector, classInfo.superName());
        for (DotName interfaceDotName : classInfo.interfaceNames()) {
            this.addClassHierarchyToReflectiveList(collector, interfaceDotName);
        }
    }

    private static void collectPackage(Collector collector, ClassInfo classOrPackageInfo) {
        String classOrPackageInfoName = classOrPackageInfo.name().toString();
        String packageName = classOrPackageInfoName.substring(0, classOrPackageInfoName.lastIndexOf(46));
        collector.packages.add(packageName);
    }

    private static void collectModelType(Collector collector, ClassInfo modelClass) {
        String name = modelClass.name().toString();
        collector.modelTypes.add(name);
        if (modelClass.declaredAnnotation(ClassNames.JPA_ENTITY) != null) {
            collector.entityTypes.add(name);
        }
    }

    private void collectEmbeddedType(Set<DotName> embeddedTypes, ClassInfo declaringClass, Declaration attribute, Type attributeType, boolean validate) throws BuildException {
        DotName className;
        switch (attributeType.kind()) {
            case CLASS: {
                className = attributeType.asClassType().name();
                break;
            }
            case PARAMETERIZED_TYPE: {
                className = attributeType.name();
                break;
            }
            default: {
                return;
            }
        }
        if (validate && !this.index.getClassByName(className).hasAnnotation(ClassNames.EMBEDDABLE)) {
            throw new BuildException("Type " + String.valueOf(className) + " must be annotated with @Embeddable, because it is used as an embeddable. This type is used in class " + String.valueOf(declaringClass) + " for attribute " + String.valueOf(attribute) + ".");
        }
        embeddedTypes.add(attributeType.name());
    }

    private void collectElementCollectionTypes(Set<DotName> embeddedTypes, ClassInfo declaringClass, Declaration attribute, Type attributeType) throws BuildException {
        switch (attributeType.kind()) {
            case CLASS: {
                break;
            }
            case PARAMETERIZED_TYPE: {
                embeddedTypes.add(attributeType.name());
                List typeArguments = attributeType.asParameterizedType().arguments();
                for (Type typeArgument : typeArguments) {
                    this.collectEmbeddedType(embeddedTypes, declaringClass, attribute, typeArgument, false);
                }
                break;
            }
            case ARRAY: {
                this.collectEmbeddedType(embeddedTypes, declaringClass, attribute, attributeType.asArrayType().constituent(), true);
                break;
            }
        }
    }

    private static boolean isIgnored(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.util.") || className.startsWith("java.lang.") || className.startsWith("org.hibernate.engine.spi.") || className.startsWith("jakarta.persistence.") || className.startsWith("jakarta.persistence.");
    }

    private static boolean isInJavaPackage(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.");
    }

    private static class Collector {
        final Set<String> packages = new HashSet<String>();
        final Set<String> entityTypes = new HashSet<String>();
        final Set<DotName> potentialCdiBeanTypes = new HashSet<DotName>();
        final Set<String> modelTypes = new HashSet<String>();
        final Set<String> enumTypes = new HashSet<String>();
        final Set<String> javaTypes = new HashSet<String>();
        final Set<DotName> unindexedClasses = new HashSet<DotName>();
        final Map<String, List<RecordableXmlMapping>> xmlMappingsByPU = new HashMap<String, List<RecordableXmlMapping>>();

        private Collector() {
        }
    }
}

