/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.common.util.PemUtils;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.http.FormPartValue;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.Strings;

public class CertificateInfoHelper {
    public static final String CERTIFICATE_PEM = "Certificate PEM";
    public static final String PUBLIC_KEY_PEM = "Public Key PEM";
    public static final String JSON_WEB_KEY_SET = "JSON Web Key Set";
    private static final Logger logger = Logger.getLogger(CertificateInfoHelper.class);
    public static final String PRIVATE_KEY = "private.key";
    public static final String X509CERTIFICATE = "certificate";
    public static final String PUBLIC_KEY = "public.key";
    public static final String KID = "kid";

    public static CertificateRepresentation getCertificateFromClient(ClientModel client, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if ("openid-connect".equals(client.getProtocol()) && Boolean.parseBoolean(client.getAttribute("use.jwks.string"))) {
            return CertificateInfoHelper.jwksStringToSigCertificateRepresentation(client.getAttribute("jwks.string"));
        }
        CertificateRepresentation rep = new CertificateRepresentation();
        rep.setCertificate(client.getAttribute(certificateAttribute));
        rep.setPublicKey(client.getAttribute(publicKeyAttribute));
        rep.setPrivateKey(client.getAttribute(privateKeyAttribute));
        rep.setKid(client.getAttribute(kidAttribute));
        return rep;
    }

    public static CertificateRepresentation jwksStringToSigCertificateRepresentation(String jwks) {
        if (jwks == null) {
            throw new IllegalStateException("The jwks is null!");
        }
        try {
            JSONWebKeySet keySet = (JSONWebKeySet)JsonSerialization.readValue((String)jwks, JSONWebKeySet.class);
            if (keySet == null || keySet.getKeys() == null) {
                throw new IllegalStateException("Certificate not found");
            }
            JWK publicKeyJwk = JWKSUtils.getKeyForUse((JSONWebKeySet)keySet, (JWK.Use)JWK.Use.SIG);
            if (publicKeyJwk == null) {
                throw new IllegalStateException("Certificate not found for use sig");
            }
            PublicKey publicKey = JWKParser.create((JWK)publicKeyJwk).toPublicKey();
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            CertificateRepresentation info = new CertificateRepresentation();
            info.setJwks(jwks);
            info.setPublicKey(publicKeyPem);
            info.setKid(publicKeyJwk.getKeyId());
            return info;
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid jwks representation!", e);
        }
    }

    public static void updateClientModelCertificateInfo(ClientModel client, CertificateRepresentation rep, String attributePrefix) {
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
        if ("openid-connect".equals(client.getProtocol())) {
            CertificateInfoHelper.setOrRemoveAttr(client, "use.jwks.string", null);
            CertificateInfoHelper.setOrRemoveAttr(client, "jwks.string", null);
        }
    }

    public static void updateClientModelJwksString(ClientModel client, String attributePrefix, String jwks) {
        if (jwks == null) {
            throw new IllegalStateException("jwks string is null!");
        }
        if (!"openid-connect".equals(client.getProtocol())) {
            throw new IllegalStateException("jwks can only be set for OIDC clients!");
        }
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, null);
        CertificateInfoHelper.setOrRemoveAttr(client, "use.jwks.string", Boolean.TRUE.toString());
        CertificateInfoHelper.setOrRemoveAttr(client, "jwks.string", jwks);
    }

    private static void setOrRemoveAttr(ClientModel client, String attrName, String attrValue) {
        if (attrValue != null) {
            client.setAttribute(attrName, attrValue);
        } else {
            client.removeAttribute(attrName);
        }
    }

    public static void updateClientRepresentationCertificateInfo(ClientRepresentation client, CertificateRepresentation rep, String attributePrefix) {
        String privateKeyAttribute = attributePrefix + ".private.key";
        String certificateAttribute = attributePrefix + ".certificate";
        String publicKeyAttribute = attributePrefix + ".public.key";
        String kidAttribute = attributePrefix + ".kid";
        if (rep.getPublicKey() == null && rep.getCertificate() == null) {
            throw new IllegalStateException("Both certificate and publicKey are null!");
        }
        if (rep.getPublicKey() != null && rep.getCertificate() != null) {
            throw new IllegalStateException("Both certificate and publicKey are not null!");
        }
        CertificateInfoHelper.setOrRemoveAttr(client, privateKeyAttribute, rep.getPrivateKey());
        CertificateInfoHelper.setOrRemoveAttr(client, publicKeyAttribute, rep.getPublicKey());
        CertificateInfoHelper.setOrRemoveAttr(client, certificateAttribute, rep.getCertificate());
        CertificateInfoHelper.setOrRemoveAttr(client, kidAttribute, rep.getKid());
    }

    public static CertificateRepresentation getCertificateFromRequest(KeycloakSession session) throws IOException {
        CertificateRepresentation info = new CertificateRepresentation();
        MultivaluedMap uploadForm = session.getContext().getHttpRequest().getMultiPartFormParameters();
        FormPartValue keystoreFormatPart = (FormPartValue)uploadForm.getFirst((Object)"keystoreFormat");
        if (keystoreFormatPart == null) {
            throw new BadRequestException("keystoreFormat cannot be null");
        }
        String keystoreFormat = keystoreFormatPart.asString();
        FormPartValue inputParts = (FormPartValue)uploadForm.getFirst((Object)"file");
        boolean fileEmpty = false;
        try {
            fileEmpty = inputParts == null || Strings.isEmpty((String)inputParts.asString()) != false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileEmpty) {
            throw new BadRequestException("file cannot be empty");
        }
        if (keystoreFormat.equals(CERTIFICATE_PEM)) {
            String pem = StreamUtil.readString((InputStream)inputParts.asInputStream(), (Charset)StandardCharsets.UTF_8);
            pem = PemUtils.removeBeginEnd((String)pem);
            KeycloakModelUtils.getCertificate((String)pem);
            info.setCertificate(pem);
            return info;
        }
        if (keystoreFormat.equals(PUBLIC_KEY_PEM)) {
            String pem = StreamUtil.readString((InputStream)inputParts.asInputStream(), (Charset)StandardCharsets.UTF_8);
            KeycloakModelUtils.getPublicKey((String)pem);
            info.setPublicKey(pem);
            return info;
        }
        if (keystoreFormat.equals(JSON_WEB_KEY_SET)) {
            String jwks = StreamUtil.readString((InputStream)inputParts.asInputStream(), (Charset)StandardCharsets.UTF_8);
            info = CertificateInfoHelper.jwksStringToSigCertificateRepresentation(jwks);
            return info;
        }
        String keyAlias = ((FormPartValue)uploadForm.getFirst((Object)"keyAlias")).asString();
        FormPartValue keyPasswordPart = (FormPartValue)uploadForm.getFirst((Object)"keyPassword");
        char[] keyPassword = keyPasswordPart != null ? keyPasswordPart.asString().toCharArray() : null;
        FormPartValue storePasswordPart = (FormPartValue)uploadForm.getFirst((Object)"storePassword");
        char[] storePassword = storePasswordPart != null ? storePasswordPart.asString().toCharArray() : null;
        PrivateKey privateKey = null;
        X509Certificate certificate = null;
        try {
            KeyStore keyStore = CryptoIntegration.getProvider().getKeyStore(KeystoreUtil.KeystoreFormat.valueOf((String)keystoreFormat));
            keyStore.load(inputParts.asInputStream(), storePassword);
            try {
                privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
            }
            catch (Exception exception) {
                // empty catch block
            }
            certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading keystore", (Throwable)e);
            Throwable throwable = e.getCause();
            if (throwable instanceof UnrecoverableKeyException) {
                UnrecoverableKeyException keyException = (UnrecoverableKeyException)throwable;
                throw new BadRequestException(keyException.getMessage());
            }
            throw new BadRequestException("error loading keystore");
        }
        if (privateKey != null) {
            String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
            info.setPrivateKey(privateKeyPem);
        }
        if (certificate != null) {
            String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
            info.setCertificate(certPem);
        }
        return info;
    }

    private static void setOrRemoveAttr(ClientRepresentation client, String attrName, String attrValue) {
        if (attrValue != null) {
            if (client.getAttributes() == null) {
                client.setAttributes(new HashMap());
            }
            client.getAttributes().put(attrName, attrValue);
        } else if (client.getAttributes() != null) {
            client.getAttributes().remove(attrName);
        }
    }
}

