/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MapsId;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfileOverride;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.FetchSecondPass;
import org.hibernate.boot.model.internal.ImplicitToOneJoinTableSecondPass;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.OneToOneSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.type.ForeignKeyDirection;

public class ToOneBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ToOneBinder.class);

    static void bindManyToOne(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder) {
        MemberDetails property = inferredData.getAttributeMember();
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        if (property.hasDirectAnnotationUsage(Column.class) || property.hasDirectAnnotationUsage(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@ManyToOne' association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@ManyToOne' association and cannot be used as identifier");
        }
        Cascade hibernateCascade = (Cascade)property.getDirectAnnotationUsage(Cascade.class);
        ToOneBinder.bindManyToOne(BinderHelper.aggregateCascadeTypes(manyToOne.cascade(), hibernateCascade, false, context), joinColumns, propertyHolder, nullability, inferredData, manyToOne.fetch(), manyToOne.optional(), false, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static boolean isIdentifier(PropertyHolder propertyHolder, PropertyBinder propertyBinder, boolean isIdentifierMapper) {
        return propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass() || isIdentifierMapper;
    }

    private static boolean isMandatory(boolean optional, MemberDetails property, NotFoundAction notFoundAction) {
        return !optional || property.hasDirectAnnotationUsage(Id.class) || property.hasDirectAnnotationUsage(MapsId.class) && notFoundAction != NotFoundAction.IGNORE;
    }

    private static void bindManyToOne(EnumSet<CascadeType> cascadeStrategy, AnnotatedJoinColumns joinColumns, PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, FetchType fetchType, boolean explicitlyOptional, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        ManyToOne manyToOne;
        MemberDetails property = inferredData.getAttributeMember();
        NotFoundAction notFoundAction = ToOneBinder.notFoundAction(propertyHolder, property, fetchType);
        OnDeleteAction onDeleteAction = ToOneBinder.onDeleteAction(property);
        boolean optional = !ToOneBinder.isMandatory(explicitlyOptional, property, notFoundAction);
        JoinTable joinTable = propertyHolder.getJoinTable(property);
        ManyToOne manyToOne2 = manyToOne = joinTable == null ? new ManyToOne(context, joinColumns.getTable()) : ToOneBinder.handleJoinTable(joinColumns, joinTable, notFoundAction, propertyHolder, inferredData, context);
        if (unique) {
            manyToOne.markAsLogicalOneToOne();
        }
        ClassDetails targetEntity = ToOneBinder.getTargetEntity(inferredData, context);
        manyToOne.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntity));
        ToOneBinder.defineFetchingStrategy(manyToOne, property, inferredData, propertyHolder);
        manyToOne.setNotFoundAction(notFoundAction);
        manyToOne.setOnDeleteAction(onDeleteAction);
        if (!optional && nullability != Nullability.FORCED_NULL) {
            for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
                column.setNullable(false);
            }
        }
        if (property.hasDirectAnnotationUsage(MapsId.class)) {
            for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
                column.setInsertable(false);
                column.setUpdatable(false);
            }
            joinColumns.setMapsId(((MapsId)property.getDirectAnnotationUsage(MapsId.class)).value());
        }
        manyToOne.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        manyToOne.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String fullPath = StringHelper.qualify(propertyHolder.getPath(), propertyName);
        ToOneBinder.bindForeignKeyNameAndDefinition(manyToOne, property, propertyHolder.getOverriddenForeignKey(fullPath), context);
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(manyToOne, joinColumns, unique, ToOneBinder.isTargetAnnotatedEntity(targetEntity, property), propertyHolder.getPersistentClass(), fullPath, context);
        if (inSecondPass) {
            secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
        } else {
            context.getMetadataCollector().addSecondPass(secondPass);
        }
        ToOneBinder.processManyToOneProperty(cascadeStrategy, joinColumns, optional, inferredData, isIdentifierMapper, propertyBinder, manyToOne, property, propertyName);
    }

    private static OnDeleteAction onDeleteAction(MemberDetails property) {
        OnDelete onDelete = (OnDelete)property.getDirectAnnotationUsage(OnDelete.class);
        return onDelete == null ? null : onDelete.action();
    }

    private static NotFoundAction notFoundAction(PropertyHolder propertyHolder, MemberDetails property, FetchType fetchType) {
        NotFoundAction notFoundAction;
        NotFound notFound = (NotFound)property.getDirectAnnotationUsage(NotFound.class);
        NotFoundAction notFoundAction2 = notFoundAction = notFound == null ? null : notFound.action();
        if (notFoundAction != null && fetchType == FetchType.LAZY) {
            LOG.ignoreNotFoundWithFetchTypeLazy(propertyHolder.getEntityName(), property.getName());
        }
        return notFoundAction;
    }

    private static ManyToOne handleJoinTable(AnnotatedJoinColumns joinColumns, JoinTable joinTable, NotFoundAction notFoundAction, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context) {
        if (StringHelper.isBlank(joinTable.name())) {
            ManyToOne value = new ManyToOne(context, joinColumns.getTable());
            context.getMetadataCollector().addSecondPass(new ImplicitToOneJoinTableSecondPass(propertyHolder, inferredData, context, joinColumns, joinTable, notFoundAction, value));
            return value;
        }
        Join join = propertyHolder.addJoin(joinTable, false);
        for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
            joinColumn.setExplicitTableName(join.getTable().getName());
        }
        if (notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        return new ManyToOne(context, joinColumns.getTable());
    }

    static boolean isTargetAnnotatedEntity(ClassDetails targetEntity, MemberDetails property) {
        ClassDetails target = BinderHelper.isDefault(targetEntity) ? property.getType().determineRawClass() : targetEntity;
        return target.hasDirectAnnotationUsage(Entity.class);
    }

    private static void processManyToOneProperty(EnumSet<CascadeType> cascadeStrategy, AnnotatedJoinColumns columns, boolean optional, PropertyData inferredData, boolean isIdentifierMapper, PropertyBinder propertyBinder, ManyToOne value, MemberDetails property, String propertyName) {
        columns.checkPropertyConsistency();
        propertyBinder.setName(propertyName);
        propertyBinder.setValue(value);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setColumns(columns);
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setCascade(cascadeStrategy);
        propertyBinder.setMemberDetails(property);
        propertyBinder.setToMany(true);
        JoinColumn joinColumn = (JoinColumn)property.getDirectAnnotationUsage(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)property.getDirectAnnotationUsage(JoinColumns.class);
        propertyBinder.makePropertyAndBind().setOptional(optional && ToOneBinder.isNullable(joinColumns, joinColumn));
    }

    private static boolean isNullable(JoinColumns joinColumns, JoinColumn joinColumn) {
        if (joinColumn != null) {
            return joinColumn.nullable();
        }
        if (joinColumns != null) {
            for (JoinColumn column : joinColumns.value()) {
                if (!column.nullable()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static void defineFetchingStrategy(ToOne toOne, MemberDetails property, PropertyData inferredData, PropertyHolder propertyHolder) {
        ToOneBinder.handleLazy(toOne, property);
        ToOneBinder.handleFetch(toOne, property);
        ToOneBinder.handleFetchProfileOverrides(toOne, property, propertyHolder, inferredData);
    }

    private static void handleLazy(ToOne toOne, MemberDetails property) {
        if (property.hasDirectAnnotationUsage(NotFound.class)) {
            toOne.setLazy(false);
            toOne.setUnwrapProxy(true);
        } else {
            boolean eager = ToOneBinder.isEager(property);
            toOne.setLazy(!eager);
            toOne.setUnwrapProxy(eager);
            toOne.setUnwrapProxyImplicit(true);
        }
    }

    private static void handleFetchProfileOverrides(ToOne toOne, MemberDetails property, PropertyHolder propertyHolder, PropertyData inferredData) {
        MetadataBuildingContext context = toOne.getBuildingContext();
        InFlightMetadataCollector collector = context.getMetadataCollector();
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        property.forEachAnnotationUsage(FetchProfileOverride.class, modelsContext, usage -> collector.addSecondPass(new FetchSecondPass((FetchProfileOverride)usage, propertyHolder, inferredData.getPropertyName(), context)));
    }

    private static void handleFetch(ToOne toOne, MemberDetails property) {
        Fetch fetchAnnotationUsage = (Fetch)property.getDirectAnnotationUsage(Fetch.class);
        if (fetchAnnotationUsage != null) {
            ToOneBinder.setHibernateFetchMode(toOne, property, fetchAnnotationUsage.value());
        } else {
            toOne.setFetchMode(BinderHelper.getFetchMode(ToOneBinder.getJpaFetchType(property)));
        }
    }

    private static void setHibernateFetchMode(ToOne toOne, MemberDetails property, org.hibernate.annotations.FetchMode fetchMode) {
        switch (fetchMode) {
            case JOIN: {
                toOne.setFetchMode(FetchMode.JOIN);
                toOne.setLazy(false);
                toOne.setUnwrapProxy(false);
                break;
            }
            case SELECT: {
                toOne.setFetchMode(FetchMode.SELECT);
                break;
            }
            case SUBSELECT: {
                throw new AnnotationException("Association '" + property.getName() + "' is annotated '@Fetch(SUBSELECT)' but is not many-valued");
            }
            default: {
                throw new AssertionFailure("unknown fetch type");
            }
        }
    }

    private static boolean isEager(MemberDetails property) {
        return ToOneBinder.getJpaFetchType(property) == FetchType.EAGER;
    }

    private static FetchType getJpaFetchType(MemberDetails property) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        jakarta.persistence.OneToOne oneToOne = (jakarta.persistence.OneToOne)property.getDirectAnnotationUsage(jakarta.persistence.OneToOne.class);
        if (manyToOne != null) {
            return manyToOne.fetch();
        }
        if (oneToOne != null) {
            return oneToOne.fetch();
        }
        throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
    }

    static void bindOneToOne(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder) {
        MemberDetails property = inferredData.getAttributeMember();
        jakarta.persistence.OneToOne oneToOne = (jakarta.persistence.OneToOne)property.getDirectAnnotationUsage(jakarta.persistence.OneToOne.class);
        if (property.hasDirectAnnotationUsage(Column.class) || property.hasDirectAnnotationUsage(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@OneToOne' association and may not use '@Column' to specify column mappings (use '@PrimaryKeyJoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@OneToOne' association and cannot be used as identifier");
        }
        boolean trueOneToOne = property.hasDirectAnnotationUsage(PrimaryKeyJoinColumn.class) || property.hasDirectAnnotationUsage(PrimaryKeyJoinColumns.class);
        Cascade hibernateCascade = (Cascade)property.getDirectAnnotationUsage(Cascade.class);
        ToOneBinder.bindOneToOne(BinderHelper.aggregateCascadeTypes(oneToOne.cascade(), hibernateCascade, oneToOne.orphanRemoval(), context), joinColumns, oneToOne.optional(), oneToOne.fetch(), propertyHolder, nullability, inferredData, StringHelper.nullIfEmpty(oneToOne.mappedBy()), trueOneToOne, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static void bindOneToOne(EnumSet<CascadeType> cascadeStrategy, AnnotatedJoinColumns joinColumns, boolean explicitlyOptional, FetchType fetchMode, PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        if (mappedBy != null || ToOneBinder.isMappedToPrimaryKey(joinColumns, propertyHolder, trueOneToOne)) {
            ToOneBinder.bindTrueOneToOne(cascadeStrategy, joinColumns, explicitlyOptional, fetchMode, propertyHolder, inferredData, mappedBy, inSecondPass, context);
        } else {
            ToOneBinder.bindManyToOne(cascadeStrategy, joinColumns, propertyHolder, nullability, inferredData, fetchMode, explicitlyOptional, true, isIdentifierMapper, inSecondPass, propertyBinder, context);
        }
    }

    private static void bindTrueOneToOne(EnumSet<CascadeType> cascadeStrategy, AnnotatedJoinColumns joinColumns, boolean explicitlyOptional, FetchType fetchMode, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean inSecondPass, MetadataBuildingContext context) {
        MemberDetails memberDetails = inferredData.getAttributeMember();
        ClassDetails targetEntityClassDetails = ToOneBinder.getTargetEntity(inferredData, context);
        NotFoundAction notFoundAction = ToOneBinder.notFoundAction(propertyHolder, memberDetails, fetchMode);
        boolean optional = !ToOneBinder.isMandatory(explicitlyOptional, memberDetails, notFoundAction);
        OneToOne oneToOne = new OneToOne(context, propertyHolder.getTable(), propertyHolder.getPersistentClass());
        String propertyName = inferredData.getPropertyName();
        oneToOne.setPropertyName(propertyName);
        oneToOne.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntityClassDetails));
        ToOneBinder.defineFetchingStrategy(oneToOne, memberDetails, inferredData, propertyHolder);
        oneToOne.setOnDeleteAction(ToOneBinder.onDeleteAction(memberDetails));
        oneToOne.setConstrained(!optional);
        oneToOne.setForeignKeyType(mappedBy == null ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT);
        ToOneBinder.bindForeignKeyNameAndDefinition(oneToOne, memberDetails, (ForeignKey)memberDetails.getDirectAnnotationUsage(ForeignKey.class), context);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setMemberDetails(memberDetails);
        binder.setValue(oneToOne);
        binder.setCascade(cascadeStrategy);
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setBuildingContext(context);
        binder.setHolder(propertyHolder);
        LazyGroup lazyGroupAnnotation = (LazyGroup)memberDetails.getDirectAnnotationUsage(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        Property property = binder.makeProperty();
        property.setOptional(optional);
        propertyHolder.addProperty(property, inferredData.getAttributeMember(), inferredData.getDeclaringClass());
        OneToOneSecondPass secondPass = new OneToOneSecondPass(binder, property, oneToOne, mappedBy, propertyHolder.getEntityName(), propertyHolder, inferredData, ToOneBinder.isTargetAnnotatedEntity(targetEntityClassDetails, memberDetails), notFoundAction, joinColumns, context);
        if (inSecondPass) {
            secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
        } else {
            context.getMetadataCollector().addSecondPass(secondPass, mappedBy == null);
        }
    }

    private static boolean isMappedToPrimaryKey(AnnotatedJoinColumns joinColumns, PropertyHolder propertyHolder, boolean trueOneToOne) {
        if (trueOneToOne) {
            return true;
        }
        KeyValue identifier = propertyHolder.getIdentifier();
        if (identifier == null) {
            return false;
        }
        List<AnnotatedJoinColumn> columns = joinColumns.getJoinColumns();
        if (identifier.getColumnSpan() != columns.size()) {
            return false;
        }
        List<org.hibernate.mapping.Column> identifierColumns = identifier.getColumns();
        return columns.stream().noneMatch(column -> {
            String name = column.getMappingColumn().getName();
            return identifierColumns.stream().noneMatch(idColumn -> idColumn.getName().equals(name));
        });
    }

    public static void bindForeignKeyNameAndDefinition(SimpleValue value, MemberDetails property, ForeignKey foreignKey, MetadataBuildingContext context) {
        if (property.hasDirectAnnotationUsage(NotFound.class)) {
            value.disableForeignKey();
        } else {
            JoinColumn joinColumn = (JoinColumn)property.getDirectAnnotationUsage(JoinColumn.class);
            JoinColumns joinColumns = (JoinColumns)property.getDirectAnnotationUsage(JoinColumns.class);
            boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
            if (joinColumn != null && BinderHelper.noConstraint(joinColumn.foreignKey(), noConstraintByDefault) || joinColumns != null && BinderHelper.noConstraint(joinColumns.foreignKey(), noConstraintByDefault)) {
                value.disableForeignKey();
            } else if (BinderHelper.noConstraint(foreignKey, noConstraintByDefault)) {
                value.disableForeignKey();
            } else if (foreignKey != null) {
                value.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                value.setForeignKeyOptions(foreignKey.options());
            } else if (noConstraintByDefault) {
                value.disableForeignKey();
            } else if (joinColumns != null) {
                ForeignKey joinColumnsForeignKey = joinColumns.foreignKey();
                value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumnsForeignKey.name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumnsForeignKey.foreignKeyDefinition()));
                value.setForeignKeyOptions(joinColumnsForeignKey.options());
            } else if (joinColumn != null) {
                ForeignKey joinColumnForeignKey = joinColumn.foreignKey();
                value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumnForeignKey.name()));
                value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumnForeignKey.foreignKeyDefinition()));
                value.setForeignKeyOptions(joinColumnForeignKey.options());
            }
        }
    }

    public static String getReferenceEntityName(PropertyData propertyData, ClassDetails targetEntity) {
        return BinderHelper.isDefault(targetEntity) ? propertyData.getClassOrElementName() : targetEntity.getName();
    }

    public static String getReferenceEntityName(PropertyData propertyData, MetadataBuildingContext context) {
        return ToOneBinder.getReferenceEntityName(propertyData, ToOneBinder.getTargetEntity(propertyData, context));
    }

    public static ClassDetails getTargetEntity(PropertyData propertyData, MetadataBuildingContext context) {
        return ToOneBinder.getTargetEntityClass(propertyData.getAttributeMember(), context);
    }

    private static ClassDetails getTargetEntityClass(MemberDetails property, MetadataBuildingContext context) {
        ClassDetailsRegistry classDetailsRegistry = context.getBootstrapContext().getModelsContext().getClassDetailsRegistry();
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        if (manyToOne != null) {
            return classDetailsRegistry.resolveClassDetails(manyToOne.targetEntity().getName());
        }
        jakarta.persistence.OneToOne oneToOne = (jakarta.persistence.OneToOne)property.getDirectAnnotationUsage(jakarta.persistence.OneToOne.class);
        if (oneToOne != null) {
            return classDetailsRegistry.resolveClassDetails(oneToOne.targetEntity().getName());
        }
        throw new AssertionFailure("Unexpected discovery of a targetEntity: " + property.getName());
    }
}

