/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class UserAttributeMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper,
TokenIntrospectionTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-usermodel-attribute-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a custom user attribute to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        boolean aggregateAttrs;
        String attributeName;
        UserModel user = userSession.getUser();
        Collection attributeValue = KeycloakModelUtils.resolveAttribute((UserModel)user, (String)(attributeName = (String)mappingModel.getConfig().get("user.attribute")), (boolean)(aggregateAttrs = Boolean.valueOf((String)mappingModel.getConfig().get("aggregate.attrs")).booleanValue()));
        if (attributeValue == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, (Object)attributeValue);
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean introspectionEndpoint, boolean multivalued) {
        return UserAttributeMapper.createClaimMapper(name, userAttribute, tokenClaimName, claimType, accessToken, idToken, introspectionEndpoint, multivalued, false);
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean introspectionEndpoint, boolean multivalued, boolean aggregateAttrs) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, userAttribute, tokenClaimName, claimType, accessToken, idToken, introspectionEndpoint, PROVIDER_ID);
        if (multivalued) {
            mapper.getConfig().put("multivalued", "true");
        }
        if (aggregateAttrs) {
            mapper.getConfig().put("aggregate.attrs", "true");
        }
        return mapper;
    }

    public static ProtocolMapperModel createClaimMapper(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean introspectionEndpoint) {
        return UserAttributeMapper.createClaimMapper(name, userAttribute, tokenClaimName, claimType, accessToken, idToken, introspectionEndpoint, false, false);
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("user.attribute");
        property.setLabel("usermodel.attr.label");
        property.setHelpText("usermodel.attr.tooltip");
        property.setType("UserProfileAttributeList");
        configProperties.add(property);
        OIDCAttributeMapperHelper.addAttributeConfig(configProperties, UserAttributeMapper.class);
        property = new ProviderConfigProperty();
        property.setName("multivalued");
        property.setLabel("multivalued.label");
        property.setHelpText("multivalued.tooltip");
        property.setType("boolean");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("aggregate.attrs");
        property.setLabel("aggregate.attrs.label");
        property.setHelpText("aggregate.attrs.tooltip");
        property.setType("boolean");
        configProperties.add(property);
    }
}

