/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions.expression;

import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParserBaseVisitor;

public abstract class AbstractBooleanEvaluator
extends BooleanConditionParserBaseVisitor<Boolean> {
    @Override
    public Boolean visitEvaluator(BooleanConditionParser.EvaluatorContext ctx) {
        return (Boolean)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Boolean visitExpression(BooleanConditionParser.ExpressionContext ctx) {
        if (ctx.expression() != null && ctx.OR() != null) {
            return (Boolean)this.visit((ParseTree)ctx.expression()) != false || (Boolean)this.visit((ParseTree)ctx.andExpression()) != false;
        }
        return (Boolean)this.visit((ParseTree)ctx.andExpression());
    }

    @Override
    public Boolean visitAndExpression(BooleanConditionParser.AndExpressionContext ctx) {
        if (ctx.andExpression() != null && ctx.AND() != null) {
            return (Boolean)this.visit((ParseTree)ctx.andExpression()) != false && (Boolean)this.visit((ParseTree)ctx.notExpression()) != false;
        }
        return (Boolean)this.visit((ParseTree)ctx.notExpression());
    }

    @Override
    public Boolean visitNotExpression(BooleanConditionParser.NotExpressionContext ctx) {
        if (ctx.NOT() != null) {
            return (Boolean)this.visit((ParseTree)ctx.notExpression()) == false;
        }
        return (Boolean)this.visit((ParseTree)ctx.atom());
    }

    @Override
    public Boolean visitAtom(BooleanConditionParser.AtomContext ctx) {
        if (ctx.conditionCall() != null) {
            return (Boolean)this.visit((ParseTree)ctx.conditionCall());
        }
        return (Boolean)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public abstract Boolean visitConditionCall(BooleanConditionParser.ConditionCallContext var1);

    protected String extractParameter(BooleanConditionParser.ParameterContext paramCtx) {
        if (paramCtx == null || paramCtx.ParameterText() == null) {
            return null;
        }
        String rawText = paramCtx.ParameterText().getText();
        return this.unEscapeParameter(rawText);
    }

    private String unEscapeParameter(String rawText) {
        return rawText.replace("\\)", ")").replace("\\\\", "\\");
    }
}

