/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.util.List;
import org.directwebremoting.spring.SpringConfigurator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ConfigurationParser
implements BeanDefinitionParser {
    public static final String DEFAULT_SPRING_CONFIGURATOR_ID = "__dwrConfiguration";
    private final NamespaceHandlerSupport handler;

    public ConfigurationParser(NamespaceHandlerSupport handler) {
        Assert.notNull((Object)handler);
        this.handler = handler;
    }

    public BeanDefinition parse(Element configurationElement, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        BeanDefinition configuration = ConfigurationParser.registerConfigurationIfNecessary(registry);
        this.parseConfigurationChildren(configurationElement, configuration, parserContext);
        return configuration;
    }

    public static BeanDefinition registerConfigurationIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SpringConfigurator.class);
            builder.addPropertyValue("creators", (Object)new ManagedMap());
            builder.addPropertyValue("converters", (Object)new ManagedMap());
            builder.addPropertyValue("filters", (Object)new ManagedList());
            registry.registerBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID, (BeanDefinition)builder.getBeanDefinition());
        }
        return registry.getBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID);
    }

    private void parseConfigurationChildren(Element configurationElement, BeanDefinition configuration, ParserContext parserContext) {
        this.parseInit(configurationElement, configuration, parserContext);
        this.parseFilters(configurationElement, configuration, parserContext);
        this.parseSignatures(configurationElement, configuration, parserContext);
        this.parseConverters(configurationElement, configuration, parserContext);
    }

    private void parseInit(Element configurationElement, BeanDefinition configuration, ParserContext parserContext) {
        Element initElement = DomUtils.getChildElementByTagName((Element)configurationElement, (String)"init");
        if (initElement != null) {
            this.handler.decorate((Node)initElement, new BeanDefinitionHolder(configuration, DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
        }
    }

    private void parseFilters(Element configurationElement, BeanDefinition configuration, ParserContext parserContext) {
        List filterElements = DomUtils.getChildElementsByTagName((Element)configurationElement, (String)"filter");
        for (Element filterElement : filterElements) {
            this.handler.decorate((Node)filterElement, new BeanDefinitionHolder(configuration, DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
        }
    }

    private void parseSignatures(Element configurationElement, BeanDefinition configuration, ParserContext parserContext) {
        List signatureElements = DomUtils.getChildElementsByTagName((Element)configurationElement, (String)"signatures");
        for (Element signatureElement : signatureElements) {
            this.handler.decorate((Node)signatureElement, new BeanDefinitionHolder(configuration, DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
        }
    }

    private void parseConverters(Element configurationElement, BeanDefinition configuration, ParserContext parserContext) {
        List convertElements = DomUtils.getChildElementsByTagName((Element)configurationElement, (String)"convert");
        for (Element convertElement : convertElements) {
            this.handler.decorate((Node)convertElement, new BeanDefinitionHolder(configuration, DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
        }
    }
}

