/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.analysis.TypeEnvironment;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.data.type.ExprCoreType;

public class ML
extends UnresolvedPlan {
    private UnresolvedPlan child;
    private final Map<String, Literal> arguments;

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitML(this, context);
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    private String getAction() {
        return (String)this.arguments.get("action").getValue();
    }

    public Map<String, ExprCoreType> getOutputSchema(TypeEnvironment env) {
        switch (this.getAction()) {
            case "train": {
                env.clearAllFields();
                return this.getTrainOutputSchema();
            }
            case "predict": 
            case "trainandpredict": {
                return this.getPredictOutputSchema();
            }
        }
        throw new IllegalArgumentException("Action error. Please indicate train, predict or trainandpredict.");
    }

    public Map<String, ExprCoreType> getPredictOutputSchema() {
        String algo;
        HashMap<String, ExprCoreType> res = new HashMap<String, ExprCoreType>();
        switch (algo = this.arguments.containsKey("algorithm") ? (String)this.arguments.get("algorithm").getValue() : null) {
            case "kmeans": {
                res.put("ClusterID", ExprCoreType.INTEGER);
                break;
            }
            case "rcf": {
                res.put("score", ExprCoreType.DOUBLE);
                if (this.arguments.containsKey("timeField")) {
                    res.put("anomaly_grade", ExprCoreType.DOUBLE);
                    res.put((String)this.arguments.get("timeField").getValue(), ExprCoreType.TIMESTAMP);
                    break;
                }
                res.put("anomalous", ExprCoreType.BOOLEAN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm: " + algo);
            }
        }
        return res;
    }

    public Map<String, ExprCoreType> getTrainOutputSchema() {
        boolean isAsync = this.arguments.containsKey("async") ? (Boolean)this.arguments.get("async").getValue() : false;
        HashMap<String, ExprCoreType> res = new HashMap<String, ExprCoreType>(Map.of("status", ExprCoreType.STRING));
        if (isAsync) {
            res.put("task_id", ExprCoreType.STRING);
        } else {
            res.put("model_id", ExprCoreType.STRING);
        }
        return res;
    }

    @Generated
    public Map<String, Literal> getArguments() {
        return this.arguments;
    }

    @Generated
    public void setChild(UnresolvedPlan child) {
        this.child = child;
    }

    @Override
    @Generated
    public String toString() {
        return "ML(child=" + String.valueOf(this.getChild()) + ", arguments=" + String.valueOf(this.getArguments()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ML)) {
            return false;
        }
        ML other = (ML)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        Map<String, Literal> this$arguments = this.getArguments();
        Map<String, Literal> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ML;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        Map<String, Literal> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public ML(Map<String, Literal> arguments) {
        this.arguments = arguments;
    }

    @Generated
    public ML(UnresolvedPlan child, Map<String, Literal> arguments) {
        this.child = child;
        this.arguments = arguments;
    }
}

