/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.core.utils.ValidationHelpersKt;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.ChimeDestination;
import org.opensearch.notifications.spi.model.destination.CustomWebhookDestination;
import org.opensearch.notifications.spi.model.destination.MicrosoftTeamsDestination;
import org.opensearch.notifications.spi.model.destination.SlackDestination;
import org.opensearch.notifications.spi.model.destination.WebhookDestination;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient;", "", "<init>", "()V", "httpClient", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "(Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;)V", "execute", "", "destination", "Lorg/opensearch/notifications/spi/model/destination/WebhookDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "getHttpResponse", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpResponse;", "constructHttpRequest", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "method", "url", "getResponseString", "response", "validateResponseStatus", "", "Lorg/apache/hc/core5/http/HttpResponse;", "buildRequestBody", "Companion", "opensearch-notifications-core"})
public final class DestinationHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationHttpClient.class);
    private static final Set<Integer> VALID_RESPONSE_STATUS;

    public DestinationHttpClient() {
        this.httpClient = DestinationHttpClient.Companion.createHttpClient();
    }

    @OpenForTesting
    public DestinationHttpClient(@NotNull CloseableHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String execute(@NotNull WebhookDestination destination, @NotNull MessageContent message, @NotNull String referenceId) throws Exception {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        CloseableHttpResponse response = null;
        try {
            ValidationHelpersKt.validateUrlHost(destination.getUrl(), PluginSettings.INSTANCE.getHostDenyList());
            response = this.getHttpResponse(destination, message);
            this.validateResponseStatus((HttpResponse)response);
            String responseString = this.getResponseString(response);
            DestinationHttpClient.Companion.getLog().debug("Http response for id " + referenceId + ": " + responseString);
            string = responseString;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return string;
    }

    private final CloseableHttpResponse getHttpResponse(WebhookDestination destination, MessageContent message) throws Exception {
        HttpUriRequestBase httpRequest = (HttpUriRequestBase)new HttpPost(destination.getUrl());
        if (destination instanceof CustomWebhookDestination) {
            httpRequest = this.constructHttpRequest(((CustomWebhookDestination)destination).getMethod(), destination.getUrl());
            if (((CustomWebhookDestination)destination).getHeaderParams().isEmpty()) {
                httpRequest.setHeader("Content-type", (Object)"application/json");
            } else {
                for (Map.Entry entry : ((CustomWebhookDestination)destination).getHeaderParams().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    httpRequest.setHeader(key, (Object)value);
                }
            }
        }
        StringEntity entity = new StringEntity(this.buildRequestBody(destination, message), StandardCharsets.UTF_8);
        httpRequest.setEntity((HttpEntity)entity);
        CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((ClassicHttpRequest)httpRequest);
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"execute(...)");
        return closeableHttpResponse;
    }

    private final HttpUriRequestBase constructHttpRequest(String method, String url) {
        return switch (method) {
            case "POST" -> (HttpUriRequestBase)new HttpPost(url);
            case "PUT" -> (HttpUriRequestBase)new HttpPut(url);
            case "PATCH" -> (HttpUriRequestBase)new HttpPatch(url);
            default -> throw new IllegalArgumentException("Invalid or empty method supplied. Only POST, PUT and PATCH are allowed");
        };
    }

    @NotNull
    public final String getResponseString(@NotNull CloseableHttpResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            return "{}";
        }
        HttpEntity entity = httpEntity;
        String responseString = EntityUtils.toString((HttpEntity)entity, (int)(PluginSettings.INSTANCE.getMaxHttpResponseSize() / 2));
        CharSequence charSequence = responseString;
        return charSequence == null || charSequence.length() == 0 ? "{}" : responseString;
    }

    private final void validateResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getCode();
        if (!VALID_RESPONSE_STATUS.contains(statusCode)) {
            throw new IOException("Failed: " + response.getReasonPhrase());
        }
    }

    @NotNull
    public final String buildRequestBody(@NotNull WebhookDestination destination, @NotNull MessageContent message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)XContentType.JSON));
        WebhookDestination webhookDestination = destination;
        if (webhookDestination instanceof SlackDestination) {
            string = "text";
        } else if (webhookDestination instanceof ChimeDestination) {
            string = "Content";
        } else if (webhookDestination instanceof MicrosoftTeamsDestination) {
            string = "text";
        } else {
            if (webhookDestination instanceof CustomWebhookDestination) {
                return message.getTextDescription();
            }
            throw new IllegalArgumentException("Invalid destination type is provided, Only Slack, Chime, Microsoft Teams and CustomWebhook are allowed");
        }
        String keyName = string;
        builder.startObject().field(keyName, message.buildMessageWithTitle()).endObject();
        Intrinsics.checkNotNull((Object)builder);
        return HelpersKt.string(builder);
    }

    static {
        Object[] objectArray = new Integer[]{RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus()};
        VALID_RESPONSE_STATUS = Collections.unmodifiableSet(new HashSet(CollectionsKt.listOf((Object[])objectArray)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R2\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "VALID_RESPONSE_STATUS", "", "", "kotlin.jvm.PlatformType", "", "createHttpClient", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final CloseableHttpClient createHttpClient() {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)PluginSettings.INSTANCE.getConnectionTimeout())).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)PluginSettings.INSTANCE.getConnectionTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)PluginSettings.INSTANCE.getSocketTimeout())).build();
            Intrinsics.checkNotNullExpressionValue((Object)requestConfig, (String)"build(...)");
            RequestConfig config = requestConfig;
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(PluginSettings.INSTANCE.getMaxConnections());
            connectionManager.setDefaultMaxPerRoute(PluginSettings.INSTANCE.getMaxConnectionsPerRoute());
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy()).useSystemProperties().disableRedirectHandling().build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"build(...)");
            return closeableHttpClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

