/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.marshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;
import java.util.Map;

public class MapToMapMarshaller
implements ArgumentMarshaller.MapAttributeMarshaller {
    private static final MapToMapMarshaller INSTANCE = new MapToMapMarshaller();
    private final ArgumentMarshaller memberMarshaller;

    public static MapToMapMarshaller instance() {
        return INSTANCE;
    }

    private MapToMapMarshaller() {
        this.memberMarshaller = null;
    }

    public MapToMapMarshaller(ArgumentMarshaller memberMarshaller) {
        if (memberMarshaller == null) {
            throw new NullPointerException("memberMarshaller");
        }
        this.memberMarshaller = memberMarshaller;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        if (this.memberMarshaller == null) {
            throw new IllegalStateException("No member marshaller configured!");
        }
        Map map = (Map)obj;
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        for (Map.Entry entry : map.entrySet()) {
            AttributeValue value = entry.getValue() == null ? new AttributeValue().withNULL(true) : this.memberMarshaller.marshall(entry.getValue());
            values.put((String)entry.getKey(), value);
        }
        AttributeValue result = new AttributeValue();
        result.setM(values);
        return result;
    }

    public ArgumentMarshaller getMemberMarshaller() {
        return this.memberMarshaller;
    }
}

