/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricGOST3410Key<T>
implements AsymmetricKey {
    protected static final Set ecAcceptable = new HashSet();
    protected static final Set fpAcceptable = new HashSet();
    private Algorithm algorithm;
    private GOST3410Parameters<T> domainParameters;

    AsymmetricGOST3410Key(Algorithm algorithm, GOST3410Parameters<T> gOST3410Parameters) {
        this.algorithm = algorithm;
        this.domainParameters = gOST3410Parameters;
    }

    AsymmetricGOST3410Key(Algorithm algorithm, Set set, AlgorithmIdentifier algorithmIdentifier) {
        if (!set.contains(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricGOST3410Key.decodeDomainParameters(algorithmIdentifier);
    }

    private static GOST3410Parameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(algorithmIdentifier.getParameters());
            return new GOST3410Parameters(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet(), gOST3410PublicKeyAlgParameters.getDigestParamSet(), gOST3410PublicKeyAlgParameters.getDigestParamSet());
        }
        return null;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public GOST3410Parameters<T> getParameters() {
        return this.domainParameters;
    }

    protected final boolean isThreadCorrectMode() {
        return !CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }

    static {
        ecAcceptable.add(CryptoProObjectIdentifiers.gostR3410_2001);
        ecAcceptable.add(CryptoProObjectIdentifiers.gostR3410_2001DH);
        ecAcceptable.add(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256);
        ecAcceptable.add(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512);
        ecAcceptable.add(RosstandartObjectIdentifiers.id_tc26_agreement_gost_3410_12_256);
        ecAcceptable.add(RosstandartObjectIdentifiers.id_tc26_agreement_gost_3410_12_512);
        fpAcceptable.add(CryptoProObjectIdentifiers.gostR3410_94);
    }
}

