/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.chart.AreaRenderer;
import net.sourceforge.plantuml.chart.BarRenderer;
import net.sourceforge.plantuml.chart.ChartAnnotation;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.chart.LineRenderer;
import net.sourceforge.plantuml.chart.ScatterRenderer;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class ChartRenderer {
    private final ISkinParam skinParam;
    private final List<String> xAxisLabels;
    private final String xAxisTitle;
    private final Integer xAxisTickSpacing;
    private final ChartAxis.LabelPosition xAxisLabelPosition;
    private final List<ChartSeries> series;
    private final ChartAxis xAxis;
    private final ChartAxis yAxis;
    private final ChartAxis y2Axis;
    private final ChartDiagram.LegendPosition legendPosition;
    private final ChartDiagram.GridMode xGridMode;
    private final ChartDiagram.GridMode yGridMode;
    private final ChartDiagram.StackMode stackMode;
    private final ChartDiagram.Orientation orientation;
    private final List<ChartAnnotation> annotations;
    private static final double MARGIN = 20.0;
    private static final double AXIS_LABEL_SPACE = 40.0;
    private static final double TITLE_SPACE = 30.0;
    private static final double TICK_SIZE = 5.0;
    private static final double LEGEND_MARGIN = 10.0;
    private static final double LEGEND_SYMBOL_SIZE = 12.0;
    private static final double LEGEND_TEXT_SPACING = 5.0;
    private static final double LEGEND_ITEM_SPACING = 15.0;

    public ChartRenderer(ISkinParam skinParam, List<String> xAxisLabels, String xAxisTitle, Integer xAxisTickSpacing, ChartAxis.LabelPosition xAxisLabelPosition, List<ChartSeries> series, ChartAxis xAxis, ChartAxis yAxis, ChartAxis y2Axis, ChartDiagram.LegendPosition legendPosition, ChartDiagram.GridMode xGridMode, ChartDiagram.GridMode yGridMode, ChartDiagram.StackMode stackMode, ChartDiagram.Orientation orientation, List<ChartAnnotation> annotations) {
        this.skinParam = skinParam;
        this.orientation = orientation;
        if (orientation == ChartDiagram.Orientation.HORIZONTAL) {
            this.xAxisLabels = xAxisLabels;
            this.xAxisTitle = xAxisTitle;
            this.xAxisTickSpacing = xAxisTickSpacing;
            this.xAxisLabelPosition = xAxisLabelPosition;
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.y2Axis = y2Axis;
            this.xGridMode = xGridMode;
            this.yGridMode = yGridMode;
        } else {
            this.xAxisLabels = xAxisLabels;
            this.xAxisTitle = xAxisTitle;
            this.xAxisTickSpacing = xAxisTickSpacing;
            this.xAxisLabelPosition = xAxisLabelPosition;
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.y2Axis = y2Axis;
            this.xGridMode = xGridMode;
            this.yGridMode = yGridMode;
        }
        this.series = series;
        this.legendPosition = legendPosition;
        this.stackMode = stackMode;
        this.annotations = annotations;
    }

    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D legendDim = this.calculateLegendDimension(stringBounder);
        double width = 60.0 + this.getPlotWidth() + (this.y2Axis != null ? 40.0 : 0.0) + 20.0;
        double height = 50.0 + this.getPlotHeight() + 40.0 + 20.0;
        if (this.xAxisTitle != null && !this.xAxisTitle.isEmpty()) {
            height += 20.0;
        }
        if (this.legendPosition == ChartDiagram.LegendPosition.LEFT || this.legendPosition == ChartDiagram.LegendPosition.RIGHT) {
            width += legendDim.getWidth() + 10.0;
        } else if (this.legendPosition == ChartDiagram.LegendPosition.TOP || this.legendPosition == ChartDiagram.LegendPosition.BOTTOM) {
            height += legendDim.getHeight() + 10.0;
        }
        return new XDimension2D(width, height);
    }

    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Style style = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor lineColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor fontColor = style.value(PName.FontColor).asColor(this.skinParam.getIHtmlColorSet());
        ug = ug.apply(lineColor).apply(UStroke.withThickness(1.0));
        XDimension2D legendDim = this.calculateLegendDimension(stringBounder);
        double leftMargin = 60.0;
        double topMargin = 50.0;
        double plotWidth = this.getPlotWidth();
        double plotHeight = this.getPlotHeight();
        if (this.legendPosition == ChartDiagram.LegendPosition.LEFT) {
            leftMargin += legendDim.getWidth() + 10.0;
        } else if (this.legendPosition == ChartDiagram.LegendPosition.TOP) {
            topMargin += legendDim.getHeight() + 10.0;
        }
        double xAxisY = topMargin + plotHeight;
        if (this.orientation != ChartDiagram.Orientation.HORIZONTAL && this.yAxis != null && this.yAxis.getMin() <= 0.0 && this.yAxis.getMax() >= 0.0) {
            double zeroRatio = (0.0 - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin());
            xAxisY = topMargin + plotHeight * (1.0 - zeroRatio);
        }
        double yAxisX = leftMargin;
        if (this.orientation != ChartDiagram.Orientation.HORIZONTAL && this.xAxis != null && this.xAxis.getMin() <= 0.0 && this.xAxis.getMax() >= 0.0) {
            double zeroX = this.xAxis.valueToPixel(0.0, 0.0, plotWidth);
            yAxisX = leftMargin + zeroX;
        }
        if (this.orientation == ChartDiagram.Orientation.HORIZONTAL) {
            this.drawXAxis(ug.apply(UTranslate.dx(leftMargin).compose(UTranslate.dy(topMargin))), plotHeight, plotHeight, lineColor, fontColor);
            this.drawYAxisHorizontally(ug.apply(UTranslate.dx(leftMargin).compose(UTranslate.dy(topMargin + plotHeight))), plotWidth, plotHeight, this.yAxis, lineColor, fontColor);
        } else {
            this.drawYAxis(ug.apply(UTranslate.dx(yAxisX).compose(UTranslate.dy(topMargin))), plotHeight, plotWidth, this.yAxis, true, lineColor, fontColor);
            if (this.y2Axis != null) {
                this.drawYAxis(ug.apply(UTranslate.dx(leftMargin + plotWidth).compose(UTranslate.dy(topMargin))), plotHeight, plotWidth, this.y2Axis, false, lineColor, fontColor);
            }
            this.drawXAxis(ug.apply(UTranslate.dx(leftMargin).compose(UTranslate.dy(xAxisY))), plotWidth, plotHeight, lineColor, fontColor);
        }
        UGraphic ugPlot = ug.apply(UTranslate.dx(leftMargin).compose(UTranslate.dy(topMargin)));
        this.drawGridLines(ugPlot, plotWidth, plotHeight, lineColor, fontColor);
        this.drawSeries(ugPlot, plotWidth, plotHeight);
        this.drawAnnotations(ugPlot, plotWidth, plotHeight, lineColor, fontColor);
        this.drawLegend(ug, leftMargin, topMargin, plotWidth, plotHeight, lineColor, fontColor);
    }

    private void drawYAxis(UGraphic ug, double height, double width, ChartAxis axis, boolean leftSide, HColor lineColor, HColor fontColor) {
        Style axisStyle = this.getAxisStyleSignature(false).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor styledLineColor = axisStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double lineThickness = axisStyle.value(PName.LineThickness).asDouble();
        FontConfiguration fontConfig = axisStyle.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        HColor actualLineColor = styledLineColor != null ? styledLineColor : lineColor;
        ug = ug.apply(actualLineColor).apply(UStroke.withThickness(lineThickness));
        ug.draw(ULine.vline(height));
        Style gridStyle = this.getGridStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor gridColor = gridStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (gridColor == null) {
            try {
                gridColor = this.skinParam.getIHtmlColorSet().getColor("#D0D0D0");
            }
            catch (Exception e) {
                gridColor = lineColor;
            }
        }
        double gridThickness = gridStyle.value(PName.LineThickness).asDouble();
        UStroke gridStroke = UStroke.withThickness(gridThickness);
        StringBounder stringBounder = ug.getStringBounder();
        if (axis.hasCustomTicks()) {
            for (Map.Entry<Double, String> entry : axis.getCustomTicks().entrySet()) {
                double value = entry.getKey();
                String label = entry.getValue();
                double y = height * (1.0 - (value - axis.getMin()) / (axis.getMax() - axis.getMin()));
                if (y < 0.0 || y > height) continue;
                if (leftSide && this.yGridMode != ChartDiagram.GridMode.OFF && this.xAxis == null) {
                    ULine gridLine = ULine.hline(width);
                    ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dy(y)).draw(gridLine);
                }
                if (leftSide) {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(-5.0));
                } else {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(5.0));
                }
                TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.RIGHT, this.skinParam);
                double textHeight = textBlock.calculateDimension(stringBounder).getHeight();
                if (leftSide) {
                    double textWidth = textBlock.calculateDimension(stringBounder).getWidth();
                    textBlock.drawU(ug.apply(UTranslate.dx(-5.0 - textWidth - 5.0).compose(UTranslate.dy(y - textHeight / 2.0))));
                    continue;
                }
                textBlock.drawU(ug.apply(UTranslate.dx(10.0).compose(UTranslate.dy(y - textHeight / 2.0))));
            }
        } else if (axis.hasTickSpacing()) {
            double startValue;
            double spacing = axis.getTickSpacing();
            double range = axis.getMax() - axis.getMin();
            for (double value = startValue = Math.ceil(axis.getMin() / spacing) * spacing; value <= axis.getMax() && !(value > axis.getMax() + spacing * 0.01); value += spacing) {
                double y = height * (1.0 - (value - axis.getMin()) / range);
                if (leftSide && this.yGridMode != ChartDiagram.GridMode.OFF && this.xAxis == null) {
                    ULine gridLine = ULine.hline(width);
                    ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dy(y)).draw(gridLine);
                }
                if (leftSide) {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(-5.0));
                } else {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(5.0));
                }
                String label = this.formatValue(value);
                TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.RIGHT, this.skinParam);
                double textHeight = textBlock.calculateDimension(stringBounder).getHeight();
                if (leftSide) {
                    double textWidth = textBlock.calculateDimension(stringBounder).getWidth();
                    textBlock.drawU(ug.apply(UTranslate.dx(-5.0 - textWidth - 5.0).compose(UTranslate.dy(y - textHeight / 2.0))));
                    continue;
                }
                textBlock.drawU(ug.apply(UTranslate.dx(10.0).compose(UTranslate.dy(y - textHeight / 2.0))));
            }
        } else {
            int numTicks = 5;
            for (int i = 0; i <= 5; ++i) {
                double y = height * (1.0 - (double)i / 5.0);
                double value = axis.getMin() + (axis.getMax() - axis.getMin()) * (double)i / 5.0;
                if (leftSide && this.yGridMode != ChartDiagram.GridMode.OFF && this.xAxis == null) {
                    ULine gridLine = ULine.hline(width);
                    ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dy(y)).draw(gridLine);
                }
                if (leftSide) {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(-5.0));
                } else {
                    ug.apply(UTranslate.dy(y)).draw(ULine.hline(5.0));
                }
                String label = this.formatValue(value);
                TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.RIGHT, this.skinParam);
                double textHeight = textBlock.calculateDimension(stringBounder).getHeight();
                if (leftSide) {
                    double textWidth = textBlock.calculateDimension(stringBounder).getWidth();
                    textBlock.drawU(ug.apply(UTranslate.dx(-5.0 - textWidth - 5.0).compose(UTranslate.dy(y - textHeight / 2.0))));
                    continue;
                }
                textBlock.drawU(ug.apply(UTranslate.dx(10.0).compose(UTranslate.dy(y - textHeight / 2.0))));
            }
        }
        if (axis.getTitle() != null && !axis.getTitle().isEmpty()) {
            if (axis.getLabelPosition() == ChartAxis.LabelPosition.TOP) {
                this.drawHorizontalAxisTitle(ug, axis.getTitle(), height, leftSide, fontColor, true, fontConfig);
            } else {
                this.drawVerticalText(ug, axis.getTitle(), height, leftSide, fontColor, fontConfig);
            }
        }
    }

    private void drawVerticalText(UGraphic ug, String text, double height, boolean leftSide, HColor fontColor, FontConfiguration axisFontConfig) {
        int orientation = leftSide ? 90 : 270;
        UText utext = UText.build(text, axisFontConfig).withOrientation(orientation);
        UFont font = axisFontConfig.getFont();
        double textWidth = ug.getStringBounder().calculateDimension(font, text).getWidth();
        double textHeight = ug.getStringBounder().calculateDimension(font, text).getHeight();
        double extraSpacing = 10.0;
        double xPos = leftSide ? -40.0 + textHeight / 2.0 - 10.0 : 40.0 - textHeight / 2.0 + 10.0;
        double yPos = leftSide ? height / 2.0 + textWidth / 2.0 : height / 2.0 - textWidth / 2.0;
        ug.apply(UTranslate.dx(xPos).compose(UTranslate.dy(yPos))).draw(utext);
    }

    private void drawHorizontalAxisTitle(UGraphic ug, String text, double height, boolean leftSide, HColor fontColor, boolean isVerticalAxis, FontConfiguration axisFontConfig) {
        TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), text).create(axisFontConfig, HorizontalAlignment.CENTER, this.skinParam);
        double textWidth = textBlock.calculateDimension(ug.getStringBounder()).getWidth();
        double textHeight = textBlock.calculateDimension(ug.getStringBounder()).getHeight();
        if (isVerticalAxis) {
            double xPos = leftSide ? -20.0 - textWidth / 2.0 : 20.0 - textWidth / 2.0;
            double yPos = -textHeight - 15.0;
            textBlock.drawU(ug.apply(UTranslate.dx(xPos).compose(UTranslate.dy(yPos))));
        } else {
            double xPos = height + 10.0;
            double yPos = -textHeight / 2.0;
            textBlock.drawU(ug.apply(UTranslate.dx(xPos).compose(UTranslate.dy(yPos))));
        }
    }

    private void drawXAxis(UGraphic ug, double width, double height, HColor lineColor, HColor fontColor) {
        if (this.orientation == ChartDiagram.Orientation.HORIZONTAL) {
            this.drawCategoriesVerticallyOnLeft(ug, height, lineColor, fontColor);
            return;
        }
        Style axisStyle = this.getAxisStyleSignature(true).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor styledLineColor = axisStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        double lineThickness = axisStyle.value(PName.LineThickness).asDouble();
        FontConfiguration fontConfig = axisStyle.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        HColor actualLineColor = styledLineColor != null ? styledLineColor : lineColor;
        ug = ug.apply(actualLineColor).apply(UStroke.withThickness(lineThickness));
        ug.draw(ULine.hline(width));
        StringBounder stringBounder = ug.getStringBounder();
        if (!this.xAxisLabels.isEmpty()) {
            int spacing;
            double categoryWidth = width / (double)this.xAxisLabels.size();
            Style gridStyle = this.getGridStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            HColor gridColor = gridStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
            if (gridColor == null) {
                try {
                    gridColor = this.skinParam.getIHtmlColorSet().getColor("#D0D0D0");
                }
                catch (Exception e) {
                    gridColor = lineColor;
                }
            }
            double gridThickness = gridStyle.value(PName.LineThickness).asDouble();
            UStroke gridStroke = UStroke.withThickness(gridThickness);
            int n = spacing = this.xAxisTickSpacing != null && this.xAxisTickSpacing > 0 ? this.xAxisTickSpacing : 1;
            if (this.xGridMode != ChartDiagram.GridMode.OFF) {
                double distanceToBottom;
                double distanceToTop;
                if (this.yAxis != null && this.yAxis.getMin() <= 0.0 && this.yAxis.getMax() >= 0.0) {
                    double zeroRatio = (0.0 - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin());
                    distanceToTop = height * (1.0 - zeroRatio);
                    distanceToBottom = height * zeroRatio;
                } else {
                    distanceToTop = height;
                    distanceToBottom = 0.0;
                }
                for (int i = 0; i < this.xAxisLabels.size(); ++i) {
                    double gridX = ((double)i + 0.5) * categoryWidth;
                    if (distanceToTop > 0.0) {
                        ULine gridLineUp = ULine.vline(-distanceToTop);
                        ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dx(gridX)).draw(gridLineUp);
                    }
                    if (!(distanceToBottom > 0.0)) continue;
                    ULine gridLineDown = ULine.vline(distanceToBottom);
                    ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dx(gridX)).draw(gridLineDown);
                }
            }
            for (int i = 0; i < this.xAxisLabels.size(); ++i) {
                double labelX = ((double)i + 0.5) * categoryWidth;
                if (i % spacing != 0) continue;
                ug.apply(UTranslate.dx(labelX)).draw(ULine.vline(5.0));
                TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisLabels.get(i)).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
                double textWidth = textBlock.calculateDimension(stringBounder).getWidth();
                textBlock.drawU(ug.apply(UTranslate.dx(labelX - textWidth / 2.0).compose(UTranslate.dy(10.0))));
            }
            if (this.xAxisTitle != null && !this.xAxisTitle.isEmpty()) {
                if (this.xAxisLabelPosition == ChartAxis.LabelPosition.RIGHT) {
                    TextBlock titleBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisTitle).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
                    double textHeight = titleBlock.calculateDimension(stringBounder).getHeight();
                    titleBlock.drawU(ug.apply(UTranslate.dx(width + 10.0).compose(UTranslate.dy(-textHeight / 2.0))));
                } else {
                    TextBlock titleBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisTitle).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
                    double titleWidth = titleBlock.calculateDimension(stringBounder).getWidth();
                    double titleY = 30.0;
                    titleBlock.drawU(ug.apply(UTranslate.dx(width / 2.0 - titleWidth / 2.0).compose(UTranslate.dy(30.0))));
                }
            }
        } else if (this.xAxis != null) {
            double startValue;
            double range = this.xAxis.getMax() - this.xAxis.getMin();
            double tickInterval = this.xAxisTickSpacing != null && this.xAxisTickSpacing > 0 ? (double)this.xAxisTickSpacing.intValue() : range / 10.0;
            for (double value = startValue = Math.floor(this.xAxis.getMin() / tickInterval) * tickInterval; value <= this.xAxis.getMax() + tickInterval * 0.01; value += tickInterval) {
                if (value < this.xAxis.getMin() - tickInterval * 0.01 || value > this.xAxis.getMax() + tickInterval * 0.01) continue;
                double x = this.xAxis.valueToPixel(value, 0.0, width);
                ug.apply(UTranslate.dx(x)).draw(ULine.vline(5.0));
                String label = this.formatAxisValue(value);
                TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
                double textWidth = textBlock.calculateDimension(stringBounder).getWidth();
                textBlock.drawU(ug.apply(UTranslate.dx(x - textWidth / 2.0).compose(UTranslate.dy(10.0))));
            }
            if (this.xAxisTitle != null && !this.xAxisTitle.isEmpty()) {
                if (this.xAxisLabelPosition == ChartAxis.LabelPosition.RIGHT) {
                    TextBlock titleBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisTitle).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
                    double textHeight = titleBlock.calculateDimension(stringBounder).getHeight();
                    titleBlock.drawU(ug.apply(UTranslate.dx(width + 10.0).compose(UTranslate.dy(-textHeight / 2.0))));
                } else {
                    TextBlock titleBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisTitle).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
                    double titleWidth = titleBlock.calculateDimension(stringBounder).getWidth();
                    double titleY = 30.0;
                    titleBlock.drawU(ug.apply(UTranslate.dx(width / 2.0 - titleWidth / 2.0).compose(UTranslate.dy(30.0))));
                }
            }
        }
    }

    private void drawCategoriesVerticallyOnLeft(UGraphic ug, double height, HColor lineColor, HColor fontColor) {
        ug.draw(ULine.vline(height));
        if (this.xAxisLabels.isEmpty()) {
            return;
        }
        UFont font = UFont.sansSerif(10);
        FontConfiguration fontConfig = FontConfiguration.create(font, fontColor, fontColor, null);
        double categoryHeight = height / (double)this.xAxisLabels.size();
        for (int i = 0; i < this.xAxisLabels.size(); ++i) {
            double y = ((double)i + 0.5) * categoryHeight;
            ug.apply(UTranslate.dx(-5.0).compose(UTranslate.dy(y))).draw(ULine.hline(5.0));
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), this.xAxisLabels.get(i)).create(fontConfig, HorizontalAlignment.RIGHT, this.skinParam);
            double textHeight = textBlock.calculateDimension(ug.getStringBounder()).getHeight();
            double textWidth = textBlock.calculateDimension(ug.getStringBounder()).getWidth();
            textBlock.drawU(ug.apply(UTranslate.dx(-5.0 - textWidth - 5.0).compose(UTranslate.dy(y - textHeight / 2.0))));
        }
    }

    private void drawYAxisHorizontally(UGraphic ug, double width, double height, ChartAxis axis, HColor lineColor, HColor fontColor) {
        ug.draw(ULine.hline(width));
        UFont font = UFont.sansSerif(10);
        FontConfiguration fontConfig = FontConfiguration.create(font, fontColor, fontColor, null);
        HColor gridColor = lineColor;
        try {
            gridColor = this.skinParam.getIHtmlColorSet().getColor("#D0D0D0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        double range = axis.getMax() - axis.getMin();
        int NUM_TICKS = 5;
        for (int i = 0; i <= 5; ++i) {
            double value = axis.getMin() + (double)i * range / 5.0;
            double x = width * (double)i / 5.0;
            ug.apply(UTranslate.dx(x)).draw(ULine.vline(5.0));
            String label = String.format("%.0f", value);
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), label).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
            double textWidth = textBlock.calculateDimension(ug.getStringBounder()).getWidth();
            textBlock.drawU(ug.apply(UTranslate.dx(x - textWidth / 2.0).compose(UTranslate.dy(10.0))));
        }
        if (axis.getTitle() != null && !axis.getTitle().isEmpty()) {
            TextBlock titleBlock = Display.getWithNewlines(this.skinParam.getPragma(), axis.getTitle()).create(fontConfig, HorizontalAlignment.CENTER, this.skinParam);
            double titleWidth = titleBlock.calculateDimension(ug.getStringBounder()).getWidth();
            double titleY = 30.0;
            titleBlock.drawU(ug.apply(UTranslate.dx(width / 2.0 - titleWidth / 2.0).compose(UTranslate.dy(30.0))));
        }
    }

    private void drawGridLines(UGraphic ug, double plotWidth, double plotHeight, HColor lineColor, HColor fontColor) {
        ULine gridLine;
        double startValue;
        double value;
        double tickInterval;
        double range;
        if (this.xAxis == null || this.yAxis == null) {
            return;
        }
        Style gridStyle = this.getGridStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor gridColor = gridStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (gridColor == null) {
            try {
                gridColor = this.skinParam.getIHtmlColorSet().getColor("#D0D0D0");
            }
            catch (Exception e) {
                gridColor = lineColor;
            }
        }
        double gridThickness = gridStyle.value(PName.LineThickness).asDouble();
        UStroke gridStroke = UStroke.withThickness(gridThickness);
        if (this.xGridMode != ChartDiagram.GridMode.OFF && this.xAxis != null) {
            range = this.xAxis.getMax() - this.xAxis.getMin();
            tickInterval = this.xAxisTickSpacing != null && this.xAxisTickSpacing > 0 ? (double)this.xAxisTickSpacing.intValue() : range / 10.0;
            for (value = startValue = Math.floor(this.xAxis.getMin() / tickInterval) * tickInterval; value <= this.xAxis.getMax() + tickInterval * 0.01; value += tickInterval) {
                if (value < this.xAxis.getMin() - tickInterval * 0.01 || value > this.xAxis.getMax() + tickInterval * 0.01) continue;
                double x = this.xAxis.valueToPixel(value, 0.0, plotWidth);
                gridLine = ULine.vline(plotHeight);
                ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dx(x)).draw(gridLine);
            }
        }
        if (this.yGridMode != ChartDiagram.GridMode.OFF && this.yAxis != null) {
            range = this.yAxis.getMax() - this.yAxis.getMin();
            tickInterval = this.yAxis.hasTickSpacing() ? this.yAxis.getTickSpacing() : range / 10.0;
            for (value = startValue = Math.ceil(this.yAxis.getMin() / tickInterval) * tickInterval; value <= this.yAxis.getMax() + tickInterval * 0.01; value += tickInterval) {
                if (value < this.yAxis.getMin() - tickInterval * 0.01 || value > this.yAxis.getMax() + tickInterval * 0.01) continue;
                double y = plotHeight * (1.0 - (value - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin()));
                gridLine = ULine.hline(plotWidth);
                ug.apply(gridColor).apply(gridStroke).apply(UTranslate.dy(y)).draw(gridLine);
            }
        }
    }

    private void drawSeries(UGraphic ug, double plotWidth, double plotHeight) {
        boolean hasCoordinatePairs;
        boolean bl = hasCoordinatePairs = !this.series.isEmpty() && this.series.get(0).hasExplicitXValues();
        if (this.xAxisLabels.isEmpty() && !hasCoordinatePairs || this.series.isEmpty()) {
            return;
        }
        ArrayList<ChartSeries> barSeries = new ArrayList<ChartSeries>();
        ArrayList<HColor> barColors = new ArrayList<HColor>();
        for (ChartSeries s : this.series) {
            if (s.getType() != ChartSeries.SeriesType.BAR) continue;
            barSeries.add(s);
            Style barStyle = this.getBarStyle(s);
            HColor color = s.getColor();
            if (color == null && (color = barStyle.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet())) == null) {
                color = this.getDefaultColor(this.series.indexOf(s));
            }
            barColors.add(color);
        }
        if (!barSeries.isEmpty()) {
            ChartAxis axis = ((ChartSeries)barSeries.get(0)).isUseSecondaryAxis() && this.y2Axis != null ? this.y2Axis : this.yAxis;
            boolean isHorizontal = this.orientation == ChartDiagram.Orientation.HORIZONTAL;
            BarRenderer barRenderer = new BarRenderer(this.skinParam, plotWidth, plotHeight, this.xAxisLabels.size(), axis, isHorizontal);
            if (barSeries.size() == 1) {
                barRenderer.draw(ug, (ChartSeries)barSeries.get(0), (HColor)barColors.get(0));
            } else if (this.stackMode == ChartDiagram.StackMode.STACKED) {
                barRenderer.drawStacked(ug, barSeries, barColors);
            } else {
                barRenderer.drawGrouped(ug, barSeries, barColors);
            }
        }
        ArrayList<ChartSeries> areaSeries = new ArrayList<ChartSeries>();
        ArrayList<HColor> areaColors = new ArrayList<HColor>();
        for (ChartSeries s : this.series) {
            Style seriesStyle;
            if (s.getType() == ChartSeries.SeriesType.AREA) {
                areaSeries.add(s);
                Style areaStyle = this.getAreaStyle(s);
                HColor color = s.getColor();
                if (color == null) {
                    color = areaStyle.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
                    if (color == null) {
                        color = areaStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
                    }
                    if (color == null) {
                        color = this.getDefaultColor(this.series.indexOf(s));
                    }
                }
                areaColors.add(color);
                continue;
            }
            if (s.getType() == ChartSeries.SeriesType.BAR) continue;
            ChartAxis axis = s.isUseSecondaryAxis() && this.y2Axis != null ? this.y2Axis : this.yAxis;
            switch (s.getType()) {
                case LINE: {
                    seriesStyle = this.getLineStyle(s);
                    break;
                }
                case SCATTER: {
                    seriesStyle = this.getScatterStyle(s);
                    break;
                }
                default: {
                    seriesStyle = this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
                }
            }
            HColor color = s.getColor();
            if (color == null && (color = seriesStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet())) == null) {
                color = this.getDefaultColor(this.series.indexOf(s));
            }
            if (s.getType() == ChartSeries.SeriesType.LINE) {
                LineRenderer lineRenderer = new LineRenderer(this.skinParam, plotWidth, plotHeight, this.xAxisLabels.size(), axis, this.xAxis);
                lineRenderer.draw(ug, s, color);
                continue;
            }
            if (s.getType() != ChartSeries.SeriesType.SCATTER) continue;
            ScatterRenderer scatterRenderer = new ScatterRenderer(this.skinParam, plotWidth, plotHeight, this.xAxisLabels.size(), axis, this.xAxis);
            scatterRenderer.draw(ug, s, color);
        }
        if (!areaSeries.isEmpty()) {
            ChartAxis axis = ((ChartSeries)areaSeries.get(0)).isUseSecondaryAxis() && this.y2Axis != null ? this.y2Axis : this.yAxis;
            AreaRenderer areaRenderer = new AreaRenderer(this.skinParam, plotWidth, plotHeight, this.xAxisLabels.size(), axis);
            ArrayList<Double> cumulativeValues = null;
            for (int i = 0; i < areaSeries.size(); ++i) {
                int j;
                ChartSeries areaSer = (ChartSeries)areaSeries.get(i);
                HColor color = (HColor)areaColors.get(i);
                areaRenderer.draw(ug, areaSer, color, cumulativeValues);
                if (cumulativeValues == null) {
                    cumulativeValues = new ArrayList<Double>(areaSer.getValues());
                    continue;
                }
                for (j = 0; j < Math.min(areaSer.getValues().size(), cumulativeValues.size()); ++j) {
                    cumulativeValues.set(j, (Double)cumulativeValues.get(j) + areaSer.getValues().get(j));
                }
                for (j = cumulativeValues.size(); j < areaSer.getValues().size(); ++j) {
                    cumulativeValues.add(areaSer.getValues().get(j));
                }
            }
        }
    }

    private double getPlotWidth() {
        return Math.max(400, this.xAxisLabels.size() * 60);
    }

    private double getPlotHeight() {
        return 300.0;
    }

    private String formatValue(double value) {
        if (Math.abs(value) < 0.01 && value != 0.0) {
            return String.format("%.2e", value);
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%.2f", value);
    }

    private HColor getDefaultColor(int index) {
        String[] defaultColors = new String[]{"#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf"};
        try {
            return this.skinParam.getIHtmlColorSet().getColor(defaultColors[index % defaultColors.length]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram);
    }

    private StyleSignatureBasic getBarStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.bar);
    }

    private Style getBarStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getBarStyleSignature();
        if (series.getStereotype() != null) {
            Style style = signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            Style stereoStyle = signature.forStereotypeItself(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            if (style != null) {
                stereoStyle = style.mergeWith(stereoStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            }
            return stereoStyle;
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getLineStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.line);
    }

    private Style getLineStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getLineStyleSignature();
        if (series.getStereotype() != null) {
            Style style = signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            Style stereoStyle = signature.forStereotypeItself(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            if (style != null) {
                stereoStyle = style.mergeWith(stereoStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            }
            return stereoStyle;
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getAreaStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.area);
    }

    private Style getAreaStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getAreaStyleSignature();
        if (series.getStereotype() != null) {
            Style style = signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            Style stereoStyle = signature.forStereotypeItself(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            if (style != null) {
                stereoStyle = style.mergeWith(stereoStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            }
            return stereoStyle;
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private String formatAxisValue(double value) {
        if (Math.abs(value) < 0.01 && value != 0.0) {
            return String.format("%.2e", value);
        }
        if (value == (double)((long)value)) {
            return String.format("%d", (long)value);
        }
        return String.format("%.1f", value);
    }

    private StyleSignatureBasic getScatterStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.scatter);
    }

    private Style getScatterStyle(ChartSeries series) {
        StyleSignatureBasic signature = this.getScatterStyleSignature();
        if (series.getStereotype() != null) {
            Style style = signature.withTOBECHANGED(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            Style stereoStyle = signature.forStereotypeItself(series.getStereotype()).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            if (style != null) {
                stereoStyle = style.mergeWith(stereoStyle, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            }
            return stereoStyle;
        }
        return signature.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getAxisStyleSignature(boolean horizontal) {
        SName axisType = horizontal ? SName.hAxis : SName.vAxis;
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.axis, axisType);
    }

    private StyleSignatureBasic getGridStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.grid);
    }

    private StyleSignatureBasic getLegendStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.legend);
    }

    private StyleSignatureBasic getAnnotationStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chartDiagram, SName.annotation);
    }

    private XDimension2D calculateLegendDimension(StringBounder stringBounder) {
        if (this.legendPosition == ChartDiagram.LegendPosition.NONE || this.series.isEmpty()) {
            return new XDimension2D(0.0, 0.0);
        }
        Style legendStyle = this.getLegendStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfig = legendStyle.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        double maxWidth = 0.0;
        double totalHeight = 0.0;
        for (ChartSeries s : this.series) {
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), s.getName()).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
            XDimension2D dim = textBlock.calculateDimension(stringBounder);
            if (this.legendPosition == ChartDiagram.LegendPosition.LEFT || this.legendPosition == ChartDiagram.LegendPosition.RIGHT) {
                maxWidth = Math.max(maxWidth, dim.getWidth());
                totalHeight += dim.getHeight() + 15.0;
                continue;
            }
            maxWidth += dim.getWidth() + 12.0 + 5.0 + 15.0;
            totalHeight = Math.max(totalHeight, dim.getHeight());
        }
        if (this.legendPosition == ChartDiagram.LegendPosition.LEFT || this.legendPosition == ChartDiagram.LegendPosition.RIGHT) {
            return new XDimension2D(maxWidth + 12.0 + 5.0 + 20.0, totalHeight);
        }
        return new XDimension2D(maxWidth, totalHeight + 20.0);
    }

    private void drawLegend(UGraphic ug, double leftMargin, double topMargin, double plotWidth, double plotHeight, HColor lineColor, HColor fontColor) {
        if (this.legendPosition == ChartDiagram.LegendPosition.NONE || this.series.isEmpty()) {
            return;
        }
        Style legendStyle = this.getLegendStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfig = legendStyle.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        double x = 0.0;
        double y = 0.0;
        switch (this.legendPosition) {
            case LEFT: {
                x = 20.0;
                y = topMargin;
                break;
            }
            case RIGHT: {
                x = leftMargin + plotWidth + (this.y2Axis != null ? 40.0 : 0.0) + 10.0;
                y = topMargin;
                break;
            }
            case TOP: {
                x = leftMargin;
                y = 20.0;
                break;
            }
            case BOTTOM: {
                x = leftMargin;
                y = topMargin + plotHeight + 40.0 + 10.0;
                break;
            }
            default: {
                return;
            }
        }
        double currentX = x;
        double currentY = y;
        for (int i = 0; i < this.series.size(); ++i) {
            URectangle rect;
            HColor styleColor;
            HColor color;
            ChartSeries s = this.series.get(i);
            HColor hColor = color = s.getColor() != null ? s.getColor() : this.getDefaultColor(i);
            if (s.getType() == ChartSeries.SeriesType.BAR) {
                Style barStyle;
                if (s.getColor() == null && (styleColor = (barStyle = this.getBarStyle(s)).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet())) != null) {
                    color = styleColor;
                }
                rect = URectangle.build(12.0, 12.0);
                ug.apply(color).apply(color.bg()).apply(UTranslate.dx(currentX).compose(UTranslate.dy(currentY))).draw(rect);
            } else if (s.getType() == ChartSeries.SeriesType.LINE) {
                Style lineStyle;
                if (s.getColor() == null && (styleColor = (lineStyle = this.getLineStyle(s)).value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet())) != null) {
                    color = styleColor;
                }
                ULine line = ULine.hline(12.0);
                ug.apply(color).apply(UStroke.withThickness(2.0)).apply(UTranslate.dx(currentX).compose(UTranslate.dy(currentY + 6.0))).draw(line);
            } else if (s.getType() == ChartSeries.SeriesType.AREA) {
                Style areaStyle;
                if (s.getColor() == null && (styleColor = (areaStyle = this.getAreaStyle(s)).value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet())) != null) {
                    color = styleColor;
                }
                rect = URectangle.build(12.0, 12.0);
                ug.apply(color).apply(color.bg()).apply(UTranslate.dx(currentX).compose(UTranslate.dy(currentY))).draw(rect);
            } else if (s.getType() == ChartSeries.SeriesType.SCATTER) {
                HColor styleLineColor;
                Style scatterStyle = this.getScatterStyle(s);
                HColor markerColor = color;
                HColor styleMarkerColor = scatterStyle.value(PName.MarkerColor).asColor(this.skinParam.getIHtmlColorSet());
                if (styleMarkerColor != null) {
                    markerColor = styleMarkerColor;
                } else if (s.getColor() == null && (styleLineColor = scatterStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet())) != null) {
                    markerColor = styleLineColor;
                }
                ChartSeries.MarkerShape markerShape = s.getMarkerShape();
                try {
                    String styleMarkerShape = scatterStyle.value(PName.MarkerShape).asString();
                    if (styleMarkerShape != null && !styleMarkerShape.isEmpty()) {
                        switch (styleMarkerShape.toLowerCase()) {
                            case "circle": {
                                markerShape = ChartSeries.MarkerShape.CIRCLE;
                                break;
                            }
                            case "square": {
                                markerShape = ChartSeries.MarkerShape.SQUARE;
                                break;
                            }
                            case "triangle": {
                                markerShape = ChartSeries.MarkerShape.TRIANGLE;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.drawLegendScatterMarker(ug, markerColor, currentX + 6.0, currentY + 6.0, 8.399999999999999, markerShape);
            }
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), s.getName()).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(ug.getStringBounder());
            textBlock.drawU(ug.apply(UTranslate.dx(currentX + 12.0 + 5.0).compose(UTranslate.dy(currentY))));
            if (this.legendPosition == ChartDiagram.LegendPosition.LEFT || this.legendPosition == ChartDiagram.LegendPosition.RIGHT) {
                currentY += textDim.getHeight() + 15.0;
                continue;
            }
            currentX += 17.0 + textDim.getWidth() + 15.0;
        }
    }

    private void drawLegendScatterMarker(UGraphic ug, HColor color, double x, double y, double size, ChartSeries.MarkerShape shape) {
        switch (shape) {
            case CIRCLE: {
                UEllipse circle = UEllipse.build(size, size);
                ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x - size / 2.0).compose(UTranslate.dy(y - size / 2.0))).draw(circle);
                break;
            }
            case SQUARE: {
                URectangle square = URectangle.build(size, size);
                ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x - size / 2.0).compose(UTranslate.dy(y - size / 2.0))).draw(square);
                break;
            }
            case TRIANGLE: {
                UPolygon triangle = new UPolygon();
                triangle.addPoint(0.0, -size / 2.0);
                triangle.addPoint(-size / 2.0, size / 2.0);
                triangle.addPoint(size / 2.0, size / 2.0);
                ug.apply(color).apply(color.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(y))).draw(triangle);
            }
        }
    }

    private void drawAnnotations(UGraphic ug, double plotWidth, double plotHeight, HColor lineColor, HColor fontColor) {
        if (this.annotations == null || this.annotations.isEmpty()) {
            return;
        }
        Style annotationStyle = this.getAnnotationStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        FontConfiguration fontConfig = annotationStyle.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        HColor arrowColor = annotationStyle.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        if (arrowColor == null) {
            arrowColor = HColors.BLACK;
            try {
                arrowColor = this.skinParam.getIHtmlColorSet().getColor("#000000");
            }
            catch (Exception e) {
                arrowColor = lineColor;
            }
        }
        double arrowThickness = annotationStyle.value(PName.LineThickness).asDouble();
        for (ChartAnnotation annotation : this.annotations) {
            double x = 0.0;
            double y = 0.0;
            if (annotation.getXPosition() instanceof Double) {
                double xValue = (Double)annotation.getXPosition();
                if (this.orientation == ChartDiagram.Orientation.HORIZONTAL) {
                    y = plotHeight * (1.0 - (xValue - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin()));
                } else {
                    x = plotWidth * ((xValue - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin()));
                }
            } else if (annotation.getXPosition() instanceof String) {
                String xLabel = (String)annotation.getXPosition();
                int index = this.xAxisLabels.indexOf(xLabel);
                if (index < 0) continue;
                if (this.orientation == ChartDiagram.Orientation.HORIZONTAL) {
                    y = plotHeight * ((double)index + 0.5) / (double)this.xAxisLabels.size();
                } else {
                    x = plotWidth * ((double)index + 0.5) / (double)this.xAxisLabels.size();
                }
            }
            if (this.orientation == ChartDiagram.Orientation.HORIZONTAL) {
                x = plotWidth * ((annotation.getYPosition() - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin()));
            } else {
                y = plotHeight * (1.0 - (annotation.getYPosition() - this.yAxis.getMin()) / (this.yAxis.getMax() - this.yAxis.getMin()));
            }
            TextBlock textBlock = Display.getWithNewlines(this.skinParam.getPragma(), annotation.getText()).create(fontConfig, HorizontalAlignment.LEFT, this.skinParam);
            XDimension2D textDim = textBlock.calculateDimension(ug.getStringBounder());
            if (annotation.isShowArrow()) {
                UPolygon arrowhead;
                ULine arrowLine;
                double arrowLength;
                double arrowStartY;
                double arrowEndY;
                double textY;
                double textX;
                boolean placeAbove;
                double minSpaceAbove = textDim.getHeight() + 40.0;
                boolean bl = placeAbove = y > minSpaceAbove;
                if (placeAbove) {
                    textX = x - textDim.getWidth() / 2.0;
                    textY = y - textDim.getHeight() - 40.0;
                    textBlock.drawU(ug.apply(UTranslate.dx(textX).compose(UTranslate.dy(textY))));
                    arrowEndY = y - 5.0;
                    arrowStartY = textY + textDim.getHeight() + 5.0;
                    arrowLength = arrowEndY - arrowStartY;
                    if (!(arrowLength > 0.0)) continue;
                    arrowLine = new ULine(0.0, arrowLength);
                    ug.apply(arrowColor).apply(UStroke.withThickness(arrowThickness)).apply(UTranslate.dx(x).compose(UTranslate.dy(arrowStartY))).draw(arrowLine);
                    arrowhead = new UPolygon();
                    arrowhead.addPoint(0.0, 0.0);
                    arrowhead.addPoint(-5.0, -8.0);
                    arrowhead.addPoint(5.0, -8.0);
                    ug.apply(arrowColor).apply(arrowColor.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(arrowEndY))).draw(arrowhead);
                    continue;
                }
                textX = x - textDim.getWidth() / 2.0;
                textY = y + 40.0;
                textBlock.drawU(ug.apply(UTranslate.dx(textX).compose(UTranslate.dy(textY))));
                arrowStartY = textY - 5.0;
                arrowEndY = y + 5.0;
                arrowLength = arrowStartY - arrowEndY;
                if (!(arrowLength > 0.0)) continue;
                arrowLine = new ULine(0.0, -arrowLength);
                ug.apply(arrowColor).apply(UStroke.withThickness(arrowThickness)).apply(UTranslate.dx(x).compose(UTranslate.dy(arrowStartY))).draw(arrowLine);
                arrowhead = new UPolygon();
                arrowhead.addPoint(0.0, 0.0);
                arrowhead.addPoint(-5.0, 8.0);
                arrowhead.addPoint(5.0, 8.0);
                ug.apply(arrowColor).apply(arrowColor.bg()).apply(UTranslate.dx(x).compose(UTranslate.dy(arrowEndY))).draw(arrowhead);
                continue;
            }
            textBlock.drawU(ug.apply(UTranslate.dx(x - textDim.getWidth() / 2.0).compose(UTranslate.dy(y - textDim.getHeight() - 5.0))));
        }
    }
}

