/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.PaddingParam;
import net.sourceforge.plantuml.skin.SkinParamBackcolored;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.WithStyle;

public class Doll
implements WithStyle {
    private final List<Participant> participants = new ArrayList<Participant>();
    private final Map<ParticipantEnglober, Doll> alls;
    private final ParticipantEnglober englober;
    private final StyleBuilder styleBuilder;
    private final TileArguments tileArguments;

    public static Doll createPuma(ParticipantEnglober englober, Participant first, ISkinParam skinParam, Rose skin, StringBounder stringBounder, StyleBuilder styleBuilder) {
        return new Doll(englober, Doll.convertFunctionToBeRemoved(skinParam, skin, stringBounder), styleBuilder, first, null);
    }

    public static Doll createTeoz(ParticipantEnglober englober, TileArguments tileArguments, Map<ParticipantEnglober, Doll> alls) {
        return new Doll(englober, tileArguments, tileArguments.getSkinParam().getCurrentStyleBuilder(), null, alls);
    }

    private static TileArguments convertFunctionToBeRemoved(ISkinParam skinParam, Rose skin, StringBounder stringBounder) {
        return new TileArguments(stringBounder, null, skin, skinParam, null, null);
    }

    private Doll(ParticipantEnglober englober, TileArguments tileArguments, StyleBuilder styleBuilder, Participant first, Map<ParticipantEnglober, Doll> alls) {
        this.englober = Objects.requireNonNull(englober);
        this.styleBuilder = styleBuilder;
        this.tileArguments = Objects.requireNonNull(tileArguments);
        this.alls = alls;
        if (first != null) {
            this.participants.add(first);
        }
    }

    @Override
    public final StyleSignature getStyleSignature() {
        return ComponentType.ENGLOBER.getStyleSignature();
    }

    @Override
    public final Style[] getUsedStyles() {
        Style tmp = this.getStyleSignature().withTOBECHANGED(this.englober.getStereotype()).getMergedStyle(this.styleBuilder);
        HColor backColor = this.englober.getBoxColor();
        if (tmp != null) {
            tmp = tmp.eventuallyOverride(PName.BackGroundColor, backColor);
        }
        return new Style[]{tmp};
    }

    public final ParticipantEnglober getParticipantEnglober() {
        return this.englober;
    }

    private Component getComponent() {
        ParticipantEnglober englober = this.getParticipantEnglober();
        ISkinParam s = englober.getBoxColor() == null ? this.tileArguments.getSkinParam() : new SkinParamBackcolored(this.tileArguments.getSkinParam(), englober.getBoxColor());
        return this.tileArguments.getSkin().createComponent(this.getUsedStyles(), ComponentType.ENGLOBER, null, s, englober.getTitle());
    }

    public double getTitlePreferredHeight() {
        Component comp = this.tileArguments.getSkin().createComponent(this.getUsedStyles(), ComponentType.ENGLOBER, null, this.tileArguments.getSkinParam(), this.getParticipantEnglober().getTitle());
        return comp.getPreferredHeight(this.tileArguments.getStringBounder());
    }

    public final Participant getFirst2TOBEPRIVATE() {
        return this.participants.get(0);
    }

    public final Participant getLast2TOBEPRIVATE() {
        return this.participants.get(this.participants.size() - 1);
    }

    private Real getPosA(StringBounder stringBounder) {
        return this.getFirstLivingSpace().getPosA(stringBounder);
    }

    private Real getPosB(StringBounder stringBounder) {
        return this.getFirstLivingSpace().getPosB(stringBounder);
    }

    private Real getPosD(StringBounder stringBounder) {
        return this.getLastLivingSpace().getPosD(stringBounder);
    }

    private Real getPosE(StringBounder stringBounder) {
        return this.getLastLivingSpace().getPosE(stringBounder);
    }

    private Real getPosAA(StringBounder stringBounder) {
        LivingSpace previous = this.tileArguments.getLivingSpaces().previous(this.getFirstLivingSpace());
        if (previous == null) {
            return this.tileArguments.getXOrigin();
        }
        return previous.getPosD(stringBounder);
    }

    private LivingSpace getFirstLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getFirst2TOBEPRIVATE());
    }

    private LivingSpace getLastLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getLast2TOBEPRIVATE());
    }

    public boolean contains(Participant p) {
        return this.participants.contains(p);
    }

    public void addParticipant(Participant p) {
        this.participants.add(Objects.requireNonNull(p));
    }

    public String toString() {
        return "Doll:" + this.englober.getTitle().toString() + " " + this.participants;
    }

    private double getTitleWidth() {
        return this.getComponent().getPreferredWidth(this.tileArguments.getStringBounder());
    }

    public void drawMe(UGraphic ug, double height, Context2D context, Doll group) {
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = this.getPosA(stringBounder).getCurrentValue() - 4.0;
        double x2 = this.getPosE(stringBounder).getCurrentValue() + 4.0;
        for (Doll current = group; current != null; current = current.getParent()) {
            double titlePreferredHeight = current.getTitlePreferredHeight();
            ug = ug.apply(UTranslate.dy(titlePreferredHeight));
            height -= titlePreferredHeight;
        }
        XDimension2D dim = new XDimension2D(x2 - x1, height);
        this.getComponent().drawU(ug.apply(new UTranslate(x1, 1.0)), new Area(dim), context);
    }

    public Doll getParent() {
        ParticipantEnglober parent = this.getParticipantEnglober().getParent();
        if (parent == null) {
            return null;
        }
        return this.alls.get(parent);
    }

    public void addInternalConstraints(StringBounder stringBounder) {
        double titleWidth = this.getTitleWidth();
        double x1 = this.getPosB(stringBounder).getCurrentValue();
        double x2 = this.getPosD(stringBounder).getCurrentValue();
        double actualWidth = x2 - x1;
        double marginX = (titleWidth + 10.0 - actualWidth) / 2.0;
        if (marginX > 0.0) {
            this.getFirstLivingSpace().ensureMarginBefore(marginX);
            this.getLastLivingSpace().ensureMarginAfter(marginX);
        }
        this.getPosA(stringBounder).ensureBiggerThan(this.getPosAA(stringBounder).addFixed(10.0 + this.padding()));
    }

    public void addConstraintAfter(StringBounder stringBounder) {
        LivingSpace next = this.tileArguments.getLivingSpaces().next(this.getLastLivingSpace());
        if (next == null) {
            return;
        }
        next.getPosA(stringBounder).ensureBiggerThan(this.getPosE(stringBounder).addFixed(20.0 + 2.0 * this.padding()));
    }

    private double padding() {
        return this.tileArguments.getSkinParam().getPadding(PaddingParam.BOX);
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getPosA(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.getPosE(stringBounder).addFixed(10.0);
    }
}

