/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_TOPLEVEL_ICON_V1_CLIENT_PROTOCOL_H
#define XDG_TOPLEVEL_ICON_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xdg_toplevel_icon_v1 The xdg_toplevel_icon_v1 protocol
 * protocol to assign icons to toplevels
 *
 * @section page_desc_xdg_toplevel_icon_v1 Description
 *
 * This protocol allows clients to set icons for their toplevel surfaces
 * either via the XDG icon stock (using an icon name), or from pixel data.
 *
 * A toplevel icon represents the individual toplevel (unlike the application
 * or launcher icon, which represents the application as a whole), and may be
 * shown in window switchers, window overviews and taskbars that list
 * individual windows.
 *
 * This document adheres to RFC 2119 when using words like "must",
 * "should", "may", etc.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_xdg_toplevel_icon_v1 Interfaces
 * - @subpage page_iface_xdg_toplevel_icon_manager_v1 - interface to manage toplevel icons
 * - @subpage page_iface_xdg_toplevel_icon_v1 - a toplevel window icon
 * @section page_copyright_xdg_toplevel_icon_v1 Copyright
 * <pre>
 *
 * Copyright © 2023-2024 Matthias Klumpp
 * Copyright ©      2024 David Edmundson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct xdg_toplevel;
struct xdg_toplevel_icon_manager_v1;
struct xdg_toplevel_icon_v1;

#ifndef XDG_TOPLEVEL_ICON_MANAGER_V1_INTERFACE
#define XDG_TOPLEVEL_ICON_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xdg_toplevel_icon_manager_v1 xdg_toplevel_icon_manager_v1
 * @section page_iface_xdg_toplevel_icon_manager_v1_desc Description
 *
 * This interface allows clients to create toplevel window icons and set
 * them on toplevel windows to be displayed to the user.
 * @section page_iface_xdg_toplevel_icon_manager_v1_api API
 * See @ref iface_xdg_toplevel_icon_manager_v1.
 */
/**
 * @defgroup iface_xdg_toplevel_icon_manager_v1 The xdg_toplevel_icon_manager_v1 interface
 *
 * This interface allows clients to create toplevel window icons and set
 * them on toplevel windows to be displayed to the user.
 */
extern const struct wl_interface xdg_toplevel_icon_manager_v1_interface;
#endif
#ifndef XDG_TOPLEVEL_ICON_V1_INTERFACE
#define XDG_TOPLEVEL_ICON_V1_INTERFACE
/**
 * @page page_iface_xdg_toplevel_icon_v1 xdg_toplevel_icon_v1
 * @section page_iface_xdg_toplevel_icon_v1_desc Description
 *
 * This interface defines a toplevel icon.
 * An icon can have a name, and multiple buffers.
 * In order to be applied, the icon must have either a name, or at least
 * one buffer assigned. Applying an empty icon (with no buffer or name) to
 * a toplevel should reset its icon to the default icon.
 *
 * It is up to compositor policy whether to prefer using a buffer or loading
 * an icon via its name. See 'set_name' and 'add_buffer' for details.
 * @section page_iface_xdg_toplevel_icon_v1_api API
 * See @ref iface_xdg_toplevel_icon_v1.
 */
/**
 * @defgroup iface_xdg_toplevel_icon_v1 The xdg_toplevel_icon_v1 interface
 *
 * This interface defines a toplevel icon.
 * An icon can have a name, and multiple buffers.
 * In order to be applied, the icon must have either a name, or at least
 * one buffer assigned. Applying an empty icon (with no buffer or name) to
 * a toplevel should reset its icon to the default icon.
 *
 * It is up to compositor policy whether to prefer using a buffer or loading
 * an icon via its name. See 'set_name' and 'add_buffer' for details.
 */
extern const struct wl_interface xdg_toplevel_icon_v1_interface;
#endif

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 * @struct xdg_toplevel_icon_manager_v1_listener
 */
struct xdg_toplevel_icon_manager_v1_listener {
	/**
	 * describes a supported & preferred icon size
	 *
	 * This event indicates an icon size the compositor prefers to be
	 * available if the client has scalable icons and can render to any
	 * size.
	 *
	 * When the 'xdg_toplevel_icon_manager_v1' object is created, the
	 * compositor may send one or more 'icon_size' events to describe
	 * the list of preferred icon sizes. If the compositor has no size
	 * preference, it may not send any 'icon_size' event, and it is up
	 * to the client to decide a suitable icon size.
	 *
	 * A sequence of 'icon_size' events must be finished with a 'done'
	 * event. If the compositor has no size preferences, it must still
	 * send the 'done' event, without any preceding 'icon_size' events.
	 * @param size the edge size of the square icon in surface-local coordinates, e.g. 64
	 */
	void (*icon_size)(void *data,
			  struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1,
			  int32_t size);
	/**
	 * all information has been sent
	 *
	 * This event is sent after all 'icon_size' events have been
	 * sent.
	 */
	void (*done)(void *data,
		     struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1);
};

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
static inline int
xdg_toplevel_icon_manager_v1_add_listener(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1,
					  const struct xdg_toplevel_icon_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) xdg_toplevel_icon_manager_v1,
				     (void (**)(void)) listener, data);
}

#define XDG_TOPLEVEL_ICON_MANAGER_V1_DESTROY 0
#define XDG_TOPLEVEL_ICON_MANAGER_V1_CREATE_ICON 1
#define XDG_TOPLEVEL_ICON_MANAGER_V1_SET_ICON 2

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_ICON_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_CREATE_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 */
#define XDG_TOPLEVEL_ICON_MANAGER_V1_SET_ICON_SINCE_VERSION 1

/** @ingroup iface_xdg_toplevel_icon_manager_v1 */
static inline void
xdg_toplevel_icon_manager_v1_set_user_data(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xdg_toplevel_icon_manager_v1, user_data);
}

/** @ingroup iface_xdg_toplevel_icon_manager_v1 */
static inline void *
xdg_toplevel_icon_manager_v1_get_user_data(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xdg_toplevel_icon_manager_v1);
}

static inline uint32_t
xdg_toplevel_icon_manager_v1_get_version(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_manager_v1);
}

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 *
 * Destroy the toplevel icon manager.
 * This does not destroy objects created with the manager.
 */
static inline void
xdg_toplevel_icon_manager_v1_destroy(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_manager_v1,
			 XDG_TOPLEVEL_ICON_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 *
 * Creates a new icon object. This icon can then be attached to a
 * xdg_toplevel via the 'set_icon' request.
 */
static inline struct xdg_toplevel_icon_v1 *
xdg_toplevel_icon_manager_v1_create_icon(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_manager_v1,
			 XDG_TOPLEVEL_ICON_MANAGER_V1_CREATE_ICON, &xdg_toplevel_icon_v1_interface, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_manager_v1), 0, NULL);

	return (struct xdg_toplevel_icon_v1 *) id;
}

/**
 * @ingroup iface_xdg_toplevel_icon_manager_v1
 *
 * This request assigns the icon 'icon' to 'toplevel', or clears the
 * toplevel icon if 'icon' was null.
 * This state is double-buffered and is applied on the next
 * wl_surface.commit of the toplevel.
 *
 * After making this call, the xdg_toplevel_icon_v1 provided as 'icon'
 * can be destroyed by the client without 'toplevel' losing its icon.
 * The xdg_toplevel_icon_v1 is immutable from this point, and any
 * future attempts to change it must raise the
 * 'xdg_toplevel_icon_v1.immutable' protocol error.
 *
 * The compositor must set the toplevel icon from either the pixel data
 * the icon provides, or by loading a stock icon using the icon name.
 * See the description of 'xdg_toplevel_icon_v1' for details.
 *
 * If 'icon' is set to null, the icon of the respective toplevel is reset
 * to its default icon (usually the icon of the application, derived from
 * its desktop-entry file, or a placeholder icon).
 * If this request is passed an icon with no pixel buffers or icon name
 * assigned, the icon must be reset just like if 'icon' was null.
 */
static inline void
xdg_toplevel_icon_manager_v1_set_icon(struct xdg_toplevel_icon_manager_v1 *xdg_toplevel_icon_manager_v1, struct xdg_toplevel *toplevel, struct xdg_toplevel_icon_v1 *icon)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_manager_v1,
			 XDG_TOPLEVEL_ICON_MANAGER_V1_SET_ICON, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_manager_v1), 0, toplevel, icon);
}

#ifndef XDG_TOPLEVEL_ICON_V1_ERROR_ENUM
#define XDG_TOPLEVEL_ICON_V1_ERROR_ENUM
enum xdg_toplevel_icon_v1_error {
	/**
	 * the provided buffer does not satisfy requirements
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_INVALID_BUFFER = 1,
	/**
	 * the icon has already been assigned to a toplevel and must not be changed
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_IMMUTABLE = 2,
	/**
	 * the provided buffer has been destroyed before the toplevel icon
	 */
	XDG_TOPLEVEL_ICON_V1_ERROR_NO_BUFFER = 3,
};
#endif /* XDG_TOPLEVEL_ICON_V1_ERROR_ENUM */

#define XDG_TOPLEVEL_ICON_V1_DESTROY 0
#define XDG_TOPLEVEL_ICON_V1_SET_NAME 1
#define XDG_TOPLEVEL_ICON_V1_ADD_BUFFER 2


/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_SET_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_toplevel_icon_v1
 */
#define XDG_TOPLEVEL_ICON_V1_ADD_BUFFER_SINCE_VERSION 1

/** @ingroup iface_xdg_toplevel_icon_v1 */
static inline void
xdg_toplevel_icon_v1_set_user_data(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xdg_toplevel_icon_v1, user_data);
}

/** @ingroup iface_xdg_toplevel_icon_v1 */
static inline void *
xdg_toplevel_icon_v1_get_user_data(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xdg_toplevel_icon_v1);
}

static inline uint32_t
xdg_toplevel_icon_v1_get_version(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_v1);
}

/**
 * @ingroup iface_xdg_toplevel_icon_v1
 *
 * Destroys the 'xdg_toplevel_icon_v1' object.
 * The icon must still remain set on every toplevel it was assigned to,
 * until the toplevel icon is reset explicitly.
 */
static inline void
xdg_toplevel_icon_v1_destroy(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_v1,
			 XDG_TOPLEVEL_ICON_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xdg_toplevel_icon_v1
 *
 * This request assigns an icon name to this icon.
 * Any previously set name is overridden.
 *
 * The compositor must resolve 'icon_name' according to the lookup rules
 * described in the XDG icon theme specification[1] using the
 * environment's current icon theme.
 *
 * If the compositor does not support icon names or cannot resolve
 * 'icon_name' according to the XDG icon theme specification it must
 * fall back to using pixel buffer data instead.
 *
 * If this request is made after the icon has been assigned to a toplevel
 * via 'set_icon', a 'immutable' error must be raised.
 *
 * [1]: https://specifications.freedesktop.org/icon-theme-spec/icon-theme-spec-latest.html
 */
static inline void
xdg_toplevel_icon_v1_set_name(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1, const char *icon_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_v1,
			 XDG_TOPLEVEL_ICON_V1_SET_NAME, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_v1), 0, icon_name);
}

/**
 * @ingroup iface_xdg_toplevel_icon_v1
 *
 * This request adds pixel data supplied as wl_buffer to the icon.
 *
 * The client should add pixel data for all icon sizes and scales that
 * it can provide, or which are explicitly requested by the compositor
 * via 'icon_size' events on xdg_toplevel_icon_manager_v1.
 *
 * The wl_buffer supplying pixel data as 'buffer' must be backed by wl_shm
 * and must be a square (width and height being equal).
 * If any of these buffer requirements are not fulfilled, a 'invalid_buffer'
 * error must be raised.
 *
 * If this icon instance already has a buffer of the same size and scale
 * from a previous 'add_buffer' request, data from the last request
 * overrides the preexisting pixel data.
 *
 * The wl_buffer must be kept alive for as long as the xdg_toplevel_icon
 * it is associated with is not destroyed, otherwise a 'no_buffer' error
 * is raised. The buffer contents must not be modified after it was
 * assigned to the icon. As a result, the region of the wl_shm_pool's
 * backing storage used for the wl_buffer must not be modified after this
 * request is sent. The wl_buffer.release event is unused.
 *
 * If this request is made after the icon has been assigned to a toplevel
 * via 'set_icon', a 'immutable' error must be raised.
 */
static inline void
xdg_toplevel_icon_v1_add_buffer(struct xdg_toplevel_icon_v1 *xdg_toplevel_icon_v1, struct wl_buffer *buffer, int32_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_toplevel_icon_v1,
			 XDG_TOPLEVEL_ICON_V1_ADD_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_toplevel_icon_v1), 0, buffer, scale);
}

#ifdef  __cplusplus
}
#endif

#endif
