// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "LineProperty.h"

#include "PropertiesTypes.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class OutlinePropertyPrivate;

/*!
\class Union::Properties::OutlineProperty
\inmodule core
\ingroup core-properties

\brief A property group containing properties of an element's outline.

*/
class UNION_EXPORT OutlineProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    OutlineProperty();
    /*!
     * Copy constructor.
     */
    OutlineProperty(const OutlineProperty &other);
    /*!
     * Move constructor.
     */
    OutlineProperty(OutlineProperty &&other);
    ~OutlineProperty();

    /*!
     * Copy assignment operator.
     */
    OutlineProperty &operator=(const OutlineProperty &other);
    /*!
     * Move assignment operator.
     */
    OutlineProperty &operator=(OutlineProperty &&other);

    /*!
     * Returns left if set or nullptr if not.
     */
    LineProperty *left() const;

    /*!
     * Set the value of left.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setLeft(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns right if set or nullptr if not.
     */
    LineProperty *right() const;

    /*!
     * Set the value of right.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setRight(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns top if set or nullptr if not.
     */
    LineProperty *top() const;

    /*!
     * Set the value of top.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setTop(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns bottom if set or nullptr if not.
     */
    LineProperty *bottom() const;

    /*!
     * Set the value of bottom.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setBottom(std::unique_ptr<LineProperty> &&newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Returns a string representation of this property group.
     *
     * This is intended for debugging.
     *
     * \a indentation The amount of indentation to apply. Defaults to 0.
     * \a flags A set of flags that control conversion behavior.
     */
    QString toString(int indentation = 0, ToStringFlags flags = ToStringFlags{}) const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const OutlineProperty *source, OutlineProperty *destination);

    /*!
     * Create and return an empty OutlineProperty instance.
     *
     * This will create an empty OutlineProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static std::unique_ptr<OutlineProperty> empty();

private:
    std::unique_ptr<OutlinePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::OutlineProperty
 * Equality comparison for OutlineProperty.
 */
UNION_EXPORT bool operator==(const OutlineProperty &left, const OutlineProperty &right);
}
}

/*!
 * \relates Union::Properties::OutlineProperty
 * QDebug support for OutlineProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, Union::Properties::OutlineProperty *type);