#include "nv_push_cla26f.h"

#include <stdio.h>





const char *P_PARSE_NVA16F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA16F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVA26F_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVA16F_MTHD(idx);

                            case NVA26F_SEMAPHORED:
        return "NVA26F_SEMAPHORED";
                case NVA26F_MEM_OP_B:
        return "NVA26F_MEM_OP_B";
        case NVA26F_SYNCPOINTA:
        return "NVA26F_SYNCPOINTA";
    case NVA26F_SYNCPOINTB:
        return "NVA26F_SYNCPOINTB";
            
    }
}

void
P_DUMP_NVA26F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVA16F_MTHD_DATA(fp, idx, data, prefix);
    break;

                          
    case NVA26F_SEMAPHORED:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA26F_SEMAPHORED_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVA26F_SEMAPHORED_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVA26F_SEMAPHORED_OPERATION_ACQ_GEQ:
            fprintf(fp, "ACQ_GEQ\n");
            break;
        case NVA26F_SEMAPHORED_OPERATION_ACQ_AND:
            fprintf(fp, "ACQ_AND\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE_SWITCH = ", prefix);
        switch (parsed) {
        case NVA26F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVA26F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED:
            fprintf(fp, "ENABLED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_WFI = ", prefix);
        switch (parsed) {
        case NVA26F_SEMAPHORED_RELEASE_WFI_EN:
            fprintf(fp, "EN\n");
            break;
        case NVA26F_SEMAPHORED_RELEASE_WFI_DIS:
            fprintf(fp, "DIS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE_SIZE = ", prefix);
        switch (parsed) {
        case NVA26F_SEMAPHORED_RELEASE_SIZE_16BYTE:
            fprintf(fp, "16BYTE\n");
            break;
        case NVA26F_SEMAPHORED_RELEASE_SIZE_4BYTE:
            fprintf(fp, "4BYTE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
              
    case NVA26F_MEM_OP_B:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OPERAND_HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 5) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA26F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH:
            fprintf(fp, "SYSMEMBAR_FLUSH\n");
            break;
        case NVA26F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE:
            fprintf(fp, "MMU_TLB_INVALIDATE\n");
            break;
        case NVA26F_MEM_OP_B_OPERATION_L2_INVALIDATE_CLEAN_LINES:
            fprintf(fp, "L2_INVALIDATE_CLEAN_LINES\n");
            break;
        case NVA26F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS:
            fprintf(fp, "L2_CLEAN_COMPTAGS\n");
            break;
        case NVA26F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY:
            fprintf(fp, "L2_FLUSH_DIRTY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MMU_TLB_INVALIDATE_PDB = ", prefix);
        switch (parsed) {
        case NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.MMU_TLB_INVALIDATE_GPC = ", prefix);
        switch (parsed) {
        case NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        case NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NVA26F_SYNCPOINTA:

    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVA26F_SYNCPOINTB:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVA26F_SYNCPOINTB_OPERATION_WAIT:
            fprintf(fp, "WAIT\n");
            break;
        case NVA26F_SYNCPOINTB_OPERATION_INCR:
            fprintf(fp, "INCR\n");
            break;
        case NVA26F_SYNCPOINTB_OPERATION_BASE_ADD:
            fprintf(fp, "BASE_ADD\n");
            break;
        case NVA26F_SYNCPOINTB_OPERATION_BASE_WRITE:
            fprintf(fp, "BASE_WRITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.WAIT_SWITCH = ", prefix);
        switch (parsed) {
        case NVA26F_SYNCPOINTB_WAIT_SWITCH_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVA26F_SYNCPOINTB_WAIT_SWITCH_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.BASE = ", prefix);
        switch (parsed) {
        case NVA26F_SYNCPOINTB_BASE_DIS:
            fprintf(fp, "DIS\n");
            break;
        case NVA26F_SYNCPOINTB_BASE_EN:
            fprintf(fp, "EN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.SYNCPT_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 6) - 1);
        fprintf(fp, "%s.BASE_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                }
}
