/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Register Bank Source Fragments                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_REGBANK_DECLARATIONS
#undef GET_REGBANK_DECLARATIONS
namespace llvm {
namespace Mips {
enum : unsigned {
  InvalidRegBankID = ~0u,
  FPRBRegBankID = 0,
  GPRBRegBankID = 1,
  NumRegisterBanks,
};
} // end namespace Mips
} // end namespace llvm
#endif // GET_REGBANK_DECLARATIONS

#ifdef GET_TARGET_REGBANK_CLASS
#undef GET_TARGET_REGBANK_CLASS
private:
  static const RegisterBank *RegBanks[];
  static const unsigned Sizes[];

public:
  const RegisterBank &getRegBankFromRegClass(const TargetRegisterClass &RC, LLT Ty) const override;
protected:
  MipsGenRegisterBankInfo(unsigned HwMode = 0);

#endif // GET_TARGET_REGBANK_CLASS

#ifdef GET_TARGET_REGBANK_IMPL
#undef GET_TARGET_REGBANK_IMPL
namespace llvm {
namespace Mips {
const uint32_t FPRBRegBankCoverageData[] = {
    // 0-31
    (1u << (Mips::FGR32RegClassID - 0)) |
    (1u << (Mips::FGRCCRegClassID - 0)) |
    0,
    // 32-63
    (1u << (Mips::FGR64RegClassID - 32)) |
    (1u << (Mips::AFGR64RegClassID - 32)) |
    0,
    // 64-95
    (1u << (Mips::MSA128DRegClassID - 64)) |
    (1u << (Mips::MSA128BRegClassID - 64)) |
    (1u << (Mips::MSA128HRegClassID - 64)) |
    (1u << (Mips::MSA128WRegClassID - 64)) |
    (1u << (Mips::MSA128WEvensRegClassID - 64)) |
    0,
};
const uint32_t GPRBRegBankCoverageData[] = {
    // 0-31
    (1u << (Mips::GPR32RegClassID - 0)) |
    (1u << (Mips::GPR32NONZERORegClassID - 0)) |
    (1u << (Mips::CPU16RegsPlusSPRegClassID - 0)) |
    (1u << (Mips::CPU16RegsRegClassID - 0)) |
    (1u << (Mips::GPRMM16RegClassID - 0)) |
    (1u << (Mips::CPU16Regs_and_GPRMM16ZeroRegClassID - 0)) |
    (1u << (Mips::CPU16Regs_and_GPRMM16MovePPairSecondRegClassID - 0)) |
    (1u << (Mips::GPRMM16MovePPairFirst_and_GPRMM16MovePPairSecondRegClassID - 0)) |
    (1u << (Mips::GPRMM16MovePPairFirstRegClassID - 0)) |
    (1u << (Mips::GPRMM16MoveP_and_CPU16Regs_and_GPRMM16ZeroRegClassID - 0)) |
    (1u << (Mips::CPU16Regs_and_GPRMM16MovePRegClassID - 0)) |
    (1u << (Mips::CPUSPRegRegClassID - 0)) |
    (1u << (Mips::GPR32NONZERO_and_GPRMM16MovePRegClassID - 0)) |
    (1u << (Mips::GPRMM16MovePPairSecondRegClassID - 0)) |
    (1u << (Mips::CPURARegRegClassID - 0)) |
    (1u << (Mips::GPRMM16MovePRegClassID - 0)) |
    (1u << (Mips::GPRMM16MoveP_and_GPRMM16ZeroRegClassID - 0)) |
    (1u << (Mips::GPRMM16ZeroRegClassID - 0)) |
    0,
    // 32-63
    (1u << (Mips::SP32RegClassID - 32)) |
    (1u << (Mips::GP32RegClassID - 32)) |
    (1u << (Mips::GPR32ZERORegClassID - 32)) |
    0,
    // 64-95
    0,
};

constexpr RegisterBank FPRBRegBank(/* ID */ Mips::FPRBRegBankID, /* Name */ "FPRB", /* CoveredRegClasses */ FPRBRegBankCoverageData, /* NumRegClasses */ 70);
constexpr RegisterBank GPRBRegBank(/* ID */ Mips::GPRBRegBankID, /* Name */ "GPRB", /* CoveredRegClasses */ GPRBRegBankCoverageData, /* NumRegClasses */ 70);
} // end namespace Mips

const RegisterBank *MipsGenRegisterBankInfo::RegBanks[] = {
    &Mips::FPRBRegBank,
    &Mips::GPRBRegBank,
};

const unsigned MipsGenRegisterBankInfo::Sizes[] = {
    // Mode = 0 (Default)
    128,
    32,
};

MipsGenRegisterBankInfo::MipsGenRegisterBankInfo(unsigned HwMode)
    : RegisterBankInfo(RegBanks, Mips::NumRegisterBanks, Sizes, HwMode) {
  // Assert that RegBank indices match their ID's
#ifndef NDEBUG
  for (auto RB : enumerate(RegBanks))
    assert(RB.index() == RB.value()->getID() && "Index != ID");
#endif // NDEBUG
}
const RegisterBank &
MipsGenRegisterBankInfo::getRegBankFromRegClass(const TargetRegisterClass &RC, LLT) const {
  constexpr uint32_t InvalidRegBankID = uint32_t(Mips::InvalidRegBankID) & 3;
  static const uint32_t RegClass2RegBank[5] = {
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(Mips::FPRBRegBankID) << 12) | // FGR32RegClassID
    (uint32_t(Mips::FPRBRegBankID) << 14) | // FGRCCRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 16) | // GPR32RegClassID
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(Mips::GPRBRegBankID) << 22) | // GPR32NONZERORegClassID
    (uint32_t(Mips::GPRBRegBankID) << 24) | // CPU16RegsPlusSPRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 26) | // CPU16RegsRegClassID
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(Mips::GPRBRegBankID) << 30), // GPRMM16RegClassID
    (uint32_t(Mips::GPRBRegBankID) << 0) | // GPRMM16MovePRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 2) | // GPRMM16ZeroRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 4) | // CPU16Regs_and_GPRMM16ZeroRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 6) | // GPR32NONZERO_and_GPRMM16MovePRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 8) | // GPRMM16MovePPairSecondRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 10) | // CPU16Regs_and_GPRMM16MovePRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 12) | // GPRMM16MoveP_and_GPRMM16ZeroRegClassID
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(Mips::GPRBRegBankID) << 18) | // CPU16Regs_and_GPRMM16MovePPairSecondRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 20) | // GPRMM16MovePPairFirstRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 22) | // GPRMM16MoveP_and_CPU16Regs_and_GPRMM16ZeroRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 24) | // GPRMM16MovePPairFirst_and_GPRMM16MovePPairSecondRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 26) | // CPURARegRegClassID
    (uint32_t(Mips::GPRBRegBankID) << 28) | // CPUSPRegRegClassID
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(Mips::GPRBRegBankID) << 0) | // GP32RegClassID
    (uint32_t(Mips::GPRBRegBankID) << 2) | // GPR32ZERORegClassID
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(Mips::GPRBRegBankID) << 8) | // SP32RegClassID
    (uint32_t(Mips::FPRBRegBankID) << 10) | // FGR64RegClassID
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(Mips::FPRBRegBankID) << 16) | // AFGR64RegClassID
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(InvalidRegBankID) << 10) |
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(Mips::FPRBRegBankID) << 0) | // MSA128BRegClassID
    (uint32_t(Mips::FPRBRegBankID) << 2) | // MSA128DRegClassID
    (uint32_t(Mips::FPRBRegBankID) << 4) | // MSA128HRegClassID
    (uint32_t(Mips::FPRBRegBankID) << 6) | // MSA128WRegClassID
    (uint32_t(Mips::FPRBRegBankID) << 8) // MSA128WEvensRegClassID
  };
  const unsigned RegClassID = RC.getID();
  if (LLVM_LIKELY(RegClassID < 69)) {
    unsigned RegBankID = (RegClass2RegBank[RegClassID / 16] >> ((RegClassID % 16) * 2)) & 3;
    if (RegBankID != InvalidRegBankID)
      return getRegBank(RegBankID);
  }
  llvm_unreachable(llvm::Twine("Target needs to handle register class ID 0x").concat(llvm::Twine::utohexstr(RegClassID)).str().c_str());
}
} // end namespace llvm
#endif // GET_TARGET_REGBANK_IMPL
