/* Copyright (c) 2024-2026 The Khronos Group Inc.
 * Copyright (c) 2024-2026 LunarG, Inc.
 * Copyright (c) 2024-2026 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once
#include <string>

struct Location;

namespace vvl {

enum class PipelineBinaryInfoError {
    PNext_09616,
    PNext_09617,
    BinaryCount_09620,
    BinaryCount_09621,
    BinaryCount_09622,
    Flags_11311,
    Flags_11367,
};

const std::string &GetPipelineBinaryInfoVUID(const Location &loc, PipelineBinaryInfoError error);

enum class PipelineCreateFlagError {
    CacheControl_02878,
    Shader64BitIndexing_11798,
    ProtectedAccess_07368,
    ProtectedAccess_07369,
};
const char *GetPipelineCreateFlagVUID(const Location &loc, PipelineCreateFlagError error);

}  // namespace vvl