const char *spheres_vs =
  "#version 400\n"
  "precision highp float;  \n"
  "in vec4 vertex;\n"
  "in vec3 color;\n"
  "in vec2 texCoordinate;\n"
  "out vec2 v_texCoord;\n"
  "out vec3 fColor;\n"
  "out vec4 eyePosition;\n"
  "out float radius;\n"
  "\n"
  "uniform mat4 modelView;\n"
  "uniform mat4 projection;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  radius = abs(texCoordinate.x);\n"
  "  fColor = color;\n"
  "  v_texCoord = texCoordinate / radius;\n"
  "  gl_Position = modelView * vertex;\n"
  "  eyePosition = gl_Position;\n"
  "\n"
  "  // Test if the closest point on the sphere would be clipped.\n"
  "  vec4 clipTestNear = eyePosition;\n"
  "  clipTestNear.z += radius;\n"
  "  clipTestNear = projection * clipTestNear;\n"
  "  if (clipTestNear.z > -clipTestNear.w) {\n"
  "    // If not, calculate clip coordinate\n"
  "    gl_Position.xy += texCoordinate;\n"
  "    gl_Position = projection * gl_Position;\n"
  "  }\n"
  "  else {\n"
  "    // If so, invalidate the clip coordinate to ensure that it will be clipped.\n"
  "    gl_Position.w = 0.0;\n"
  "  }\n"
  "}\n"
  "\n";
