/* src/bazaar.p/bz-backend-notification.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include "bz-entry.h"

G_BEGIN_DECLS

typedef enum
{
  BZ_BACKEND_NOTIFICATION_KIND_ERROR,
  BZ_BACKEND_NOTIFICATION_KIND_TELL_INCOMING,
  BZ_BACKEND_NOTIFICATION_KIND_REPLACE_ENTRY,
  BZ_BACKEND_NOTIFICATION_KIND_INSTALL_DONE,
  BZ_BACKEND_NOTIFICATION_KIND_UPDATE_DONE,
  BZ_BACKEND_NOTIFICATION_KIND_REMOVE_DONE,
  BZ_BACKEND_NOTIFICATION_KIND_EXTERNAL_CHANGE,
} BzBackendNotificationKind;
GType bz_backend_notification_kind_get_type (void);
#define BZ_TYPE_BACKEND_NOTIFICATION_KIND (bz_backend_notification_kind_get_type ())

#define BZ_TYPE_BACKEND_NOTIFICATION (bz_backend_notification_get_type ())
G_DECLARE_FINAL_TYPE (BzBackendNotification, bz_backend_notification, BZ, BACKEND_NOTIFICATION, GObject)

BzBackendNotification *
bz_backend_notification_new (void);

BzBackendNotificationKind
bz_backend_notification_get_kind (BzBackendNotification *self);

const char *
bz_backend_notification_get_error (BzBackendNotification *self);

int
bz_backend_notification_get_n_incoming (BzBackendNotification *self);

BzEntry *
bz_backend_notification_get_entry (BzBackendNotification *self);

const char *
bz_backend_notification_get_unique_id (BzBackendNotification *self);

void
bz_backend_notification_set_kind (BzBackendNotification *self,
    BzBackendNotificationKind kind);

void
bz_backend_notification_set_error (BzBackendNotification *self,
    const char *error);

void
bz_backend_notification_set_n_incoming (BzBackendNotification *self,
    int n_incoming);

void
bz_backend_notification_set_entry (BzBackendNotification *self,
    BzEntry *entry);

void
bz_backend_notification_set_unique_id (BzBackendNotification *self,
    const char *unique_id);

G_END_DECLS

/* End of src/bazaar.p/bz-backend-notification.h */
