/* NightLight.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NightLight.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "nightlightapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NIGHT_LIGHT_PLUGIN_0_PROPERTY,
	NIGHT_LIGHT_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* night_light_plugin_properties[NIGHT_LIGHT_PLUGIN_NUM_PROPERTIES];

#define NIGHT_LIGHT_TYPE_INDICATOR_WINDOW (night_light_indicator_window_get_type ())
#define NIGHT_LIGHT_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindow))
#define NIGHT_LIGHT_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindowClass))
#define NIGHT_LIGHT_IS_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW))
#define NIGHT_LIGHT_IS_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW))
#define NIGHT_LIGHT_INDICATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIGHT_LIGHT_TYPE_INDICATOR_WINDOW, NightLightIndicatorWindowClass))

typedef struct _NightLightIndicatorWindow NightLightIndicatorWindow;
typedef struct _NightLightIndicatorWindowClass NightLightIndicatorWindowClass;
enum  {
	NIGHT_LIGHT_APPLET_0_PROPERTY,
	NIGHT_LIGHT_APPLET_UUID_PROPERTY,
	NIGHT_LIGHT_APPLET_NUM_PROPERTIES
};
static GParamSpec* night_light_applet_properties[NIGHT_LIGHT_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NightLightAppletPrivate {
	GtkEventBox* event_box;
	NightLightIndicatorWindow* popover;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};

static gpointer night_light_plugin_parent_class = NULL;
static BudgiePluginIface * night_light_plugin_budgie_plugin_parent_iface = NULL;
static GType night_light_plugin_type_id = 0;
static gint NightLightApplet_private_offset;
static gpointer night_light_applet_parent_class = NULL;
static GType night_light_applet_type_id = 0;

static BudgieApplet* night_light_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                        const gchar* uuid);
GType night_light_indicator_window_register_type (GTypeModule * module);
VALA_EXTERN GType night_light_indicator_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NightLightIndicatorWindow* night_light_indicator_window_new (GtkWidget* window_parent);
VALA_EXTERN NightLightIndicatorWindow* night_light_indicator_window_construct (GType object_type,
                                                                   GtkWidget* window_parent);
static gboolean __lambda5_ (NightLightApplet* self,
                     GdkEventButton* e);
VALA_EXTERN void night_light_indicator_window_toggle_nightlight (NightLightIndicatorWindow* self);
static gboolean ___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void night_light_applet_real_update_popovers (BudgieApplet* base,
                                              BudgiePopoverManager* manager);
static void night_light_applet_finalize (GObject * obj);
static void _vala_night_light_applet_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_night_light_applet_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
GType night_light_indicator_window_register_type (GTypeModule * module);

static BudgieApplet*
night_light_plugin_real_get_panel_widget (BudgiePlugin* base,
                                          const gchar* uuid)
{
	NightLightPlugin * self;
	NightLightApplet* _tmp0_;
	BudgieApplet* result;
	self = (NightLightPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = night_light_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

NightLightPlugin*
night_light_plugin_construct (GType object_type)
{
	NightLightPlugin * self = NULL;
	self = (NightLightPlugin*) g_object_new (object_type, NULL);
	return self;
}

NightLightPlugin*
night_light_plugin_new (void)
{
	return night_light_plugin_construct (NIGHT_LIGHT_TYPE_PLUGIN);
}

static void
night_light_plugin_class_init (NightLightPluginClass * klass,
                               gpointer klass_data)
{
	night_light_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
night_light_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                 gpointer iface_data)
{
	night_light_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) night_light_plugin_real_get_panel_widget;
}

static void
night_light_plugin_instance_init (NightLightPlugin * self,
                                  gpointer klass)
{
}

GType
night_light_plugin_get_type (void)
{
	return night_light_plugin_type_id;
}

GType
night_light_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightLightPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) night_light_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightLightPlugin), 0, (GInstanceInitFunc) night_light_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) night_light_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	night_light_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "NightLightPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, night_light_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return night_light_plugin_type_id;
}

static inline gpointer
night_light_applet_get_instance_private (NightLightApplet* self)
{
	return G_STRUCT_MEMBER_P (self, NightLightApplet_private_offset);
}

static gboolean
__lambda5_ (NightLightApplet* self,
            GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) 1)) {
		NightLightIndicatorWindow* _tmp0_;
		_tmp0_ = self->priv->popover;
		if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
			NightLightIndicatorWindow* _tmp1_;
			_tmp1_ = self->priv->popover;
			gtk_widget_hide ((GtkWidget*) _tmp1_);
		} else {
			BudgiePopoverManager* _tmp2_;
			GtkEventBox* _tmp3_;
			_tmp2_ = self->priv->manager;
			_tmp3_ = self->priv->event_box;
			budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
		}
	} else {
		if (e->button == ((guint) 2)) {
			NightLightIndicatorWindow* _tmp4_;
			_tmp4_ = self->priv->popover;
			night_light_indicator_window_toggle_nightlight (_tmp4_);
		} else {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda5_ ((NightLightApplet*) self, event);
	return result;
}

NightLightApplet*
night_light_applet_construct (GType object_type,
                              const gchar* uuid)
{
	NightLightApplet * self = NULL;
	GtkEventBox* _tmp0_;
	GtkImage* icon = NULL;
	GtkImage* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* _tmp3_;
	NightLightIndicatorWindow* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkEventBox* _tmp6_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (NightLightApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->event_box);
	self->priv->event_box = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("weather-clear-night-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	icon = _tmp1_;
	_tmp2_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) icon);
	_tmp3_ = self->priv->event_box;
	_tmp4_ = night_light_indicator_window_new ((GtkWidget*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp4_;
	_tmp5_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp6_ = self->priv->event_box;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-press-event", (GCallback) ___lambda5__gtk_widget_button_press_event, self, 0);
	_g_object_unref0 (icon);
	return self;
}

NightLightApplet*
night_light_applet_new (const gchar* uuid)
{
	return night_light_applet_construct (NIGHT_LIGHT_TYPE_APPLET, uuid);
}

static void
night_light_applet_real_update_popovers (BudgieApplet* base,
                                         BudgiePopoverManager* manager)
{
	NightLightApplet * self;
	GtkEventBox* _tmp0_;
	NightLightIndicatorWindow* _tmp1_;
	self = (NightLightApplet*) base;
	_tmp0_ = self->priv->event_box;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, (GtkPopover*) _tmp1_);
	self->priv->manager = manager;
}

const gchar*
night_light_applet_get_uuid (NightLightApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
night_light_applet_set_uuid (NightLightApplet* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = night_light_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, night_light_applet_properties[NIGHT_LIGHT_APPLET_UUID_PROPERTY]);
	}
}

static void
night_light_applet_class_init (NightLightAppletClass * klass,
                               gpointer klass_data)
{
	night_light_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NightLightApplet_private_offset);
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) night_light_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_night_light_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_night_light_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = night_light_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHT_LIGHT_APPLET_UUID_PROPERTY, night_light_applet_properties[NIGHT_LIGHT_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
night_light_applet_instance_init (NightLightApplet * self,
                                  gpointer klass)
{
	self->priv = night_light_applet_get_instance_private (self);
	self->priv->popover = NULL;
	self->priv->manager = NULL;
}

static void
night_light_applet_finalize (GObject * obj)
{
	NightLightApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIGHT_LIGHT_TYPE_APPLET, NightLightApplet);
	_g_object_unref0 (self->priv->event_box);
	_g_object_unref0 (self->priv->popover);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (night_light_applet_parent_class)->finalize (obj);
}

GType
night_light_applet_get_type (void)
{
	return night_light_applet_type_id;
}

GType
night_light_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightLightAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) night_light_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightLightApplet), 0, (GInstanceInitFunc) night_light_applet_instance_init, NULL };
	night_light_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "NightLightApplet", &g_define_type_info, 0);
	NightLightApplet_private_offset = sizeof (NightLightAppletPrivate);
	return night_light_applet_type_id;
}

static void
_vala_night_light_applet_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	NightLightApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIGHT_LIGHT_TYPE_APPLET, NightLightApplet);
	switch (property_id) {
		case NIGHT_LIGHT_APPLET_UUID_PROPERTY:
		g_value_set_string (value, night_light_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_night_light_applet_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	NightLightApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIGHT_LIGHT_TYPE_APPLET, NightLightApplet);
	switch (property_id) {
		case NIGHT_LIGHT_APPLET_UUID_PROPERTY:
		night_light_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	night_light_plugin_register_type (module);
	night_light_applet_register_type (module);
	night_light_indicator_window_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), NIGHT_LIGHT_TYPE_PLUGIN);
	_g_object_unref0 (objmodule);
}

