/* View.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from View.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include "budgie-appindexer.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_VIEW_0_PROPERTY,
	APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY,
	APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY,
	APPLICATION_VIEW_SEARCH_TERM_PROPERTY,
	APPLICATION_VIEW_ICON_SIZE_PROPERTY,
	APPLICATION_VIEW_NUM_PROPERTIES
};
static GParamSpec* application_view_properties[APPLICATION_VIEW_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
enum  {
	APPLICATION_VIEW_APP_LAUNCHED_SIGNAL,
	APPLICATION_VIEW_NUM_SIGNALS
};
static guint application_view_signals[APPLICATION_VIEW_NUM_SIGNALS] = {0};

struct _ApplicationViewPrivate {
	GHashTable* _application_buttons;
	GeeArrayList* _control_center_buttons;
	gchar* _search_term;
	gint _icon_size;
	guint timeout_id;
};

struct _Block4Data {
	int _ref_count_;
	ApplicationView* self;
	BudgieAppIndex* app_tracker;
};

static gint ApplicationView_private_offset;
static gpointer application_view_parent_class = NULL;
static GType application_view_type_id = 0;

static void application_view_real_on_search_entry_activated (ApplicationView* self);
static void application_view_real_on_show (ApplicationView* self);
static void application_view_real_refresh (ApplicationView* self,
                                    BudgieAppIndex* app_tracker);
static void application_view_real_invalidate (ApplicationView* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block4Data* _data4_);
static gboolean ___lambda4__gsource_func (gpointer self);
static GObject * application_view_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void application_view_finalize (GObject * obj);
static void _vala_application_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_application_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
application_view_get_instance_private (ApplicationView* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationView_private_offset);
}

/**
 * This should be called when the user activates a search entry.
 */
static void
application_view_real_on_search_entry_activated (ApplicationView* self)
{
	g_critical ("Type `%s' does not implement abstract method `application_view_on_search_entry_activated'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
application_view_on_search_entry_activated (ApplicationView* self)
{
	ApplicationViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APPLICATION_VIEW_GET_CLASS (self);
	if (_klass_->on_search_entry_activated) {
		_klass_->on_search_entry_activated (self);
	}
}

/**
 * Performs any work that should be done to the view when the menu
 * is opened, e.g. resetting the current category or invalidating filters.
 */
static void
application_view_real_on_show (ApplicationView* self)
{
	g_critical ("Type `%s' does not implement abstract method `application_view_on_show'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
application_view_on_show (ApplicationView* self)
{
	ApplicationViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APPLICATION_VIEW_GET_CLASS (self);
	if (_klass_->on_show) {
		_klass_->on_show (self);
	}
}

/**
 * Refreshes the entire application view.
 */
static void
application_view_real_refresh (ApplicationView* self,
                               BudgieAppIndex* app_tracker)
{
	g_critical ("Type `%s' does not implement abstract method `application_view_refresh'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
application_view_refresh (ApplicationView* self,
                          BudgieAppIndex* app_tracker)
{
	ApplicationViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APPLICATION_VIEW_GET_CLASS (self);
	if (_klass_->refresh) {
		_klass_->refresh (self, app_tracker);
	}
}

/**
 * Invalidate aspects of the view, e.g. category headers.
 */
static void
application_view_real_invalidate (ApplicationView* self)
{
	g_critical ("Type `%s' does not implement abstract method `application_view_invalidate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
application_view_invalidate (ApplicationView* self)
{
	ApplicationViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = APPLICATION_VIEW_GET_CLASS (self);
	if (_klass_->invalidate) {
		_klass_->invalidate (self);
	}
}

/**
 * Queue a refresh of the application view.
 *
 * The time to wait before refreshing can be set by passing in `seconds`.
 * By default, the time is 1 second.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ApplicationView* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->app_tracker);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda4_ (Block4Data* _data4_)
{
	ApplicationView* self;
	gboolean result;
	self = _data4_->self;
	application_view_refresh (self, _data4_->app_tracker);
	self->priv->timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

void
application_view_queue_refresh (ApplicationView* self,
                                BudgieAppIndex* app_tracker,
                                gint seconds)
{
	Block4Data* _data4_;
	BudgieAppIndex* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_tracker != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (app_tracker);
	_g_object_unref0 (_data4_->app_tracker);
	_data4_->app_tracker = _tmp0_;
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) seconds, ___lambda4__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

/**
 * To be called when the search entry changes.
 */
void
application_view_search_changed (ApplicationView* self,
                                 const gchar* search_term)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_term != NULL);
	application_view_set_search_term (self, search_term);
	_tmp0_ = self->priv->_application_buttons;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			MenuButton* child = NULL;
			child = (MenuButton*) child_it->data;
			{
				BudgieRelevancyService* _tmp2_;
				MenuButton* _tmp3_;
				BudgieApplication* _tmp4_;
				BudgieApplication* _tmp5_;
				_tmp2_ = self->relevancy_service;
				_tmp3_ = child;
				_tmp4_ = menu_button_get_app (_tmp3_);
				_tmp5_ = _tmp4_;
				budgie_relevancy_service_update_relevancy (_tmp2_, _tmp5_, search_term);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	application_view_invalidate (self);
}

/**
 * Checks if a `MenuButton` already exists in the view.
 */
gboolean
application_view_is_item_dupe (ApplicationView* self,
                               MenuButton* button)
{
	MenuButton* compare_item = NULL;
	GHashTable* _tmp0_;
	BudgieApplication* _tmp1_;
	BudgieApplication* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	MenuButton* _tmp6_;
	gboolean _tmp7_ = FALSE;
	MenuButton* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_application_buttons;
	_tmp1_ = menu_button_get_app (button);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_application_get_desktop_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp0_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((MenuButton*) _tmp5_);
	compare_item = _tmp6_;
	_tmp8_ = compare_item;
	if (_tmp8_ != NULL) {
		MenuButton* _tmp9_;
		_tmp9_ = compare_item;
		_tmp7_ = _tmp9_ != button;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = TRUE;
		_g_object_unref0 (compare_item);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (compare_item);
	return result;
}

ApplicationView*
application_view_construct (GType object_type)
{
	ApplicationView * self = NULL;
	self = (ApplicationView*) g_object_new (object_type, NULL);
	return self;
}

GHashTable*
application_view_get_application_buttons (ApplicationView* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application_buttons;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
application_view_set_application_buttons (ApplicationView* self,
                                          GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = application_view_get_application_buttons (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_application_buttons);
		self->priv->_application_buttons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_view_properties[APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY]);
	}
}

GeeArrayList*
application_view_get_control_center_buttons (ApplicationView* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_control_center_buttons;
	result = _tmp0_;
	return result;
}

void
application_view_set_control_center_buttons (ApplicationView* self,
                                             GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = application_view_get_control_center_buttons (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_control_center_buttons);
		self->priv->_control_center_buttons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_view_properties[APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY]);
	}
}

const gchar*
application_view_get_search_term (ApplicationView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}

void
application_view_set_search_term (ApplicationView* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = application_view_get_search_term (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_term);
		self->priv->_search_term = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_view_properties[APPLICATION_VIEW_SEARCH_TERM_PROPERTY]);
	}
}

gint
application_view_get_icon_size (ApplicationView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}

void
application_view_set_icon_size (ApplicationView* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = application_view_get_icon_size (self);
	if (old_value != value) {
		self->priv->_icon_size = value;
		g_object_notify_by_pspec ((GObject *) self, application_view_properties[APPLICATION_VIEW_ICON_SIZE_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
application_view_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ApplicationView * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	BudgieRelevancyService* _tmp6_;
	parent_class = G_OBJECT_CLASS (application_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION_VIEW, ApplicationView);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	application_view_set_application_buttons (self, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	_tmp4_ = gee_array_list_new (TYPE_MENU_BUTTON, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	application_view_set_control_center_buttons (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = budgie_relevancy_service_new ();
	_g_object_unref0 (self->relevancy_service);
	self->relevancy_service = _tmp6_;
	return obj;
}

static void
application_view_class_init (ApplicationViewClass * klass,
                             gpointer klass_data)
{
	application_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationView_private_offset);
	((ApplicationViewClass *) klass)->on_search_entry_activated = (void (*) (ApplicationView*)) application_view_real_on_search_entry_activated;
	((ApplicationViewClass *) klass)->on_show = (void (*) (ApplicationView*)) application_view_real_on_show;
	((ApplicationViewClass *) klass)->refresh = (void (*) (ApplicationView*, BudgieAppIndex*)) application_view_real_refresh;
	((ApplicationViewClass *) klass)->invalidate = (void (*) (ApplicationView*)) application_view_real_invalidate;
	G_OBJECT_CLASS (klass)->get_property = _vala_application_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = application_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = application_view_finalize;
	/** Mapped id to MenuButton */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY, application_view_properties[APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY] = g_param_spec_boxed ("application-buttons", "application-buttons", "application-buttons", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY, application_view_properties[APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY] = g_param_spec_object ("control-center-buttons", "control-center-buttons", "control-center-buttons", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_VIEW_SEARCH_TERM_PROPERTY, application_view_properties[APPLICATION_VIEW_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_VIEW_ICON_SIZE_PROPERTY, application_view_properties[APPLICATION_VIEW_ICON_SIZE_PROPERTY] = g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 24, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Emitted when an app is launched.
	 */
	application_view_signals[APPLICATION_VIEW_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", TYPE_APPLICATION_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
application_view_instance_init (ApplicationView * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = application_view_get_instance_private (self);
	self->priv->_application_buttons = NULL;
	self->priv->_control_center_buttons = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_search_term = _tmp0_;
	self->priv->_icon_size = 24;
	self->priv->timeout_id = (guint) 0;
}

static void
application_view_finalize (GObject * obj)
{
	ApplicationView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION_VIEW, ApplicationView);
	_g_hash_table_unref0 (self->priv->_application_buttons);
	_g_object_unref0 (self->priv->_control_center_buttons);
	_g_free0 (self->priv->_search_term);
	_g_object_unref0 (self->relevancy_service);
	G_OBJECT_CLASS (application_view_parent_class)->finalize (obj);
}

/**
 * Abstract class for different views for the application menu to
 * extend.
 */
GType
application_view_get_type (void)
{
	return application_view_type_id;
}

GType
application_view_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationView), 0, (GInstanceInitFunc) application_view_instance_init, NULL };
	application_view_type_id = g_type_module_register_type (module, gtk_box_get_type (), "ApplicationView", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ApplicationView_private_offset = sizeof (ApplicationViewPrivate);
	return application_view_type_id;
}

static void
_vala_application_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ApplicationView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APPLICATION_VIEW, ApplicationView);
	switch (property_id) {
		case APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY:
		g_value_set_boxed (value, application_view_get_application_buttons (self));
		break;
		case APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY:
		g_value_set_object (value, application_view_get_control_center_buttons (self));
		break;
		case APPLICATION_VIEW_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, application_view_get_search_term (self));
		break;
		case APPLICATION_VIEW_ICON_SIZE_PROPERTY:
		g_value_set_int (value, application_view_get_icon_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ApplicationView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APPLICATION_VIEW, ApplicationView);
	switch (property_id) {
		case APPLICATION_VIEW_APPLICATION_BUTTONS_PROPERTY:
		application_view_set_application_buttons (self, g_value_get_boxed (value));
		break;
		case APPLICATION_VIEW_CONTROL_CENTER_BUTTONS_PROPERTY:
		application_view_set_control_center_buttons (self, g_value_get_object (value));
		break;
		case APPLICATION_VIEW_SEARCH_TERM_PROPERTY:
		application_view_set_search_term (self, g_value_get_string (value));
		break;
		case APPLICATION_VIEW_ICON_SIZE_PROPERTY:
		application_view_set_icon_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

