// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/compiler/v1alpha1/report.proto

package compilerv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A diagnostic level. This affects how (and whether) it is shown to users.
type Diagnostic_Level int32

const (
	Diagnostic_LEVEL_UNSPECIFIED Diagnostic_Level = 0
	Diagnostic_LEVEL_ICE         Diagnostic_Level = 1
	Diagnostic_LEVEL_ERROR       Diagnostic_Level = 2
	Diagnostic_LEVEL_WARNING     Diagnostic_Level = 3
	Diagnostic_LEVEL_REMARK      Diagnostic_Level = 4
)

// Enum value maps for Diagnostic_Level.
var (
	Diagnostic_Level_name = map[int32]string{
		0: "LEVEL_UNSPECIFIED",
		1: "LEVEL_ICE",
		2: "LEVEL_ERROR",
		3: "LEVEL_WARNING",
		4: "LEVEL_REMARK",
	}
	Diagnostic_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED": 0,
		"LEVEL_ICE":         1,
		"LEVEL_ERROR":       2,
		"LEVEL_WARNING":     3,
		"LEVEL_REMARK":      4,
	}
)

func (x Diagnostic_Level) Enum() *Diagnostic_Level {
	p := new(Diagnostic_Level)
	*p = x
	return p
}

func (x Diagnostic_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Diagnostic_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_report_proto_enumTypes[0].Descriptor()
}

func (Diagnostic_Level) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_report_proto_enumTypes[0]
}

func (x Diagnostic_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Diagnostic_Level.Descriptor instead.
func (Diagnostic_Level) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{1, 0}
}

// A diagnostic report, consisting of `Diagnostics` and the `File`s they diagnose.
type Report struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Files         []*Report_File         `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Report) Reset() {
	*x = Report{}
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Report) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Report) ProtoMessage() {}

func (x *Report) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Report.ProtoReflect.Descriptor instead.
func (*Report) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{0}
}

func (x *Report) GetFiles() []*Report_File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Report) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// A diagnostic within a `Report`.
type Diagnostic struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required. The message to show for this diagnostic. This should fit on one line.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// An optional machine-readable tag for the diagnostic.
	Tag string `protobuf:"bytes,8,opt,name=tag,proto3" json:"tag,omitempty"`
	// Required. The level for this diagnostic.
	Level Diagnostic_Level `protobuf:"varint,2,opt,name=level,proto3,enum=buf.compiler.v1alpha1.Diagnostic_Level" json:"level,omitempty"`
	// An optional path to show in the diagnostic, if it has no annotations.
	// This is useful for e.g. diagnostics that would have no spans.
	InFile string `protobuf:"bytes,3,opt,name=in_file,json=inFile,proto3" json:"in_file,omitempty"`
	// Annotations for source code relevant to this diagnostic.
	Annotations []*Diagnostic_Annotation `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Notes about the error to show to the user. May span multiple lines.
	Notes []string `protobuf:"bytes,5,rep,name=notes,proto3" json:"notes,omitempty"`
	// Helpful suggestions to the user.
	Help []string `protobuf:"bytes,6,rep,name=help,proto3" json:"help,omitempty"`
	// Debugging information related to the diagnostic. This should only be
	// used for information about debugging a tool or compiler that emits the
	// diagnostic, not the code being diagnosed.
	Debug         []string `protobuf:"bytes,7,rep,name=debug,proto3" json:"debug,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{1}
}

func (x *Diagnostic) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Diagnostic) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *Diagnostic) GetLevel() Diagnostic_Level {
	if x != nil {
		return x.Level
	}
	return Diagnostic_LEVEL_UNSPECIFIED
}

func (x *Diagnostic) GetInFile() string {
	if x != nil {
		return x.InFile
	}
	return ""
}

func (x *Diagnostic) GetAnnotations() []*Diagnostic_Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Diagnostic) GetNotes() []string {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *Diagnostic) GetHelp() []string {
	if x != nil {
		return x.Help
	}
	return nil
}

func (x *Diagnostic) GetDebug() []string {
	if x != nil {
		return x.Debug
	}
	return nil
}

// A file involved in a diagnostic `Report`.
type Report_File struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The path to this file. Does not need to be meaningful as a file-system
	// path.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The textual contents of this file. Presumed to be UTF-8, although it need
	// not be.
	Text          []byte `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Report_File) Reset() {
	*x = Report_File{}
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Report_File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Report_File) ProtoMessage() {}

func (x *Report_File) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Report_File.ProtoReflect.Descriptor instead.
func (*Report_File) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Report_File) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Report_File) GetText() []byte {
	if x != nil {
		return x.Text
	}
	return nil
}

// A file annotation within a `Diagnostic`. This corresponds to a single
// span of source code in a `Report`'s file.
type Diagnostic_Annotation struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A message to show under this snippet. May be empty.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Whether this is a "primary" snippet, which is used for deciding whether or not
	// to mark the snippet with the same color as the overall diagnostic.
	Primary bool `protobuf:"varint,2,opt,name=primary,proto3" json:"primary,omitempty"`
	// Whether this annotation wants to be on its own window, separate from
	// annotations that follow.
	PageBreak bool `protobuf:"varint,7,opt,name=page_break,json=pageBreak,proto3" json:"page_break,omitempty"`
	// The index of `Report.files` of the file this annotation is for.
	//
	// This is not a whole `Report.File` to help keep serialized reports slim. This
	// avoids neeidng to duplicate the whole text of the file one for every annotation.
	File uint32 `protobuf:"varint,3,opt,name=file,proto3" json:"file,omitempty"`
	// The start offset of the annotated snippet, in bytes.
	Start uint32 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end offset of the annotated snippet, in bytes.
	End           uint32             `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	Edits         []*Diagnostic_Edit `protobuf:"bytes,6,rep,name=edits,proto3" json:"edits,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic_Annotation) Reset() {
	*x = Diagnostic_Annotation{}
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic_Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic_Annotation) ProtoMessage() {}

func (x *Diagnostic_Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic_Annotation.ProtoReflect.Descriptor instead.
func (*Diagnostic_Annotation) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Diagnostic_Annotation) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Diagnostic_Annotation) GetPrimary() bool {
	if x != nil {
		return x.Primary
	}
	return false
}

func (x *Diagnostic_Annotation) GetPageBreak() bool {
	if x != nil {
		return x.PageBreak
	}
	return false
}

func (x *Diagnostic_Annotation) GetFile() uint32 {
	if x != nil {
		return x.File
	}
	return 0
}

func (x *Diagnostic_Annotation) GetStart() uint32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Diagnostic_Annotation) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Diagnostic_Annotation) GetEdits() []*Diagnostic_Edit {
	if x != nil {
		return x.Edits
	}
	return nil
}

// Edit is an edit to suggest on an `Annotation`.
//
// A pure insertion is modeled by `start == end`.
// A pure deletion is modeled by empty `replace`.
type Diagnostic_Edit struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The start offset of the edit, relative to the containing snippet.
	Start uint32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end offset of the edit, relative to the containing snippet.
	End uint32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The text to insert in place of the selected region.
	Replace       string `protobuf:"bytes,3,opt,name=replace,proto3" json:"replace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic_Edit) Reset() {
	*x = Diagnostic_Edit{}
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic_Edit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic_Edit) ProtoMessage() {}

func (x *Diagnostic_Edit) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_report_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic_Edit.ProtoReflect.Descriptor instead.
func (*Diagnostic_Edit) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_report_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Diagnostic_Edit) GetStart() uint32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Diagnostic_Edit) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Diagnostic_Edit) GetReplace() string {
	if x != nil {
		return x.Replace
	}
	return ""
}

var File_buf_compiler_v1alpha1_report_proto protoreflect.FileDescriptor

const file_buf_compiler_v1alpha1_report_proto_rawDesc = "" +
	"\n" +
	"\"buf/compiler/v1alpha1/report.proto\x12\x15buf.compiler.v1alpha1\"\xb7\x01\n" +
	"\x06Report\x128\n" +
	"\x05files\x18\x01 \x03(\v2\".buf.compiler.v1alpha1.Report.FileR\x05files\x12C\n" +
	"\vdiagnostics\x18\x02 \x03(\v2!.buf.compiler.v1alpha1.DiagnosticR\vdiagnostics\x1a.\n" +
	"\x04File\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x12\n" +
	"\x04text\x18\x02 \x01(\fR\x04text\"\xab\x05\n" +
	"\n" +
	"Diagnostic\x12\x18\n" +
	"\amessage\x18\x01 \x01(\tR\amessage\x12\x10\n" +
	"\x03tag\x18\b \x01(\tR\x03tag\x12=\n" +
	"\x05level\x18\x02 \x01(\x0e2'.buf.compiler.v1alpha1.Diagnostic.LevelR\x05level\x12\x17\n" +
	"\ain_file\x18\x03 \x01(\tR\x06inFile\x12N\n" +
	"\vannotations\x18\x04 \x03(\v2,.buf.compiler.v1alpha1.Diagnostic.AnnotationR\vannotations\x12\x14\n" +
	"\x05notes\x18\x05 \x03(\tR\x05notes\x12\x12\n" +
	"\x04help\x18\x06 \x03(\tR\x04help\x12\x14\n" +
	"\x05debug\x18\a \x03(\tR\x05debug\x1a\xd9\x01\n" +
	"\n" +
	"Annotation\x12\x18\n" +
	"\amessage\x18\x01 \x01(\tR\amessage\x12\x18\n" +
	"\aprimary\x18\x02 \x01(\bR\aprimary\x12\x1d\n" +
	"\n" +
	"page_break\x18\a \x01(\bR\tpageBreak\x12\x12\n" +
	"\x04file\x18\x03 \x01(\rR\x04file\x12\x14\n" +
	"\x05start\x18\x04 \x01(\rR\x05start\x12\x10\n" +
	"\x03end\x18\x05 \x01(\rR\x03end\x12<\n" +
	"\x05edits\x18\x06 \x03(\v2&.buf.compiler.v1alpha1.Diagnostic.EditR\x05edits\x1aH\n" +
	"\x04Edit\x12\x14\n" +
	"\x05start\x18\x01 \x01(\rR\x05start\x12\x10\n" +
	"\x03end\x18\x02 \x01(\rR\x03end\x12\x18\n" +
	"\areplace\x18\x03 \x01(\tR\areplace\"c\n" +
	"\x05Level\x12\x15\n" +
	"\x11LEVEL_UNSPECIFIED\x10\x00\x12\r\n" +
	"\tLEVEL_ICE\x10\x01\x12\x0f\n" +
	"\vLEVEL_ERROR\x10\x02\x12\x11\n" +
	"\rLEVEL_WARNING\x10\x03\x12\x10\n" +
	"\fLEVEL_REMARK\x10\x04B\xf4\x01\n" +
	"\x19com.buf.compiler.v1alpha1B\vReportProtoP\x01ZTgithub.com/bufbuild/protocompile/internal/gen/buf/compiler/v1alpha1;compilerv1alpha1\xa2\x02\x03BCX\xaa\x02\x15Buf.Compiler.V1alpha1\xca\x02\x15Buf\\Compiler\\V1alpha1\xe2\x02!Buf\\Compiler\\V1alpha1\\GPBMetadata\xea\x02\x17Buf::Compiler::V1alpha1b\x06proto3"

var (
	file_buf_compiler_v1alpha1_report_proto_rawDescOnce sync.Once
	file_buf_compiler_v1alpha1_report_proto_rawDescData []byte
)

func file_buf_compiler_v1alpha1_report_proto_rawDescGZIP() []byte {
	file_buf_compiler_v1alpha1_report_proto_rawDescOnce.Do(func() {
		file_buf_compiler_v1alpha1_report_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_report_proto_rawDesc), len(file_buf_compiler_v1alpha1_report_proto_rawDesc)))
	})
	return file_buf_compiler_v1alpha1_report_proto_rawDescData
}

var file_buf_compiler_v1alpha1_report_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_compiler_v1alpha1_report_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_buf_compiler_v1alpha1_report_proto_goTypes = []any{
	(Diagnostic_Level)(0),         // 0: buf.compiler.v1alpha1.Diagnostic.Level
	(*Report)(nil),                // 1: buf.compiler.v1alpha1.Report
	(*Diagnostic)(nil),            // 2: buf.compiler.v1alpha1.Diagnostic
	(*Report_File)(nil),           // 3: buf.compiler.v1alpha1.Report.File
	(*Diagnostic_Annotation)(nil), // 4: buf.compiler.v1alpha1.Diagnostic.Annotation
	(*Diagnostic_Edit)(nil),       // 5: buf.compiler.v1alpha1.Diagnostic.Edit
}
var file_buf_compiler_v1alpha1_report_proto_depIdxs = []int32{
	3, // 0: buf.compiler.v1alpha1.Report.files:type_name -> buf.compiler.v1alpha1.Report.File
	2, // 1: buf.compiler.v1alpha1.Report.diagnostics:type_name -> buf.compiler.v1alpha1.Diagnostic
	0, // 2: buf.compiler.v1alpha1.Diagnostic.level:type_name -> buf.compiler.v1alpha1.Diagnostic.Level
	4, // 3: buf.compiler.v1alpha1.Diagnostic.annotations:type_name -> buf.compiler.v1alpha1.Diagnostic.Annotation
	5, // 4: buf.compiler.v1alpha1.Diagnostic.Annotation.edits:type_name -> buf.compiler.v1alpha1.Diagnostic.Edit
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_compiler_v1alpha1_report_proto_init() }
func file_buf_compiler_v1alpha1_report_proto_init() {
	if File_buf_compiler_v1alpha1_report_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_report_proto_rawDesc), len(file_buf_compiler_v1alpha1_report_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_compiler_v1alpha1_report_proto_goTypes,
		DependencyIndexes: file_buf_compiler_v1alpha1_report_proto_depIdxs,
		EnumInfos:         file_buf_compiler_v1alpha1_report_proto_enumTypes,
		MessageInfos:      file_buf_compiler_v1alpha1_report_proto_msgTypes,
	}.Build()
	File_buf_compiler_v1alpha1_report_proto = out.File
	file_buf_compiler_v1alpha1_report_proto_goTypes = nil
	file_buf_compiler_v1alpha1_report_proto_depIdxs = nil
}
