/* bookmarks.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from bookmarks.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define BOOKMARKS_bookmark_this_search_text _ ("Bookmark this Search")
#define BOOKMARKS_bookmark_this_location_text _ ("Bookmark this Location")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BOOKMARK_ICON_VALID_FOLDER,
	BOOKMARK_ICON_SEARCH,
	BOOKMARK_ICON_DCONF_OBJECT,
	BOOKMARK_ICON_KEY_DEFAULTS,
	BOOKMARK_ICON_EDITED_VALUE,
	BOOKMARK_ICON_EMPTY_FOLDER,
	BOOKMARK_ICON_EMPTY_OBJECT
} BookmarkIcon;

#define TYPE_BOOKMARK_ICON (bookmark_icon_get_type ())

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;
typedef struct _BookmarksPrivate BookmarksPrivate;

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;

#define TYPE_BOOKMARKS_LIST (bookmarks_list_get_type ())
#define BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_LIST, BookmarksList))
#define BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_LIST, BookmarksListClass))
#define IS_BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_LIST))
#define IS_BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_LIST))
#define BOOKMARKS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_LIST, BookmarksListClass))

typedef struct _BookmarksList BookmarksList;
typedef struct _BookmarksListClass BookmarksListClass;

#define TYPE_BOOKMARKS_CONTROLLER (bookmarks_controller_get_type ())
#define BOOKMARKS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_CONTROLLER, BookmarksController))
#define BOOKMARKS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_CONTROLLER, BookmarksControllerClass))
#define IS_BOOKMARKS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_CONTROLLER))
#define IS_BOOKMARKS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_CONTROLLER))
#define BOOKMARKS_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_CONTROLLER, BookmarksControllerClass))

typedef struct _BookmarksController BookmarksController;
typedef struct _BookmarksControllerClass BookmarksControllerClass;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())
enum  {
	BOOKMARKS_0_PROPERTY,
	BOOKMARKS_SCHEMA_PATH_PROPERTY,
	BOOKMARKS_NUM_PROPERTIES
};
static GParamSpec* bookmarks_properties[BOOKMARKS_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	OVERLAYED_LIST_SELECTION_STATE_EMPTY,
	OVERLAYED_LIST_SELECTION_STATE_UNIQUE,
	OVERLAYED_LIST_SELECTION_STATE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_MIDDLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_ALL
} OverlayedListSelectionState;

#define OVERLAYED_LIST_TYPE_SELECTION_STATE (overlayed_list_selection_state_get_type ())
typedef struct _Block2Data Block2Data;
enum  {
	BOOKMARKS_UPDATE_BOOKMARKS_ICONS_SIGNAL,
	BOOKMARKS_NUM_SIGNALS
};
static guint bookmarks_signals[BOOKMARKS_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Bookmarks {
	GtkMenuButton parent_instance;
	BookmarksPrivate * priv;
};

struct _BookmarksClass {
	GtkMenuButtonClass parent_class;
};

struct _BookmarksPrivate {
	GtkImage* bookmarks_icon;
	GtkPopover* bookmarks_popover;
	GtkStack* edit_mode_stack;
	BookmarksList* bookmarks_list;
	GtkSwitch* bookmarked_switch;
	GtkLabel* switch_label;
	BookmarksController* bookmarks_controller;
	gchar* current_path;
	ViewType current_type;
	gchar* schema_id;
	GSettings* settings;
	gboolean actions_init_done;
	GSimpleAction* move_top_action;
	GSimpleAction* move_up_action;
	GSimpleAction* move_down_action;
	GSimpleAction* move_bottom_action;
	GSimpleAction* trash_bookmark_action;
	GSimpleAction* edit_mode_state_action;
};

struct _Block2Data {
	int _ref_count_;
	Bookmarks* self;
	GtkStyleContext* context;
	gboolean has_small_bookmarks_rows_class;
	gulong small_bookmarks_rows_handler;
};

static gint Bookmarks_private_offset;
static gpointer bookmarks_parent_class = NULL;

VALA_EXTERN GType bookmark_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bookmarks_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bookmarks, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType bookmarks_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksList, g_object_unref)
VALA_EXTERN GType bookmarks_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksController, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
static void bookmarks_set_edit_mode (Bookmarks* self,
                              GSimpleAction* action,
                              GVariant* variant);
static void _bookmarks_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void bookmarks_trash_bookmark (Bookmarks* self);
static void _bookmarks_trash_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void bookmarks_set_small_rows (Bookmarks* self);
static void _bookmarks_set_small_rows_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void bookmarks_move_top (Bookmarks* self);
static void _bookmarks_move_top_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void bookmarks_move_up (Bookmarks* self);
static void _bookmarks_move_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void bookmarks_move_down (Bookmarks* self);
static void _bookmarks_move_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void bookmarks_move_bottom (Bookmarks* self);
static void _bookmarks_move_bottom_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void bookmarks_bookmark (Bookmarks* self,
                         GSimpleAction* action,
                         GVariant* path_variant);
static void _bookmarks_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void bookmarks_unbookmark (Bookmarks* self,
                           GSimpleAction* action,
                           GVariant* path_variant);
static void _bookmarks_unbookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void bookmarks_on_update_bookmarks_icons (Bookmarks* self,
                                          GVariant* bookmarks_variant);
static void _bookmarks_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons (BookmarksList* _sender,
                                                                                 GVariant* bookmarks_variant,
                                                                                 gpointer self);
VALA_EXTERN Bookmarks* bookmarks_new (const gchar* _schema_path);
VALA_EXTERN Bookmarks* bookmarks_construct (GType object_type,
                                const gchar* _schema_path);
static void bookmarks_on_bookmarks_changed (Bookmarks* self,
                                     GVariant* bookmarks_variant,
                                     gboolean writable);
static void bookmarks_leave_edit_mode (Bookmarks* self);
static void bookmarks_update_icon_and_switch (Bookmarks* self,
                                       GVariant* bookmarks_variant);
static void bookmarks_set_switch_sensitivity (Bookmarks* self,
                                       gboolean writable);
static void _bookmarks_on_bookmarks_changed_bookmarks_list_bookmarks_changed (BookmarksList* _sender,
                                                                       GVariant* bookmarks_variant,
                                                                       gboolean writable,
                                                                       gpointer self);
static void bookmarks_on_writability_changed (Bookmarks* self,
                                       gboolean writable);
static void _bookmarks_on_writability_changed_bookmarks_list_writability_changed (BookmarksList* _sender,
                                                                           gboolean writable,
                                                                           gpointer self);
static gboolean bookmarks_on_key_press_event (Bookmarks* self,
                                       GtkWidget* widget,
                                       GdkEventKey* event);
VALA_EXTERN void overlayed_list_select_all (OverlayedList* self);
VALA_EXTERN void overlayed_list_unselect_all (OverlayedList* self);
static gboolean _bookmarks_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                   GdkEventKey* event,
                                                                   gpointer self);
static void bookmarks_on_selection_changed (Bookmarks* self);
static void bookmarks_update_actions (Bookmarks* self);
static void _bookmarks_on_selection_changed_overlayed_list_selection_changed (OverlayedList* _sender,
                                                                       gpointer self);
VALA_EXTERN void bookmarks_set_path (Bookmarks* self,
                         ViewType type,
                         const gchar* path);
static void bookmarks_update_switch_label (ViewType old_type,
                                    ViewType new_type,
                                    GtkLabel* switch_label);
VALA_EXTERN GVariant* bookmarks_list_get_bookmarks_as_variant (BookmarksList* self);
VALA_EXTERN gchar** bookmarks_get_bookmarks (Bookmarks* self,
                                 gint* result_length1);
VALA_EXTERN gchar** bookmarks_list_get_bookmarks_as_array (BookmarksList* self,
                                               gint* result_length1);
VALA_EXTERN gboolean bookmarks_next_match (Bookmarks* self);
VALA_EXTERN gboolean overlayed_list_next_match (OverlayedList* self);
VALA_EXTERN gboolean bookmarks_previous_match (Bookmarks* self);
VALA_EXTERN gboolean overlayed_list_previous_match (OverlayedList* self);
VALA_EXTERN gboolean bookmarks_handle_copy_text (Bookmarks* self,
                                     gchar** copy_text);
VALA_EXTERN gboolean overlayed_list_handle_copy_text (OverlayedList* self,
                                          gchar** copy_text);
VALA_EXTERN void bookmarks_bookmark_current_path (Bookmarks* self);
VALA_EXTERN void bookmarks_list_append_bookmark (BookmarksList* self,
                                     ViewType type,
                                     const gchar* bookmark);
VALA_EXTERN void bookmarks_unbookmark_current_path (Bookmarks* self);
VALA_EXTERN void bookmarks_list_remove_bookmark (BookmarksList* self,
                                     ViewType type,
                                     const gchar* bookmark);
VALA_EXTERN void bookmarks_update_bookmark_icon (Bookmarks* self,
                                     const gchar* bookmark,
                                     BookmarkIcon icon);
VALA_EXTERN void bookmarks_list_update_bookmark_icon (BookmarksList* self,
                                          const gchar* bookmark,
                                          BookmarkIcon icon);
VALA_EXTERN GType overlayed_list_selection_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void _bookmarks_update_actions (OverlayedListSelectionState selection_state,
                                GSimpleAction** move_top_action,
                                GSimpleAction** move_up_action,
                                GSimpleAction** move_down_action,
                                GSimpleAction** move_bottom_action,
                                GSimpleAction** trash_bookmark_action);
VALA_EXTERN OverlayedListSelectionState overlayed_list_get_selection_state (OverlayedList* self);
static void bookmarks_install_action_entries (Bookmarks* self);
static GVariant* _variant_new3 (gboolean value);
static void bookmarks_enter_edit_mode (Bookmarks* self);
static GVariant* _variant_new4 (gboolean value);
VALA_EXTERN void bookmarks_list_enter_edit_mode (BookmarksList* self);
static GVariant* _variant_new5 (gboolean value);
VALA_EXTERN gboolean bookmarks_list_leave_edit_mode (BookmarksList* self);
static void _bookmarks_leave_edit_mode_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
VALA_EXTERN void bookmarks_list_trash_bookmark (BookmarksList* self);
VALA_EXTERN gboolean bookmarks_controller_get_small_rows_state (BookmarksController* self);
VALA_EXTERN void bookmarks_list_move_top (BookmarksList* self);
VALA_EXTERN void bookmarks_list_move_up (BookmarksList* self);
VALA_EXTERN void bookmarks_list_move_down (BookmarksList* self);
VALA_EXTERN void bookmarks_list_move_bottom (BookmarksList* self);
VALA_EXTERN ViewType view_type_from_byte (guint8 type);
VALA_EXTERN guint8 view_type_to_byte (ViewType type);
VALA_EXTERN gchar* bookmarks_list_get_bookmark_name (ViewType type,
                                         const gchar* path);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void bookmarks_update_switch_state (gboolean bookmarked,
                                    GtkSwitch* bookmarked_switch);
static void bookmarks_set_schema_path (Bookmarks* self,
                                const gchar* value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void bookmarks_list_set_schema_path (BookmarksList* self,
                                     const gchar* value);
static void _bookmarks_schema_path___lambda102_ (Block2Data* _data2_);
VALA_EXTERN void bookmarks_controller_update_rows_size_button_icon (BookmarksController* self,
                                                        gboolean small_bookmarks_rows);
static void __bookmarks_schema_path___lambda102__g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void _bookmarks_schema_path___lambda103_ (Block2Data* _data2_);
static void __bookmarks_schema_path___lambda103__gtk_widget_destroy (GtkWidget* _sender,
                                                              gpointer self);
static GObject * bookmarks_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void _bookmarks___lambda104_ (Bookmarks* self);
static void __bookmarks___lambda104__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void bookmarks_finalize (GObject * obj);
static GType bookmarks_get_type_once (void);
static void _vala_bookmarks_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static const GActionEntry BOOKMARKS_action_entries[9] = {{"set-edit-mode", _bookmarks_set_edit_mode_gsimple_action_activate_callback, "b", "false"}, {"trash-bookmark", _bookmarks_trash_bookmark_gsimple_action_activate_callback}, {"set-small-rows", _bookmarks_set_small_rows_gsimple_action_activate_callback}, {"move-top", _bookmarks_move_top_gsimple_action_activate_callback}, {"move-up", _bookmarks_move_up_gsimple_action_activate_callback}, {"move-down", _bookmarks_move_down_gsimple_action_activate_callback}, {"move-bottom", _bookmarks_move_bottom_gsimple_action_activate_callback}, {"bookmark", _bookmarks_bookmark_gsimple_action_activate_callback, "(ys)"}, {"unbookmark", _bookmarks_unbookmark_gsimple_action_activate_callback, "(ys)"}};

static GType
bookmark_icon_get_type_once (void)
{
	static const GEnumValue values[] = {{BOOKMARK_ICON_VALID_FOLDER, "BOOKMARK_ICON_VALID_FOLDER", "valid-folder"}, {BOOKMARK_ICON_SEARCH, "BOOKMARK_ICON_SEARCH", "search"}, {BOOKMARK_ICON_DCONF_OBJECT, "BOOKMARK_ICON_DCONF_OBJECT", "dconf-object"}, {BOOKMARK_ICON_KEY_DEFAULTS, "BOOKMARK_ICON_KEY_DEFAULTS", "key-defaults"}, {BOOKMARK_ICON_EDITED_VALUE, "BOOKMARK_ICON_EDITED_VALUE", "edited-value"}, {BOOKMARK_ICON_EMPTY_FOLDER, "BOOKMARK_ICON_EMPTY_FOLDER", "empty-folder"}, {BOOKMARK_ICON_EMPTY_OBJECT, "BOOKMARK_ICON_EMPTY_OBJECT", "empty-object"}, {0, NULL, NULL}};
	GType bookmark_icon_type_id;
	bookmark_icon_type_id = g_enum_register_static ("BookmarkIcon", values);
	return bookmark_icon_type_id;
}

GType
bookmark_icon_get_type (void)
{
	static volatile gsize bookmark_icon_type_id__once = 0;
	if (g_once_init_enter (&bookmark_icon_type_id__once)) {
		GType bookmark_icon_type_id;
		bookmark_icon_type_id = bookmark_icon_get_type_once ();
		g_once_init_leave (&bookmark_icon_type_id__once, bookmark_icon_type_id);
	}
	return bookmark_icon_type_id__once;
}

static inline gpointer
bookmarks_get_instance_private (Bookmarks* self)
{
	return G_STRUCT_MEMBER_P (self, Bookmarks_private_offset);
}

static void
_bookmarks_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	bookmarks_set_edit_mode ((Bookmarks*) self, action, parameter);
}

static void
_bookmarks_trash_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	bookmarks_trash_bookmark ((Bookmarks*) self);
}

static void
_bookmarks_set_small_rows_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	bookmarks_set_small_rows ((Bookmarks*) self);
}

static void
_bookmarks_move_top_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	bookmarks_move_top ((Bookmarks*) self);
}

static void
_bookmarks_move_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	bookmarks_move_up ((Bookmarks*) self);
}

static void
_bookmarks_move_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	bookmarks_move_down ((Bookmarks*) self);
}

static void
_bookmarks_move_bottom_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	bookmarks_move_bottom ((Bookmarks*) self);
}

static void
_bookmarks_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	bookmarks_bookmark ((Bookmarks*) self, action, parameter);
}

static void
_bookmarks_unbookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	bookmarks_unbookmark ((Bookmarks*) self, action, parameter);
}

static void
bookmarks_on_update_bookmarks_icons (Bookmarks* self,
                                     GVariant* bookmarks_variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmarks_variant != NULL);
	g_signal_emit (self, bookmarks_signals[BOOKMARKS_UPDATE_BOOKMARKS_ICONS_SIGNAL], 0, bookmarks_variant);
}

static void
_bookmarks_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons (BookmarksList* _sender,
                                                                            GVariant* bookmarks_variant,
                                                                            gpointer self)
{
	bookmarks_on_update_bookmarks_icons ((Bookmarks*) self, bookmarks_variant);
}

Bookmarks*
bookmarks_construct (GType object_type,
                     const gchar* _schema_path)
{
	Bookmarks * self = NULL;
	g_return_val_if_fail (_schema_path != NULL, NULL);
	self = (Bookmarks*) g_object_new (object_type, "schema-path", _schema_path, NULL);
	return self;
}

Bookmarks*
bookmarks_new (const gchar* _schema_path)
{
	return bookmarks_construct (TYPE_BOOKMARKS, _schema_path);
}

static void
bookmarks_on_bookmarks_changed (Bookmarks* self,
                                GVariant* bookmarks_variant,
                                gboolean writable)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gsize _tmp6_ = 0;
	const gchar** _tmp7_;
	const gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmarks_variant != NULL);
	_tmp0_ = g_variant_print (bookmarks_variant, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("bw.update-bookmarks-icons(", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ")", NULL);
	_tmp5_ = _tmp4_;
	gtk_actionable_set_detailed_action_name ((GtkActionable*) self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp7_ = g_variant_get_strv (bookmarks_variant, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = _tmp6_ == 0;
	_tmp8_ = (g_free (_tmp8_), NULL);
	if (_tmp9_) {
		gchar* visible_child_name = NULL;
		GtkStack* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp10_ = self->priv->edit_mode_stack;
		_tmp11_ = gtk_stack_get_visible_child_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		visible_child_name = _tmp12_;
		_tmp14_ = visible_child_name;
		if (_tmp14_ != NULL) {
			const gchar* _tmp15_;
			_tmp15_ = visible_child_name;
			_tmp13_ = g_strcmp0 ((const gchar*) _tmp15_, "edit-mode-on") == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			bookmarks_leave_edit_mode (self);
		}
		_g_free0 (visible_child_name);
	}
	bookmarks_update_icon_and_switch (self, bookmarks_variant);
	bookmarks_set_switch_sensitivity (self, writable);
}

static void
_bookmarks_on_bookmarks_changed_bookmarks_list_bookmarks_changed (BookmarksList* _sender,
                                                                  GVariant* bookmarks_variant,
                                                                  gboolean writable,
                                                                  gpointer self)
{
	bookmarks_on_bookmarks_changed ((Bookmarks*) self, bookmarks_variant, writable);
}

static void
bookmarks_on_writability_changed (Bookmarks* self,
                                  gboolean writable)
{
	g_return_if_fail (self != NULL);
	bookmarks_set_switch_sensitivity (self, writable);
}

static void
_bookmarks_on_writability_changed_bookmarks_list_writability_changed (BookmarksList* _sender,
                                                                      gboolean writable,
                                                                      gpointer self)
{
	bookmarks_on_writability_changed ((Bookmarks*) self, writable);
}

static void
bookmarks_set_switch_sensitivity (Bookmarks* self,
                                  gboolean writable)
{
	g_return_if_fail (self != NULL);
	if (writable) {
		gchar* visible_child_name = NULL;
		GtkStack* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->edit_mode_stack;
		_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
		_tmp2_ = g_strdup (_tmp1_);
		visible_child_name = _tmp2_;
		_tmp4_ = visible_child_name;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_;
			_tmp5_ = visible_child_name;
			_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "edit-mode-disabled") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkStack* _tmp6_;
			_tmp6_ = self->priv->edit_mode_stack;
			gtk_stack_set_visible_child_name (_tmp6_, "edit-mode-off");
		}
		_g_free0 (visible_child_name);
	} else {
		GtkStack* _tmp7_;
		BookmarksList* _tmp8_;
		_tmp7_ = self->priv->edit_mode_stack;
		gtk_stack_set_visible_child_name (_tmp7_, "edit-mode-disabled");
		_tmp8_ = self->priv->bookmarks_list;
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
	}
}

static gboolean
bookmarks_on_key_press_event (Bookmarks* self,
                              GtkWidget* widget,
                              GdkEventKey* event)
{
	guint keyval = 0U;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gchar* visible_child_name = NULL;
	GtkStack* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean edit_mode_on = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	keyval = event->keyval;
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	_tmp3_ = self->priv->edit_mode_stack;
	_tmp4_ = gtk_stack_get_visible_child_name (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	visible_child_name = _tmp5_;
	_tmp7_ = visible_child_name;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = visible_child_name;
		_tmp6_ = g_strcmp0 ((const gchar*) _tmp8_, "edit-mode-on") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	edit_mode_on = _tmp6_;
	if ((event->state & GDK_CONTROL_MASK) != 0) {
		if (edit_mode_on) {
			const gchar* _tmp9_;
			const gchar* _tmp11_;
			_tmp9_ = name;
			if (g_strcmp0 (_tmp9_, "a") == 0) {
				BookmarksList* _tmp10_;
				_tmp10_ = self->priv->bookmarks_list;
				overlayed_list_select_all ((OverlayedList*) _tmp10_);
				result = TRUE;
				_g_free0 (visible_child_name);
				_g_free0 (name);
				return result;
			}
			_tmp11_ = name;
			if (g_strcmp0 (_tmp11_, "A") == 0) {
				BookmarksList* _tmp12_;
				_tmp12_ = self->priv->bookmarks_list;
				overlayed_list_unselect_all ((OverlayedList*) _tmp12_);
				result = TRUE;
				_g_free0 (visible_child_name);
				_g_free0 (name);
				return result;
			}
		}
	}
	if (keyval == GDK_KEY_Escape) {
		_tmp13_ = edit_mode_on;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		bookmarks_leave_edit_mode (self);
		result = TRUE;
		_g_free0 (visible_child_name);
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (visible_child_name);
	_g_free0 (name);
	return result;
}

static gboolean
_bookmarks_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                          GdkEventKey* event,
                                                          gpointer self)
{
	gboolean result;
	result = bookmarks_on_key_press_event ((Bookmarks*) self, _sender, event);
	return result;
}

static void
bookmarks_on_selection_changed (Bookmarks* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->actions_init_done) {
		bookmarks_update_actions (self);
	}
}

static void
_bookmarks_on_selection_changed_overlayed_list_selection_changed (OverlayedList* _sender,
                                                                  gpointer self)
{
	bookmarks_on_selection_changed ((Bookmarks*) self);
}

void
bookmarks_set_path (Bookmarks* self,
                    ViewType type,
                    const gchar* path)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	BookmarksList* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->switch_label;
	bookmarks_update_switch_label (self->priv->current_type, type, _tmp0_);
	_tmp1_ = g_strdup (path);
	_g_free0 (self->priv->current_path);
	self->priv->current_path = _tmp1_;
	self->priv->current_type = type;
	_tmp2_ = self->priv->bookmarks_list;
	_tmp3_ = bookmarks_list_get_bookmarks_as_variant (_tmp2_);
	_tmp4_ = _tmp3_;
	bookmarks_update_icon_and_switch (self, _tmp4_);
	_g_variant_unref0 (_tmp4_);
}

gchar**
bookmarks_get_bookmarks (Bookmarks* self,
                         gint* result_length1)
{
	BookmarksList* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookmarks_list;
	_tmp2_ = bookmarks_list_get_bookmarks_as_array (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

gboolean
bookmarks_next_match (Bookmarks* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BookmarksList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "active", FALSE);
	_tmp2_ = self->priv->bookmarks_list;
	result = overlayed_list_next_match ((OverlayedList*) _tmp2_);
	return result;
}

gboolean
bookmarks_previous_match (Bookmarks* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BookmarksList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "active", FALSE);
	_tmp2_ = self->priv->bookmarks_list;
	result = overlayed_list_previous_match ((OverlayedList*) _tmp2_);
	return result;
}

gboolean
bookmarks_handle_copy_text (Bookmarks* self,
                            gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	BookmarksList* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bookmarks_list;
	_tmp2_ = overlayed_list_handle_copy_text ((OverlayedList*) _tmp0_, &_tmp1_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = _tmp2_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

void
bookmarks_bookmark_current_path (Bookmarks* self)
{
	GtkSwitch* _tmp0_;
	BookmarksList* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarked_switch;
	if (gtk_switch_get_active (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->bookmarks_list;
	_tmp2_ = self->priv->current_path;
	bookmarks_list_append_bookmark (_tmp1_, self->priv->current_type, _tmp2_);
}

void
bookmarks_unbookmark_current_path (Bookmarks* self)
{
	GtkSwitch* _tmp0_;
	BookmarksList* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarked_switch;
	if (!gtk_switch_get_active (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->bookmarks_list;
	_tmp2_ = self->priv->current_path;
	bookmarks_list_remove_bookmark (_tmp1_, self->priv->current_type, _tmp2_);
}

void
bookmarks_update_bookmark_icon (Bookmarks* self,
                                const gchar* bookmark,
                                BookmarkIcon icon)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_update_bookmark_icon (_tmp0_, bookmark, icon);
}

static void
bookmarks_update_actions (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->actions_init_done, "actions_init_done");
	_tmp0_ = self->priv->bookmarks_list;
	_bookmarks_update_actions (overlayed_list_get_selection_state ((OverlayedList*) _tmp0_), &self->priv->move_top_action, &self->priv->move_up_action, &self->priv->move_down_action, &self->priv->move_bottom_action, &self->priv->trash_bookmark_action);
}

void
_bookmarks_update_actions (OverlayedListSelectionState selection_state,
                           GSimpleAction** move_top_action,
                           GSimpleAction** move_up_action,
                           GSimpleAction** move_down_action,
                           GSimpleAction** move_bottom_action,
                           GSimpleAction** trash_bookmark_action)
{
	gboolean one_middle_selection = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean enable_move_up_action = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean enable_move_down_action = FALSE;
	gboolean multiple_middle_selections = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (*move_top_action != NULL);
	g_return_if_fail (*move_up_action != NULL);
	g_return_if_fail (*move_down_action != NULL);
	g_return_if_fail (*move_bottom_action != NULL);
	g_return_if_fail (*trash_bookmark_action != NULL);
	g_simple_action_set_enabled (*trash_bookmark_action, selection_state != OVERLAYED_LIST_SELECTION_STATE_EMPTY);
	one_middle_selection = selection_state == OVERLAYED_LIST_SELECTION_STATE_MIDDLE;
	if (one_middle_selection) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = selection_state == OVERLAYED_LIST_SELECTION_STATE_LAST;
	}
	enable_move_up_action = _tmp0_;
	if (one_middle_selection) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = selection_state == OVERLAYED_LIST_SELECTION_STATE_FIRST;
	}
	enable_move_down_action = _tmp1_;
	g_simple_action_set_enabled (*move_up_action, enable_move_up_action);
	g_simple_action_set_enabled (*move_down_action, enable_move_down_action);
	multiple_middle_selections = selection_state == OVERLAYED_LIST_SELECTION_STATE_MULTIPLE;
	if (selection_state == OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = multiple_middle_selections;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = enable_move_up_action;
	}
	g_simple_action_set_enabled (*move_top_action, _tmp2_);
	if (selection_state == OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = multiple_middle_selections;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = enable_move_down_action;
	}
	g_simple_action_set_enabled (*move_bottom_action, _tmp4_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bookmarks_install_action_entries (Bookmarks* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GAction* _tmp11_;
	GSimpleAction* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BOOKMARKS_action_entries, (gint) G_N_ELEMENTS (BOOKMARKS_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "bookmarks", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-top");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_top_action);
	self->priv->move_top_action = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-up");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_up_action);
	self->priv->move_up_action = _tmp4_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-down");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_down_action);
	self->priv->move_down_action = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-bottom");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_bottom_action);
	self->priv->move_bottom_action = _tmp8_;
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) action_group, "trash-bookmark");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->trash_bookmark_action);
	self->priv->trash_bookmark_action = _tmp10_;
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) action_group, "set-edit-mode");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->edit_mode_state_action);
	self->priv->edit_mode_state_action = _tmp12_;
	self->priv->actions_init_done = TRUE;
	_g_object_unref0 (action_group);
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
bookmarks_set_edit_mode (Bookmarks* self,
                         GSimpleAction* action,
                         GVariant* variant)
{
	gboolean new_state = FALSE;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	new_state = g_variant_get_boolean ((GVariant*) variant);
	_tmp0_ = _variant_new3 (new_state);
	g_simple_action_set_state (action, _tmp0_);
	_g_variant_unref0 (_tmp0_);
	if (new_state) {
		bookmarks_enter_edit_mode (self);
	} else {
		bookmarks_leave_edit_mode (self);
	}
}

static GVariant*
_variant_new4 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
bookmarks_enter_edit_mode (Bookmarks* self)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GtkStack* _tmp2_;
	BookmarksList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->edit_mode_state_action;
	_tmp1_ = _variant_new4 (TRUE);
	g_simple_action_set_state (_tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->edit_mode_stack;
	gtk_stack_set_visible_child_name (_tmp2_, "edit-mode-on");
	_tmp3_ = self->priv->bookmarks_list;
	bookmarks_list_enter_edit_mode (_tmp3_);
}

static GVariant*
_variant_new5 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
bookmarks_leave_edit_mode (Bookmarks* self)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	gboolean give_focus_to_switch = FALSE;
	BookmarksList* _tmp2_;
	GtkStack* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->edit_mode_state_action;
	_tmp1_ = _variant_new5 (FALSE);
	g_simple_action_set_state (_tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->bookmarks_list;
	give_focus_to_switch = bookmarks_list_leave_edit_mode (_tmp2_);
	_tmp3_ = self->priv->edit_mode_stack;
	gtk_stack_set_visible_child_name (_tmp3_, "edit-mode-off");
	if (give_focus_to_switch) {
		GtkSwitch* _tmp4_;
		_tmp4_ = self->priv->bookmarked_switch;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	}
}

static void
_bookmarks_leave_edit_mode_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	bookmarks_leave_edit_mode ((Bookmarks*) self);
}

static void
bookmarks_trash_bookmark (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_trash_bookmark (_tmp0_);
}

static void
bookmarks_set_small_rows (Bookmarks* self)
{
	GSettings* _tmp0_;
	BookmarksController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->bookmarks_controller;
	g_settings_set_boolean (_tmp0_, "small-bookmarks-rows", bookmarks_controller_get_small_rows_state (_tmp1_));
}

static void
bookmarks_move_top (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_top (_tmp0_);
}

static void
bookmarks_move_up (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_up (_tmp0_);
}

static void
bookmarks_move_down (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_down (_tmp0_);
}

static void
bookmarks_move_bottom (Bookmarks* self)
{
	BookmarksList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_move_bottom (_tmp0_);
}

static void
bookmarks_bookmark (Bookmarks* self,
                    GSimpleAction* action,
                    GVariant* path_variant)
{
	GtkPopover* _tmp0_;
	guint8 type = 0U;
	gchar* bookmark = NULL;
	guint8 _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	BookmarksList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	_tmp0_ = self->priv->bookmarks_popover;
	g_signal_emit_by_name (_tmp0_, "closed");
	g_variant_get ((GVariant*) path_variant, "(ys)", &_tmp1_, &_tmp2_, NULL);
	type = _tmp1_;
	_g_free0 (bookmark);
	bookmark = _tmp2_;
	_tmp3_ = self->priv->bookmarks_list;
	bookmarks_list_append_bookmark (_tmp3_, view_type_from_byte (type), bookmark);
	_g_free0 (bookmark);
}

static void
bookmarks_unbookmark (Bookmarks* self,
                      GSimpleAction* action,
                      GVariant* path_variant)
{
	GtkPopover* _tmp0_;
	guint8 type = 0U;
	gchar* bookmark = NULL;
	guint8 _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	BookmarksList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	_tmp0_ = self->priv->bookmarks_popover;
	g_signal_emit_by_name (_tmp0_, "closed");
	g_variant_get ((GVariant*) path_variant, "(ys)", &_tmp1_, &_tmp2_, NULL);
	type = _tmp1_;
	_g_free0 (bookmark);
	bookmark = _tmp2_;
	_tmp3_ = self->priv->bookmarks_list;
	bookmarks_list_remove_bookmark (_tmp3_, view_type_from_byte (type), bookmark);
	_g_free0 (bookmark);
}

static void
bookmarks_update_switch_label (ViewType old_type,
                               ViewType new_type,
                               GtkLabel* switch_label)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (switch_label != NULL);
	if (new_type == VIEW_TYPE_SEARCH) {
		_tmp0_ = old_type != VIEW_TYPE_SEARCH;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_label_set_label (switch_label, BOOKMARKS_bookmark_this_search_text);
	} else {
		gboolean _tmp1_ = FALSE;
		if (new_type != VIEW_TYPE_SEARCH) {
			_tmp1_ = old_type == VIEW_TYPE_SEARCH;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gtk_label_set_label (switch_label, BOOKMARKS_bookmark_this_location_text);
		}
	}
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
bookmarks_update_icon_and_switch (Bookmarks* self,
                                  GVariant* bookmarks_variant)
{
	GVariant* variant = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	gchar* bookmark_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gsize _tmp5_ = 0;
	const gchar** _tmp6_;
	const gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmarks_variant != NULL);
	_tmp0_ = self->priv->current_path;
	_tmp1_ = g_variant_new ("(ys)", view_type_to_byte (self->priv->current_type), _tmp0_, NULL);
	g_variant_ref_sink (_tmp1_);
	variant = _tmp1_;
	_tmp2_ = self->priv->current_path;
	_tmp3_ = bookmarks_list_get_bookmark_name (self->priv->current_type, _tmp2_);
	bookmark_name = _tmp3_;
	_tmp4_ = bookmark_name;
	_tmp6_ = g_variant_get_strv (bookmarks_variant, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp8_ = _vala_string_array_contains (_tmp7_, _tmp5_, _tmp4_);
	_tmp7_ = (g_free (_tmp7_), NULL);
	if (_tmp8_) {
		GtkImage* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_;
		GtkSwitch* _tmp15_;
		GtkSwitch* _tmp16_;
		GVariant* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp9_ = self->priv->bookmarks_icon;
		g_object_get (_tmp9_, "icon-name", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp12_, "starred-symbolic") != 0;
		_g_free0 (_tmp12_);
		if (_tmp13_) {
			GtkImage* _tmp14_;
			_tmp14_ = self->priv->bookmarks_icon;
			g_object_set (_tmp14_, "icon-name", "starred-symbolic", NULL);
		}
		_tmp15_ = self->priv->bookmarked_switch;
		bookmarks_update_switch_state (TRUE, _tmp15_);
		_tmp16_ = self->priv->bookmarked_switch;
		_tmp17_ = variant;
		_tmp18_ = g_variant_print (_tmp17_, TRUE);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("bookmarks.unbookmark(", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
		_tmp23_ = _tmp22_;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp16_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	} else {
		GtkImage* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gboolean _tmp28_;
		GtkSwitch* _tmp30_;
		GtkSwitch* _tmp31_;
		GVariant* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp24_ = self->priv->bookmarks_icon;
		g_object_get (_tmp24_, "icon-name", &_tmp25_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strcmp0 (_tmp27_, "non-starred-symbolic") != 0;
		_g_free0 (_tmp27_);
		if (_tmp28_) {
			GtkImage* _tmp29_;
			_tmp29_ = self->priv->bookmarks_icon;
			g_object_set (_tmp29_, "icon-name", "non-starred-symbolic", NULL);
		}
		_tmp30_ = self->priv->bookmarked_switch;
		bookmarks_update_switch_state (FALSE, _tmp30_);
		_tmp31_ = self->priv->bookmarked_switch;
		_tmp32_ = variant;
		_tmp33_ = g_variant_print (_tmp32_, TRUE);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat ("bookmarks.bookmark(", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, ")", NULL);
		_tmp38_ = _tmp37_;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp31_, _tmp38_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
	}
	_g_free0 (bookmark_name);
	_g_variant_unref0 (variant);
}

static void
bookmarks_update_switch_state (gboolean bookmarked,
                               GtkSwitch* bookmarked_switch)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (bookmarked_switch != NULL);
	_tmp0_ = gtk_switch_get_active (bookmarked_switch);
	_tmp1_ = _tmp0_;
	if (bookmarked == _tmp1_) {
		return;
	}
	gtk_actionable_set_detailed_action_name ((GtkActionable*) bookmarked_switch, "browser.empty((byte 255,''))");
	gtk_switch_set_active (bookmarked_switch, bookmarked);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Bookmarks* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->context);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_bookmarks_schema_path___lambda102_ (Block2Data* _data2_)
{
	Bookmarks* self;
	gboolean small_bookmarks_rows = FALSE;
	GSettings* _tmp0_;
	BookmarksController* _tmp3_;
	self = _data2_->self;
	_tmp0_ = self->priv->settings;
	small_bookmarks_rows = g_settings_get_boolean (_tmp0_, "small-bookmarks-rows");
	if (small_bookmarks_rows) {
		if (!_data2_->has_small_bookmarks_rows_class) {
			GtkStyleContext* _tmp1_;
			_tmp1_ = _data2_->context;
			gtk_style_context_add_class (_tmp1_, "small-bookmarks-rows");
		}
	} else {
		if (_data2_->has_small_bookmarks_rows_class) {
			GtkStyleContext* _tmp2_;
			_tmp2_ = _data2_->context;
			gtk_style_context_remove_class (_tmp2_, "small-bookmarks-rows");
		}
	}
	_data2_->has_small_bookmarks_rows_class = small_bookmarks_rows;
	_tmp3_ = self->priv->bookmarks_controller;
	bookmarks_controller_update_rows_size_button_icon (_tmp3_, small_bookmarks_rows);
}

static void
__bookmarks_schema_path___lambda102__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	_bookmarks_schema_path___lambda102_ (self);
}

static void
_bookmarks_schema_path___lambda103_ (Block2Data* _data2_)
{
	Bookmarks* self;
	GSettings* _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->settings;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data2_->small_bookmarks_rows_handler);
}

static void
__bookmarks_schema_path___lambda103__gtk_widget_destroy (GtkWidget* _sender,
                                                         gpointer self)
{
	_bookmarks_schema_path___lambda103_ (self);
}

static void
bookmarks_set_schema_path (Bookmarks* self,
                           const gchar* value)
{
	Block2Data* _data2_;
	BookmarksList* _tmp0_;
	const gchar* _tmp1_;
	GSettings* _tmp2_;
	GtkPopover* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GSettings* _tmp6_;
	gulong _tmp7_;
	GSettings* _tmp8_;
	BookmarksController* _tmp10_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->bookmarks_list;
	bookmarks_list_set_schema_path (_tmp0_, value);
	_tmp1_ = self->priv->schema_id;
	_tmp2_ = g_settings_new_with_path (_tmp1_, value);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = self->priv->bookmarks_popover;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data2_->context = _tmp5_;
	_data2_->has_small_bookmarks_rows_class = FALSE;
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_signal_connect_data (_tmp6_, "changed::small-bookmarks-rows", (GCallback) __bookmarks_schema_path___lambda102__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->small_bookmarks_rows_handler = _tmp7_;
	_tmp8_ = self->priv->settings;
	_data2_->has_small_bookmarks_rows_class = g_settings_get_boolean (_tmp8_, "small-bookmarks-rows");
	if (_data2_->has_small_bookmarks_rows_class) {
		GtkStyleContext* _tmp9_;
		_tmp9_ = _data2_->context;
		gtk_style_context_add_class (_tmp9_, "small-bookmarks-rows");
	}
	_tmp10_ = self->priv->bookmarks_controller;
	bookmarks_controller_update_rows_size_button_icon (_tmp10_, _data2_->has_small_bookmarks_rows_class);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __bookmarks_schema_path___lambda103__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
_bookmarks___lambda104_ (Bookmarks* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkSwitch* _tmp2_;
		_tmp2_ = self->priv->bookmarked_switch;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	}
}

static void
__bookmarks___lambda104__gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	_bookmarks___lambda104_ ((Bookmarks*) self);
}

static GObject *
bookmarks_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Bookmarks * self;
	GtkLabel* _tmp0_;
	parent_class = G_OBJECT_CLASS (bookmarks_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS, Bookmarks);
	_tmp0_ = self->priv->switch_label;
	bookmarks_update_switch_label (VIEW_TYPE_SEARCH, VIEW_TYPE_FOLDER, _tmp0_);
	bookmarks_install_action_entries (self);
	g_signal_connect_object ((GtkButton*) self, "clicked", (GCallback) __bookmarks___lambda104__gtk_button_clicked, self, 0);
	return obj;
}

static void
bookmarks_class_init (BookmarksClass * klass,
                      gpointer klass_data)
{
	bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Bookmarks_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmarks_set_property;
	G_OBJECT_CLASS (klass)->constructor = bookmarks_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmarks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_SCHEMA_PATH_PROPERTY, bookmarks_properties[BOOKMARKS_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/bookmarks.ui");
	bookmarks_signals[BOOKMARKS_UPDATE_BOOKMARKS_ICONS_SIGNAL] = g_signal_new ("update-bookmarks-icons", TYPE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_icon", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_popover", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_mode_stack", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, edit_mode_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_list", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarked_switch", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarked_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_label", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, switch_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_controller", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_controller));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_update_bookmarks_icons", G_CALLBACK(_bookmarks_on_update_bookmarks_icons_bookmarks_list_update_bookmarks_icons));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_bookmarks_changed", G_CALLBACK(_bookmarks_on_bookmarks_changed_bookmarks_list_bookmarks_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_writability_changed", G_CALLBACK(_bookmarks_on_writability_changed_bookmarks_list_writability_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_bookmarks_on_key_press_event_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_selection_changed", G_CALLBACK(_bookmarks_on_selection_changed_overlayed_list_selection_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_edit_mode", G_CALLBACK(_bookmarks_leave_edit_mode_gtk_button_clicked));
}

static void
bookmarks_instance_init (Bookmarks * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = bookmarks_get_instance_private (self);
	_tmp0_ = g_strdup ("/");
	self->priv->current_path = _tmp0_;
	self->priv->current_type = VIEW_TYPE_FOLDER;
	_tmp1_ = g_strdup ("ca.desrt.dconf-editor.Bookmarks");
	self->priv->schema_id = _tmp1_;
	self->priv->actions_init_done = FALSE;
	g_type_ensure (TYPE_BOOKMARKS_LIST);
	g_type_ensure (TYPE_BOOKMARKS_CONTROLLER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
bookmarks_finalize (GObject * obj)
{
	Bookmarks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS, Bookmarks);
	_g_free0 (self->priv->current_path);
	_g_free0 (self->priv->schema_id);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->move_top_action);
	_g_object_unref0 (self->priv->move_up_action);
	_g_object_unref0 (self->priv->move_down_action);
	_g_object_unref0 (self->priv->move_bottom_action);
	_g_object_unref0 (self->priv->trash_bookmark_action);
	_g_object_unref0 (self->priv->edit_mode_state_action);
	G_OBJECT_CLASS (bookmarks_parent_class)->finalize (obj);
}

static GType
bookmarks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bookmarks), 0, (GInstanceInitFunc) bookmarks_instance_init, NULL };
	GType bookmarks_type_id;
	bookmarks_type_id = g_type_register_static (gtk_menu_button_get_type (), "Bookmarks", &g_define_type_info, 0);
	Bookmarks_private_offset = g_type_add_instance_private (bookmarks_type_id, sizeof (BookmarksPrivate));
	return bookmarks_type_id;
}

GType
bookmarks_get_type (void)
{
	static volatile gsize bookmarks_type_id__once = 0;
	if (g_once_init_enter (&bookmarks_type_id__once)) {
		GType bookmarks_type_id;
		bookmarks_type_id = bookmarks_get_type_once ();
		g_once_init_leave (&bookmarks_type_id__once, bookmarks_type_id);
	}
	return bookmarks_type_id__once;
}

static void
_vala_bookmarks_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Bookmarks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS, Bookmarks);
	switch (property_id) {
		case BOOKMARKS_SCHEMA_PATH_PROPERTY:
		bookmarks_set_schema_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

