// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/client-management.xml

#include "qwayland-server-com-deepin-client-management.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int com_deepin_client_management::deferred_destroy_global_func(void *data) {
        auto object = static_cast<com_deepin_client_management *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->com_deepin_client_management_destroy_global();
        return 0;
    }

    com_deepin_client_management::com_deepin_client_management(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    com_deepin_client_management::com_deepin_client_management(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    com_deepin_client_management::com_deepin_client_management(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    com_deepin_client_management::com_deepin_client_management()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    com_deepin_client_management::~com_deepin_client_management()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->com_deepin_client_management_object = nullptr;

        if (m_resource)
            m_resource->com_deepin_client_management_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void com_deepin_client_management::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void com_deepin_client_management::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    com_deepin_client_management::Resource *com_deepin_client_management::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    com_deepin_client_management::Resource *com_deepin_client_management::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void com_deepin_client_management::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::com_deepin_client_management_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = com_deepin_client_management::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *com_deepin_client_management::interface()
    {
        return &::com_deepin_client_management_interface;
    }

    com_deepin_client_management::Resource *com_deepin_client_management::com_deepin_client_management_allocate()
    {
        return new Resource;
    }

    void com_deepin_client_management::com_deepin_client_management_destroy_global()
    {
    }

    void com_deepin_client_management::com_deepin_client_management_bind_resource(Resource *)
    {
    }

    void com_deepin_client_management::com_deepin_client_management_destroy_resource(Resource *)
    {
    }

    void com_deepin_client_management::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        com_deepin_client_management *that = static_cast<com_deepin_client_management *>(data);
        that->add(client, id, version);
    }

    void com_deepin_client_management::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        com_deepin_client_management *that = static_cast<com_deepin_client_management::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void com_deepin_client_management::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        com_deepin_client_management *that = resource->com_deepin_client_management_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->com_deepin_client_management_destroy_resource(resource);

            that = resource->com_deepin_client_management_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void com_deepin_client_management::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    com_deepin_client_management::Resource *com_deepin_client_management::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::com_deepin_client_management_interface, version, id);
        return bind(handle);
    }

    com_deepin_client_management::Resource *com_deepin_client_management::bind(struct ::wl_resource *handle)
    {
        Resource *resource = com_deepin_client_management_allocate();
        resource->com_deepin_client_management_object = this;

        wl_resource_set_implementation(handle, &m_com_deepin_client_management_interface, resource, destroy_func);
        resource->handle = handle;
        com_deepin_client_management_bind_resource(resource);
        return resource;
    }
    com_deepin_client_management::Resource *com_deepin_client_management::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::com_deepin_client_management_interface, &m_com_deepin_client_management_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::com_deepin_client_management_interface com_deepin_client_management::m_com_deepin_client_management_interface = {
        com_deepin_client_management::handle_get_window_states,
        com_deepin_client_management::handle_capture_window_image,
        com_deepin_client_management::handle_split_window
    };

    void com_deepin_client_management::com_deepin_client_management_get_window_states(Resource *)
    {
    }

    void com_deepin_client_management::com_deepin_client_management_capture_window_image(Resource *, int32_t , struct ::wl_resource *)
    {
    }

    void com_deepin_client_management::com_deepin_client_management_split_window(Resource *, const QString &, int32_t )
    {
    }


    void com_deepin_client_management::handle_get_window_states(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->com_deepin_client_management_object)) {
            return;
        }
        static_cast<com_deepin_client_management *>(r->com_deepin_client_management_object)->com_deepin_client_management_get_window_states(
            r);
    }

    void com_deepin_client_management::handle_capture_window_image(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t window_id,
        struct ::wl_resource *buffer)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->com_deepin_client_management_object)) {
            return;
        }
        static_cast<com_deepin_client_management *>(r->com_deepin_client_management_object)->com_deepin_client_management_capture_window_image(
            r,
            window_id,
            buffer);
    }

    void com_deepin_client_management::handle_split_window(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *uuid,
        int32_t split_type)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->com_deepin_client_management_object)) {
            return;
        }
        static_cast<com_deepin_client_management *>(r->com_deepin_client_management_object)->com_deepin_client_management_split_window(
            r,
            QString::fromUtf8(uuid),
            split_type);
    }

    void com_deepin_client_management::send_window_states(uint32_t count, const QByteArray &states)
    {
        Q_ASSERT_X(m_resource, "com_deepin_client_management::window_states", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call com_deepin_client_management::window_states as it's not initialised");
            return;
        }
        send_window_states(
            m_resource->handle,
            count,
            states);
    }

    void com_deepin_client_management::send_window_states(struct ::wl_resource *resource, uint32_t count, const QByteArray &states)
    {
        struct wl_array states_data;
        states_data.size = states.size();
        states_data.data = static_cast<void *>(const_cast<char *>(states.constData()));
        states_data.alloc = 0;

        com_deepin_client_management_send_window_states(
            resource,
            count,
            &states_data);
    }


    void com_deepin_client_management::send_capture_callback(int32_t window_id, int32_t succeed, struct ::wl_resource *buffer)
    {
        Q_ASSERT_X(m_resource, "com_deepin_client_management::capture_callback", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call com_deepin_client_management::capture_callback as it's not initialised");
            return;
        }
        send_capture_callback(
            m_resource->handle,
            window_id,
            succeed,
            buffer);
    }

    void com_deepin_client_management::send_capture_callback(struct ::wl_resource *resource, int32_t window_id, int32_t succeed, struct ::wl_resource *buffer)
    {
        com_deepin_client_management_send_capture_callback(
            resource,
            window_id,
            succeed,
            buffer);
    }


    void com_deepin_client_management::send_split_change(const QString &uuid, uint32_t splitable)
    {
        Q_ASSERT_X(m_resource, "com_deepin_client_management::split_change", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call com_deepin_client_management::split_change as it's not initialised");
            return;
        }
        send_split_change(
            m_resource->handle,
            uuid,
            splitable);
    }

    void com_deepin_client_management::send_split_change(struct ::wl_resource *resource, const QString &uuid, uint32_t splitable)
    {
        com_deepin_client_management_send_split_change(
            resource,
            uuid.toUtf8().constData(),
            splitable);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
