// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/plasma-window-management.xml

#include "qwayland-server-plasma-window-management.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int org_kde_plasma_window_management::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_window_management *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_window_management_destroy_global();
        return 0;
    }

    org_kde_plasma_window_management::org_kde_plasma_window_management(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_window_management::org_kde_plasma_window_management(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_window_management::org_kde_plasma_window_management(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_window_management::org_kde_plasma_window_management()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_window_management::~org_kde_plasma_window_management()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->org_kde_plasma_window_management_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_window_management_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_window_management::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_window_management::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_window_management::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_window_management_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_window_management::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_window_management::interface()
    {
        return &::org_kde_plasma_window_management_interface;
    }

    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::org_kde_plasma_window_management_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_window_management::org_kde_plasma_window_management_destroy_global()
    {
    }

    void org_kde_plasma_window_management::org_kde_plasma_window_management_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_window_management::org_kde_plasma_window_management_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_window_management::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_window_management *that = static_cast<org_kde_plasma_window_management *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_window_management::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_window_management *that = static_cast<org_kde_plasma_window_management::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_window_management::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_window_management *that = resource->org_kde_plasma_window_management_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_window_management_destroy_resource(resource);

            that = resource->org_kde_plasma_window_management_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_window_management::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_window_management_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_window_management_allocate();
        resource->org_kde_plasma_window_management_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_window_management_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_window_management_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_window_management::Resource *org_kde_plasma_window_management::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_window_management_interface, &m_org_kde_plasma_window_management_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_window_management_interface org_kde_plasma_window_management::m_org_kde_plasma_window_management_interface = {
        org_kde_plasma_window_management::handle_show_desktop,
        org_kde_plasma_window_management::handle_get_window,
        org_kde_plasma_window_management::handle_get_window_by_uuid
    };

    void org_kde_plasma_window_management::org_kde_plasma_window_management_show_desktop(Resource *, uint32_t )
    {
    }

    void org_kde_plasma_window_management::org_kde_plasma_window_management_get_window(Resource *, uint32_t, uint32_t )
    {
    }

    void org_kde_plasma_window_management::org_kde_plasma_window_management_get_window_by_uuid(Resource *, uint32_t, const QString &)
    {
    }


    void org_kde_plasma_window_management::handle_show_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t state)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_window_management *>(r->org_kde_plasma_window_management_object)->org_kde_plasma_window_management_show_desktop(
            r,
            state);
    }

    void org_kde_plasma_window_management::handle_get_window(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        uint32_t internal_window_id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_window_management *>(r->org_kde_plasma_window_management_object)->org_kde_plasma_window_management_get_window(
            r,
            id,
            internal_window_id);
    }

    void org_kde_plasma_window_management::handle_get_window_by_uuid(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        const char *internal_window_uuid)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_window_management *>(r->org_kde_plasma_window_management_object)->org_kde_plasma_window_management_get_window_by_uuid(
            r,
            id,
            QString::fromUtf8(internal_window_uuid));
    }

    void org_kde_plasma_window_management::send_show_desktop_changed(uint32_t state)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window_management::show_desktop_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window_management::show_desktop_changed as it's not initialised");
            return;
        }
        send_show_desktop_changed(
            m_resource->handle,
            state);
    }

    void org_kde_plasma_window_management::send_show_desktop_changed(struct ::wl_resource *resource, uint32_t state)
    {
        org_kde_plasma_window_management_send_show_desktop_changed(
            resource,
            state);
    }


    void org_kde_plasma_window_management::send_window(uint32_t id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window_management::window", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window_management::window as it's not initialised");
            return;
        }
        send_window(
            m_resource->handle,
            id);
    }

    void org_kde_plasma_window_management::send_window(struct ::wl_resource *resource, uint32_t id)
    {
        org_kde_plasma_window_management_send_window(
            resource,
            id);
    }


    void org_kde_plasma_window_management::send_stacking_order_changed(const QByteArray &ids)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window_management::stacking_order_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window_management::stacking_order_changed as it's not initialised");
            return;
        }
        send_stacking_order_changed(
            m_resource->handle,
            ids);
    }

    void org_kde_plasma_window_management::send_stacking_order_changed(struct ::wl_resource *resource, const QByteArray &ids)
    {
        struct wl_array ids_data;
        ids_data.size = ids.size();
        ids_data.data = static_cast<void *>(const_cast<char *>(ids.constData()));
        ids_data.alloc = 0;

        org_kde_plasma_window_management_send_stacking_order_changed(
            resource,
            &ids_data);
    }


    void org_kde_plasma_window_management::send_stacking_order_uuid_changed(const QString &uuids)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window_management::stacking_order_uuid_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window_management::stacking_order_uuid_changed as it's not initialised");
            return;
        }
        send_stacking_order_uuid_changed(
            m_resource->handle,
            uuids);
    }

    void org_kde_plasma_window_management::send_stacking_order_uuid_changed(struct ::wl_resource *resource, const QString &uuids)
    {
        org_kde_plasma_window_management_send_stacking_order_uuid_changed(
            resource,
            uuids.toUtf8().constData());
    }


    void org_kde_plasma_window_management::send_window_with_uuid(uint32_t id, const QString &uuid)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window_management::window_with_uuid", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window_management::window_with_uuid as it's not initialised");
            return;
        }
        send_window_with_uuid(
            m_resource->handle,
            id,
            uuid);
    }

    void org_kde_plasma_window_management::send_window_with_uuid(struct ::wl_resource *resource, uint32_t id, const QString &uuid)
    {
        org_kde_plasma_window_management_send_window_with_uuid(
            resource,
            id,
            uuid.toUtf8().constData());
    }



    int org_kde_plasma_window::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_window *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_window_destroy_global();
        return 0;
    }

    org_kde_plasma_window::org_kde_plasma_window(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_window::org_kde_plasma_window(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_window::org_kde_plasma_window(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_window::org_kde_plasma_window()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_window::~org_kde_plasma_window()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->org_kde_plasma_window_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_window_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_window::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_window::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_window::Resource *org_kde_plasma_window::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_window::Resource *org_kde_plasma_window::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_window::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_window_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_window::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_window::interface()
    {
        return &::org_kde_plasma_window_interface;
    }

    org_kde_plasma_window::Resource *org_kde_plasma_window::org_kde_plasma_window_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_window::org_kde_plasma_window_destroy_global()
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_window::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_window *that = static_cast<org_kde_plasma_window *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_window::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_window *that = static_cast<org_kde_plasma_window::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_window::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_window *that = resource->org_kde_plasma_window_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_window_destroy_resource(resource);

            that = resource->org_kde_plasma_window_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_window::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_window::Resource *org_kde_plasma_window::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_window_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_window::Resource *org_kde_plasma_window::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_window_allocate();
        resource->org_kde_plasma_window_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_window_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_window_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_window::Resource *org_kde_plasma_window::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_window_interface, &m_org_kde_plasma_window_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_window_interface org_kde_plasma_window::m_org_kde_plasma_window_interface = {
        org_kde_plasma_window::handle_set_state,
        org_kde_plasma_window::handle_set_virtual_desktop,
        org_kde_plasma_window::handle_set_minimized_geometry,
        org_kde_plasma_window::handle_unset_minimized_geometry,
        org_kde_plasma_window::handle_close,
        org_kde_plasma_window::handle_request_move,
        org_kde_plasma_window::handle_request_resize,
        org_kde_plasma_window::handle_destroy,
        org_kde_plasma_window::handle_get_icon,
        org_kde_plasma_window::handle_request_enter_virtual_desktop,
        org_kde_plasma_window::handle_request_enter_new_virtual_desktop,
        org_kde_plasma_window::handle_request_leave_virtual_desktop,
        org_kde_plasma_window::handle_request_enter_activity,
        org_kde_plasma_window::handle_request_leave_activity,
        org_kde_plasma_window::handle_send_to_output
    };

    void org_kde_plasma_window::org_kde_plasma_window_set_state(Resource *, uint32_t , uint32_t )
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_set_virtual_desktop(Resource *, uint32_t )
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_set_minimized_geometry(Resource *, struct ::wl_resource *, uint32_t , uint32_t , uint32_t , uint32_t )
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_unset_minimized_geometry(Resource *, struct ::wl_resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_close(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_move(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_resize(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_destroy(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_get_icon(Resource *, int32_t )
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_enter_virtual_desktop(Resource *, const QString &)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_enter_new_virtual_desktop(Resource *)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_leave_virtual_desktop(Resource *, const QString &)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_enter_activity(Resource *, const QString &)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_request_leave_activity(Resource *, const QString &)
    {
    }

    void org_kde_plasma_window::org_kde_plasma_window_send_to_output(Resource *, struct ::wl_resource *)
    {
    }


    void org_kde_plasma_window::handle_set_state(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t flags,
        uint32_t state)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_set_state(
            r,
            flags,
            state);
    }

    void org_kde_plasma_window::handle_set_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t number)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_set_virtual_desktop(
            r,
            number);
    }

    void org_kde_plasma_window::handle_set_minimized_geometry(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *panel,
        uint32_t x,
        uint32_t y,
        uint32_t width,
        uint32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_set_minimized_geometry(
            r,
            panel,
            x,
            y,
            width,
            height);
    }

    void org_kde_plasma_window::handle_unset_minimized_geometry(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *panel)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_unset_minimized_geometry(
            r,
            panel);
    }

    void org_kde_plasma_window::handle_close(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_close(
            r);
    }

    void org_kde_plasma_window::handle_request_move(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_move(
            r);
    }

    void org_kde_plasma_window::handle_request_resize(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_resize(
            r);
    }

    void org_kde_plasma_window::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_destroy(
            r);
    }

    void org_kde_plasma_window::handle_get_icon(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t fd)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
        close(fd);
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_get_icon(
            r,
            fd);
    }

    void org_kde_plasma_window::handle_request_enter_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_enter_virtual_desktop(
            r,
            QString::fromUtf8(id));
    }

    void org_kde_plasma_window::handle_request_enter_new_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_enter_new_virtual_desktop(
            r);
    }

    void org_kde_plasma_window::handle_request_leave_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_leave_virtual_desktop(
            r,
            QString::fromUtf8(id));
    }

    void org_kde_plasma_window::handle_request_enter_activity(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_enter_activity(
            r,
            QString::fromUtf8(id));
    }

    void org_kde_plasma_window::handle_request_leave_activity(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_request_leave_activity(
            r,
            QString::fromUtf8(id));
    }

    void org_kde_plasma_window::handle_send_to_output(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *output)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_window_object)) {
            return;
        }
        static_cast<org_kde_plasma_window *>(r->org_kde_plasma_window_object)->org_kde_plasma_window_send_to_output(
            r,
            output);
    }

    void org_kde_plasma_window::send_title_changed(const QString &title)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::title_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::title_changed as it's not initialised");
            return;
        }
        send_title_changed(
            m_resource->handle,
            title);
    }

    void org_kde_plasma_window::send_title_changed(struct ::wl_resource *resource, const QString &title)
    {
        org_kde_plasma_window_send_title_changed(
            resource,
            title.toUtf8().constData());
    }


    void org_kde_plasma_window::send_app_id_changed(const QString &app_id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::app_id_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::app_id_changed as it's not initialised");
            return;
        }
        send_app_id_changed(
            m_resource->handle,
            app_id);
    }

    void org_kde_plasma_window::send_app_id_changed(struct ::wl_resource *resource, const QString &app_id)
    {
        org_kde_plasma_window_send_app_id_changed(
            resource,
            app_id.toUtf8().constData());
    }


    void org_kde_plasma_window::send_state_changed(uint32_t flags)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::state_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::state_changed as it's not initialised");
            return;
        }
        send_state_changed(
            m_resource->handle,
            flags);
    }

    void org_kde_plasma_window::send_state_changed(struct ::wl_resource *resource, uint32_t flags)
    {
        org_kde_plasma_window_send_state_changed(
            resource,
            flags);
    }


    void org_kde_plasma_window::send_virtual_desktop_changed(int32_t number)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::virtual_desktop_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::virtual_desktop_changed as it's not initialised");
            return;
        }
        send_virtual_desktop_changed(
            m_resource->handle,
            number);
    }

    void org_kde_plasma_window::send_virtual_desktop_changed(struct ::wl_resource *resource, int32_t number)
    {
        org_kde_plasma_window_send_virtual_desktop_changed(
            resource,
            number);
    }


    void org_kde_plasma_window::send_themed_icon_name_changed(const QString &name)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::themed_icon_name_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::themed_icon_name_changed as it's not initialised");
            return;
        }
        send_themed_icon_name_changed(
            m_resource->handle,
            name);
    }

    void org_kde_plasma_window::send_themed_icon_name_changed(struct ::wl_resource *resource, const QString &name)
    {
        org_kde_plasma_window_send_themed_icon_name_changed(
            resource,
            name.toUtf8().constData());
    }


    void org_kde_plasma_window::send_unmapped()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::unmapped", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::unmapped as it's not initialised");
            return;
        }
        send_unmapped(
            m_resource->handle);
    }

    void org_kde_plasma_window::send_unmapped(struct ::wl_resource *resource)
    {
        org_kde_plasma_window_send_unmapped(
            resource);
    }


    void org_kde_plasma_window::send_initial_state()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::initial_state", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::initial_state as it's not initialised");
            return;
        }
        send_initial_state(
            m_resource->handle);
    }

    void org_kde_plasma_window::send_initial_state(struct ::wl_resource *resource)
    {
        org_kde_plasma_window_send_initial_state(
            resource);
    }


    void org_kde_plasma_window::send_parent_window(struct ::wl_resource *parent)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::parent_window", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::parent_window as it's not initialised");
            return;
        }
        send_parent_window(
            m_resource->handle,
            parent);
    }

    void org_kde_plasma_window::send_parent_window(struct ::wl_resource *resource, struct ::wl_resource *parent)
    {
        org_kde_plasma_window_send_parent_window(
            resource,
            parent);
    }


    void org_kde_plasma_window::send_geometry(int32_t x, int32_t y, uint32_t width, uint32_t height)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::geometry", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::geometry as it's not initialised");
            return;
        }
        send_geometry(
            m_resource->handle,
            x,
            y,
            width,
            height);
    }

    void org_kde_plasma_window::send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, uint32_t width, uint32_t height)
    {
        org_kde_plasma_window_send_geometry(
            resource,
            x,
            y,
            width,
            height);
    }


    void org_kde_plasma_window::send_icon_changed()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::icon_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::icon_changed as it's not initialised");
            return;
        }
        send_icon_changed(
            m_resource->handle);
    }

    void org_kde_plasma_window::send_icon_changed(struct ::wl_resource *resource)
    {
        org_kde_plasma_window_send_icon_changed(
            resource);
    }


    void org_kde_plasma_window::send_pid_changed(uint32_t pid)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::pid_changed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::pid_changed as it's not initialised");
            return;
        }
        send_pid_changed(
            m_resource->handle,
            pid);
    }

    void org_kde_plasma_window::send_pid_changed(struct ::wl_resource *resource, uint32_t pid)
    {
        org_kde_plasma_window_send_pid_changed(
            resource,
            pid);
    }


    void org_kde_plasma_window::send_virtual_desktop_entered(const QString &id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::virtual_desktop_entered", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::virtual_desktop_entered as it's not initialised");
            return;
        }
        send_virtual_desktop_entered(
            m_resource->handle,
            id);
    }

    void org_kde_plasma_window::send_virtual_desktop_entered(struct ::wl_resource *resource, const QString &id)
    {
        org_kde_plasma_window_send_virtual_desktop_entered(
            resource,
            id.toUtf8().constData());
    }


    void org_kde_plasma_window::send_virtual_desktop_left(const QString &is)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::virtual_desktop_left", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::virtual_desktop_left as it's not initialised");
            return;
        }
        send_virtual_desktop_left(
            m_resource->handle,
            is);
    }

    void org_kde_plasma_window::send_virtual_desktop_left(struct ::wl_resource *resource, const QString &is)
    {
        org_kde_plasma_window_send_virtual_desktop_left(
            resource,
            is.toUtf8().constData());
    }


    void org_kde_plasma_window::send_application_menu(const QString &service_name, const QString &object_path)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::application_menu", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::application_menu as it's not initialised");
            return;
        }
        send_application_menu(
            m_resource->handle,
            service_name,
            object_path);
    }

    void org_kde_plasma_window::send_application_menu(struct ::wl_resource *resource, const QString &service_name, const QString &object_path)
    {
        org_kde_plasma_window_send_application_menu(
            resource,
            service_name.toUtf8().constData(),
            object_path.toUtf8().constData());
    }


    void org_kde_plasma_window::send_activity_entered(const QString &id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::activity_entered", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::activity_entered as it's not initialised");
            return;
        }
        send_activity_entered(
            m_resource->handle,
            id);
    }

    void org_kde_plasma_window::send_activity_entered(struct ::wl_resource *resource, const QString &id)
    {
        org_kde_plasma_window_send_activity_entered(
            resource,
            id.toUtf8().constData());
    }


    void org_kde_plasma_window::send_activity_left(const QString &id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::activity_left", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::activity_left as it's not initialised");
            return;
        }
        send_activity_left(
            m_resource->handle,
            id);
    }

    void org_kde_plasma_window::send_activity_left(struct ::wl_resource *resource, const QString &id)
    {
        org_kde_plasma_window_send_activity_left(
            resource,
            id.toUtf8().constData());
    }


    void org_kde_plasma_window::send_window_id(uint32_t winid)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_window::window_id", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_window::window_id as it's not initialised");
            return;
        }
        send_window_id(
            m_resource->handle,
            winid);
    }

    void org_kde_plasma_window::send_window_id(struct ::wl_resource *resource, uint32_t winid)
    {
        org_kde_plasma_window_send_window_id(
            resource,
            winid);
    }



    int org_kde_plasma_activation_feedback::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_activation_feedback *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_activation_feedback_destroy_global();
        return 0;
    }

    org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_activation_feedback::~org_kde_plasma_activation_feedback()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->org_kde_plasma_activation_feedback_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_activation_feedback_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_activation_feedback::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_activation_feedback::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_activation_feedback::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_activation_feedback_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_activation_feedback::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_activation_feedback::interface()
    {
        return &::org_kde_plasma_activation_feedback_interface;
    }

    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback_destroy_global()
    {
    }

    void org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_activation_feedback::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_activation_feedback *that = static_cast<org_kde_plasma_activation_feedback *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_activation_feedback::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_activation_feedback *that = static_cast<org_kde_plasma_activation_feedback::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_activation_feedback::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_activation_feedback *that = resource->org_kde_plasma_activation_feedback_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_activation_feedback_destroy_resource(resource);

            that = resource->org_kde_plasma_activation_feedback_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_activation_feedback::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_activation_feedback_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_activation_feedback_allocate();
        resource->org_kde_plasma_activation_feedback_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_activation_feedback_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_activation_feedback_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_activation_feedback::Resource *org_kde_plasma_activation_feedback::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_activation_feedback_interface, &m_org_kde_plasma_activation_feedback_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_activation_feedback_interface org_kde_plasma_activation_feedback::m_org_kde_plasma_activation_feedback_interface = {
        org_kde_plasma_activation_feedback::handle_destroy
    };

    void org_kde_plasma_activation_feedback::org_kde_plasma_activation_feedback_destroy(Resource *)
    {
    }


    void org_kde_plasma_activation_feedback::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_activation_feedback_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<org_kde_plasma_activation_feedback *>(r->org_kde_plasma_activation_feedback_object)->org_kde_plasma_activation_feedback_destroy(
            r);
    }

    void org_kde_plasma_activation_feedback::send_activation(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_activation_feedback::activation", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_activation_feedback::activation as it's not initialised");
            return;
        }
        send_activation(
            m_resource->handle,
            id);
    }

    void org_kde_plasma_activation_feedback::send_activation(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        org_kde_plasma_activation_feedback_send_activation(
            resource,
            id);
    }



    int org_kde_plasma_activation::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_activation *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_activation_destroy_global();
        return 0;
    }

    org_kde_plasma_activation::org_kde_plasma_activation(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_activation::org_kde_plasma_activation(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_activation::org_kde_plasma_activation(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_activation::org_kde_plasma_activation()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_activation::~org_kde_plasma_activation()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->org_kde_plasma_activation_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_activation_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_activation::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_activation::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_activation::Resource *org_kde_plasma_activation::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_activation::Resource *org_kde_plasma_activation::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_activation::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_activation_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_activation::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_activation::interface()
    {
        return &::org_kde_plasma_activation_interface;
    }

    org_kde_plasma_activation::Resource *org_kde_plasma_activation::org_kde_plasma_activation_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_activation::org_kde_plasma_activation_destroy_global()
    {
    }

    void org_kde_plasma_activation::org_kde_plasma_activation_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_activation::org_kde_plasma_activation_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_activation::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_activation *that = static_cast<org_kde_plasma_activation *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_activation::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_activation *that = static_cast<org_kde_plasma_activation::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_activation::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_activation *that = resource->org_kde_plasma_activation_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_activation_destroy_resource(resource);

            that = resource->org_kde_plasma_activation_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_activation::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_activation::Resource *org_kde_plasma_activation::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_activation_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_activation::Resource *org_kde_plasma_activation::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_activation_allocate();
        resource->org_kde_plasma_activation_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_activation_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_activation_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_activation::Resource *org_kde_plasma_activation::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_activation_interface, &m_org_kde_plasma_activation_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_activation_interface org_kde_plasma_activation::m_org_kde_plasma_activation_interface = {
        org_kde_plasma_activation::handle_destroy
    };

    void org_kde_plasma_activation::org_kde_plasma_activation_destroy(Resource *)
    {
    }


    void org_kde_plasma_activation::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->org_kde_plasma_activation_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<org_kde_plasma_activation *>(r->org_kde_plasma_activation_object)->org_kde_plasma_activation_destroy(
            r);
    }

    void org_kde_plasma_activation::send_app_id(const QString &app_id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_activation::app_id", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_activation::app_id as it's not initialised");
            return;
        }
        send_app_id(
            m_resource->handle,
            app_id);
    }

    void org_kde_plasma_activation::send_app_id(struct ::wl_resource *resource, const QString &app_id)
    {
        org_kde_plasma_activation_send_app_id(
            resource,
            app_id.toUtf8().constData());
    }


    void org_kde_plasma_activation::send_finished()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_activation::finished", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_activation::finished as it's not initialised");
            return;
        }
        send_finished(
            m_resource->handle);
    }

    void org_kde_plasma_activation::send_finished(struct ::wl_resource *resource)
    {
        org_kde_plasma_activation_send_finished(
            resource);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
