/* Generated by wayland-scanner 1.23.0 */

#ifndef KDE_OUTPUT_MANAGEMENT_V2_SERVER_PROTOCOL_H
#define KDE_OUTPUT_MANAGEMENT_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_output_management_v2 The kde_output_management_v2 protocol
 * @section page_ifaces_kde_output_management_v2 Interfaces
 * - @subpage page_iface_kde_output_management_v2 - configuration of server outputs through clients
 * - @subpage page_iface_kde_output_configuration_v2 - configure single output devices
 * @section page_copyright_kde_output_management_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 * SPDX-FileCopyrightText: 2021 Méven Car <meven.car@enioka.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_configuration_v2;
struct kde_output_device_mode_v2;
struct kde_output_device_v2;
struct kde_output_management_v2;

#ifndef KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
#define KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
/**
 * @page page_iface_kde_output_management_v2 kde_output_management_v2
 * @section page_iface_kde_output_management_v2_desc Description
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * @section page_iface_kde_output_management_v2_api API
 * See @ref iface_kde_output_management_v2.
 */
/**
 * @defgroup iface_kde_output_management_v2 The kde_output_management_v2 interface
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 */
extern const struct wl_interface kde_output_management_v2_interface;
#endif
#ifndef KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
#define KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
/**
 * @page page_iface_kde_output_configuration_v2 kde_output_configuration_v2
 * @section page_iface_kde_output_configuration_v2_desc Description
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 * @section page_iface_kde_output_configuration_v2_api API
 * See @ref iface_kde_output_configuration_v2.
 */
/**
 * @defgroup iface_kde_output_configuration_v2 The kde_output_configuration_v2 interface
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 */
extern const struct wl_interface kde_output_configuration_v2_interface;
#endif

/**
 * @ingroup iface_kde_output_management_v2
 * @struct kde_output_management_v2_interface
 */
struct kde_output_management_v2_interface {
	/**
	 * provide outputconfiguration object for configuring outputs
	 *
	 * Request an outputconfiguration object through which the client
	 * can configure output devices.
	 */
	void (*create_configuration)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id);
};


/**
 * @ingroup iface_kde_output_management_v2
 */
#define KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION_SINCE_VERSION 1

#ifndef KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum kde_output_configuration_v2_vrr_policy {
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_NEVER = 0,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ALWAYS = 1,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_AUTOMATIC = 2,
};
/**
 * @ingroup iface_kde_output_configuration_v2
 * Validate a kde_output_configuration_v2 vrr_policy value.
 *
 * @return true on success, false on error.
 * @ref kde_output_configuration_v2_vrr_policy
 */
static inline bool
kde_output_configuration_v2_vrr_policy_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_NEVER:
		return version >= 1;
	case KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ALWAYS:
		return version >= 1;
	case KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_AUTOMATIC:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes RGB range policy
 *
 * Whether this output should use full or limited rgb.
 */
enum kde_output_configuration_v2_rgb_range {
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_AUTOMATIC = 0,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_FULL = 1,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_LIMITED = 2,
};
/**
 * @ingroup iface_kde_output_configuration_v2
 * Validate a kde_output_configuration_v2 rgb_range value.
 *
 * @return true on success, false on error.
 * @ref kde_output_configuration_v2_rgb_range
 */
static inline bool
kde_output_configuration_v2_rgb_range_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_AUTOMATIC:
		return version >= 1;
	case KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_FULL:
		return version >= 1;
	case KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_LIMITED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM */

/**
 * @ingroup iface_kde_output_configuration_v2
 * @struct kde_output_configuration_v2_interface
 */
struct kde_output_configuration_v2_interface {
	/**
	 * enable or disable an output
	 *
	 * Mark the output as enabled or disabled.
	 * @param outputdevice outputdevice to be en- or disabled
	 * @param enable 1 to enable or 0 to disable this output
	 */
	void (*enable)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *outputdevice,
		       int32_t enable);
	/**
	 * switch output-device to mode
	 *
	 * Sets the mode for a given output.
	 * @param outputdevice outputdevice this mode change applies to
	 * @param mode the mode to apply
	 */
	void (*mode)(struct wl_client *client,
		     struct wl_resource *resource,
		     struct wl_resource *outputdevice,
		     struct wl_resource *mode);
	/**
	 * transform output-device
	 *
	 * Sets the transformation for a given output.
	 * @param outputdevice outputdevice this transformation change applies to
	 * @param transform transform enum
	 */
	void (*transform)(struct wl_client *client,
			  struct wl_resource *resource,
			  struct wl_resource *outputdevice,
			  int32_t transform);
	/**
	 * position output in global space
	 *
	 * Sets the position for this output device. (x,y) describe the
	 * top-left corner of the output in global space, whereby the
	 * origin (0,0) of the global space has to be aligned with the
	 * top-left corner of the most left and in case this does not
	 * define a single one the top output.
	 *
	 * There may be no gaps or overlaps between outputs, i.e. the
	 * outputs are stacked horizontally, vertically, or both on each
	 * other.
	 * @param outputdevice outputdevice this position applies to
	 * @param x position on the x-axis
	 * @param y position on the y-axis
	 */
	void (*position)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *outputdevice,
			 int32_t x,
			 int32_t y);
	/**
	 * set scaling factor of this output
	 *
	 * Sets the scaling factor for this output device.
	 * @param outputdevice outputdevice this scale change applies to
	 * @param scale scaling factor
	 */
	void (*scale)(struct wl_client *client,
		      struct wl_resource *resource,
		      struct wl_resource *outputdevice,
		      wl_fixed_t scale);
	/**
	 * apply configuration changes to all output devices
	 *
	 * Asks the server to apply property changes requested through
	 * this outputconfiguration object to all outputs on the server
	 * side.
	 */
	void (*apply)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * release the outputconfiguration object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set overscan value
	 *
	 * Set the overscan value of this output device with a value in
	 * percent.
	 * @param outputdevice outputdevice overscan applies to
	 * @param overscan overscan value
	 */
	void (*overscan)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *outputdevice,
			 uint32_t overscan);
	/**
	 * set the VRR policy
	 *
	 * Set what policy the compositor should employ regarding its use
	 * of variable refresh rate.
	 * @param outputdevice outputdevice this VRR policy applies to
	 * @param policy the vrr policy to apply
	 */
	void (*set_vrr_policy)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *outputdevice,
			       uint32_t policy);
	/**
	 * RGB range
	 *
	 * Whether full or limited color range should be used
	 * @param outputdevice outputdevice the rgb range applies to
	 */
	void (*set_rgb_range)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *outputdevice,
			      uint32_t rgb_range);
	/**
	 * Select which primary output to use
	 *
	 * 
	 * @since 2
	 */
	void (*set_primary_output)(struct wl_client *client,
				   struct wl_resource *resource,
				   struct wl_resource *output);
	/**
	 * switch outputdevice brightness
	 *
	 * Sets the just a test.
	 * @param outputdevice outputdevice this brightness change applies to
	 * @param brightness aspired brightness's number
	 */
	void (*brightness)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *outputdevice,
			   int32_t brightness);
};

#define KDE_OUTPUT_CONFIGURATION_V2_APPLIED 0
#define KDE_OUTPUT_CONFIGURATION_V2_FAILED 1

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLIED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT_SINCE_VERSION 2
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_BRIGHTNESS_SINCE_VERSION 1

/**
 * @ingroup iface_kde_output_configuration_v2
 * Sends an applied event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_configuration_v2_send_applied(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_CONFIGURATION_V2_APPLIED);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_configuration_v2_send_failed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_CONFIGURATION_V2_FAILED);
}

#ifdef  __cplusplus
}
#endif

#endif
