// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the resource scans from newest to oldest. By default it will return up to
// 10 resource scans.
func (c *Client) ListResourceScans(ctx context.Context, params *ListResourceScansInput, optFns ...func(*Options)) (*ListResourceScansOutput, error) {
	if params == nil {
		params = &ListResourceScansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceScans", params, optFns, c.addOperationListResourceScansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceScansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceScansInput struct {

	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the next
	// set of results. The default value is 10. The maximum value is 100.
	MaxResults *int32

	// The token for the next set of items to return. (You received this token from a
	// previous call.)
	NextToken *string

	// The scan type that you want to get summary information about. The default is
	// FULL .
	ScanTypeFilter types.ScanType

	noSmithyDocumentSerde
}

type ListResourceScansOutput struct {

	// If the request doesn't return all the remaining results, NextToken is set to a
	// token. To retrieve the next set of results, call ListResourceScans again and
	// use that value for the NextToken parameter. If the request returns all results,
	// NextToken is set to an empty string.
	NextToken *string

	// The list of scans returned.
	ResourceScanSummaries []types.ResourceScanSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceScansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpListResourceScans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpListResourceScans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceScans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceScans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListResourceScansPaginatorOptions is the paginator options for ListResourceScans
type ListResourceScansPaginatorOptions struct {
	// If the number of available results exceeds this maximum, the response includes
	// a NextToken value that you can use for the NextToken parameter to get the next
	// set of results. The default value is 10. The maximum value is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceScansPaginator is a paginator for ListResourceScans
type ListResourceScansPaginator struct {
	options   ListResourceScansPaginatorOptions
	client    ListResourceScansAPIClient
	params    *ListResourceScansInput
	nextToken *string
	firstPage bool
}

// NewListResourceScansPaginator returns a new ListResourceScansPaginator
func NewListResourceScansPaginator(client ListResourceScansAPIClient, params *ListResourceScansInput, optFns ...func(*ListResourceScansPaginatorOptions)) *ListResourceScansPaginator {
	if params == nil {
		params = &ListResourceScansInput{}
	}

	options := ListResourceScansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceScansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceScansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceScans page.
func (p *ListResourceScansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceScansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceScans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceScansAPIClient is a client that implements the ListResourceScans
// operation.
type ListResourceScansAPIClient interface {
	ListResourceScans(context.Context, *ListResourceScansInput, ...func(*Options)) (*ListResourceScansOutput, error)
}

var _ ListResourceScansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceScans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceScans",
	}
}
