// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an import from a data source to CloudWatch Log and creates a managed log
// group as the destination for the imported data. Currently, [CloudTrail Event Data Store]is the only
// supported data source.
//
// The import task must satisfy the following constraints:
//
//   - The specified source must be in an ACTIVE state.
//
//   - The API caller must have permissions to access the data in the provided
//     source and to perform iam:PassRole on the provided import role which has the
//     same permissions, as described below.
//
//   - The provided IAM role must trust the "cloudtrail.amazonaws.com" principal
//     and have the following permissions:
//
//   - cloudtrail:GetEventDataStoreData
//
//   - logs:CreateLogGroup
//
//   - logs:CreateLogStream
//
//   - logs:PutResourcePolicy
//
//   - (If source has an associated AWS KMS Key) kms:Decrypt
//
//   - (If source has an associated AWS KMS Key) kms:GenerateDataKey
//
// Example IAM policy for provided import role:
//
// [ { "Effect": "Allow", "Action": "iam:PassRole", "Resource":
//
//	"arn:aws:iam::123456789012:role/apiCallerCredentials", "Condition": {
//	"StringLike": { "iam:AssociatedResourceARN":
//	"arn:aws:logs:us-east-1:123456789012:log-group:aws/cloudtrail/f1d45bff-d0e3-4868-b5d9-2eb678aa32fb:*"
//	} } }, { "Effect": "Allow", "Action": [ "cloudtrail:GetEventDataStoreData" ],
//	"Resource": [
//	"arn:aws:cloudtrail:us-east-1:123456789012:eventdatastore/f1d45bff-d0e3-4868-b5d9-2eb678aa32fb"
//	] }, { "Effect": "Allow", "Action": [ "logs:CreateImportTask",
//	"logs:CreateLogGroup", "logs:CreateLogStream", "logs:PutResourcePolicy" ],
//	"Resource": [ "arn:aws:logs:us-east-1:123456789012:log-group:/aws/cloudtrail/*"
//	] }, { "Effect": "Allow", "Action": [ "kms:Decrypt", "kms:GenerateDataKey" ],
//	"Resource": [
//	"arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012" ]
//	} ]
//
//	- If the import source has a customer managed key, the
//	"cloudtrail.amazonaws.com" principal needs permissions to perform kms:Decrypt
//	and kms:GenerateDataKey.
//
//	- There can be no more than 3 active imports per account at a given time.
//
//	- The startEventTime must be less than or equal to endEventTime.
//
//	- The data being imported must be within the specified source's retention
//	period.
//
// [CloudTrail Event Data Store]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html
func (c *Client) CreateImportTask(ctx context.Context, params *CreateImportTaskInput, optFns ...func(*Options)) (*CreateImportTaskOutput, error) {
	if params == nil {
		params = &CreateImportTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateImportTask", params, optFns, c.addOperationCreateImportTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateImportTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateImportTaskInput struct {

	// The ARN of the IAM role that grants CloudWatch Logs permission to import from
	// the CloudTrail Lake Event Data Store.
	//
	// This member is required.
	ImportRoleArn *string

	// The ARN of the source to import from.
	//
	// This member is required.
	ImportSourceArn *string

	// Optional filters to constrain the import by CloudTrail event time. Times are
	// specified in Unix timestamp milliseconds. The range of data being imported must
	// be within the specified source's retention period.
	ImportFilter *types.ImportFilter

	noSmithyDocumentSerde
}

type CreateImportTaskOutput struct {

	// The timestamp when the import task was created, expressed as the number of
	// milliseconds after Jan 1, 1970 00:00:00 UTC.
	CreationTime *int64

	// The ARN of the CloudWatch Logs log group created as the destination for the
	// imported events.
	ImportDestinationArn *string

	// A unique identifier for the import task.
	ImportId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateImportTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateImportTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateImportTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateImportTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateImportTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateImportTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateImportTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateImportTask",
	}
}
