#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */
#include "common.h"
const char *const HELP_text[] = {
  "Usage:  enca [-L LANGUAGE] [OPTION]... [FILE]...",
  "        enconv [-L LANGUAGE] [OPTION]... [FILE]...",
  "Detect encoding of text files and convert them if required.",
  "",
  "Operation modes:",
  " -g, --guess             Behave as `enca' (just detect encoding by default)",
  " -c, --auto-convert      Behave as `enconv' (autoconvert by default)",
  "",
  "Output type selectors:",
  " -d, --details           Print failure reason when encoding was not recognized",
  " -e, --enca-name         Print enca's encoding name (passed to converters)",
  " -f, --human-readable    Print full (descriptive) encoding name (default)",
  " -i, --iconv-name        Print how iconv calls the encoding",
  " -m, --mime-name         Print preferred MIME encoding name",
  " -r, --rfc1345-name      Print RFC 1345 (or otherwise canonized) encoding name",
  " -s, --cstocs-name       Print how cstocs calls the encoding",
  " -n, --name=WORD         Print required name (enca-name, human-readable, etc.)",
  " -x, --convert-to=ENC    Convert file to some other encoding ENC",
  "",
  "Guessing parameters:",
  " -L, --language=LANG     Set language of FILEs; obligatory, when cannot be",
  "                         determined from locale settings",
  "",
  "Conversion parameters:",
  " -E, --external-converter-program=PATH",
  "                         Set external converter program name",
  "                         (default: recode)",
  " -C, --try-converters=LIST  Converters to be tried (associative)",
  "                         (default: built-in,librecode)",
  "",
  "General options:",
  " -p, --with-filename     Print the file name for each result",
  " -P, --no-filename       Suppress the prefixing filename on output",
  " -V, --verbose           Increase verbosity level",
  "",
  "Listings:",
  " -G, --license           Print full enca license and terminate",
  " -h, --help              Print this help and terminate",
  " -l, --list=WORD         Print required list (built-in-charsets, converters,",
  "                         charsets, languages, lists, names, surfaces)",
  "                         and terminate",
  " -v, --version           Print version and build information and terminate",
  "",
  "With no FILE, reads standard input and possibly writes converted stream to",
  "standard output.  Exit status is 0 if all files were successfully proceeded,",
  "1 if some were not recognized or converted, 2 in real troubles.",
  "",
  "When called as `enconv' without -x, target encoding it guessed from locales.",
  "",
  "Report bugs to https://github.com/nijel/enca/issues",
  NULL
};
