
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "plugins_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "plugins_plugin_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Plugins_Type = nullptr;
static PyTypeObject *Sbk_Plugins_TypeF(void)
{
    return _Sbk_Plugins_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void PluginsWrapper::pysideInitQtMetaTypes()
{
}

void PluginsWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

PluginsWrapper::PluginsWrapper(::QObject * parent) : Plugins(parent)
{
}

void PluginsWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("Plugins", funcName, gil, pyOverride, event);
}

void PluginsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Plugins", funcName, gil, pyOverride, signal);
}

void PluginsWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("Plugins", funcName, gil, pyOverride, event);
}

void PluginsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Plugins", funcName, gil, pyOverride, signal);
}

bool PluginsWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("Plugins", funcName, gil, pyOverride, event);
}

bool PluginsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("Plugins", funcName, gil, pyOverride, watched, event);
}

void PluginsWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Plugins_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("Plugins", funcName, gil, pyOverride, event);
}

const QMetaObject *PluginsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Plugins::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int PluginsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Plugins::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *PluginsWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< PluginsWrapper *>(this));
    }
    return Plugins::qt_metacast(_clname);
}

PluginsWrapper::~PluginsWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_Plugins_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Plugins_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Plugins >()))
        return -1;

    PluginsWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:Plugins", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Plugins::Plugins(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // Plugins(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Plugins(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // Plugins(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) PluginsWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new PluginsWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< Plugins >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);
    };


    return 1;
}

static PyObject *Sbk_PluginsFunc_addPlugin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Plugins::addPlugin(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addPlugin(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addPlugin", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addPlugin(QString)
            bool cppResult = cppSelf->addPlugin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginsFunc_availablePlugins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availablePlugins()
        QList<Plugins::Plugin> cppResult = cppSelf->availablePlugins();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_Plugins_Plugin_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginsFunc_createSpec(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static Plugins::createSpec(DesktopFile)->PluginSpec
    // 1: static Plugins::createSpec(QJsonObject)->PluginSpec
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], (pyArg)))) {
        overloadId = 1; // createSpec(QJsonObject)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopFile_IDX]), (pyArg)))) {
        overloadId = 0; // createSpec(DesktopFile)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSpec", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // createSpec(const DesktopFile &metaData)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::DesktopFile cppArg0_local;
            ::DesktopFile *cppArg0 = &cppArg0_local;
            if (pythonToCpp.isValue())
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // createSpec(DesktopFile)
                PluginSpec cppResult = ::Plugins::createSpec(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), &cppResult);
            }
            break;
        }
        case 1: // createSpec(const QJsonObject &metaData)
        {
            ::QJsonObject cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createSpec(QJsonObject)
                PluginSpec cppResult = ::Plugins::createSpec(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginsFunc_loadPlugin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Plugins::loadPlugin(Plugins::Plugin*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), (pyArg)))) {
        overloadId = 0; // loadPlugin(Plugins::Plugin*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadPlugin", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Plugins::Plugin *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadPlugin(Plugins::Plugin*)
            bool cppResult = cppSelf->loadPlugin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginsFunc_loadPlugins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadPlugins()
        cppSelf->loadPlugins();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginsFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginsFunc_removePlugin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Plugins::removePlugin(Plugins::Plugin*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), (pyArg)))) {
        overloadId = 0; // removePlugin(Plugins::Plugin*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removePlugin", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Plugins::Plugin *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removePlugin(Plugins::Plugin*)
            cppSelf->removePlugin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginsFunc_shutdown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shutdown()
        cppSelf->shutdown();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginsFunc_unloadPlugin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Plugins::unloadPlugin(Plugins::Plugin*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_Plugin_IDX]), (pyArg)))) {
        overloadId = 0; // unloadPlugin(Plugins::Plugin*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unloadPlugin", errInfo, SbkPyFalkonTypeStructs[SBK_Plugins_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Plugins::Plugin *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unloadPlugin(Plugins::Plugin*)
            cppSelf->unloadPlugin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_Plugins_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Plugins_methods[] = {
    {"addPlugin", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_addPlugin), METH_O, nullptr},
    {"availablePlugins", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_availablePlugins), METH_NOARGS, nullptr},
    {"createSpec", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_createSpec), METH_O|METH_STATIC, nullptr},
    {"loadPlugin", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_loadPlugin), METH_O, nullptr},
    {"loadPlugins", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_loadPlugins), METH_NOARGS, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_loadSettings), METH_NOARGS, nullptr},
    {"removePlugin", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_removePlugin), METH_O, nullptr},
    {"shutdown", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_shutdown), METH_NOARGS, nullptr},
    {"unloadPlugin", reinterpret_cast<PyCFunction>(Sbk_PluginsFunc_unloadPlugin), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_Plugins_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<PluginsWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_Plugins_get_m_loadedPlugins(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PluginInterfacePTR_IDX], &static_cast<PluginsWrapper *>(cppSelf)->m_loadedPlugins);
}
static int Sbk_Plugins_set_m_loadedPlugins(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = static_cast<PluginsWrapper *>(reinterpret_cast< ::Plugins *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("m_loadedPlugins");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PluginInterfacePTR_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("m_loadedPlugins", "QList");
        return -1;
    }

    auto &cppOut_ptr = static_cast<PluginsWrapper *>(cppSelf)->m_loadedPlugins;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Plugins
static PyGetSetDef Sbk_Plugins_getsetlist[] = {
    {"m_loadedPlugins", Sbk_Plugins_get_m_loadedPlugins, Sbk_Plugins_set_m_loadedPlugins, "QList[PyFalkon.PluginInterface]", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Plugins_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Plugins_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Plugins_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Plugins_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Plugins_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Plugins_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Plugins_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_Plugins_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Plugins_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_Plugins_spec = {
    "1:PyFalkon.Plugins",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Plugins_slots
};

} //extern "C"

static void *Sbk_Plugins_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::Plugins *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Plugins_PythonToCpp_Plugins_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Plugins_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Plugins_PythonToCpp_Plugins_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Plugins_TypeF()))
        return Plugins_PythonToCpp_Plugins_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Plugins_PTR_CppToPython_Plugins(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::Plugins *>(const_cast<void *>(cppIn)), Sbk_Plugins_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Plugins_SignatureStrings[] = {
    "PyFalkon.Plugins(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.Plugins.addPlugin(self,id:QString)->bool",
    "PyFalkon.Plugins.availablePlugins(self)->QList[PyFalkon.Plugins.Plugin]",
    "1:PyFalkon.Plugins.createSpec(metaData:PyFalkon.DesktopFile)->PyFalkon.PluginSpec",
    "0:PyFalkon.Plugins.createSpec(metaData:QJsonObject)->PyFalkon.PluginSpec",
    "PyFalkon.Plugins.loadPlugin(self,plugin:PyFalkon.Plugins.Plugin)->bool",
    "PyFalkon.Plugins.loadPlugins(self)",
    "PyFalkon.Plugins.loadSettings(self)",
    "PyFalkon.Plugins.removePlugin(self,plugin:PyFalkon.Plugins.Plugin)",
    "PyFalkon.Plugins.shutdown(self)",
    "PyFalkon.Plugins.unloadPlugin(self,plugin:PyFalkon.Plugins.Plugin)",
    nullptr}; // Sentinel
#else
static constexpr size_t Plugins_SignatureByteSize = 222;
static constexpr uint8_t Plugins_SignatureBytes[222] = {
    0x78, 0xda, 0x95, 0x90, 0x41, 0x8b, 0xc2, 0x40, 0x0c, 0x85, 0xef, 0xfd, 0x25, 0x0a, 0x6e, 0x71,
    0x2f, 0x1e, 0x0a, 0xeb, 0x45, 0xf1, 0x20, 0x0b, 0x76, 0xe8, 0x51, 0xf6, 0x90, 0x76, 0xa2, 0x8e,
    0x8d, 0x93, 0x61, 0x26, 0x55, 0xfc, 0xf7, 0x76, 0xed, 0x82, 0xab, 0x75, 0x40, 0x4f, 0x09, 0xe4,
    0xbd, 0x2f, 0xc9, 0xcb, 0xcf, 0x0b, 0xa0, 0x9a, 0x6d, 0x9a, 0x53, 0xb3, 0x35, 0x36, 0x0c, 0x02,
    0xd2, 0x66, 0xe4, 0xc0, 0xa3, 0x95, 0x2c, 0x3f, 0x17, 0x46, 0xe3, 0x24, 0x55, 0x32, 0x63, 0x8f,
    0xa9, 0x5a, 0x95, 0x7b, 0xac, 0xe4, 0xcb, 0x36, 0x44, 0x4e, 0xfc, 0x30, 0xc9, 0x1f, 0xcc, 0x29,
    0x68, 0xdd, 0xb5, 0x1d, 0xc6, 0xe8, 0x4c, 0x15, 0xe2, 0x8d, 0xdd, 0x0e, 0x3f, 0xa6, 0x25, 0x33,
    0x3d, 0x71, 0x1c, 0xc1, 0x10, 0x94, 0x84, 0xff, 0xf7, 0xb7, 0x6a, 0xf5, 0x6d, 0x82, 0xac, 0x7b,
    0xf2, 0xae, 0xfe, 0x24, 0x9f, 0x59, 0x6f, 0x54, 0x79, 0x04, 0xc1, 0xc2, 0x61, 0x35, 0x38, 0xa0,
    0xc0, 0x1c, 0x04, 0x6e, 0xa2, 0x39, 0x86, 0x5a, 0xd8, 0x2d, 0x0c, 0x61, 0x0b, 0x7f, 0xf0, 0xfe,
    0x7a, 0x92, 0xf1, 0x6b, 0x44, 0xb5, 0x0c, 0x6c, 0xbb, 0x1c, 0x22, 0xa0, 0x1e, 0x86, 0x18, 0xee,
    0x52, 0x71, 0xd7, 0x3e, 0x8b, 0xfc, 0x16, 0x4d, 0xea, 0x86, 0xf9, 0x0b, 0xe9, 0xb9, 0xa4, 0x40,
    0x91, 0x36, 0xf0, 0xa8, 0xc6, 0xe3, 0x81, 0x8f, 0xf8, 0xc6, 0x3d, 0x7d, 0x44, 0xd8, 0x35, 0xa2,
    0xf9, 0x64, 0x63, 0x2b, 0x1a, 0xfb, 0xe6, 0xcb, 0xc9, 0x05, 0x26, 0xd1, 0xee, 0x49
};
#endif

PyTypeObject *init_Plugins(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_Plugins_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_Plugins_IDX].type;

    Shiboken::AutoDecRef Sbk_Plugins_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_Plugins_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Plugins",
        "Plugins*",
        &Sbk_Plugins_spec,
        &Shiboken::callCppDestructor< Plugins >,
        Sbk_Plugins_Type_bases.object(),
        0);
    auto *pyType = _Sbk_Plugins_Type; // references _Sbk_Plugins_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Plugins_SignatureStrings);
#else
    InitSignatureBytes(pyType, Plugins_SignatureBytes, Plugins_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Plugins_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_Plugins_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Plugins_PythonToCpp_Plugins_PTR,
        is_Plugins_PythonToCpp_Plugins_PTR_Convertible,
        Plugins_PTR_CppToPython_Plugins);

    Shiboken::Conversions::registerConverterName(converter, "Plugins");
    Shiboken::Conversions::registerConverterName(converter, "Plugins*");
    Shiboken::Conversions::registerConverterName(converter, "Plugins&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Plugins).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(PluginsWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_Plugins_TypeF(), &Sbk_Plugins_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::Plugins::staticMetaObject);
    PluginsWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::Plugins::staticMetaObject, sizeof(PluginsWrapper));

    return pyType;
}
