/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ebitdo-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_ebitdo_pkt_type_to_string(FuEbitdoPktType val)
{
    if (val == FU_EBITDO_PKT_TYPE_USER_CMD)
        return "user-cmd";
    if (val == FU_EBITDO_PKT_TYPE_USER_DATA)
        return "user-data";
    if (val == FU_EBITDO_PKT_TYPE_MID_CMD)
        return "mid-cmd";
    return NULL;
}

const gchar *
fu_ebitdo_pkt_cmd_to_string(FuEbitdoPktCmd val)
{
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_DATA)
        return "fw-update-data";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_HEADER)
        return "fw-update-header";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_OK)
        return "fw-update-ok";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_ERROR)
        return "fw-update-error";
    if (val == FU_EBITDO_PKT_CMD_FW_GET_VERSION)
        return "fw-get-version";
    if (val == FU_EBITDO_PKT_CMD_FW_SET_VERSION)
        return "fw-set-version";
    if (val == FU_EBITDO_PKT_CMD_FW_SET_ENCODE_ID)
        return "fw-set-encode-id";
    if (val == FU_EBITDO_PKT_CMD_ACK)
        return "ack";
    if (val == FU_EBITDO_PKT_CMD_NAK)
        return "nak";
    if (val == FU_EBITDO_PKT_CMD_UPDATE_FIRMWARE_DATA)
        return "update-firmware-data";
    if (val == FU_EBITDO_PKT_CMD_TRANSFER_ABORT)
        return "transfer-abort";
    if (val == FU_EBITDO_PKT_CMD_VERIFICATION_ID)
        return "verification-id";
    if (val == FU_EBITDO_PKT_CMD_GET_VERIFICATION_ID)
        return "get-verification-id";
    if (val == FU_EBITDO_PKT_CMD_VERIFY_ERROR)
        return "verify-error";
    if (val == FU_EBITDO_PKT_CMD_VERIFY_OK)
        return "verify-ok";
    if (val == FU_EBITDO_PKT_CMD_TRANSFER_TIMEOUT)
        return "transfer-timeout";
    if (val == FU_EBITDO_PKT_CMD_GET_VERSION)
        return "get-version";
    if (val == FU_EBITDO_PKT_CMD_GET_VERSION_RESPONSE)
        return "get-version-response";
    return NULL;
}
/**
 * fu_struct_ebitdo_hdr_ref: (skip):
 **/
FuStructEbitdoHdr *
fu_struct_ebitdo_hdr_ref(FuStructEbitdoHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ebitdo_hdr_unref: (skip):
 **/
void
fu_struct_ebitdo_hdr_unref(FuStructEbitdoHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEbitdoHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ebitdo_hdr_new_internal: (skip):
 **/
static FuStructEbitdoHdr *
fu_struct_ebitdo_hdr_new_internal(void)
{
    FuStructEbitdoHdr *st = g_new0(FuStructEbitdoHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ebitdo_hdr_get_version: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_version(const FuStructEbitdoHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_get_destination_addr: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_destination_addr(const FuStructEbitdoHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_get_destination_len: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_destination_len(const FuStructEbitdoHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ebitdo_hdr_set_version: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_version(FuStructEbitdoHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_set_destination_addr: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_destination_addr(FuStructEbitdoHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_set_destination_len: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_destination_len(FuStructEbitdoHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_new: (skip):
 **/
FuStructEbitdoHdr *
fu_struct_ebitdo_hdr_new(void)
{
    FuStructEbitdoHdr *st = fu_struct_ebitdo_hdr_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    return st;
}
/**
 * fu_struct_ebitdo_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_ebitdo_hdr_to_string(const FuStructEbitdoHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEbitdoHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_version(st));
    g_string_append_printf(str, "  destination_addr: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_destination_addr(st));
    g_string_append_printf(str, "  destination_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_destination_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ebitdo_hdr_validate_internal(FuStructEbitdoHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ebitdo_hdr_parse_internal(FuStructEbitdoHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ebitdo_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ebitdo_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ebitdo_hdr_parse_stream: (skip):
 **/
FuStructEbitdoHdr *
fu_struct_ebitdo_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEbitdoHdr) st = fu_struct_ebitdo_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEbitdoHdr failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEbitdoHdr requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ebitdo_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ebitdo_pkt_ref: (skip):
 **/
FuStructEbitdoPkt *
fu_struct_ebitdo_pkt_ref(FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ebitdo_pkt_unref: (skip):
 **/
void
fu_struct_ebitdo_pkt_unref(FuStructEbitdoPkt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEbitdoPkt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ebitdo_pkt_new_internal: (skip):
 **/
static FuStructEbitdoPkt *
fu_struct_ebitdo_pkt_new_internal(void)
{
    FuStructEbitdoPkt *st = g_new0(FuStructEbitdoPkt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ebitdo_pkt_get_pkt_len: (skip):
 **/
guint8
fu_struct_ebitdo_pkt_get_pkt_len(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ebitdo_pkt_get_type: (skip):
 **/
FuEbitdoPktType
fu_struct_ebitdo_pkt_get_type(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ebitdo_pkt_get_subtype: (skip):
 **/
guint8
fu_struct_ebitdo_pkt_get_subtype(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ebitdo_pkt_get_cmd_len: (skip):
 **/
guint16
fu_struct_ebitdo_pkt_get_cmd_len(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_get_cmd: (skip):
 **/
FuEbitdoPktCmd
fu_struct_ebitdo_pkt_get_cmd(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_ebitdo_pkt_get_payload_len: (skip):
 **/
guint16
fu_struct_ebitdo_pkt_get_payload_len(const FuStructEbitdoPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ebitdo_pkt_set_pkt_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_pkt_len(FuStructEbitdoPkt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_type: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_type(FuStructEbitdoPkt *st, FuEbitdoPktType value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_subtype: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_subtype(FuStructEbitdoPkt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_cmd_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_cmd_len(FuStructEbitdoPkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_set_cmd: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_cmd(FuStructEbitdoPkt *st, FuEbitdoPktCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_payload_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_payload_len(FuStructEbitdoPkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_new: (skip):
 **/
FuStructEbitdoPkt *
fu_struct_ebitdo_pkt_new(void)
{
    FuStructEbitdoPkt *st = fu_struct_ebitdo_pkt_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_ebitdo_pkt_to_string: (skip):
 **/
static gchar *
fu_struct_ebitdo_pkt_to_string(const FuStructEbitdoPkt *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEbitdoPkt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pkt_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_pkt_len(st));
    {
        const gchar *tmp = fu_ebitdo_pkt_type_to_string(fu_struct_ebitdo_pkt_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_ebitdo_pkt_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_ebitdo_pkt_get_type(st));
        }
    }
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_subtype(st));
    g_string_append_printf(str, "  cmd_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_cmd_len(st));
    {
        const gchar *tmp = fu_ebitdo_pkt_cmd_to_string(fu_struct_ebitdo_pkt_get_cmd(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  cmd: 0x%x [%s]\n", (guint) fu_struct_ebitdo_pkt_get_cmd(st), tmp);
        } else {
            g_string_append_printf(str, "  cmd: 0x%x\n", (guint) fu_struct_ebitdo_pkt_get_cmd(st));
        }
    }
    g_string_append_printf(str, "  payload_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_payload_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ebitdo_pkt_validate_internal(FuStructEbitdoPkt *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ebitdo_pkt_parse_internal(FuStructEbitdoPkt *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ebitdo_pkt_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ebitdo_pkt_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ebitdo_pkt_parse: (skip):
 **/
FuStructEbitdoPkt *
fu_struct_ebitdo_pkt_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructEbitdoPkt) st = fu_struct_ebitdo_pkt_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructEbitdoPkt: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_ebitdo_pkt_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
