/* archive-reader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from archive-reader.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <archive_entry.h>
#include "common.h"
#include <stdio.h>
#include <glib/gstdio.h>

#define BOXES_ARCHIVE_READER_BLOCK_SIZE 10240
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
enum  {
	BOXES_ARCHIVE_READER_0_PROPERTY,
	BOXES_ARCHIVE_READER_NUM_PROPERTIES
};
static GParamSpec* boxes_archive_reader_properties[BOXES_ARCHIVE_READER_NUM_PROPERTIES];
#define _archive_read_free0(var) ((var == NULL) ? NULL : (var = (archive_read_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveReaderPrivate {
	gchar* filename;
	int* format;
	GList* filters;
};

struct _Block14Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	FILE* fd;
};

struct _Block15Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	int filter;
};

static gint BoxesArchiveReader_private_offset;
static gpointer boxes_archive_reader_parent_class = NULL;

VALA_EXTERN GType boxes_archive_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesArchiveReader, g_object_unref)
VALA_EXTERN BoxesArchiveReader* boxes_archive_reader_new (const gchar* filename,
                                              int* format,
                                              GList* filters,
                                              GError** error);
VALA_EXTERN BoxesArchiveReader* boxes_archive_reader_construct (GType object_type,
                                                    const gchar* filename,
                                                    int* format,
                                                    GList* filters,
                                                    GError** error);
static int* _archive_format_dup (int* self);
static void boxes_archive_reader_open_archive (BoxesArchiveReader* self,
                                        GError** error);
VALA_EXTERN GList* boxes_archive_reader_get_file_list (BoxesArchiveReader* self,
                                           GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN void boxes_archive_reader_extract_file (BoxesArchiveReader* self,
                                        const gchar* src,
                                        const gchar* dest,
                                        gboolean override_if_necessary,
                                        GError** error);
static void boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self,
                                                   gchar** src_list,
                                                   gint src_list_length1,
                                                   gchar** dest_list,
                                                   gint dest_list_length1,
                                                   gboolean override_if_necessary,
                                                   gboolean follow_hardlinks,
                                                   GError** error);
VALA_EXTERN void boxes_archive_reader_reset (BoxesArchiveReader* self,
                                 GError** error);
static int _archive_read_close_boxes_libarchive_function (gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static gchar* boxes_archive_reader_get_dest_file (BoxesArchiveReader* self,
                                           gchar** src_list,
                                           gint src_list_length1,
                                           gchar** dest_list,
                                           gint dest_list_length1,
                                           const gchar* src);
static int _archive_read_data_skip_boxes_libarchive_function (gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static int ___lambda23_ (Block14Data* _data14_);
static int ____lambda23__boxes_libarchive_function (gpointer self);
static int _archive_read_support_format_all_boxes_libarchive_function (gpointer self);
static int ___lambda20_ (BoxesArchiveReader* self);
static int ____lambda20__boxes_libarchive_function (gpointer self);
static int _archive_read_support_filter_all_boxes_libarchive_function (gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static int _____lambda21_ (Block15Data* _data15_);
static int ______lambda21__boxes_libarchive_function (gpointer self);
static int __lambda22_ (BoxesArchiveReader* self);
static int ___lambda22__boxes_libarchive_function (gpointer self);
static void boxes_archive_reader_finalize (GObject * obj);
static GType boxes_archive_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
boxes_archive_reader_get_instance_private (BoxesArchiveReader* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesArchiveReader_private_offset);
}

static int*
_archive_format_dup (int* self)
{
	int* dup;
	dup = g_new0 (int, 1);
	memcpy (dup, self, sizeof (int));
	return dup;
}

static gpointer
__archive_format_dup0 (gpointer self)
{
	return self ? _archive_format_dup (self) : NULL;
}

BoxesArchiveReader*
boxes_archive_reader_construct (GType object_type,
                                const gchar* filename,
                                int* format,
                                GList* filters,
                                GError** error)
{
	BoxesArchiveReader * self = NULL;
	gchar* _tmp0_;
	int* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (BoxesArchiveReader*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp0_;
	_tmp1_ = __archive_format_dup0 (format);
	_g_free0 (self->priv->format);
	self->priv->format = _tmp1_;
	if (filters != NULL) {
		GList* _tmp2_;
		_tmp2_ = g_list_copy (filters);
		(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
		self->priv->filters = _tmp2_;
	}
	boxes_archive_reader_open_archive (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

BoxesArchiveReader*
boxes_archive_reader_new (const gchar* filename,
                          int* format,
                          GList* filters,
                          GError** error)
{
	return boxes_archive_reader_construct (BOXES_TYPE_ARCHIVE_READER, filename, format, filters, error);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

GList*
boxes_archive_reader_get_file_list (BoxesArchiveReader* self,
                                    GError** error)
{
	GList* _result_ = NULL;
	struct archive_entry* iterator = NULL;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		struct archive* _tmp1_;
		struct archive_entry* _tmp2_ = NULL;
		gboolean _tmp3_;
		struct archive_entry* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = self->archive;
		_tmp3_ = boxes_get_next_header (_tmp1_, &_tmp2_, (guint) 1, &_inner_error0_);
		iterator = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_free0_ (_result_), NULL));
				return NULL;
			} else {
				(_result_ == NULL) ? NULL : (_result_ = (_g_list_free__g_free0_ (_result_), NULL));
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = iterator;
		_tmp5_ = archive_entry_pathname (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		_result_ = g_list_append (_result_, _tmp6_);
	}
	result = _result_;
	return result;
}

void
boxes_archive_reader_extract_file (BoxesArchiveReader* self,
                                   const gchar* src,
                                   const gchar* dest,
                                   gboolean override_if_necessary,
                                   GError** error)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (dest != NULL);
	_tmp0_ = g_strdup (src);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = g_strdup (dest);
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	boxes_archive_reader_extract_files_recursive (self, _tmp2_, (gint) 1, _tmp5_, (gint) 1, override_if_necessary, TRUE, &_inner_error0_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static int
_archive_read_close_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_close ((struct archive*) self);
	return result;
}

void
boxes_archive_reader_reset (BoxesArchiveReader* self,
                            GError** error)
{
	struct archive* _tmp0_;
	struct archive* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->archive;
	_tmp1_ = self->archive;
	boxes_execute_libarchive_function (_tmp0_, _archive_read_close_boxes_libarchive_function, _tmp1_, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	boxes_archive_reader_open_archive (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		BoxesArchiveReader* self;
		self = _data14_->self;
		_fclose0 (_data14_->fd);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static int
_archive_read_data_skip_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_data_skip ((struct archive*) self);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static int
___lambda23_ (Block14Data* _data14_)
{
	BoxesArchiveReader* self;
	struct archive* _tmp0_;
	FILE* _tmp1_;
	int result;
	self = _data14_->self;
	_tmp0_ = self->archive;
	_tmp1_ = _data14_->fd;
	result = archive_read_data_into_fd (_tmp0_, fileno (_tmp1_));
	return result;
}

static int
____lambda23__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda23_ (self);
	return result;
}

static void
boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self,
                                              gchar** src_list,
                                              gint src_list_length1,
                                              gchar** dest_list,
                                              gint dest_list_length1,
                                              gboolean override_if_necessary,
                                              gboolean follow_hardlinks,
                                              GError** error)
{
	struct archive_entry* iterator = NULL;
	guint i = 0U;
	gchar** hardlink_src = NULL;
	gchar** _tmp0_;
	gint hardlink_src_length1;
	gint _hardlink_src_size_;
	gchar** hardlink_dest = NULL;
	gchar** _tmp1_;
	gint hardlink_dest_length1;
	gint _hardlink_dest_size_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (src_list_length1 == dest_list_length1, "src_list.length == dest_list.length");
	if (src_list_length1 == 0) {
		return;
	}
	i = (guint) 0;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	hardlink_src = _tmp0_;
	hardlink_src_length1 = 0;
	_hardlink_src_size_ = hardlink_src_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	hardlink_dest = _tmp1_;
	hardlink_dest_length1 = 0;
	_hardlink_dest_size_ = hardlink_dest_length1;
	while (TRUE) {
		Block14Data* _data14_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		struct archive* _tmp4_;
		struct archive_entry* _tmp5_ = NULL;
		gboolean _tmp6_;
		gchar* dest = NULL;
		struct archive_entry* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp13_ = FALSE;
		struct archive_entry* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp31_;
		FILE* _tmp32_;
		struct archive* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		guint _tmp36_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		_tmp4_ = self->archive;
		_tmp6_ = boxes_get_next_header (_tmp4_, &_tmp5_, (guint) 1, &_inner_error0_);
		iterator = _tmp5_;
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (_tmp3_) {
			_tmp2_ = i < ((guint) src_list_length1);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			block14_data_unref (_data14_);
			_data14_ = NULL;
			break;
		}
		_tmp7_ = iterator;
		_tmp8_ = archive_entry_pathname (_tmp7_);
		_tmp9_ = boxes_archive_reader_get_dest_file (self, src_list, (gint) src_list_length1, dest_list, (gint) dest_list_length1, _tmp8_);
		dest = _tmp9_;
		_tmp10_ = dest;
		if (_tmp10_ == NULL) {
			struct archive* _tmp11_;
			struct archive* _tmp12_;
			_tmp11_ = self->archive;
			_tmp12_ = self->archive;
			boxes_execute_libarchive_function (_tmp11_, _archive_read_data_skip_boxes_libarchive_function, _tmp12_, (guint) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (dest);
					block14_data_unref (_data14_);
					_data14_ = NULL;
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					_g_free0 (dest);
					block14_data_unref (_data14_);
					_data14_ = NULL;
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_free0 (dest);
			block14_data_unref (_data14_);
			_data14_ = NULL;
			continue;
		}
		_tmp14_ = iterator;
		_tmp15_ = archive_entry_hardlink (_tmp14_);
		if (_tmp15_ != NULL) {
			struct archive_entry* _tmp16_;
			_tmp16_ = iterator;
			_tmp13_ = archive_entry_size (_tmp16_) == ((la_int64_t) 0);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			struct archive_entry* _tmp17_;
			const gchar* _tmp18_;
			struct archive_entry* _tmp19_;
			const gchar* _tmp20_;
			struct archive_entry* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			guint _tmp26_;
			_tmp17_ = iterator;
			_tmp18_ = archive_entry_pathname (_tmp17_);
			_tmp19_ = iterator;
			_tmp20_ = archive_entry_hardlink (_tmp19_);
			g_debug ("archive-reader.vala:72: Following hardlink of '%s' to '%s'.", _tmp18_, _tmp20_);
			_tmp21_ = iterator;
			_tmp22_ = archive_entry_hardlink (_tmp21_);
			_tmp23_ = g_strdup (_tmp22_);
			_vala_array_add1 (&hardlink_src, &hardlink_src_length1, &_hardlink_src_size_, _tmp23_);
			_tmp24_ = dest;
			_tmp25_ = g_strdup (_tmp24_);
			_vala_array_add2 (&hardlink_dest, &hardlink_dest_length1, &_hardlink_dest_size_, _tmp25_);
			_tmp26_ = i;
			i = _tmp26_ + 1;
			_g_free0 (dest);
			block14_data_unref (_data14_);
			_data14_ = NULL;
			continue;
		}
		if (!override_if_necessary) {
			const gchar* _tmp28_;
			_tmp28_ = dest;
			_tmp27_ = g_file_test (_tmp28_, G_FILE_TEST_EXISTS);
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			const gchar* _tmp29_;
			GError* _tmp30_;
			_tmp29_ = dest;
			_tmp30_ = g_error_new (G_IO_ERROR, G_IO_ERROR_EXISTS, "Destination file '%s' already exists.", _tmp29_);
			_inner_error0_ = _tmp30_;
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (dest);
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				_g_free0 (dest);
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp31_ = dest;
		_tmp32_ = g_fopen (_tmp31_, "w+");
		_data14_->fd = _tmp32_;
		_tmp33_ = self->archive;
		boxes_execute_libarchive_function (_tmp33_, ____lambda23__boxes_libarchive_function, _data14_, (guint) 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (dest);
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				_g_free0 (dest);
				block14_data_unref (_data14_);
				_data14_ = NULL;
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp34_ = dest;
		_tmp35_ = self->priv->filename;
		g_debug ("archive-reader.vala:87: Extracted file '%s' from archive '%s'.", _tmp34_, _tmp35_);
		_tmp36_ = i;
		i = _tmp36_ + 1;
		_g_free0 (dest);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	if (((guint) src_list_length1) != i) {
		GError* _tmp37_;
		_tmp37_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "At least one specified file was not found in the archive.");
		_inner_error0_ = _tmp37_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	boxes_archive_reader_reset (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp38_ = hardlink_src;
	_tmp38__length1 = hardlink_src_length1;
	if (_tmp38__length1 > 0) {
		if (follow_hardlinks) {
			gchar** _tmp39_;
			gint _tmp39__length1;
			gchar** _tmp40_;
			gint _tmp40__length1;
			_tmp39_ = hardlink_src;
			_tmp39__length1 = hardlink_src_length1;
			_tmp40_ = hardlink_dest;
			_tmp40__length1 = hardlink_dest_length1;
			boxes_archive_reader_extract_files_recursive (self, _tmp39_, (gint) _tmp39__length1, _tmp40_, (gint) _tmp40__length1, override_if_necessary, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			gchar* msg = NULL;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			GError* _tmp43_;
			_tmp41_ = g_strdup ("Maximum recursion depth exceeded. It is likely that a hardlink points " \
"to itself.");
			msg = _tmp41_;
			_tmp42_ = msg;
			_tmp43_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_WOULD_RECURSE, _tmp42_);
			_inner_error0_ = _tmp43_;
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				_g_free0 (msg);
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (msg);
		}
	}
	hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
	hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
boxes_archive_reader_get_dest_file (BoxesArchiveReader* self,
                                    gchar** src_list,
                                    gint src_list_length1,
                                    gchar** dest_list,
                                    gint dest_list_length1,
                                    const gchar* src)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	{
		guint j = 0U;
		j = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(j < ((guint) src_list_length1))) {
					break;
				}
				_tmp2_ = src_list[j];
				if (g_strcmp0 (_tmp2_, src) == 0) {
					const gchar* _tmp3_;
					gchar* _tmp4_;
					_tmp3_ = dest_list[j];
					_tmp4_ = g_strdup (_tmp3_);
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static int
_archive_read_support_format_all_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_support_format_all ((struct archive*) self);
	return result;
}

static int
___lambda20_ (BoxesArchiveReader* self)
{
	struct archive* _tmp0_;
	int* _tmp1_;
	int result;
	_tmp0_ = self->archive;
	_tmp1_ = self->priv->format;
	result = archive_read_set_format (_tmp0_, *_tmp1_);
	return result;
}

static int
____lambda20__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda20_ ((BoxesArchiveReader*) self);
	return result;
}

static int
_archive_read_support_filter_all_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_support_filter_all ((struct archive*) self);
	return result;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		BoxesArchiveReader* self;
		self = _data15_->self;
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static int
_____lambda21_ (Block15Data* _data15_)
{
	BoxesArchiveReader* self;
	struct archive* _tmp0_;
	int result;
	self = _data15_->self;
	_tmp0_ = self->archive;
	result = archive_read_append_filter (_tmp0_, _data15_->filter);
	return result;
}

static int
______lambda21__boxes_libarchive_function (gpointer self)
{
	int result;
	result = _____lambda21_ (self);
	return result;
}

static int
__lambda22_ (BoxesArchiveReader* self)
{
	struct archive* _tmp0_;
	const gchar* _tmp1_;
	int result;
	_tmp0_ = self->archive;
	_tmp1_ = self->priv->filename;
	result = archive_read_open_filename (_tmp0_, _tmp1_, (gsize) BOXES_ARCHIVE_READER_BLOCK_SIZE);
	return result;
}

static int
___lambda22__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda22_ ((BoxesArchiveReader*) self);
	return result;
}

static void
boxes_archive_reader_open_archive (BoxesArchiveReader* self,
                                   GError** error)
{
	struct archive* _tmp0_;
	int* _tmp1_;
	GList* _tmp5_;
	struct archive* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = archive_read_new ();
	_archive_read_free0 (self->archive);
	self->archive = _tmp0_;
	_tmp1_ = self->priv->format;
	if (_tmp1_ == NULL) {
		struct archive* _tmp2_;
		struct archive* _tmp3_;
		_tmp2_ = self->archive;
		_tmp3_ = self->archive;
		boxes_execute_libarchive_function (_tmp2_, _archive_read_support_format_all_boxes_libarchive_function, _tmp3_, (guint) 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		struct archive* _tmp4_;
		_tmp4_ = self->archive;
		boxes_execute_libarchive_function (_tmp4_, ____lambda20__boxes_libarchive_function, self, (guint) 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp5_ = self->priv->filters;
	if (_tmp5_ == NULL) {
		struct archive* _tmp6_;
		struct archive* _tmp7_;
		_tmp6_ = self->archive;
		_tmp7_ = self->archive;
		boxes_execute_libarchive_function (_tmp6_, _archive_read_support_filter_all_boxes_libarchive_function, _tmp7_, (guint) 1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		GList* _tmp8_;
		_tmp8_ = self->priv->filters;
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
			filter_collection = _tmp8_;
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
				int filter = 0;
				filter = (int) ((gintptr) filter_it->data);
				{
					Block15Data* _data15_;
					struct archive* _tmp9_;
					_data15_ = g_slice_new0 (Block15Data);
					_data15_->_ref_count_ = 1;
					_data15_->self = g_object_ref (self);
					_data15_->filter = filter;
					_tmp9_ = self->archive;
					boxes_execute_libarchive_function (_tmp9_, ______lambda21__boxes_libarchive_function, _data15_, (guint) 1, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							g_propagate_error (error, _inner_error0_);
							block15_data_unref (_data15_);
							_data15_ = NULL;
							return;
						} else {
							block15_data_unref (_data15_);
							_data15_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					block15_data_unref (_data15_);
					_data15_ = NULL;
				}
			}
		}
	}
	_tmp10_ = self->archive;
	boxes_execute_libarchive_function (_tmp10_, ___lambda22__boxes_libarchive_function, self, (guint) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
boxes_archive_reader_class_init (BoxesArchiveReaderClass * klass,
                                 gpointer klass_data)
{
	boxes_archive_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesArchiveReader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_reader_finalize;
}

static void
boxes_archive_reader_instance_init (BoxesArchiveReader * self,
                                    gpointer klass)
{
	self->priv = boxes_archive_reader_get_instance_private (self);
}

static void
boxes_archive_reader_finalize (GObject * obj)
{
	BoxesArchiveReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader);
	_archive_read_free0 (self->archive);
	_g_free0 (self->priv->filename);
	_g_free0 (self->priv->format);
	(self->priv->filters == NULL) ? NULL : (self->priv->filters = (g_list_free (self->priv->filters), NULL));
	G_OBJECT_CLASS (boxes_archive_reader_parent_class)->finalize (obj);
}

static GType
boxes_archive_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveReader), 0, (GInstanceInitFunc) boxes_archive_reader_instance_init, NULL };
	GType boxes_archive_reader_type_id;
	boxes_archive_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveReader", &g_define_type_info, 0);
	BoxesArchiveReader_private_offset = g_type_add_instance_private (boxes_archive_reader_type_id, sizeof (BoxesArchiveReaderPrivate));
	return boxes_archive_reader_type_id;
}

GType
boxes_archive_reader_get_type (void)
{
	static volatile gsize boxes_archive_reader_type_id__once = 0;
	if (g_once_init_enter (&boxes_archive_reader_type_id__once)) {
		GType boxes_archive_reader_type_id;
		boxes_archive_reader_type_id = boxes_archive_reader_get_type_once ();
		g_once_init_leave (&boxes_archive_reader_type_id__once, boxes_archive_reader_type_id);
	}
	return boxes_archive_reader_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

