/* downloader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from downloader.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "common.h"
#include <gobject/gvaluecollector.h>
#include <libsoup/soup.h>
#include <osinfo/osinfo.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_DOWNLOAD (boxes_download_get_type ())
#define BOXES_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOAD, BoxesDownload))
#define BOXES_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOAD, BoxesDownloadClass))
#define BOXES_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOAD))
#define BOXES_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOAD))
#define BOXES_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOAD, BoxesDownloadClass))

typedef struct _BoxesDownload BoxesDownload;
typedef struct _BoxesDownloadClass BoxesDownloadClass;
typedef struct _BoxesDownloadPrivate BoxesDownloadPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesParamSpecDownload BoxesParamSpecDownload;

#define BOXES_TYPE_DOWNLOADER (boxes_downloader_get_type ())
#define BOXES_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOADER, BoxesDownloader))
#define BOXES_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOADER, BoxesDownloaderClass))
#define BOXES_IS_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOADER))
#define BOXES_IS_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOADER))
#define BOXES_DOWNLOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOADER, BoxesDownloaderClass))

typedef struct _BoxesDownloader BoxesDownloader;
typedef struct _BoxesDownloaderClass BoxesDownloaderClass;
typedef struct _BoxesDownloaderPrivate BoxesDownloaderPrivate;
enum  {
	BOXES_DOWNLOADER_0_PROPERTY,
	BOXES_DOWNLOADER_NUM_PROPERTIES
};
static GParamSpec* boxes_downloader_properties[BOXES_DOWNLOADER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _boxes_download_unref0(var) ((var == NULL) ? NULL : (var = (boxes_download_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesDownloaderDownloadData BoxesDownloaderDownloadData;
typedef struct _Block54Data Block54Data;
typedef struct _BoxesDownloaderDownloadFromHttpData BoxesDownloaderDownloadFromHttpData;
typedef struct _BoxesDownloaderFetchOsLogoData BoxesDownloaderFetchOsLogoData;
typedef struct _BoxesDownloaderFetchMediaData BoxesDownloaderFetchMediaData;
typedef struct _Block55Data Block55Data;
typedef struct _BoxesDownloaderAwaitDownloadData BoxesDownloaderAwaitDownloadData;
typedef struct _Block56Data Block56Data;
typedef struct _BoxesDownloaderDownloadFromFilesystemData BoxesDownloaderDownloadFromFilesystemData;
enum  {
	BOXES_DOWNLOADER_DOWNLOADED_SIGNAL,
	BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL,
	BOXES_DOWNLOADER_NUM_SIGNALS
};
static guint boxes_downloader_signals[BOXES_DOWNLOADER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesDownload {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesDownloadPrivate * priv;
	gchar* uri;
	GFile* remote_file;
	GFile* cached_file;
	BoxesActivityProgress* progress;
};

struct _BoxesDownloadClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesDownload *self);
};

struct _BoxesParamSpecDownload {
	GParamSpec parent_instance;
};

struct _BoxesDownloader {
	GObject parent_instance;
	BoxesDownloaderPrivate * priv;
};

struct _BoxesDownloaderClass {
	GObjectClass parent_class;
};

struct _BoxesDownloaderPrivate {
	SoupSession* session;
	GHashTable* downloads;
};

struct _BoxesDownloaderDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	GFile* remote_file;
	gchar** cached_paths;
	gint cached_paths_length1;
	BoxesActivityProgress* progress;
	GCancellable* cancellable;
	GFile* result;
	gchar* uri;
	gchar* _tmp0_;
	BoxesDownload* download;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	BoxesDownload* _tmp4_;
	gchar* cached_path;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	BoxesDownload* _tmp7_;
	GFile* _tmp8_;
	BoxesDownload* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* cached_file;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar** splited_path;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint splited_path_length1;
	gint _splited_path_size_;
	gchar* tmp_name;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* tmp_file_path;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* tmp_file;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	BoxesDownload* _tmp28_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	BoxesDownload* _tmp32_;
	BoxesDownload* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gboolean _tmp37_;
	BoxesDownload* _tmp38_;
	BoxesDownload* _tmp39_;
	GError* _error_;
	BoxesDownload* _tmp40_;
	GError* _tmp41_;
	GError* _tmp42_;
	GError* _tmp43_;
	GError* _inner_error1_;
	GHashTable* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	GFile* _tmp49_;
	BoxesDownload* _tmp50_;
	GFile* _tmp51_;
	GFile* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	BoxesDownload* _tmp55_;
	GError* _inner_error0_;
};

struct _Block54Data {
	int _ref_count_;
	BoxesDownloader* self;
	SoupMessage* msg;
	gint64 total_num_bytes;
	gpointer _async_data_;
};

struct _BoxesDownloaderDownloadFromHttpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	GCancellable* cancellable;
	Block54Data* _data54_;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	GError* err;
	SoupMessage* _tmp2_;
	GFileOutputStream* cached_file_stream;
	GFile* _tmp3_;
	GFileOutputStream* _tmp4_;
	gint64 current_num_bytes;
	GInputStream* input_stream;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	GInputStream* _tmp7_;
	guint8* buffer;
	guint8* _tmp8_;
	gint buffer_length1;
	gint _buffer_size_;
	gssize num_read;
	GInputStream* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	gsize bytes_written;
	GFileOutputStream* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gsize _tmp14_;
	BoxesActivityProgress* _tmp15_;
	GFileOutputStream* _tmp16_;
	GError* e;
	GError* _tmp17_;
	GError* _tmp18_;
	gboolean _tmp19_;
	SoupMessage* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GFile* _tmp23_;
	GError* _tmp24_;
	SoupMessage* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	SoupMessage* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GError* _tmp31_;
	GError* _tmp32_;
	GError* _tmp33_;
	GError* _inner_error0_;
};

struct _BoxesDownloaderFetchOsLogoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GtkImage* image;
	OsinfoOs* os;
	gint size;
	gchar* logo_url;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* remote_file;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	gchar* system_cached_path;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* cached_path;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** cached_paths;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint cached_paths_length1;
	gint _cached_paths_size_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* cached_file;
	BoxesDownloader* _tmp23_;
	BoxesDownloader* _tmp24_;
	GFile* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	BoxesActivityProgress* _tmp27_;
	BoxesActivityProgress* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GdkPixbuf* pixbuf;
	GFile* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GdkPixbuf* _tmp34_;
	GdkPixbuf* _tmp35_;
	GdkPixbuf* _tmp36_;
	GError* _error_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	const gchar* _tmp39_;
	GError* _inner_error0_;
};

struct _BoxesDownloaderFetchMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* uri;
	gchar* filename;
	BoxesActivityProgress* progress;
	GCancellable* cancellable;
	gchar* result;
	GFile* file;
	GFile* _tmp0_;
	gchar* basename;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	BoxesDownloader* downloader;
	BoxesDownloader* _tmp10_;
	gchar* cache;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GError* _inner_error0_;
};

struct _Block55Data {
	int _ref_count_;
	BoxesDownloader* self;
	GFile* downloaded_file;
	GError* download_error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	BoxesDownload* download;
	gpointer _async_data_;
};

struct _BoxesDownloaderAwaitDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	gchar* cached_path;
	BoxesActivityProgress* progress;
	GFile* result;
	Block55Data* _data55_;
	BoxesActivityProgress* _tmp0_;
	gulong downloaded_id;
	gulong _tmp1_;
	gulong downloaded_failed_id;
	gulong _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GFile* cached_file;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* _inner_error0_;
};

struct _Block56Data {
	int _ref_count_;
	BoxesDownloader* self;
	BoxesDownload* download;
	gpointer _async_data_;
};

struct _BoxesDownloaderDownloadFromFilesystemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	GCancellable* cancellable;
	Block56Data* _data56_;
	GFile* src_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* dest_file;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_;
};

static gpointer boxes_download_parent_class = NULL;
static gint BoxesDownloader_private_offset;
static gpointer boxes_downloader_parent_class = NULL;
static BoxesDownloader* boxes_downloader_downloader;
static BoxesDownloader* boxes_downloader_downloader = NULL;
VALA_EXTERN gchar** boxes_downloader_supported_schemes;
VALA_EXTERN gint boxes_downloader_supported_schemes_length1;
gchar** boxes_downloader_supported_schemes = NULL;
gint boxes_downloader_supported_schemes_length1 = 0;
static gint _boxes_downloader_supported_schemes_size_ = 0;

VALA_EXTERN gpointer boxes_download_ref (gpointer instance);
VALA_EXTERN void boxes_download_unref (gpointer instance);
VALA_EXTERN GParamSpec* boxes_param_spec_download (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void boxes_value_set_download (GValue* value,
                               gpointer v_object);
VALA_EXTERN void boxes_value_take_download (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer boxes_value_get_download (const GValue* value);
VALA_EXTERN GType boxes_download_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDownload, boxes_download_unref)
VALA_EXTERN BoxesDownload* boxes_download_new (GFile* remote_file,
                                   GFile* cached_file,
                                   BoxesActivityProgress* progress);
VALA_EXTERN BoxesDownload* boxes_download_construct (GType object_type,
                                         GFile* remote_file,
                                         GFile* cached_file,
                                         BoxesActivityProgress* progress);
static void boxes_download_finalize (BoxesDownload * obj);
static GType boxes_download_get_type_once (void);
VALA_EXTERN GType boxes_downloader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDownloader, g_object_unref)
VALA_EXTERN BoxesDownloader* boxes_downloader_get_default (void);
static BoxesDownloader* boxes_downloader_new (void);
static BoxesDownloader* boxes_downloader_construct (GType object_type);
VALA_EXTERN gchar* boxes_downloader_fetch_os_logo_url (OsinfoOs* os);
static void _g_free0_ (gpointer var);
static void _boxes_download_unref0_ (gpointer var);
static void boxes_downloader_download_data_free (gpointer _data);
VALA_EXTERN void boxes_downloader_download (BoxesDownloader* self,
                                GFile* remote_file,
                                gchar** cached_paths,
                                gint cached_paths_length1,
                                BoxesActivityProgress* progress,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN GFile* boxes_downloader_download_finish (BoxesDownloader* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean boxes_downloader_download_co (BoxesDownloaderDownloadData* _data_);
static void boxes_downloader_await_download (BoxesDownloader* self,
                                      BoxesDownload* download,
                                      const gchar* cached_path,
                                      BoxesActivityProgress* progress,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static GFile* boxes_downloader_await_download_finish (BoxesDownloader* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void boxes_downloader_download_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static GFile* boxes_downloader_get_cached_file (BoxesDownloader* self,
                                         GFile* remote_file,
                                         gchar** cached_paths,
                                         gint cached_paths_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void boxes_downloader_download_from_http (BoxesDownloader* self,
                                          BoxesDownload* download,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void boxes_downloader_download_from_http_finish (BoxesDownloader* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void boxes_downloader_download_from_filesystem (BoxesDownloader* self,
                                                BoxesDownload* download,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void boxes_downloader_download_from_filesystem_finish (BoxesDownloader* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void boxes_downloader_download_from_http_data_free (gpointer _data);
static gboolean boxes_downloader_download_from_http_co (BoxesDownloaderDownloadFromHttpData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void __lambda16_ (Block54Data* _data54_);
static void ___lambda16__soup_message_got_headers (SoupMessage* _sender,
                                            gpointer self);
static void boxes_downloader_download_from_http_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void boxes_downloader_fetch_os_logo_data_free (gpointer _data);
VALA_EXTERN void boxes_downloader_fetch_os_logo (GtkImage* image,
                                     OsinfoOs* os,
                                     gint size,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void boxes_downloader_fetch_os_logo_finish (GAsyncResult* _res_);
static gboolean boxes_downloader_fetch_os_logo_co (BoxesDownloaderFetchOsLogoData* _data_);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void boxes_downloader_fetch_os_logo_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void boxes_downloader_fetch_media_data_free (gpointer _data);
VALA_EXTERN void boxes_downloader_fetch_media (const gchar* uri,
                                   const gchar* filename,
                                   BoxesActivityProgress* progress,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* boxes_downloader_fetch_media_finish (GAsyncResult* _res_,
                                            GError** error);
static gboolean boxes_downloader_fetch_media_co (BoxesDownloaderFetchMediaData* _data_);
static void boxes_downloader_fetch_media_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void boxes_downloader_await_download_data_free (gpointer _data);
static gboolean boxes_downloader_await_download_co (BoxesDownloaderAwaitDownloadData* _data_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static gboolean _boxes_downloader_await_download_co_gsource_func (gpointer self);
static void __lambda14_ (Block55Data* _data55_,
                  BoxesDownloader* downloader,
                  BoxesDownload* downloaded);
static void ___lambda14__boxes_downloader_downloaded (BoxesDownloader* _sender,
                                               BoxesDownload* download,
                                               gpointer self);
static void __lambda15_ (Block55Data* _data55_,
                  BoxesDownloader* downloader,
                  BoxesDownload* failed_download,
                  GError* _error_);
static void ___lambda15__boxes_downloader_download_failed (BoxesDownloader* _sender,
                                                    BoxesDownload* download,
                                                    GError* _error_,
                                                    gpointer self);
static void boxes_downloader_await_download_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void boxes_downloader_download_from_filesystem_data_free (gpointer _data);
static gboolean boxes_downloader_download_from_filesystem_co (BoxesDownloaderDownloadFromFilesystemData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static void ___lambda17_ (Block56Data* _data56_,
                   gint64 current,
                   gint64 total);
static void ____lambda17__gfile_progress_callback (gint64 current_num_bytes,
                                            gint64 total_num_bytes,
                                            gpointer self);
static void boxes_downloader_download_from_filesystem_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_BOXED (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void boxes_downloader_finalize (GObject * obj);
static GType boxes_downloader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BoxesDownload*
boxes_download_construct (GType object_type,
                          GFile* remote_file,
                          GFile* cached_file,
                          BoxesActivityProgress* progress)
{
	BoxesDownload* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	BoxesActivityProgress* _tmp3_;
	g_return_val_if_fail (remote_file != NULL, NULL);
	g_return_val_if_fail (cached_file != NULL, NULL);
	g_return_val_if_fail (progress != NULL, NULL);
	self = (BoxesDownload*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (remote_file);
	_g_object_unref0 (self->remote_file);
	self->remote_file = _tmp0_;
	_tmp1_ = g_file_get_uri (remote_file);
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	_tmp2_ = _g_object_ref0 (cached_file);
	_g_object_unref0 (self->cached_file);
	self->cached_file = _tmp2_;
	_tmp3_ = _g_object_ref0 (progress);
	_g_object_unref0 (self->progress);
	self->progress = _tmp3_;
	return self;
}

BoxesDownload*
boxes_download_new (GFile* remote_file,
                    GFile* cached_file,
                    BoxesActivityProgress* progress)
{
	return boxes_download_construct (BOXES_TYPE_DOWNLOAD, remote_file, cached_file, progress);
}

static void
boxes_value_download_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
boxes_value_download_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		boxes_download_unref (value->data[0].v_pointer);
	}
}

static void
boxes_value_download_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_download_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
boxes_value_download_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
boxes_value_download_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BoxesDownload * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_download_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
boxes_value_download_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	BoxesDownload ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_download_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
boxes_param_spec_download (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	BoxesParamSpecDownload* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_DOWNLOAD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
boxes_value_get_download (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD), NULL);
	return value->data[0].v_pointer;
}

void
boxes_value_set_download (GValue* value,
                          gpointer v_object)
{
	BoxesDownload * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_DOWNLOAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_download_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_download_unref (old);
	}
}

void
boxes_value_take_download (GValue* value,
                           gpointer v_object)
{
	BoxesDownload * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_DOWNLOAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_download_unref (old);
	}
}

static void
boxes_download_class_init (BoxesDownloadClass * klass,
                           gpointer klass_data)
{
	boxes_download_parent_class = g_type_class_peek_parent (klass);
	((BoxesDownloadClass *) klass)->finalize = boxes_download_finalize;
}

static void
boxes_download_instance_init (BoxesDownload * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
boxes_download_finalize (BoxesDownload * obj)
{
	BoxesDownload * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOAD, BoxesDownload);
	g_signal_handlers_destroy (self);
	_g_free0 (self->uri);
	_g_object_unref0 (self->remote_file);
	_g_object_unref0 (self->cached_file);
	_g_object_unref0 (self->progress);
}

static GType
boxes_download_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { boxes_value_download_init, boxes_value_download_free_value, boxes_value_download_copy_value, boxes_value_download_peek_pointer, "p", boxes_value_download_collect_value, "p", boxes_value_download_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_download_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownload), 0, (GInstanceInitFunc) boxes_download_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType boxes_download_type_id;
	boxes_download_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesDownload", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return boxes_download_type_id;
}

GType
boxes_download_get_type (void)
{
	static volatile gsize boxes_download_type_id__once = 0;
	if (g_once_init_enter (&boxes_download_type_id__once)) {
		GType boxes_download_type_id;
		boxes_download_type_id = boxes_download_get_type_once ();
		g_once_init_leave (&boxes_download_type_id__once, boxes_download_type_id);
	}
	return boxes_download_type_id__once;
}

gpointer
boxes_download_ref (gpointer instance)
{
	BoxesDownload * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
boxes_download_unref (gpointer instance)
{
	BoxesDownload * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_DOWNLOAD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
boxes_downloader_get_instance_private (BoxesDownloader* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesDownloader_private_offset);
}

BoxesDownloader*
boxes_downloader_get_default (void)
{
	BoxesDownloader* _tmp0_;
	BoxesDownloader* _tmp2_;
	BoxesDownloader* _tmp3_;
	BoxesDownloader* result;
	_tmp0_ = boxes_downloader_downloader;
	if (_tmp0_ == NULL) {
		BoxesDownloader* _tmp1_;
		_tmp1_ = boxes_downloader_new ();
		_g_object_unref0 (boxes_downloader_downloader);
		boxes_downloader_downloader = _tmp1_;
	}
	_tmp2_ = boxes_downloader_downloader;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
boxes_downloader_fetch_os_logo_url (OsinfoOs* os)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* logo_url = NULL;
	OsinfoProductList* derived = NULL;
	OsinfoProductList* _tmp5_;
	gchar* result;
	g_return_val_if_fail (os != NULL, NULL);
	_tmp0_ = osinfo_product_get_logo ((OsinfoProduct*) os);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = osinfo_product_get_logo ((OsinfoProduct*) os);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	logo_url = NULL;
	_tmp5_ = osinfo_product_get_related ((OsinfoProduct*) os, OSINFO_PRODUCT_RELATIONSHIP_UPGRADES);
	derived = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		OsinfoProductList* _tmp7_;
		OsinfoOs* parent = NULL;
		OsinfoProductList* _tmp9_;
		OsinfoEntity* _tmp10_;
		OsinfoOs* _tmp11_;
		OsinfoOs* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp7_ = derived;
		if (osinfo_list_get_length ((OsinfoList*) _tmp7_) > 0) {
			const gchar* _tmp8_;
			_tmp8_ = logo_url;
			_tmp6_ = _tmp8_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp9_ = derived;
		_tmp10_ = osinfo_list_get_nth ((OsinfoList*) _tmp9_, 0);
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, osinfo_os_get_type ()) ? ((OsinfoOs*) _tmp10_) : NULL);
		parent = _tmp11_;
		_tmp12_ = parent;
		_tmp13_ = osinfo_product_get_logo ((OsinfoProduct*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			OsinfoOs* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = parent;
			_tmp16_ = osinfo_product_get_logo ((OsinfoProduct*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (logo_url);
			logo_url = _tmp18_;
		} else {
			OsinfoOs* _tmp19_;
			OsinfoProductList* _tmp20_;
			_tmp19_ = parent;
			_tmp20_ = osinfo_product_get_related ((OsinfoProduct*) _tmp19_, OSINFO_PRODUCT_RELATIONSHIP_UPGRADES);
			_g_object_unref0 (derived);
			derived = _tmp20_;
		}
		_g_object_unref0 (parent);
	}
	result = logo_url;
	_g_object_unref0 (derived);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_boxes_download_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (boxes_download_unref (var), NULL));
}

static BoxesDownloader*
boxes_downloader_construct (GType object_type)
{
	BoxesDownloader * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	SoupSession* _tmp3_;
	const gchar* _tmp4_;
	SoupSession* _tmp8_;
	self = (BoxesDownloader*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _boxes_download_unref0_);
	_g_hash_table_unref0 (self->priv->downloads);
	self->priv->downloads = _tmp2_;
	_tmp3_ = soup_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp3_;
	_tmp4_ = g_getenv ("SOUP_DEBUG");
	if (_tmp4_ != NULL) {
		SoupSession* _tmp5_;
		SoupLogger* _tmp6_;
		SoupLogger* _tmp7_;
		_tmp5_ = self->priv->session;
		_tmp6_ = soup_logger_new (SOUP_LOGGER_LOG_HEADERS);
		_tmp7_ = _tmp6_;
		soup_session_add_feature (_tmp5_, (SoupSessionFeature*) _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	_tmp8_ = self->priv->session;
	soup_session_set_user_agent (_tmp8_, "Wget/1.0");
	return self;
}

static BoxesDownloader*
boxes_downloader_new (void)
{
	return boxes_downloader_construct (BOXES_TYPE_DOWNLOADER);
}

static void
boxes_downloader_download_data_free (gpointer _data)
{
	BoxesDownloaderDownloadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote_file);
	_g_object_unref0 (_data_->progress);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesDownloaderDownloadData, _data_);
}

void
boxes_downloader_download (BoxesDownloader* self,
                           GFile* remote_file,
                           gchar** cached_paths,
                           gint cached_paths_length1,
                           BoxesActivityProgress* progress,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	BoxesDownloaderDownloadData* _data_;
	BoxesDownloader* _tmp0_;
	GFile* _tmp1_;
	BoxesActivityProgress* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (remote_file != NULL);
	g_return_if_fail (progress != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderDownloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote_file);
	_g_object_unref0 (_data_->remote_file);
	_data_->remote_file = _tmp1_;
	_data_->cached_paths = cached_paths;
	_data_->cached_paths_length1 = cached_paths_length1;
	_tmp2_ = _g_object_ref0 (progress);
	_g_object_unref0 (_data_->progress);
	_data_->progress = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	boxes_downloader_download_co (_data_);
}

GFile*
boxes_downloader_download_finish (BoxesDownloader* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	GFile* result;
	BoxesDownloaderDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Downloads the given file.
     *
     * @param remote_file The remote file to download.
     * @param cached_paths Array of possible cache locations. If not found, the file will be saved
     *                     to the location specified by the first element.
     * @param progress The ActivityProgress object to report progress to.
     * @param cancellable The Cancellable object for cancellation.
     *
     * @return A file handle to the (now) local file.
     */
static gpointer
_boxes_download_ref0 (gpointer self)
{
	return self ? boxes_download_ref (self) : NULL;
}

static void
boxes_downloader_download_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	BoxesDownloaderDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_download_co (_data_);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
boxes_downloader_download_co (BoxesDownloaderDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_uri (_data_->remote_file);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->downloads;
	_data_->_tmp2_ = _data_->uri;
	_data_->_tmp3_ = g_hash_table_lookup (_data_->_tmp1_, _data_->_tmp2_);
	_data_->_tmp4_ = _boxes_download_ref0 ((BoxesDownload*) _data_->_tmp3_);
	_data_->download = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->cached_paths[0];
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->cached_path = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->download;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp9_ = _data_->download;
		_data_->_tmp10_ = _data_->cached_path;
		_data_->_state_ = 1;
		boxes_downloader_await_download (_data_->self, _data_->_tmp9_, _data_->_tmp10_, _data_->progress, boxes_downloader_download_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = boxes_downloader_await_download_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->cached_path);
			_boxes_download_unref0 (_data_->download);
			_g_free0 (_data_->uri);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp12_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_data_->result = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp8_);
		_g_free0 (_data_->cached_path);
		_boxes_download_unref0 (_data_->download);
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = boxes_downloader_get_cached_file (_data_->self, _data_->remote_file, _data_->cached_paths, (gint) _data_->cached_paths_length1);
	_data_->cached_file = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->cached_file;
	if (_data_->_tmp14_ != NULL) {
		_data_->result = _data_->cached_file;
		_g_free0 (_data_->cached_path);
		_boxes_download_unref0 (_data_->download);
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->cached_path;
	_data_->_tmp17_ = _data_->_tmp16_ = g_strsplit (_data_->_tmp15_, "/", 0);
	_data_->splited_path = _data_->_tmp17_;
	_data_->splited_path_length1 = _vala_array_length (_data_->_tmp16_);
	_data_->_splited_path_size_ = _data_->splited_path_length1;
	_data_->_tmp18_ = _data_->splited_path;
	_data_->_tmp18__length1 = _data_->splited_path_length1;
	_data_->_tmp19_ = _data_->splited_path;
	_data_->_tmp19__length1 = _data_->splited_path_length1;
	_data_->_tmp20_ = _data_->_tmp18_[_data_->_tmp19__length1 - 1];
	_data_->_tmp21_ = g_strconcat (_data_->_tmp20_, "-XXXXXX", NULL);
	_data_->tmp_name = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->tmp_name;
	_data_->_tmp23_ = g_build_filename ("/var/tmp", _data_->_tmp22_, NULL);
	_data_->tmp_file_path = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->tmp_file_path;
	_data_->_tmp25_ = g_file_new_for_path (_data_->_tmp24_);
	_data_->tmp_file = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->uri;
	g_debug ("downloader.vala:102: Downloading '%s'...", _data_->_tmp26_);
	_data_->_tmp27_ = _data_->tmp_file;
	_data_->_tmp28_ = boxes_download_new (_data_->remote_file, _data_->_tmp27_, _data_->progress);
	_boxes_download_unref0 (_data_->download);
	_data_->download = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->self->priv->downloads;
	_data_->_tmp30_ = _data_->uri;
	_data_->_tmp31_ = g_strdup (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->download;
	_data_->_tmp33_ = _boxes_download_ref0 (_data_->_tmp32_);
	g_hash_table_insert (_data_->_tmp29_, _data_->_tmp31_, _data_->_tmp33_);
	{
		_data_->_tmp34_ = g_file_get_uri_scheme (_data_->remote_file);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = boxes_downloader_supported_schemes;
		_data_->_tmp36__length1 = boxes_downloader_supported_schemes_length1;
		_data_->_tmp37_ = _vala_string_array_contains (_data_->_tmp36_, _data_->_tmp36__length1, _data_->_tmp35_);
		_g_free0 (_data_->_tmp35_);
		if (_data_->_tmp37_) {
			_data_->_tmp38_ = _data_->download;
			_data_->_state_ = 2;
			boxes_downloader_download_from_http (_data_->self, _data_->_tmp38_, _data_->cancellable, boxes_downloader_download_ready, _data_);
			return FALSE;
			_state_2:
			boxes_downloader_download_from_http_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			_data_->_tmp39_ = _data_->download;
			_data_->_state_ = 3;
			boxes_downloader_download_from_filesystem (_data_->self, _data_->_tmp39_, _data_->cancellable, boxes_downloader_download_ready, _data_);
			return FALSE;
			_state_3:
			boxes_downloader_download_from_filesystem_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp40_ = _data_->download;
		_data_->_tmp41_ = _data_->_error_;
		g_signal_emit (_data_->self, boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL], 0, _data_->_tmp40_, _data_->_tmp41_);
		_data_->_tmp42_ = _data_->_error_;
		_data_->_tmp43_ = _g_error_copy0 (_data_->_tmp42_);
		_data_->_inner_error0_ = _data_->_tmp43_;
		_g_error_free0 (_data_->_error_);
		goto __finally0;
	}
	__finally0:
	{
		_data_->_tmp44_ = _data_->self->priv->downloads;
		_data_->_tmp45_ = _data_->uri;
		g_hash_table_remove (_data_->_tmp44_, _data_->_tmp45_);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tmp_file);
		_g_free0 (_data_->tmp_file_path);
		_g_free0 (_data_->tmp_name);
		_data_->splited_path = (_vala_array_free (_data_->splited_path, _data_->splited_path_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->cached_file);
		_g_free0 (_data_->cached_path);
		_boxes_download_unref0 (_data_->download);
		_g_free0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp46_ = _data_->cached_path;
	_data_->_tmp47_ = g_file_new_for_path (_data_->_tmp46_);
	_g_object_unref0 (_data_->cached_file);
	_data_->cached_file = _data_->_tmp47_;
	_data_->_tmp48_ = _data_->tmp_file;
	_data_->_tmp49_ = _data_->cached_file;
	g_file_move (_data_->_tmp48_, _data_->_tmp49_, G_FILE_COPY_NONE, _data_->cancellable, NULL, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->tmp_file);
		_g_free0 (_data_->tmp_file_path);
		_g_free0 (_data_->tmp_name);
		_data_->splited_path = (_vala_array_free (_data_->splited_path, _data_->splited_path_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->cached_file);
		_g_free0 (_data_->cached_path);
		_boxes_download_unref0 (_data_->download);
		_g_free0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp50_ = _data_->download;
	_data_->_tmp51_ = _data_->cached_file;
	_data_->_tmp52_ = _g_object_ref0 (_data_->_tmp51_);
	_g_object_unref0 (_data_->_tmp50_->cached_file);
	_data_->_tmp50_->cached_file = _data_->_tmp52_;
	_data_->_tmp53_ = _data_->uri;
	_data_->_tmp54_ = _data_->cached_path;
	g_debug ("downloader.vala:123: Downloaded '%s' and it's now locally available at" \
" '%s'.", _data_->_tmp53_, _data_->_tmp54_);
	_data_->_tmp55_ = _data_->download;
	g_signal_emit (_data_->self, boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOADED_SIGNAL], 0, _data_->_tmp55_);
	_data_->result = _data_->cached_file;
	_g_object_unref0 (_data_->tmp_file);
	_g_free0 (_data_->tmp_file_path);
	_g_free0 (_data_->tmp_name);
	_data_->splited_path = (_vala_array_free (_data_->splited_path, _data_->splited_path_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->cached_path);
	_boxes_download_unref0 (_data_->download);
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloader_download_from_http_data_free (gpointer _data)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	_data_ = _data;
	_boxes_download_unref0 (_data_->download);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesDownloaderDownloadFromHttpData, _data_);
}

void
boxes_downloader_download_from_http (BoxesDownloader* self,
                                     BoxesDownload* download,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (download != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderDownloadFromHttpData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_from_http_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _boxes_download_ref0 (download);
	_boxes_download_unref0 (_data_->download);
	_data_->download = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	boxes_downloader_download_from_http_co (_data_);
}

void
boxes_downloader_download_from_http_finish (BoxesDownloader* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		BoxesDownloader* self;
		self = _data54_->self;
		_g_object_unref0 (_data54_->msg);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static void
__lambda16_ (Block54Data* _data54_)
{
	BoxesDownloader* self;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	self = _data54_->self;
	_tmp0_ = _data54_->msg;
	_tmp1_ = soup_message_get_response_headers (_tmp0_);
	_tmp2_ = _tmp1_;
	_data54_->total_num_bytes = soup_message_headers_get_content_length (_tmp2_);
}

static void
___lambda16__soup_message_got_headers (SoupMessage* _sender,
                                       gpointer self)
{
	__lambda16_ (self);
}

static void
boxes_downloader_download_from_http_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_download_from_http_co (_data_);
}

static gboolean
boxes_downloader_download_from_http_co (BoxesDownloaderDownloadFromHttpData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_data54_->self = g_object_ref (_data_->self);
	_data_->_data54_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->download->uri;
	_data_->_tmp1_ = soup_message_new ("GET", _data_->_tmp0_);
	_data_->_data54_->msg = _data_->_tmp1_;
	_data_->err = NULL;
	_data_->_data54_->total_num_bytes = (gint64) 0;
	_data_->_tmp2_ = _data_->_data54_->msg;
	g_signal_connect_data (_data_->_tmp2_, "got-headers", (GCallback) ___lambda16__soup_message_got_headers, block54_data_ref (_data_->_data54_), (GClosureNotify) block54_data_unref, 0);
	_data_->_tmp3_ = _data_->download->cached_file;
	_data_->_state_ = 1;
	g_file_replace_async (_data_->_tmp3_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, boxes_downloader_download_from_http_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = g_file_replace_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->cached_file_stream = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->err);
		block54_data_unref (_data_->_data54_);
		_data_->_data54_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->current_num_bytes = (gint64) 0;
	{
		_data_->_tmp5_ = _data_->self->priv->session;
		_data_->_tmp6_ = _data_->_data54_->msg;
		_data_->_state_ = 2;
		soup_session_send_async (_data_->_tmp5_, _data_->_tmp6_, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_downloader_download_from_http_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp7_ = soup_session_send_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->input_stream = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp8_ = g_new0 (guint8, 2048);
			_data_->buffer = _data_->_tmp8_;
			_data_->buffer_length1 = 2048;
			_data_->_buffer_size_ = _data_->buffer_length1;
			_data_->_tmp9_ = _data_->input_stream;
			_data_->_tmp10_ = _data_->buffer;
			_data_->_tmp10__length1 = _data_->buffer_length1;
			_data_->_state_ = 3;
			g_input_stream_read_async (_data_->_tmp9_, _data_->_tmp10_, (gsize) _data_->_tmp10__length1, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_downloader_download_from_http_ready, _data_);
			return FALSE;
			_state_3:
			_data_->num_read = g_input_stream_read_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_data_->buffer = (g_free (_data_->buffer), NULL);
				_g_object_unref0 (_data_->input_stream);
				goto __catch0_g_error;
			}
			if (_data_->num_read == ((gssize) 0)) {
				_data_->buffer = (g_free (_data_->buffer), NULL);
				break;
			}
			_vala_assert (_data_->num_read > ((gssize) 0), "num_read > 0");
			_data_->current_num_bytes += (gint64) _data_->num_read;
			_data_->_tmp11_ = (gint) _data_->num_read;
			_data_->buffer = g_renew (guint8, _data_->buffer, (gint) _data_->num_read);
			(_data_->_tmp11_ > _data_->buffer_length1) ? memset (_data_->buffer + _data_->buffer_length1, 0, sizeof (guint8) * (_data_->_tmp11_ - _data_->buffer_length1)) : NULL;
			_data_->buffer_length1 = _data_->_tmp11_;
			_data_->_buffer_size_ = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->cached_file_stream;
			_data_->_tmp13_ = _data_->buffer;
			_data_->_tmp13__length1 = _data_->buffer_length1;
			_data_->_tmp14_ = 0UL;
			_data_->_state_ = 4;
			g_output_stream_write_all_async ((GOutputStream*) _data_->_tmp12_, _data_->_tmp13_, (gsize) _data_->_tmp13__length1, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_downloader_download_from_http_ready, _data_);
			return FALSE;
			_state_4:
			g_output_stream_write_all_finish ((GOutputStream*) _data_->_tmp12_, _data_->_res_, &_data_->_tmp14_, &_data_->_inner_error0_);
			_data_->bytes_written = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_data_->buffer = (g_free (_data_->buffer), NULL);
				_g_object_unref0 (_data_->input_stream);
				goto __catch0_g_error;
			}
			if (_data_->_data54_->total_num_bytes > ((gint64) 0)) {
				_data_->_tmp15_ = _data_->download->progress;
				boxes_activity_progress_set_progress (_data_->_tmp15_, ((gdouble) _data_->current_num_bytes) / _data_->_data54_->total_num_bytes);
			}
			_data_->buffer = (g_free (_data_->buffer), NULL);
		}
		_data_->_tmp16_ = _data_->cached_file_stream;
		_data_->_state_ = 5;
		g_output_stream_close_async ((GOutputStream*) _data_->_tmp16_, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_downloader_download_from_http_ready, _data_);
		return FALSE;
		_state_5:
		g_output_stream_close_finish ((GOutputStream*) _data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->input_stream);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->input_stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
		_g_error_free0 (_data_->err);
		_data_->err = _data_->_tmp18_;
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cached_file_stream);
		_g_error_free0 (_data_->err);
		block54_data_unref (_data_->_data54_);
		_data_->_data54_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->_data54_->msg;
	g_object_get (_data_->_tmp20_, "status-code", &_data_->_tmp21_, NULL);
	_data_->_tmp22_ = _data_->_tmp21_;
	if (_data_->_tmp22_ != ((guint) SOUP_STATUS_OK)) {
		_data_->_tmp19_ = TRUE;
	} else {
		_data_->_tmp19_ = g_cancellable_is_cancelled (_data_->cancellable);
	}
	if (_data_->_tmp19_) {
		_data_->_tmp23_ = _data_->download->cached_file;
		g_file_delete (_data_->_tmp23_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->cached_file_stream);
			_g_error_free0 (_data_->err);
			block54_data_unref (_data_->_data54_);
			_data_->_data54_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->err;
		if (_data_->_tmp24_ == NULL) {
			_data_->_tmp25_ = _data_->_data54_->msg;
			g_object_get (_data_->_tmp25_, "status-code", &_data_->_tmp26_, NULL);
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = _data_->_data54_->msg;
			_data_->_tmp29_ = soup_message_get_reason_phrase (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = g_error_new ((GQuark) G_IO_ERROR, (gint) _data_->_tmp27_, "%s", _data_->_tmp30_);
			_g_error_free0 (_data_->err);
			_data_->err = _data_->_tmp31_;
		}
		_data_->_tmp32_ = _data_->err;
		_data_->_tmp33_ = _g_error_copy0 (_data_->_tmp32_);
		_data_->_inner_error0_ = _data_->_tmp33_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cached_file_stream);
		_g_error_free0 (_data_->err);
		block54_data_unref (_data_->_data54_);
		_data_->_data54_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->cached_file_stream);
	_g_error_free0 (_data_->err);
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloader_fetch_os_logo_data_free (gpointer _data)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->image);
	_g_object_unref0 (_data_->os);
	g_slice_free (BoxesDownloaderFetchOsLogoData, _data_);
}

void
boxes_downloader_fetch_os_logo (GtkImage* image,
                                OsinfoOs* os,
                                gint size,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	GtkImage* _tmp0_;
	OsinfoOs* _tmp1_;
	g_return_if_fail (image != NULL);
	g_return_if_fail (os != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderFetchOsLogoData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_fetch_os_logo_data_free);
	_tmp0_ = _g_object_ref0 (image);
	_g_object_unref0 (_data_->image);
	_data_->image = _tmp0_;
	_tmp1_ = _g_object_ref0 (os);
	_g_object_unref0 (_data_->os);
	_data_->os = _tmp1_;
	_data_->size = size;
	boxes_downloader_fetch_os_logo_co (_data_);
}

void
boxes_downloader_fetch_os_logo_finish (GAsyncResult* _res_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
boxes_downloader_fetch_os_logo_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_fetch_os_logo_co (_data_);
}

static gboolean
boxes_downloader_fetch_os_logo_co (BoxesDownloaderFetchOsLogoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = boxes_downloader_fetch_os_logo_url (_data_->os);
	_data_->logo_url = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->logo_url;
	if (_data_->_tmp1_ == NULL) {
		_g_free0 (_data_->logo_url);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = osinfo_product_get_name ((OsinfoProduct*) _data_->os);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->logo_url;
	g_debug ("downloader.vala:183: %s has logo '%s'.", _data_->_tmp3_, _data_->_tmp4_);
	_data_->_tmp5_ = _data_->logo_url;
	_data_->_tmp6_ = g_file_new_for_uri (_data_->_tmp5_);
	_data_->remote_file = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->remote_file;
	_data_->_tmp8_ = g_file_get_basename (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = boxes_get_system_logo_cache (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_free0 (_data_->_tmp9_);
	_data_->system_cached_path = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->remote_file;
	_data_->_tmp13_ = g_file_get_basename (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = boxes_get_logo_cache (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_g_free0 (_data_->_tmp14_);
	_data_->cached_path = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->cached_path;
	_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
	_data_->_tmp19_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp19_[0] = _data_->_tmp18_;
	_data_->cached_paths = _data_->_tmp19_;
	_data_->cached_paths_length1 = 1;
	_data_->_cached_paths_size_ = _data_->cached_paths_length1;
	_data_->_tmp20_ = _data_->system_cached_path;
	if (_data_->_tmp20_ != NULL) {
		_data_->_tmp21_ = _data_->system_cached_path;
		_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
		_vala_array_add15 (&_data_->cached_paths, &_data_->cached_paths_length1, &_data_->_cached_paths_size_, _data_->_tmp22_);
	}
	{
		_data_->_tmp23_ = boxes_downloader_get_default ();
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->remote_file;
		_data_->_tmp26_ = _data_->cached_paths;
		_data_->_tmp26__length1 = _data_->cached_paths_length1;
		_data_->_tmp27_ = boxes_activity_progress_new ();
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_state_ = 1;
		boxes_downloader_download (_data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_, (gint) _data_->_tmp26__length1, _data_->_tmp28_, NULL, boxes_downloader_fetch_os_logo_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp29_ = boxes_downloader_download_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp30_ = _data_->_tmp29_;
		_g_object_unref0 (_data_->_tmp28_);
		_g_object_unref0 (_data_->_tmp24_);
		_data_->cached_file = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp31_ = _data_->cached_file;
		_data_->_tmp32_ = g_file_get_path (_data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = gdk_pixbuf_new_from_file_at_size (_data_->_tmp33_, _data_->size, _data_->size, &_data_->_inner_error0_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_g_free0 (_data_->_tmp33_);
		_data_->pixbuf = _data_->_tmp35_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cached_file);
			goto __catch0_g_error;
		}
		_data_->_tmp36_ = _data_->pixbuf;
		gtk_image_set_from_pixbuf (_data_->image, _data_->_tmp36_);
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->cached_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp37_ = _data_->logo_url;
		_data_->_tmp38_ = _data_->_error_;
		_data_->_tmp39_ = _data_->_tmp38_->message;
		g_warning ("downloader.vala:198: Error loading logo file '%s': %s", _data_->_tmp37_, _data_->_tmp39_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->cached_paths = (_vala_array_free (_data_->cached_paths, _data_->cached_paths_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->cached_path);
		_g_free0 (_data_->system_cached_path);
		_g_object_unref0 (_data_->remote_file);
		_g_free0 (_data_->logo_url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->cached_paths = (_vala_array_free (_data_->cached_paths, _data_->cached_paths_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->cached_path);
	_g_free0 (_data_->system_cached_path);
	_g_object_unref0 (_data_->remote_file);
	_g_free0 (_data_->logo_url);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloader_fetch_media_data_free (gpointer _data)
{
	BoxesDownloaderFetchMediaData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->progress);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	g_slice_free (BoxesDownloaderFetchMediaData, _data_);
}

void
boxes_downloader_fetch_media (const gchar* uri,
                              const gchar* filename,
                              BoxesActivityProgress* progress,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BoxesDownloaderFetchMediaData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BoxesActivityProgress* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (progress != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderFetchMediaData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_fetch_media_data_free);
	_tmp0_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	_tmp2_ = _g_object_ref0 (progress);
	_g_object_unref0 (_data_->progress);
	_data_->progress = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	boxes_downloader_fetch_media_co (_data_);
}

gchar*
boxes_downloader_fetch_media_finish (GAsyncResult* _res_,
                                     GError** error)
{
	gchar* result;
	BoxesDownloaderFetchMediaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_downloader_fetch_media_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BoxesDownloaderFetchMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_fetch_media_co (_data_);
}

static gboolean
boxes_downloader_fetch_media_co (BoxesDownloaderFetchMediaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
	_data_->file = _data_->_tmp0_;
	_data_->basename = NULL;
	if (_data_->filename == NULL) {
		_data_->_tmp1_ = _data_->file;
		_data_->_tmp2_ = g_file_get_basename (_data_->_tmp1_);
		_g_free0 (_data_->basename);
		_data_->basename = _data_->_tmp2_;
	} else {
		_data_->_tmp3_ = g_strdup (_data_->filename);
		_g_free0 (_data_->basename);
		_data_->basename = _data_->_tmp3_;
	}
	_data_->_tmp6_ = _data_->basename;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp7_ = _data_->basename;
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp7_, "") == 0;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp4_ = TRUE;
	} else {
		_data_->_tmp8_ = _data_->basename;
		_data_->_tmp4_ = g_strcmp0 (_data_->_tmp8_, "/") == 0;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp9_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_FILENAME, "File name is either null, empty or '/'.");
		_data_->_inner_error0_ = _data_->_tmp9_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->basename);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = boxes_downloader_get_default ();
	_data_->downloader = _data_->_tmp10_;
	_data_->_tmp11_ = boxes_get_user_special_dir_with_fallback (G_USER_DIRECTORY_DOWNLOAD);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->basename;
	_data_->_tmp14_ = g_build_filename (_data_->_tmp12_, _data_->_tmp13_, NULL);
	_data_->_tmp15_ = _data_->_tmp14_;
	_g_free0 (_data_->_tmp12_);
	_data_->cache = _data_->_tmp15_;
	boxes_activity_progress_set_progress (_data_->progress, (gdouble) 0);
	g_debug ("downloader.vala:223: Downloading media from '%s' to '%s'.", _data_->uri, _data_->cache);
	_data_->_tmp16_ = _data_->file;
	_data_->_tmp17_ = g_strdup (_data_->cache);
	_data_->_tmp18_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp18_[0] = _data_->_tmp17_;
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp19__length1 = 1;
	_data_->_state_ = 1;
	boxes_downloader_download (_data_->downloader, _data_->_tmp16_, _data_->_tmp19_, (gint) 1, _data_->progress, _data_->cancellable, boxes_downloader_fetch_media_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp20_ = boxes_downloader_download_finish (_data_->downloader, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp21_ = _data_->_tmp20_;
	_g_object_unref0 (_data_->_tmp21_);
	_data_->_tmp19_ = (_vala_array_free (_data_->_tmp19_, _data_->_tmp19__length1, (GDestroyNotify) g_free), NULL);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cache);
		_g_object_unref0 (_data_->downloader);
		_g_free0 (_data_->basename);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	boxes_activity_progress_set_progress (_data_->progress, (gdouble) 1);
	_data_->result = _data_->cache;
	_g_object_unref0 (_data_->downloader);
	_g_free0 (_data_->basename);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloader_await_download_data_free (gpointer _data)
{
	BoxesDownloaderAwaitDownloadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->cached_path);
	_g_object_unref0 (_data_->progress);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesDownloaderAwaitDownloadData, _data_);
}

static void
boxes_downloader_await_download (BoxesDownloader* self,
                                 BoxesDownload* download,
                                 const gchar* cached_path,
                                 BoxesActivityProgress* progress,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BoxesDownloaderAwaitDownloadData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	gchar* _tmp2_;
	BoxesActivityProgress* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (download != NULL);
	g_return_if_fail (cached_path != NULL);
	g_return_if_fail (progress != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderAwaitDownloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_await_download_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _boxes_download_ref0 (download);
	_boxes_download_unref0 (_data_->download);
	_data_->download = _tmp1_;
	_tmp2_ = g_strdup (cached_path);
	_g_free0 (_data_->cached_path);
	_data_->cached_path = _tmp2_;
	_tmp3_ = _g_object_ref0 (progress);
	_g_object_unref0 (_data_->progress);
	_data_->progress = _tmp3_;
	boxes_downloader_await_download_co (_data_);
}

static GFile*
boxes_downloader_await_download_finish (BoxesDownloader* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GFile* result;
	BoxesDownloaderAwaitDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		BoxesDownloader* self;
		self = _data55_->self;
		(_data55_->callback_target_destroy_notify == NULL) ? NULL : (_data55_->callback_target_destroy_notify (_data55_->callback_target), NULL);
		_data55_->callback = NULL;
		_data55_->callback_target = NULL;
		_data55_->callback_target_destroy_notify = NULL;
		_g_error_free0 (_data55_->download_error);
		_g_object_unref0 (_data55_->downloaded_file);
		_boxes_download_unref0 (_data55_->download);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static gboolean
_boxes_downloader_await_download_co_gsource_func (gpointer self)
{
	gboolean result;
	result = boxes_downloader_await_download_co (self);
	return result;
}

static void
__lambda14_ (Block55Data* _data55_,
             BoxesDownloader* downloader,
             BoxesDownload* downloaded)
{
	BoxesDownloader* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	self = _data55_->self;
	g_return_if_fail (downloader != NULL);
	g_return_if_fail (downloaded != NULL);
	_tmp0_ = downloaded->uri;
	_tmp1_ = _data55_->download->uri;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		return;
	}
	_tmp2_ = downloaded->cached_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data55_->downloaded_file);
	_data55_->downloaded_file = _tmp3_;
	_data55_->callback (_data55_->callback_target);
}

static void
___lambda14__boxes_downloader_downloaded (BoxesDownloader* _sender,
                                          BoxesDownload* download,
                                          gpointer self)
{
	__lambda14_ (self, _sender, download);
}

static void
__lambda15_ (Block55Data* _data55_,
             BoxesDownloader* downloader,
             BoxesDownload* failed_download,
             GError* _error_)
{
	BoxesDownloader* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	self = _data55_->self;
	g_return_if_fail (downloader != NULL);
	g_return_if_fail (failed_download != NULL);
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = failed_download->uri;
	_tmp1_ = _data55_->download->uri;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		return;
	}
	_tmp2_ = _g_error_copy0 (_error_);
	_g_error_free0 (_data55_->download_error);
	_data55_->download_error = _tmp2_;
	_data55_->callback (_data55_->callback_target);
}

static void
___lambda15__boxes_downloader_download_failed (BoxesDownloader* _sender,
                                               BoxesDownload* download,
                                               GError* _error_,
                                               gpointer self)
{
	__lambda15_ (self, _sender, download, _error_);
}

static void
boxes_downloader_await_download_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BoxesDownloaderAwaitDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_await_download_co (_data_);
}

static gboolean
boxes_downloader_await_download_co (BoxesDownloaderAwaitDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data55_ = g_slice_new0 (Block55Data);
	_data_->_data55_->_ref_count_ = 1;
	_data_->_data55_->self = g_object_ref (_data_->self);
	_boxes_download_unref0 (_data_->_data55_->download);
	_data_->_data55_->download = _data_->download;
	_data_->_data55_->_async_data_ = _data_;
	_data_->_data55_->downloaded_file = NULL;
	_data_->_data55_->download_error = NULL;
	_data_->_tmp0_ = _data_->_data55_->download->progress;
	g_object_bind_property_with_closures ((GObject*) _data_->_tmp0_, "progress", (GObject*) _data_->progress, "progress", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_data_->_data55_->callback = _boxes_downloader_await_download_co_gsource_func;
	_data_->_data55_->callback_target = _data_;
	_data_->_data55_->callback_target_destroy_notify = NULL;
	_data_->_tmp1_ = g_signal_connect_data (_data_->self, "downloaded", (GCallback) ___lambda14__boxes_downloader_downloaded, block55_data_ref (_data_->_data55_), (GClosureNotify) block55_data_unref, 0);
	_data_->downloaded_id = _data_->_tmp1_;
	_data_->_tmp2_ = g_signal_connect_data (_data_->self, "download-failed", (GCallback) ___lambda15__boxes_downloader_download_failed, block55_data_ref (_data_->_data55_), (GClosureNotify) block55_data_unref, 0);
	_data_->downloaded_failed_id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->_data55_->download->uri;
	g_debug ("downloader.vala:253: '%s' already being downloaded. Waiting for downlo" \
"ad to complete..", _data_->_tmp3_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp4_ = _data_->_data55_->download->uri;
	g_debug ("downloader.vala:255: Finished waiting for '%s' to download.", _data_->_tmp4_);
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->downloaded_id);
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->downloaded_failed_id);
	if (_data_->_data55_->download_error != NULL) {
		_data_->_tmp5_ = _g_error_copy0 (_data_->_data55_->download_error);
		_data_->_inner_error0_ = _data_->_tmp5_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block55_data_unref (_data_->_data55_);
		_data_->_data55_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = g_file_get_path (_data_->_data55_->downloaded_file);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = g_strcmp0 (_data_->_tmp7_, _data_->cached_path) != 0;
	_g_free0 (_data_->_tmp7_);
	if (_data_->_tmp8_) {
		_data_->_tmp9_ = g_file_new_for_path (_data_->cached_path);
		_g_object_unref0 (_data_->cached_file);
		_data_->cached_file = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->cached_file;
		_data_->_state_ = 2;
		g_file_copy_async (_data_->_data55_->downloaded_file, _data_->_tmp10_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, boxes_downloader_await_download_ready, _data_);
		return FALSE;
		_state_2:
		g_file_copy_finish (_data_->_data55_->downloaded_file, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->cached_file);
			block55_data_unref (_data_->_data55_);
			_data_->_data55_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp11_ = _g_object_ref0 (_data_->_data55_->downloaded_file);
		_g_object_unref0 (_data_->cached_file);
		_data_->cached_file = _data_->_tmp11_;
	}
	_data_->result = _data_->cached_file;
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloader_download_from_filesystem_data_free (gpointer _data)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesDownloaderDownloadFromFilesystemData, _data_);
}

static void
boxes_downloader_download_from_filesystem (BoxesDownloader* self,
                                           BoxesDownload* download,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (download != NULL);
	_data_ = g_slice_new0 (BoxesDownloaderDownloadFromFilesystemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_from_filesystem_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _boxes_download_ref0 (download);
	_boxes_download_unref0 (_data_->download);
	_data_->download = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	boxes_downloader_download_from_filesystem_co (_data_);
}

static void
boxes_downloader_download_from_filesystem_finish (BoxesDownloader* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		BoxesDownloader* self;
		self = _data56_->self;
		_boxes_download_unref0 (_data56_->download);
		_g_object_unref0 (self);
		g_slice_free (Block56Data, _data56_);
	}
}

static void
___lambda17_ (Block56Data* _data56_,
              gint64 current,
              gint64 total)
{
	BoxesDownloader* self;
	BoxesActivityProgress* _tmp0_;
	self = _data56_->self;
	_tmp0_ = _data56_->download->progress;
	boxes_activity_progress_set_progress (_tmp0_, ((gdouble) current) / total);
}

static void
____lambda17__gfile_progress_callback (gint64 current_num_bytes,
                                       gint64 total_num_bytes,
                                       gpointer self)
{
	___lambda17_ (self, current_num_bytes, total_num_bytes);
}

static void
boxes_downloader_download_from_filesystem_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloader_download_from_filesystem_co (_data_);
}

static gboolean
boxes_downloader_download_from_filesystem_co (BoxesDownloaderDownloadFromFilesystemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_data56_->self = g_object_ref (_data_->self);
	_boxes_download_unref0 (_data_->_data56_->download);
	_data_->_data56_->download = _data_->download;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->_data56_->download->remote_file;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->src_file = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->_data56_->download->cached_file;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->dest_file = _data_->_tmp3_;
	{
		_data_->_tmp4_ = g_file_get_path (_data_->src_file);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_file_get_path (_data_->dest_file);
		_data_->_tmp7_ = _data_->_tmp6_;
		g_debug ("downloader.vala:278: Copying '%s' to '%s'..", _data_->_tmp5_, _data_->_tmp7_);
		_g_free0 (_data_->_tmp7_);
		_g_free0 (_data_->_tmp5_);
		_data_->_state_ = 1;
		g_file_copy_async (_data_->src_file, _data_->dest_file, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, _data_->cancellable, ____lambda17__gfile_progress_callback, _data_->_data56_, boxes_downloader_download_from_filesystem_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->src_file, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __finally0;
		}
		_data_->_tmp8_ = g_file_get_path (_data_->src_file);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_file_get_path (_data_->dest_file);
		_data_->_tmp11_ = _data_->_tmp10_;
		g_debug ("downloader.vala:286: Copied '%s' to '%s'.", _data_->_tmp9_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp11_);
		_g_free0 (_data_->_tmp9_);
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dest_file);
		_g_object_unref0 (_data_->src_file);
		block56_data_unref (_data_->_data56_);
		_data_->_data56_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->dest_file);
	_g_object_unref0 (_data_->src_file);
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GFile*
boxes_downloader_get_cached_file (BoxesDownloader* self,
                                  GFile* remote_file,
                                  gchar** cached_paths,
                                  gint cached_paths_length1)
{
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (remote_file != NULL, NULL);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = cached_paths;
		path_collection_length1 = cached_paths_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp0_;
			gchar* path = NULL;
			_tmp0_ = g_strdup (path_collection[path_it]);
			path = _tmp0_;
			{
				GFile* cached_file = NULL;
				const gchar* _tmp1_;
				GFile* _tmp2_;
				GFile* _tmp3_;
				_tmp1_ = path;
				_tmp2_ = g_file_new_for_path (_tmp1_);
				cached_file = _tmp2_;
				_tmp3_ = cached_file;
				if (g_file_query_exists (_tmp3_, NULL)) {
					gchar* _tmp4_;
					gchar* _tmp5_;
					const gchar* _tmp6_;
					_tmp4_ = g_file_get_uri (remote_file);
					_tmp5_ = _tmp4_;
					_tmp6_ = path;
					g_debug ("downloader.vala:294: '%s' already available locally at '%s'. Not downl" \
"oading.", _tmp5_, _tmp6_);
					_g_free0 (_tmp5_);
					result = cached_file;
					_g_free0 (path);
					return result;
				}
				_g_object_unref0 (cached_file);
				_g_free0 (path);
			}
		}
	}
	result = NULL;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXES_DOWNLOAD) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXES_DOWNLOAD callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXES_DOWNLOAD) (marshal_data ? marshal_data : cc->callback);
	callback (data1, boxes_value_get_download (param_values + 1), data2);
}

static void
g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_BOXED (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXES_DOWNLOAD_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXES_DOWNLOAD_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXES_DOWNLOAD_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, boxes_value_get_download (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
boxes_downloader_class_init (BoxesDownloaderClass * klass,
                             gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	boxes_downloader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesDownloader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_downloader_finalize;
	boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOADED_SIGNAL] = g_signal_new ("downloaded", BOXES_TYPE_DOWNLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD, G_TYPE_NONE, 1, BOXES_TYPE_DOWNLOAD);
	boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL] = g_signal_new ("download-failed", BOXES_TYPE_DOWNLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_BOXED, G_TYPE_NONE, 2, BOXES_TYPE_DOWNLOAD, G_TYPE_ERROR);
	_tmp0_ = g_strdup ("http");
	_tmp1_ = g_strdup ("https");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	boxes_downloader_supported_schemes = _tmp2_;
	boxes_downloader_supported_schemes_length1 = 2;
	_boxes_downloader_supported_schemes_size_ = boxes_downloader_supported_schemes_length1;
}

static void
boxes_downloader_instance_init (BoxesDownloader * self,
                                gpointer klass)
{
	self->priv = boxes_downloader_get_instance_private (self);
}

static void
boxes_downloader_finalize (GObject * obj)
{
	BoxesDownloader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOADER, BoxesDownloader);
	_g_object_unref0 (self->priv->session);
	_g_hash_table_unref0 (self->priv->downloads);
	G_OBJECT_CLASS (boxes_downloader_parent_class)->finalize (obj);
}

static GType
boxes_downloader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_downloader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownloader), 0, (GInstanceInitFunc) boxes_downloader_instance_init, NULL };
	GType boxes_downloader_type_id;
	boxes_downloader_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesDownloader", &g_define_type_info, 0);
	BoxesDownloader_private_offset = g_type_add_instance_private (boxes_downloader_type_id, sizeof (BoxesDownloaderPrivate));
	return boxes_downloader_type_id;
}

GType
boxes_downloader_get_type (void)
{
	static volatile gsize boxes_downloader_type_id__once = 0;
	if (g_once_init_enter (&boxes_downloader_type_id__once)) {
		GType boxes_downloader_type_id;
		boxes_downloader_type_id = boxes_downloader_get_type_once ();
		g_once_init_leave (&boxes_downloader_type_id__once, boxes_downloader_type_id);
	}
	return boxes_downloader_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

