/* downloads-hub.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from downloads-hub.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <handy.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "common.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <osinfo/osinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_DOWNLOADS_HUB (boxes_downloads_hub_get_type ())
#define BOXES_DOWNLOADS_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOADS_HUB, BoxesDownloadsHub))
#define BOXES_DOWNLOADS_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOADS_HUB, BoxesDownloadsHubClass))
#define BOXES_IS_DOWNLOADS_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOADS_HUB))
#define BOXES_IS_DOWNLOADS_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOADS_HUB))
#define BOXES_DOWNLOADS_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOADS_HUB, BoxesDownloadsHubClass))

typedef struct _BoxesDownloadsHub BoxesDownloadsHub;
typedef struct _BoxesDownloadsHubClass BoxesDownloadsHubClass;
typedef struct _BoxesDownloadsHubPrivate BoxesDownloadsHubPrivate;
enum  {
	BOXES_DOWNLOADS_HUB_0_PROPERTY,
	BOXES_DOWNLOADS_HUB_NUM_PROPERTIES
};
static GParamSpec* boxes_downloads_hub_properties[BOXES_DOWNLOADS_HUB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_ASSISTANT_MEDIA_ENTRY (boxes_assistant_media_entry_get_type ())
#define BOXES_ASSISTANT_MEDIA_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ASSISTANT_MEDIA_ENTRY, BoxesAssistantMediaEntry))
#define BOXES_ASSISTANT_MEDIA_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ASSISTANT_MEDIA_ENTRY, BoxesAssistantMediaEntryClass))
#define BOXES_IS_ASSISTANT_MEDIA_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ASSISTANT_MEDIA_ENTRY))
#define BOXES_IS_ASSISTANT_MEDIA_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ASSISTANT_MEDIA_ENTRY))
#define BOXES_ASSISTANT_MEDIA_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ASSISTANT_MEDIA_ENTRY, BoxesAssistantMediaEntryClass))

typedef struct _BoxesAssistantMediaEntry BoxesAssistantMediaEntry;
typedef struct _BoxesAssistantMediaEntryClass BoxesAssistantMediaEntryClass;

#define BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY (boxes_assistant_downloadable_entry_get_type ())
#define BOXES_ASSISTANT_DOWNLOADABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY, BoxesAssistantDownloadableEntry))
#define BOXES_ASSISTANT_DOWNLOADABLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY, BoxesAssistantDownloadableEntryClass))
#define BOXES_IS_ASSISTANT_DOWNLOADABLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY))
#define BOXES_IS_ASSISTANT_DOWNLOADABLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY))
#define BOXES_ASSISTANT_DOWNLOADABLE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ASSISTANT_DOWNLOADABLE_ENTRY, BoxesAssistantDownloadableEntryClass))

typedef struct _BoxesAssistantDownloadableEntry BoxesAssistantDownloadableEntry;
typedef struct _BoxesAssistantDownloadableEntryClass BoxesAssistantDownloadableEntryClass;
typedef struct _Block28Data Block28Data;

#define BOXES_TYPE_DOWNLOADS_HUB_ROW (boxes_downloads_hub_row_get_type ())
#define BOXES_DOWNLOADS_HUB_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOADS_HUB_ROW, BoxesDownloadsHubRow))
#define BOXES_DOWNLOADS_HUB_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOADS_HUB_ROW, BoxesDownloadsHubRowClass))
#define BOXES_IS_DOWNLOADS_HUB_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOADS_HUB_ROW))
#define BOXES_IS_DOWNLOADS_HUB_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOADS_HUB_ROW))
#define BOXES_DOWNLOADS_HUB_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOADS_HUB_ROW, BoxesDownloadsHubRowClass))

typedef struct _BoxesDownloadsHubRow BoxesDownloadsHubRow;
typedef struct _BoxesDownloadsHubRowClass BoxesDownloadsHubRowClass;

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BoxesDownloadsHubRowPrivate BoxesDownloadsHubRowPrivate;
enum  {
	BOXES_DOWNLOADS_HUB_ROW_0_PROPERTY,
	BOXES_DOWNLOADS_HUB_ROW_NUM_PROPERTIES
};
static GParamSpec* boxes_downloads_hub_row_properties[BOXES_DOWNLOADS_HUB_ROW_NUM_PROPERTIES];
typedef struct _BoxesAssistantMediaEntryPrivate BoxesAssistantMediaEntryPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesAssistantDownloadableEntryPrivate BoxesAssistantDownloadableEntryPrivate;
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))

#define BOXES_TYPE_TOAST (boxes_toast_get_type ())
#define BOXES_TOAST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST, BoxesToast))
#define BOXES_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST, BoxesToastClass))
#define BOXES_IS_TOAST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST))
#define BOXES_IS_TOAST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST))
#define BOXES_TOAST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST, BoxesToastClass))

typedef struct _BoxesToast BoxesToast;
typedef struct _BoxesToastClass BoxesToastClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesDownloadsHubRowDownloadData BoxesDownloadsHubRowDownloadData;
enum  {
	BOXES_DOWNLOADS_HUB_ROW_DOWNLOAD_COMPLETE_SIGNAL,
	BOXES_DOWNLOADS_HUB_ROW_NUM_SIGNALS
};
static guint boxes_downloads_hub_row_signals[BOXES_DOWNLOADS_HUB_ROW_NUM_SIGNALS] = {0};

struct _BoxesDownloadsHub {
	GtkPopover parent_instance;
	BoxesDownloadsHubPrivate * priv;
};

struct _BoxesDownloadsHubClass {
	GtkPopoverClass parent_class;
};

struct _BoxesDownloadsHubPrivate {
	GtkListBox* listbox;
	guint n_items;
	guint redraw_progress_pie_id;
};

struct _Block28Data {
	int _ref_count_;
	BoxesDownloadsHub* self;
	GtkWidget* drawing_area;
};

struct _BoxesDownloadsHubRow {
	GtkListBoxRow parent_instance;
	BoxesDownloadsHubRowPrivate * priv;
	BoxesActivityProgress* progress;
	gchar* local_file;
	gboolean complete;
};

struct _BoxesDownloadsHubRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BoxesDownloadsHubRowPrivate {
	GtkLabel* label;
	GtkImage* image;
	GtkStack* download_status;
	GtkProgressBar* progress_bar;
	GtkLabel* download_complete_label;
	gulong progress_notify_id;
	GCancellable* cancellable;
};

struct _BoxesAssistantMediaEntry {
	HdyActionRow parent_instance;
	BoxesAssistantMediaEntryPrivate * priv;
	BoxesInstallerMedia* media;
	GtkImage* media_image;
};

struct _BoxesAssistantMediaEntryClass {
	HdyActionRowClass parent_class;
};

struct _BoxesAssistantDownloadableEntry {
	BoxesAssistantMediaEntry parent_instance;
	BoxesAssistantDownloadableEntryPrivate * priv;
	OsinfoOs* os;
	gchar* url;
};

struct _BoxesAssistantDownloadableEntryClass {
	BoxesAssistantMediaEntryClass parent_class;
};

struct _BoxesDownloadsHubRowDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloadsHubRow* self;
	gchar* url;
	gchar* filename;
	gchar* _tmp0_;
	BoxesActivityProgress* _tmp1_;
	GCancellable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _error_;
	BoxesApp* _tmp5_;
	BoxesAppWindow* _tmp6_;
	BoxesAppWindow* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BoxesToast* _tmp12_;
	BoxesToast* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GCancellable* _tmp16_;
	GtkLabel* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkStack* _tmp21_;
	GtkLabel* _tmp22_;
	GError* _inner_error0_;
};

static gint BoxesDownloadsHub_private_offset;
static gpointer boxes_downloads_hub_parent_class = NULL;
static BoxesDownloadsHub* boxes_downloads_hub_instance;
static BoxesDownloadsHub* boxes_downloads_hub_instance = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;
static gint BoxesDownloadsHubRow_private_offset;
static gpointer boxes_downloads_hub_row_parent_class = NULL;

VALA_EXTERN GType boxes_downloads_hub_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDownloadsHub, g_object_unref)
VALA_EXTERN BoxesDownloadsHub* boxes_downloads_hub_get_default (void);
VALA_EXTERN BoxesDownloadsHub* boxes_downloads_hub_new (void);
VALA_EXTERN BoxesDownloadsHub* boxes_downloads_hub_construct (GType object_type);
VALA_EXTERN GType boxes_assistant_media_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAssistantMediaEntry, g_object_unref)
VALA_EXTERN GType boxes_assistant_downloadable_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAssistantDownloadableEntry, g_object_unref)
VALA_EXTERN void boxes_downloads_hub_add_item (BoxesDownloadsHub* self,
                                   BoxesAssistantDownloadableEntry* entry);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
VALA_EXTERN GType boxes_downloads_hub_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDownloadsHubRow, g_object_unref)
VALA_EXTERN BoxesDownloadsHubRow* boxes_downloads_hub_row_new_from_entry (BoxesAssistantDownloadableEntry* entry);
VALA_EXTERN BoxesDownloadsHubRow* boxes_downloads_hub_row_construct_from_entry (GType object_type,
                                                                    BoxesAssistantDownloadableEntry* entry);
static GtkWidget* boxes_downloads_hub_get_button (BoxesDownloadsHub* self);
static gboolean boxes_downloads_hub_draw_button_pie (BoxesDownloadsHub* self,
                                              GtkWidget* drawing_area,
                                              cairo_t* context);
static gboolean _boxes_downloads_hub_draw_button_pie_gtk_widget_draw (GtkWidget* _sender,
                                                               cairo_t* cr,
                                                               gpointer self);
static void boxes_downloads_hub_on_row_deleted (BoxesDownloadsHub* self);
static void _boxes_downloads_hub_on_row_deleted_gtk_widget_destroy (GtkWidget* _sender,
                                                             gpointer self);
static void boxes_downloads_hub_on_download_complete (BoxesDownloadsHub* self,
                                               const gchar* label,
                                               const gchar* path);
static void _boxes_downloads_hub_on_download_complete_boxes_downloads_hub_row_download_complete (BoxesDownloadsHubRow* _sender,
                                                                                          const gchar* label,
                                                                                          const gchar* path,
                                                                                          gpointer self);
static gboolean boxes_downloads_hub_get_ongoing_downloads (BoxesDownloadsHub* self);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN void boxes_app_inhibit (BoxesApp* self,
                        GtkWindow* window,
                        GtkApplicationInhibitFlags* flags,
                        const gchar* reason);
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
VALA_EXTERN BoxesAppWindow* boxes_app_get_main_window (BoxesApp* self);
static gboolean ___lambda50_ (Block28Data* _data28_);
static gboolean ____lambda50__gsource_func (gpointer self);
VALA_EXTERN void boxes_app_send_notification (BoxesApp* self,
                                  const gchar* notification_id,
                                  GNotification* notification);
VALA_EXTERN void boxes_app_uninhibit (BoxesApp* self);
VALA_EXTERN void boxes_app_window_show_vm_assistant (BoxesAppWindow* self,
                                         const gchar* path);
static void boxes_downloads_hub_on_row_activated (BoxesDownloadsHub* self,
                                           GtkListBoxRow* _row);
static void _boxes_downloads_hub_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self);
static gdouble boxes_downloads_hub_get_progress (BoxesDownloadsHub* self);
static void boxes_downloads_hub_finalize (GObject * obj);
static GType boxes_downloads_hub_get_type_once (void);
static void _vala_boxes_downloads_hub_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN void boxes_downloader_fetch_os_logo (GtkImage* image,
                                     OsinfoOs* os,
                                     gint size,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void boxes_downloader_fetch_os_logo_finish (GAsyncResult* _res_);
VALA_EXTERN GType boxes_installer_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstallerMedia, g_object_unref)
static void __lambda18_ (BoxesDownloadsHubRow* self);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void boxes_downloads_hub_row_download (BoxesDownloadsHubRow* self,
                                       const gchar* url,
                                       const gchar* filename,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void boxes_downloads_hub_row_download_finish (BoxesDownloadsHubRow* self,
                                              GAsyncResult* _res_);
VALA_EXTERN GType boxes_toast_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToast, g_object_unref)
VALA_EXTERN void boxes_app_window_display_toast (BoxesAppWindow* self,
                                     BoxesToast* toast);
VALA_EXTERN BoxesToast* boxes_toast_new (const gchar* message);
VALA_EXTERN BoxesToast* boxes_toast_construct (GType object_type,
                                   const gchar* message);
static void boxes_downloads_hub_row_download_data_free (gpointer _data);
static gboolean boxes_downloads_hub_row_download_co (BoxesDownloadsHubRowDownloadData* _data_);
VALA_EXTERN void boxes_downloader_fetch_media (const gchar* uri,
                                   const gchar* filename,
                                   BoxesActivityProgress* progress,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* boxes_downloader_fetch_media_finish (GAsyncResult* _res_,
                                            GError** error);
static void boxes_downloads_hub_row_download_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void boxes_downloads_hub_row_cancel_download (BoxesDownloadsHubRow* self);
static void _boxes_downloads_hub_row_cancel_download_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
VALA_EXTERN BoxesDownloadsHubRow* boxes_downloads_hub_row_new (void);
VALA_EXTERN BoxesDownloadsHubRow* boxes_downloads_hub_row_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void boxes_downloads_hub_row_finalize (GObject * obj);
static GType boxes_downloads_hub_row_get_type_once (void);

static inline gpointer
boxes_downloads_hub_get_instance_private (BoxesDownloadsHub* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesDownloadsHub_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BoxesDownloadsHub*
boxes_downloads_hub_get_default (void)
{
	BoxesDownloadsHub* _tmp0_;
	BoxesDownloadsHub* _tmp2_;
	BoxesDownloadsHub* _tmp3_;
	BoxesDownloadsHub* result;
	_tmp0_ = boxes_downloads_hub_instance;
	if (_tmp0_ == NULL) {
		BoxesDownloadsHub* _tmp1_;
		_tmp1_ = boxes_downloads_hub_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (boxes_downloads_hub_instance);
		boxes_downloads_hub_instance = _tmp1_;
	}
	_tmp2_ = boxes_downloads_hub_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		BoxesDownloadsHub* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->drawing_area);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static gboolean
_boxes_downloads_hub_draw_button_pie_gtk_widget_draw (GtkWidget* _sender,
                                                      cairo_t* cr,
                                                      gpointer self)
{
	gboolean result;
	result = boxes_downloads_hub_draw_button_pie ((BoxesDownloadsHub*) self, _sender, cr);
	return result;
}

static void
_boxes_downloads_hub_on_row_deleted_gtk_widget_destroy (GtkWidget* _sender,
                                                        gpointer self)
{
	boxes_downloads_hub_on_row_deleted ((BoxesDownloadsHub*) self);
}

static void
_boxes_downloads_hub_on_download_complete_boxes_downloads_hub_row_download_complete (BoxesDownloadsHubRow* _sender,
                                                                                     const gchar* label,
                                                                                     const gchar* path,
                                                                                     gpointer self)
{
	boxes_downloads_hub_on_download_complete ((BoxesDownloadsHub*) self, label, path);
}

static gboolean
___lambda50_ (Block28Data* _data28_)
{
	BoxesDownloadsHub* self;
	GtkWidget* _tmp0_;
	gboolean result;
	self = _data28_->self;
	_tmp0_ = _data28_->drawing_area;
	gtk_widget_queue_draw (_tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda50__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda50_ (self);
	return result;
}

void
boxes_downloads_hub_add_item (BoxesDownloadsHub* self,
                              BoxesAssistantDownloadableEntry* entry)
{
	Block28Data* _data28_;
	BoxesDownloadsHubRow* row = NULL;
	BoxesDownloadsHubRow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkBin* bin = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkBin* _tmp9_;
	GtkBin* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	BoxesDownloadsHubRow* _tmp14_;
	BoxesDownloadsHubRow* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkListBox* _tmp24_;
	BoxesDownloadsHubRow* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	self->priv->n_items = self->priv->n_items + 1;
	_tmp0_ = boxes_downloads_hub_row_new_from_entry (entry);
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = boxes_downloads_hub_get_button (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_visible (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = boxes_downloads_hub_get_button (self);
		_tmp6_ = _tmp5_;
		gtk_widget_set_visible (_tmp6_, TRUE);
	}
	_tmp7_ = boxes_downloads_hub_get_button (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp8_) : NULL);
	bin = _tmp9_;
	_tmp10_ = bin;
	_tmp11_ = gtk_bin_get_child (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_data28_->drawing_area = _tmp12_;
	_tmp13_ = _data28_->drawing_area;
	g_signal_connect_object (_tmp13_, "draw", (GCallback) _boxes_downloads_hub_draw_button_pie_gtk_widget_draw, self, 0);
	_tmp14_ = row;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "destroy", (GCallback) _boxes_downloads_hub_on_row_deleted_gtk_widget_destroy, self, 0);
	_tmp15_ = row;
	g_signal_connect_object (_tmp15_, "download-complete", (GCallback) _boxes_downloads_hub_on_download_complete_boxes_downloads_hub_row_download_complete, self, 0);
	_tmp16_ = boxes_downloads_hub_get_ongoing_downloads (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		gchar* reason = NULL;
		gchar* _tmp18_;
		BoxesApp* _tmp19_;
		BoxesApp* _tmp20_;
		BoxesAppWindow* _tmp21_;
		BoxesAppWindow* _tmp22_;
		const gchar* _tmp23_;
		_tmp18_ = g_strdup (_ ("Downloading media"));
		reason = _tmp18_;
		_tmp19_ = boxes_app_app;
		_tmp20_ = boxes_app_app;
		_tmp21_ = boxes_app_get_main_window (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = reason;
		boxes_app_inhibit (_tmp19_, (GtkWindow*) _tmp22_, NULL, _tmp23_);
		self->priv->redraw_progress_pie_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda50__gsource_func, block28_data_ref (_data28_), block28_data_unref);
		_g_free0 (reason);
	}
	_tmp24_ = self->priv->listbox;
	_tmp25_ = row;
	gtk_list_box_prepend (_tmp24_, (GtkWidget*) _tmp25_);
	gtk_popover_popup ((GtkPopover*) self);
	_g_object_unref0 (bin);
	_g_object_unref0 (row);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static void
boxes_downloads_hub_on_row_deleted (BoxesDownloadsHub* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->n_items = self->priv->n_items - 1;
	_tmp0_ = boxes_downloads_hub_get_ongoing_downloads (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = boxes_downloads_hub_get_button (self);
		_tmp3_ = _tmp2_;
		gtk_widget_set_visible (_tmp3_, FALSE);
		g_source_remove (self->priv->redraw_progress_pie_id);
	}
}

static void
boxes_downloads_hub_on_download_complete (BoxesDownloadsHub* self,
                                          const gchar* label,
                                          const gchar* path)
{
	gchar* msg = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	const gchar* _tmp1_;
	GNotification* _tmp2_;
	GNotification* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BoxesApp* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GNotification* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup_printf (_ ("“%s” download complete"), label);
	msg = _tmp0_;
	_tmp1_ = msg;
	_tmp2_ = g_notification_new (_tmp1_);
	notification = _tmp2_;
	_tmp3_ = notification;
	_tmp4_ = g_strconcat ("app.install::", path, NULL);
	_tmp5_ = _tmp4_;
	g_notification_add_button (_tmp3_, _ ("Install"), _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = boxes_app_app;
	_tmp7_ = g_strconcat ("downloaded-", label, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = notification;
	boxes_app_send_notification (_tmp6_, _tmp8_, _tmp9_);
	_g_free0 (_tmp8_);
	_tmp10_ = boxes_downloads_hub_get_ongoing_downloads (self);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		BoxesApp* _tmp12_;
		_tmp12_ = boxes_app_app;
		boxes_app_uninhibit (_tmp12_);
	}
	if (self->priv->n_items == ((guint) 1)) {
		BoxesDownloadsHubRow* row = NULL;
		GtkListBox* _tmp13_;
		GtkListBoxRow* _tmp14_;
		BoxesDownloadsHubRow* _tmp15_;
		BoxesApp* _tmp16_;
		BoxesAppWindow* _tmp17_;
		BoxesAppWindow* _tmp18_;
		BoxesDownloadsHubRow* _tmp19_;
		const gchar* _tmp20_;
		GtkListBox* _tmp21_;
		BoxesDownloadsHubRow* _tmp22_;
		_tmp13_ = self->priv->listbox;
		_tmp14_ = gtk_list_box_get_row_at_index (_tmp13_, 0);
		_tmp15_ = _g_object_ref0 (BOXES_IS_DOWNLOADS_HUB_ROW (_tmp14_) ? ((BoxesDownloadsHubRow*) _tmp14_) : NULL);
		row = _tmp15_;
		gtk_popover_popdown ((GtkPopover*) self);
		_tmp16_ = boxes_app_app;
		_tmp17_ = boxes_app_get_main_window (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = row;
		_tmp20_ = _tmp19_->local_file;
		boxes_app_window_show_vm_assistant (_tmp18_, _tmp20_);
		_tmp21_ = self->priv->listbox;
		_tmp22_ = row;
		gtk_container_remove ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
		_g_object_unref0 (row);
	}
	_g_object_unref0 (notification);
	_g_free0 (msg);
}

static void
boxes_downloads_hub_on_row_activated (BoxesDownloadsHub* self,
                                      GtkListBoxRow* _row)
{
	BoxesDownloadsHubRow* row = NULL;
	BoxesDownloadsHubRow* _tmp0_;
	BoxesDownloadsHubRow* _tmp1_;
	BoxesDownloadsHubRow* _tmp2_;
	const gchar* _tmp3_;
	BoxesDownloadsHubRow* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_row != NULL);
	_tmp0_ = _g_object_ref0 (BOXES_IS_DOWNLOADS_HUB_ROW (_row) ? ((BoxesDownloadsHubRow*) _row) : NULL);
	row = _tmp0_;
	_tmp1_ = row;
	if (!_tmp1_->complete) {
		_g_object_unref0 (row);
		return;
	}
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp2_ = row;
	_tmp3_ = _tmp2_->local_file;
	if (_tmp3_ != NULL) {
		BoxesApp* _tmp4_;
		BoxesAppWindow* _tmp5_;
		BoxesAppWindow* _tmp6_;
		BoxesDownloadsHubRow* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = boxes_app_app;
		_tmp5_ = boxes_app_get_main_window (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = row;
		_tmp8_ = _tmp7_->local_file;
		boxes_app_window_show_vm_assistant (_tmp6_, _tmp8_);
	}
	_tmp9_ = row;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
	_g_object_unref0 (row);
}

static void
_boxes_downloads_hub_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self)
{
	boxes_downloads_hub_on_row_activated ((BoxesDownloadsHub*) self, row);
}

static gboolean
boxes_downloads_hub_draw_button_pie (BoxesDownloadsHub* self,
                                     GtkWidget* drawing_area,
                                     cairo_t* context)
{
	gint width = 0;
	gint height = 0;
	GtkStyleContext* style_context = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GdkRGBA foreground = {0};
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	GdkRGBA background = {0};
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	gdouble radians = 0.0;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (drawing_area != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	width = gtk_widget_get_allocated_width (drawing_area);
	height = gtk_widget_get_allocated_height (drawing_area);
	cairo_set_line_join (context, CAIRO_LINE_JOIN_ROUND);
	_tmp0_ = boxes_downloads_hub_get_button (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_style_context (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style_context = _tmp3_;
	_tmp4_ = boxes_downloads_hub_get_button (self);
	_tmp5_ = _tmp4_;
	gtk_style_context_get_color (style_context, gtk_widget_get_state_flags (_tmp5_), &_tmp6_);
	foreground = _tmp6_;
	_tmp7_ = foreground;
	background = _tmp7_;
	background.alpha = background.alpha * 0.3;
	_tmp8_ = background;
	_tmp9_ = background;
	_tmp10_ = background;
	_tmp11_ = background;
	cairo_set_source_rgba (context, _tmp8_.red, _tmp9_.green, _tmp10_.blue, _tmp11_.alpha);
	cairo_arc (context, (gdouble) (width / 2), (gdouble) (height / 2), (gdouble) (height / 3), (-G_PI) / 2, (3 * G_PI) / 2);
	cairo_fill (context);
	cairo_move_to (context, (gdouble) (width / 2), (gdouble) (height / 2));
	_tmp12_ = foreground;
	_tmp13_ = foreground;
	_tmp14_ = foreground;
	_tmp15_ = foreground;
	cairo_set_source_rgba (context, _tmp12_.red, _tmp13_.green, _tmp14_.blue, _tmp15_.alpha);
	_tmp16_ = boxes_downloads_hub_get_progress (self);
	_tmp17_ = _tmp16_;
	radians = ((-G_PI) / 2) + ((2 * G_PI) * _tmp17_);
	cairo_arc (context, (gdouble) (width / 2), (gdouble) (height / 2), (gdouble) (height / 3), (-G_PI) / 2, radians);
	cairo_fill (context);
	result = TRUE;
	_g_object_unref0 (style_context);
	return result;
}

BoxesDownloadsHub*
boxes_downloads_hub_construct (GType object_type)
{
	BoxesDownloadsHub * self = NULL;
	self = (BoxesDownloadsHub*) g_object_new (object_type, NULL);
	return self;
}

BoxesDownloadsHub*
boxes_downloads_hub_new (void)
{
	return boxes_downloads_hub_construct (BOXES_TYPE_DOWNLOADS_HUB);
}

static GtkWidget*
boxes_downloads_hub_get_button (BoxesDownloadsHub* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_popover_get_relative_to ((GtkPopover*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static gdouble
boxes_downloads_hub_get_progress (BoxesDownloadsHub* self)
{
	gdouble result;
	gdouble total = 0.0;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	total = (gdouble) 0;
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				BoxesDownloadsHubRow* row = NULL;
				GtkWidget* _tmp2_;
				BoxesDownloadsHubRow* _tmp3_;
				BoxesDownloadsHubRow* _tmp4_;
				BoxesActivityProgress* _tmp5_;
				gdouble _tmp6_;
				gdouble _tmp7_;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (BOXES_IS_DOWNLOADS_HUB_ROW (_tmp2_) ? ((BoxesDownloadsHubRow*) _tmp2_) : NULL);
				row = _tmp3_;
				_tmp4_ = row;
				_tmp5_ = _tmp4_->progress;
				_tmp6_ = boxes_activity_progress_get_progress (_tmp5_);
				_tmp7_ = _tmp6_;
				total += _tmp7_ / self->priv->n_items;
				_g_object_unref0 (row);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = total;
	return result;
}

static gboolean
boxes_downloads_hub_get_ongoing_downloads (BoxesDownloadsHub* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->n_items > ((guint) 0);
	return result;
}

static void
boxes_downloads_hub_class_init (BoxesDownloadsHubClass * klass,
                                gpointer klass_data)
{
	boxes_downloads_hub_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesDownloadsHub_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_downloads_hub_get_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_downloads_hub_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/downloads-hub.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, BoxesDownloadsHub_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubPrivate, listbox));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_row_activated", G_CALLBACK(_boxes_downloads_hub_on_row_activated_gtk_list_box_row_activated));
}

static void
boxes_downloads_hub_instance_init (BoxesDownloadsHub * self,
                                   gpointer klass)
{
	self->priv = boxes_downloads_hub_get_instance_private (self);
	self->priv->n_items = (guint) 0;
	self->priv->redraw_progress_pie_id = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_downloads_hub_finalize (GObject * obj)
{
	BoxesDownloadsHub * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOADS_HUB, BoxesDownloadsHub);
	G_OBJECT_CLASS (boxes_downloads_hub_parent_class)->finalize (obj);
}

static GType
boxes_downloads_hub_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloadsHubClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_downloads_hub_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownloadsHub), 0, (GInstanceInitFunc) boxes_downloads_hub_instance_init, NULL };
	GType boxes_downloads_hub_type_id;
	boxes_downloads_hub_type_id = g_type_register_static (gtk_popover_get_type (), "BoxesDownloadsHub", &g_define_type_info, 0);
	BoxesDownloadsHub_private_offset = g_type_add_instance_private (boxes_downloads_hub_type_id, sizeof (BoxesDownloadsHubPrivate));
	return boxes_downloads_hub_type_id;
}

GType
boxes_downloads_hub_get_type (void)
{
	static volatile gsize boxes_downloads_hub_type_id__once = 0;
	if (g_once_init_enter (&boxes_downloads_hub_type_id__once)) {
		GType boxes_downloads_hub_type_id;
		boxes_downloads_hub_type_id = boxes_downloads_hub_get_type_once ();
		g_once_init_leave (&boxes_downloads_hub_type_id__once, boxes_downloads_hub_type_id);
	}
	return boxes_downloads_hub_type_id__once;
}

static void
_vala_boxes_downloads_hub_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BoxesDownloadsHub * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_DOWNLOADS_HUB, BoxesDownloadsHub);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boxes_downloads_hub_row_get_instance_private (BoxesDownloadsHubRow* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesDownloadsHubRow_private_offset);
}

static void
__lambda18_ (BoxesDownloadsHubRow* self)
{
	GtkProgressBar* _tmp0_;
	BoxesActivityProgress* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = self->progress;
	_tmp2_ = boxes_activity_progress_get_progress (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_progress_bar_set_fraction (_tmp0_, _tmp3_);
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda18_ ((BoxesDownloadsHubRow*) self);
}

BoxesDownloadsHubRow*
boxes_downloads_hub_row_construct_from_entry (GType object_type,
                                              BoxesAssistantDownloadableEntry* entry)
{
	BoxesDownloadsHubRow * self = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	OsinfoOs* _tmp4_;
	BoxesActivityProgress* _tmp5_;
	gulong _tmp6_;
	GtkProgressBar* _tmp7_;
	BoxesActivityProgress* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (BoxesDownloadsHubRow*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->label;
	_tmp1_ = hdy_preferences_row_get_title ((HdyPreferencesRow*) entry);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->image;
	_tmp4_ = entry->os;
	boxes_downloader_fetch_os_logo (_tmp3_, _tmp4_, 64, NULL, NULL);
	_tmp5_ = self->progress;
	_tmp6_ = g_signal_connect_object ((GObject*) _tmp5_, "notify::progress", (GCallback) ___lambda18__g_object_notify, self, 0);
	self->priv->progress_notify_id = _tmp6_;
	_tmp7_ = self->priv->progress_bar;
	_tmp8_ = self->progress;
	boxes_activity_progress_set_progress (_tmp8_, (gdouble) 0);
	gtk_progress_bar_set_fraction (_tmp7_, (gdouble) 0);
	{
		GUri* download_uri = NULL;
		const gchar* _tmp9_;
		GUri* _tmp10_;
		gchar* download_path = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* filename = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp9_ = entry->url;
		_tmp10_ = g_uri_parse (_tmp9_, G_URI_FLAGS_NONE, &_inner_error0_);
		download_uri = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch0_g_uri_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp11_ = g_uri_get_path (download_uri);
		_tmp12_ = g_strdup (_tmp11_);
		download_path = _tmp12_;
		_tmp13_ = download_path;
		_tmp14_ = g_path_get_basename (_tmp13_);
		filename = _tmp14_;
		_tmp15_ = entry->url;
		_tmp16_ = filename;
		boxes_downloads_hub_row_download (self, _tmp15_, _tmp16_, NULL, NULL);
		_g_free0 (filename);
		_g_free0 (download_path);
		_g_uri_unref0 (download_uri);
	}
	goto __finally0;
	__catch0_g_uri_error:
	{
		GError* _error_ = NULL;
		BoxesApp* _tmp17_;
		BoxesAppWindow* _tmp18_;
		BoxesAppWindow* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		BoxesToast* _tmp24_;
		BoxesToast* _tmp25_;
		const gchar* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = boxes_app_app;
		_tmp18_ = boxes_app_get_main_window (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = g_strdup_printf (_ ("Failed to download: %s"), _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = boxes_toast_new (_tmp23_);
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		boxes_app_window_display_toast (_tmp19_, _tmp25_);
		_g_object_unref0 (_tmp25_);
		_g_free0 (_tmp23_);
		_tmp26_ = entry->url;
		_tmp27_ = _error_;
		_tmp28_ = _tmp27_->message;
		g_warning ("downloads-hub.vala:181: Failed to download '%s': %s", _tmp26_, _tmp28_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

BoxesDownloadsHubRow*
boxes_downloads_hub_row_new_from_entry (BoxesAssistantDownloadableEntry* entry)
{
	return boxes_downloads_hub_row_construct_from_entry (BOXES_TYPE_DOWNLOADS_HUB_ROW, entry);
}

static void
boxes_downloads_hub_row_download_data_free (gpointer _data)
{
	BoxesDownloadsHubRowDownloadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesDownloadsHubRowDownloadData, _data_);
}

static void
boxes_downloads_hub_row_download (BoxesDownloadsHubRow* self,
                                  const gchar* url,
                                  const gchar* filename,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	BoxesDownloadsHubRowDownloadData* _data_;
	BoxesDownloadsHubRow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BoxesDownloadsHubRowDownloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloads_hub_row_download_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	boxes_downloads_hub_row_download_co (_data_);
}

static void
boxes_downloads_hub_row_download_finish (BoxesDownloadsHubRow* self,
                                         GAsyncResult* _res_)
{
	BoxesDownloadsHubRowDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
boxes_downloads_hub_row_download_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	BoxesDownloadsHubRowDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_downloads_hub_row_download_co (_data_);
}

static gboolean
boxes_downloads_hub_row_download_co (BoxesDownloadsHubRowDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->progress;
		_data_->_tmp2_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		boxes_downloader_fetch_media (_data_->url, _data_->filename, _data_->_tmp1_, _data_->_tmp2_, boxes_downloads_hub_row_download_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = boxes_downloader_fetch_media_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_free0 (_data_->self->local_file);
		_data_->self->local_file = _data_->_tmp4_;
		_g_free0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = boxes_app_app;
		_data_->_tmp6_ = boxes_app_get_main_window (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->_error_;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		_data_->_tmp10_ = g_strdup_printf (_ ("Failed to download '%s': %s"), _data_->filename, _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = boxes_toast_new (_data_->_tmp11_);
		g_object_ref_sink (_data_->_tmp12_);
		_data_->_tmp13_ = _data_->_tmp12_;
		boxes_app_window_display_toast (_data_->_tmp7_, _data_->_tmp13_);
		_g_object_unref0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
		_data_->_tmp14_ = _data_->_error_;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("downloads-hub.vala:192: Failed to download '%s': %s", _data_->url, _data_->_tmp15_);
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->self->priv->cancellable;
	if (!g_cancellable_is_cancelled (_data_->_tmp16_)) {
		_data_->self->complete = TRUE;
		_data_->_tmp17_ = _data_->self->priv->label;
		_data_->_tmp18_ = gtk_label_get_label (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = _data_->self->local_file;
		g_signal_emit (_data_->self, boxes_downloads_hub_row_signals[BOXES_DOWNLOADS_HUB_ROW_DOWNLOAD_COMPLETE_SIGNAL], 0, _data_->_tmp19_, _data_->_tmp20_);
		_data_->_tmp21_ = _data_->self->priv->download_status;
		_data_->_tmp22_ = _data_->self->priv->download_complete_label;
		gtk_stack_set_visible_child (_data_->_tmp21_, (GtkWidget*) _data_->_tmp22_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_downloads_hub_row_cancel_download (BoxesDownloadsHubRow* self)
{
	BoxesActivityProgress* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->progress;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->progress_notify_id);
	_tmp1_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp1_);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
_boxes_downloads_hub_row_cancel_download_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	boxes_downloads_hub_row_cancel_download ((BoxesDownloadsHubRow*) self);
}

BoxesDownloadsHubRow*
boxes_downloads_hub_row_construct (GType object_type)
{
	BoxesDownloadsHubRow * self = NULL;
	self = (BoxesDownloadsHubRow*) g_object_new (object_type, NULL);
	return self;
}

BoxesDownloadsHubRow*
boxes_downloads_hub_row_new (void)
{
	return boxes_downloads_hub_row_construct (BOXES_TYPE_DOWNLOADS_HUB_ROW);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
boxes_downloads_hub_row_class_init (BoxesDownloadsHubRowClass * klass,
                                    gpointer klass_data)
{
	boxes_downloads_hub_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesDownloadsHubRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_downloads_hub_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/downloads-hub-row.ui");
	boxes_downloads_hub_row_signals[BOXES_DOWNLOADS_HUB_ROW_DOWNLOAD_COMPLETE_SIGNAL] = g_signal_new ("download-complete", BOXES_TYPE_DOWNLOADS_HUB_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, BoxesDownloadsHubRow_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubRowPrivate, label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, BoxesDownloadsHubRow_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubRowPrivate, image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "download_status", FALSE, BoxesDownloadsHubRow_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubRowPrivate, download_status));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_bar", FALSE, BoxesDownloadsHubRow_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubRowPrivate, progress_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "download_complete_label", FALSE, BoxesDownloadsHubRow_private_offset + G_STRUCT_OFFSET (BoxesDownloadsHubRowPrivate, download_complete_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_download", G_CALLBACK(_boxes_downloads_hub_row_cancel_download_gtk_button_clicked));
}

static void
boxes_downloads_hub_row_instance_init (BoxesDownloadsHubRow * self,
                                       gpointer klass)
{
	BoxesActivityProgress* _tmp0_;
	GCancellable* _tmp1_;
	self->priv = boxes_downloads_hub_row_get_instance_private (self);
	_tmp0_ = boxes_activity_progress_new ();
	self->progress = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	self->priv->cancellable = _tmp1_;
	self->complete = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_downloads_hub_row_finalize (GObject * obj)
{
	BoxesDownloadsHubRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOADS_HUB_ROW, BoxesDownloadsHubRow);
	_g_object_unref0 (self->progress);
	_g_object_unref0 (self->priv->cancellable);
	_g_free0 (self->local_file);
	G_OBJECT_CLASS (boxes_downloads_hub_row_parent_class)->finalize (obj);
}

static GType
boxes_downloads_hub_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloadsHubRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_downloads_hub_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownloadsHubRow), 0, (GInstanceInitFunc) boxes_downloads_hub_row_instance_init, NULL };
	GType boxes_downloads_hub_row_type_id;
	boxes_downloads_hub_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BoxesDownloadsHubRow", &g_define_type_info, 0);
	BoxesDownloadsHubRow_private_offset = g_type_add_instance_private (boxes_downloads_hub_row_type_id, sizeof (BoxesDownloadsHubRowPrivate));
	return boxes_downloads_hub_row_type_id;
}

GType
boxes_downloads_hub_row_get_type (void)
{
	static volatile gsize boxes_downloads_hub_row_type_id__once = 0;
	if (g_once_init_enter (&boxes_downloads_hub_row_type_id__once)) {
		GType boxes_downloads_hub_row_type_id;
		boxes_downloads_hub_row_type_id = boxes_downloads_hub_row_get_type_once ();
		g_once_init_leave (&boxes_downloads_hub_row_type_id__once, boxes_downloads_hub_row_type_id);
	}
	return boxes_downloads_hub_row_type_id__once;
}

