/* os-database.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from os-database.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "common.h"
#include <float.h>
#include <math.h>

#define BOXES_OS_DATABASE_MINIMAL_STORAGE (10 * ((gint64) OSINFO_GIBIBYTES))
#define BOXES_OS_DATABASE_DEFAULT_VCPUS 1
#define BOXES_OS_DATABASE_DEFAULT_RAM (2 * ((gint64) OSINFO_GIBIBYTES))
#define BOXES_OS_DATABASE_DEFAULT_STORAGE (30 * ((gint64) OSINFO_GIBIBYTES))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_OS_DATABASE_ERROR (boxes_os_database_error_get_type ())

#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
typedef struct _BoxesOSDatabasePrivate BoxesOSDatabasePrivate;
enum  {
	BOXES_OS_DATABASE_0_PROPERTY,
	BOXES_OS_DATABASE_NUM_PROPERTIES
};
static GParamSpec* boxes_os_database_properties[BOXES_OS_DATABASE_NUM_PROPERTIES];
typedef enum  {
	BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_URL = 0,
	BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_OS = 1,
	BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_LAST
} BoxesOSDatabaseMediaURLsColumns;

#define BOXES_OS_DATABASE_TYPE_MEDIA_UR_LS_COLUMNS (boxes_os_database_media_ur_ls_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block41Data Block41Data;

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;
typedef struct _BoxesAppPrivate BoxesAppPrivate;

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;

#define BOXES_TYPE_SHARED_FOLDERS_MANAGER (boxes_shared_folders_manager_get_type ())
#define BOXES_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager))
#define BOXES_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))
#define BOXES_IS_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_IS_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_SHARED_FOLDERS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))

typedef struct _BoxesSharedFoldersManager BoxesSharedFoldersManager;
typedef struct _BoxesSharedFoldersManagerClass BoxesSharedFoldersManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BoxesOsDatabaseLoadData BoxesOsDatabaseLoadData;
typedef struct _BoxesOsDatabaseGuessOsFromInstallMediaPathData BoxesOsDatabaseGuessOsFromInstallMediaPathData;
typedef struct _BoxesOsDatabaseGuessOsFromInstallMediaData BoxesOsDatabaseGuessOsFromInstallMediaData;
typedef struct _BoxesOsDatabaseGetOsByIdData BoxesOsDatabaseGetOsByIdData;
typedef struct _BoxesOsDatabaseGetAllOsesSortedByReleaseDateData BoxesOsDatabaseGetAllOsesSortedByReleaseDateData;
typedef struct _BoxesOsDatabaseGetLatestReleaseForOsPrefixData BoxesOsDatabaseGetLatestReleaseForOsPrefixData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _BoxesOsDatabaseListDownloadableOsesData BoxesOsDatabaseListDownloadableOsesData;
typedef enum  {
	BOXES_CPU_ARCH_COMPATIBILITY_INCOMPATIBLE = -1,
	BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL = 0,
	BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE = 1,
	BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE_DIFF_WORDSIZE = 2
} BoxesCPUArchCompatibility;

#define BOXES_TYPE_CPU_ARCH_COMPATIBILITY (boxes_cpu_arch_compatibility_get_type ())
typedef struct _Block42Data Block42Data;
typedef struct _Block43Data Block43Data;
typedef struct _BoxesOsDatabaseEnsureDbLoadedData BoxesOsDatabaseEnsureDbLoadedData;
enum  {
	BOXES_OS_DATABASE_DB_LOADED_SIGNAL,
	BOXES_OS_DATABASE_NUM_SIGNALS
};
static guint boxes_os_database_signals[BOXES_OS_DATABASE_NUM_SIGNALS] = {0};

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()

struct _BoxesOSDatabase {
	GObject parent_instance;
	BoxesOSDatabasePrivate * priv;
};

struct _BoxesOSDatabaseClass {
	GObjectClass parent_class;
};

struct _BoxesOSDatabasePrivate {
	OsinfoDb* db;
	gboolean db_loading;
};

struct _Block41Data {
	int _ref_count_;
	BoxesOSDatabase* self;
	OsinfoLoader* loader;
	gpointer _async_data_;
};

struct _BoxesApp {
	GtkApplication parent_instance;
	BoxesAppPrivate * priv;
	BoxesCollection* collection;
	BoxesAsyncLauncher* async_launcher;
	BoxesSharedFoldersManager* shared_folders_manager;
};

struct _BoxesAppClass {
	GtkApplicationClass parent_class;
};

struct _BoxesOsDatabaseLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	Block41Data* _data41_;
	OsinfoLoader* _tmp0_;
	BoxesApp* _tmp1_;
	BoxesAsyncLauncher* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	BoxesApp* _tmp5_;
	BoxesAsyncLauncher* _tmp6_;
	GError* _vala1_e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	OsinfoDb* _tmp9_;
	OsinfoDb* _tmp10_;
	GError* _inner_error0_;
};

struct _BoxesOsDatabaseGuessOsFromInstallMediaPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	gchar* media_path;
	GCancellable* cancellable;
	OsinfoMedia* result;
	OsinfoMedia* media;
	OsinfoMedia* _tmp0_;
	OsinfoMedia* _tmp1_;
	OsinfoMedia* _tmp2_;
	OsinfoMedia* _tmp3_;
	OsinfoMedia* _tmp4_;
	GError* _inner_error0_;
};

struct _BoxesOsDatabaseGuessOsFromInstallMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	OsinfoMedia* media;
	OsinfoMedia* result;
	OsinfoDb* _tmp0_;
	OsinfoMedia* _tmp1_;
};

struct _BoxesOsDatabaseGetOsByIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	gchar* id;
	OsinfoOs* result;
	GError* _tmp0_;
	OsinfoOs* os;
	OsinfoDb* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoOs* _tmp3_;
	OsinfoOs* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _BoxesOsDatabaseGetAllOsesSortedByReleaseDateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	GList* result;
	GError* _tmp0_;
	GList* os_list;
	OsinfoDb* _tmp1_;
	OsinfoOsList* _tmp2_;
	OsinfoOsList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GError* _inner_error0_;
};

struct _BoxesOsDatabaseGetLatestReleaseForOsPrefixData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	gchar* os_id_prefix;
	OsinfoOs* result;
	OsinfoOs* latest_version;
	GList* os_list;
	OsinfoDb* _tmp0_;
	OsinfoOsList* _tmp1_;
	OsinfoOsList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* entity_collection;
	GList* entity_it;
	OsinfoEntity* entity;
	OsinfoOs* os;
	OsinfoEntity* _tmp6_;
	OsinfoOs* _tmp7_;
	OsinfoOs* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	OsinfoOs* _tmp14_;
	OsinfoOs* _tmp15_;
	OsinfoOs* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	OsinfoOs* _tmp19_;
	OsinfoOs* _tmp20_;
	OsinfoOs* _tmp21_;
	OsinfoOs* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	OsinfoOs* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	OsinfoOs* _tmp28_;
	OsinfoOs* _tmp29_;
};

struct _BoxesOsDatabaseListDownloadableOsesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	GList* result;
	GError* _tmp0_;
	gint year;
	gint month;
	gint day;
	GDateTime* date_time;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GDate now;
	GList* after_list;
	OsinfoDb* _tmp6_;
	OsinfoOsList* _tmp7_;
	OsinfoOsList* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* entity_collection;
	GList* entity_it;
	OsinfoEntity* entity;
	OsinfoOs* os;
	OsinfoEntity* _tmp11_;
	OsinfoOs* _tmp12_;
	gboolean _tmp13_;
	OsinfoOs* _tmp14_;
	OsinfoOs* _tmp15_;
	OsinfoOs* _tmp16_;
	OsinfoMediaList* _tmp17_;
	OsinfoMediaList* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	GList* media_entity_collection;
	GList* media_entity_it;
	OsinfoEntity* media_entity;
	OsinfoMedia* media;
	OsinfoEntity* _tmp21_;
	OsinfoMedia* _tmp22_;
	OsinfoMedia* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	OsinfoMedia* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	OsinfoProduct* product;
	OsinfoOs* _tmp33_;
	OsinfoProduct* _tmp34_;
	GDate* eol;
	OsinfoProduct* _tmp35_;
	GDate* _tmp36_;
	gboolean _tmp37_;
	GDate* _tmp38_;
	GDate* _tmp39_;
	GDate _tmp40_;
	OsinfoMedia* _tmp41_;
	OsinfoMedia* _tmp42_;
	GError* _inner_error0_;
};

struct _Block42Data {
	int _ref_count_;
	BoxesOSDatabase* self;
	gpointer _async_data_;
};

struct _Block43Data {
	int _ref_count_;
	Block42Data * _data42_;
	gulong db_loaded_id;
};

struct _BoxesOsDatabaseEnsureDbLoadedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesOSDatabase* self;
	gboolean result;
	Block42Data* _data42_;
	OsinfoDb* _tmp0_;
	Block43Data* _data43_;
	gulong _tmp1_;
	OsinfoDb* _tmp2_;
};

static gint BoxesOSDatabase_private_offset;
static gpointer boxes_os_database_parent_class = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;

VALA_EXTERN GQuark boxes_os_database_error_quark (void);
VALA_EXTERN GType boxes_os_database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_os_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesOSDatabase, g_object_unref)
VALA_EXTERN GType boxes_os_database_media_ur_ls_columns_get_type (void) G_GNUC_CONST ;
VALA_EXTERN OsinfoResources* boxes_os_database_get_default_resources (void);
static void boxes_os_database_load_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_load (BoxesOSDatabase* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void boxes_os_database_load_finish (BoxesOSDatabase* self,
                                    GAsyncResult* _res_);
static gboolean boxes_os_database_load_co (BoxesOsDatabaseLoadData* _data_);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN GType boxes_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollection, g_object_unref)
VALA_EXTERN GType boxes_shared_folders_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSharedFoldersManager, g_object_unref)
static void ___lambda4_ (Block41Data* _data41_,
                  GError** error);
static void ____lambda4__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                           GError** error);
static void boxes_os_database_load_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void ___lambda5_ (Block41Data* _data41_,
                  GError** error);
static void ____lambda5__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                           GError** error);
static void boxes_os_database_guess_os_from_install_media_path_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_guess_os_from_install_media_path (BoxesOSDatabase* self,
                                                         const gchar* media_path,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN OsinfoMedia* boxes_os_database_guess_os_from_install_media_path_finish (BoxesOSDatabase* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error);
static gboolean boxes_os_database_guess_os_from_install_media_path_co (BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_);
static void boxes_os_database_ensure_db_loaded (BoxesOSDatabase* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean boxes_os_database_ensure_db_loaded_finish (BoxesOSDatabase* self,
                                                    GAsyncResult* _res_);
static void boxes_os_database_guess_os_from_install_media_path_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
VALA_EXTERN void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self,
                                                    OsinfoMedia* media,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN OsinfoMedia* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data);
static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_);
static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void boxes_os_database_get_os_by_id_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_get_os_by_id (BoxesOSDatabase* self,
                                     const gchar* id,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN OsinfoOs* boxes_os_database_get_os_by_id_finish (BoxesOSDatabase* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static gboolean boxes_os_database_get_os_by_id_co (BoxesOsDatabaseGetOsByIdData* _data_);
static void boxes_os_database_get_os_by_id_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void boxes_os_database_get_all_oses_sorted_by_release_date_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_get_all_oses_sorted_by_release_date (BoxesOSDatabase* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN GList* boxes_os_database_get_all_oses_sorted_by_release_date_finish (BoxesOSDatabase* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static gboolean boxes_os_database_get_all_oses_sorted_by_release_date_co (BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_);
static void boxes_os_database_get_all_oses_sorted_by_release_date_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static gint __lambda7_ (OsinfoEntity* entity_a,
                 OsinfoEntity* entity_b);
static gint ___lambda7__gcompare_func (gconstpointer a,
                                gconstpointer b);
static void boxes_os_database_get_latest_release_for_os_prefix_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_get_latest_release_for_os_prefix (BoxesOSDatabase* self,
                                                         const gchar* os_id_prefix,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN OsinfoOs* boxes_os_database_get_latest_release_for_os_prefix_finish (BoxesOSDatabase* self,
                                                                     GAsyncResult* _res_);
static gboolean boxes_os_database_get_latest_release_for_os_prefix_co (BoxesOsDatabaseGetLatestReleaseForOsPrefixData* _data_);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_os_database_list_downloadable_oses_data_free (gpointer _data);
VALA_EXTERN void boxes_os_database_list_downloadable_oses (BoxesOSDatabase* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN GList* boxes_os_database_list_downloadable_oses_finish (BoxesOSDatabase* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean boxes_os_database_list_downloadable_oses_co (BoxesOsDatabaseListDownloadableOsesData* _data_);
static void boxes_os_database_list_downloadable_oses_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static gint __lambda124_ (OsinfoMedia* media_a,
                   OsinfoMedia* media_b);
static gint ___lambda124__gcompare_func (gconstpointer a,
                                  gconstpointer b);
VALA_EXTERN OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self,
                                                OsinfoOs* os,
                                                const gchar* id,
                                                GError** error);
VALA_EXTERN OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self,
                                                         OsinfoOs* os,
                                                         const gchar* architecture);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static OsinfoResources* boxes_os_database_get_prefered_resources (OsinfoResourcesList* list,
                                                           gchar** prefs,
                                                           gint prefs_length1);
static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self,
                                                                    OsinfoResources* minimum,
                                                                    OsinfoResources* recommended);
VALA_EXTERN OsinfoResources* boxes_os_database_get_recommended_resources_for_os (OsinfoOs* os,
                                                                     const gchar* architecture);
VALA_EXTERN OsinfoDatamap* boxes_os_database_get_datamap (BoxesOSDatabase* self,
                                              const gchar* id);
static OsinfoResourcesList* boxes_os_database_filter_resources_list_by_arch (OsinfoResourcesList* list,
                                                                      const gchar* arch);
VALA_EXTERN GType boxes_cpu_arch_compatibility_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BoxesCPUArchCompatibility boxes_compare_cpu_architectures (const gchar* arch1,
                                                           const gchar* arch2);
static void boxes_os_database_ensure_db_loaded_data_free (gpointer _data);
static gboolean boxes_os_database_ensure_db_loaded_co (BoxesOsDatabaseEnsureDbLoadedData* _data_);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void ___lambda6_ (Block43Data* _data43_);
static void ____lambda6__boxes_os_database_db_loaded (BoxesOSDatabase* _sender,
                                               gpointer self);
VALA_EXTERN BoxesOSDatabase* boxes_os_database_new (void);
VALA_EXTERN BoxesOSDatabase* boxes_os_database_construct (GType object_type);
static void boxes_os_database_finalize (GObject * obj);
static GType boxes_os_database_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* BOXES_OS_DATABASE_skipped_os_versions[5] = {"unknown", "rawhide", "Rawhide", "testing", "factory"};
VALA_EXTERN const gchar* BOXES_INSTALLED_MEDIA_supported_architectures[6];

GQuark
boxes_os_database_error_quark (void)
{
	return g_quark_from_static_string ("boxes-os-database-error-quark");
}

static GType
boxes_os_database_error_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_OS_DATABASE_ERROR_NON_BOOTABLE, "BOXES_OS_DATABASE_ERROR_NON_BOOTABLE", "non-bootable"}, {BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED, "BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED", "db-loading-failed"}, {BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID", "unknown-os-id"}, {BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID, "BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID", "unknown-media-id"}, {0, NULL, NULL}};
	GType boxes_os_database_error_type_id;
	boxes_os_database_error_type_id = g_enum_register_static ("BoxesOSDatabaseError", values);
	return boxes_os_database_error_type_id;
}

GType
boxes_os_database_error_get_type (void)
{
	static volatile gsize boxes_os_database_error_type_id__once = 0;
	if (g_once_init_enter (&boxes_os_database_error_type_id__once)) {
		GType boxes_os_database_error_type_id;
		boxes_os_database_error_type_id = boxes_os_database_error_get_type_once ();
		g_once_init_leave (&boxes_os_database_error_type_id__once, boxes_os_database_error_type_id);
	}
	return boxes_os_database_error_type_id__once;
}

static inline gpointer
boxes_os_database_get_instance_private (BoxesOSDatabase* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesOSDatabase_private_offset);
}

static GType
boxes_os_database_media_ur_ls_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_URL, "BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_URL", "url"}, {BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_OS, "BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_OS", "os"}, {BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_LAST, "BOXES_OS_DATABASE_MEDIA_UR_LS_COLUMNS_LAST", "last"}, {0, NULL, NULL}};
	GType boxes_os_database_media_ur_ls_columns_type_id;
	boxes_os_database_media_ur_ls_columns_type_id = g_enum_register_static ("BoxesOSDatabaseMediaURLsColumns", values);
	return boxes_os_database_media_ur_ls_columns_type_id;
}

GType
boxes_os_database_media_ur_ls_columns_get_type (void)
{
	static volatile gsize boxes_os_database_media_ur_ls_columns_type_id__once = 0;
	if (g_once_init_enter (&boxes_os_database_media_ur_ls_columns_type_id__once)) {
		GType boxes_os_database_media_ur_ls_columns_type_id;
		boxes_os_database_media_ur_ls_columns_type_id = boxes_os_database_media_ur_ls_columns_get_type_once ();
		g_once_init_leave (&boxes_os_database_media_ur_ls_columns_type_id__once, boxes_os_database_media_ur_ls_columns_type_id);
	}
	return boxes_os_database_media_ur_ls_columns_type_id__once;
}

OsinfoResources*
boxes_os_database_get_default_resources (void)
{
	OsinfoResources* resources = NULL;
	OsinfoResources* _tmp0_;
	OsinfoResources* result;
	_tmp0_ = osinfo_resources_new ("whatever", "x86_64");
	resources = _tmp0_;
	osinfo_resources_set_n_cpus (resources, BOXES_OS_DATABASE_DEFAULT_VCPUS);
	osinfo_resources_set_ram (resources, BOXES_OS_DATABASE_DEFAULT_RAM);
	osinfo_resources_set_storage (resources, BOXES_OS_DATABASE_DEFAULT_STORAGE);
	result = resources;
	return result;
}

static void
boxes_os_database_load_data_free (gpointer _data)
{
	BoxesOsDatabaseLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseLoadData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_os_database_load (BoxesOSDatabase* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	BoxesOsDatabaseLoadData* _data_;
	BoxesOSDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_os_database_load_co (_data_);
}

void
boxes_os_database_load_finish (BoxesOSDatabase* self,
                               GAsyncResult* _res_)
{
	BoxesOsDatabaseLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		BoxesOSDatabase* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->loader);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
___lambda4_ (Block41Data* _data41_,
             GError** error)
{
	BoxesOSDatabase* self;
	GError* _inner_error0_ = NULL;
	self = _data41_->self;
	osinfo_loader_process_default_path (_data41_->loader, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
____lambda4__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                      GError** error)
{
	___lambda4_ (self, error);
}

static void
boxes_os_database_load_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	BoxesOsDatabaseLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_load_co (_data_);
}

static void
___lambda5_ (Block41Data* _data41_,
             GError** error)
{
	BoxesOSDatabase* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = _data41_->self;
	_tmp0_ = boxes_get_custom_osinfo_db ();
	_tmp1_ = _tmp0_;
	osinfo_loader_process_path (_data41_->loader, _tmp1_, &_inner_error0_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
____lambda5__boxes_async_launcher_run_in_thread_func (gpointer self,
                                                      GError** error)
{
	___lambda5_ (self, error);
}

static gboolean
boxes_os_database_load_co (BoxesOsDatabaseLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data41_ = g_slice_new0 (Block41Data);
	_data_->_data41_->_ref_count_ = 1;
	_data_->_data41_->self = g_object_ref (_data_->self);
	_data_->_data41_->_async_data_ = _data_;
	_data_->self->priv->db_loading = TRUE;
	_data_->_tmp0_ = osinfo_loader_new ();
	_data_->_data41_->loader = _data_->_tmp0_;
	{
		_data_->_tmp1_ = boxes_app_app;
		_data_->_tmp2_ = _data_->_tmp1_->async_launcher;
		_data_->_state_ = 1;
		boxes_async_launcher_launch (_data_->_tmp2_, ____lambda4__boxes_async_launcher_run_in_thread_func, block41_data_ref (_data_->_data41_), block41_data_unref, boxes_os_database_load_ready, _data_);
		return FALSE;
		_state_1:
		boxes_async_launcher_launch_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("os-database.vala:51: Error loading default libosinfo database: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block41_data_unref (_data_->_data41_);
		_data_->_data41_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp5_ = boxes_app_app;
		_data_->_tmp6_ = _data_->_tmp5_->async_launcher;
		_data_->_state_ = 2;
		boxes_async_launcher_launch (_data_->_tmp6_, ____lambda5__boxes_async_launcher_run_in_thread_func, block41_data_ref (_data_->_data41_), block41_data_unref, boxes_os_database_load_ready, _data_);
		return FALSE;
		_state_2:
		boxes_async_launcher_launch_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->_vala1_e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("os-database.vala:56: Error loading GNOME Boxes libosinfo database: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block41_data_unref (_data_->_data41_);
		_data_->_data41_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = osinfo_loader_get_db (_data_->_data41_->loader);
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_g_object_unref0 (_data_->self->priv->db);
	_data_->self->priv->db = _data_->_tmp10_;
	_data_->self->priv->db_loading = FALSE;
	g_signal_emit (_data_->self, boxes_os_database_signals[BOXES_OS_DATABASE_DB_LOADED_SIGNAL], 0);
	block41_data_unref (_data_->_data41_);
	_data_->_data41_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_os_database_guess_os_from_install_media_path_data_free (gpointer _data)
{
	BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->media_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGuessOsFromInstallMediaPathData, _data_);
}

void
boxes_os_database_guess_os_from_install_media_path (BoxesOSDatabase* self,
                                                    const gchar* media_path,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_;
	BoxesOSDatabase* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media_path != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseGuessOsFromInstallMediaPathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_guess_os_from_install_media_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (media_path);
	_g_free0 (_data_->media_path);
	_data_->media_path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	boxes_os_database_guess_os_from_install_media_path_co (_data_);
}

OsinfoMedia*
boxes_os_database_guess_os_from_install_media_path_finish (BoxesOSDatabase* self,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	OsinfoMedia* result;
	BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_os_database_guess_os_from_install_media_path_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_guess_os_from_install_media_path_co (_data_);
}

static gboolean
boxes_os_database_guess_os_from_install_media_path_co (BoxesOsDatabaseGuessOsFromInstallMediaPathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	boxes_os_database_ensure_db_loaded (_data_->self, boxes_os_database_guess_os_from_install_media_path_ready, _data_);
	return FALSE;
	_state_1:
	if (!boxes_os_database_ensure_db_loaded_finish (_data_->self, _data_->_res_)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	osinfo_media_create_from_location_async (_data_->media_path, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_os_database_guess_os_from_install_media_path_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp0_ = osinfo_media_create_from_location_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->media = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->media;
	_data_->_state_ = 3;
	boxes_os_database_guess_os_from_install_media (_data_->self, _data_->_tmp2_, boxes_os_database_guess_os_from_install_media_path_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp3_ = boxes_os_database_guess_os_from_install_media_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_data_->result = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp1_);
	_g_object_unref0 (_data_->media);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_os_database_guess_os_from_install_media_data_free (gpointer _data)
{
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->media);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGuessOsFromInstallMediaData, _data_);
}

void
boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self,
                                               OsinfoMedia* media,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	BoxesOSDatabase* _tmp0_;
	OsinfoMedia* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseGuessOsFromInstallMediaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_guess_os_from_install_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (media);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp1_;
	boxes_os_database_guess_os_from_install_media_co (_data_);
}

OsinfoMedia*
boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	OsinfoMedia* result;
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_os_database_guess_os_from_install_media_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_guess_os_from_install_media_co (_data_);
}

static gboolean
boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	boxes_os_database_ensure_db_loaded (_data_->self, boxes_os_database_guess_os_from_install_media_ready, _data_);
	return FALSE;
	_state_1:
	if (!boxes_os_database_ensure_db_loaded_finish (_data_->self, _data_->_res_)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->db;
	if (osinfo_db_identify_media (_data_->_tmp0_, _data_->media)) {
		_data_->_tmp1_ = _g_object_ref0 (_data_->media);
		_data_->result = _data_->_tmp1_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_os_database_get_os_by_id_data_free (gpointer _data)
{
	BoxesOsDatabaseGetOsByIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGetOsByIdData, _data_);
}

void
boxes_os_database_get_os_by_id (BoxesOSDatabase* self,
                                const gchar* id,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BoxesOsDatabaseGetOsByIdData* _data_;
	BoxesOSDatabase* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseGetOsByIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_get_os_by_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	boxes_os_database_get_os_by_id_co (_data_);
}

OsinfoOs*
boxes_os_database_get_os_by_id_finish (BoxesOSDatabase* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	OsinfoOs* result;
	BoxesOsDatabaseGetOsByIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_os_database_get_os_by_id_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	BoxesOsDatabaseGetOsByIdData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_get_os_by_id_co (_data_);
}

static gboolean
boxes_os_database_get_os_by_id_co (BoxesOsDatabaseGetOsByIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	boxes_os_database_ensure_db_loaded (_data_->self, boxes_os_database_get_os_by_id_ready, _data_);
	return FALSE;
	_state_1:
	if (!boxes_os_database_ensure_db_loaded_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp0_ = g_error_new_literal (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED, "Failed to load OS database");
		_data_->_inner_error0_ = _data_->_tmp0_;
		if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = _data_->self->priv->db;
	_data_->_tmp2_ = osinfo_db_get_os (_data_->_tmp1_, _data_->id);
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->os = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->os;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "Unknown OS ID '%s'", _data_->id);
		_data_->_inner_error0_ = _data_->_tmp5_;
		if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->os);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->os);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->os;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_os_database_get_all_oses_sorted_by_release_date_data_free (gpointer _data)
{
	BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_;
	_data_ = _data;
	(_data_->result == NULL) ? NULL : (_data_->result = (g_list_free (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGetAllOsesSortedByReleaseDateData, _data_);
}

void
boxes_os_database_get_all_oses_sorted_by_release_date (BoxesOSDatabase* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_;
	BoxesOSDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseGetAllOsesSortedByReleaseDateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_get_all_oses_sorted_by_release_date_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_os_database_get_all_oses_sorted_by_release_date_co (_data_);
}

GList*
boxes_os_database_get_all_oses_sorted_by_release_date_finish (BoxesOSDatabase* self,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	GList* result;
	BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_os_database_get_all_oses_sorted_by_release_date_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_get_all_oses_sorted_by_release_date_co (_data_);
}

static gint
__lambda7_ (OsinfoEntity* entity_a,
            OsinfoEntity* entity_b)
{
	OsinfoOs* os_a = NULL;
	OsinfoOs* _tmp0_;
	OsinfoOs* os_b = NULL;
	OsinfoOs* _tmp1_;
	OsinfoOs* _tmp2_;
	OsinfoOs* _tmp3_;
	GDate* release_a = NULL;
	OsinfoOs* _tmp4_;
	GDate* _tmp5_;
	GDate* release_b = NULL;
	OsinfoOs* _tmp6_;
	GDate* _tmp7_;
	GDate* _tmp8_;
	GDate* _tmp10_;
	GDate* _tmp11_;
	GDate _tmp12_;
	gint result;
	g_return_val_if_fail (entity_a != NULL, 0);
	g_return_val_if_fail (entity_b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (entity_a, osinfo_os_get_type ()) ? ((OsinfoOs*) entity_a) : NULL);
	os_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (entity_b, osinfo_os_get_type ()) ? ((OsinfoOs*) entity_b) : NULL);
	os_b = _tmp1_;
	_tmp2_ = os_a;
	if (_tmp2_ == NULL) {
		result = -1;
		_g_object_unref0 (os_b);
		_g_object_unref0 (os_a);
		return result;
	}
	_tmp3_ = os_b;
	if (_tmp3_ == NULL) {
		result = 1;
		_g_object_unref0 (os_b);
		_g_object_unref0 (os_a);
		return result;
	}
	_tmp4_ = os_a;
	_tmp5_ = osinfo_product_get_release_date ((OsinfoProduct*) _tmp4_);
	release_a = _tmp5_;
	_tmp6_ = os_b;
	_tmp7_ = osinfo_product_get_release_date ((OsinfoProduct*) _tmp6_);
	release_b = _tmp7_;
	_tmp8_ = release_a;
	if (_tmp8_ == NULL) {
		result = -1;
		_g_free0 (release_b);
		_g_free0 (release_a);
		_g_object_unref0 (os_b);
		_g_object_unref0 (os_a);
		return result;
	} else {
		GDate* _tmp9_;
		_tmp9_ = release_b;
		if (_tmp9_ == NULL) {
			result = 1;
			_g_free0 (release_b);
			_g_free0 (release_a);
			_g_object_unref0 (os_b);
			_g_object_unref0 (os_a);
			return result;
		}
	}
	_tmp10_ = release_b;
	_tmp11_ = release_a;
	_tmp12_ = *_tmp11_;
	result = g_date_compare (_tmp10_, &_tmp12_);
	_g_free0 (release_b);
	_g_free0 (release_a);
	_g_object_unref0 (os_b);
	_g_object_unref0 (os_a);
	return result;
}

static gint
___lambda7__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda7_ ((OsinfoEntity*) a, (OsinfoEntity*) b);
	return result;
}

static gboolean
boxes_os_database_get_all_oses_sorted_by_release_date_co (BoxesOsDatabaseGetAllOsesSortedByReleaseDateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	boxes_os_database_ensure_db_loaded (_data_->self, boxes_os_database_get_all_oses_sorted_by_release_date_ready, _data_);
	return FALSE;
	_state_1:
	if (!boxes_os_database_ensure_db_loaded_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp0_ = g_error_new_literal (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED, "Failed to load OS database");
		_data_->_inner_error0_ = _data_->_tmp0_;
		if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = _data_->self->priv->db;
	_data_->_tmp2_ = osinfo_db_get_os_list (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = osinfo_list_get_elements ((OsinfoList*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp3_);
	_data_->os_list = _data_->_tmp5_;
	_data_->os_list = g_list_sort (_data_->os_list, ___lambda7__gcompare_func);
	_data_->result = _data_->os_list;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_os_database_get_latest_release_for_os_prefix_data_free (gpointer _data)
{
	BoxesOsDatabaseGetLatestReleaseForOsPrefixData* _data_;
	_data_ = _data;
	_g_free0 (_data_->os_id_prefix);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseGetLatestReleaseForOsPrefixData, _data_);
}

void
boxes_os_database_get_latest_release_for_os_prefix (BoxesOSDatabase* self,
                                                    const gchar* os_id_prefix,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	BoxesOsDatabaseGetLatestReleaseForOsPrefixData* _data_;
	BoxesOSDatabase* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os_id_prefix != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseGetLatestReleaseForOsPrefixData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_get_latest_release_for_os_prefix_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (os_id_prefix);
	_g_free0 (_data_->os_id_prefix);
	_data_->os_id_prefix = _tmp1_;
	boxes_os_database_get_latest_release_for_os_prefix_co (_data_);
}

OsinfoOs*
boxes_os_database_get_latest_release_for_os_prefix_finish (BoxesOSDatabase* self,
                                                           GAsyncResult* _res_)
{
	OsinfoOs* result;
	BoxesOsDatabaseGetLatestReleaseForOsPrefixData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
boxes_os_database_get_latest_release_for_os_prefix_co (BoxesOsDatabaseGetLatestReleaseForOsPrefixData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->latest_version = NULL;
	_data_->_tmp0_ = _data_->self->priv->db;
	_data_->_tmp1_ = osinfo_db_get_os_list (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = osinfo_list_get_elements ((OsinfoList*) _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->os_list = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->os_list;
	{
		_data_->entity_collection = _data_->_tmp5_;
		for (_data_->entity_it = _data_->entity_collection; _data_->entity_it != NULL; _data_->entity_it = _data_->entity_it->next) {
			_data_->entity = (OsinfoEntity*) _data_->entity_it->data;
			{
				_data_->_tmp6_ = _data_->entity;
				_data_->_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, osinfo_os_get_type ()) ? ((OsinfoOs*) _data_->_tmp6_) : NULL);
				_data_->os = _data_->_tmp7_;
				_data_->_tmp8_ = _data_->os;
				g_object_get ((OsinfoEntity*) _data_->_tmp8_, "id", &_data_->_tmp9_, NULL);
				_data_->_tmp10_ = _data_->_tmp9_;
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp12_ = !g_str_has_prefix (_data_->_tmp11_, _data_->os_id_prefix);
				_g_free0 (_data_->_tmp11_);
				if (_data_->_tmp12_) {
					_g_object_unref0 (_data_->os);
					continue;
				}
				_data_->_tmp14_ = _data_->os;
				if (osinfo_os_get_release_status (_data_->_tmp14_) != OSINFO_RELEASE_STATUS_RELEASED) {
					_data_->_tmp15_ = _data_->os;
					_data_->_tmp13_ = osinfo_os_get_release_status (_data_->_tmp15_) != OSINFO_RELEASE_STATUS_ROLLING;
				} else {
					_data_->_tmp13_ = FALSE;
				}
				if (_data_->_tmp13_) {
					_g_object_unref0 (_data_->os);
					continue;
				}
				_data_->_tmp16_ = _data_->os;
				_data_->_tmp17_ = osinfo_product_get_version ((OsinfoProduct*) _data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				if (_vala_string_array_contains (BOXES_OS_DATABASE_skipped_os_versions, G_N_ELEMENTS (BOXES_OS_DATABASE_skipped_os_versions), _data_->_tmp18_)) {
					_g_object_unref0 (_data_->os);
					continue;
				}
				_data_->_tmp19_ = _data_->latest_version;
				if (_data_->_tmp19_ == NULL) {
					_data_->_tmp20_ = _data_->os;
					_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
					_g_object_unref0 (_data_->latest_version);
					_data_->latest_version = _data_->_tmp21_;
					_g_object_unref0 (_data_->os);
					continue;
				}
				_data_->_tmp22_ = _data_->os;
				_data_->_tmp23_ = osinfo_product_get_version ((OsinfoProduct*) _data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = _data_->latest_version;
				_data_->_tmp26_ = osinfo_product_get_version ((OsinfoProduct*) _data_->_tmp25_);
				_data_->_tmp27_ = _data_->_tmp26_;
				if (double_parse (_data_->_tmp24_) > double_parse (_data_->_tmp27_)) {
					_data_->_tmp28_ = _data_->os;
					_data_->_tmp29_ = _g_object_ref0 (_data_->_tmp28_);
					_g_object_unref0 (_data_->latest_version);
					_data_->latest_version = _data_->_tmp29_;
				}
				_g_object_unref0 (_data_->os);
			}
		}
	}
	_data_->result = _data_->latest_version;
	(_data_->os_list == NULL) ? NULL : (_data_->os_list = (g_list_free (_data_->os_list), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
boxes_os_database_list_downloadable_oses_data_free (gpointer _data)
{
	BoxesOsDatabaseListDownloadableOsesData* _data_;
	_data_ = _data;
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_object_unref0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseListDownloadableOsesData, _data_);
}

void
boxes_os_database_list_downloadable_oses (BoxesOSDatabase* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BoxesOsDatabaseListDownloadableOsesData* _data_;
	BoxesOSDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseListDownloadableOsesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_list_downloadable_oses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_os_database_list_downloadable_oses_co (_data_);
}

GList*
boxes_os_database_list_downloadable_oses_finish (BoxesOSDatabase* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GList* result;
	BoxesOsDatabaseListDownloadableOsesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_os_database_list_downloadable_oses_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	BoxesOsDatabaseListDownloadableOsesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_os_database_list_downloadable_oses_co (_data_);
}

static gint
__lambda124_ (OsinfoMedia* media_a,
              OsinfoMedia* media_b)
{
	GDate* release_a = NULL;
	OsinfoOs* _tmp0_;
	OsinfoOs* _tmp1_;
	OsinfoOs* _tmp2_;
	GDate* _tmp3_;
	GDate* _tmp4_;
	GDate* release_b = NULL;
	OsinfoOs* _tmp5_;
	OsinfoOs* _tmp6_;
	OsinfoOs* _tmp7_;
	GDate* _tmp8_;
	GDate* _tmp9_;
	GDate* _tmp10_;
	GDate* _tmp12_;
	GDate* _tmp13_;
	GDate _tmp14_;
	gint result;
	g_return_val_if_fail (media_a != NULL, 0);
	g_return_val_if_fail (media_b != NULL, 0);
	g_object_get (media_a, "os", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = osinfo_product_get_release_date ((OsinfoProduct*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	release_a = _tmp4_;
	g_object_get (media_b, "os", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = osinfo_product_get_release_date ((OsinfoProduct*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	release_b = _tmp9_;
	_tmp10_ = release_a;
	if (_tmp10_ == NULL) {
		result = -1;
		_g_free0 (release_b);
		_g_free0 (release_a);
		return result;
	} else {
		GDate* _tmp11_;
		_tmp11_ = release_b;
		if (_tmp11_ == NULL) {
			result = 1;
			_g_free0 (release_b);
			_g_free0 (release_a);
			return result;
		}
	}
	_tmp12_ = release_b;
	_tmp13_ = release_a;
	_tmp14_ = *_tmp13_;
	result = g_date_compare (_tmp12_, &_tmp14_);
	_g_free0 (release_b);
	_g_free0 (release_a);
	return result;
}

static gint
___lambda124__gcompare_func (gconstpointer a,
                             gconstpointer b)
{
	gint result;
	result = __lambda124_ ((OsinfoMedia*) a, (OsinfoMedia*) b);
	return result;
}

static gboolean
boxes_os_database_list_downloadable_oses_co (BoxesOsDatabaseListDownloadableOsesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	boxes_os_database_ensure_db_loaded (_data_->self, boxes_os_database_list_downloadable_oses_ready, _data_);
	return FALSE;
	_state_1:
	if (!boxes_os_database_ensure_db_loaded_finish (_data_->self, _data_->_res_)) {
		_data_->_tmp0_ = g_error_new_literal (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED, "Failed to load OS database");
		_data_->_inner_error0_ = _data_->_tmp0_;
		if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = g_date_time_new_now_local ();
	_data_->date_time = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->date_time;
	_data_->_tmp3_ = 0;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = 0;
	g_date_time_get_ymd (_data_->_tmp2_, &_data_->_tmp3_, &_data_->_tmp4_, &_data_->_tmp5_);
	_data_->year = _data_->_tmp3_;
	_data_->month = _data_->_tmp4_;
	_data_->day = _data_->_tmp5_;
	memset (&_data_->now, 0, sizeof (GDate));
	g_date_set_dmy (&_data_->now, (GDateDay) _data_->day, _data_->month, (GDateYear) _data_->year);
	_data_->after_list = NULL;
	_data_->_tmp6_ = _data_->self->priv->db;
	_data_->_tmp7_ = osinfo_db_get_os_list (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = osinfo_list_get_elements ((OsinfoList*) _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_object_unref0 (_data_->_tmp8_);
	{
		_data_->entity_collection = _data_->_tmp10_;
		for (_data_->entity_it = _data_->entity_collection; _data_->entity_it != NULL; _data_->entity_it = _data_->entity_it->next) {
			_data_->entity = (OsinfoEntity*) _data_->entity_it->data;
			{
				_data_->_tmp11_ = _data_->entity;
				_data_->_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, osinfo_os_get_type ()) ? ((OsinfoOs*) _data_->_tmp11_) : NULL);
				_data_->os = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->os;
				if (osinfo_os_get_release_status (_data_->_tmp14_) != OSINFO_RELEASE_STATUS_RELEASED) {
					_data_->_tmp15_ = _data_->os;
					_data_->_tmp13_ = osinfo_os_get_release_status (_data_->_tmp15_) != OSINFO_RELEASE_STATUS_ROLLING;
				} else {
					_data_->_tmp13_ = FALSE;
				}
				if (_data_->_tmp13_) {
					_g_object_unref0 (_data_->os);
					continue;
				}
				_data_->_tmp16_ = _data_->os;
				_data_->_tmp17_ = osinfo_os_get_media_list (_data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp19_ = osinfo_list_get_elements ((OsinfoList*) _data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_g_object_unref0 (_data_->_tmp18_);
				{
					_data_->media_entity_collection = _data_->_tmp20_;
					for (_data_->media_entity_it = _data_->media_entity_collection; _data_->media_entity_it != NULL; _data_->media_entity_it = _data_->media_entity_it->next) {
						_data_->media_entity = (OsinfoEntity*) _data_->media_entity_it->data;
						{
							_data_->_tmp21_ = _data_->media_entity;
							_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, osinfo_media_get_type ()) ? ((OsinfoMedia*) _data_->_tmp21_) : NULL);
							_data_->media = _data_->_tmp22_;
							_data_->_tmp23_ = _data_->media;
							g_object_get (_data_->_tmp23_, "url", &_data_->_tmp24_, NULL);
							_data_->_tmp25_ = _data_->_tmp24_;
							_data_->_tmp26_ = _data_->_tmp25_;
							_data_->_tmp27_ = _data_->_tmp26_ == NULL;
							_g_free0 (_data_->_tmp26_);
							if (_data_->_tmp27_) {
								_g_object_unref0 (_data_->media);
								continue;
							}
							_data_->_tmp28_ = _data_->media;
							g_object_get (_data_->_tmp28_, "architecture", &_data_->_tmp29_, NULL);
							_data_->_tmp30_ = _data_->_tmp29_;
							_data_->_tmp31_ = _data_->_tmp30_;
							_data_->_tmp32_ = !_vala_string_array_contains (BOXES_INSTALLED_MEDIA_supported_architectures, G_N_ELEMENTS (BOXES_INSTALLED_MEDIA_supported_architectures), _data_->_tmp31_);
							_g_free0 (_data_->_tmp31_);
							if (_data_->_tmp32_) {
								_g_object_unref0 (_data_->media);
								continue;
							}
							_data_->_tmp33_ = _data_->os;
							_data_->_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp33_, osinfo_product_get_type ()) ? ((OsinfoProduct*) _data_->_tmp33_) : NULL);
							_data_->product = _data_->_tmp34_;
							_data_->_tmp35_ = _data_->product;
							_data_->_tmp36_ = osinfo_product_get_eol_date (_data_->_tmp35_);
							_data_->eol = _data_->_tmp36_;
							_data_->_tmp38_ = _data_->eol;
							if (_data_->_tmp38_ == NULL) {
								_data_->_tmp37_ = TRUE;
							} else {
								_data_->_tmp39_ = _data_->eol;
								_data_->_tmp40_ = *_data_->_tmp39_;
								_data_->_tmp37_ = g_date_compare (&_data_->now, &_data_->_tmp40_) < 1;
							}
							if (_data_->_tmp37_) {
								_data_->_tmp41_ = _data_->media;
								_data_->_tmp42_ = _g_object_ref0 (_data_->_tmp41_);
								_data_->after_list = g_list_append (_data_->after_list, _data_->_tmp42_);
							}
							_g_free0 (_data_->eol);
							_g_object_unref0 (_data_->product);
							_g_object_unref0 (_data_->media);
						}
					}
					(_data_->media_entity_collection == NULL) ? NULL : (_data_->media_entity_collection = (g_list_free (_data_->media_entity_collection), NULL));
				}
				_g_object_unref0 (_data_->os);
			}
		}
		(_data_->entity_collection == NULL) ? NULL : (_data_->entity_collection = (g_list_free (_data_->entity_collection), NULL));
	}
	_data_->after_list = g_list_sort (_data_->after_list, ___lambda124__gcompare_func);
	_data_->result = _data_->after_list;
	_g_date_time_unref0 (_data_->date_time);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

OsinfoMedia*
boxes_os_database_get_media_by_id (BoxesOSDatabase* self,
                                   OsinfoOs* os,
                                   const gchar* id,
                                   GError** error)
{
	OsinfoMediaList* medias = NULL;
	OsinfoMediaList* _tmp0_;
	OsinfoMedia* media = NULL;
	OsinfoMediaList* _tmp1_;
	OsinfoEntity* _tmp2_;
	OsinfoMedia* _tmp3_;
	OsinfoMedia* _tmp4_;
	GError* _inner_error0_ = NULL;
	OsinfoMedia* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (os != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = osinfo_os_get_media_list (os);
	medias = _tmp0_;
	_tmp1_ = medias;
	_tmp2_ = osinfo_list_find_by_id ((OsinfoList*) _tmp1_, id);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, osinfo_media_get_type ()) ? ((OsinfoMedia*) _tmp2_) : NULL);
	media = _tmp3_;
	_tmp4_ = media;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID, "Unknown media ID '%s'", id);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (media);
			_g_object_unref0 (medias);
			return NULL;
		} else {
			_g_object_unref0 (media);
			_g_object_unref0 (medias);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = media;
	_g_object_unref0 (medias);
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

OsinfoResources*
boxes_os_database_get_resources_for_os (BoxesOSDatabase* self,
                                        OsinfoOs* os,
                                        const gchar* architecture)
{
	gchar** architectures = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint architectures_length1;
	gint _architectures_size_;
	gchar** prefs = NULL;
	gint prefs_length1 = 0;
	gint _prefs_size_ = 0;
	OsinfoResourcesList* list = NULL;
	OsinfoResourcesList* _tmp15_;
	OsinfoResources* recommended = NULL;
	OsinfoResourcesList* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	OsinfoResources* _tmp18_;
	OsinfoResourcesList* _tmp19_;
	OsinfoResources* minimum = NULL;
	OsinfoResourcesList* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	OsinfoResources* _tmp22_;
	OsinfoResources* _tmp23_;
	OsinfoResources* _tmp24_;
	OsinfoResources* _tmp25_;
	OsinfoResources* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (os == NULL) {
		OsinfoResources* _tmp0_;
		_tmp0_ = boxes_os_database_get_default_resources ();
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup ("x86_64");
	_tmp2_ = g_strdup ("i686");
	_tmp3_ = g_strdup ("i386");
	_tmp4_ = g_strdup (OSINFO_ARCHITECTURE_ALL);
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	architectures = _tmp5_;
	architectures_length1 = 4;
	_architectures_size_ = architectures_length1;
	if (architecture != NULL) {
		gchar** _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
		prefs = _tmp6_;
		prefs_length1 = 0;
		_prefs_size_ = prefs_length1;
		_tmp7_ = g_strdup (architecture);
		_vala_array_add4 (&prefs, &prefs_length1, &_prefs_size_, _tmp7_);
		_tmp8_ = architectures;
		_tmp8__length1 = architectures_length1;
		{
			gchar** arch_collection = NULL;
			gint arch_collection_length1 = 0;
			gint _arch_collection_size_ = 0;
			gint arch_it = 0;
			arch_collection = _tmp8_;
			arch_collection_length1 = _tmp8__length1;
			for (arch_it = 0; arch_it < arch_collection_length1; arch_it = arch_it + 1) {
				gchar* _tmp9_;
				gchar* arch = NULL;
				_tmp9_ = g_strdup (arch_collection[arch_it]);
				arch = _tmp9_;
				{
					const gchar* _tmp10_;
					_tmp10_ = arch;
					if (g_strcmp0 (_tmp10_, architecture) != 0) {
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp11_ = arch;
						_tmp12_ = g_strdup (_tmp11_);
						_vala_array_add5 (&prefs, &prefs_length1, &_prefs_size_, _tmp12_);
					}
					_g_free0 (arch);
				}
			}
		}
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = architectures;
		_tmp13__length1 = architectures_length1;
		_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup3 (_tmp13_, _tmp13__length1) : _tmp13_;
		_tmp14__length1 = _tmp13__length1;
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
		prefs = _tmp14_;
		prefs_length1 = _tmp14__length1;
		_prefs_size_ = prefs_length1;
	}
	_tmp15_ = osinfo_os_get_recommended_resources (os);
	list = _tmp15_;
	_tmp16_ = list;
	_tmp17_ = prefs;
	_tmp17__length1 = prefs_length1;
	_tmp18_ = boxes_os_database_get_prefered_resources (_tmp16_, _tmp17_, (gint) _tmp17__length1);
	recommended = _tmp18_;
	_tmp19_ = osinfo_os_get_minimum_resources (os);
	_g_object_unref0 (list);
	list = _tmp19_;
	_tmp20_ = list;
	_tmp21_ = prefs;
	_tmp21__length1 = prefs_length1;
	_tmp22_ = boxes_os_database_get_prefered_resources (_tmp20_, _tmp21_, (gint) _tmp21__length1);
	minimum = _tmp22_;
	_tmp23_ = minimum;
	_tmp24_ = recommended;
	_tmp25_ = boxes_os_database_get_resources_from_os_resources (self, _tmp23_, _tmp24_);
	result = _tmp25_;
	_g_object_unref0 (minimum);
	_g_object_unref0 (recommended);
	_g_object_unref0 (list);
	prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
	architectures = (_vala_array_free (architectures, architectures_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

OsinfoResources*
boxes_os_database_get_recommended_resources_for_os (OsinfoOs* os,
                                                    const gchar* architecture)
{
	gchar** prefs = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint prefs_length1;
	gint _prefs_size_;
	OsinfoResourcesList* list = NULL;
	OsinfoResourcesList* _tmp3_;
	OsinfoResources* _tmp4_;
	OsinfoResources* result;
	g_return_val_if_fail (os != NULL, NULL);
	if (architecture == NULL) {
		architecture = "x86_64";
	}
	_tmp0_ = g_strdup (architecture);
	_tmp1_ = g_strdup (OSINFO_ARCHITECTURE_ALL);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	prefs = _tmp2_;
	prefs_length1 = 2;
	_prefs_size_ = prefs_length1;
	_tmp3_ = osinfo_os_get_recommended_resources (os);
	list = _tmp3_;
	_tmp4_ = boxes_os_database_get_prefered_resources (list, prefs, (gint) prefs_length1);
	result = _tmp4_;
	_g_object_unref0 (list);
	prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

OsinfoDatamap*
boxes_os_database_get_datamap (BoxesOSDatabase* self,
                               const gchar* id)
{
	OsinfoDb* _tmp0_;
	OsinfoDatamap* _tmp1_;
	OsinfoDatamap* _tmp2_;
	OsinfoDatamap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = osinfo_db_get_datamap (_tmp0_, id);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static OsinfoResources*
boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self,
                                                   OsinfoResources* minimum,
                                                   OsinfoResources* recommended)
{
	OsinfoResources* resources = NULL;
	OsinfoResources* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp31_ = FALSE;
	OsinfoResources* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_os_database_get_default_resources ();
	resources = _tmp0_;
	if (recommended != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = osinfo_resources_get_n_cpus (recommended);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		OsinfoResources* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = resources;
		_tmp5_ = osinfo_resources_get_n_cpus (recommended);
		_tmp6_ = _tmp5_;
		osinfo_resources_set_n_cpus (_tmp4_, _tmp6_);
	} else {
		gboolean _tmp7_ = FALSE;
		if (minimum != NULL) {
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = osinfo_resources_get_n_cpus (minimum);
			_tmp9_ = _tmp8_;
			_tmp7_ = _tmp9_ > 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			OsinfoResources* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			OsinfoResources* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp10_ = resources;
			_tmp11_ = osinfo_resources_get_n_cpus (minimum);
			_tmp12_ = _tmp11_;
			_tmp13_ = resources;
			_tmp14_ = osinfo_resources_get_n_cpus (_tmp13_);
			_tmp15_ = _tmp14_;
			osinfo_resources_set_n_cpus (_tmp10_, MAX (_tmp12_, _tmp15_));
		}
	}
	if (recommended != NULL) {
		gint64 _tmp17_;
		gint64 _tmp18_;
		_tmp17_ = osinfo_resources_get_ram (recommended);
		_tmp18_ = _tmp17_;
		_tmp16_ = _tmp18_ > ((gint64) 0);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		OsinfoResources* _tmp19_;
		gint64 _tmp20_;
		gint64 _tmp21_;
		_tmp19_ = resources;
		_tmp20_ = osinfo_resources_get_ram (recommended);
		_tmp21_ = _tmp20_;
		osinfo_resources_set_ram (_tmp19_, _tmp21_);
	} else {
		gboolean _tmp22_ = FALSE;
		if (minimum != NULL) {
			gint64 _tmp23_;
			gint64 _tmp24_;
			_tmp23_ = osinfo_resources_get_ram (minimum);
			_tmp24_ = _tmp23_;
			_tmp22_ = _tmp24_ > ((gint64) 0);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			OsinfoResources* _tmp25_;
			gint64 _tmp26_;
			gint64 _tmp27_;
			OsinfoResources* _tmp28_;
			gint64 _tmp29_;
			gint64 _tmp30_;
			_tmp25_ = resources;
			_tmp26_ = osinfo_resources_get_ram (minimum);
			_tmp27_ = _tmp26_;
			_tmp28_ = resources;
			_tmp29_ = osinfo_resources_get_ram (_tmp28_);
			_tmp30_ = _tmp29_;
			osinfo_resources_set_ram (_tmp25_, MAX (_tmp27_, _tmp30_));
		}
	}
	if (recommended != NULL) {
		gint64 _tmp32_;
		gint64 _tmp33_;
		_tmp32_ = osinfo_resources_get_storage (recommended);
		_tmp33_ = _tmp32_;
		_tmp31_ = _tmp33_ > ((gint64) 0);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		OsinfoResources* _tmp34_;
		gint64 _tmp35_;
		gint64 _tmp36_;
		_tmp34_ = resources;
		_tmp35_ = osinfo_resources_get_storage (recommended);
		_tmp36_ = _tmp35_;
		osinfo_resources_set_storage (_tmp34_, _tmp36_);
	} else {
		gboolean _tmp37_ = FALSE;
		if (minimum != NULL) {
			gint64 _tmp38_;
			gint64 _tmp39_;
			_tmp38_ = osinfo_resources_get_storage (minimum);
			_tmp39_ = _tmp38_;
			_tmp37_ = _tmp39_ > ((gint64) 0);
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			OsinfoResources* _tmp40_;
			gint64 _tmp41_;
			gint64 _tmp42_;
			OsinfoResources* _tmp43_;
			gint64 _tmp44_;
			gint64 _tmp45_;
			_tmp40_ = resources;
			_tmp41_ = osinfo_resources_get_storage (minimum);
			_tmp42_ = _tmp41_;
			_tmp43_ = resources;
			_tmp44_ = osinfo_resources_get_storage (_tmp43_);
			_tmp45_ = _tmp44_;
			osinfo_resources_set_storage (_tmp40_, MAX (_tmp42_ * 2, _tmp45_));
		}
	}
	result = resources;
	return result;
}

static OsinfoResources*
boxes_os_database_get_prefered_resources (OsinfoResourcesList* list,
                                          gchar** prefs,
                                          gint prefs_length1)
{
	OsinfoResourcesList* filtered = NULL;
	const gchar* _tmp0_;
	OsinfoResourcesList* _tmp1_;
	OsinfoResourcesList* _tmp2_;
	OsinfoResources* result;
	g_return_val_if_fail (list != NULL, NULL);
	if (prefs_length1 <= 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = prefs[0];
	_tmp1_ = boxes_os_database_filter_resources_list_by_arch (list, _tmp0_);
	filtered = _tmp1_;
	_tmp2_ = filtered;
	if (osinfo_list_get_length ((OsinfoList*) _tmp2_) <= 0) {
		OsinfoResources* _tmp3_;
		_tmp3_ = boxes_os_database_get_prefered_resources (list, prefs + 1, (gint) (prefs_length1 - 1));
		result = _tmp3_;
		_g_object_unref0 (filtered);
		return result;
	} else {
		OsinfoResourcesList* _tmp4_;
		OsinfoEntity* _tmp5_;
		OsinfoResources* _tmp6_;
		_tmp4_ = filtered;
		_tmp5_ = osinfo_list_get_nth ((OsinfoList*) _tmp4_, 0);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, osinfo_resources_get_type ()) ? ((OsinfoResources*) _tmp5_) : NULL);
		result = _tmp6_;
		_g_object_unref0 (filtered);
		return result;
	}
}

static OsinfoResourcesList*
boxes_os_database_filter_resources_list_by_arch (OsinfoResourcesList* list,
                                                 const gchar* arch)
{
	OsinfoResourcesList* new_list = NULL;
	OsinfoResourcesList* _tmp0_;
	GList* _tmp1_;
	OsinfoResourcesList* result;
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (arch != NULL, NULL);
	_tmp0_ = osinfo_resourceslist_new ();
	new_list = _tmp0_;
	_tmp1_ = osinfo_list_get_elements ((OsinfoList*) list);
	{
		GList* entity_collection = NULL;
		GList* entity_it = NULL;
		entity_collection = _tmp1_;
		for (entity_it = entity_collection; entity_it != NULL; entity_it = entity_it->next) {
			OsinfoEntity* entity = NULL;
			entity = (OsinfoEntity*) entity_it->data;
			{
				OsinfoResources* resources = NULL;
				OsinfoEntity* _tmp2_;
				OsinfoResources* _tmp3_;
				BoxesCPUArchCompatibility compatibility = 0;
				OsinfoResources* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = entity;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, osinfo_resources_get_type ()) ? ((OsinfoResources*) _tmp2_) : NULL);
				resources = _tmp3_;
				_tmp4_ = resources;
				_tmp5_ = osinfo_resources_get_architecture (_tmp4_);
				_tmp6_ = _tmp5_;
				compatibility = boxes_compare_cpu_architectures (arch, _tmp6_);
				if (compatibility == BOXES_CPU_ARCH_COMPATIBILITY_IDENTICAL) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = compatibility == BOXES_CPU_ARCH_COMPATIBILITY_COMPATIBLE;
				}
				if (_tmp7_) {
					OsinfoResourcesList* _tmp8_;
					OsinfoResources* _tmp9_;
					_tmp8_ = new_list;
					_tmp9_ = resources;
					osinfo_list_add ((OsinfoList*) _tmp8_, (OsinfoEntity*) _tmp9_);
				}
				_g_object_unref0 (resources);
			}
		}
		(entity_collection == NULL) ? NULL : (entity_collection = (g_list_free (entity_collection), NULL));
	}
	result = new_list;
	return result;
}

static void
boxes_os_database_ensure_db_loaded_data_free (gpointer _data)
{
	BoxesOsDatabaseEnsureDbLoadedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesOsDatabaseEnsureDbLoadedData, _data_);
}

static void
boxes_os_database_ensure_db_loaded (BoxesOSDatabase* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	BoxesOsDatabaseEnsureDbLoadedData* _data_;
	BoxesOSDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesOsDatabaseEnsureDbLoadedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_os_database_ensure_db_loaded_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_os_database_ensure_db_loaded_co (_data_);
}

static gboolean
boxes_os_database_ensure_db_loaded_finish (BoxesOSDatabase* self,
                                           GAsyncResult* _res_)
{
	gboolean result;
	BoxesOsDatabaseEnsureDbLoadedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		BoxesOSDatabase* self;
		self = _data42_->self;
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		BoxesOSDatabase* self;
		self = _data43_->_data42_->self;
		block42_data_unref (_data43_->_data42_);
		_data43_->_data42_ = NULL;
		g_slice_free (Block43Data, _data43_);
	}
}

static void
___lambda6_ (Block43Data* _data43_)
{
	Block42Data* _data42_;
	BoxesOSDatabase* self;
	_data42_ = _data43_->_data42_;
	self = _data42_->self;
	boxes_os_database_ensure_db_loaded_co (_data42_->_async_data_);
	g_signal_handler_disconnect ((GObject*) self, _data43_->db_loaded_id);
}

static void
____lambda6__boxes_os_database_db_loaded (BoxesOSDatabase* _sender,
                                          gpointer self)
{
	___lambda6_ (self);
}

static gboolean
boxes_os_database_ensure_db_loaded_co (BoxesOsDatabaseEnsureDbLoadedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data42_ = g_slice_new0 (Block42Data);
	_data_->_data42_->_ref_count_ = 1;
	_data_->_data42_->self = g_object_ref (_data_->self);
	_data_->_data42_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->db;
	if (_data_->_tmp0_ != NULL) {
		_data_->result = TRUE;
		block42_data_unref (_data_->_data42_);
		_data_->_data42_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->db_loading) {
		_data_->_data43_ = g_slice_new0 (Block43Data);
		_data_->_data43_->_ref_count_ = 1;
		_data_->_data43_->_data42_ = block42_data_ref (_data_->_data42_);
		_data_->_data43_->db_loaded_id = (gulong) 0;
		_data_->_tmp1_ = g_signal_connect_data (_data_->self, "db-loaded", (GCallback) ____lambda6__boxes_os_database_db_loaded, block43_data_ref (_data_->_data43_), (GClosureNotify) block43_data_unref, 0);
		_data_->_data43_->db_loaded_id = _data_->_tmp1_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		block43_data_unref (_data_->_data43_);
		_data_->_data43_ = NULL;
	}
	_data_->_tmp2_ = _data_->self->priv->db;
	_data_->result = _data_->_tmp2_ != NULL;
	block42_data_unref (_data_->_data42_);
	_data_->_data42_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BoxesOSDatabase*
boxes_os_database_construct (GType object_type)
{
	BoxesOSDatabase * self = NULL;
	self = (BoxesOSDatabase*) g_object_new (object_type, NULL);
	return self;
}

BoxesOSDatabase*
boxes_os_database_new (void)
{
	return boxes_os_database_construct (BOXES_TYPE_OS_DATABASE);
}

static void
boxes_os_database_class_init (BoxesOSDatabaseClass * klass,
                              gpointer klass_data)
{
	boxes_os_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesOSDatabase_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_os_database_finalize;
	boxes_os_database_signals[BOXES_OS_DATABASE_DB_LOADED_SIGNAL] = g_signal_new ("db-loaded", BOXES_TYPE_OS_DATABASE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
boxes_os_database_instance_init (BoxesOSDatabase * self,
                                 gpointer klass)
{
	self->priv = boxes_os_database_get_instance_private (self);
}

static void
boxes_os_database_finalize (GObject * obj)
{
	BoxesOSDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_OS_DATABASE, BoxesOSDatabase);
	_g_object_unref0 (self->priv->db);
	G_OBJECT_CLASS (boxes_os_database_parent_class)->finalize (obj);
}

static GType
boxes_os_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesOSDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_os_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesOSDatabase), 0, (GInstanceInitFunc) boxes_os_database_instance_init, NULL };
	GType boxes_os_database_type_id;
	boxes_os_database_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesOSDatabase", &g_define_type_info, 0);
	BoxesOSDatabase_private_offset = g_type_add_instance_private (boxes_os_database_type_id, sizeof (BoxesOSDatabasePrivate));
	return boxes_os_database_type_id;
}

GType
boxes_os_database_get_type (void)
{
	static volatile gsize boxes_os_database_type_id__once = 0;
	if (g_once_init_enter (&boxes_os_database_type_id__once)) {
		GType boxes_os_database_type_id;
		boxes_os_database_type_id = boxes_os_database_get_type_once ();
		g_once_init_leave (&boxes_os_database_type_id__once, boxes_os_database_type_id);
	}
	return boxes_os_database_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

