

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Enums
    ( 

 -- * Enumerations


-- ** EulerOrder #enum:EulerOrder#

    EulerOrder(..)                          ,


-- ** RayIntersectionKind #enum:RayIntersectionKind#

    RayIntersectionKind(..)                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum RayIntersectionKind
-- | The type of intersection.
-- 
-- /Since: 1.10/
data RayIntersectionKind = 
      RayIntersectionKindNone
    -- ^ No intersection
    | RayIntersectionKindEnter
    -- ^ The ray is entering the intersected
    --   object
    | RayIntersectionKindLeave
    -- ^ The ray is leaving the intersected
    --   object
    | AnotherRayIntersectionKind Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RayIntersectionKind where
    fromEnum RayIntersectionKindNone = 0
    fromEnum RayIntersectionKindEnter = 1
    fromEnum RayIntersectionKindLeave = 2
    fromEnum (AnotherRayIntersectionKind k) = k

    toEnum 0 = RayIntersectionKindNone
    toEnum 1 = RayIntersectionKindEnter
    toEnum 2 = RayIntersectionKindLeave
    toEnum k = AnotherRayIntersectionKind k

instance P.Ord RayIntersectionKind where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum EulerOrder
-- | Specify the order of the rotations on each axis.
-- 
-- The 'GI.Graphene.Enums.EulerOrderDefault' value is special, and is used
-- as an alias for one of the other orders.
-- 
-- /Since: 1.2/
data EulerOrder = 
      EulerOrderDefault
    -- ^ Rotate in the default order; the
    --   default order is one of the following enumeration values
    | EulerOrderXyz
    -- ^ Rotate in the X, Y, and Z order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSxyz'
    | EulerOrderYzx
    -- ^ Rotate in the Y, Z, and X order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSyzx'
    | EulerOrderZxy
    -- ^ Rotate in the Z, X, and Y order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSzxy'
    | EulerOrderXzy
    -- ^ Rotate in the X, Z, and Y order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSxzy'
    | EulerOrderYxz
    -- ^ Rotate in the Y, X, and Z order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSyxz'
    | EulerOrderZyx
    -- ^ Rotate in the Z, Y, and X order. Deprecated in
    --   Graphene 1.10, it\'s an alias for 'GI.Graphene.Enums.EulerOrderSzyx'
    | EulerOrderSxyz
    -- ^ Defines a static rotation along the X, Y, and Z axes (Since: 1.10)
    | EulerOrderSxyx
    -- ^ Defines a static rotation along the X, Y, and X axes (Since: 1.10)
    | EulerOrderSxzy
    -- ^ Defines a static rotation along the X, Z, and Y axes (Since: 1.10)
    | EulerOrderSxzx
    -- ^ Defines a static rotation along the X, Z, and X axes (Since: 1.10)
    | EulerOrderSyzx
    -- ^ Defines a static rotation along the Y, Z, and X axes (Since: 1.10)
    | EulerOrderSyzy
    -- ^ Defines a static rotation along the Y, Z, and Y axes (Since: 1.10)
    | EulerOrderSyxz
    -- ^ Defines a static rotation along the Y, X, and Z axes (Since: 1.10)
    | EulerOrderSyxy
    -- ^ Defines a static rotation along the Y, X, and Y axes (Since: 1.10)
    | EulerOrderSzxy
    -- ^ Defines a static rotation along the Z, X, and Y axes (Since: 1.10)
    | EulerOrderSzxz
    -- ^ Defines a static rotation along the Z, X, and Z axes (Since: 1.10)
    | EulerOrderSzyx
    -- ^ Defines a static rotation along the Z, Y, and X axes (Since: 1.10)
    | EulerOrderSzyz
    -- ^ Defines a static rotation along the Z, Y, and Z axes (Since: 1.10)
    | EulerOrderRzyx
    -- ^ Defines a relative rotation along the Z, Y, and X axes (Since: 1.10)
    | EulerOrderRxyx
    -- ^ Defines a relative rotation along the X, Y, and X axes (Since: 1.10)
    | EulerOrderRyzx
    -- ^ Defines a relative rotation along the Y, Z, and X axes (Since: 1.10)
    | EulerOrderRxzx
    -- ^ Defines a relative rotation along the X, Z, and X axes (Since: 1.10)
    | EulerOrderRxzy
    -- ^ Defines a relative rotation along the X, Z, and Y axes (Since: 1.10)
    | EulerOrderRyzy
    -- ^ Defines a relative rotation along the Y, Z, and Y axes (Since: 1.10)
    | EulerOrderRzxy
    -- ^ Defines a relative rotation along the Z, X, and Y axes (Since: 1.10)
    | EulerOrderRyxy
    -- ^ Defines a relative rotation along the Y, X, and Y axes (Since: 1.10)
    | EulerOrderRyxz
    -- ^ Defines a relative rotation along the Y, X, and Z axes (Since: 1.10)
    | EulerOrderRzxz
    -- ^ Defines a relative rotation along the Z, X, and Z axes (Since: 1.10)
    | EulerOrderRxyz
    -- ^ Defines a relative rotation along the X, Y, and Z axes (Since: 1.10)
    | EulerOrderRzyz
    -- ^ Defines a relative rotation along the Z, Y, and Z axes (Since: 1.10)
    | AnotherEulerOrder Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EulerOrder where
    fromEnum EulerOrderDefault = -1
    fromEnum EulerOrderXyz = 0
    fromEnum EulerOrderYzx = 1
    fromEnum EulerOrderZxy = 2
    fromEnum EulerOrderXzy = 3
    fromEnum EulerOrderYxz = 4
    fromEnum EulerOrderZyx = 5
    fromEnum EulerOrderSxyz = 6
    fromEnum EulerOrderSxyx = 7
    fromEnum EulerOrderSxzy = 8
    fromEnum EulerOrderSxzx = 9
    fromEnum EulerOrderSyzx = 10
    fromEnum EulerOrderSyzy = 11
    fromEnum EulerOrderSyxz = 12
    fromEnum EulerOrderSyxy = 13
    fromEnum EulerOrderSzxy = 14
    fromEnum EulerOrderSzxz = 15
    fromEnum EulerOrderSzyx = 16
    fromEnum EulerOrderSzyz = 17
    fromEnum EulerOrderRzyx = 18
    fromEnum EulerOrderRxyx = 19
    fromEnum EulerOrderRyzx = 20
    fromEnum EulerOrderRxzx = 21
    fromEnum EulerOrderRxzy = 22
    fromEnum EulerOrderRyzy = 23
    fromEnum EulerOrderRzxy = 24
    fromEnum EulerOrderRyxy = 25
    fromEnum EulerOrderRyxz = 26
    fromEnum EulerOrderRzxz = 27
    fromEnum EulerOrderRxyz = 28
    fromEnum EulerOrderRzyz = 29
    fromEnum (AnotherEulerOrder k) = k

    toEnum -1 = EulerOrderDefault
    toEnum 0 = EulerOrderXyz
    toEnum 1 = EulerOrderYzx
    toEnum 2 = EulerOrderZxy
    toEnum 3 = EulerOrderXzy
    toEnum 4 = EulerOrderYxz
    toEnum 5 = EulerOrderZyx
    toEnum 6 = EulerOrderSxyz
    toEnum 7 = EulerOrderSxyx
    toEnum 8 = EulerOrderSxzy
    toEnum 9 = EulerOrderSxzx
    toEnum 10 = EulerOrderSyzx
    toEnum 11 = EulerOrderSyzy
    toEnum 12 = EulerOrderSyxz
    toEnum 13 = EulerOrderSyxy
    toEnum 14 = EulerOrderSzxy
    toEnum 15 = EulerOrderSzxz
    toEnum 16 = EulerOrderSzyx
    toEnum 17 = EulerOrderSzyz
    toEnum 18 = EulerOrderRzyx
    toEnum 19 = EulerOrderRxyx
    toEnum 20 = EulerOrderRyzx
    toEnum 21 = EulerOrderRxzx
    toEnum 22 = EulerOrderRxzy
    toEnum 23 = EulerOrderRyzy
    toEnum 24 = EulerOrderRzxy
    toEnum 25 = EulerOrderRyxy
    toEnum 26 = EulerOrderRyxz
    toEnum 27 = EulerOrderRzxz
    toEnum 28 = EulerOrderRxyz
    toEnum 29 = EulerOrderRzyz
    toEnum k = AnotherEulerOrder k

instance P.Ord EulerOrder where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)


