{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents a large dynamic list of items using multiple columns with headers.
-- 
-- @GtkColumnView@ uses the factories of its columns to generate a cell widget for
-- each column, for each visible item and displays them together as the row for
-- this item.
-- 
-- The [ColumnView:showRowSeparators]("GI.Gtk.Objects.ColumnView#g:attr:showRowSeparators") and
-- [ColumnView:showColumnSeparators]("GI.Gtk.Objects.ColumnView#g:attr:showColumnSeparators") properties offer a simple way
-- to display separators between the rows or columns.
-- 
-- @GtkColumnView@ allows the user to select items according to the selection
-- characteristics of the model. For models that allow multiple selected items,
-- it is possible to turn on *rubberband selection*, using
-- [ColumnView:enableRubberband]("GI.Gtk.Objects.ColumnView#g:attr:enableRubberband").
-- 
-- The column view supports sorting that can be customized by the user by
-- clicking on column headers. To set this up, the @GtkSorter@ returned by
-- 'GI.Gtk.Objects.ColumnView.columnViewGetSorter' must be attached to a sort model for the
-- data that the view is showing, and the columns must have sorters attached to
-- them by calling 'GI.Gtk.Objects.ColumnViewColumn.columnViewColumnSetSorter'. The initial sort
-- order can be set with 'GI.Gtk.Objects.ColumnView.columnViewSortByColumn'.
-- 
-- The column view also supports interactive resizing and reordering of
-- columns, via Drag-and-Drop of the column headers. This can be enabled or
-- disabled with the [ColumnView:reorderable]("GI.Gtk.Objects.ColumnView#g:attr:reorderable") and
-- [ColumnViewColumn:resizable]("GI.Gtk.Objects.ColumnViewColumn#g:attr:resizable") properties.
-- 
-- To learn more about the list widget framework, see the
-- <https://docs.gtk.org/gtk4/section-list-widget.html overview>.
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >columnview[.column-separators][.rich-list][.navigation-sidebar][.data-table]
-- >├── header
-- >│   ├── <column header>
-- >┊   ┊
-- >│   ╰── <column header>
-- >│
-- >├── listview
-- >│
-- >┊
-- >╰── [rubberband]
-- 
-- 
-- @GtkColumnView@ uses a single CSS node named columnview. It may carry the
-- .column-separators style class, when [ColumnView:showColumnSeparators]("GI.Gtk.Objects.ColumnView#g:attr:showColumnSeparators")
-- property is set. Header widgets appear below a node with name header.
-- The rows are contained in a @GtkListView@ widget, so there is a listview
-- node with the same structure as for a standalone @GtkListView@ widget.
-- If [ColumnView:showRowSeparators]("GI.Gtk.Objects.ColumnView#g:attr:showRowSeparators") is set, it will be passed
-- on to the list view, causing its CSS node to carry the .separators style class.
-- For rubberband selection, a node with name rubberband is used.
-- 
-- The main columnview node may also carry style classes to select
-- the style of <https://docs.gtk.org/gtk4/section-list-widget.html#list-styles list presentation>:
-- .rich-list, .navigation-sidebar or .data-table.
-- 
-- = Accessibility
-- 
-- @GtkColumnView@ uses the 'GI.Gtk.Enums.AccessibleRoleTreeGrid' role, header title
-- widgets are using the 'GI.Gtk.Enums.AccessibleRoleColumnHeader' role. The row widgets
-- are using the 'GI.Gtk.Enums.AccessibleRoleRow' role, and individual cells are using
-- the 'GI.Gtk.Enums.AccessibleRoleGridCell' role

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ColumnView
    ( 

-- * Exported types
    ColumnView(..)                          ,
    IsColumnView                            ,
    toColumnView                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [appendColumn]("GI.Gtk.Objects.ColumnView#g:method:appendColumn"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertColumn]("GI.Gtk.Objects.ColumnView#g:method:insertColumn"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeColumn]("GI.Gtk.Objects.ColumnView#g:method:removeColumn"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollTo]("GI.Gtk.Objects.ColumnView#g:method:scrollTo"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [sortByColumn]("GI.Gtk.Objects.ColumnView#g:method:sortByColumn"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBorder]("GI.Gtk.Interfaces.Scrollable#g:method:getBorder"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getColumns]("GI.Gtk.Objects.ColumnView#g:method:getColumns"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEnableRubberband]("GI.Gtk.Objects.ColumnView#g:method:getEnableRubberband"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderFactory]("GI.Gtk.Objects.ColumnView#g:method:getHeaderFactory"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getHscrollPolicy"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getModel]("GI.Gtk.Objects.ColumnView#g:method:getModel"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getReorderable]("GI.Gtk.Objects.ColumnView#g:method:getReorderable"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRowFactory]("GI.Gtk.Objects.ColumnView#g:method:getRowFactory"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowColumnSeparators]("GI.Gtk.Objects.ColumnView#g:method:getShowColumnSeparators"), [getShowRowSeparators]("GI.Gtk.Objects.ColumnView#g:method:getShowRowSeparators"), [getSingleClickActivate]("GI.Gtk.Objects.ColumnView#g:method:getSingleClickActivate"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSorter]("GI.Gtk.Objects.ColumnView#g:method:getSorter"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabBehavior]("GI.Gtk.Objects.ColumnView#g:method:getTabBehavior"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getVscrollPolicy"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEnableRubberband]("GI.Gtk.Objects.ColumnView#g:method:setEnableRubberband"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHeaderFactory]("GI.Gtk.Objects.ColumnView#g:method:setHeaderFactory"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setHscrollPolicy"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setModel]("GI.Gtk.Objects.ColumnView#g:method:setModel"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setReorderable]("GI.Gtk.Objects.ColumnView#g:method:setReorderable"), [setRowFactory]("GI.Gtk.Objects.ColumnView#g:method:setRowFactory"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowColumnSeparators]("GI.Gtk.Objects.ColumnView#g:method:setShowColumnSeparators"), [setShowRowSeparators]("GI.Gtk.Objects.ColumnView#g:method:setShowRowSeparators"), [setSingleClickActivate]("GI.Gtk.Objects.ColumnView#g:method:setSingleClickActivate"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabBehavior]("GI.Gtk.Objects.ColumnView#g:method:setTabBehavior"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setVscrollPolicy").

#if defined(ENABLE_OVERLOADING)
    ResolveColumnViewMethod                 ,
#endif

-- ** appendColumn #method:appendColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewAppendColumnMethodInfo        ,
#endif
    columnViewAppendColumn                  ,


-- ** getColumns #method:getColumns#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetColumnsMethodInfo          ,
#endif
    columnViewGetColumns                    ,


-- ** getEnableRubberband #method:getEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetEnableRubberbandMethodInfo ,
#endif
    columnViewGetEnableRubberband           ,


-- ** getHeaderFactory #method:getHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetHeaderFactoryMethodInfo    ,
#endif
    columnViewGetHeaderFactory              ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetModelMethodInfo            ,
#endif
    columnViewGetModel                      ,


-- ** getReorderable #method:getReorderable#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetReorderableMethodInfo      ,
#endif
    columnViewGetReorderable                ,


-- ** getRowFactory #method:getRowFactory#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetRowFactoryMethodInfo       ,
#endif
    columnViewGetRowFactory                 ,


-- ** getShowColumnSeparators #method:getShowColumnSeparators#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetShowColumnSeparatorsMethodInfo,
#endif
    columnViewGetShowColumnSeparators       ,


-- ** getShowRowSeparators #method:getShowRowSeparators#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetShowRowSeparatorsMethodInfo,
#endif
    columnViewGetShowRowSeparators          ,


-- ** getSingleClickActivate #method:getSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetSingleClickActivateMethodInfo,
#endif
    columnViewGetSingleClickActivate        ,


-- ** getSorter #method:getSorter#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetSorterMethodInfo           ,
#endif
    columnViewGetSorter                     ,


-- ** getTabBehavior #method:getTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ColumnViewGetTabBehaviorMethodInfo      ,
#endif
    columnViewGetTabBehavior                ,


-- ** insertColumn #method:insertColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewInsertColumnMethodInfo        ,
#endif
    columnViewInsertColumn                  ,


-- ** new #method:new#

    columnViewNew                           ,


-- ** removeColumn #method:removeColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewRemoveColumnMethodInfo        ,
#endif
    columnViewRemoveColumn                  ,


-- ** scrollTo #method:scrollTo#

#if defined(ENABLE_OVERLOADING)
    ColumnViewScrollToMethodInfo            ,
#endif
    columnViewScrollTo                      ,


-- ** setEnableRubberband #method:setEnableRubberband#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetEnableRubberbandMethodInfo ,
#endif
    columnViewSetEnableRubberband           ,


-- ** setHeaderFactory #method:setHeaderFactory#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetHeaderFactoryMethodInfo    ,
#endif
    columnViewSetHeaderFactory              ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetModelMethodInfo            ,
#endif
    columnViewSetModel                      ,


-- ** setReorderable #method:setReorderable#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetReorderableMethodInfo      ,
#endif
    columnViewSetReorderable                ,


-- ** setRowFactory #method:setRowFactory#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetRowFactoryMethodInfo       ,
#endif
    columnViewSetRowFactory                 ,


-- ** setShowColumnSeparators #method:setShowColumnSeparators#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetShowColumnSeparatorsMethodInfo,
#endif
    columnViewSetShowColumnSeparators       ,


-- ** setShowRowSeparators #method:setShowRowSeparators#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetShowRowSeparatorsMethodInfo,
#endif
    columnViewSetShowRowSeparators          ,


-- ** setSingleClickActivate #method:setSingleClickActivate#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetSingleClickActivateMethodInfo,
#endif
    columnViewSetSingleClickActivate        ,


-- ** setTabBehavior #method:setTabBehavior#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSetTabBehaviorMethodInfo      ,
#endif
    columnViewSetTabBehavior                ,


-- ** sortByColumn #method:sortByColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSortByColumnMethodInfo        ,
#endif
    columnViewSortByColumn                  ,




 -- * Properties


-- ** columns #attr:columns#
-- | The list of columns.

#if defined(ENABLE_OVERLOADING)
    ColumnViewColumnsPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewColumns                       ,
#endif
    getColumnViewColumns                    ,


-- ** enableRubberband #attr:enableRubberband#
-- | Allow rubberband selection.

#if defined(ENABLE_OVERLOADING)
    ColumnViewEnableRubberbandPropertyInfo  ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewEnableRubberband              ,
#endif
    constructColumnViewEnableRubberband     ,
    getColumnViewEnableRubberband           ,
    setColumnViewEnableRubberband           ,


-- ** headerFactory #attr:headerFactory#
-- | Factory for creating header widgets.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ListHeader.ListHeader' objects.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ColumnViewHeaderFactoryPropertyInfo     ,
#endif
    clearColumnViewHeaderFactory            ,
#if defined(ENABLE_OVERLOADING)
    columnViewHeaderFactory                 ,
#endif
    constructColumnViewHeaderFactory        ,
    getColumnViewHeaderFactory              ,
    setColumnViewHeaderFactory              ,


-- ** model #attr:model#
-- | Model for the items displayed.

#if defined(ENABLE_OVERLOADING)
    ColumnViewModelPropertyInfo             ,
#endif
    clearColumnViewModel                    ,
#if defined(ENABLE_OVERLOADING)
    columnViewModel                         ,
#endif
    constructColumnViewModel                ,
    getColumnViewModel                      ,
    setColumnViewModel                      ,


-- ** reorderable #attr:reorderable#
-- | Whether columns are reorderable.

#if defined(ENABLE_OVERLOADING)
    ColumnViewReorderablePropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewReorderable                   ,
#endif
    constructColumnViewReorderable          ,
    getColumnViewReorderable                ,
    setColumnViewReorderable                ,


-- ** rowFactory #attr:rowFactory#
-- | The factory used for configuring rows.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ColumnViewRow.ColumnViewRow' objects.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ColumnViewRowFactoryPropertyInfo        ,
#endif
    clearColumnViewRowFactory               ,
#if defined(ENABLE_OVERLOADING)
    columnViewRowFactory                    ,
#endif
    constructColumnViewRowFactory           ,
    getColumnViewRowFactory                 ,
    setColumnViewRowFactory                 ,


-- ** showColumnSeparators #attr:showColumnSeparators#
-- | Show separators between columns.

#if defined(ENABLE_OVERLOADING)
    ColumnViewShowColumnSeparatorsPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewShowColumnSeparators          ,
#endif
    constructColumnViewShowColumnSeparators ,
    getColumnViewShowColumnSeparators       ,
    setColumnViewShowColumnSeparators       ,


-- ** showRowSeparators #attr:showRowSeparators#
-- | Show separators between rows.

#if defined(ENABLE_OVERLOADING)
    ColumnViewShowRowSeparatorsPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewShowRowSeparators             ,
#endif
    constructColumnViewShowRowSeparators    ,
    getColumnViewShowRowSeparators          ,
    setColumnViewShowRowSeparators          ,


-- ** singleClickActivate #attr:singleClickActivate#
-- | Activate rows on single click and select them on hover.

#if defined(ENABLE_OVERLOADING)
    ColumnViewSingleClickActivatePropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewSingleClickActivate           ,
#endif
    constructColumnViewSingleClickActivate  ,
    getColumnViewSingleClickActivate        ,
    setColumnViewSingleClickActivate        ,


-- ** sorter #attr:sorter#
-- | Sorter with the sorting choices of the user.

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterPropertyInfo            ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewSorter                        ,
#endif
    getColumnViewSorter                     ,


-- ** tabBehavior #attr:tabBehavior#
-- | Behavior of the \<kbd>Tab\<\/kbd> key
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ColumnViewTabBehaviorPropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewTabBehavior                   ,
#endif
    constructColumnViewTabBehavior          ,
    getColumnViewTabBehavior                ,
    setColumnViewTabBehavior                ,




 -- * Signals


-- ** activate #signal:activate#

    ColumnViewActivateCallback              ,
#if defined(ENABLE_OVERLOADING)
    ColumnViewActivateSignalInfo            ,
#endif
    afterColumnViewActivate                 ,
    onColumnViewActivate                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColumnViewColumn as Gtk.ColumnViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColumnViewColumn as Gtk.ColumnViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo

#endif

-- | Memory-managed wrapper type.
newtype ColumnView = ColumnView (SP.ManagedPtr ColumnView)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColumnView where
    toManagedPtr (ColumnView p) = p

foreign import ccall "gtk_column_view_get_type"
    c_gtk_column_view_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColumnView where
    glibType = c_gtk_column_view_get_type

instance B.Types.GObject ColumnView

-- | Type class for types which can be safely cast to t'ColumnView', for instance with `toColumnView`.
class (SP.GObject o, O.IsDescendantOf ColumnView o) => IsColumnView o
instance (SP.GObject o, O.IsDescendantOf ColumnView o) => IsColumnView o

instance O.HasParentTypes ColumnView
type instance O.ParentTypes ColumnView = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Scrollable.Scrollable]

-- | Cast to t'ColumnView', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toColumnView :: (MIO.MonadIO m, IsColumnView o) => o -> m ColumnView
toColumnView = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColumnView

-- | Convert t'ColumnView' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColumnView) where
    gvalueGType_ = c_gtk_column_view_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ColumnView)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ColumnView)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ColumnView ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveColumnViewMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColumnViewMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveColumnViewMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveColumnViewMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveColumnViewMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveColumnViewMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveColumnViewMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveColumnViewMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveColumnViewMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveColumnViewMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveColumnViewMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveColumnViewMethod "appendColumn" o = ColumnViewAppendColumnMethodInfo
    ResolveColumnViewMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveColumnViewMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveColumnViewMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveColumnViewMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveColumnViewMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveColumnViewMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveColumnViewMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveColumnViewMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveColumnViewMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveColumnViewMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveColumnViewMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveColumnViewMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveColumnViewMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveColumnViewMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveColumnViewMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveColumnViewMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveColumnViewMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveColumnViewMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveColumnViewMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveColumnViewMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveColumnViewMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveColumnViewMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveColumnViewMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveColumnViewMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveColumnViewMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveColumnViewMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveColumnViewMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveColumnViewMethod "insertColumn" o = ColumnViewInsertColumnMethodInfo
    ResolveColumnViewMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveColumnViewMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveColumnViewMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveColumnViewMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveColumnViewMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveColumnViewMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveColumnViewMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveColumnViewMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveColumnViewMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveColumnViewMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveColumnViewMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveColumnViewMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveColumnViewMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveColumnViewMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveColumnViewMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveColumnViewMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveColumnViewMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveColumnViewMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveColumnViewMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveColumnViewMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveColumnViewMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveColumnViewMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveColumnViewMethod "removeColumn" o = ColumnViewRemoveColumnMethodInfo
    ResolveColumnViewMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveColumnViewMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveColumnViewMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveColumnViewMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveColumnViewMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveColumnViewMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveColumnViewMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveColumnViewMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveColumnViewMethod "scrollTo" o = ColumnViewScrollToMethodInfo
    ResolveColumnViewMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveColumnViewMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveColumnViewMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveColumnViewMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveColumnViewMethod "sortByColumn" o = ColumnViewSortByColumnMethodInfo
    ResolveColumnViewMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveColumnViewMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveColumnViewMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveColumnViewMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveColumnViewMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveColumnViewMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveColumnViewMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveColumnViewMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveColumnViewMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveColumnViewMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveColumnViewMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveColumnViewMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveColumnViewMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveColumnViewMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveColumnViewMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveColumnViewMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveColumnViewMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveColumnViewMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveColumnViewMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveColumnViewMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveColumnViewMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveColumnViewMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveColumnViewMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveColumnViewMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveColumnViewMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveColumnViewMethod "getBorder" o = Gtk.Scrollable.ScrollableGetBorderMethodInfo
    ResolveColumnViewMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveColumnViewMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveColumnViewMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveColumnViewMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveColumnViewMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveColumnViewMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveColumnViewMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveColumnViewMethod "getColumns" o = ColumnViewGetColumnsMethodInfo
    ResolveColumnViewMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveColumnViewMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveColumnViewMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveColumnViewMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveColumnViewMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveColumnViewMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveColumnViewMethod "getEnableRubberband" o = ColumnViewGetEnableRubberbandMethodInfo
    ResolveColumnViewMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveColumnViewMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveColumnViewMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveColumnViewMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveColumnViewMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveColumnViewMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveColumnViewMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveColumnViewMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveColumnViewMethod "getHadjustment" o = Gtk.Scrollable.ScrollableGetHadjustmentMethodInfo
    ResolveColumnViewMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveColumnViewMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveColumnViewMethod "getHeaderFactory" o = ColumnViewGetHeaderFactoryMethodInfo
    ResolveColumnViewMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveColumnViewMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveColumnViewMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveColumnViewMethod "getHscrollPolicy" o = Gtk.Scrollable.ScrollableGetHscrollPolicyMethodInfo
    ResolveColumnViewMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveColumnViewMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveColumnViewMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveColumnViewMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveColumnViewMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveColumnViewMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveColumnViewMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveColumnViewMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveColumnViewMethod "getModel" o = ColumnViewGetModelMethodInfo
    ResolveColumnViewMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveColumnViewMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveColumnViewMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveColumnViewMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveColumnViewMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveColumnViewMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveColumnViewMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveColumnViewMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveColumnViewMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveColumnViewMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveColumnViewMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveColumnViewMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveColumnViewMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveColumnViewMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveColumnViewMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveColumnViewMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveColumnViewMethod "getReorderable" o = ColumnViewGetReorderableMethodInfo
    ResolveColumnViewMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveColumnViewMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveColumnViewMethod "getRowFactory" o = ColumnViewGetRowFactoryMethodInfo
    ResolveColumnViewMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveColumnViewMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveColumnViewMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveColumnViewMethod "getShowColumnSeparators" o = ColumnViewGetShowColumnSeparatorsMethodInfo
    ResolveColumnViewMethod "getShowRowSeparators" o = ColumnViewGetShowRowSeparatorsMethodInfo
    ResolveColumnViewMethod "getSingleClickActivate" o = ColumnViewGetSingleClickActivateMethodInfo
    ResolveColumnViewMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveColumnViewMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveColumnViewMethod "getSorter" o = ColumnViewGetSorterMethodInfo
    ResolveColumnViewMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveColumnViewMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveColumnViewMethod "getTabBehavior" o = ColumnViewGetTabBehaviorMethodInfo
    ResolveColumnViewMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveColumnViewMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveColumnViewMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveColumnViewMethod "getVadjustment" o = Gtk.Scrollable.ScrollableGetVadjustmentMethodInfo
    ResolveColumnViewMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveColumnViewMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveColumnViewMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveColumnViewMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveColumnViewMethod "getVscrollPolicy" o = Gtk.Scrollable.ScrollableGetVscrollPolicyMethodInfo
    ResolveColumnViewMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveColumnViewMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveColumnViewMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveColumnViewMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveColumnViewMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveColumnViewMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveColumnViewMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveColumnViewMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveColumnViewMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveColumnViewMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveColumnViewMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveColumnViewMethod "setEnableRubberband" o = ColumnViewSetEnableRubberbandMethodInfo
    ResolveColumnViewMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveColumnViewMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveColumnViewMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveColumnViewMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveColumnViewMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveColumnViewMethod "setHadjustment" o = Gtk.Scrollable.ScrollableSetHadjustmentMethodInfo
    ResolveColumnViewMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveColumnViewMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveColumnViewMethod "setHeaderFactory" o = ColumnViewSetHeaderFactoryMethodInfo
    ResolveColumnViewMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveColumnViewMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveColumnViewMethod "setHscrollPolicy" o = Gtk.Scrollable.ScrollableSetHscrollPolicyMethodInfo
    ResolveColumnViewMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveColumnViewMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveColumnViewMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveColumnViewMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveColumnViewMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveColumnViewMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveColumnViewMethod "setModel" o = ColumnViewSetModelMethodInfo
    ResolveColumnViewMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveColumnViewMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveColumnViewMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveColumnViewMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveColumnViewMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveColumnViewMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveColumnViewMethod "setReorderable" o = ColumnViewSetReorderableMethodInfo
    ResolveColumnViewMethod "setRowFactory" o = ColumnViewSetRowFactoryMethodInfo
    ResolveColumnViewMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveColumnViewMethod "setShowColumnSeparators" o = ColumnViewSetShowColumnSeparatorsMethodInfo
    ResolveColumnViewMethod "setShowRowSeparators" o = ColumnViewSetShowRowSeparatorsMethodInfo
    ResolveColumnViewMethod "setSingleClickActivate" o = ColumnViewSetSingleClickActivateMethodInfo
    ResolveColumnViewMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveColumnViewMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveColumnViewMethod "setTabBehavior" o = ColumnViewSetTabBehaviorMethodInfo
    ResolveColumnViewMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveColumnViewMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveColumnViewMethod "setVadjustment" o = Gtk.Scrollable.ScrollableSetVadjustmentMethodInfo
    ResolveColumnViewMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveColumnViewMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveColumnViewMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveColumnViewMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveColumnViewMethod "setVscrollPolicy" o = Gtk.Scrollable.ScrollableSetVscrollPolicyMethodInfo
    ResolveColumnViewMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColumnViewMethod t ColumnView, O.OverloadedMethod info ColumnView p) => OL.IsLabel t (ColumnView -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColumnViewMethod t ColumnView, O.OverloadedMethod info ColumnView p, R.HasField t ColumnView p) => R.HasField t ColumnView p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColumnViewMethod t ColumnView, O.OverloadedMethodInfo info ColumnView) => OL.IsLabel t (O.MethodProxy info ColumnView) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ColumnView::activate
-- | Emitted when a row has been activated by the user, usually via activating
-- the GtkListBase|list.activate-item action.
-- 
-- This allows for a convenient way to handle activation in a columnview.
-- See 'GI.Gtk.Objects.ListItem.listItemSetActivatable' for details on how to use this
-- signal.
type ColumnViewActivateCallback =
    Word32
    -- ^ /@position@/: position of item to activate
    -> IO ()

type C_ColumnViewActivateCallback =
    Ptr ColumnView ->                       -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ColumnViewActivateCallback`.
foreign import ccall "wrapper"
    mk_ColumnViewActivateCallback :: C_ColumnViewActivateCallback -> IO (FunPtr C_ColumnViewActivateCallback)

wrap_ColumnViewActivateCallback :: 
    GObject a => (a -> ColumnViewActivateCallback) ->
    C_ColumnViewActivateCallback
wrap_ColumnViewActivateCallback gi'cb gi'selfPtr position _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  position


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' columnView #activate callback
-- @
-- 
-- 
onColumnViewActivate :: (IsColumnView a, MonadIO m) => a -> ((?self :: a) => ColumnViewActivateCallback) -> m SignalHandlerId
onColumnViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ColumnViewActivateCallback wrapped
    wrapped'' <- mk_ColumnViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' columnView #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterColumnViewActivate :: (IsColumnView a, MonadIO m) => a -> ((?self :: a) => ColumnViewActivateCallback) -> m SignalHandlerId
afterColumnViewActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ColumnViewActivateCallback wrapped
    wrapped'' <- mk_ColumnViewActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ColumnViewActivateSignalInfo
instance SignalInfo ColumnViewActivateSignalInfo where
    type HaskellCallbackType ColumnViewActivateSignalInfo = ColumnViewActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ColumnViewActivateCallback cb
        cb'' <- mk_ColumnViewActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:signal:activate"})

#endif

-- VVV Prop "columns"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@columns@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #columns
-- @
getColumnViewColumns :: (MonadIO m, IsColumnView o) => o -> m Gio.ListModel.ListModel
getColumnViewColumns obj = MIO.liftIO $ checkUnexpectedNothing "getColumnViewColumns" $ B.Properties.getObjectPropertyObject obj "columns" Gio.ListModel.ListModel

#if defined(ENABLE_OVERLOADING)
data ColumnViewColumnsPropertyInfo
instance AttrInfo ColumnViewColumnsPropertyInfo where
    type AttrAllowedOps ColumnViewColumnsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewColumnsPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewColumnsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ColumnViewColumnsPropertyInfo = (~) ()
    type AttrTransferType ColumnViewColumnsPropertyInfo = ()
    type AttrGetType ColumnViewColumnsPropertyInfo = Gio.ListModel.ListModel
    type AttrLabel ColumnViewColumnsPropertyInfo = "columns"
    type AttrOrigin ColumnViewColumnsPropertyInfo = ColumnView
    attrGet = getColumnViewColumns
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columns"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:columns"
        })
#endif

-- VVV Prop "enable-rubberband"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #enableRubberband
-- @
getColumnViewEnableRubberband :: (MonadIO m, IsColumnView o) => o -> m Bool
getColumnViewEnableRubberband obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-rubberband"

-- | Set the value of the “@enable-rubberband@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #enableRubberband 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewEnableRubberband :: (MonadIO m, IsColumnView o) => o -> Bool -> m ()
setColumnViewEnableRubberband obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-rubberband" val

-- | Construct a t'GValueConstruct' with valid value for the “@enable-rubberband@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewEnableRubberband :: (IsColumnView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColumnViewEnableRubberband val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-rubberband" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewEnableRubberbandPropertyInfo
instance AttrInfo ColumnViewEnableRubberbandPropertyInfo where
    type AttrAllowedOps ColumnViewEnableRubberbandPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewEnableRubberbandPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColumnViewEnableRubberbandPropertyInfo = (~) Bool
    type AttrTransferType ColumnViewEnableRubberbandPropertyInfo = Bool
    type AttrGetType ColumnViewEnableRubberbandPropertyInfo = Bool
    type AttrLabel ColumnViewEnableRubberbandPropertyInfo = "enable-rubberband"
    type AttrOrigin ColumnViewEnableRubberbandPropertyInfo = ColumnView
    attrGet = getColumnViewEnableRubberband
    attrSet = setColumnViewEnableRubberband
    attrPut = setColumnViewEnableRubberband
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewEnableRubberband
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.enableRubberband"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:enableRubberband"
        })
#endif

-- VVV Prop "header-factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #headerFactory
-- @
getColumnViewHeaderFactory :: (MonadIO m, IsColumnView o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getColumnViewHeaderFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "header-factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@header-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #headerFactory 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewHeaderFactory :: (MonadIO m, IsColumnView o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setColumnViewHeaderFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "header-factory" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@header-factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewHeaderFactory :: (IsColumnView o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructColumnViewHeaderFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "header-factory" (P.Just val)

-- | Set the value of the “@header-factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #headerFactory
-- @
clearColumnViewHeaderFactory :: (MonadIO m, IsColumnView o) => o -> m ()
clearColumnViewHeaderFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "header-factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data ColumnViewHeaderFactoryPropertyInfo
instance AttrInfo ColumnViewHeaderFactoryPropertyInfo where
    type AttrAllowedOps ColumnViewHeaderFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewHeaderFactoryPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint ColumnViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType ColumnViewHeaderFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType ColumnViewHeaderFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel ColumnViewHeaderFactoryPropertyInfo = "header-factory"
    type AttrOrigin ColumnViewHeaderFactoryPropertyInfo = ColumnView
    attrGet = getColumnViewHeaderFactory
    attrSet = setColumnViewHeaderFactory
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructColumnViewHeaderFactory
    attrClear = clearColumnViewHeaderFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.headerFactory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:headerFactory"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #model
-- @
getColumnViewModel :: (MonadIO m, IsColumnView o) => o -> m (Maybe Gtk.SelectionModel.SelectionModel)
getColumnViewModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gtk.SelectionModel.SelectionModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewModel :: (MonadIO m, IsColumnView o, Gtk.SelectionModel.IsSelectionModel a) => o -> a -> m ()
setColumnViewModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewModel :: (IsColumnView o, MIO.MonadIO m, Gtk.SelectionModel.IsSelectionModel a) => a -> m (GValueConstruct o)
constructColumnViewModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearColumnViewModel :: (MonadIO m, IsColumnView o) => o -> m ()
clearColumnViewModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gtk.SelectionModel.SelectionModel)

#if defined(ENABLE_OVERLOADING)
data ColumnViewModelPropertyInfo
instance AttrInfo ColumnViewModelPropertyInfo where
    type AttrAllowedOps ColumnViewModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewModelPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferTypeConstraint ColumnViewModelPropertyInfo = Gtk.SelectionModel.IsSelectionModel
    type AttrTransferType ColumnViewModelPropertyInfo = Gtk.SelectionModel.SelectionModel
    type AttrGetType ColumnViewModelPropertyInfo = (Maybe Gtk.SelectionModel.SelectionModel)
    type AttrLabel ColumnViewModelPropertyInfo = "model"
    type AttrOrigin ColumnViewModelPropertyInfo = ColumnView
    attrGet = getColumnViewModel
    attrSet = setColumnViewModel
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.SelectionModel.SelectionModel v
    attrConstruct = constructColumnViewModel
    attrClear = clearColumnViewModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:model"
        })
#endif

-- VVV Prop "reorderable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #reorderable
-- @
getColumnViewReorderable :: (MonadIO m, IsColumnView o) => o -> m Bool
getColumnViewReorderable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "reorderable"

-- | Set the value of the “@reorderable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #reorderable 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewReorderable :: (MonadIO m, IsColumnView o) => o -> Bool -> m ()
setColumnViewReorderable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "reorderable" val

-- | Construct a t'GValueConstruct' with valid value for the “@reorderable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewReorderable :: (IsColumnView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColumnViewReorderable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "reorderable" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewReorderablePropertyInfo
instance AttrInfo ColumnViewReorderablePropertyInfo where
    type AttrAllowedOps ColumnViewReorderablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewReorderablePropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewReorderablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColumnViewReorderablePropertyInfo = (~) Bool
    type AttrTransferType ColumnViewReorderablePropertyInfo = Bool
    type AttrGetType ColumnViewReorderablePropertyInfo = Bool
    type AttrLabel ColumnViewReorderablePropertyInfo = "reorderable"
    type AttrOrigin ColumnViewReorderablePropertyInfo = ColumnView
    attrGet = getColumnViewReorderable
    attrSet = setColumnViewReorderable
    attrPut = setColumnViewReorderable
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewReorderable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.reorderable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:reorderable"
        })
#endif

-- VVV Prop "row-factory"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@row-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #rowFactory
-- @
getColumnViewRowFactory :: (MonadIO m, IsColumnView o) => o -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
getColumnViewRowFactory obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "row-factory" Gtk.ListItemFactory.ListItemFactory

-- | Set the value of the “@row-factory@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #rowFactory 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewRowFactory :: (MonadIO m, IsColumnView o, Gtk.ListItemFactory.IsListItemFactory a) => o -> a -> m ()
setColumnViewRowFactory obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "row-factory" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@row-factory@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewRowFactory :: (IsColumnView o, MIO.MonadIO m, Gtk.ListItemFactory.IsListItemFactory a) => a -> m (GValueConstruct o)
constructColumnViewRowFactory val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "row-factory" (P.Just val)

-- | Set the value of the “@row-factory@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #rowFactory
-- @
clearColumnViewRowFactory :: (MonadIO m, IsColumnView o) => o -> m ()
clearColumnViewRowFactory obj = liftIO $ B.Properties.setObjectPropertyObject obj "row-factory" (Nothing :: Maybe Gtk.ListItemFactory.ListItemFactory)

#if defined(ENABLE_OVERLOADING)
data ColumnViewRowFactoryPropertyInfo
instance AttrInfo ColumnViewRowFactoryPropertyInfo where
    type AttrAllowedOps ColumnViewRowFactoryPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewRowFactoryPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewRowFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferTypeConstraint ColumnViewRowFactoryPropertyInfo = Gtk.ListItemFactory.IsListItemFactory
    type AttrTransferType ColumnViewRowFactoryPropertyInfo = Gtk.ListItemFactory.ListItemFactory
    type AttrGetType ColumnViewRowFactoryPropertyInfo = (Maybe Gtk.ListItemFactory.ListItemFactory)
    type AttrLabel ColumnViewRowFactoryPropertyInfo = "row-factory"
    type AttrOrigin ColumnViewRowFactoryPropertyInfo = ColumnView
    attrGet = getColumnViewRowFactory
    attrSet = setColumnViewRowFactory
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.ListItemFactory.ListItemFactory v
    attrConstruct = constructColumnViewRowFactory
    attrClear = clearColumnViewRowFactory
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.rowFactory"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:rowFactory"
        })
#endif

-- VVV Prop "show-column-separators"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-column-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #showColumnSeparators
-- @
getColumnViewShowColumnSeparators :: (MonadIO m, IsColumnView o) => o -> m Bool
getColumnViewShowColumnSeparators obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-column-separators"

-- | Set the value of the “@show-column-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #showColumnSeparators 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewShowColumnSeparators :: (MonadIO m, IsColumnView o) => o -> Bool -> m ()
setColumnViewShowColumnSeparators obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-column-separators" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-column-separators@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewShowColumnSeparators :: (IsColumnView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColumnViewShowColumnSeparators val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-column-separators" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewShowColumnSeparatorsPropertyInfo
instance AttrInfo ColumnViewShowColumnSeparatorsPropertyInfo where
    type AttrAllowedOps ColumnViewShowColumnSeparatorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewShowColumnSeparatorsPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewShowColumnSeparatorsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColumnViewShowColumnSeparatorsPropertyInfo = (~) Bool
    type AttrTransferType ColumnViewShowColumnSeparatorsPropertyInfo = Bool
    type AttrGetType ColumnViewShowColumnSeparatorsPropertyInfo = Bool
    type AttrLabel ColumnViewShowColumnSeparatorsPropertyInfo = "show-column-separators"
    type AttrOrigin ColumnViewShowColumnSeparatorsPropertyInfo = ColumnView
    attrGet = getColumnViewShowColumnSeparators
    attrSet = setColumnViewShowColumnSeparators
    attrPut = setColumnViewShowColumnSeparators
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewShowColumnSeparators
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.showColumnSeparators"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:showColumnSeparators"
        })
#endif

-- VVV Prop "show-row-separators"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-row-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #showRowSeparators
-- @
getColumnViewShowRowSeparators :: (MonadIO m, IsColumnView o) => o -> m Bool
getColumnViewShowRowSeparators obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-row-separators"

-- | Set the value of the “@show-row-separators@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #showRowSeparators 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewShowRowSeparators :: (MonadIO m, IsColumnView o) => o -> Bool -> m ()
setColumnViewShowRowSeparators obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-row-separators" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-row-separators@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewShowRowSeparators :: (IsColumnView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColumnViewShowRowSeparators val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-row-separators" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewShowRowSeparatorsPropertyInfo
instance AttrInfo ColumnViewShowRowSeparatorsPropertyInfo where
    type AttrAllowedOps ColumnViewShowRowSeparatorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewShowRowSeparatorsPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewShowRowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColumnViewShowRowSeparatorsPropertyInfo = (~) Bool
    type AttrTransferType ColumnViewShowRowSeparatorsPropertyInfo = Bool
    type AttrGetType ColumnViewShowRowSeparatorsPropertyInfo = Bool
    type AttrLabel ColumnViewShowRowSeparatorsPropertyInfo = "show-row-separators"
    type AttrOrigin ColumnViewShowRowSeparatorsPropertyInfo = ColumnView
    attrGet = getColumnViewShowRowSeparators
    attrSet = setColumnViewShowRowSeparators
    attrPut = setColumnViewShowRowSeparators
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewShowRowSeparators
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.showRowSeparators"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:showRowSeparators"
        })
#endif

-- VVV Prop "single-click-activate"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #singleClickActivate
-- @
getColumnViewSingleClickActivate :: (MonadIO m, IsColumnView o) => o -> m Bool
getColumnViewSingleClickActivate obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "single-click-activate"

-- | Set the value of the “@single-click-activate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #singleClickActivate 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewSingleClickActivate :: (MonadIO m, IsColumnView o) => o -> Bool -> m ()
setColumnViewSingleClickActivate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "single-click-activate" val

-- | Construct a t'GValueConstruct' with valid value for the “@single-click-activate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewSingleClickActivate :: (IsColumnView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructColumnViewSingleClickActivate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "single-click-activate" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewSingleClickActivatePropertyInfo
instance AttrInfo ColumnViewSingleClickActivatePropertyInfo where
    type AttrAllowedOps ColumnViewSingleClickActivatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewSingleClickActivatePropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ColumnViewSingleClickActivatePropertyInfo = (~) Bool
    type AttrTransferType ColumnViewSingleClickActivatePropertyInfo = Bool
    type AttrGetType ColumnViewSingleClickActivatePropertyInfo = Bool
    type AttrLabel ColumnViewSingleClickActivatePropertyInfo = "single-click-activate"
    type AttrOrigin ColumnViewSingleClickActivatePropertyInfo = ColumnView
    attrGet = getColumnViewSingleClickActivate
    attrSet = setColumnViewSingleClickActivate
    attrPut = setColumnViewSingleClickActivate
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewSingleClickActivate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.singleClickActivate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:singleClickActivate"
        })
#endif

-- VVV Prop "sorter"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Sorter"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@sorter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #sorter
-- @
getColumnViewSorter :: (MonadIO m, IsColumnView o) => o -> m (Maybe Gtk.Sorter.Sorter)
getColumnViewSorter obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "sorter" Gtk.Sorter.Sorter

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterPropertyInfo
instance AttrInfo ColumnViewSorterPropertyInfo where
    type AttrAllowedOps ColumnViewSorterPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewSorterPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewSorterPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ColumnViewSorterPropertyInfo = (~) ()
    type AttrTransferType ColumnViewSorterPropertyInfo = ()
    type AttrGetType ColumnViewSorterPropertyInfo = (Maybe Gtk.Sorter.Sorter)
    type AttrLabel ColumnViewSorterPropertyInfo = "sorter"
    type AttrOrigin ColumnViewSorterPropertyInfo = ColumnView
    attrGet = getColumnViewSorter
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.sorter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:sorter"
        })
#endif

-- VVV Prop "tab-behavior"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnView #tabBehavior
-- @
getColumnViewTabBehavior :: (MonadIO m, IsColumnView o) => o -> m Gtk.Enums.ListTabBehavior
getColumnViewTabBehavior obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "tab-behavior"

-- | Set the value of the “@tab-behavior@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' columnView [ #tabBehavior 'Data.GI.Base.Attributes.:=' value ]
-- @
setColumnViewTabBehavior :: (MonadIO m, IsColumnView o) => o -> Gtk.Enums.ListTabBehavior -> m ()
setColumnViewTabBehavior obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "tab-behavior" val

-- | Construct a t'GValueConstruct' with valid value for the “@tab-behavior@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructColumnViewTabBehavior :: (IsColumnView o, MIO.MonadIO m) => Gtk.Enums.ListTabBehavior -> m (GValueConstruct o)
constructColumnViewTabBehavior val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "tab-behavior" val

#if defined(ENABLE_OVERLOADING)
data ColumnViewTabBehaviorPropertyInfo
instance AttrInfo ColumnViewTabBehaviorPropertyInfo where
    type AttrAllowedOps ColumnViewTabBehaviorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ColumnViewTabBehaviorPropertyInfo = IsColumnView
    type AttrSetTypeConstraint ColumnViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferTypeConstraint ColumnViewTabBehaviorPropertyInfo = (~) Gtk.Enums.ListTabBehavior
    type AttrTransferType ColumnViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrGetType ColumnViewTabBehaviorPropertyInfo = Gtk.Enums.ListTabBehavior
    type AttrLabel ColumnViewTabBehaviorPropertyInfo = "tab-behavior"
    type AttrOrigin ColumnViewTabBehaviorPropertyInfo = ColumnView
    attrGet = getColumnViewTabBehavior
    attrSet = setColumnViewTabBehavior
    attrPut = setColumnViewTabBehavior
    attrTransfer _ v = do
        return v
    attrConstruct = constructColumnViewTabBehavior
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.tabBehavior"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#g:attr:tabBehavior"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColumnView
type instance O.AttributeList ColumnView = ColumnViewAttributeList
type ColumnViewAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("columns", ColumnViewColumnsPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("enableRubberband", ColumnViewEnableRubberbandPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", Gtk.Scrollable.ScrollableHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("headerFactory", ColumnViewHeaderFactoryPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollPolicy", Gtk.Scrollable.ScrollableHscrollPolicyPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("model", ColumnViewModelPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("reorderable", ColumnViewReorderablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("rowFactory", ColumnViewRowFactoryPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showColumnSeparators", ColumnViewShowColumnSeparatorsPropertyInfo), '("showRowSeparators", ColumnViewShowRowSeparatorsPropertyInfo), '("singleClickActivate", ColumnViewSingleClickActivatePropertyInfo), '("sorter", ColumnViewSorterPropertyInfo), '("tabBehavior", ColumnViewTabBehaviorPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("vadjustment", Gtk.Scrollable.ScrollableVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollPolicy", Gtk.Scrollable.ScrollableVscrollPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
columnViewColumns :: AttrLabelProxy "columns"
columnViewColumns = AttrLabelProxy

columnViewEnableRubberband :: AttrLabelProxy "enableRubberband"
columnViewEnableRubberband = AttrLabelProxy

columnViewHeaderFactory :: AttrLabelProxy "headerFactory"
columnViewHeaderFactory = AttrLabelProxy

columnViewModel :: AttrLabelProxy "model"
columnViewModel = AttrLabelProxy

columnViewReorderable :: AttrLabelProxy "reorderable"
columnViewReorderable = AttrLabelProxy

columnViewRowFactory :: AttrLabelProxy "rowFactory"
columnViewRowFactory = AttrLabelProxy

columnViewShowColumnSeparators :: AttrLabelProxy "showColumnSeparators"
columnViewShowColumnSeparators = AttrLabelProxy

columnViewShowRowSeparators :: AttrLabelProxy "showRowSeparators"
columnViewShowRowSeparators = AttrLabelProxy

columnViewSingleClickActivate :: AttrLabelProxy "singleClickActivate"
columnViewSingleClickActivate = AttrLabelProxy

columnViewSorter :: AttrLabelProxy "sorter"
columnViewSorter = AttrLabelProxy

columnViewTabBehavior :: AttrLabelProxy "tabBehavior"
columnViewTabBehavior = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ColumnView = ColumnViewSignalList
type ColumnViewSignalList = ('[ '("activate", ColumnViewActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ColumnView::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the list model to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ColumnView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_new" gtk_column_view_new :: 
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO (Ptr ColumnView)

-- | Creates a new @GtkColumnView@.
-- 
-- You most likely want to call 'GI.Gtk.Objects.ColumnView.columnViewAppendColumn'
-- to add columns next.
columnViewNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.SelectionModel.IsSelectionModel a) =>
    Maybe (a)
    -- ^ /@model@/: the list model to use
    -> m ColumnView
    -- ^ __Returns:__ a new @GtkColumnView@
columnViewNew model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    result <- gtk_column_view_new maybeModel
    checkUnexpectedReturnNULL "columnViewNew" result
    result' <- (newObject ColumnView) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColumnView::append_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a column that hasn't been added to a `GtkColumnView` yet"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_append_column" gtk_column_view_append_column :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.ColumnViewColumn.ColumnViewColumn -> -- column : TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
    IO ()

-- | Appends the /@column@/ to the end of the columns in /@self@/.
columnViewAppendColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) =>
    a
    -- ^ /@self@/: a columnview
    -> b
    -- ^ /@column@/: a column that hasn\'t been added to a @GtkColumnView@ yet
    -> m ()
columnViewAppendColumn self column = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    column' <- unsafeManagedPtrCastPtr column
    gtk_column_view_append_column self' column'
    touchManagedPtr self
    touchManagedPtr column
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewAppendColumnMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) => O.OverloadedMethod ColumnViewAppendColumnMethodInfo a signature where
    overloadedMethod = columnViewAppendColumn

instance O.OverloadedMethodInfo ColumnViewAppendColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewAppendColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewAppendColumn"
        })


#endif

-- method ColumnView::get_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_columns" gtk_column_view_get_columns :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the list of columns in this column view.
-- 
-- This list is constant over the lifetime of /@self@/ and can be used to
-- monitor changes to the columns of /@self@/ by connecting to the
-- [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") signal.
columnViewGetColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ The list managing the columns
columnViewGetColumns self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_columns self'
    checkUnexpectedReturnNULL "columnViewGetColumns" result
    result' <- (newObject Gio.ListModel.ListModel) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetColumnsMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetColumnsMethodInfo a signature where
    overloadedMethod = columnViewGetColumns

instance O.OverloadedMethodInfo ColumnViewGetColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetColumns"
        })


#endif

-- method ColumnView::get_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_enable_rubberband" gtk_column_view_get_enable_rubberband :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CInt

-- | Returns whether rows can be selected by dragging with the mouse.
columnViewGetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Bool
    -- ^ __Returns:__ true if rubberband selection is enabled
columnViewGetEnableRubberband self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_enable_rubberband self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetEnableRubberbandMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetEnableRubberbandMethodInfo a signature where
    overloadedMethod = columnViewGetEnableRubberband

instance O.OverloadedMethodInfo ColumnViewGetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetEnableRubberband"
        })


#endif

-- method ColumnView::get_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_header_factory" gtk_column_view_get_header_factory :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory that\'s currently used to populate section headers.
-- 
-- /Since: 4.12/
columnViewGetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory in use
columnViewGetHeaderFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_header_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetHeaderFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetHeaderFactoryMethodInfo a signature where
    overloadedMethod = columnViewGetHeaderFactory

instance O.OverloadedMethodInfo ColumnViewGetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetHeaderFactory"
        })


#endif

-- method ColumnView::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_model" gtk_column_view_get_model :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO (Ptr Gtk.SelectionModel.SelectionModel)

-- | Gets the model that\'s currently used to read the items displayed.
columnViewGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m (Maybe Gtk.SelectionModel.SelectionModel)
    -- ^ __Returns:__ The model in use
columnViewGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.SelectionModel.SelectionModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetModelMethodInfo
instance (signature ~ (m (Maybe Gtk.SelectionModel.SelectionModel)), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetModelMethodInfo a signature where
    overloadedMethod = columnViewGetModel

instance O.OverloadedMethodInfo ColumnViewGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetModel"
        })


#endif

-- method ColumnView::get_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_reorderable" gtk_column_view_get_reorderable :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CInt

-- | Returns whether columns are reorderable.
columnViewGetReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Bool
    -- ^ __Returns:__ true if columns are reorderable
columnViewGetReorderable self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_reorderable self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetReorderableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetReorderableMethodInfo a signature where
    overloadedMethod = columnViewGetReorderable

instance O.OverloadedMethodInfo ColumnViewGetReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetReorderable"
        })


#endif

-- method ColumnView::get_row_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_row_factory" gtk_column_view_get_row_factory :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO (Ptr Gtk.ListItemFactory.ListItemFactory)

-- | Gets the factory set via 'GI.Gtk.Objects.ColumnView.columnViewSetRowFactory'.
-- 
-- /Since: 4.12/
columnViewGetRowFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m (Maybe Gtk.ListItemFactory.ListItemFactory)
    -- ^ __Returns:__ The factory
columnViewGetRowFactory self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_row_factory self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ListItemFactory.ListItemFactory) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetRowFactoryMethodInfo
instance (signature ~ (m (Maybe Gtk.ListItemFactory.ListItemFactory)), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetRowFactoryMethodInfo a signature where
    overloadedMethod = columnViewGetRowFactory

instance O.OverloadedMethodInfo ColumnViewGetRowFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetRowFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetRowFactory"
        })


#endif

-- method ColumnView::get_show_column_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_show_column_separators" gtk_column_view_get_show_column_separators :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CInt

-- | Returns whether the list should show separators between columns.
columnViewGetShowColumnSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Bool
    -- ^ __Returns:__ true if the list shows column separators
columnViewGetShowColumnSeparators self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_show_column_separators self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetShowColumnSeparatorsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetShowColumnSeparatorsMethodInfo a signature where
    overloadedMethod = columnViewGetShowColumnSeparators

instance O.OverloadedMethodInfo ColumnViewGetShowColumnSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetShowColumnSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetShowColumnSeparators"
        })


#endif

-- method ColumnView::get_show_row_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_show_row_separators" gtk_column_view_get_show_row_separators :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CInt

-- | Returns whether the list should show separators between rows.
columnViewGetShowRowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Bool
    -- ^ __Returns:__ true if the list shows separators
columnViewGetShowRowSeparators self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_show_row_separators self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetShowRowSeparatorsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetShowRowSeparatorsMethodInfo a signature where
    overloadedMethod = columnViewGetShowRowSeparators

instance O.OverloadedMethodInfo ColumnViewGetShowRowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetShowRowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetShowRowSeparators"
        })


#endif

-- method ColumnView::get_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_single_click_activate" gtk_column_view_get_single_click_activate :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CInt

-- | Returns whether rows will be activated on single click and
-- selected on hover.
columnViewGetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Bool
    -- ^ __Returns:__ true if rows are activated on single click
columnViewGetSingleClickActivate self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_single_click_activate self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetSingleClickActivateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetSingleClickActivateMethodInfo a signature where
    overloadedMethod = columnViewGetSingleClickActivate

instance O.OverloadedMethodInfo ColumnViewGetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetSingleClickActivate"
        })


#endif

-- method ColumnView::get_sorter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Sorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_sorter" gtk_column_view_get_sorter :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO (Ptr Gtk.Sorter.Sorter)

-- | Returns a special sorter that reflects the users sorting
-- choices in the column view.
-- 
-- To allow users to customizable sorting by clicking on column
-- headers, this sorter needs to be set on the sort model underneath
-- the model that is displayed by the view.
-- 
-- See 'GI.Gtk.Objects.ColumnViewColumn.columnViewColumnSetSorter' for setting up
-- per-column sorting.
-- 
-- Here is an example:
-- 
-- === /c code/
-- >gtk_column_view_column_set_sorter (column, sorter);
-- >gtk_column_view_append_column (view, column);
-- >sorter = g_object_ref (gtk_column_view_get_sorter (view)));
-- >model = gtk_sort_list_model_new (store, sorter);
-- >selection = gtk_no_selection_new (model);
-- >gtk_column_view_set_model (view, selection);
columnViewGetSorter ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m (Maybe Gtk.Sorter.Sorter)
    -- ^ __Returns:__ the @GtkSorter@ of /@self@/
columnViewGetSorter self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_sorter self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Sorter.Sorter) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetSorterMethodInfo
instance (signature ~ (m (Maybe Gtk.Sorter.Sorter)), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetSorterMethodInfo a signature where
    overloadedMethod = columnViewGetSorter

instance O.OverloadedMethodInfo ColumnViewGetSorterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetSorter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetSorter"
        })


#endif

-- method ColumnView::get_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_get_tab_behavior" gtk_column_view_get_tab_behavior :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    IO CUInt

-- | Gets the behavior set for the \<kbd>Tab\<\/kbd> key.
-- 
-- /Since: 4.12/
columnViewGetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> m Gtk.Enums.ListTabBehavior
    -- ^ __Returns:__ The behavior of the \<kbd>Tab\<\/kbd> key
columnViewGetTabBehavior self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_get_tab_behavior self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewGetTabBehaviorMethodInfo
instance (signature ~ (m Gtk.Enums.ListTabBehavior), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewGetTabBehaviorMethodInfo a signature where
    overloadedMethod = columnViewGetTabBehavior

instance O.OverloadedMethodInfo ColumnViewGetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewGetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewGetTabBehavior"
        })


#endif

-- method ColumnView::insert_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position to insert @column at"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column to insert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_insert_column" gtk_column_view_insert_column :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Word32 ->                               -- position : TBasicType TUInt
    Ptr Gtk.ColumnViewColumn.ColumnViewColumn -> -- column : TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
    IO ()

-- | Inserts a column at the given position in the columns of /@self@/.
-- 
-- If /@column@/ is already a column of /@self@/, it will be repositioned.
columnViewInsertColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) =>
    a
    -- ^ /@self@/: a columnview
    -> Word32
    -- ^ /@position@/: the position to insert /@column@/ at
    -> b
    -- ^ /@column@/: the column to insert
    -> m ()
columnViewInsertColumn self position column = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    column' <- unsafeManagedPtrCastPtr column
    gtk_column_view_insert_column self' position column'
    touchManagedPtr self
    touchManagedPtr column
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewInsertColumnMethodInfo
instance (signature ~ (Word32 -> b -> m ()), MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) => O.OverloadedMethod ColumnViewInsertColumnMethodInfo a signature where
    overloadedMethod = columnViewInsertColumn

instance O.OverloadedMethodInfo ColumnViewInsertColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewInsertColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewInsertColumn"
        })


#endif

-- method ColumnView::remove_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a column that's part of @self"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_remove_column" gtk_column_view_remove_column :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.ColumnViewColumn.ColumnViewColumn -> -- column : TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
    IO ()

-- | Removes the /@column@/ from the list of columns of /@self@/.
columnViewRemoveColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) =>
    a
    -- ^ /@self@/: a columnview
    -> b
    -- ^ /@column@/: a column that\'s part of /@self@/
    -> m ()
columnViewRemoveColumn self column = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    column' <- unsafeManagedPtrCastPtr column
    gtk_column_view_remove_column self' column'
    touchManagedPtr self
    touchManagedPtr column
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewRemoveColumnMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) => O.OverloadedMethod ColumnViewRemoveColumnMethodInfo a signature where
    overloadedMethod = columnViewRemoveColumn

instance O.OverloadedMethodInfo ColumnViewRemoveColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewRemoveColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewRemoveColumn"
        })


#endif

-- method ColumnView::scroll_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "position of the item. Must be less than the number of\n  items in the view."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The column to scroll to\n  or `NULL` to not scroll columns"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListScrollFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "actions to perform" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scroll"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrollInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "details of how to perform\n  the scroll operation or %NULL to scroll into view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_scroll_to" gtk_column_view_scroll_to :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Word32 ->                               -- pos : TBasicType TUInt
    Ptr Gtk.ColumnViewColumn.ColumnViewColumn -> -- column : TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "ListScrollFlags"})
    Ptr Gtk.ScrollInfo.ScrollInfo ->        -- scroll : TInterface (Name {namespace = "Gtk", name = "ScrollInfo"})
    IO ()

-- | Scroll to the row at the given position - or cell if a column is
-- given - and performs the actions specified in /@flags@/.
-- 
-- This function works no matter if the columnview is shown or focused.
-- If it isn\'t, then the changes will take effect once that happens.
-- 
-- /Since: 4.12/
columnViewScrollTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) =>
    a
    -- ^ /@self@/: The columnview
    -> Word32
    -- ^ /@pos@/: position of the item. Must be less than the number of
    --   items in the view.
    -> Maybe (b)
    -- ^ /@column@/: The column to scroll to
    --   or @NULL@ to not scroll columns
    -> [Gtk.Flags.ListScrollFlags]
    -- ^ /@flags@/: actions to perform
    -> Maybe (Gtk.ScrollInfo.ScrollInfo)
    -- ^ /@scroll@/: details of how to perform
    --   the scroll operation or 'P.Nothing' to scroll into view
    -> m ()
columnViewScrollTo self pos column flags scroll = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeColumn <- case column of
        Nothing -> return FP.nullPtr
        Just jColumn -> do
            jColumn' <- unsafeManagedPtrCastPtr jColumn
            return jColumn'
    let flags' = gflagsToWord flags
    maybeScroll <- case scroll of
        Nothing -> return FP.nullPtr
        Just jScroll -> do
            jScroll' <- B.ManagedPtr.disownBoxed jScroll
            return jScroll'
    gtk_column_view_scroll_to self' pos maybeColumn flags' maybeScroll
    touchManagedPtr self
    whenJust column touchManagedPtr
    whenJust scroll touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewScrollToMethodInfo
instance (signature ~ (Word32 -> Maybe (b) -> [Gtk.Flags.ListScrollFlags] -> Maybe (Gtk.ScrollInfo.ScrollInfo) -> m ()), MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) => O.OverloadedMethod ColumnViewScrollToMethodInfo a signature where
    overloadedMethod = columnViewScrollTo

instance O.OverloadedMethodInfo ColumnViewScrollToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewScrollTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewScrollTo"
        })


#endif

-- method ColumnView::set_enable_rubberband
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable_rubberband"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable rubberband selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_enable_rubberband" gtk_column_view_set_enable_rubberband :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CInt ->                                 -- enable_rubberband : TBasicType TBoolean
    IO ()

-- | Sets whether selections can be changed by dragging with the mouse.
columnViewSetEnableRubberband ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Bool
    -- ^ /@enableRubberband@/: whether to enable rubberband selection
    -> m ()
columnViewSetEnableRubberband self enableRubberband = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enableRubberband' = (P.fromIntegral . P.fromEnum) enableRubberband
    gtk_column_view_set_enable_rubberband self' enableRubberband'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetEnableRubberbandMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetEnableRubberbandMethodInfo a signature where
    overloadedMethod = columnViewSetEnableRubberband

instance O.OverloadedMethodInfo ColumnViewSetEnableRubberbandMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetEnableRubberband",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetEnableRubberband"
        })


#endif

-- method ColumnView::set_header_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the factory to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_header_factory" gtk_column_view_set_header_factory :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the factory to use for populating the
-- t'GI.Gtk.Objects.ListHeader.ListHeader' objects used in section headers.
-- 
-- If this factory is set to @NULL@, the list will not show
-- section headers.
-- 
-- /Since: 4.12/
columnViewSetHeaderFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a columnview
    -> Maybe (b)
    -- ^ /@factory@/: the factory to use
    -> m ()
columnViewSetHeaderFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_column_view_set_header_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetHeaderFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsColumnView a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod ColumnViewSetHeaderFactoryMethodInfo a signature where
    overloadedMethod = columnViewSetHeaderFactory

instance O.OverloadedMethodInfo ColumnViewSetHeaderFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetHeaderFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetHeaderFactory"
        })


#endif

-- method ColumnView::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SelectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_model" gtk_column_view_set_model :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.SelectionModel.SelectionModel -> -- model : TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
    IO ()

-- | Sets the model to use.
-- 
-- This must be a t'GI.Gtk.Interfaces.SelectionModel.SelectionModel'.
columnViewSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.SelectionModel.IsSelectionModel b) =>
    a
    -- ^ /@self@/: a columnview
    -> Maybe (b)
    -- ^ /@model@/: the model to use
    -> m ()
columnViewSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_column_view_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsColumnView a, Gtk.SelectionModel.IsSelectionModel b) => O.OverloadedMethod ColumnViewSetModelMethodInfo a signature where
    overloadedMethod = columnViewSetModel

instance O.OverloadedMethodInfo ColumnViewSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetModel"
        })


#endif

-- method ColumnView::set_reorderable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "reorderable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether columns should be reorderable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_reorderable" gtk_column_view_set_reorderable :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CInt ->                                 -- reorderable : TBasicType TBoolean
    IO ()

-- | Sets whether columns should be reorderable by dragging.
columnViewSetReorderable ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Bool
    -- ^ /@reorderable@/: whether columns should be reorderable
    -> m ()
columnViewSetReorderable self reorderable = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let reorderable' = (P.fromIntegral . P.fromEnum) reorderable
    gtk_column_view_set_reorderable self' reorderable'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetReorderableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetReorderableMethodInfo a signature where
    overloadedMethod = columnViewSetReorderable

instance O.OverloadedMethodInfo ColumnViewSetReorderableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetReorderable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetReorderable"
        })


#endif

-- method ColumnView::set_row_factory
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factory"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListItemFactory" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The row factory" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_row_factory" gtk_column_view_set_row_factory :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.ListItemFactory.ListItemFactory -> -- factory : TInterface (Name {namespace = "Gtk", name = "ListItemFactory"})
    IO ()

-- | Sets the factory used for configuring rows.
-- 
-- The factory must be for configuring t'GI.Gtk.Objects.ColumnViewRow.ColumnViewRow' objects.
-- 
-- If this factory is not set - which is the default - then the defaults
-- will be used.
-- 
-- This factory is not used to set the widgets displayed in the individual
-- cells. For that see [method/@gtkColumnViewColumn@/.set_factory] and
-- [class/@gtkColumnViewCell@/].
-- 
-- /Since: 4.12/
columnViewSetRowFactory ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ListItemFactory.IsListItemFactory b) =>
    a
    -- ^ /@self@/: a columnview
    -> Maybe (b)
    -- ^ /@factory@/: The row factory
    -> m ()
columnViewSetRowFactory self factory = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFactory <- case factory of
        Nothing -> return FP.nullPtr
        Just jFactory -> do
            jFactory' <- unsafeManagedPtrCastPtr jFactory
            return jFactory'
    gtk_column_view_set_row_factory self' maybeFactory
    touchManagedPtr self
    whenJust factory touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetRowFactoryMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsColumnView a, Gtk.ListItemFactory.IsListItemFactory b) => O.OverloadedMethod ColumnViewSetRowFactoryMethodInfo a signature where
    overloadedMethod = columnViewSetRowFactory

instance O.OverloadedMethodInfo ColumnViewSetRowFactoryMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetRowFactory",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetRowFactory"
        })


#endif

-- method ColumnView::set_show_column_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_column_separators"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show column separators"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_show_column_separators" gtk_column_view_set_show_column_separators :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CInt ->                                 -- show_column_separators : TBasicType TBoolean
    IO ()

-- | Sets whether the list should show separators between columns.
columnViewSetShowColumnSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Bool
    -- ^ /@showColumnSeparators@/: whether to show column separators
    -> m ()
columnViewSetShowColumnSeparators self showColumnSeparators = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let showColumnSeparators' = (P.fromIntegral . P.fromEnum) showColumnSeparators
    gtk_column_view_set_show_column_separators self' showColumnSeparators'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetShowColumnSeparatorsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetShowColumnSeparatorsMethodInfo a signature where
    overloadedMethod = columnViewSetShowColumnSeparators

instance O.OverloadedMethodInfo ColumnViewSetShowColumnSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetShowColumnSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetShowColumnSeparators"
        })


#endif

-- method ColumnView::set_show_row_separators
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_row_separators"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show row separators"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_show_row_separators" gtk_column_view_set_show_row_separators :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CInt ->                                 -- show_row_separators : TBasicType TBoolean
    IO ()

-- | Sets whether the list should show separators between rows.
columnViewSetShowRowSeparators ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Bool
    -- ^ /@showRowSeparators@/: whether to show row separators
    -> m ()
columnViewSetShowRowSeparators self showRowSeparators = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let showRowSeparators' = (P.fromIntegral . P.fromEnum) showRowSeparators
    gtk_column_view_set_show_row_separators self' showRowSeparators'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetShowRowSeparatorsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetShowRowSeparatorsMethodInfo a signature where
    overloadedMethod = columnViewSetShowRowSeparators

instance O.OverloadedMethodInfo ColumnViewSetShowRowSeparatorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetShowRowSeparators",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetShowRowSeparators"
        })


#endif

-- method ColumnView::set_single_click_activate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "single_click_activate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to activate items on single click"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_single_click_activate" gtk_column_view_set_single_click_activate :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CInt ->                                 -- single_click_activate : TBasicType TBoolean
    IO ()

-- | Sets whether rows should be activated on single click and
-- selected on hover.
columnViewSetSingleClickActivate ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Bool
    -- ^ /@singleClickActivate@/: whether to activate items on single click
    -> m ()
columnViewSetSingleClickActivate self singleClickActivate = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let singleClickActivate' = (P.fromIntegral . P.fromEnum) singleClickActivate
    gtk_column_view_set_single_click_activate self' singleClickActivate'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetSingleClickActivateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetSingleClickActivateMethodInfo a signature where
    overloadedMethod = columnViewSetSingleClickActivate

instance O.OverloadedMethodInfo ColumnViewSetSingleClickActivateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetSingleClickActivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetSingleClickActivate"
        })


#endif

-- method ColumnView::set_tab_behavior
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_behavior"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ListTabBehavior" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The desired tab behavior"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_set_tab_behavior" gtk_column_view_set_tab_behavior :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    CUInt ->                                -- tab_behavior : TInterface (Name {namespace = "Gtk", name = "ListTabBehavior"})
    IO ()

-- | Sets the \<kbd>Tab\<\/kbd> key behavior.
-- 
-- This influences how the \<kbd>Tab\<\/kbd> and
-- \<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd> keys move the
-- focus in the columnview.
-- 
-- /Since: 4.12/
columnViewSetTabBehavior ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a) =>
    a
    -- ^ /@self@/: a columnview
    -> Gtk.Enums.ListTabBehavior
    -- ^ /@tabBehavior@/: The desired tab behavior
    -> m ()
columnViewSetTabBehavior self tabBehavior = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let tabBehavior' = (fromIntegral . fromEnum) tabBehavior
    gtk_column_view_set_tab_behavior self' tabBehavior'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSetTabBehaviorMethodInfo
instance (signature ~ (Gtk.Enums.ListTabBehavior -> m ()), MonadIO m, IsColumnView a) => O.OverloadedMethod ColumnViewSetTabBehaviorMethodInfo a signature where
    overloadedMethod = columnViewSetTabBehavior

instance O.OverloadedMethodInfo ColumnViewSetTabBehaviorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSetTabBehavior",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSetTabBehavior"
        })


#endif

-- method ColumnView::sort_by_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnview" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "column"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column to sort by"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SortType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the direction to sort in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_sort_by_column" gtk_column_view_sort_by_column :: 
    Ptr ColumnView ->                       -- self : TInterface (Name {namespace = "Gtk", name = "ColumnView"})
    Ptr Gtk.ColumnViewColumn.ColumnViewColumn -> -- column : TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
    CUInt ->                                -- direction : TInterface (Name {namespace = "Gtk", name = "SortType"})
    IO ()

-- | Sets the sorting of the view.
-- 
-- This function should be used to set up the initial sorting.
-- At runtime, users can change the sorting of a column view
-- by clicking on the list headers.
-- 
-- This call only has an effect if the sorter returned by
-- 'GI.Gtk.Objects.ColumnView.columnViewGetSorter' is set on a sort model,
-- and 'GI.Gtk.Objects.ColumnViewColumn.columnViewColumnSetSorter' has been called
-- on /@column@/ to associate a sorter with the column.
-- 
-- If /@column@/ is unset, the view will be unsorted.
columnViewSortByColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) =>
    a
    -- ^ /@self@/: a columnview
    -> Maybe (b)
    -- ^ /@column@/: the column to sort by
    -> Gtk.Enums.SortType
    -- ^ /@direction@/: the direction to sort in
    -> m ()
columnViewSortByColumn self column direction = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeColumn <- case column of
        Nothing -> return FP.nullPtr
        Just jColumn -> do
            jColumn' <- unsafeManagedPtrCastPtr jColumn
            return jColumn'
    let direction' = (fromIntegral . fromEnum) direction
    gtk_column_view_sort_by_column self' maybeColumn direction'
    touchManagedPtr self
    whenJust column touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ColumnViewSortByColumnMethodInfo
instance (signature ~ (Maybe (b) -> Gtk.Enums.SortType -> m ()), MonadIO m, IsColumnView a, Gtk.ColumnViewColumn.IsColumnViewColumn b) => O.OverloadedMethod ColumnViewSortByColumnMethodInfo a signature where
    overloadedMethod = columnViewSortByColumn

instance O.OverloadedMethodInfo ColumnViewSortByColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnView.columnViewSortByColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnView.html#v:columnViewSortByColumn"
        })


#endif


