

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Enums
    ( 

 -- * Enumerations


-- ** AatLayoutFeatureSelectorT #enum:AatLayoutFeatureSelectorT#

    AatLayoutFeatureSelectorT(..)           ,


-- ** AatLayoutFeatureTypeT #enum:AatLayoutFeatureTypeT#

    AatLayoutFeatureTypeT(..)               ,


-- ** BufferClusterLevelT #enum:BufferClusterLevelT#

    BufferClusterLevelT(..)                 ,


-- ** BufferContentTypeT #enum:BufferContentTypeT#

    BufferContentTypeT(..)                  ,


-- ** BufferSerializeFormatT #enum:BufferSerializeFormatT#

    BufferSerializeFormatT(..)              ,


-- ** DirectionT #enum:DirectionT#

    DirectionT(..)                          ,


-- ** MemoryModeT #enum:MemoryModeT#

    MemoryModeT(..)                         ,


-- ** OtLayoutBaselineTagT #enum:OtLayoutBaselineTagT#

    OtLayoutBaselineTagT(..)                ,


-- ** OtLayoutGlyphClassT #enum:OtLayoutGlyphClassT#

    OtLayoutGlyphClassT(..)                 ,


-- ** OtMathConstantT #enum:OtMathConstantT#

    OtMathConstantT(..)                     ,


-- ** OtMathKernT #enum:OtMathKernT#

    OtMathKernT(..)                         ,


-- ** OtMetaTagT #enum:OtMetaTagT#

    OtMetaTagT(..)                          ,


-- ** OtMetricsTagT #enum:OtMetricsTagT#

    OtMetricsTagT(..)                       ,


-- ** OtNameIdPredefinedT #enum:OtNameIdPredefinedT#

    OtNameIdPredefinedT(..)                 ,


-- ** PaintCompositeModeT #enum:PaintCompositeModeT#

    PaintCompositeModeT(..)                 ,


-- ** PaintExtendT #enum:PaintExtendT#

    PaintExtendT(..)                        ,


-- ** ScriptT #enum:ScriptT#

    ScriptT(..)                             ,


-- ** StyleTagT #enum:StyleTagT#

    StyleTagT(..)                           ,


-- ** UnicodeCombiningClassT #enum:UnicodeCombiningClassT#

    UnicodeCombiningClassT(..)              ,


-- ** UnicodeGeneralCategoryT #enum:UnicodeGeneralCategoryT#

    UnicodeGeneralCategoryT(..)             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum unicode_general_category_t
-- | Data type for the \"General_Category\" (gc) property from
-- the Unicode Character Database.
data UnicodeGeneralCategoryT = 
      UnicodeGeneralCategoryTControl
    -- ^ [Cc]
    | UnicodeGeneralCategoryTFormat
    -- ^ [Cf]
    | UnicodeGeneralCategoryTUnassigned
    -- ^ [Cn]
    | UnicodeGeneralCategoryTPrivateUse
    -- ^ [Co]
    | UnicodeGeneralCategoryTSurrogate
    -- ^ [Cs]
    | UnicodeGeneralCategoryTLowercaseLetter
    -- ^ [Ll]
    | UnicodeGeneralCategoryTModifierLetter
    -- ^ [Lm]
    | UnicodeGeneralCategoryTOtherLetter
    -- ^ [Lo]
    | UnicodeGeneralCategoryTTitlecaseLetter
    -- ^ [Lt]
    | UnicodeGeneralCategoryTUppercaseLetter
    -- ^ [Lu]
    | UnicodeGeneralCategoryTSpacingMark
    -- ^ [Mc]
    | UnicodeGeneralCategoryTEnclosingMark
    -- ^ [Me]
    | UnicodeGeneralCategoryTNonSpacingMark
    -- ^ [Mn]
    | UnicodeGeneralCategoryTDecimalNumber
    -- ^ [Nd]
    | UnicodeGeneralCategoryTLetterNumber
    -- ^ [Nl]
    | UnicodeGeneralCategoryTOtherNumber
    -- ^ [No]
    | UnicodeGeneralCategoryTConnectPunctuation
    -- ^ [Pc]
    | UnicodeGeneralCategoryTDashPunctuation
    -- ^ [Pd]
    | UnicodeGeneralCategoryTClosePunctuation
    -- ^ [Pe]
    | UnicodeGeneralCategoryTFinalPunctuation
    -- ^ [Pf]
    | UnicodeGeneralCategoryTInitialPunctuation
    -- ^ [Pi]
    | UnicodeGeneralCategoryTOtherPunctuation
    -- ^ [Po]
    | UnicodeGeneralCategoryTOpenPunctuation
    -- ^ [Ps]
    | UnicodeGeneralCategoryTCurrencySymbol
    -- ^ [Sc]
    | UnicodeGeneralCategoryTModifierSymbol
    -- ^ [Sk]
    | UnicodeGeneralCategoryTMathSymbol
    -- ^ [Sm]
    | UnicodeGeneralCategoryTOtherSymbol
    -- ^ [So]
    | UnicodeGeneralCategoryTLineSeparator
    -- ^ [Zl]
    | UnicodeGeneralCategoryTParagraphSeparator
    -- ^ [Zp]
    | UnicodeGeneralCategoryTSpaceSeparator
    -- ^ [Zs]
    | AnotherUnicodeGeneralCategoryT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnicodeGeneralCategoryT where
    fromEnum UnicodeGeneralCategoryTControl = 0
    fromEnum UnicodeGeneralCategoryTFormat = 1
    fromEnum UnicodeGeneralCategoryTUnassigned = 2
    fromEnum UnicodeGeneralCategoryTPrivateUse = 3
    fromEnum UnicodeGeneralCategoryTSurrogate = 4
    fromEnum UnicodeGeneralCategoryTLowercaseLetter = 5
    fromEnum UnicodeGeneralCategoryTModifierLetter = 6
    fromEnum UnicodeGeneralCategoryTOtherLetter = 7
    fromEnum UnicodeGeneralCategoryTTitlecaseLetter = 8
    fromEnum UnicodeGeneralCategoryTUppercaseLetter = 9
    fromEnum UnicodeGeneralCategoryTSpacingMark = 10
    fromEnum UnicodeGeneralCategoryTEnclosingMark = 11
    fromEnum UnicodeGeneralCategoryTNonSpacingMark = 12
    fromEnum UnicodeGeneralCategoryTDecimalNumber = 13
    fromEnum UnicodeGeneralCategoryTLetterNumber = 14
    fromEnum UnicodeGeneralCategoryTOtherNumber = 15
    fromEnum UnicodeGeneralCategoryTConnectPunctuation = 16
    fromEnum UnicodeGeneralCategoryTDashPunctuation = 17
    fromEnum UnicodeGeneralCategoryTClosePunctuation = 18
    fromEnum UnicodeGeneralCategoryTFinalPunctuation = 19
    fromEnum UnicodeGeneralCategoryTInitialPunctuation = 20
    fromEnum UnicodeGeneralCategoryTOtherPunctuation = 21
    fromEnum UnicodeGeneralCategoryTOpenPunctuation = 22
    fromEnum UnicodeGeneralCategoryTCurrencySymbol = 23
    fromEnum UnicodeGeneralCategoryTModifierSymbol = 24
    fromEnum UnicodeGeneralCategoryTMathSymbol = 25
    fromEnum UnicodeGeneralCategoryTOtherSymbol = 26
    fromEnum UnicodeGeneralCategoryTLineSeparator = 27
    fromEnum UnicodeGeneralCategoryTParagraphSeparator = 28
    fromEnum UnicodeGeneralCategoryTSpaceSeparator = 29
    fromEnum (AnotherUnicodeGeneralCategoryT k) = k

    toEnum 0 = UnicodeGeneralCategoryTControl
    toEnum 1 = UnicodeGeneralCategoryTFormat
    toEnum 2 = UnicodeGeneralCategoryTUnassigned
    toEnum 3 = UnicodeGeneralCategoryTPrivateUse
    toEnum 4 = UnicodeGeneralCategoryTSurrogate
    toEnum 5 = UnicodeGeneralCategoryTLowercaseLetter
    toEnum 6 = UnicodeGeneralCategoryTModifierLetter
    toEnum 7 = UnicodeGeneralCategoryTOtherLetter
    toEnum 8 = UnicodeGeneralCategoryTTitlecaseLetter
    toEnum 9 = UnicodeGeneralCategoryTUppercaseLetter
    toEnum 10 = UnicodeGeneralCategoryTSpacingMark
    toEnum 11 = UnicodeGeneralCategoryTEnclosingMark
    toEnum 12 = UnicodeGeneralCategoryTNonSpacingMark
    toEnum 13 = UnicodeGeneralCategoryTDecimalNumber
    toEnum 14 = UnicodeGeneralCategoryTLetterNumber
    toEnum 15 = UnicodeGeneralCategoryTOtherNumber
    toEnum 16 = UnicodeGeneralCategoryTConnectPunctuation
    toEnum 17 = UnicodeGeneralCategoryTDashPunctuation
    toEnum 18 = UnicodeGeneralCategoryTClosePunctuation
    toEnum 19 = UnicodeGeneralCategoryTFinalPunctuation
    toEnum 20 = UnicodeGeneralCategoryTInitialPunctuation
    toEnum 21 = UnicodeGeneralCategoryTOtherPunctuation
    toEnum 22 = UnicodeGeneralCategoryTOpenPunctuation
    toEnum 23 = UnicodeGeneralCategoryTCurrencySymbol
    toEnum 24 = UnicodeGeneralCategoryTModifierSymbol
    toEnum 25 = UnicodeGeneralCategoryTMathSymbol
    toEnum 26 = UnicodeGeneralCategoryTOtherSymbol
    toEnum 27 = UnicodeGeneralCategoryTLineSeparator
    toEnum 28 = UnicodeGeneralCategoryTParagraphSeparator
    toEnum 29 = UnicodeGeneralCategoryTSpaceSeparator
    toEnum k = AnotherUnicodeGeneralCategoryT k

instance P.Ord UnicodeGeneralCategoryT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnicodeGeneralCategoryT = '[]
instance O.HasParentTypes UnicodeGeneralCategoryT

foreign import ccall "hb_gobject_unicode_general_category_get_type" c_hb_gobject_unicode_general_category_get_type :: 
    IO GType

instance B.Types.TypedObject UnicodeGeneralCategoryT where
    glibType = c_hb_gobject_unicode_general_category_get_type

instance B.Types.BoxedEnum UnicodeGeneralCategoryT

-- Enum unicode_combining_class_t
-- | Data type for the Canonical_Combining_Class (ccc) property
-- from the Unicode Character Database.
-- 
-- \<note>Note: newer versions of Unicode may add new values.
-- Client programs should be ready to handle any value in the 0..254 range
-- being returned from 'GI.HarfBuzz.Functions.unicodeCombiningClass'.\<\/note>
data UnicodeCombiningClassT = 
      UnicodeCombiningClassTNotReordered
    -- ^ Spacing and enclosing marks; also many vowel and consonant signs, even if nonspacing
    | UnicodeCombiningClassTOverlay
    -- ^ Marks which overlay a base letter or symbol
    | UnicodeCombiningClassTNukta
    -- ^ Diacritic nukta marks in Brahmi-derived scripts
    | UnicodeCombiningClassTKanaVoicing
    -- ^ Hiragana\/Katakana voicing marks
    | UnicodeCombiningClassTVirama
    -- ^ Viramas
    | UnicodeCombiningClassTCcc10
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc11
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc12
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc13
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc14
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc15
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc16
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc17
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc18
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc19
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc20
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc21
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc22
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc23
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc24
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc25
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc26
    -- ^ [Hebrew]
    | UnicodeCombiningClassTCcc27
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc28
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc29
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc30
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc31
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc32
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc33
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc34
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc35
    -- ^ [Arabic]
    | UnicodeCombiningClassTCcc36
    -- ^ [Syriac]
    | UnicodeCombiningClassTCcc84
    -- ^ [Telugu]
    | UnicodeCombiningClassTCcc91
    -- ^ [Telugu]
    | UnicodeCombiningClassTCcc103
    -- ^ [Thai]
    | UnicodeCombiningClassTCcc107
    -- ^ [Thai]
    | UnicodeCombiningClassTCcc118
    -- ^ [Lao]
    | UnicodeCombiningClassTCcc122
    -- ^ [Lao]
    | UnicodeCombiningClassTCcc129
    -- ^ [Tibetan]
    | UnicodeCombiningClassTCcc130
    -- ^ [Tibetan]
    | UnicodeCombiningClassTCcc132
    -- ^ [Tibetan] Since: 7.2.0
    | UnicodeCombiningClassTAttachedBelowLeft
    -- ^ Marks attached at the bottom left
    | UnicodeCombiningClassTAttachedBelow
    -- ^ Marks attached directly below
    | UnicodeCombiningClassTAttachedAbove
    -- ^ Marks attached directly above
    | UnicodeCombiningClassTAttachedAboveRight
    -- ^ Marks attached at the top right
    | UnicodeCombiningClassTBelowLeft
    -- ^ Distinct marks at the bottom left
    | UnicodeCombiningClassTBelow
    -- ^ Distinct marks directly below
    | UnicodeCombiningClassTBelowRight
    -- ^ Distinct marks at the bottom right
    | UnicodeCombiningClassTLeft
    -- ^ Distinct marks to the left
    | UnicodeCombiningClassTRight
    -- ^ Distinct marks to the right
    | UnicodeCombiningClassTAboveLeft
    -- ^ Distinct marks at the top left
    | UnicodeCombiningClassTAbove
    -- ^ Distinct marks directly above
    | UnicodeCombiningClassTAboveRight
    -- ^ Distinct marks at the top right
    | UnicodeCombiningClassTDoubleBelow
    -- ^ Distinct marks subtending two bases
    | UnicodeCombiningClassTDoubleAbove
    -- ^ Distinct marks extending above two bases
    | UnicodeCombiningClassTIotaSubscript
    -- ^ Greek iota subscript only
    | UnicodeCombiningClassTInvalid
    -- ^ Invalid combining class
    | AnotherUnicodeCombiningClassT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnicodeCombiningClassT where
    fromEnum UnicodeCombiningClassTNotReordered = 0
    fromEnum UnicodeCombiningClassTOverlay = 1
    fromEnum UnicodeCombiningClassTNukta = 7
    fromEnum UnicodeCombiningClassTKanaVoicing = 8
    fromEnum UnicodeCombiningClassTVirama = 9
    fromEnum UnicodeCombiningClassTCcc10 = 10
    fromEnum UnicodeCombiningClassTCcc11 = 11
    fromEnum UnicodeCombiningClassTCcc12 = 12
    fromEnum UnicodeCombiningClassTCcc13 = 13
    fromEnum UnicodeCombiningClassTCcc14 = 14
    fromEnum UnicodeCombiningClassTCcc15 = 15
    fromEnum UnicodeCombiningClassTCcc16 = 16
    fromEnum UnicodeCombiningClassTCcc17 = 17
    fromEnum UnicodeCombiningClassTCcc18 = 18
    fromEnum UnicodeCombiningClassTCcc19 = 19
    fromEnum UnicodeCombiningClassTCcc20 = 20
    fromEnum UnicodeCombiningClassTCcc21 = 21
    fromEnum UnicodeCombiningClassTCcc22 = 22
    fromEnum UnicodeCombiningClassTCcc23 = 23
    fromEnum UnicodeCombiningClassTCcc24 = 24
    fromEnum UnicodeCombiningClassTCcc25 = 25
    fromEnum UnicodeCombiningClassTCcc26 = 26
    fromEnum UnicodeCombiningClassTCcc27 = 27
    fromEnum UnicodeCombiningClassTCcc28 = 28
    fromEnum UnicodeCombiningClassTCcc29 = 29
    fromEnum UnicodeCombiningClassTCcc30 = 30
    fromEnum UnicodeCombiningClassTCcc31 = 31
    fromEnum UnicodeCombiningClassTCcc32 = 32
    fromEnum UnicodeCombiningClassTCcc33 = 33
    fromEnum UnicodeCombiningClassTCcc34 = 34
    fromEnum UnicodeCombiningClassTCcc35 = 35
    fromEnum UnicodeCombiningClassTCcc36 = 36
    fromEnum UnicodeCombiningClassTCcc84 = 84
    fromEnum UnicodeCombiningClassTCcc91 = 91
    fromEnum UnicodeCombiningClassTCcc103 = 103
    fromEnum UnicodeCombiningClassTCcc107 = 107
    fromEnum UnicodeCombiningClassTCcc118 = 118
    fromEnum UnicodeCombiningClassTCcc122 = 122
    fromEnum UnicodeCombiningClassTCcc129 = 129
    fromEnum UnicodeCombiningClassTCcc130 = 130
    fromEnum UnicodeCombiningClassTCcc132 = 132
    fromEnum UnicodeCombiningClassTAttachedBelowLeft = 200
    fromEnum UnicodeCombiningClassTAttachedBelow = 202
    fromEnum UnicodeCombiningClassTAttachedAbove = 214
    fromEnum UnicodeCombiningClassTAttachedAboveRight = 216
    fromEnum UnicodeCombiningClassTBelowLeft = 218
    fromEnum UnicodeCombiningClassTBelow = 220
    fromEnum UnicodeCombiningClassTBelowRight = 222
    fromEnum UnicodeCombiningClassTLeft = 224
    fromEnum UnicodeCombiningClassTRight = 226
    fromEnum UnicodeCombiningClassTAboveLeft = 228
    fromEnum UnicodeCombiningClassTAbove = 230
    fromEnum UnicodeCombiningClassTAboveRight = 232
    fromEnum UnicodeCombiningClassTDoubleBelow = 233
    fromEnum UnicodeCombiningClassTDoubleAbove = 234
    fromEnum UnicodeCombiningClassTIotaSubscript = 240
    fromEnum UnicodeCombiningClassTInvalid = 255
    fromEnum (AnotherUnicodeCombiningClassT k) = k

    toEnum 0 = UnicodeCombiningClassTNotReordered
    toEnum 1 = UnicodeCombiningClassTOverlay
    toEnum 7 = UnicodeCombiningClassTNukta
    toEnum 8 = UnicodeCombiningClassTKanaVoicing
    toEnum 9 = UnicodeCombiningClassTVirama
    toEnum 10 = UnicodeCombiningClassTCcc10
    toEnum 11 = UnicodeCombiningClassTCcc11
    toEnum 12 = UnicodeCombiningClassTCcc12
    toEnum 13 = UnicodeCombiningClassTCcc13
    toEnum 14 = UnicodeCombiningClassTCcc14
    toEnum 15 = UnicodeCombiningClassTCcc15
    toEnum 16 = UnicodeCombiningClassTCcc16
    toEnum 17 = UnicodeCombiningClassTCcc17
    toEnum 18 = UnicodeCombiningClassTCcc18
    toEnum 19 = UnicodeCombiningClassTCcc19
    toEnum 20 = UnicodeCombiningClassTCcc20
    toEnum 21 = UnicodeCombiningClassTCcc21
    toEnum 22 = UnicodeCombiningClassTCcc22
    toEnum 23 = UnicodeCombiningClassTCcc23
    toEnum 24 = UnicodeCombiningClassTCcc24
    toEnum 25 = UnicodeCombiningClassTCcc25
    toEnum 26 = UnicodeCombiningClassTCcc26
    toEnum 27 = UnicodeCombiningClassTCcc27
    toEnum 28 = UnicodeCombiningClassTCcc28
    toEnum 29 = UnicodeCombiningClassTCcc29
    toEnum 30 = UnicodeCombiningClassTCcc30
    toEnum 31 = UnicodeCombiningClassTCcc31
    toEnum 32 = UnicodeCombiningClassTCcc32
    toEnum 33 = UnicodeCombiningClassTCcc33
    toEnum 34 = UnicodeCombiningClassTCcc34
    toEnum 35 = UnicodeCombiningClassTCcc35
    toEnum 36 = UnicodeCombiningClassTCcc36
    toEnum 84 = UnicodeCombiningClassTCcc84
    toEnum 91 = UnicodeCombiningClassTCcc91
    toEnum 103 = UnicodeCombiningClassTCcc103
    toEnum 107 = UnicodeCombiningClassTCcc107
    toEnum 118 = UnicodeCombiningClassTCcc118
    toEnum 122 = UnicodeCombiningClassTCcc122
    toEnum 129 = UnicodeCombiningClassTCcc129
    toEnum 130 = UnicodeCombiningClassTCcc130
    toEnum 132 = UnicodeCombiningClassTCcc132
    toEnum 200 = UnicodeCombiningClassTAttachedBelowLeft
    toEnum 202 = UnicodeCombiningClassTAttachedBelow
    toEnum 214 = UnicodeCombiningClassTAttachedAbove
    toEnum 216 = UnicodeCombiningClassTAttachedAboveRight
    toEnum 218 = UnicodeCombiningClassTBelowLeft
    toEnum 220 = UnicodeCombiningClassTBelow
    toEnum 222 = UnicodeCombiningClassTBelowRight
    toEnum 224 = UnicodeCombiningClassTLeft
    toEnum 226 = UnicodeCombiningClassTRight
    toEnum 228 = UnicodeCombiningClassTAboveLeft
    toEnum 230 = UnicodeCombiningClassTAbove
    toEnum 232 = UnicodeCombiningClassTAboveRight
    toEnum 233 = UnicodeCombiningClassTDoubleBelow
    toEnum 234 = UnicodeCombiningClassTDoubleAbove
    toEnum 240 = UnicodeCombiningClassTIotaSubscript
    toEnum 255 = UnicodeCombiningClassTInvalid
    toEnum k = AnotherUnicodeCombiningClassT k

instance P.Ord UnicodeCombiningClassT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnicodeCombiningClassT = '[]
instance O.HasParentTypes UnicodeCombiningClassT

foreign import ccall "hb_gobject_unicode_combining_class_get_type" c_hb_gobject_unicode_combining_class_get_type :: 
    IO GType

instance B.Types.TypedObject UnicodeCombiningClassT where
    glibType = c_hb_gobject_unicode_combining_class_get_type

instance B.Types.BoxedEnum UnicodeCombiningClassT

-- Enum style_tag_t
-- | Defined by <https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg OpenType Design-Variation Axis Tag Registry>.
-- 
-- /Since: 3.0.0/
data StyleTagT = 
      StyleTagTItalic
    -- ^ Used to vary between non-italic and italic.
    -- A value of 0 can be interpreted as \"Roman\" (non-italic); a value of 1 can
    -- be interpreted as (fully) italic.
    | StyleTagTOpticalSize
    -- ^ Used to vary design to suit different text sizes.
    -- Non-zero. Values can be interpreted as text size, in points.
    | StyleTagTSlantAngle
    -- ^ Used to vary between upright and slanted text. Values
    -- must be greater than -90 and less than +90. Values can be interpreted as
    -- the angle, in counter-clockwise degrees, of oblique slant from whatever the
    -- designer considers to be upright for that font design. Typical right-leaning
    -- Italic fonts have a negative slant angle (typically around -12)
    | StyleTagTSlantRatio
    -- ^ same as /@hBSTYLETAGSLANTANGLE@/ expression as ratio.
    -- Typical right-leaning Italic fonts have a positive slant ratio (typically around 0.2)
    | StyleTagTWidth
    -- ^ Used to vary width of text from narrower to wider.
    -- Non-zero. Values can be interpreted as a percentage of whatever the font
    -- designer considers “normal width” for that font design.
    | StyleTagTWeight
    -- ^ Used to vary stroke thicknesses or other design details
    -- to give variation from lighter to blacker. Values can be interpreted in direct
    -- comparison to values for usWeightClass in the OS\/2 table,
    -- or the CSS font-weight property.
    | AnotherStyleTagT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StyleTagT where
    fromEnum StyleTagTItalic = 1769234796
    fromEnum StyleTagTOpticalSize = 1869640570
    fromEnum StyleTagTSlantAngle = 1936486004
    fromEnum StyleTagTSlantRatio = 1399615092
    fromEnum StyleTagTWidth = 2003072104
    fromEnum StyleTagTWeight = 2003265652
    fromEnum (AnotherStyleTagT k) = k

    toEnum 1769234796 = StyleTagTItalic
    toEnum 1869640570 = StyleTagTOpticalSize
    toEnum 1936486004 = StyleTagTSlantAngle
    toEnum 1399615092 = StyleTagTSlantRatio
    toEnum 2003072104 = StyleTagTWidth
    toEnum 2003265652 = StyleTagTWeight
    toEnum k = AnotherStyleTagT k

instance P.Ord StyleTagT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StyleTagT = '[]
instance O.HasParentTypes StyleTagT

foreign import ccall "hb_gobject_style_tag_get_type" c_hb_gobject_style_tag_get_type :: 
    IO GType

instance B.Types.TypedObject StyleTagT where
    glibType = c_hb_gobject_style_tag_get_type

instance B.Types.BoxedEnum StyleTagT

-- Enum script_t
-- | Data type for scripts. Each t'GI.HarfBuzz.Enums.ScriptT'\'s value is an @/hb_tag_t/@ corresponding
-- to the four-letter values defined by <https://unicode.org/iso15924/ ISO 15924>.
-- 
-- See also the Script (sc) property of the Unicode Character Database.
data ScriptT = 
      ScriptTCommon
    -- ^ @Zyyy@
    | ScriptTInherited
    -- ^ @Zinh@
    | ScriptTUnknown
    -- ^ @Zzzz@
    | ScriptTArabic
    -- ^ @Arab@
    | ScriptTArmenian
    -- ^ @Armn@
    | ScriptTBengali
    -- ^ @Beng@
    | ScriptTCyrillic
    -- ^ @Cyrl@
    | ScriptTDevanagari
    -- ^ @Deva@
    | ScriptTGeorgian
    -- ^ @Geor@
    | ScriptTGreek
    -- ^ @Grek@
    | ScriptTGujarati
    -- ^ @Gujr@
    | ScriptTGurmukhi
    -- ^ @Guru@
    | ScriptTHangul
    -- ^ @Hang@
    | ScriptTHan
    -- ^ @Hani@
    | ScriptTHebrew
    -- ^ @Hebr@
    | ScriptTHiragana
    -- ^ @Hira@
    | ScriptTKannada
    -- ^ @Knda@
    | ScriptTKatakana
    -- ^ @Kana@
    | ScriptTLao
    -- ^ @Laoo@
    | ScriptTLatin
    -- ^ @Latn@
    | ScriptTMalayalam
    -- ^ @Mlym@
    | ScriptTOriya
    -- ^ @Orya@
    | ScriptTTamil
    -- ^ @Taml@
    | ScriptTTelugu
    -- ^ @Telu@
    | ScriptTThai
    -- ^ @Thai@
    | ScriptTTibetan
    -- ^ @Tibt@
    | ScriptTBopomofo
    -- ^ @Bopo@
    | ScriptTBraille
    -- ^ @Brai@
    | ScriptTCanadianSyllabics
    -- ^ @Cans@
    | ScriptTCherokee
    -- ^ @Cher@
    | ScriptTEthiopic
    -- ^ @Ethi@
    | ScriptTKhmer
    -- ^ @Khmr@
    | ScriptTMongolian
    -- ^ @Mong@
    | ScriptTMyanmar
    -- ^ @Mymr@
    | ScriptTOgham
    -- ^ @Ogam@
    | ScriptTRunic
    -- ^ @Runr@
    | ScriptTSinhala
    -- ^ @Sinh@
    | ScriptTSyriac
    -- ^ @Syrc@
    | ScriptTThaana
    -- ^ @Thaa@
    | ScriptTYi
    -- ^ @Yiii@
    | ScriptTDeseret
    -- ^ @Dsrt@
    | ScriptTGothic
    -- ^ @Goth@
    | ScriptTOldItalic
    -- ^ @Ital@
    | ScriptTBuhid
    -- ^ @Buhd@
    | ScriptTHanunoo
    -- ^ @Hano@
    | ScriptTTagalog
    -- ^ @Tglg@
    | ScriptTTagbanwa
    -- ^ @Tagb@
    | ScriptTCypriot
    -- ^ @Cprt@
    | ScriptTLimbu
    -- ^ @Limb@
    | ScriptTLinearB
    -- ^ @Linb@
    | ScriptTOsmanya
    -- ^ @Osma@
    | ScriptTShavian
    -- ^ @Shaw@
    | ScriptTTaiLe
    -- ^ @Tale@
    | ScriptTUgaritic
    -- ^ @Ugar@
    | ScriptTBuginese
    -- ^ @Bugi@
    | ScriptTCoptic
    -- ^ @Copt@
    | ScriptTGlagolitic
    -- ^ @Glag@
    | ScriptTKharoshthi
    -- ^ @Khar@
    | ScriptTNewTaiLue
    -- ^ @Talu@
    | ScriptTOldPersian
    -- ^ @Xpeo@
    | ScriptTSylotiNagri
    -- ^ @Sylo@
    | ScriptTTifinagh
    -- ^ @Tfng@
    | ScriptTBalinese
    -- ^ @Bali@
    | ScriptTCuneiform
    -- ^ @Xsux@
    | ScriptTNko
    -- ^ @Nkoo@
    | ScriptTPhagsPa
    -- ^ @Phag@
    | ScriptTPhoenician
    -- ^ @Phnx@
    | ScriptTCarian
    -- ^ @Cari@
    | ScriptTCham
    -- ^ @Cham@
    | ScriptTKayahLi
    -- ^ @Kali@
    | ScriptTLepcha
    -- ^ @Lepc@
    | ScriptTLycian
    -- ^ @Lyci@
    | ScriptTLydian
    -- ^ @Lydi@
    | ScriptTOlChiki
    -- ^ @Olck@
    | ScriptTRejang
    -- ^ @Rjng@
    | ScriptTSaurashtra
    -- ^ @Saur@
    | ScriptTSundanese
    -- ^ @Sund@
    | ScriptTVai
    -- ^ @Vaii@
    | ScriptTAvestan
    -- ^ @Avst@
    | ScriptTBamum
    -- ^ @Bamu@
    | ScriptTEgyptianHieroglyphs
    -- ^ @Egyp@
    | ScriptTImperialAramaic
    -- ^ @Armi@
    | ScriptTInscriptionalPahlavi
    -- ^ @Phli@
    | ScriptTInscriptionalParthian
    -- ^ @Prti@
    | ScriptTJavanese
    -- ^ @Java@
    | ScriptTKaithi
    -- ^ @Kthi@
    | ScriptTLisu
    -- ^ @Lisu@
    | ScriptTMeeteiMayek
    -- ^ @Mtei@
    | ScriptTOldSouthArabian
    -- ^ @Sarb@
    | ScriptTOldTurkic
    -- ^ @Orkh@
    | ScriptTSamaritan
    -- ^ @Samr@
    | ScriptTTaiTham
    -- ^ @Lana@
    | ScriptTTaiViet
    -- ^ @Tavt@
    | ScriptTBatak
    -- ^ @Batk@
    | ScriptTBrahmi
    -- ^ @Brah@
    | ScriptTMandaic
    -- ^ @Mand@
    | ScriptTChakma
    -- ^ @Cakm@
    | ScriptTMeroiticCursive
    -- ^ @Merc@
    | ScriptTMeroiticHieroglyphs
    -- ^ @Mero@
    | ScriptTMiao
    -- ^ @Plrd@
    | ScriptTSharada
    -- ^ @Shrd@
    | ScriptTSoraSompeng
    -- ^ @Sora@
    | ScriptTTakri
    -- ^ @Takr@
    | ScriptTBassaVah
    -- ^ @Bass@, Since: 0.9.30
    | ScriptTCaucasianAlbanian
    -- ^ @Aghb@, Since: 0.9.30
    | ScriptTDuployan
    -- ^ @Dupl@, Since: 0.9.30
    | ScriptTElbasan
    -- ^ @Elba@, Since: 0.9.30
    | ScriptTGrantha
    -- ^ @Gran@, Since: 0.9.30
    | ScriptTKhojki
    -- ^ @Khoj@, Since: 0.9.30
    | ScriptTKhudawadi
    -- ^ @Sind@, Since: 0.9.30
    | ScriptTLinearA
    -- ^ @Lina@, Since: 0.9.30
    | ScriptTMahajani
    -- ^ @Mahj@, Since: 0.9.30
    | ScriptTManichaean
    -- ^ @Mani@, Since: 0.9.30
    | ScriptTMendeKikakui
    -- ^ @Mend@, Since: 0.9.30
    | ScriptTModi
    -- ^ @Modi@, Since: 0.9.30
    | ScriptTMro
    -- ^ @Mroo@, Since: 0.9.30
    | ScriptTNabataean
    -- ^ @Nbat@, Since: 0.9.30
    | ScriptTOldNorthArabian
    -- ^ @Narb@, Since: 0.9.30
    | ScriptTOldPermic
    -- ^ @Perm@, Since: 0.9.30
    | ScriptTPahawhHmong
    -- ^ @Hmng@, Since: 0.9.30
    | ScriptTPalmyrene
    -- ^ @Palm@, Since: 0.9.30
    | ScriptTPauCinHau
    -- ^ @Pauc@, Since: 0.9.30
    | ScriptTPsalterPahlavi
    -- ^ @Phlp@, Since: 0.9.30
    | ScriptTSiddham
    -- ^ @Sidd@, Since: 0.9.30
    | ScriptTTirhuta
    -- ^ @Tirh@, Since: 0.9.30
    | ScriptTWarangCiti
    -- ^ @Wara@, Since: 0.9.30
    | ScriptTAhom
    -- ^ @Ahom@, Since: 0.9.30
    | ScriptTAnatolianHieroglyphs
    -- ^ @Hluw@, Since: 0.9.30
    | ScriptTHatran
    -- ^ @Hatr@, Since: 0.9.30
    | ScriptTMultani
    -- ^ @Mult@, Since: 0.9.30
    | ScriptTOldHungarian
    -- ^ @Hung@, Since: 0.9.30
    | ScriptTSignwriting
    -- ^ @Sgnw@, Since: 0.9.30
    | ScriptTAdlam
    -- ^ @Adlm@, Since: 1.3.0
    | ScriptTBhaiksuki
    -- ^ @Bhks@, Since: 1.3.0
    | ScriptTMarchen
    -- ^ @Marc@, Since: 1.3.0
    | ScriptTOsage
    -- ^ @Osge@, Since: 1.3.0
    | ScriptTTangut
    -- ^ @Tang@, Since: 1.3.0
    | ScriptTNewa
    -- ^ @Newa@, Since: 1.3.0
    | ScriptTMasaramGondi
    -- ^ @Gonm@, Since: 1.6.0
    | ScriptTNushu
    -- ^ @Nshu@, Since: 1.6.0
    | ScriptTSoyombo
    -- ^ @Soyo@, Since: 1.6.0
    | ScriptTZanabazarSquare
    -- ^ @Zanb@, Since: 1.6.0
    | ScriptTDogra
    -- ^ @Dogr@, Since: 1.8.0
    | ScriptTGunjalaGondi
    -- ^ @Gong@, Since: 1.8.0
    | ScriptTHanifiRohingya
    -- ^ @Rohg@, Since: 1.8.0
    | ScriptTMakasar
    -- ^ @Maka@, Since: 1.8.0
    | ScriptTMedefaidrin
    -- ^ @Medf@, Since: 1.8.0
    | ScriptTOldSogdian
    -- ^ @Sogo@, Since: 1.8.0
    | ScriptTSogdian
    -- ^ @Sogd@, Since: 1.8.0
    | ScriptTElymaic
    -- ^ @Elym@, Since: 2.4.0
    | ScriptTNandinagari
    -- ^ @Nand@, Since: 2.4.0
    | ScriptTNyiakengPuachueHmong
    -- ^ @Hmnp@, Since: 2.4.0
    | ScriptTWancho
    -- ^ @Wcho@, Since: 2.4.0
    | ScriptTChorasmian
    -- ^ @Chrs@, Since: 2.6.7
    | ScriptTDivesAkuru
    -- ^ @Diak@, Since: 2.6.7
    | ScriptTKhitanSmallScript
    -- ^ @Kits@, Since: 2.6.7
    | ScriptTYezidi
    -- ^ @Yezi@, Since: 2.6.7
    | ScriptTCyproMinoan
    -- ^ @Cpmn@, Since: 3.0.0
    | ScriptTOldUyghur
    -- ^ @Ougr@, Since: 3.0.0
    | ScriptTTangsa
    -- ^ @Tnsa@, Since: 3.0.0
    | ScriptTToto
    -- ^ @Toto@, Since: 3.0.0
    | ScriptTVithkuqi
    -- ^ @Vith@, Since: 3.0.0
    | ScriptTMath
    -- ^ @Zmth@, Since: 3.4.0
    | ScriptTKawi
    -- ^ @Kawi@, Since: 5.2.0
    | ScriptTNagMundari
    -- ^ @Nagm@, Since: 5.2.0
    | ScriptTGaray
    -- ^ @Gara@, Since: 10.0.0
    | ScriptTGurungKhema
    -- ^ @Gukh@, Since: 10.0.0
    | ScriptTKiratRai
    -- ^ @Krai@, Since: 10.0.0
    | ScriptTOlOnal
    -- ^ @Onao@, Since: 10.0.0
    | ScriptTSunuwar
    -- ^ @Sunu@, Since: 10.0.0
    | ScriptTTodhri
    -- ^ @Todr@, Since: 10.0.0
    | ScriptTTuluTigalari
    -- ^ @Tutg@, Since: 10.0.0
    | ScriptTBeriaErfe
    -- ^ @Berf@, Since: 11.5.0
    | ScriptTSidetic
    -- ^ @Sidt@, Since: 11.5.0
    | ScriptTTaiYo
    -- ^ @Tayo@, Since: 11.5.0
    | ScriptTTolongSiki
    -- ^ @Tols@, Since: 11.5.0
    | ScriptTInvalid
    -- ^ No script set
    | AnotherScriptT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScriptT where
    fromEnum ScriptTCommon = 1517910393
    fromEnum ScriptTInherited = 1516858984
    fromEnum ScriptTUnknown = 1517976186
    fromEnum ScriptTArabic = 1098015074
    fromEnum ScriptTArmenian = 1098018158
    fromEnum ScriptTBengali = 1113943655
    fromEnum ScriptTCyrillic = 1132032620
    fromEnum ScriptTDevanagari = 1147500129
    fromEnum ScriptTGeorgian = 1197830002
    fromEnum ScriptTGreek = 1198679403
    fromEnum ScriptTGujarati = 1198877298
    fromEnum ScriptTGurmukhi = 1198879349
    fromEnum ScriptTHangul = 1214344807
    fromEnum ScriptTHan = 1214344809
    fromEnum ScriptTHebrew = 1214603890
    fromEnum ScriptTHiragana = 1214870113
    fromEnum ScriptTKannada = 1265525857
    fromEnum ScriptTKatakana = 1264676449
    fromEnum ScriptTLao = 1281453935
    fromEnum ScriptTLatin = 1281455214
    fromEnum ScriptTMalayalam = 1298954605
    fromEnum ScriptTOriya = 1332902241
    fromEnum ScriptTTamil = 1415671148
    fromEnum ScriptTTelugu = 1415933045
    fromEnum ScriptTThai = 1416126825
    fromEnum ScriptTTibetan = 1416192628
    fromEnum ScriptTBopomofo = 1114599535
    fromEnum ScriptTBraille = 1114792297
    fromEnum ScriptTCanadianSyllabics = 1130458739
    fromEnum ScriptTCherokee = 1130915186
    fromEnum ScriptTEthiopic = 1165256809
    fromEnum ScriptTKhmer = 1265134962
    fromEnum ScriptTMongolian = 1299148391
    fromEnum ScriptTMyanmar = 1299803506
    fromEnum ScriptTOgham = 1332175213
    fromEnum ScriptTRunic = 1383427698
    fromEnum ScriptTSinhala = 1399418472
    fromEnum ScriptTSyriac = 1400468067
    fromEnum ScriptTThaana = 1416126817
    fromEnum ScriptTYi = 1500080489
    fromEnum ScriptTDeseret = 1148416628
    fromEnum ScriptTGothic = 1198486632
    fromEnum ScriptTOldItalic = 1232363884
    fromEnum ScriptTBuhid = 1114990692
    fromEnum ScriptTHanunoo = 1214344815
    fromEnum ScriptTTagalog = 1416064103
    fromEnum ScriptTTagbanwa = 1415669602
    fromEnum ScriptTCypriot = 1131442804
    fromEnum ScriptTLimbu = 1281977698
    fromEnum ScriptTLinearB = 1281977954
    fromEnum ScriptTOsmanya = 1332964705
    fromEnum ScriptTShavian = 1399349623
    fromEnum ScriptTTaiLe = 1415670885
    fromEnum ScriptTUgaritic = 1432838514
    fromEnum ScriptTBuginese = 1114990441
    fromEnum ScriptTCoptic = 1131376756
    fromEnum ScriptTGlagolitic = 1198285159
    fromEnum ScriptTKharoshthi = 1265131890
    fromEnum ScriptTNewTaiLue = 1415670901
    fromEnum ScriptTOldPersian = 1483761007
    fromEnum ScriptTSylotiNagri = 1400466543
    fromEnum ScriptTTifinagh = 1415999079
    fromEnum ScriptTBalinese = 1113681001
    fromEnum ScriptTCuneiform = 1483961720
    fromEnum ScriptTNko = 1315663727
    fromEnum ScriptTPhagsPa = 1349017959
    fromEnum ScriptTPhoenician = 1349021304
    fromEnum ScriptTCarian = 1130459753
    fromEnum ScriptTCham = 1130914157
    fromEnum ScriptTKayahLi = 1264675945
    fromEnum ScriptTLepcha = 1281716323
    fromEnum ScriptTLycian = 1283023721
    fromEnum ScriptTLydian = 1283023977
    fromEnum ScriptTOlChiki = 1332503403
    fromEnum ScriptTRejang = 1382706791
    fromEnum ScriptTSaurashtra = 1398895986
    fromEnum ScriptTSundanese = 1400204900
    fromEnum ScriptTVai = 1449224553
    fromEnum ScriptTAvestan = 1098281844
    fromEnum ScriptTBamum = 1113681269
    fromEnum ScriptTEgyptianHieroglyphs = 1164409200
    fromEnum ScriptTImperialAramaic = 1098018153
    fromEnum ScriptTInscriptionalPahlavi = 1349020777
    fromEnum ScriptTInscriptionalParthian = 1349678185
    fromEnum ScriptTJavanese = 1247901281
    fromEnum ScriptTKaithi = 1265920105
    fromEnum ScriptTLisu = 1281979253
    fromEnum ScriptTMeeteiMayek = 1299473769
    fromEnum ScriptTOldSouthArabian = 1398895202
    fromEnum ScriptTOldTurkic = 1332898664
    fromEnum ScriptTSamaritan = 1398893938
    fromEnum ScriptTTaiTham = 1281453665
    fromEnum ScriptTTaiViet = 1415673460
    fromEnum ScriptTBatak = 1113683051
    fromEnum ScriptTBrahmi = 1114792296
    fromEnum ScriptTMandaic = 1298230884
    fromEnum ScriptTChakma = 1130457965
    fromEnum ScriptTMeroiticCursive = 1298494051
    fromEnum ScriptTMeroiticHieroglyphs = 1298494063
    fromEnum ScriptTMiao = 1349284452
    fromEnum ScriptTSharada = 1399353956
    fromEnum ScriptTSoraSompeng = 1399812705
    fromEnum ScriptTTakri = 1415670642
    fromEnum ScriptTBassaVah = 1113682803
    fromEnum ScriptTCaucasianAlbanian = 1097295970
    fromEnum ScriptTDuployan = 1148547180
    fromEnum ScriptTElbasan = 1164730977
    fromEnum ScriptTGrantha = 1198678382
    fromEnum ScriptTKhojki = 1265135466
    fromEnum ScriptTKhudawadi = 1399418468
    fromEnum ScriptTLinearA = 1281977953
    fromEnum ScriptTMahajani = 1298229354
    fromEnum ScriptTManichaean = 1298230889
    fromEnum ScriptTMendeKikakui = 1298493028
    fromEnum ScriptTModi = 1299145833
    fromEnum ScriptTMro = 1299345263
    fromEnum ScriptTNabataean = 1315070324
    fromEnum ScriptTOldNorthArabian = 1315009122
    fromEnum ScriptTOldPermic = 1348825709
    fromEnum ScriptTPahawhHmong = 1215131239
    fromEnum ScriptTPalmyrene = 1348562029
    fromEnum ScriptTPauCinHau = 1348564323
    fromEnum ScriptTPsalterPahlavi = 1349020784
    fromEnum ScriptTSiddham = 1399415908
    fromEnum ScriptTTirhuta = 1416196712
    fromEnum ScriptTWarangCiti = 1466004065
    fromEnum ScriptTAhom = 1097363309
    fromEnum ScriptTAnatolianHieroglyphs = 1215067511
    fromEnum ScriptTHatran = 1214346354
    fromEnum ScriptTMultani = 1299541108
    fromEnum ScriptTOldHungarian = 1215655527
    fromEnum ScriptTSignwriting = 1399287415
    fromEnum ScriptTAdlam = 1097100397
    fromEnum ScriptTBhaiksuki = 1114139507
    fromEnum ScriptTMarchen = 1298231907
    fromEnum ScriptTOsage = 1332963173
    fromEnum ScriptTTangut = 1415671399
    fromEnum ScriptTNewa = 1315272545
    fromEnum ScriptTMasaramGondi = 1198485101
    fromEnum ScriptTNushu = 1316186229
    fromEnum ScriptTSoyombo = 1399814511
    fromEnum ScriptTZanabazarSquare = 1516334690
    fromEnum ScriptTDogra = 1148151666
    fromEnum ScriptTGunjalaGondi = 1198485095
    fromEnum ScriptTHanifiRohingya = 1383032935
    fromEnum ScriptTMakasar = 1298230113
    fromEnum ScriptTMedefaidrin = 1298490470
    fromEnum ScriptTOldSogdian = 1399809903
    fromEnum ScriptTSogdian = 1399809892
    fromEnum ScriptTElymaic = 1164736877
    fromEnum ScriptTNandinagari = 1315008100
    fromEnum ScriptTNyiakengPuachueHmong = 1215131248
    fromEnum ScriptTWancho = 1466132591
    fromEnum ScriptTChorasmian = 1130918515
    fromEnum ScriptTDivesAkuru = 1147756907
    fromEnum ScriptTKhitanSmallScript = 1265202291
    fromEnum ScriptTYezidi = 1499822697
    fromEnum ScriptTCyproMinoan = 1131441518
    fromEnum ScriptTOldUyghur = 1333094258
    fromEnum ScriptTTangsa = 1416524641
    fromEnum ScriptTToto = 1416590447
    fromEnum ScriptTVithkuqi = 1449751656
    fromEnum ScriptTMath = 1517122664
    fromEnum ScriptTKawi = 1264678761
    fromEnum ScriptTNagMundari = 1315006317
    fromEnum ScriptTGaray = 1197568609
    fromEnum ScriptTGurungKhema = 1198877544
    fromEnum ScriptTKiratRai = 1265787241
    fromEnum ScriptTOlOnal = 1332633967
    fromEnum ScriptTSunuwar = 1400204917
    fromEnum ScriptTTodhri = 1416586354
    fromEnum ScriptTTuluTigalari = 1416983655
    fromEnum ScriptTBeriaErfe = 1113944678
    fromEnum ScriptTSidetic = 1399415924
    fromEnum ScriptTTaiYo = 1415674223
    fromEnum ScriptTTolongSiki = 1416588403
    fromEnum ScriptTInvalid = 0
    fromEnum (AnotherScriptT k) = k

    toEnum 1517910393 = ScriptTCommon
    toEnum 1516858984 = ScriptTInherited
    toEnum 1517976186 = ScriptTUnknown
    toEnum 1098015074 = ScriptTArabic
    toEnum 1098018158 = ScriptTArmenian
    toEnum 1113943655 = ScriptTBengali
    toEnum 1132032620 = ScriptTCyrillic
    toEnum 1147500129 = ScriptTDevanagari
    toEnum 1197830002 = ScriptTGeorgian
    toEnum 1198679403 = ScriptTGreek
    toEnum 1198877298 = ScriptTGujarati
    toEnum 1198879349 = ScriptTGurmukhi
    toEnum 1214344807 = ScriptTHangul
    toEnum 1214344809 = ScriptTHan
    toEnum 1214603890 = ScriptTHebrew
    toEnum 1214870113 = ScriptTHiragana
    toEnum 1265525857 = ScriptTKannada
    toEnum 1264676449 = ScriptTKatakana
    toEnum 1281453935 = ScriptTLao
    toEnum 1281455214 = ScriptTLatin
    toEnum 1298954605 = ScriptTMalayalam
    toEnum 1332902241 = ScriptTOriya
    toEnum 1415671148 = ScriptTTamil
    toEnum 1415933045 = ScriptTTelugu
    toEnum 1416126825 = ScriptTThai
    toEnum 1416192628 = ScriptTTibetan
    toEnum 1114599535 = ScriptTBopomofo
    toEnum 1114792297 = ScriptTBraille
    toEnum 1130458739 = ScriptTCanadianSyllabics
    toEnum 1130915186 = ScriptTCherokee
    toEnum 1165256809 = ScriptTEthiopic
    toEnum 1265134962 = ScriptTKhmer
    toEnum 1299148391 = ScriptTMongolian
    toEnum 1299803506 = ScriptTMyanmar
    toEnum 1332175213 = ScriptTOgham
    toEnum 1383427698 = ScriptTRunic
    toEnum 1399418472 = ScriptTSinhala
    toEnum 1400468067 = ScriptTSyriac
    toEnum 1416126817 = ScriptTThaana
    toEnum 1500080489 = ScriptTYi
    toEnum 1148416628 = ScriptTDeseret
    toEnum 1198486632 = ScriptTGothic
    toEnum 1232363884 = ScriptTOldItalic
    toEnum 1114990692 = ScriptTBuhid
    toEnum 1214344815 = ScriptTHanunoo
    toEnum 1416064103 = ScriptTTagalog
    toEnum 1415669602 = ScriptTTagbanwa
    toEnum 1131442804 = ScriptTCypriot
    toEnum 1281977698 = ScriptTLimbu
    toEnum 1281977954 = ScriptTLinearB
    toEnum 1332964705 = ScriptTOsmanya
    toEnum 1399349623 = ScriptTShavian
    toEnum 1415670885 = ScriptTTaiLe
    toEnum 1432838514 = ScriptTUgaritic
    toEnum 1114990441 = ScriptTBuginese
    toEnum 1131376756 = ScriptTCoptic
    toEnum 1198285159 = ScriptTGlagolitic
    toEnum 1265131890 = ScriptTKharoshthi
    toEnum 1415670901 = ScriptTNewTaiLue
    toEnum 1483761007 = ScriptTOldPersian
    toEnum 1400466543 = ScriptTSylotiNagri
    toEnum 1415999079 = ScriptTTifinagh
    toEnum 1113681001 = ScriptTBalinese
    toEnum 1483961720 = ScriptTCuneiform
    toEnum 1315663727 = ScriptTNko
    toEnum 1349017959 = ScriptTPhagsPa
    toEnum 1349021304 = ScriptTPhoenician
    toEnum 1130459753 = ScriptTCarian
    toEnum 1130914157 = ScriptTCham
    toEnum 1264675945 = ScriptTKayahLi
    toEnum 1281716323 = ScriptTLepcha
    toEnum 1283023721 = ScriptTLycian
    toEnum 1283023977 = ScriptTLydian
    toEnum 1332503403 = ScriptTOlChiki
    toEnum 1382706791 = ScriptTRejang
    toEnum 1398895986 = ScriptTSaurashtra
    toEnum 1400204900 = ScriptTSundanese
    toEnum 1449224553 = ScriptTVai
    toEnum 1098281844 = ScriptTAvestan
    toEnum 1113681269 = ScriptTBamum
    toEnum 1164409200 = ScriptTEgyptianHieroglyphs
    toEnum 1098018153 = ScriptTImperialAramaic
    toEnum 1349020777 = ScriptTInscriptionalPahlavi
    toEnum 1349678185 = ScriptTInscriptionalParthian
    toEnum 1247901281 = ScriptTJavanese
    toEnum 1265920105 = ScriptTKaithi
    toEnum 1281979253 = ScriptTLisu
    toEnum 1299473769 = ScriptTMeeteiMayek
    toEnum 1398895202 = ScriptTOldSouthArabian
    toEnum 1332898664 = ScriptTOldTurkic
    toEnum 1398893938 = ScriptTSamaritan
    toEnum 1281453665 = ScriptTTaiTham
    toEnum 1415673460 = ScriptTTaiViet
    toEnum 1113683051 = ScriptTBatak
    toEnum 1114792296 = ScriptTBrahmi
    toEnum 1298230884 = ScriptTMandaic
    toEnum 1130457965 = ScriptTChakma
    toEnum 1298494051 = ScriptTMeroiticCursive
    toEnum 1298494063 = ScriptTMeroiticHieroglyphs
    toEnum 1349284452 = ScriptTMiao
    toEnum 1399353956 = ScriptTSharada
    toEnum 1399812705 = ScriptTSoraSompeng
    toEnum 1415670642 = ScriptTTakri
    toEnum 1113682803 = ScriptTBassaVah
    toEnum 1097295970 = ScriptTCaucasianAlbanian
    toEnum 1148547180 = ScriptTDuployan
    toEnum 1164730977 = ScriptTElbasan
    toEnum 1198678382 = ScriptTGrantha
    toEnum 1265135466 = ScriptTKhojki
    toEnum 1399418468 = ScriptTKhudawadi
    toEnum 1281977953 = ScriptTLinearA
    toEnum 1298229354 = ScriptTMahajani
    toEnum 1298230889 = ScriptTManichaean
    toEnum 1298493028 = ScriptTMendeKikakui
    toEnum 1299145833 = ScriptTModi
    toEnum 1299345263 = ScriptTMro
    toEnum 1315070324 = ScriptTNabataean
    toEnum 1315009122 = ScriptTOldNorthArabian
    toEnum 1348825709 = ScriptTOldPermic
    toEnum 1215131239 = ScriptTPahawhHmong
    toEnum 1348562029 = ScriptTPalmyrene
    toEnum 1348564323 = ScriptTPauCinHau
    toEnum 1349020784 = ScriptTPsalterPahlavi
    toEnum 1399415908 = ScriptTSiddham
    toEnum 1416196712 = ScriptTTirhuta
    toEnum 1466004065 = ScriptTWarangCiti
    toEnum 1097363309 = ScriptTAhom
    toEnum 1215067511 = ScriptTAnatolianHieroglyphs
    toEnum 1214346354 = ScriptTHatran
    toEnum 1299541108 = ScriptTMultani
    toEnum 1215655527 = ScriptTOldHungarian
    toEnum 1399287415 = ScriptTSignwriting
    toEnum 1097100397 = ScriptTAdlam
    toEnum 1114139507 = ScriptTBhaiksuki
    toEnum 1298231907 = ScriptTMarchen
    toEnum 1332963173 = ScriptTOsage
    toEnum 1415671399 = ScriptTTangut
    toEnum 1315272545 = ScriptTNewa
    toEnum 1198485101 = ScriptTMasaramGondi
    toEnum 1316186229 = ScriptTNushu
    toEnum 1399814511 = ScriptTSoyombo
    toEnum 1516334690 = ScriptTZanabazarSquare
    toEnum 1148151666 = ScriptTDogra
    toEnum 1198485095 = ScriptTGunjalaGondi
    toEnum 1383032935 = ScriptTHanifiRohingya
    toEnum 1298230113 = ScriptTMakasar
    toEnum 1298490470 = ScriptTMedefaidrin
    toEnum 1399809903 = ScriptTOldSogdian
    toEnum 1399809892 = ScriptTSogdian
    toEnum 1164736877 = ScriptTElymaic
    toEnum 1315008100 = ScriptTNandinagari
    toEnum 1215131248 = ScriptTNyiakengPuachueHmong
    toEnum 1466132591 = ScriptTWancho
    toEnum 1130918515 = ScriptTChorasmian
    toEnum 1147756907 = ScriptTDivesAkuru
    toEnum 1265202291 = ScriptTKhitanSmallScript
    toEnum 1499822697 = ScriptTYezidi
    toEnum 1131441518 = ScriptTCyproMinoan
    toEnum 1333094258 = ScriptTOldUyghur
    toEnum 1416524641 = ScriptTTangsa
    toEnum 1416590447 = ScriptTToto
    toEnum 1449751656 = ScriptTVithkuqi
    toEnum 1517122664 = ScriptTMath
    toEnum 1264678761 = ScriptTKawi
    toEnum 1315006317 = ScriptTNagMundari
    toEnum 1197568609 = ScriptTGaray
    toEnum 1198877544 = ScriptTGurungKhema
    toEnum 1265787241 = ScriptTKiratRai
    toEnum 1332633967 = ScriptTOlOnal
    toEnum 1400204917 = ScriptTSunuwar
    toEnum 1416586354 = ScriptTTodhri
    toEnum 1416983655 = ScriptTTuluTigalari
    toEnum 1113944678 = ScriptTBeriaErfe
    toEnum 1399415924 = ScriptTSidetic
    toEnum 1415674223 = ScriptTTaiYo
    toEnum 1416588403 = ScriptTTolongSiki
    toEnum 0 = ScriptTInvalid
    toEnum k = AnotherScriptT k

instance P.Ord ScriptT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScriptT = '[]
instance O.HasParentTypes ScriptT

foreign import ccall "hb_gobject_script_get_type" c_hb_gobject_script_get_type :: 
    IO GType

instance B.Types.TypedObject ScriptT where
    glibType = c_hb_gobject_script_get_type

instance B.Types.BoxedEnum ScriptT

-- Enum paint_extend_t
-- | The values of this enumeration determine how color values
-- outside the minimum and maximum defined offset on a t'GI.HarfBuzz.Structs.ColorLineT.ColorLineT'
-- are determined.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details.
-- 
-- /Since: 7.0.0/
data PaintExtendT = 
      PaintExtendTPad
    -- ^ Outside the defined interval,
    --   the color of the closest color stop is used.
    | PaintExtendTRepeat
    -- ^ The color line is repeated over
    --   repeated multiples of the defined interval
    | PaintExtendTReflect
    -- ^ The color line is repeated over
    --      repeated intervals, as for the repeat mode.
    --      However, in each repeated interval, the ordering of
    --      color stops is the reverse of the adjacent interval.
    | AnotherPaintExtendT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PaintExtendT where
    fromEnum PaintExtendTPad = 0
    fromEnum PaintExtendTRepeat = 1
    fromEnum PaintExtendTReflect = 2
    fromEnum (AnotherPaintExtendT k) = k

    toEnum 0 = PaintExtendTPad
    toEnum 1 = PaintExtendTRepeat
    toEnum 2 = PaintExtendTReflect
    toEnum k = AnotherPaintExtendT k

instance P.Ord PaintExtendT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PaintExtendT = '[]
instance O.HasParentTypes PaintExtendT

foreign import ccall "hb_gobject_paint_extend_get_type" c_hb_gobject_paint_extend_get_type :: 
    IO GType

instance B.Types.TypedObject PaintExtendT where
    glibType = c_hb_gobject_paint_extend_get_type

instance B.Types.BoxedEnum PaintExtendT

-- Enum paint_composite_mode_t
-- | The values of this enumeration describe the compositing modes
-- that can be used when combining temporary redirected drawing
-- with the backdrop.
-- 
-- See the OpenType spec <https://learn.microsoft.com/en-us/typography/opentype/spec/colr COLR>
-- section for details.
-- 
-- /Since: 7.0.0/
data PaintCompositeModeT = 
      PaintCompositeModeTClear
    -- ^ clear destination layer (bounded)
    | PaintCompositeModeTSrc
    -- ^ replace destination layer (bounded)
    | PaintCompositeModeTDest
    -- ^ ignore the source
    | PaintCompositeModeTSrcOver
    -- ^ draw source layer on top of destination layer
    -- (bounded)
    | PaintCompositeModeTDestOver
    -- ^ draw destination on top of source
    | PaintCompositeModeTSrcIn
    -- ^ draw source where there was destination content
    -- (unbounded)
    | PaintCompositeModeTDestIn
    -- ^ leave destination only where there was
    -- source content (unbounded)
    | PaintCompositeModeTSrcOut
    -- ^ draw source where there was no destination
    -- content (unbounded)
    | PaintCompositeModeTDestOut
    -- ^ leave destination only where there was no
    -- source content
    | PaintCompositeModeTSrcAtop
    -- ^ draw source on top of destination content and
    -- only there
    | PaintCompositeModeTDestAtop
    -- ^ leave destination on top of source content
    -- and only there (unbounded)
    | PaintCompositeModeTXor
    -- ^ source and destination are shown where there is only
    -- one of them
    | PaintCompositeModeTPlus
    -- ^ source and destination layers are accumulated
    | PaintCompositeModeTScreen
    -- ^ source and destination are complemented and
    -- multiplied. This causes the result to be at least as light as the lighter
    -- inputs.
    | PaintCompositeModeTOverlay
    -- ^ multiplies or screens, depending on the
    -- lightness of the destination color.
    | PaintCompositeModeTDarken
    -- ^ replaces the destination with the source if it
    -- is darker, otherwise keeps the source.
    | PaintCompositeModeTLighten
    -- ^ replaces the destination with the source if it
    -- is lighter, otherwise keeps the source.
    | PaintCompositeModeTColorDodge
    -- ^ brightens the destination color to reflect
    -- the source color.
    | PaintCompositeModeTColorBurn
    -- ^ darkens the destination color to reflect
    -- the source color.
    | PaintCompositeModeTHardLight
    -- ^ Multiplies or screens, dependent on source
    -- color.
    | PaintCompositeModeTSoftLight
    -- ^ Darkens or lightens, dependent on source
    -- color.
    | PaintCompositeModeTDifference
    -- ^ Takes the difference of the source and
    -- destination color.
    | PaintCompositeModeTExclusion
    -- ^ Produces an effect similar to difference, but
    -- with lower contrast.
    | PaintCompositeModeTMultiply
    -- ^ source and destination layers are multiplied.
    -- This causes the result to be at least as dark as the darker inputs.
    | PaintCompositeModeTHslHue
    -- ^ Creates a color with the hue of the source
    -- and the saturation and luminosity of the target.
    | PaintCompositeModeTHslSaturation
    -- ^ Creates a color with the saturation
    -- of the source and the hue and luminosity of the target. Painting with
    -- this mode onto a gray area produces no change.
    | PaintCompositeModeTHslColor
    -- ^ Creates a color with the hue and saturation
    -- of the source and the luminosity of the target. This preserves the gray
    -- levels of the target and is useful for coloring monochrome images or
    -- tinting color images.
    | PaintCompositeModeTHslLuminosity
    -- ^ Creates a color with the luminosity of
    -- the source and the hue and saturation of the target. This produces an
    -- inverse effect to /@hBPAINTCOMPOSITEMODEHSLCOLOR@/.
    | AnotherPaintCompositeModeT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PaintCompositeModeT where
    fromEnum PaintCompositeModeTClear = 0
    fromEnum PaintCompositeModeTSrc = 1
    fromEnum PaintCompositeModeTDest = 2
    fromEnum PaintCompositeModeTSrcOver = 3
    fromEnum PaintCompositeModeTDestOver = 4
    fromEnum PaintCompositeModeTSrcIn = 5
    fromEnum PaintCompositeModeTDestIn = 6
    fromEnum PaintCompositeModeTSrcOut = 7
    fromEnum PaintCompositeModeTDestOut = 8
    fromEnum PaintCompositeModeTSrcAtop = 9
    fromEnum PaintCompositeModeTDestAtop = 10
    fromEnum PaintCompositeModeTXor = 11
    fromEnum PaintCompositeModeTPlus = 12
    fromEnum PaintCompositeModeTScreen = 13
    fromEnum PaintCompositeModeTOverlay = 14
    fromEnum PaintCompositeModeTDarken = 15
    fromEnum PaintCompositeModeTLighten = 16
    fromEnum PaintCompositeModeTColorDodge = 17
    fromEnum PaintCompositeModeTColorBurn = 18
    fromEnum PaintCompositeModeTHardLight = 19
    fromEnum PaintCompositeModeTSoftLight = 20
    fromEnum PaintCompositeModeTDifference = 21
    fromEnum PaintCompositeModeTExclusion = 22
    fromEnum PaintCompositeModeTMultiply = 23
    fromEnum PaintCompositeModeTHslHue = 24
    fromEnum PaintCompositeModeTHslSaturation = 25
    fromEnum PaintCompositeModeTHslColor = 26
    fromEnum PaintCompositeModeTHslLuminosity = 27
    fromEnum (AnotherPaintCompositeModeT k) = k

    toEnum 0 = PaintCompositeModeTClear
    toEnum 1 = PaintCompositeModeTSrc
    toEnum 2 = PaintCompositeModeTDest
    toEnum 3 = PaintCompositeModeTSrcOver
    toEnum 4 = PaintCompositeModeTDestOver
    toEnum 5 = PaintCompositeModeTSrcIn
    toEnum 6 = PaintCompositeModeTDestIn
    toEnum 7 = PaintCompositeModeTSrcOut
    toEnum 8 = PaintCompositeModeTDestOut
    toEnum 9 = PaintCompositeModeTSrcAtop
    toEnum 10 = PaintCompositeModeTDestAtop
    toEnum 11 = PaintCompositeModeTXor
    toEnum 12 = PaintCompositeModeTPlus
    toEnum 13 = PaintCompositeModeTScreen
    toEnum 14 = PaintCompositeModeTOverlay
    toEnum 15 = PaintCompositeModeTDarken
    toEnum 16 = PaintCompositeModeTLighten
    toEnum 17 = PaintCompositeModeTColorDodge
    toEnum 18 = PaintCompositeModeTColorBurn
    toEnum 19 = PaintCompositeModeTHardLight
    toEnum 20 = PaintCompositeModeTSoftLight
    toEnum 21 = PaintCompositeModeTDifference
    toEnum 22 = PaintCompositeModeTExclusion
    toEnum 23 = PaintCompositeModeTMultiply
    toEnum 24 = PaintCompositeModeTHslHue
    toEnum 25 = PaintCompositeModeTHslSaturation
    toEnum 26 = PaintCompositeModeTHslColor
    toEnum 27 = PaintCompositeModeTHslLuminosity
    toEnum k = AnotherPaintCompositeModeT k

instance P.Ord PaintCompositeModeT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PaintCompositeModeT = '[]
instance O.HasParentTypes PaintCompositeModeT

foreign import ccall "hb_gobject_paint_composite_mode_get_type" c_hb_gobject_paint_composite_mode_get_type :: 
    IO GType

instance B.Types.TypedObject PaintCompositeModeT where
    glibType = c_hb_gobject_paint_composite_mode_get_type

instance B.Types.BoxedEnum PaintCompositeModeT

-- Enum ot_name_id_predefined_t
-- | An enum type representing the pre-defined name IDs.
-- 
-- For more information on these fields, see the
-- <https://docs.microsoft.com/en-us/typography/opentype/spec/name#name-ids OpenType spec>.
-- 
-- /Since: 7.0.0/
data OtNameIdPredefinedT = 
      OtNameIdPredefinedTCopyright
    -- ^ Copyright notice
    | OtNameIdPredefinedTFontFamily
    -- ^ Font Family name
    | OtNameIdPredefinedTFontSubfamily
    -- ^ Font Subfamily name
    | OtNameIdPredefinedTUniqueId
    -- ^ Unique font identifier
    | OtNameIdPredefinedTFullName
    -- ^ Full font name that reflects
    -- all family and relevant subfamily descriptors
    | OtNameIdPredefinedTVersionString
    -- ^ Version string
    | OtNameIdPredefinedTPostscriptName
    -- ^ PostScript name for the font
    | OtNameIdPredefinedTTrademark
    -- ^ Trademark
    | OtNameIdPredefinedTManufacturer
    -- ^ Manufacturer Name
    | OtNameIdPredefinedTDesigner
    -- ^ Designer
    | OtNameIdPredefinedTDescription
    -- ^ Description
    | OtNameIdPredefinedTVendorUrl
    -- ^ URL of font vendor
    | OtNameIdPredefinedTDesignerUrl
    -- ^ URL of typeface designer
    | OtNameIdPredefinedTLicense
    -- ^ License Description
    | OtNameIdPredefinedTLicenseUrl
    -- ^ URL where additional licensing
    -- information can be found
    | OtNameIdPredefinedTTypographicFamily
    -- ^ Typographic Family name
    | OtNameIdPredefinedTTypographicSubfamily
    -- ^ Typographic Subfamily name
    | OtNameIdPredefinedTMacFullName
    -- ^ Compatible Full Name for MacOS
    | OtNameIdPredefinedTSampleText
    -- ^ Sample text
    | OtNameIdPredefinedTCidFindfontName
    -- ^ PostScript CID findfont name
    | OtNameIdPredefinedTWwsFamily
    -- ^ WWS Family Name
    | OtNameIdPredefinedTWwsSubfamily
    -- ^ WWS Subfamily Name
    | OtNameIdPredefinedTLightBackground
    -- ^ Light Background Palette
    | OtNameIdPredefinedTDarkBackground
    -- ^ Dark Background Palette
    | OtNameIdPredefinedTVariationsPsPrefix
    -- ^ Variations PostScript Name Prefix
    | OtNameIdPredefinedTInvalid
    -- ^ Value to represent a nonexistent name ID.
    | AnotherOtNameIdPredefinedT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtNameIdPredefinedT where
    fromEnum OtNameIdPredefinedTCopyright = 0
    fromEnum OtNameIdPredefinedTFontFamily = 1
    fromEnum OtNameIdPredefinedTFontSubfamily = 2
    fromEnum OtNameIdPredefinedTUniqueId = 3
    fromEnum OtNameIdPredefinedTFullName = 4
    fromEnum OtNameIdPredefinedTVersionString = 5
    fromEnum OtNameIdPredefinedTPostscriptName = 6
    fromEnum OtNameIdPredefinedTTrademark = 7
    fromEnum OtNameIdPredefinedTManufacturer = 8
    fromEnum OtNameIdPredefinedTDesigner = 9
    fromEnum OtNameIdPredefinedTDescription = 10
    fromEnum OtNameIdPredefinedTVendorUrl = 11
    fromEnum OtNameIdPredefinedTDesignerUrl = 12
    fromEnum OtNameIdPredefinedTLicense = 13
    fromEnum OtNameIdPredefinedTLicenseUrl = 14
    fromEnum OtNameIdPredefinedTTypographicFamily = 16
    fromEnum OtNameIdPredefinedTTypographicSubfamily = 17
    fromEnum OtNameIdPredefinedTMacFullName = 18
    fromEnum OtNameIdPredefinedTSampleText = 19
    fromEnum OtNameIdPredefinedTCidFindfontName = 20
    fromEnum OtNameIdPredefinedTWwsFamily = 21
    fromEnum OtNameIdPredefinedTWwsSubfamily = 22
    fromEnum OtNameIdPredefinedTLightBackground = 23
    fromEnum OtNameIdPredefinedTDarkBackground = 24
    fromEnum OtNameIdPredefinedTVariationsPsPrefix = 25
    fromEnum OtNameIdPredefinedTInvalid = 65535
    fromEnum (AnotherOtNameIdPredefinedT k) = k

    toEnum 0 = OtNameIdPredefinedTCopyright
    toEnum 1 = OtNameIdPredefinedTFontFamily
    toEnum 2 = OtNameIdPredefinedTFontSubfamily
    toEnum 3 = OtNameIdPredefinedTUniqueId
    toEnum 4 = OtNameIdPredefinedTFullName
    toEnum 5 = OtNameIdPredefinedTVersionString
    toEnum 6 = OtNameIdPredefinedTPostscriptName
    toEnum 7 = OtNameIdPredefinedTTrademark
    toEnum 8 = OtNameIdPredefinedTManufacturer
    toEnum 9 = OtNameIdPredefinedTDesigner
    toEnum 10 = OtNameIdPredefinedTDescription
    toEnum 11 = OtNameIdPredefinedTVendorUrl
    toEnum 12 = OtNameIdPredefinedTDesignerUrl
    toEnum 13 = OtNameIdPredefinedTLicense
    toEnum 14 = OtNameIdPredefinedTLicenseUrl
    toEnum 16 = OtNameIdPredefinedTTypographicFamily
    toEnum 17 = OtNameIdPredefinedTTypographicSubfamily
    toEnum 18 = OtNameIdPredefinedTMacFullName
    toEnum 19 = OtNameIdPredefinedTSampleText
    toEnum 20 = OtNameIdPredefinedTCidFindfontName
    toEnum 21 = OtNameIdPredefinedTWwsFamily
    toEnum 22 = OtNameIdPredefinedTWwsSubfamily
    toEnum 23 = OtNameIdPredefinedTLightBackground
    toEnum 24 = OtNameIdPredefinedTDarkBackground
    toEnum 25 = OtNameIdPredefinedTVariationsPsPrefix
    toEnum 65535 = OtNameIdPredefinedTInvalid
    toEnum k = AnotherOtNameIdPredefinedT k

instance P.Ord OtNameIdPredefinedT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtNameIdPredefinedT = '[]
instance O.HasParentTypes OtNameIdPredefinedT

foreign import ccall "hb_gobject_ot_name_id_predefined_get_type" c_hb_gobject_ot_name_id_predefined_get_type :: 
    IO GType

instance B.Types.TypedObject OtNameIdPredefinedT where
    glibType = c_hb_gobject_ot_name_id_predefined_get_type

instance B.Types.BoxedEnum OtNameIdPredefinedT

-- Enum ot_metrics_tag_t
-- | Metric tags corresponding to <https://docs.microsoft.com/en-us/typography/opentype/spec/mvar#value-tags MVAR Value
-- Tags>
-- 
-- /Since: 2.6.0/
data OtMetricsTagT = 
      OtMetricsTagTHorizontalAscender
    -- ^ horizontal ascender.
    | OtMetricsTagTHorizontalDescender
    -- ^ horizontal descender.
    | OtMetricsTagTHorizontalLineGap
    -- ^ horizontal line gap.
    | OtMetricsTagTHorizontalClippingAscent
    -- ^ horizontal clipping ascent.
    | OtMetricsTagTHorizontalClippingDescent
    -- ^ horizontal clipping descent.
    | OtMetricsTagTVerticalAscender
    -- ^ vertical ascender.
    | OtMetricsTagTVerticalDescender
    -- ^ vertical descender.
    | OtMetricsTagTVerticalLineGap
    -- ^ vertical line gap.
    | OtMetricsTagTHorizontalCaretRise
    -- ^ horizontal caret rise.
    | OtMetricsTagTHorizontalCaretRun
    -- ^ horizontal caret run.
    | OtMetricsTagTHorizontalCaretOffset
    -- ^ horizontal caret offset.
    | OtMetricsTagTVerticalCaretRise
    -- ^ vertical caret rise.
    | OtMetricsTagTVerticalCaretRun
    -- ^ vertical caret run.
    | OtMetricsTagTVerticalCaretOffset
    -- ^ vertical caret offset.
    | OtMetricsTagTXHeight
    -- ^ x height.
    | OtMetricsTagTCapHeight
    -- ^ cap height.
    | OtMetricsTagTSubscriptEmXSize
    -- ^ subscript em x size.
    | OtMetricsTagTSubscriptEmYSize
    -- ^ subscript em y size.
    | OtMetricsTagTSubscriptEmXOffset
    -- ^ subscript em x offset.
    | OtMetricsTagTSubscriptEmYOffset
    -- ^ subscript em y offset.
    | OtMetricsTagTSuperscriptEmXSize
    -- ^ superscript em x size.
    | OtMetricsTagTSuperscriptEmYSize
    -- ^ superscript em y size.
    | OtMetricsTagTSuperscriptEmXOffset
    -- ^ superscript em x offset.
    | OtMetricsTagTSuperscriptEmYOffset
    -- ^ superscript em y offset.
    | OtMetricsTagTStrikeoutSize
    -- ^ strikeout size.
    | OtMetricsTagTStrikeoutOffset
    -- ^ strikeout offset.
    | OtMetricsTagTUnderlineSize
    -- ^ underline size.
    | OtMetricsTagTUnderlineOffset
    -- ^ underline offset.
    | AnotherOtMetricsTagT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtMetricsTagT where
    fromEnum OtMetricsTagTHorizontalAscender = 1751216995
    fromEnum OtMetricsTagTHorizontalDescender = 1751413603
    fromEnum OtMetricsTagTHorizontalLineGap = 1751934832
    fromEnum OtMetricsTagTHorizontalClippingAscent = 1751346273
    fromEnum OtMetricsTagTHorizontalClippingDescent = 1751346276
    fromEnum OtMetricsTagTVerticalAscender = 1986098019
    fromEnum OtMetricsTagTVerticalDescender = 1986294627
    fromEnum OtMetricsTagTVerticalLineGap = 1986815856
    fromEnum OtMetricsTagTHorizontalCaretRise = 1751347827
    fromEnum OtMetricsTagTHorizontalCaretRun = 1751347822
    fromEnum OtMetricsTagTHorizontalCaretOffset = 1751347046
    fromEnum OtMetricsTagTVerticalCaretRise = 1986228851
    fromEnum OtMetricsTagTVerticalCaretRun = 1986228846
    fromEnum OtMetricsTagTVerticalCaretOffset = 1986228070
    fromEnum OtMetricsTagTXHeight = 2020108148
    fromEnum OtMetricsTagTCapHeight = 1668311156
    fromEnum OtMetricsTagTSubscriptEmXSize = 1935833203
    fromEnum OtMetricsTagTSubscriptEmYSize = 1935833459
    fromEnum OtMetricsTagTSubscriptEmXOffset = 1935833199
    fromEnum OtMetricsTagTSubscriptEmYOffset = 1935833455
    fromEnum OtMetricsTagTSuperscriptEmXSize = 1936750707
    fromEnum OtMetricsTagTSuperscriptEmYSize = 1936750963
    fromEnum OtMetricsTagTSuperscriptEmXOffset = 1936750703
    fromEnum OtMetricsTagTSuperscriptEmYOffset = 1936750959
    fromEnum OtMetricsTagTStrikeoutSize = 1937011315
    fromEnum OtMetricsTagTStrikeoutOffset = 1937011311
    fromEnum OtMetricsTagTUnderlineSize = 1970168947
    fromEnum OtMetricsTagTUnderlineOffset = 1970168943
    fromEnum (AnotherOtMetricsTagT k) = k

    toEnum 1751216995 = OtMetricsTagTHorizontalAscender
    toEnum 1751413603 = OtMetricsTagTHorizontalDescender
    toEnum 1751934832 = OtMetricsTagTHorizontalLineGap
    toEnum 1751346273 = OtMetricsTagTHorizontalClippingAscent
    toEnum 1751346276 = OtMetricsTagTHorizontalClippingDescent
    toEnum 1986098019 = OtMetricsTagTVerticalAscender
    toEnum 1986294627 = OtMetricsTagTVerticalDescender
    toEnum 1986815856 = OtMetricsTagTVerticalLineGap
    toEnum 1751347827 = OtMetricsTagTHorizontalCaretRise
    toEnum 1751347822 = OtMetricsTagTHorizontalCaretRun
    toEnum 1751347046 = OtMetricsTagTHorizontalCaretOffset
    toEnum 1986228851 = OtMetricsTagTVerticalCaretRise
    toEnum 1986228846 = OtMetricsTagTVerticalCaretRun
    toEnum 1986228070 = OtMetricsTagTVerticalCaretOffset
    toEnum 2020108148 = OtMetricsTagTXHeight
    toEnum 1668311156 = OtMetricsTagTCapHeight
    toEnum 1935833203 = OtMetricsTagTSubscriptEmXSize
    toEnum 1935833459 = OtMetricsTagTSubscriptEmYSize
    toEnum 1935833199 = OtMetricsTagTSubscriptEmXOffset
    toEnum 1935833455 = OtMetricsTagTSubscriptEmYOffset
    toEnum 1936750707 = OtMetricsTagTSuperscriptEmXSize
    toEnum 1936750963 = OtMetricsTagTSuperscriptEmYSize
    toEnum 1936750703 = OtMetricsTagTSuperscriptEmXOffset
    toEnum 1936750959 = OtMetricsTagTSuperscriptEmYOffset
    toEnum 1937011315 = OtMetricsTagTStrikeoutSize
    toEnum 1937011311 = OtMetricsTagTStrikeoutOffset
    toEnum 1970168947 = OtMetricsTagTUnderlineSize
    toEnum 1970168943 = OtMetricsTagTUnderlineOffset
    toEnum k = AnotherOtMetricsTagT k

instance P.Ord OtMetricsTagT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtMetricsTagT = '[]
instance O.HasParentTypes OtMetricsTagT

foreign import ccall "hb_gobject_ot_metrics_tag_get_type" c_hb_gobject_ot_metrics_tag_get_type :: 
    IO GType

instance B.Types.TypedObject OtMetricsTagT where
    glibType = c_hb_gobject_ot_metrics_tag_get_type

instance B.Types.BoxedEnum OtMetricsTagT

-- Enum ot_meta_tag_t
-- | Known metadata tags from https:\/\/docs.microsoft.com\/en-us\/typography\/opentype\/spec\/meta
-- 
-- /Since: 2.6.0/
data OtMetaTagT = 
      OtMetaTagTDesignLanguages
    -- ^ Design languages. Text, using only
    -- Basic Latin (ASCII) characters. Indicates languages and\/or scripts
    -- for the user audiences that the font was primarily designed for.
    | OtMetaTagTSupportedLanguages
    -- ^ Supported languages. Text, using
    -- only Basic Latin (ASCII) characters. Indicates languages and\/or scripts
    -- that the font is declared to be capable of supporting.
    | AnotherOtMetaTagT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtMetaTagT where
    fromEnum OtMetaTagTDesignLanguages = 1684827751
    fromEnum OtMetaTagTSupportedLanguages = 1936485991
    fromEnum (AnotherOtMetaTagT k) = k

    toEnum 1684827751 = OtMetaTagTDesignLanguages
    toEnum 1936485991 = OtMetaTagTSupportedLanguages
    toEnum k = AnotherOtMetaTagT k

instance P.Ord OtMetaTagT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtMetaTagT = '[]
instance O.HasParentTypes OtMetaTagT

foreign import ccall "hb_gobject_ot_meta_tag_get_type" c_hb_gobject_ot_meta_tag_get_type :: 
    IO GType

instance B.Types.TypedObject OtMetaTagT where
    glibType = c_hb_gobject_ot_meta_tag_get_type

instance B.Types.BoxedEnum OtMetaTagT

-- Enum ot_math_kern_t
-- | The math kerning-table types defined for the four corners
-- of a glyph.
-- 
-- /Since: 1.3.3/
data OtMathKernT = 
      OtMathKernTTopRight
    -- ^ The top right corner of the glyph.
    | OtMathKernTTopLeft
    -- ^ The top left corner of the glyph.
    | OtMathKernTBottomRight
    -- ^ The bottom right corner of the glyph.
    | OtMathKernTBottomLeft
    -- ^ The bottom left corner of the glyph.
    | AnotherOtMathKernT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtMathKernT where
    fromEnum OtMathKernTTopRight = 0
    fromEnum OtMathKernTTopLeft = 1
    fromEnum OtMathKernTBottomRight = 2
    fromEnum OtMathKernTBottomLeft = 3
    fromEnum (AnotherOtMathKernT k) = k

    toEnum 0 = OtMathKernTTopRight
    toEnum 1 = OtMathKernTTopLeft
    toEnum 2 = OtMathKernTBottomRight
    toEnum 3 = OtMathKernTBottomLeft
    toEnum k = AnotherOtMathKernT k

instance P.Ord OtMathKernT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtMathKernT = '[]
instance O.HasParentTypes OtMathKernT

foreign import ccall "hb_gobject_ot_math_kern_get_type" c_hb_gobject_ot_math_kern_get_type :: 
    IO GType

instance B.Types.TypedObject OtMathKernT where
    glibType = c_hb_gobject_ot_math_kern_get_type

instance B.Types.BoxedEnum OtMathKernT

-- Enum ot_math_constant_t
-- | The \'MATH\' table constants, refer to
-- <https://docs.microsoft.com/en-us/typography/opentype/spec/math#mathconstants-table OpenType documentation>
-- For more explanations.
-- 
-- /Since: 1.3.3/
data OtMathConstantT = 
      OtMathConstantTScriptPercentScaleDown
    -- ^ scriptPercentScaleDown
    | OtMathConstantTScriptScriptPercentScaleDown
    -- ^ scriptScriptPercentScaleDown
    | OtMathConstantTDelimitedSubFormulaMinHeight
    -- ^ delimitedSubFormulaMinHeight
    | OtMathConstantTDisplayOperatorMinHeight
    -- ^ displayOperatorMinHeight
    | OtMathConstantTMathLeading
    -- ^ mathLeading
    | OtMathConstantTAxisHeight
    -- ^ axisHeight
    | OtMathConstantTAccentBaseHeight
    -- ^ accentBaseHeight
    | OtMathConstantTFlattenedAccentBaseHeight
    -- ^ flattenedAccentBaseHeight
    | OtMathConstantTSubscriptShiftDown
    -- ^ subscriptShiftDown
    | OtMathConstantTSubscriptTopMax
    -- ^ subscriptTopMax
    | OtMathConstantTSubscriptBaselineDropMin
    -- ^ subscriptBaselineDropMin
    | OtMathConstantTSuperscriptShiftUp
    -- ^ superscriptShiftUp
    | OtMathConstantTSuperscriptShiftUpCramped
    -- ^ superscriptShiftUpCramped
    | OtMathConstantTSuperscriptBottomMin
    -- ^ superscriptBottomMin
    | OtMathConstantTSuperscriptBaselineDropMax
    -- ^ superscriptBaselineDropMax
    | OtMathConstantTSubSuperscriptGapMin
    -- ^ subSuperscriptGapMin
    | OtMathConstantTSuperscriptBottomMaxWithSubscript
    -- ^ superscriptBottomMaxWithSubscript
    | OtMathConstantTSpaceAfterScript
    -- ^ spaceAfterScript
    | OtMathConstantTUpperLimitGapMin
    -- ^ upperLimitGapMin
    | OtMathConstantTUpperLimitBaselineRiseMin
    -- ^ upperLimitBaselineRiseMin
    | OtMathConstantTLowerLimitGapMin
    -- ^ lowerLimitGapMin
    | OtMathConstantTLowerLimitBaselineDropMin
    -- ^ lowerLimitBaselineDropMin
    | OtMathConstantTStackTopShiftUp
    -- ^ stackTopShiftUp
    | OtMathConstantTStackTopDisplayStyleShiftUp
    -- ^ stackTopDisplayStyleShiftUp
    | OtMathConstantTStackBottomShiftDown
    -- ^ stackBottomShiftDown
    | OtMathConstantTStackBottomDisplayStyleShiftDown
    -- ^ stackBottomDisplayStyleShiftDown
    | OtMathConstantTStackGapMin
    -- ^ stackGapMin
    | OtMathConstantTStackDisplayStyleGapMin
    -- ^ stackDisplayStyleGapMin
    | OtMathConstantTStretchStackTopShiftUp
    -- ^ stretchStackTopShiftUp
    | OtMathConstantTStretchStackBottomShiftDown
    -- ^ stretchStackBottomShiftDown
    | OtMathConstantTStretchStackGapAboveMin
    -- ^ stretchStackGapAboveMin
    | OtMathConstantTStretchStackGapBelowMin
    -- ^ stretchStackGapBelowMin
    | OtMathConstantTFractionNumeratorShiftUp
    -- ^ fractionNumeratorShiftUp
    | OtMathConstantTFractionNumeratorDisplayStyleShiftUp
    -- ^ fractionNumeratorDisplayStyleShiftUp
    | OtMathConstantTFractionDenominatorShiftDown
    -- ^ fractionDenominatorShiftDown
    | OtMathConstantTFractionDenominatorDisplayStyleShiftDown
    -- ^ fractionDenominatorDisplayStyleShiftDown
    | OtMathConstantTFractionNumeratorGapMin
    -- ^ fractionNumeratorGapMin
    | OtMathConstantTFractionNumDisplayStyleGapMin
    -- ^ fractionNumDisplayStyleGapMin
    | OtMathConstantTFractionRuleThickness
    -- ^ fractionRuleThickness
    | OtMathConstantTFractionDenominatorGapMin
    -- ^ fractionDenominatorGapMin
    | OtMathConstantTFractionDenomDisplayStyleGapMin
    -- ^ fractionDenomDisplayStyleGapMin
    | OtMathConstantTSkewedFractionHorizontalGap
    -- ^ skewedFractionHorizontalGap
    | OtMathConstantTSkewedFractionVerticalGap
    -- ^ skewedFractionVerticalGap
    | OtMathConstantTOverbarVerticalGap
    -- ^ overbarVerticalGap
    | OtMathConstantTOverbarRuleThickness
    -- ^ overbarRuleThickness
    | OtMathConstantTOverbarExtraAscender
    -- ^ overbarExtraAscender
    | OtMathConstantTUnderbarVerticalGap
    -- ^ underbarVerticalGap
    | OtMathConstantTUnderbarRuleThickness
    -- ^ underbarRuleThickness
    | OtMathConstantTUnderbarExtraDescender
    -- ^ underbarExtraDescender
    | OtMathConstantTRadicalVerticalGap
    -- ^ radicalVerticalGap
    | OtMathConstantTRadicalDisplayStyleVerticalGap
    -- ^ radicalDisplayStyleVerticalGap
    | OtMathConstantTRadicalRuleThickness
    -- ^ radicalRuleThickness
    | OtMathConstantTRadicalExtraAscender
    -- ^ radicalExtraAscender
    | OtMathConstantTRadicalKernBeforeDegree
    -- ^ radicalKernBeforeDegree
    | OtMathConstantTRadicalKernAfterDegree
    -- ^ radicalKernAfterDegree
    | OtMathConstantTRadicalDegreeBottomRaisePercent
    -- ^ radicalDegreeBottomRaisePercent
    | AnotherOtMathConstantT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtMathConstantT where
    fromEnum OtMathConstantTScriptPercentScaleDown = 0
    fromEnum OtMathConstantTScriptScriptPercentScaleDown = 1
    fromEnum OtMathConstantTDelimitedSubFormulaMinHeight = 2
    fromEnum OtMathConstantTDisplayOperatorMinHeight = 3
    fromEnum OtMathConstantTMathLeading = 4
    fromEnum OtMathConstantTAxisHeight = 5
    fromEnum OtMathConstantTAccentBaseHeight = 6
    fromEnum OtMathConstantTFlattenedAccentBaseHeight = 7
    fromEnum OtMathConstantTSubscriptShiftDown = 8
    fromEnum OtMathConstantTSubscriptTopMax = 9
    fromEnum OtMathConstantTSubscriptBaselineDropMin = 10
    fromEnum OtMathConstantTSuperscriptShiftUp = 11
    fromEnum OtMathConstantTSuperscriptShiftUpCramped = 12
    fromEnum OtMathConstantTSuperscriptBottomMin = 13
    fromEnum OtMathConstantTSuperscriptBaselineDropMax = 14
    fromEnum OtMathConstantTSubSuperscriptGapMin = 15
    fromEnum OtMathConstantTSuperscriptBottomMaxWithSubscript = 16
    fromEnum OtMathConstantTSpaceAfterScript = 17
    fromEnum OtMathConstantTUpperLimitGapMin = 18
    fromEnum OtMathConstantTUpperLimitBaselineRiseMin = 19
    fromEnum OtMathConstantTLowerLimitGapMin = 20
    fromEnum OtMathConstantTLowerLimitBaselineDropMin = 21
    fromEnum OtMathConstantTStackTopShiftUp = 22
    fromEnum OtMathConstantTStackTopDisplayStyleShiftUp = 23
    fromEnum OtMathConstantTStackBottomShiftDown = 24
    fromEnum OtMathConstantTStackBottomDisplayStyleShiftDown = 25
    fromEnum OtMathConstantTStackGapMin = 26
    fromEnum OtMathConstantTStackDisplayStyleGapMin = 27
    fromEnum OtMathConstantTStretchStackTopShiftUp = 28
    fromEnum OtMathConstantTStretchStackBottomShiftDown = 29
    fromEnum OtMathConstantTStretchStackGapAboveMin = 30
    fromEnum OtMathConstantTStretchStackGapBelowMin = 31
    fromEnum OtMathConstantTFractionNumeratorShiftUp = 32
    fromEnum OtMathConstantTFractionNumeratorDisplayStyleShiftUp = 33
    fromEnum OtMathConstantTFractionDenominatorShiftDown = 34
    fromEnum OtMathConstantTFractionDenominatorDisplayStyleShiftDown = 35
    fromEnum OtMathConstantTFractionNumeratorGapMin = 36
    fromEnum OtMathConstantTFractionNumDisplayStyleGapMin = 37
    fromEnum OtMathConstantTFractionRuleThickness = 38
    fromEnum OtMathConstantTFractionDenominatorGapMin = 39
    fromEnum OtMathConstantTFractionDenomDisplayStyleGapMin = 40
    fromEnum OtMathConstantTSkewedFractionHorizontalGap = 41
    fromEnum OtMathConstantTSkewedFractionVerticalGap = 42
    fromEnum OtMathConstantTOverbarVerticalGap = 43
    fromEnum OtMathConstantTOverbarRuleThickness = 44
    fromEnum OtMathConstantTOverbarExtraAscender = 45
    fromEnum OtMathConstantTUnderbarVerticalGap = 46
    fromEnum OtMathConstantTUnderbarRuleThickness = 47
    fromEnum OtMathConstantTUnderbarExtraDescender = 48
    fromEnum OtMathConstantTRadicalVerticalGap = 49
    fromEnum OtMathConstantTRadicalDisplayStyleVerticalGap = 50
    fromEnum OtMathConstantTRadicalRuleThickness = 51
    fromEnum OtMathConstantTRadicalExtraAscender = 52
    fromEnum OtMathConstantTRadicalKernBeforeDegree = 53
    fromEnum OtMathConstantTRadicalKernAfterDegree = 54
    fromEnum OtMathConstantTRadicalDegreeBottomRaisePercent = 55
    fromEnum (AnotherOtMathConstantT k) = k

    toEnum 0 = OtMathConstantTScriptPercentScaleDown
    toEnum 1 = OtMathConstantTScriptScriptPercentScaleDown
    toEnum 2 = OtMathConstantTDelimitedSubFormulaMinHeight
    toEnum 3 = OtMathConstantTDisplayOperatorMinHeight
    toEnum 4 = OtMathConstantTMathLeading
    toEnum 5 = OtMathConstantTAxisHeight
    toEnum 6 = OtMathConstantTAccentBaseHeight
    toEnum 7 = OtMathConstantTFlattenedAccentBaseHeight
    toEnum 8 = OtMathConstantTSubscriptShiftDown
    toEnum 9 = OtMathConstantTSubscriptTopMax
    toEnum 10 = OtMathConstantTSubscriptBaselineDropMin
    toEnum 11 = OtMathConstantTSuperscriptShiftUp
    toEnum 12 = OtMathConstantTSuperscriptShiftUpCramped
    toEnum 13 = OtMathConstantTSuperscriptBottomMin
    toEnum 14 = OtMathConstantTSuperscriptBaselineDropMax
    toEnum 15 = OtMathConstantTSubSuperscriptGapMin
    toEnum 16 = OtMathConstantTSuperscriptBottomMaxWithSubscript
    toEnum 17 = OtMathConstantTSpaceAfterScript
    toEnum 18 = OtMathConstantTUpperLimitGapMin
    toEnum 19 = OtMathConstantTUpperLimitBaselineRiseMin
    toEnum 20 = OtMathConstantTLowerLimitGapMin
    toEnum 21 = OtMathConstantTLowerLimitBaselineDropMin
    toEnum 22 = OtMathConstantTStackTopShiftUp
    toEnum 23 = OtMathConstantTStackTopDisplayStyleShiftUp
    toEnum 24 = OtMathConstantTStackBottomShiftDown
    toEnum 25 = OtMathConstantTStackBottomDisplayStyleShiftDown
    toEnum 26 = OtMathConstantTStackGapMin
    toEnum 27 = OtMathConstantTStackDisplayStyleGapMin
    toEnum 28 = OtMathConstantTStretchStackTopShiftUp
    toEnum 29 = OtMathConstantTStretchStackBottomShiftDown
    toEnum 30 = OtMathConstantTStretchStackGapAboveMin
    toEnum 31 = OtMathConstantTStretchStackGapBelowMin
    toEnum 32 = OtMathConstantTFractionNumeratorShiftUp
    toEnum 33 = OtMathConstantTFractionNumeratorDisplayStyleShiftUp
    toEnum 34 = OtMathConstantTFractionDenominatorShiftDown
    toEnum 35 = OtMathConstantTFractionDenominatorDisplayStyleShiftDown
    toEnum 36 = OtMathConstantTFractionNumeratorGapMin
    toEnum 37 = OtMathConstantTFractionNumDisplayStyleGapMin
    toEnum 38 = OtMathConstantTFractionRuleThickness
    toEnum 39 = OtMathConstantTFractionDenominatorGapMin
    toEnum 40 = OtMathConstantTFractionDenomDisplayStyleGapMin
    toEnum 41 = OtMathConstantTSkewedFractionHorizontalGap
    toEnum 42 = OtMathConstantTSkewedFractionVerticalGap
    toEnum 43 = OtMathConstantTOverbarVerticalGap
    toEnum 44 = OtMathConstantTOverbarRuleThickness
    toEnum 45 = OtMathConstantTOverbarExtraAscender
    toEnum 46 = OtMathConstantTUnderbarVerticalGap
    toEnum 47 = OtMathConstantTUnderbarRuleThickness
    toEnum 48 = OtMathConstantTUnderbarExtraDescender
    toEnum 49 = OtMathConstantTRadicalVerticalGap
    toEnum 50 = OtMathConstantTRadicalDisplayStyleVerticalGap
    toEnum 51 = OtMathConstantTRadicalRuleThickness
    toEnum 52 = OtMathConstantTRadicalExtraAscender
    toEnum 53 = OtMathConstantTRadicalKernBeforeDegree
    toEnum 54 = OtMathConstantTRadicalKernAfterDegree
    toEnum 55 = OtMathConstantTRadicalDegreeBottomRaisePercent
    toEnum k = AnotherOtMathConstantT k

instance P.Ord OtMathConstantT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtMathConstantT = '[]
instance O.HasParentTypes OtMathConstantT

foreign import ccall "hb_gobject_ot_math_constant_get_type" c_hb_gobject_ot_math_constant_get_type :: 
    IO GType

instance B.Types.TypedObject OtMathConstantT where
    glibType = c_hb_gobject_ot_math_constant_get_type

instance B.Types.BoxedEnum OtMathConstantT

-- Enum ot_layout_glyph_class_t
-- | The GDEF classes defined for glyphs.
data OtLayoutGlyphClassT = 
      OtLayoutGlyphClassTUnclassified
    -- ^ Glyphs not matching the other classifications
    | OtLayoutGlyphClassTBaseGlyph
    -- ^ Spacing, single characters, capable of accepting marks
    | OtLayoutGlyphClassTLigature
    -- ^ Glyphs that represent ligation of multiple characters
    | OtLayoutGlyphClassTMark
    -- ^ Non-spacing, combining glyphs that represent marks
    | OtLayoutGlyphClassTComponent
    -- ^ Spacing glyphs that represent part of a single character
    | AnotherOtLayoutGlyphClassT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtLayoutGlyphClassT where
    fromEnum OtLayoutGlyphClassTUnclassified = 0
    fromEnum OtLayoutGlyphClassTBaseGlyph = 1
    fromEnum OtLayoutGlyphClassTLigature = 2
    fromEnum OtLayoutGlyphClassTMark = 3
    fromEnum OtLayoutGlyphClassTComponent = 4
    fromEnum (AnotherOtLayoutGlyphClassT k) = k

    toEnum 0 = OtLayoutGlyphClassTUnclassified
    toEnum 1 = OtLayoutGlyphClassTBaseGlyph
    toEnum 2 = OtLayoutGlyphClassTLigature
    toEnum 3 = OtLayoutGlyphClassTMark
    toEnum 4 = OtLayoutGlyphClassTComponent
    toEnum k = AnotherOtLayoutGlyphClassT k

instance P.Ord OtLayoutGlyphClassT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtLayoutGlyphClassT = '[]
instance O.HasParentTypes OtLayoutGlyphClassT

foreign import ccall "hb_gobject_ot_layout_glyph_class_get_type" c_hb_gobject_ot_layout_glyph_class_get_type :: 
    IO GType

instance B.Types.TypedObject OtLayoutGlyphClassT where
    glibType = c_hb_gobject_ot_layout_glyph_class_get_type

instance B.Types.BoxedEnum OtLayoutGlyphClassT

-- Enum ot_layout_baseline_tag_t
-- | Baseline tags from <https://docs.microsoft.com/en-us/typography/opentype/spec/baselinetags Baseline Tags> registry.
-- 
-- /Since: 2.6.0/
data OtLayoutBaselineTagT = 
      OtLayoutBaselineTagTRoman
    -- ^ The baseline used by alphabetic scripts such as Latin, Cyrillic and Greek.
    -- In vertical writing mode, the alphabetic baseline for characters rotated 90 degrees clockwise.
    -- (This would not apply to alphabetic characters that remain upright in vertical writing mode, since these
    -- characters are not rotated.)
    | OtLayoutBaselineTagTHanging
    -- ^ The hanging baseline. In horizontal direction, this is the horizontal
    -- line from which syllables seem, to hang in Tibetan and other similar scripts. In vertical writing mode,
    -- for Tibetan (or some other similar script) characters rotated 90 degrees clockwise.
    | OtLayoutBaselineTagTIdeoFaceBottomOrLeft
    -- ^ Ideographic character face bottom or left edge,
    -- if the direction is horizontal or vertical, respectively.
    | OtLayoutBaselineTagTIdeoFaceTopOrRight
    -- ^ Ideographic character face top or right edge,
    -- if the direction is horizontal or vertical, respectively.
    | OtLayoutBaselineTagTIdeoFaceCentral
    -- ^ The center of the ideographic character face. Since: 4.0.0
    | OtLayoutBaselineTagTIdeoEmboxBottomOrLeft
    -- ^ Ideographic em-box bottom or left edge,
    -- if the direction is horizontal or vertical, respectively.
    | OtLayoutBaselineTagTIdeoEmboxTopOrRight
    -- ^ Ideographic em-box top or right edge baseline,
    | OtLayoutBaselineTagTIdeoEmboxCentral
    -- ^ The center of the ideographic em-box. Since: 4.0.0
    -- if the direction is horizontal or vertical, respectively.
    | OtLayoutBaselineTagTMath
    -- ^ The baseline about which mathematical characters are centered.
    -- In vertical writing mode when mathematical characters rotated 90 degrees clockwise, are centered.
    | AnotherOtLayoutBaselineTagT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OtLayoutBaselineTagT where
    fromEnum OtLayoutBaselineTagTRoman = 1919905134
    fromEnum OtLayoutBaselineTagTHanging = 1751215719
    fromEnum OtLayoutBaselineTagTIdeoFaceBottomOrLeft = 1768121954
    fromEnum OtLayoutBaselineTagTIdeoFaceTopOrRight = 1768121972
    fromEnum OtLayoutBaselineTagTIdeoFaceCentral = 1231251043
    fromEnum OtLayoutBaselineTagTIdeoEmboxBottomOrLeft = 1768187247
    fromEnum OtLayoutBaselineTagTIdeoEmboxTopOrRight = 1768191088
    fromEnum OtLayoutBaselineTagTIdeoEmboxCentral = 1231315813
    fromEnum OtLayoutBaselineTagTMath = 1835103336
    fromEnum (AnotherOtLayoutBaselineTagT k) = k

    toEnum 1919905134 = OtLayoutBaselineTagTRoman
    toEnum 1751215719 = OtLayoutBaselineTagTHanging
    toEnum 1768121954 = OtLayoutBaselineTagTIdeoFaceBottomOrLeft
    toEnum 1768121972 = OtLayoutBaselineTagTIdeoFaceTopOrRight
    toEnum 1231251043 = OtLayoutBaselineTagTIdeoFaceCentral
    toEnum 1768187247 = OtLayoutBaselineTagTIdeoEmboxBottomOrLeft
    toEnum 1768191088 = OtLayoutBaselineTagTIdeoEmboxTopOrRight
    toEnum 1231315813 = OtLayoutBaselineTagTIdeoEmboxCentral
    toEnum 1835103336 = OtLayoutBaselineTagTMath
    toEnum k = AnotherOtLayoutBaselineTagT k

instance P.Ord OtLayoutBaselineTagT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OtLayoutBaselineTagT = '[]
instance O.HasParentTypes OtLayoutBaselineTagT

foreign import ccall "hb_gobject_ot_layout_baseline_tag_get_type" c_hb_gobject_ot_layout_baseline_tag_get_type :: 
    IO GType

instance B.Types.TypedObject OtLayoutBaselineTagT where
    glibType = c_hb_gobject_ot_layout_baseline_tag_get_type

instance B.Types.BoxedEnum OtLayoutBaselineTagT

-- Enum memory_mode_t
-- | Data type holding the memory modes available to
-- client programs.
-- 
-- Regarding these various memory-modes:
-- 
-- * In no case shall the HarfBuzz client modify memory
--   that is passed to HarfBuzz in a blob.  If there is
--   any such possibility, /@hBMEMORYMODEDUPLICATE@/ should be used
--   such that HarfBuzz makes a copy immediately,
-- * Use /@hBMEMORYMODEREADONLY@/ otherwise, unless you really really
--   really know what you are doing,
-- * /@hBMEMORYMODEWRITABLE@/ is appropriate if you really made a
--   copy of data solely for the purpose of passing to
--   HarfBuzz and doing that just once (no reuse!),
-- * If the font is @/mmap()/@ed, it\'s okay to use
--   /@hBMEMORYMODEREADONLYMAYMAKEWRITABLE@/, however, using that mode
--   correctly is very tricky.  Use /@hBMEMORYMODEREADONLY@/ instead.
data MemoryModeT = 
      MemoryModeTDuplicate
    -- ^ HarfBuzz immediately makes a copy of the data.
    | MemoryModeTReadonly
    -- ^ HarfBuzz client will never modify the data,
    --     and HarfBuzz will never modify the data.
    | MemoryModeTWritable
    -- ^ HarfBuzz client made a copy of the data solely
    --     for HarfBuzz, so HarfBuzz may modify the data.
    | MemoryModeTReadonlyMayMakeWritable
    -- ^ See above
    | AnotherMemoryModeT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MemoryModeT where
    fromEnum MemoryModeTDuplicate = 0
    fromEnum MemoryModeTReadonly = 1
    fromEnum MemoryModeTWritable = 2
    fromEnum MemoryModeTReadonlyMayMakeWritable = 3
    fromEnum (AnotherMemoryModeT k) = k

    toEnum 0 = MemoryModeTDuplicate
    toEnum 1 = MemoryModeTReadonly
    toEnum 2 = MemoryModeTWritable
    toEnum 3 = MemoryModeTReadonlyMayMakeWritable
    toEnum k = AnotherMemoryModeT k

instance P.Ord MemoryModeT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MemoryModeT = '[]
instance O.HasParentTypes MemoryModeT

foreign import ccall "hb_gobject_memory_mode_get_type" c_hb_gobject_memory_mode_get_type :: 
    IO GType

instance B.Types.TypedObject MemoryModeT where
    glibType = c_hb_gobject_memory_mode_get_type

instance B.Types.BoxedEnum MemoryModeT

-- Enum direction_t
-- | The direction of a text segment or buffer.
-- 
-- A segment can also be tested for horizontal or vertical
-- orientation (irrespective of specific direction) with
-- @/HB_DIRECTION_IS_HORIZONTAL()/@ or @/HB_DIRECTION_IS_VERTICAL()/@.
data DirectionT = 
      DirectionTInvalid
    -- ^ Initial, unset direction.
    | DirectionTLtr
    -- ^ Text is set horizontally from left to right.
    | DirectionTRtl
    -- ^ Text is set horizontally from right to left.
    | DirectionTTtb
    -- ^ Text is set vertically from top to bottom.
    | DirectionTBtt
    -- ^ Text is set vertically from bottom to top.
    | AnotherDirectionT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DirectionT where
    fromEnum DirectionTInvalid = 0
    fromEnum DirectionTLtr = 4
    fromEnum DirectionTRtl = 5
    fromEnum DirectionTTtb = 6
    fromEnum DirectionTBtt = 7
    fromEnum (AnotherDirectionT k) = k

    toEnum 0 = DirectionTInvalid
    toEnum 4 = DirectionTLtr
    toEnum 5 = DirectionTRtl
    toEnum 6 = DirectionTTtb
    toEnum 7 = DirectionTBtt
    toEnum k = AnotherDirectionT k

instance P.Ord DirectionT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DirectionT = '[]
instance O.HasParentTypes DirectionT

foreign import ccall "hb_gobject_direction_get_type" c_hb_gobject_direction_get_type :: 
    IO GType

instance B.Types.TypedObject DirectionT where
    glibType = c_hb_gobject_direction_get_type

instance B.Types.BoxedEnum DirectionT

-- Enum buffer_serialize_format_t
-- | The buffer serialization and de-serialization format used in
-- 'GI.HarfBuzz.Functions.bufferSerializeGlyphs' and 'GI.HarfBuzz.Functions.bufferDeserializeGlyphs'.
-- 
-- /Since: 0.9.2/
data BufferSerializeFormatT = 
      BufferSerializeFormatTText
    -- ^ a human-readable, plain text format.
    | BufferSerializeFormatTJson
    -- ^ a machine-readable JSON format.
    | BufferSerializeFormatTInvalid
    -- ^ invalid format.
    | AnotherBufferSerializeFormatT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferSerializeFormatT where
    fromEnum BufferSerializeFormatTText = 1413830740
    fromEnum BufferSerializeFormatTJson = 1246973774
    fromEnum BufferSerializeFormatTInvalid = 0
    fromEnum (AnotherBufferSerializeFormatT k) = k

    toEnum 1413830740 = BufferSerializeFormatTText
    toEnum 1246973774 = BufferSerializeFormatTJson
    toEnum 0 = BufferSerializeFormatTInvalid
    toEnum k = AnotherBufferSerializeFormatT k

instance P.Ord BufferSerializeFormatT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferSerializeFormatT = '[]
instance O.HasParentTypes BufferSerializeFormatT

foreign import ccall "hb_gobject_buffer_serialize_format_get_type" c_hb_gobject_buffer_serialize_format_get_type :: 
    IO GType

instance B.Types.TypedObject BufferSerializeFormatT where
    glibType = c_hb_gobject_buffer_serialize_format_get_type

instance B.Types.BoxedEnum BufferSerializeFormatT

-- Enum buffer_content_type_t
-- | The type of t'GI.HarfBuzz.Structs.BufferT.BufferT' contents.
data BufferContentTypeT = 
      BufferContentTypeTInvalid
    -- ^ Initial value for new buffer.
    | BufferContentTypeTUnicode
    -- ^ The buffer contains input characters (before shaping).
    | BufferContentTypeTGlyphs
    -- ^ The buffer contains output glyphs (after shaping).
    | AnotherBufferContentTypeT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferContentTypeT where
    fromEnum BufferContentTypeTInvalid = 0
    fromEnum BufferContentTypeTUnicode = 1
    fromEnum BufferContentTypeTGlyphs = 2
    fromEnum (AnotherBufferContentTypeT k) = k

    toEnum 0 = BufferContentTypeTInvalid
    toEnum 1 = BufferContentTypeTUnicode
    toEnum 2 = BufferContentTypeTGlyphs
    toEnum k = AnotherBufferContentTypeT k

instance P.Ord BufferContentTypeT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferContentTypeT = '[]
instance O.HasParentTypes BufferContentTypeT

foreign import ccall "hb_gobject_buffer_content_type_get_type" c_hb_gobject_buffer_content_type_get_type :: 
    IO GType

instance B.Types.TypedObject BufferContentTypeT where
    glibType = c_hb_gobject_buffer_content_type_get_type

instance B.Types.BoxedEnum BufferContentTypeT

-- Enum buffer_cluster_level_t
-- | Data type for holding HarfBuzz\'s clustering behavior options. The cluster level
-- dictates one aspect of how HarfBuzz will treat non-base characters
-- during shaping.
-- 
-- In /@hBBUFFERCLUSTERLEVELMONOTONEGRAPHEMES@/, non-base
-- characters are merged into the cluster of the base character that precedes them.
-- There is also cluster merging every time the clusters will otherwise become non-monotone.
-- 
-- In /@hBBUFFERCLUSTERLEVELMONOTONECHARACTERS@/, non-base characters are initially
-- assigned their own cluster values, which are not merged into preceding base
-- clusters. This allows HarfBuzz to perform additional operations like reorder
-- sequences of adjacent marks. The output is still monotone, but the cluster
-- values are more granular.
-- 
-- In /@hBBUFFERCLUSTERLEVELCHARACTERS@/, non-base characters are assigned their
-- own cluster values, which are not merged into preceding base clusters. Moreover,
-- the cluster values are not merged into monotone order. This is the most granular
-- cluster level, and it is useful for clients that need to know the exact cluster
-- values of each character, but is harder to use for clients, since clusters
-- might appear in any order.
-- 
-- In /@hBBUFFERCLUSTERLEVELGRAPHEMES@/, non-base characters are merged into the
-- cluster of the base character that precedes them. This is similar to the Unicode
-- Grapheme Cluster algorithm, but it is not exactly the same. The output is
-- not forced to be monotone. This is useful for clients that want to use HarfBuzz
-- as a cheap implementation of the Unicode Grapheme Cluster algorithm.
-- 
-- /@hBBUFFERCLUSTERLEVELMONOTONEGRAPHEMES@/ is the default, because it maintains
-- backward compatibility with older versions of HarfBuzz. New client programs that
-- do not need to maintain such backward compatibility are recommended to use
-- /@hBBUFFERCLUSTERLEVELMONOTONECHARACTERS@/ instead of the default.
-- 
-- /Since: 0.9.42/
data BufferClusterLevelT = 
      BufferClusterLevelTMonotoneGraphemes
    -- ^ Return cluster values grouped by graphemes into
    --   monotone order.
    | BufferClusterLevelTMonotoneCharacters
    -- ^ Return cluster values grouped into monotone order.
    | BufferClusterLevelTCharacters
    -- ^ Don\'t group cluster values.
    | BufferClusterLevelTGraphemes
    -- ^ Only group clusters, but don\'t enforce monotone order.
    | BufferClusterLevelTDefault
    -- ^ Default cluster level,
    --   equal to /@hBBUFFERCLUSTERLEVELMONOTONEGRAPHEMES@/.
    | AnotherBufferClusterLevelT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BufferClusterLevelT where
    fromEnum BufferClusterLevelTMonotoneGraphemes = 0
    fromEnum BufferClusterLevelTMonotoneCharacters = 1
    fromEnum BufferClusterLevelTCharacters = 2
    fromEnum BufferClusterLevelTGraphemes = 3
    fromEnum BufferClusterLevelTDefault = 0
    fromEnum (AnotherBufferClusterLevelT k) = k

    toEnum 0 = BufferClusterLevelTMonotoneGraphemes
    toEnum 1 = BufferClusterLevelTMonotoneCharacters
    toEnum 2 = BufferClusterLevelTCharacters
    toEnum 3 = BufferClusterLevelTGraphemes
    toEnum k = AnotherBufferClusterLevelT k

instance P.Ord BufferClusterLevelT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BufferClusterLevelT = '[]
instance O.HasParentTypes BufferClusterLevelT

foreign import ccall "hb_gobject_buffer_cluster_level_get_type" c_hb_gobject_buffer_cluster_level_get_type :: 
    IO GType

instance B.Types.TypedObject BufferClusterLevelT where
    glibType = c_hb_gobject_buffer_cluster_level_get_type

instance B.Types.BoxedEnum BufferClusterLevelT

-- Enum aat_layout_feature_type_t
-- | The possible feature types defined for AAT shaping, from Apple <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html Font Feature Registry>.
-- 
-- /Since: 2.2.0/
data AatLayoutFeatureTypeT = 
      AatLayoutFeatureTypeTInvalid
    -- ^ Initial, unset feature type
    | AatLayoutFeatureTypeTAllTypographic
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type0 All Typographic Features>
    | AatLayoutFeatureTypeTLigatures
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type1 Ligatures>
    | AatLayoutFeatureTypeTCursiveConnection
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type2 Cursive Connection>
    | AatLayoutFeatureTypeTLetterCase
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type3 Letter Case>
    | AatLayoutFeatureTypeTVerticalSubstitution
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type4 Vertical Substitution>
    | AatLayoutFeatureTypeTLinguisticRearrangement
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type5 Linguistic Rearrangement>
    | AatLayoutFeatureTypeTNumberSpacing
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type6 Number Spacing>
    | AatLayoutFeatureTypeTSmartSwashType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type8 Smart Swash>
    | AatLayoutFeatureTypeTDiacriticsType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type9 Diacritics>
    | AatLayoutFeatureTypeTVerticalPosition
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type10 Vertical Position>
    | AatLayoutFeatureTypeTFractions
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type11 Fractions>
    | AatLayoutFeatureTypeTOverlappingCharactersType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type13 Overlapping Characters>
    | AatLayoutFeatureTypeTTypographicExtras
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type14 Typographic Extras>
    | AatLayoutFeatureTypeTMathematicalExtras
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type15 Mathematical Extras>
    | AatLayoutFeatureTypeTOrnamentSetsType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type16 Ornament Sets>
    | AatLayoutFeatureTypeTCharacterAlternatives
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type17 Character Alternatives>
    | AatLayoutFeatureTypeTDesignComplexityType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type18 Design Complexity>
    | AatLayoutFeatureTypeTStyleOptions
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type19 Style Options>
    | AatLayoutFeatureTypeTCharacterShape
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type20 Character Shape>
    | AatLayoutFeatureTypeTNumberCase
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type21 Number Case>
    | AatLayoutFeatureTypeTTextSpacing
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type22 Text Spacing>
    | AatLayoutFeatureTypeTTransliteration
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type23 Transliteration>
    | AatLayoutFeatureTypeTAnnotationType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type24 Annotation>
    | AatLayoutFeatureTypeTKanaSpacingType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type25 Kana Spacing>
    | AatLayoutFeatureTypeTIdeographicSpacingType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type26 Ideographic Spacing>
    | AatLayoutFeatureTypeTUnicodeDecompositionType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type27 Unicode Decomposition>
    | AatLayoutFeatureTypeTRubyKana
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type28 Ruby Kana>
    | AatLayoutFeatureTypeTCjkSymbolAlternativesType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type29 CJK Symbol Alternatives>
    | AatLayoutFeatureTypeTIdeographicAlternativesType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type30 Ideographic Alternatives>
    | AatLayoutFeatureTypeTCjkVerticalRomanPlacementType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type31 CJK Vertical Roman Placement>
    | AatLayoutFeatureTypeTItalicCjkRoman
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type32 Italic CJK Roman>
    | AatLayoutFeatureTypeTCaseSensitiveLayout
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type33 Case Sensitive Layout>
    | AatLayoutFeatureTypeTAlternateKana
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type34 Alternate Kana>
    | AatLayoutFeatureTypeTStylisticAlternatives
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type35 Stylistic Alternatives>
    | AatLayoutFeatureTypeTContextualAlternatives
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type36 Contextual Alternatives>
    | AatLayoutFeatureTypeTLowerCase
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type37 Lower Case>
    | AatLayoutFeatureTypeTUpperCase
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type38 Upper Case>
    | AatLayoutFeatureTypeTLanguageTagType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type39 Language Tag>
    | AatLayoutFeatureTypeTCjkRomanSpacingType
    -- ^ <https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type103 CJK Roman Spacing>
    | AnotherAatLayoutFeatureTypeT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AatLayoutFeatureTypeT where
    fromEnum AatLayoutFeatureTypeTInvalid = 65535
    fromEnum AatLayoutFeatureTypeTAllTypographic = 0
    fromEnum AatLayoutFeatureTypeTLigatures = 1
    fromEnum AatLayoutFeatureTypeTCursiveConnection = 2
    fromEnum AatLayoutFeatureTypeTLetterCase = 3
    fromEnum AatLayoutFeatureTypeTVerticalSubstitution = 4
    fromEnum AatLayoutFeatureTypeTLinguisticRearrangement = 5
    fromEnum AatLayoutFeatureTypeTNumberSpacing = 6
    fromEnum AatLayoutFeatureTypeTSmartSwashType = 8
    fromEnum AatLayoutFeatureTypeTDiacriticsType = 9
    fromEnum AatLayoutFeatureTypeTVerticalPosition = 10
    fromEnum AatLayoutFeatureTypeTFractions = 11
    fromEnum AatLayoutFeatureTypeTOverlappingCharactersType = 13
    fromEnum AatLayoutFeatureTypeTTypographicExtras = 14
    fromEnum AatLayoutFeatureTypeTMathematicalExtras = 15
    fromEnum AatLayoutFeatureTypeTOrnamentSetsType = 16
    fromEnum AatLayoutFeatureTypeTCharacterAlternatives = 17
    fromEnum AatLayoutFeatureTypeTDesignComplexityType = 18
    fromEnum AatLayoutFeatureTypeTStyleOptions = 19
    fromEnum AatLayoutFeatureTypeTCharacterShape = 20
    fromEnum AatLayoutFeatureTypeTNumberCase = 21
    fromEnum AatLayoutFeatureTypeTTextSpacing = 22
    fromEnum AatLayoutFeatureTypeTTransliteration = 23
    fromEnum AatLayoutFeatureTypeTAnnotationType = 24
    fromEnum AatLayoutFeatureTypeTKanaSpacingType = 25
    fromEnum AatLayoutFeatureTypeTIdeographicSpacingType = 26
    fromEnum AatLayoutFeatureTypeTUnicodeDecompositionType = 27
    fromEnum AatLayoutFeatureTypeTRubyKana = 28
    fromEnum AatLayoutFeatureTypeTCjkSymbolAlternativesType = 29
    fromEnum AatLayoutFeatureTypeTIdeographicAlternativesType = 30
    fromEnum AatLayoutFeatureTypeTCjkVerticalRomanPlacementType = 31
    fromEnum AatLayoutFeatureTypeTItalicCjkRoman = 32
    fromEnum AatLayoutFeatureTypeTCaseSensitiveLayout = 33
    fromEnum AatLayoutFeatureTypeTAlternateKana = 34
    fromEnum AatLayoutFeatureTypeTStylisticAlternatives = 35
    fromEnum AatLayoutFeatureTypeTContextualAlternatives = 36
    fromEnum AatLayoutFeatureTypeTLowerCase = 37
    fromEnum AatLayoutFeatureTypeTUpperCase = 38
    fromEnum AatLayoutFeatureTypeTLanguageTagType = 39
    fromEnum AatLayoutFeatureTypeTCjkRomanSpacingType = 103
    fromEnum (AnotherAatLayoutFeatureTypeT k) = k

    toEnum 65535 = AatLayoutFeatureTypeTInvalid
    toEnum 0 = AatLayoutFeatureTypeTAllTypographic
    toEnum 1 = AatLayoutFeatureTypeTLigatures
    toEnum 2 = AatLayoutFeatureTypeTCursiveConnection
    toEnum 3 = AatLayoutFeatureTypeTLetterCase
    toEnum 4 = AatLayoutFeatureTypeTVerticalSubstitution
    toEnum 5 = AatLayoutFeatureTypeTLinguisticRearrangement
    toEnum 6 = AatLayoutFeatureTypeTNumberSpacing
    toEnum 8 = AatLayoutFeatureTypeTSmartSwashType
    toEnum 9 = AatLayoutFeatureTypeTDiacriticsType
    toEnum 10 = AatLayoutFeatureTypeTVerticalPosition
    toEnum 11 = AatLayoutFeatureTypeTFractions
    toEnum 13 = AatLayoutFeatureTypeTOverlappingCharactersType
    toEnum 14 = AatLayoutFeatureTypeTTypographicExtras
    toEnum 15 = AatLayoutFeatureTypeTMathematicalExtras
    toEnum 16 = AatLayoutFeatureTypeTOrnamentSetsType
    toEnum 17 = AatLayoutFeatureTypeTCharacterAlternatives
    toEnum 18 = AatLayoutFeatureTypeTDesignComplexityType
    toEnum 19 = AatLayoutFeatureTypeTStyleOptions
    toEnum 20 = AatLayoutFeatureTypeTCharacterShape
    toEnum 21 = AatLayoutFeatureTypeTNumberCase
    toEnum 22 = AatLayoutFeatureTypeTTextSpacing
    toEnum 23 = AatLayoutFeatureTypeTTransliteration
    toEnum 24 = AatLayoutFeatureTypeTAnnotationType
    toEnum 25 = AatLayoutFeatureTypeTKanaSpacingType
    toEnum 26 = AatLayoutFeatureTypeTIdeographicSpacingType
    toEnum 27 = AatLayoutFeatureTypeTUnicodeDecompositionType
    toEnum 28 = AatLayoutFeatureTypeTRubyKana
    toEnum 29 = AatLayoutFeatureTypeTCjkSymbolAlternativesType
    toEnum 30 = AatLayoutFeatureTypeTIdeographicAlternativesType
    toEnum 31 = AatLayoutFeatureTypeTCjkVerticalRomanPlacementType
    toEnum 32 = AatLayoutFeatureTypeTItalicCjkRoman
    toEnum 33 = AatLayoutFeatureTypeTCaseSensitiveLayout
    toEnum 34 = AatLayoutFeatureTypeTAlternateKana
    toEnum 35 = AatLayoutFeatureTypeTStylisticAlternatives
    toEnum 36 = AatLayoutFeatureTypeTContextualAlternatives
    toEnum 37 = AatLayoutFeatureTypeTLowerCase
    toEnum 38 = AatLayoutFeatureTypeTUpperCase
    toEnum 39 = AatLayoutFeatureTypeTLanguageTagType
    toEnum 103 = AatLayoutFeatureTypeTCjkRomanSpacingType
    toEnum k = AnotherAatLayoutFeatureTypeT k

instance P.Ord AatLayoutFeatureTypeT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AatLayoutFeatureTypeT = '[]
instance O.HasParentTypes AatLayoutFeatureTypeT

foreign import ccall "hb_gobject_aat_layout_feature_type_get_type" c_hb_gobject_aat_layout_feature_type_get_type :: 
    IO GType

instance B.Types.TypedObject AatLayoutFeatureTypeT where
    glibType = c_hb_gobject_aat_layout_feature_type_get_type

instance B.Types.BoxedEnum AatLayoutFeatureTypeT

-- Enum aat_layout_feature_selector_t
-- | The selectors defined for specifying AAT feature settings.
-- 
-- /Since: 2.2.0/
data AatLayoutFeatureSelectorT = 
      AatLayoutFeatureSelectorTInvalid
    -- ^ Initial, unset feature selector
    | AatLayoutFeatureSelectorTAllTypeFeaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC/@
    | AatLayoutFeatureSelectorTAllTypeFeaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC/@
    | AatLayoutFeatureSelectorTRequiredLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTRequiredLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTCommonLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTCommonLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTRareLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTRareLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTLogosOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTLogosOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTRebusPicturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTRebusPicturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTDiphthongLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTDiphthongLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTSquaredLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTSquaredLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTSymbolLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTSymbolLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTContextualLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTContextualLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTHistoricalLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTHistoricalLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTUnconnected
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTPartiallyConnected
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTCursive
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES/@
    | AatLayoutFeatureSelectorTUpperAndLowerCase
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTAllCaps
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTAllLowerCase
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTSmallCaps
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTInitialCaps
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTInitialCapsAndSmallCaps
    -- ^ Deprecated
    | AatLayoutFeatureSelectorTSubstituteVerticalFormsOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION/@
    | AatLayoutFeatureSelectorTSubstituteVerticalFormsOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION/@
    | AatLayoutFeatureSelectorTLinguisticRearrangementOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT/@
    | AatLayoutFeatureSelectorTLinguisticRearrangementOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT/@
    | AatLayoutFeatureSelectorTMonospacedNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING/@
    | AatLayoutFeatureSelectorTProportionalNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING/@
    | AatLayoutFeatureSelectorTThirdWidthNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING/@
    | AatLayoutFeatureSelectorTQuarterWidthNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING/@
    | AatLayoutFeatureSelectorTWordInitialSwashesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTWordInitialSwashesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTWordFinalSwashesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTWordFinalSwashesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTLineInitialSwashesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTLineInitialSwashesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTLineFinalSwashesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTLineFinalSwashesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTNonFinalSwashesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTNonFinalSwashesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE/@
    | AatLayoutFeatureSelectorTShowDiacritics
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE/@
    | AatLayoutFeatureSelectorTHideDiacritics
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE/@
    | AatLayoutFeatureSelectorTDecomposeDiacritics
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE/@
    | AatLayoutFeatureSelectorTNormalPosition
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION/@
    | AatLayoutFeatureSelectorTSuperiors
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION/@
    | AatLayoutFeatureSelectorTInferiors
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION/@
    | AatLayoutFeatureSelectorTOrdinals
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION/@
    | AatLayoutFeatureSelectorTScientificInferiors
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION/@
    | AatLayoutFeatureSelectorTNoFractions
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS/@
    | AatLayoutFeatureSelectorTVerticalFractions
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS/@
    | AatLayoutFeatureSelectorTDiagonalFractions
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS/@
    | AatLayoutFeatureSelectorTPreventOverlapOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE/@
    | AatLayoutFeatureSelectorTPreventOverlapOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE/@
    | AatLayoutFeatureSelectorTHyphensToEmDashOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTHyphensToEmDashOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTHyphenToEnDashOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTHyphenToEnDashOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTSlashedZeroOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTSlashedZeroOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTFormInterrobangOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTFormInterrobangOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTSmartQuotesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTSmartQuotesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTPeriodsToEllipsisOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTPeriodsToEllipsisOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS/@
    | AatLayoutFeatureSelectorTHyphenToMinusOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTHyphenToMinusOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTAsteriskToMultiplyOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTAsteriskToMultiplyOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTSlashToDivideOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTSlashToDivideOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTInequalityLigaturesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTInequalityLigaturesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTExponentsOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTExponentsOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTMathematicalGreekOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTMathematicalGreekOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS/@
    | AatLayoutFeatureSelectorTNoOrnaments
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTDingbats
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTPiCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTFleurons
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTDecorativeBorders
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTInternationalSymbols
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTMathSymbols
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE/@
    | AatLayoutFeatureSelectorTNoAlternates
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTDesignLevel1
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE/@
    | AatLayoutFeatureSelectorTDesignLevel2
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE/@
    | AatLayoutFeatureSelectorTDesignLevel3
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE/@
    | AatLayoutFeatureSelectorTDesignLevel4
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE/@
    | AatLayoutFeatureSelectorTDesignLevel5
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE/@
    | AatLayoutFeatureSelectorTNoStyleOptions
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTDisplayText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTEngravedText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTIlluminatedCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTTitlingCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTTallCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS/@
    | AatLayoutFeatureSelectorTTraditionalCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTSimplifiedCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTJis1978Characters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTJis1983Characters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTJis1990Characters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalAltOne
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalAltTwo
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalAltThree
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalAltFour
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalAltFive
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTExpertCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTJis2004Characters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTHojoCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTNlccharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTTraditionalNamesCharacters
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE/@
    | AatLayoutFeatureSelectorTLowerCaseNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE/@
    | AatLayoutFeatureSelectorTUpperCaseNumbers
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE/@
    | AatLayoutFeatureSelectorTProportionalText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTMonospacedText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTHalfWidthText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTThirdWidthText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTQuarterWidthText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTAltProportionalText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTAltHalfWidthText
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING/@
    | AatLayoutFeatureSelectorTNoTransliteration
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTHanjaToHangul
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTHiraganaToKatakana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTKatakanaToHiragana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTKanaToRomanization
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTRomanizationToHiragana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTRomanizationToKatakana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTHanjaToHangulAltOne
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTHanjaToHangulAltTwo
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTHanjaToHangulAltThree
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION/@
    | AatLayoutFeatureSelectorTNoAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTBoxAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTRoundedBoxAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTCircleAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTInvertedCircleAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTParenthesisAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTPeriodAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTRomanNumeralAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTDiamondAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTInvertedBoxAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTInvertedRoundedBoxAnnotation
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE/@
    | AatLayoutFeatureSelectorTFullWidthKana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTProportionalKana
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTFullWidthIdeographs
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTProportionalIdeographs
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTHalfWidthIdeographs
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTCanonicalCompositionOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTCanonicalCompositionOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTCompatibilityCompositionOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTCompatibilityCompositionOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTTranscodingCompositionOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTTranscodingCompositionOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE/@
    | AatLayoutFeatureSelectorTNoRubyKana
    -- ^ Deprecated; use @/HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF/@ instead
    | AatLayoutFeatureSelectorTRubyKana
    -- ^ Deprecated; use @/HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON/@ instead
    | AatLayoutFeatureSelectorTRubyKanaOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA/@
    | AatLayoutFeatureSelectorTRubyKanaOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA/@
    | AatLayoutFeatureSelectorTNoCjkSymbolAlternatives
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkSymbolAltOne
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkSymbolAltTwo
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkSymbolAltThree
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkSymbolAltFour
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkSymbolAltFive
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTNoIdeographicAlternatives
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTIdeographicAltOne
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTIdeographicAltTwo
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTIdeographicAltThree
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTIdeographicAltFour
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTIdeographicAltFive
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE/@
    | AatLayoutFeatureSelectorTCjkVerticalRomanCentered
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE/@
    | AatLayoutFeatureSelectorTCjkVerticalRomanHbaseline
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE/@
    | AatLayoutFeatureSelectorTNoCjkItalicRoman
    -- ^ Deprecated; use @/HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF/@ instead
    | AatLayoutFeatureSelectorTCjkItalicRoman
    -- ^ Deprecated; use @/HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON/@ instead
    | AatLayoutFeatureSelectorTCjkItalicRomanOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN/@
    | AatLayoutFeatureSelectorTCjkItalicRomanOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN/@
    | AatLayoutFeatureSelectorTCaseSensitiveLayoutOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT/@
    | AatLayoutFeatureSelectorTCaseSensitiveLayoutOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT/@
    | AatLayoutFeatureSelectorTCaseSensitiveSpacingOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT/@
    | AatLayoutFeatureSelectorTCaseSensitiveSpacingOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT/@
    | AatLayoutFeatureSelectorTAlternateHorizKanaOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA/@
    | AatLayoutFeatureSelectorTAlternateHorizKanaOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA/@
    | AatLayoutFeatureSelectorTAlternateVertKanaOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA/@
    | AatLayoutFeatureSelectorTAlternateVertKanaOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA/@
    | AatLayoutFeatureSelectorTNoStylisticAlternates
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltOneOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltOneOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwoOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwoOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltThreeOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltThreeOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFourOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFourOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFiveOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFiveOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSixOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSixOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSevenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSevenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltEightOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltEightOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltNineOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltNineOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltElevenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltElevenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwelveOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwelveOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltThirteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltThirteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFourteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFourteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFifteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltFifteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSixteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSixteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSeventeenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltSeventeenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltEighteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltEighteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltNineteenOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltNineteenOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwentyOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTStylisticAltTwentyOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTContextualAlternatesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTContextualAlternatesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTSwashAlternatesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTSwashAlternatesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTContextualSwashAlternatesOn
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTContextualSwashAlternatesOff
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES/@
    | AatLayoutFeatureSelectorTDefaultLowerCase
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE/@
    | AatLayoutFeatureSelectorTLowerCaseSmallCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE/@
    | AatLayoutFeatureSelectorTLowerCasePetiteCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE/@
    | AatLayoutFeatureSelectorTDefaultUpperCase
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE/@
    | AatLayoutFeatureSelectorTUpperCaseSmallCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE/@
    | AatLayoutFeatureSelectorTUpperCasePetiteCaps
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE/@
    | AatLayoutFeatureSelectorTHalfWidthCjkRoman
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTProportionalCjkRoman
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTDefaultCjkRoman
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE/@
    | AatLayoutFeatureSelectorTFullWidthCjkRoman
    -- ^ for @/HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE/@
    | AnotherAatLayoutFeatureSelectorT Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AatLayoutFeatureSelectorT where
    fromEnum AatLayoutFeatureSelectorTInvalid = 65535
    fromEnum AatLayoutFeatureSelectorTAllTypeFeaturesOn = 0
    fromEnum AatLayoutFeatureSelectorTAllTypeFeaturesOff = 1
    fromEnum AatLayoutFeatureSelectorTRequiredLigaturesOn = 0
    fromEnum AatLayoutFeatureSelectorTRequiredLigaturesOff = 1
    fromEnum AatLayoutFeatureSelectorTCommonLigaturesOn = 2
    fromEnum AatLayoutFeatureSelectorTCommonLigaturesOff = 3
    fromEnum AatLayoutFeatureSelectorTRareLigaturesOn = 4
    fromEnum AatLayoutFeatureSelectorTRareLigaturesOff = 5
    fromEnum AatLayoutFeatureSelectorTLogosOn = 6
    fromEnum AatLayoutFeatureSelectorTLogosOff = 7
    fromEnum AatLayoutFeatureSelectorTRebusPicturesOn = 8
    fromEnum AatLayoutFeatureSelectorTRebusPicturesOff = 9
    fromEnum AatLayoutFeatureSelectorTDiphthongLigaturesOn = 10
    fromEnum AatLayoutFeatureSelectorTDiphthongLigaturesOff = 11
    fromEnum AatLayoutFeatureSelectorTSquaredLigaturesOn = 12
    fromEnum AatLayoutFeatureSelectorTSquaredLigaturesOff = 13
    fromEnum AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOn = 14
    fromEnum AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOff = 15
    fromEnum AatLayoutFeatureSelectorTSymbolLigaturesOn = 16
    fromEnum AatLayoutFeatureSelectorTSymbolLigaturesOff = 17
    fromEnum AatLayoutFeatureSelectorTContextualLigaturesOn = 18
    fromEnum AatLayoutFeatureSelectorTContextualLigaturesOff = 19
    fromEnum AatLayoutFeatureSelectorTHistoricalLigaturesOn = 20
    fromEnum AatLayoutFeatureSelectorTHistoricalLigaturesOff = 21
    fromEnum AatLayoutFeatureSelectorTUnconnected = 0
    fromEnum AatLayoutFeatureSelectorTPartiallyConnected = 1
    fromEnum AatLayoutFeatureSelectorTCursive = 2
    fromEnum AatLayoutFeatureSelectorTUpperAndLowerCase = 0
    fromEnum AatLayoutFeatureSelectorTAllCaps = 1
    fromEnum AatLayoutFeatureSelectorTAllLowerCase = 2
    fromEnum AatLayoutFeatureSelectorTSmallCaps = 3
    fromEnum AatLayoutFeatureSelectorTInitialCaps = 4
    fromEnum AatLayoutFeatureSelectorTInitialCapsAndSmallCaps = 5
    fromEnum AatLayoutFeatureSelectorTSubstituteVerticalFormsOn = 0
    fromEnum AatLayoutFeatureSelectorTSubstituteVerticalFormsOff = 1
    fromEnum AatLayoutFeatureSelectorTLinguisticRearrangementOn = 0
    fromEnum AatLayoutFeatureSelectorTLinguisticRearrangementOff = 1
    fromEnum AatLayoutFeatureSelectorTMonospacedNumbers = 0
    fromEnum AatLayoutFeatureSelectorTProportionalNumbers = 1
    fromEnum AatLayoutFeatureSelectorTThirdWidthNumbers = 2
    fromEnum AatLayoutFeatureSelectorTQuarterWidthNumbers = 3
    fromEnum AatLayoutFeatureSelectorTWordInitialSwashesOn = 0
    fromEnum AatLayoutFeatureSelectorTWordInitialSwashesOff = 1
    fromEnum AatLayoutFeatureSelectorTWordFinalSwashesOn = 2
    fromEnum AatLayoutFeatureSelectorTWordFinalSwashesOff = 3
    fromEnum AatLayoutFeatureSelectorTLineInitialSwashesOn = 4
    fromEnum AatLayoutFeatureSelectorTLineInitialSwashesOff = 5
    fromEnum AatLayoutFeatureSelectorTLineFinalSwashesOn = 6
    fromEnum AatLayoutFeatureSelectorTLineFinalSwashesOff = 7
    fromEnum AatLayoutFeatureSelectorTNonFinalSwashesOn = 8
    fromEnum AatLayoutFeatureSelectorTNonFinalSwashesOff = 9
    fromEnum AatLayoutFeatureSelectorTShowDiacritics = 0
    fromEnum AatLayoutFeatureSelectorTHideDiacritics = 1
    fromEnum AatLayoutFeatureSelectorTDecomposeDiacritics = 2
    fromEnum AatLayoutFeatureSelectorTNormalPosition = 0
    fromEnum AatLayoutFeatureSelectorTSuperiors = 1
    fromEnum AatLayoutFeatureSelectorTInferiors = 2
    fromEnum AatLayoutFeatureSelectorTOrdinals = 3
    fromEnum AatLayoutFeatureSelectorTScientificInferiors = 4
    fromEnum AatLayoutFeatureSelectorTNoFractions = 0
    fromEnum AatLayoutFeatureSelectorTVerticalFractions = 1
    fromEnum AatLayoutFeatureSelectorTDiagonalFractions = 2
    fromEnum AatLayoutFeatureSelectorTPreventOverlapOn = 0
    fromEnum AatLayoutFeatureSelectorTPreventOverlapOff = 1
    fromEnum AatLayoutFeatureSelectorTHyphensToEmDashOn = 0
    fromEnum AatLayoutFeatureSelectorTHyphensToEmDashOff = 1
    fromEnum AatLayoutFeatureSelectorTHyphenToEnDashOn = 2
    fromEnum AatLayoutFeatureSelectorTHyphenToEnDashOff = 3
    fromEnum AatLayoutFeatureSelectorTSlashedZeroOn = 4
    fromEnum AatLayoutFeatureSelectorTSlashedZeroOff = 5
    fromEnum AatLayoutFeatureSelectorTFormInterrobangOn = 6
    fromEnum AatLayoutFeatureSelectorTFormInterrobangOff = 7
    fromEnum AatLayoutFeatureSelectorTSmartQuotesOn = 8
    fromEnum AatLayoutFeatureSelectorTSmartQuotesOff = 9
    fromEnum AatLayoutFeatureSelectorTPeriodsToEllipsisOn = 10
    fromEnum AatLayoutFeatureSelectorTPeriodsToEllipsisOff = 11
    fromEnum AatLayoutFeatureSelectorTHyphenToMinusOn = 0
    fromEnum AatLayoutFeatureSelectorTHyphenToMinusOff = 1
    fromEnum AatLayoutFeatureSelectorTAsteriskToMultiplyOn = 2
    fromEnum AatLayoutFeatureSelectorTAsteriskToMultiplyOff = 3
    fromEnum AatLayoutFeatureSelectorTSlashToDivideOn = 4
    fromEnum AatLayoutFeatureSelectorTSlashToDivideOff = 5
    fromEnum AatLayoutFeatureSelectorTInequalityLigaturesOn = 6
    fromEnum AatLayoutFeatureSelectorTInequalityLigaturesOff = 7
    fromEnum AatLayoutFeatureSelectorTExponentsOn = 8
    fromEnum AatLayoutFeatureSelectorTExponentsOff = 9
    fromEnum AatLayoutFeatureSelectorTMathematicalGreekOn = 10
    fromEnum AatLayoutFeatureSelectorTMathematicalGreekOff = 11
    fromEnum AatLayoutFeatureSelectorTNoOrnaments = 0
    fromEnum AatLayoutFeatureSelectorTDingbats = 1
    fromEnum AatLayoutFeatureSelectorTPiCharacters = 2
    fromEnum AatLayoutFeatureSelectorTFleurons = 3
    fromEnum AatLayoutFeatureSelectorTDecorativeBorders = 4
    fromEnum AatLayoutFeatureSelectorTInternationalSymbols = 5
    fromEnum AatLayoutFeatureSelectorTMathSymbols = 6
    fromEnum AatLayoutFeatureSelectorTNoAlternates = 0
    fromEnum AatLayoutFeatureSelectorTDesignLevel1 = 0
    fromEnum AatLayoutFeatureSelectorTDesignLevel2 = 1
    fromEnum AatLayoutFeatureSelectorTDesignLevel3 = 2
    fromEnum AatLayoutFeatureSelectorTDesignLevel4 = 3
    fromEnum AatLayoutFeatureSelectorTDesignLevel5 = 4
    fromEnum AatLayoutFeatureSelectorTNoStyleOptions = 0
    fromEnum AatLayoutFeatureSelectorTDisplayText = 1
    fromEnum AatLayoutFeatureSelectorTEngravedText = 2
    fromEnum AatLayoutFeatureSelectorTIlluminatedCaps = 3
    fromEnum AatLayoutFeatureSelectorTTitlingCaps = 4
    fromEnum AatLayoutFeatureSelectorTTallCaps = 5
    fromEnum AatLayoutFeatureSelectorTTraditionalCharacters = 0
    fromEnum AatLayoutFeatureSelectorTSimplifiedCharacters = 1
    fromEnum AatLayoutFeatureSelectorTJis1978Characters = 2
    fromEnum AatLayoutFeatureSelectorTJis1983Characters = 3
    fromEnum AatLayoutFeatureSelectorTJis1990Characters = 4
    fromEnum AatLayoutFeatureSelectorTTraditionalAltOne = 5
    fromEnum AatLayoutFeatureSelectorTTraditionalAltTwo = 6
    fromEnum AatLayoutFeatureSelectorTTraditionalAltThree = 7
    fromEnum AatLayoutFeatureSelectorTTraditionalAltFour = 8
    fromEnum AatLayoutFeatureSelectorTTraditionalAltFive = 9
    fromEnum AatLayoutFeatureSelectorTExpertCharacters = 10
    fromEnum AatLayoutFeatureSelectorTJis2004Characters = 11
    fromEnum AatLayoutFeatureSelectorTHojoCharacters = 12
    fromEnum AatLayoutFeatureSelectorTNlccharacters = 13
    fromEnum AatLayoutFeatureSelectorTTraditionalNamesCharacters = 14
    fromEnum AatLayoutFeatureSelectorTLowerCaseNumbers = 0
    fromEnum AatLayoutFeatureSelectorTUpperCaseNumbers = 1
    fromEnum AatLayoutFeatureSelectorTProportionalText = 0
    fromEnum AatLayoutFeatureSelectorTMonospacedText = 1
    fromEnum AatLayoutFeatureSelectorTHalfWidthText = 2
    fromEnum AatLayoutFeatureSelectorTThirdWidthText = 3
    fromEnum AatLayoutFeatureSelectorTQuarterWidthText = 4
    fromEnum AatLayoutFeatureSelectorTAltProportionalText = 5
    fromEnum AatLayoutFeatureSelectorTAltHalfWidthText = 6
    fromEnum AatLayoutFeatureSelectorTNoTransliteration = 0
    fromEnum AatLayoutFeatureSelectorTHanjaToHangul = 1
    fromEnum AatLayoutFeatureSelectorTHiraganaToKatakana = 2
    fromEnum AatLayoutFeatureSelectorTKatakanaToHiragana = 3
    fromEnum AatLayoutFeatureSelectorTKanaToRomanization = 4
    fromEnum AatLayoutFeatureSelectorTRomanizationToHiragana = 5
    fromEnum AatLayoutFeatureSelectorTRomanizationToKatakana = 6
    fromEnum AatLayoutFeatureSelectorTHanjaToHangulAltOne = 7
    fromEnum AatLayoutFeatureSelectorTHanjaToHangulAltTwo = 8
    fromEnum AatLayoutFeatureSelectorTHanjaToHangulAltThree = 9
    fromEnum AatLayoutFeatureSelectorTNoAnnotation = 0
    fromEnum AatLayoutFeatureSelectorTBoxAnnotation = 1
    fromEnum AatLayoutFeatureSelectorTRoundedBoxAnnotation = 2
    fromEnum AatLayoutFeatureSelectorTCircleAnnotation = 3
    fromEnum AatLayoutFeatureSelectorTInvertedCircleAnnotation = 4
    fromEnum AatLayoutFeatureSelectorTParenthesisAnnotation = 5
    fromEnum AatLayoutFeatureSelectorTPeriodAnnotation = 6
    fromEnum AatLayoutFeatureSelectorTRomanNumeralAnnotation = 7
    fromEnum AatLayoutFeatureSelectorTDiamondAnnotation = 8
    fromEnum AatLayoutFeatureSelectorTInvertedBoxAnnotation = 9
    fromEnum AatLayoutFeatureSelectorTInvertedRoundedBoxAnnotation = 10
    fromEnum AatLayoutFeatureSelectorTFullWidthKana = 0
    fromEnum AatLayoutFeatureSelectorTProportionalKana = 1
    fromEnum AatLayoutFeatureSelectorTFullWidthIdeographs = 0
    fromEnum AatLayoutFeatureSelectorTProportionalIdeographs = 1
    fromEnum AatLayoutFeatureSelectorTHalfWidthIdeographs = 2
    fromEnum AatLayoutFeatureSelectorTCanonicalCompositionOn = 0
    fromEnum AatLayoutFeatureSelectorTCanonicalCompositionOff = 1
    fromEnum AatLayoutFeatureSelectorTCompatibilityCompositionOn = 2
    fromEnum AatLayoutFeatureSelectorTCompatibilityCompositionOff = 3
    fromEnum AatLayoutFeatureSelectorTTranscodingCompositionOn = 4
    fromEnum AatLayoutFeatureSelectorTTranscodingCompositionOff = 5
    fromEnum AatLayoutFeatureSelectorTNoRubyKana = 0
    fromEnum AatLayoutFeatureSelectorTRubyKana = 1
    fromEnum AatLayoutFeatureSelectorTRubyKanaOn = 2
    fromEnum AatLayoutFeatureSelectorTRubyKanaOff = 3
    fromEnum AatLayoutFeatureSelectorTNoCjkSymbolAlternatives = 0
    fromEnum AatLayoutFeatureSelectorTCjkSymbolAltOne = 1
    fromEnum AatLayoutFeatureSelectorTCjkSymbolAltTwo = 2
    fromEnum AatLayoutFeatureSelectorTCjkSymbolAltThree = 3
    fromEnum AatLayoutFeatureSelectorTCjkSymbolAltFour = 4
    fromEnum AatLayoutFeatureSelectorTCjkSymbolAltFive = 5
    fromEnum AatLayoutFeatureSelectorTNoIdeographicAlternatives = 0
    fromEnum AatLayoutFeatureSelectorTIdeographicAltOne = 1
    fromEnum AatLayoutFeatureSelectorTIdeographicAltTwo = 2
    fromEnum AatLayoutFeatureSelectorTIdeographicAltThree = 3
    fromEnum AatLayoutFeatureSelectorTIdeographicAltFour = 4
    fromEnum AatLayoutFeatureSelectorTIdeographicAltFive = 5
    fromEnum AatLayoutFeatureSelectorTCjkVerticalRomanCentered = 0
    fromEnum AatLayoutFeatureSelectorTCjkVerticalRomanHbaseline = 1
    fromEnum AatLayoutFeatureSelectorTNoCjkItalicRoman = 0
    fromEnum AatLayoutFeatureSelectorTCjkItalicRoman = 1
    fromEnum AatLayoutFeatureSelectorTCjkItalicRomanOn = 2
    fromEnum AatLayoutFeatureSelectorTCjkItalicRomanOff = 3
    fromEnum AatLayoutFeatureSelectorTCaseSensitiveLayoutOn = 0
    fromEnum AatLayoutFeatureSelectorTCaseSensitiveLayoutOff = 1
    fromEnum AatLayoutFeatureSelectorTCaseSensitiveSpacingOn = 2
    fromEnum AatLayoutFeatureSelectorTCaseSensitiveSpacingOff = 3
    fromEnum AatLayoutFeatureSelectorTAlternateHorizKanaOn = 0
    fromEnum AatLayoutFeatureSelectorTAlternateHorizKanaOff = 1
    fromEnum AatLayoutFeatureSelectorTAlternateVertKanaOn = 2
    fromEnum AatLayoutFeatureSelectorTAlternateVertKanaOff = 3
    fromEnum AatLayoutFeatureSelectorTNoStylisticAlternates = 0
    fromEnum AatLayoutFeatureSelectorTStylisticAltOneOn = 2
    fromEnum AatLayoutFeatureSelectorTStylisticAltOneOff = 3
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwoOn = 4
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwoOff = 5
    fromEnum AatLayoutFeatureSelectorTStylisticAltThreeOn = 6
    fromEnum AatLayoutFeatureSelectorTStylisticAltThreeOff = 7
    fromEnum AatLayoutFeatureSelectorTStylisticAltFourOn = 8
    fromEnum AatLayoutFeatureSelectorTStylisticAltFourOff = 9
    fromEnum AatLayoutFeatureSelectorTStylisticAltFiveOn = 10
    fromEnum AatLayoutFeatureSelectorTStylisticAltFiveOff = 11
    fromEnum AatLayoutFeatureSelectorTStylisticAltSixOn = 12
    fromEnum AatLayoutFeatureSelectorTStylisticAltSixOff = 13
    fromEnum AatLayoutFeatureSelectorTStylisticAltSevenOn = 14
    fromEnum AatLayoutFeatureSelectorTStylisticAltSevenOff = 15
    fromEnum AatLayoutFeatureSelectorTStylisticAltEightOn = 16
    fromEnum AatLayoutFeatureSelectorTStylisticAltEightOff = 17
    fromEnum AatLayoutFeatureSelectorTStylisticAltNineOn = 18
    fromEnum AatLayoutFeatureSelectorTStylisticAltNineOff = 19
    fromEnum AatLayoutFeatureSelectorTStylisticAltTenOn = 20
    fromEnum AatLayoutFeatureSelectorTStylisticAltTenOff = 21
    fromEnum AatLayoutFeatureSelectorTStylisticAltElevenOn = 22
    fromEnum AatLayoutFeatureSelectorTStylisticAltElevenOff = 23
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwelveOn = 24
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwelveOff = 25
    fromEnum AatLayoutFeatureSelectorTStylisticAltThirteenOn = 26
    fromEnum AatLayoutFeatureSelectorTStylisticAltThirteenOff = 27
    fromEnum AatLayoutFeatureSelectorTStylisticAltFourteenOn = 28
    fromEnum AatLayoutFeatureSelectorTStylisticAltFourteenOff = 29
    fromEnum AatLayoutFeatureSelectorTStylisticAltFifteenOn = 30
    fromEnum AatLayoutFeatureSelectorTStylisticAltFifteenOff = 31
    fromEnum AatLayoutFeatureSelectorTStylisticAltSixteenOn = 32
    fromEnum AatLayoutFeatureSelectorTStylisticAltSixteenOff = 33
    fromEnum AatLayoutFeatureSelectorTStylisticAltSeventeenOn = 34
    fromEnum AatLayoutFeatureSelectorTStylisticAltSeventeenOff = 35
    fromEnum AatLayoutFeatureSelectorTStylisticAltEighteenOn = 36
    fromEnum AatLayoutFeatureSelectorTStylisticAltEighteenOff = 37
    fromEnum AatLayoutFeatureSelectorTStylisticAltNineteenOn = 38
    fromEnum AatLayoutFeatureSelectorTStylisticAltNineteenOff = 39
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwentyOn = 40
    fromEnum AatLayoutFeatureSelectorTStylisticAltTwentyOff = 41
    fromEnum AatLayoutFeatureSelectorTContextualAlternatesOn = 0
    fromEnum AatLayoutFeatureSelectorTContextualAlternatesOff = 1
    fromEnum AatLayoutFeatureSelectorTSwashAlternatesOn = 2
    fromEnum AatLayoutFeatureSelectorTSwashAlternatesOff = 3
    fromEnum AatLayoutFeatureSelectorTContextualSwashAlternatesOn = 4
    fromEnum AatLayoutFeatureSelectorTContextualSwashAlternatesOff = 5
    fromEnum AatLayoutFeatureSelectorTDefaultLowerCase = 0
    fromEnum AatLayoutFeatureSelectorTLowerCaseSmallCaps = 1
    fromEnum AatLayoutFeatureSelectorTLowerCasePetiteCaps = 2
    fromEnum AatLayoutFeatureSelectorTDefaultUpperCase = 0
    fromEnum AatLayoutFeatureSelectorTUpperCaseSmallCaps = 1
    fromEnum AatLayoutFeatureSelectorTUpperCasePetiteCaps = 2
    fromEnum AatLayoutFeatureSelectorTHalfWidthCjkRoman = 0
    fromEnum AatLayoutFeatureSelectorTProportionalCjkRoman = 1
    fromEnum AatLayoutFeatureSelectorTDefaultCjkRoman = 2
    fromEnum AatLayoutFeatureSelectorTFullWidthCjkRoman = 3
    fromEnum (AnotherAatLayoutFeatureSelectorT k) = k

    toEnum 65535 = AatLayoutFeatureSelectorTInvalid
    toEnum 0 = AatLayoutFeatureSelectorTAllTypeFeaturesOn
    toEnum 1 = AatLayoutFeatureSelectorTAllTypeFeaturesOff
    toEnum 2 = AatLayoutFeatureSelectorTCommonLigaturesOn
    toEnum 3 = AatLayoutFeatureSelectorTCommonLigaturesOff
    toEnum 4 = AatLayoutFeatureSelectorTRareLigaturesOn
    toEnum 5 = AatLayoutFeatureSelectorTRareLigaturesOff
    toEnum 6 = AatLayoutFeatureSelectorTLogosOn
    toEnum 7 = AatLayoutFeatureSelectorTLogosOff
    toEnum 8 = AatLayoutFeatureSelectorTRebusPicturesOn
    toEnum 9 = AatLayoutFeatureSelectorTRebusPicturesOff
    toEnum 10 = AatLayoutFeatureSelectorTDiphthongLigaturesOn
    toEnum 11 = AatLayoutFeatureSelectorTDiphthongLigaturesOff
    toEnum 12 = AatLayoutFeatureSelectorTSquaredLigaturesOn
    toEnum 13 = AatLayoutFeatureSelectorTSquaredLigaturesOff
    toEnum 14 = AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOn
    toEnum 15 = AatLayoutFeatureSelectorTAbbrevSquaredLigaturesOff
    toEnum 16 = AatLayoutFeatureSelectorTSymbolLigaturesOn
    toEnum 17 = AatLayoutFeatureSelectorTSymbolLigaturesOff
    toEnum 18 = AatLayoutFeatureSelectorTContextualLigaturesOn
    toEnum 19 = AatLayoutFeatureSelectorTContextualLigaturesOff
    toEnum 20 = AatLayoutFeatureSelectorTHistoricalLigaturesOn
    toEnum 21 = AatLayoutFeatureSelectorTHistoricalLigaturesOff
    toEnum 22 = AatLayoutFeatureSelectorTStylisticAltElevenOn
    toEnum 23 = AatLayoutFeatureSelectorTStylisticAltElevenOff
    toEnum 24 = AatLayoutFeatureSelectorTStylisticAltTwelveOn
    toEnum 25 = AatLayoutFeatureSelectorTStylisticAltTwelveOff
    toEnum 26 = AatLayoutFeatureSelectorTStylisticAltThirteenOn
    toEnum 27 = AatLayoutFeatureSelectorTStylisticAltThirteenOff
    toEnum 28 = AatLayoutFeatureSelectorTStylisticAltFourteenOn
    toEnum 29 = AatLayoutFeatureSelectorTStylisticAltFourteenOff
    toEnum 30 = AatLayoutFeatureSelectorTStylisticAltFifteenOn
    toEnum 31 = AatLayoutFeatureSelectorTStylisticAltFifteenOff
    toEnum 32 = AatLayoutFeatureSelectorTStylisticAltSixteenOn
    toEnum 33 = AatLayoutFeatureSelectorTStylisticAltSixteenOff
    toEnum 34 = AatLayoutFeatureSelectorTStylisticAltSeventeenOn
    toEnum 35 = AatLayoutFeatureSelectorTStylisticAltSeventeenOff
    toEnum 36 = AatLayoutFeatureSelectorTStylisticAltEighteenOn
    toEnum 37 = AatLayoutFeatureSelectorTStylisticAltEighteenOff
    toEnum 38 = AatLayoutFeatureSelectorTStylisticAltNineteenOn
    toEnum 39 = AatLayoutFeatureSelectorTStylisticAltNineteenOff
    toEnum 40 = AatLayoutFeatureSelectorTStylisticAltTwentyOn
    toEnum 41 = AatLayoutFeatureSelectorTStylisticAltTwentyOff
    toEnum k = AnotherAatLayoutFeatureSelectorT k

instance P.Ord AatLayoutFeatureSelectorT where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AatLayoutFeatureSelectorT = '[]
instance O.HasParentTypes AatLayoutFeatureSelectorT

foreign import ccall "hb_gobject_aat_layout_feature_selector_get_type" c_hb_gobject_aat_layout_feature_selector_get_type :: 
    IO GType

instance B.Types.TypedObject AatLayoutFeatureSelectorT where
    glibType = c_hb_gobject_aat_layout_feature_selector_get_type

instance B.Types.BoxedEnum AatLayoutFeatureSelectorT


